/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.sdk.IContributedSDK;
import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.SDKAvailabilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.SDKMissedMarkerHandler;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.SDKNotAvailableException;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.ISDKFilesChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.ISDKFilesCheckerResult;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.SDKFilesChecker;
import com.freescale.s32ds.cross.sdk.internal.ProjectUpdater;
import com.freescale.s32ds.cross.sdk.processors.CopyProcessor;
import com.freescale.s32ds.cross.sdk.processors.ISourcePathProcessor;
import com.freescale.s32ds.cross.sdk.processors.LinkProcessor;
import com.freescale.s32ds.cross.sdk.processors.RemoveProcessor;
import com.freescale.s32ds.cross.sdk.ui.SDKManagementWidget;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKConflictedFilesDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class SDKAttach {
    private static final Map<String, AttachData[]> cache = new LinkedHashMap<String, AttachData[]>();

    public static List<ISDK> getAttached(IProject project) {
        return SDKAttach.getAttached(project, false);
    }

    public static List<ISDK> getAttachedVerbose(IProject project) {
        return SDKAttach.getAttached(project, true);
    }

    public static List<ISDK> getAttached(IProject project, boolean verbose) {
        AttachData[] attachDatas;
        if (project == null) {
            return new ArrayList<ISDK>();
        }
        ArrayList<ISDK> result = new ArrayList<ISDK>();
        LinkedHashMap<String, String> notAvailableSDKs = new LinkedHashMap<String, String>();
        SDKAvailabilityChecker availabilityChecker = new SDKAvailabilityChecker();
        AttachData[] attachDataArray = attachDatas = SDKAttach.get(project);
        int n = attachDatas.length;
        int n2 = 0;
        while (n2 < n) {
            AttachData ad = attachDataArray[n2];
            ISDK sdk = SDKUtils.getSDKbyID(ad.sdkId);
            if (sdk != null) {
                result.add(sdk);
                try {
                    availabilityChecker.checkAvailability(ad.sdkId);
                }
                catch (SDKNotAvailableException sdknae) {
                    notAvailableSDKs.put(ad.sdkId, sdknae.getMessage());
                }
            } else {
                notAvailableSDKs.put(ad.sdkId, String.format(Messages.SDKAttach_Not_found, ad.sdkId, project.getName()));
            }
            ++n2;
        }
        if (verbose) {
            SDKMissedMarkerHandler.delete(project);
            if (!notAvailableSDKs.isEmpty()) {
                notAvailableSDKs.entrySet().forEach(e -> {
                    String sdkId = (String)e.getKey();
                    SDKMissedMarkerHandler.create(sdkId, project, (String)e.getValue());
                    SDKSupportPlugin.log(String.format(Messages.SDKAttach_Not_found, sdkId, project.getName()));
                });
            }
        }
        return result;
    }

    public static List<ISDK> getAttached(IProject project, ISDK.TYPE type) {
        return SDKAttach.getAttached(project).stream().filter(sdk -> type == sdk.getType()).collect(Collectors.toList());
    }

    public static List<IConfiguration> getAttached(IProject project, ISDK sdk) {
        AttachData[] attData;
        ArrayList<IConfiguration> res = new ArrayList<IConfiguration>();
        if (project == null || sdk == null) {
            return res;
        }
        AttachData[] attachDataArray = attData = SDKAttach.get(project);
        int n = attData.length;
        int n2 = 0;
        while (n2 < n) {
            AttachData data = attachDataArray[n2];
            if (data.sdkId.equals(sdk.getId())) {
                IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)project);
                IConfiguration[] configurations = bi.getManagedProject().getConfigurations();
                if (data.cfgs.length == 0) {
                    IConfiguration[] iConfigurationArray = configurations;
                    int n3 = configurations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfiguration configuration = iConfigurationArray[n4];
                        res.add(configuration);
                        ++n4;
                    }
                } else {
                    String[] stringArray = data.cfgs;
                    int n5 = stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String s = stringArray[n6];
                        int c = 0;
                        while (c < configurations.length) {
                            IConfiguration conf = configurations[c];
                            if (s.equals(conf.getName())) {
                                res.add(conf);
                            }
                            ++c;
                        }
                        ++n6;
                    }
                }
                break;
            }
            ++n2;
        }
        return res;
    }

    public static String[] getAttached(String prj, String sdkId) {
        if (prj != null) {
            AttachData[] data = cache.get(prj);
            if (data == null) {
                for (IProject project : SDKUtils.listProjects()) {
                    if (prj.equals(project.getName())) {
                        SDKAttach.getAttached(project, false);
                    }
                    data = cache.get(prj);
                }
            }
            if (prj != null && sdkId != null) {
                AttachData[] attachDataArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    AttachData ad = attachDataArray[n2];
                    if (sdkId.equals(ad.sdkId)) {
                        return ad.cfgs;
                    }
                    ++n2;
                }
            } else if (prj != null && sdkId == null) {
                String[] res = new String[data.length];
                int i = 0;
                while (i < data.length) {
                    res[i] = data[i].sdkId;
                    ++i;
                }
                return res;
            }
        } else if (prj == null && sdkId != null) {
            ArrayList<String> res = new ArrayList<String>();
            block3: for (String key : cache.keySet()) {
                AttachData[] attachDataArray = cache.get(key);
                int n = attachDataArray.length;
                int n3 = 0;
                while (n3 < n) {
                    AttachData data = attachDataArray[n3];
                    if (sdkId.equals(data.sdkId)) {
                        res.add(key);
                        continue block3;
                    }
                    ++n3;
                }
            }
            return res.toArray(new String[0]);
        }
        return null;
    }

    public static boolean isAttached(String prj, String cfg, String sdkId) {
        if (prj == null || cfg == null || sdkId == null) {
            return false;
        }
        AttachData[] data = cache.get(prj);
        if (data != null) {
            AttachData[] attachDataArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                AttachData ad = attachDataArray[n2];
                if (sdkId.equals(ad.sdkId)) {
                    if (ad.cfgs.length == 0) {
                        return true;
                    }
                    String[] stringArray = ad.cfgs;
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray[n4];
                        if (s.equals(cfg)) {
                            return true;
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isAttached(ISDK sdk, IProject project) {
        return !SDKAttach.hasAttached(project) ? false : !SDKAttach.getAttached(project, sdk).isEmpty();
    }

    public static List<IProject> getAttached(ISDK sdk) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        if (sdk == null) {
            return result;
        }
        String sdkId = sdk.getId();
        for (IProject project : SDKUtils.listProjects()) {
            for (ISDK sd : SDKAttach.getAttached(project, false)) {
                if (!sdkId.equals(sd.getId())) continue;
                result.add(project);
            }
        }
        return result;
    }

    public static void restoreSDK(ISDK sdk, IProject project) {
        List<IConfiguration> configurations = SDKAttach.getAttached(project, sdk);
        configurations.forEach(conf -> {
            SDKAttach.addOptions(sdk, conf);
            SDKAttach.addResources(sdk, conf);
            SDKUtils.addSources(project, sdk, conf);
        });
    }

    public static boolean attachToProjectConfigurations(ISDK sdk, Iterable<IConfiguration> configs, int context) {
        IStatus status;
        if (!SDKAttach.validateAttachParameters(sdk, configs)) {
            return false;
        }
        if (context == 0 && sdk instanceof IContributedSDK && !SDKAttach.handleAttachStatus(status = ((IContributedSDK)sdk).checkStateChangePreconditions(5, null), null)) {
            return false;
        }
        return SDKAttach.attachTo(sdk, configs);
    }

    private static boolean validateAttachParameters(ISDK sdk, Iterable<IConfiguration> configs) {
        if (sdk == null || configs == null) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.SDKAttach_illegal_attach_params, null)));
            return false;
        }
        if (!configs.iterator().hasNext()) {
            SDKSupportPlugin.log((IStatus)new Status(2, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.SDKAttach_no_configs_to_attach, null)));
            return false;
        }
        return true;
    }

    private static boolean attachTo(ISDK sdk, Iterable<IConfiguration> cfgs) {
        OverrideData overrideData;
        if (!SDKAttach.validateAttachParameters(sdk, cfgs)) {
            return false;
        }
        IProject project = cfgs.iterator().next().getOwner().getProject();
        if (!SDKAttach.checkConflictedFiles(sdk, project, overrideData = new OverrideData())) {
            return false;
        }
        List<ISDK> sdks = SDKAttach.getAttached(project, false);
        if (!sdks.contains(sdk) && !SDKUtils.exists(sdk.getId())) {
            SDKUtils.add(sdk, true);
        }
        if (sdk instanceof IContributedSDK && cfgs != null && cfgs.iterator().hasNext()) {
            ((IContributedSDK)sdk).stateChange(5, false, cfgs.iterator().next(), project.getName());
        }
        for (IConfiguration cfg : cfgs) {
            if (SDKAttach.isAttached(project.getName(), cfg.getName(), sdk.getId())) continue;
            if (sdk instanceof IContributedSDK) {
                ((IContributedSDK)sdk).stateChange(2, false, cfg, project.getName());
            }
            SDKAttach.attach(sdk, cfg);
            SDKAttach.addOptions(sdk, cfg);
            if (SDKAttach.addResources(sdk, cfg, overrideData)) {
                SDKUtils.addSources(project, sdk, cfg);
            }
            overrideData.setBackupFiles(false);
            if (!(sdk instanceof IContributedSDK)) continue;
            ((IContributedSDK)sdk).stateChange(2, true, cfg, project.getName());
        }
        if (sdk instanceof IContributedSDK && cfgs != null && cfgs.iterator().hasNext()) {
            ((IContributedSDK)sdk).stateChange(5, true, cfgs.iterator().next(), project.getName());
            IStatus status = ((IContributedSDK)sdk).checkStateChangePostconditions(5, null);
            SDKAttach.handleAttachStatus(status, null);
        }
        SDKAttach.reindexProject(project);
        SDKUtils.notifySDKObserver();
        return true;
    }

    private static boolean handleAttachStatus(IStatus status, Object source) {
        IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(status);
        if (statusHandler != null) {
            try {
                Object result = statusHandler.handleStatus(status, source);
                if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                    return false;
                }
            }
            catch (CoreException ce) {
                SDKSupportPlugin.error(ce);
            }
        }
        return true;
    }

    public static boolean detachFrom(ISDK sdk, Iterable<IConfiguration> cfgs) {
        if (sdk == null || cfgs == null) {
            throw new IllegalArgumentException(String.format("Bad parameter(s): SDK=%s CFGS=%s", sdk, cfgs));
        }
        IConfiguration cfg0 = null;
        Iterator<IConfiguration> it = cfgs.iterator();
        if (!it.hasNext()) {
            return true;
        }
        cfg0 = it.next();
        IProject prj = cfg0.getOwner().getProject();
        List<ISDK> attached = SDKAttach.getAttached(prj, false);
        List<IConfiguration> cfs = SDKAttach.getAttached(prj, sdk);
        int cnt = 0;
        for (IConfiguration cfg : cfgs) {
            if (!attached.contains(sdk)) continue;
            if (sdk instanceof IContributedSDK) {
                ((IContributedSDK)sdk).stateChange(3, false, cfg, prj.getName());
            }
            SDKAttach.detach(sdk, cfg);
            SDKAttach.removeResources(sdk, cfg);
            SDKAttach.removeOptions(sdk, cfg);
            SDKUtils.removeSources(prj, sdk, cfg);
            if (sdk instanceof IContributedSDK) {
                ((IContributedSDK)sdk).stateChange(3, true, cfg, prj.getName());
            }
            cfs.remove(cfg);
            ++cnt;
        }
        if (cnt > 0 && (cfs == null || cfs.size() == 0)) {
            SDKAttach.removeSDKFolderFromProject(sdk, prj);
            attached.remove(sdk);
        }
        SDKUtils.notifySDKObserver();
        return cnt > 0;
    }

    public static void detachFrom(ISDK sdk, IProject project) {
        List<IConfiguration> configurations = SDKAttach.getAttached(project, sdk);
        SDKAttach.detachFrom(sdk, configurations);
    }

    public static void addOptions(ISDK sdk, IConfiguration cfg) {
        ProjectUpdater.updateOptions(cfg, sdk, false);
    }

    public static void removeOptions(ISDK sdk, IConfiguration cfg) {
        ProjectUpdater.updateOptions(cfg, sdk, true);
    }

    public static boolean addResources(ISDK sdk, IConfiguration cfg) {
        return SDKAttach.addResources(sdk, cfg, null);
    }

    public static boolean addResources(ISDK sdk, IConfiguration cfg, OverrideData overrideData) {
        boolean needCopy;
        String id = cfg.getToolChain().getBaseId();
        boolean isBackupFiles = overrideData != null ? overrideData.isBackupFiles() : false;
        LinkProcessor linkProcessor = new LinkProcessor(sdk, isBackupFiles);
        CopyProcessor copyProcessor = new CopyProcessor(sdk, isBackupFiles);
        LinkedHashSet<IExtendedPath> toCopy = new LinkedHashSet<IExtendedPath>();
        LinkedHashSet<IExtendedPath> toMove = new LinkedHashSet<IExtendedPath>();
        LinkedHashSet<IExtendedPath> toLink = new LinkedHashSet<IExtendedPath>();
        Set toOverride = overrideData != null ? overrideData.getFilesToOverride() : null;
        IExtendedPath[][] data = sdk.getResources(id);
        int i = 0;
        while (i < data.length) {
            IExtendedPath[] iExtendedPathArray = data[i];
            int n = iExtendedPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtendedPath p = iExtendedPathArray[n2];
                p.setOverride(toOverride != null && toOverride.contains(p));
                if (p.isCopy()) {
                    if (p.copyPath() == null) {
                        toCopy.add(p);
                    } else {
                        toMove.add(p);
                    }
                } else if (i != 1 && i != 2) {
                    toLink.add(p);
                }
                ++n2;
            }
            ++i;
        }
        IPath sdkPath = SDKSupportPlugin.getEclipsePath(sdk);
        IFolder sdkFolder = cfg.getOwner().getProject().getFolder(sdk.getName());
        for (IExtendedPath source : toMove) {
            SDKAttach.processSourcePath(source, sdkPath, sdkFolder, copyProcessor);
        }
        boolean bl = needCopy = !toCopy.isEmpty();
        if (needCopy || !toLink.isEmpty()) {
            try {
                if (sdkFolder.exists() && sdkFolder.isVirtual() && needCopy) {
                    sdkFolder.delete(true, null);
                }
                if (!sdkFolder.exists()) {
                    sdkFolder.create(needCopy ? 1 : 8192, true, null);
                }
            }
            catch (CoreException e) {
                SDKSupportPlugin.error(e);
            }
            for (IExtendedPath source : toCopy) {
                SDKAttach.processSourcePath(source, sdkPath, sdkFolder, copyProcessor);
            }
            for (IExtendedPath source : toLink) {
                SDKAttach.processSourcePath(source, sdkPath, sdkFolder, linkProcessor);
            }
            return true;
        }
        return false;
    }

    public static void removeResources(ISDK sdk, IConfiguration cfg) {
        IFolder link = ((IProject)cfg.getOwner()).getFolder(sdk.getName());
        if (!link.isVirtual()) {
            String id = cfg.getToolChain().getBaseId();
            IPath root = SDKSupportPlugin.getEclipsePath(sdk);
            RemoveProcessor removeProcessor = new RemoveProcessor();
            IExtendedPath[][] iExtendedPathArray = sdk.getResources(id);
            int n = iExtendedPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtendedPath[] res;
                IExtendedPath[] iExtendedPathArray2 = res = iExtendedPathArray[n2];
                int n3 = res.length;
                int n4 = 0;
                while (n4 < n3) {
                    IExtendedPath p = iExtendedPathArray2[n4];
                    SDKAttach.processSourcePath(p, root, link, removeProcessor);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public static void processSourcePath(IExtendedPath path, IPath root, IFolder parent, ISourcePathProcessor processor) {
        String copyToProjectPath = path.copyPath();
        if (copyToProjectPath != null) {
            String name = path.lastSegment();
            String rename = path.renameTo();
            if (rename != null && !rename.isEmpty()) {
                name = new Path(rename).lastSegment();
            }
            IProject project = parent.getProject();
            if (copyToProjectPath.isEmpty() || copyToProjectPath.equals(".") || copyToProjectPath.equals("/")) {
                IFile link = project.getFile(name);
                processor.file(link, path);
            } else {
                IPath copyPath = Path.fromOSString((String)copyToProjectPath);
                IFolder f = project.getFolder(copyPath.segment(0));
                processor.folder(f);
                int i = 1;
                while (i < copyPath.segmentCount()) {
                    f = f.getFolder(copyPath.segment(i));
                    processor.folder(f);
                    ++i;
                }
                IFile link = f.getFile(name);
                processor.file(link, path);
            }
        } else {
            IPath srcRelPath = path.makeRelativeTo(root);
            if (srcRelPath != null && srcRelPath.segmentCount() > 0) {
                IFolder f = parent;
                int i = 0;
                while (i < srcRelPath.segmentCount() - 1) {
                    f = f.getFolder(srcRelPath.segment(i));
                    processor.folder(f);
                    ++i;
                }
                if (path.toFile().isDirectory()) {
                    processor.folder(f.getFolder(srcRelPath.lastSegment()));
                } else {
                    processor.file(f.getFile(srcRelPath.lastSegment()), path);
                }
            }
        }
    }

    public static void changeAttachment(ISDK sdk, boolean[] newAttachFlags, boolean[] oldAttachFlags, IProject project, SDKManagementWidget widget) {
        Integer configIndex;
        if (newAttachFlags == null) {
            return;
        }
        ArrayList<IConfiguration> toAdd = new ArrayList<IConfiguration>();
        ArrayList<IConfiguration> toDel = new ArrayList<IConfiguration>();
        int selectedConfigsCount = newAttachFlags.length;
        if (oldAttachFlags == null) {
            oldAttachFlags = new boolean[selectedConfigsCount];
        }
        HashMap<IConfiguration, Integer> confsAtachInfo = new HashMap<IConfiguration, Integer>();
        IConfiguration[] cfgs = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        int i = 0;
        while (i < selectedConfigsCount) {
            IConfiguration configuration = cfgs[i];
            confsAtachInfo.put(configuration, i);
            if (newAttachFlags[i] && !oldAttachFlags[i]) {
                toAdd.add(configuration);
            } else if (!newAttachFlags[i] && oldAttachFlags[i]) {
                toDel.add(configuration);
            }
            ++i;
        }
        if (!toAdd.isEmpty() && !SDKAttach.attachToProjectConfigurations(sdk, toAdd, 0)) {
            Boolean[] undoAttachFlags = new Boolean[newAttachFlags.length];
            for (Map.Entry e : confsAtachInfo.entrySet()) {
                configIndex = (Integer)e.getValue();
                undoAttachFlags[configIndex.intValue()] = newAttachFlags[configIndex];
                if (!toAdd.contains(e.getKey()) || !newAttachFlags[configIndex]) continue;
                undoAttachFlags[configIndex.intValue()] = Boolean.FALSE;
            }
            widget.restoreSDKAttachData(sdk.getId(), undoAttachFlags);
        }
        if (!toDel.isEmpty() && !SDKAttach.detachFrom(sdk, toDel)) {
            Boolean[] undoAttachFlags = new Boolean[newAttachFlags.length];
            for (Map.Entry e : confsAtachInfo.entrySet()) {
                configIndex = (Integer)e.getValue();
                undoAttachFlags[configIndex.intValue()] = newAttachFlags[configIndex];
                if (!toDel.contains(e.getKey()) || !oldAttachFlags[configIndex]) continue;
                undoAttachFlags[configIndex.intValue()] = Boolean.TRUE;
            }
            widget.restoreSDKAttachData(sdk.getId(), undoAttachFlags);
        }
    }

    public static void checkAttached(IProject project) {
        List<ISDK> attached = SDKAttach.getAttached(project);
        if (attached.isEmpty()) {
            return;
        }
        SDKAttach.checkMissedFiles(project, attached);
    }

    public static boolean hasAttached(IProject project) {
        return cache.containsKey(project.getName());
    }

    private static void attach(ISDK sdk, IConfiguration cfg) {
        AttachData[] data;
        if (sdk == null || cfg == null) {
            return;
        }
        String id = sdk.getId();
        AttachData[] attachDataArray = data = SDKAttach.get(cfg.getOwner().getProject());
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            AttachData dt = attachDataArray[n2];
            if (dt.sdkId.equals(id)) {
                String[] stringArray = dt.cfgs;
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray[n4];
                    if (s.equals(cfg.getName())) {
                        SDKSupportPlugin.log(String.format(Messages.SDKAttach_Attached, sdk.getId(), cfg.getName(), cfg.getOwner().getProject().getName()));
                        return;
                    }
                    ++n4;
                }
                String[] tmp = new String[dt.cfgs.length + 1];
                System.arraycopy(dt.cfgs, 0, tmp, 0, dt.cfgs.length);
                tmp[((AttachData)dt).cfgs.length] = cfg.getName();
                dt.cfgs = tmp;
                SDKAttach.put(cfg.getOwner().getProject(), data);
                return;
            }
            ++n2;
        }
        AttachData[] tmp = new AttachData[data.length + 1];
        System.arraycopy(data, 0, tmp, 0, data.length);
        tmp[data.length] = new AttachData();
        tmp[data.length].sdkId = sdk.getId();
        tmp[data.length].cfgs = new String[]{cfg.getName()};
        SDKAttach.put(cfg.getOwner().getProject(), tmp);
    }

    private static void detach(ISDK sdk, IConfiguration cfg) {
        AttachData[] data;
        if (sdk == null || cfg == null) {
            return;
        }
        String id = sdk.getId();
        AttachData[] attachDataArray = data = SDKAttach.get(cfg.getOwner().getProject());
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            AttachData dt = attachDataArray[n2];
            if (dt.sdkId.equals(id)) {
                String[] stringArray = dt.cfgs;
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray[n4];
                    if (s.equals(cfg.getName())) {
                        if (dt.cfgs.length == 1) {
                            AttachData[] tmp = new AttachData[data.length - 1];
                            int cnt = 0;
                            AttachData[] attachDataArray2 = data;
                            int n5 = data.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                AttachData d = attachDataArray2[n6];
                                if (!d.equals(dt)) {
                                    tmp[cnt++] = d;
                                }
                                ++n6;
                            }
                            SDKAttach.put(cfg.getOwner().getProject(), tmp);
                        } else {
                            String[] tmp = new String[dt.cfgs.length - 1];
                            int cnt = 0;
                            String[] stringArray2 = dt.cfgs;
                            int n7 = stringArray2.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                String c = stringArray2[n8];
                                if (!c.equals(s)) {
                                    tmp[cnt++] = c;
                                }
                                ++n8;
                            }
                            dt.cfgs = tmp;
                            SDKAttach.put(cfg.getOwner().getProject(), data);
                        }
                        return;
                    }
                    ++n4;
                }
                SDKSupportPlugin.log(String.format(Messages.SDKAttach_Not_attached_to_cfg, sdk.getId(), cfg.getName(), cfg.getOwner().getProject().getName()));
                return;
            }
            ++n2;
        }
        SDKSupportPlugin.log(String.format(Messages.SDKAttach_Not_attached_to_prj, sdk.getId(), cfg.getOwner().getProject().getName()));
    }

    private static AttachData[] get(IProject project) {
        String sdksConfigData;
        IConfiguration[] configurations = null;
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)project);
        if (bi != null) {
            configurations = bi.getManagedProject().getConfigurations();
        }
        if ((sdksConfigData = new ProjectSettings(project, SDKSupportPlugin.getUniqueIdentifier()).load(AttachData.SDKS_PROJECT_PROPERTY_KEY)) == null || sdksConfigData.trim().length() == 0) {
            cache.remove(project.getName());
            return new AttachData[0];
        }
        String[] attachedSdks = sdksConfigData.split(":");
        int attachedSdksCount = attachedSdks.length;
        AttachData[] attachData = new AttachData[attachedSdksCount];
        int i = 0;
        while (i < attachedSdksCount) {
            String[] attachedSdkParams = attachedSdks[i].split(Pattern.quote("|"));
            attachData[i] = new AttachData();
            attachData[i].sdkId = attachedSdkParams[0].trim();
            int attachedConfigsCount = attachedSdkParams.length - 1;
            if (attachedConfigsCount > 0) {
                attachData[i].cfgs = new String[attachedConfigsCount];
                System.arraycopy(attachedSdkParams, 1, attachData[i].cfgs, 0, attachedConfigsCount);
            } else if (configurations != null) {
                int projectConfigsCount = configurations.length;
                attachData[i].cfgs = new String[projectConfigsCount];
                int j = 0;
                while (j < projectConfigsCount) {
                    ((AttachData)attachData[i]).cfgs[j] = configurations[j].getName();
                    ++j;
                }
            } else {
                attachData[i].cfgs = new String[0];
            }
            ++i;
        }
        cache.put(project.getName(), attachData);
        return attachData;
    }

    private static void put(IProject p, AttachData[] data) {
        StringBuilder sb = new StringBuilder();
        AttachData[] attachDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            AttachData dt = attachDataArray[n2];
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(dt.toRecord());
            ++n2;
        }
        new ProjectSettings(p, SDKSupportPlugin.getUniqueIdentifier()).store(AttachData.SDKS_PROJECT_PROPERTY_KEY, sb.toString());
        cache.put(p.getName(), data);
    }

    private static boolean checkConflictedFiles(ISDK sdk, IProject project, OverrideData overrideData) {
        boolean isChecked = true;
        ISDKFilesChecker filesChecker = SDKFilesChecker.getFilesChecker(sdk, project, ISDKFilesChecker.Mode.CONFLICTED);
        ISDKFilesCheckerResult checkResult = filesChecker.checkFiles();
        Set<IExtendedPath> conflictedFiles = checkResult.getResultFiles();
        if (!conflictedFiles.isEmpty()) {
            SDKConflictedFilesDialog sdkConflictedFilesDialog = new SDKConflictedFilesDialog(EclipseUtils.getShell(), sdk, project, conflictedFiles);
            if (sdkConflictedFilesDialog.open() != 0) {
                isChecked = false;
            } else {
                overrideData.setFilesToOverride(sdkConflictedFilesDialog.getFilesToOverride());
                overrideData.setBackupFiles(sdkConflictedFilesDialog.isBackupFiles());
            }
        }
        return isChecked;
    }

    private static void checkMissedFiles(IProject project, List<ISDK> attached) {
        HashMap<ISDK, Set<IExtendedPath>> checkResults = new HashMap<ISDK, Set<IExtendedPath>>();
        for (ISDK sdk2 : attached) {
            ISDKFilesCheckerResult checkResult = SDKFilesChecker.getFilesChecker(sdk2, project, ISDKFilesChecker.Mode.MISSED).checkFiles();
            Set<IExtendedPath> missedFiles = checkResult.getResultFiles();
            if (missedFiles.isEmpty()) continue;
            checkResults.put(sdk2, missedFiles);
        }
        if (!checkResults.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            checkResults.keySet().forEach(sdk -> sb.append("- ").append(sdk.getBriefInfo()).append('\n'));
            SDKAttach.confirmAndRestoreSDKFiles(checkResults, project, sb.toString());
        }
    }

    private static void confirmAndRestoreSDKFiles(Map<ISDK, Set<IExtendedPath>> checkResults, IProject project, String sdkList) {
        Shell shell = EclipseUtils.getShell();
        shell.getDisplay().asyncExec(() -> {
            if (MessageDialog.openConfirm((Shell)shell, (String)Messages.SDKMissedFilesDialog_title, (String)String.format(Messages.SDKMissedFilesDialog_text, project.getName(), sdkList))) {
                SDKAttach.restoreSDKs(checkResults, project);
            }
        });
    }

    private static void removeSDKFolderFromProject(ISDK sdk, IProject project) {
        SDKUtils.removeSources(project, sdk);
        IFolder projectSDKFolder = project.getFolder(sdk.getName());
        if (projectSDKFolder.isVirtual()) {
            try {
                projectSDKFolder.delete(true, null);
            }
            catch (CoreException e) {
                SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", e.getMessage()));
            }
        }
    }

    private static void reindexProject(IProject project) {
        ICProject cProject = CoreModel.getDefault().getCModel().getCProject(project.getName());
        CCorePlugin.getIndexManager().reindex(cProject);
    }

    private static void restoreSDKs(Map<ISDK, Set<IExtendedPath>> sdks, IProject project) {
        try {
            for (Map.Entry<ISDK, Set<IExtendedPath>> entry : sdks.entrySet()) {
                ISDK sdk = entry.getKey();
                HashSet<IFolder> foldersToRestore = new HashSet<IFolder>();
                IFolder sdkFolder = project.getFolder(sdk.getName());
                foldersToRestore.add(sdkFolder);
                List<IConfiguration> cfgs = SDKAttach.getAttached(project, sdk);
                SDKUtils.restoreSDKFolder(sdkFolder, cfgs);
                IPath sdkPath = SDKSupportPlugin.getEclipsePath(sdk);
                for (IExtendedPath ep : entry.getValue()) {
                    IPath srcRelPath = ep.makeRelativeTo(sdkPath);
                    IFolder folder = null;
                    String copyPath = ep.copyPath();
                    if (copyPath != null && !copyPath.isEmpty() && !copyPath.equals(".")) {
                        folder = project.getFolder(ep.copyPath());
                        if (!foldersToRestore.add(folder)) continue;
                        SDKUtils.restoreSDKFolder(folder, cfgs);
                        continue;
                    }
                    folder = sdkFolder;
                    int i = 0;
                    while (i < srcRelPath.segmentCount() - 1) {
                        if (foldersToRestore.add(folder = folder.getFolder(srcRelPath.segment(i)))) {
                            SDKUtils.restoreSDKFolder(folder, cfgs);
                        }
                        ++i;
                    }
                }
            }
            for (ISDK sdk : sdks.keySet()) {
                SDKAttach.restoreSDK(sdk, project);
            }
        }
        catch (CoreException e) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", e.getMessage()));
        }
    }

    private static class AttachData {
        private static final String SDKS_PROJECT_PROPERTY_KEY = String.valueOf(SDKSupportPlugin.getUniqueIdentifier()) + ".attachedSDKs";
        private static final String SDK_IDS_SEPARATOR = ":";
        private static final String SDK_GROUP_SEPARATOR = "|";
        private String sdkId;
        private String[] cfgs;

        private AttachData() {
        }

        public String toString() {
            return "[AttachData: " + this.sdkId + SDK_GROUP_SEPARATOR + Arrays.toString(this.cfgs) + " ]";
        }

        private String toRecord() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.sdkId);
            String[] stringArray = this.cfgs;
            int n = this.cfgs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (sb.length() > 0) {
                    sb.append(SDK_GROUP_SEPARATOR);
                }
                sb.append(s);
                ++n2;
            }
            return sb.toString();
        }
    }

    private static class OverrideData {
        private boolean isBackupFiles;
        private Set<IExtendedPath> filesToOverride;

        private OverrideData() {
        }

        private void setFilesToOverride(Set<IExtendedPath> filesToOverride) {
            this.filesToOverride = filesToOverride;
        }

        private void setBackupFiles(boolean isBackupFiles) {
            this.isBackupFiles = isBackupFiles;
        }

        private Set<IExtendedPath> getFilesToOverride() {
            return this.filesToOverride;
        }

        private boolean isBackupFiles() {
            return this.isBackupFiles;
        }
    }
}

