/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import java.io.File;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariable;
import org.eclipse.core.resources.IProject;

public class SDKValidator {
    private static final String SDK_NAME_PATTERN = "^[a-zA-Z0-9_]*$";
    private static final String SDK_VERS_PATTERN = "^[a-zA-Z0-9_.]*$";
    private static final String ENV_NAME_PATTERN = "^[a-zA-Z0-9_.]*$";
    private static final int MAX_LEN = 250;
    private IProject project;

    public SDKValidator(IProject project) {
        this.project = project;
    }

    public Result validateName(String name) {
        if (Result.VALIDATION_OK != this.validateFieldIsNullOrEmpty(name)) {
            return Result.FIELD_EMPTY;
        }
        if (!this.validateFirstLetter(name)) {
            return Result.FIELD_FIRST_LETTER_ERROR;
        }
        if (!this.validateNameChars(name)) {
            return Result.FIELD_CHARS_ERROR;
        }
        if (Result.VALIDATION_OK != this.validateFieldLength(name)) {
            return Result.FIELD_LENGTH_ERROR;
        }
        return Result.VALIDATION_OK;
    }

    public Result validateVersion(String version) {
        if (Result.VALIDATION_OK != this.validateFieldIsNullOrEmpty(version)) {
            return Result.FIELD_EMPTY;
        }
        if (!this.validateVersionChars(version)) {
            return Result.FIELD_CHARS_ERROR;
        }
        return Result.VALIDATION_OK;
    }

    public Result validateExists(String name, String version) {
        if (SDKUtils.exists(SDKHeader.makeId(name, version))) {
            return Result.SDK_EXISTS;
        }
        return Result.VALIDATION_OK;
    }

    public Result validatePath(String path, String envName) {
        if (path != null) {
            File file = new File(SDKSupportPlugin.performStringSubstitution(path, envName));
            if (!file.exists()) {
                return Result.PATH_NOT_EXISTS;
            }
            if (!file.isDirectory()) {
                return Result.PATH_NOT_DIR;
            }
        } else {
            return Result.PATH_NOT_EXISTS;
        }
        return Result.VALIDATION_OK;
    }

    public Result validateEnv(String envName, boolean isSystem) {
        if (Result.VALIDATION_OK != this.validateFieldIsNullOrEmpty(envName)) {
            return Result.FIELD_EMPTY;
        }
        if (!this.validateFirstLetter(envName)) {
            return Result.FIELD_FIRST_LETTER_ERROR;
        }
        if (envName.length() > 250) {
            return Result.FIELD_LENGTH_ERROR;
        }
        if (!this.validateEnvNameChars(envName)) {
            return Result.FIELD_CHARS_ERROR;
        }
        if (!this.validateEnvVariableExist(envName, isSystem)) {
            return Result.ENV_VAR_EXISTS;
        }
        return Result.VALIDATION_OK;
    }

    public Result validateEnvVariableExist(String name) {
        if (SDKSupportPlugin.isVariableExists(name) && System.getenv().get(name) == null) {
            return Result.ENV_VAR_EXISTS;
        }
        return Result.VALIDATION_OK;
    }

    public boolean validateEnvVariableExist(String envName, boolean isSystem) {
        if (!isSystem && System.getenv().containsKey(envName)) {
            return false;
        }
        ICdtVariableManager vmgr = CCorePlugin.getDefault().getCdtVariableManager();
        ICdtVariable variable = vmgr.getVariable(envName, null);
        if (variable instanceof StorableCdtVariable) {
            return false;
        }
        if (this.project != null) {
            return !this.isProjectLocalVariableExist(envName, this.project);
        }
        for (IProject prj : SDKUtils.listProjects()) {
            if (!this.isProjectLocalVariableExist(envName, prj)) continue;
            return false;
        }
        return true;
    }

    public Result validateFieldLength(String field) {
        return field == null || field.length() <= 250 ? Result.VALIDATION_OK : Result.FIELD_LENGTH_ERROR;
    }

    public Result validateFieldIsNullOrEmpty(String field) {
        return field == null || field.isEmpty() ? Result.FIELD_EMPTY : Result.VALIDATION_OK;
    }

    public Result validateArchiveDescriptor(String archiveName) {
        Result result = Result.VALIDATION_OK;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(archiveName);){
                ZipEntry sourceXmlEntry = zipFile.getEntry("sources.xml");
                if (sourceXmlEntry == null) {
                    result = Result.DESCRIPTOR_NOT_EXISTS;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            SDKSupportPlugin.error(Messages.SDKImportDialog_exception, ex);
        }
        return result;
    }

    public boolean validateFirstLetter(String text) {
        return text != null && !text.isEmpty() && Character.isLetter(text.charAt(0));
    }

    public boolean validateNameChars(String text) {
        return this.isMatch(text, SDK_NAME_PATTERN);
    }

    public boolean validateVersionChars(String text) {
        return this.isMatch(text, "^[a-zA-Z0-9_.]*$");
    }

    public boolean validateEnvNameChars(String text) {
        return this.isMatch(text, "^[a-zA-Z0-9_.]*$");
    }

    private boolean isMatch(String text, String pattern) {
        return text != null && !text.isEmpty() && text.matches(pattern);
    }

    private boolean isProjectLocalVariableExist(String envName, IProject project) {
        ICdtVariable variable;
        ICConfigurationDescription cfg;
        ICdtVariableManager vmgr = CCorePlugin.getDefault().getCdtVariableManager();
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project);
        return projectDescription != null && (cfg = projectDescription.getDefaultSettingConfiguration()) != null && (variable = vmgr.getVariable(envName, cfg)) instanceof StorableCdtVariable && vmgr.getVariable(envName, cfg) != null;
    }

    public static enum Result {
        VALIDATION_OK,
        FIELD_EMPTY,
        FIELD_FIRST_LETTER_ERROR,
        FIELD_CHARS_ERROR,
        FIELD_LENGTH_ERROR,
        PATH_NOT_EXISTS,
        PATH_NOT_DIR,
        SDK_EXISTS,
        ENV_VAR_EXISTS,
        DESCRIPTOR_NOT_EXISTS;

    }
}

