/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.ui.internal.handler.SDKEditDialogHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameDialog
extends TitleAreaDialog {
    private Text sdkNameField;
    private Text sdkVersionField;
    private Button okButton;
    private String sdkName;
    private String sdkVersion;
    private String defaultMsg = null;
    private String resName;
    private String resVers;
    private String envName;
    private SDKEditDialogHandler handler;

    public RenameDialog(Shell parent, ISDK sdk, String message) {
        super(parent);
        this.sdkName = sdk.getName();
        this.sdkVersion = sdk.getVersion();
        this.handler = new SDKEditDialogHandler(this, null);
        this.defaultMsg = message;
    }

    public RenameDialog(Shell parent, SDKHeader sdkHeader, String message) {
        super(parent);
        this.sdkName = sdkHeader.getName();
        this.sdkVersion = sdkHeader.getVersion();
        this.handler = new SDKEditDialogHandler(this, null);
        this.defaultMsg = message;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.RenameDialog_TITLE);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = new Composite(parentComposite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)contents);
        this.setTitle(this.defaultMsg == null || this.defaultMsg.trim().isEmpty() ? Messages.RenameDialog_PROVIDE_ANOTHER : this.defaultMsg);
        contents.setLayout((Layout)new GridLayout(2, false));
        this.createWidgets(contents);
        RenameDialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.sdkNameField.setFocus();
        this.sdkNameField.setText(this.sdkName);
        this.sdkNameField.selectAll();
        this.sdkVersionField.setText(this.sdkVersion);
    }

    public String getSDKName() {
        return this.resName;
    }

    public String getSDKVersion() {
        return this.resVers;
    }

    private void createWidgets(Composite contents) {
        Label label1 = new Label(contents, 16384);
        label1.setText(Messages.RenameDialog_NAME_LABEL);
        label1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sdkNameField = new Text(contents, 2052);
        this.sdkNameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sdkNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameDialog.this.updateEnvName();
                RenameDialog.this.validate();
            }
        });
        Label label2 = new Label(contents, 16384);
        label2.setText(Messages.RenameDialog_VERS_LABEL);
        label2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sdkVersionField = new Text(contents, 2052);
        this.sdkVersionField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sdkVersionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameDialog.this.updateEnvName();
                RenameDialog.this.validate();
            }
        });
    }

    private String updateEnvName() {
        this.envName = SDKSupportPlugin.getEnvironment(this.sdkNameField.getText(), this.sdkVersionField.getText()).getName();
        return this.envName;
    }

    private void validate() {
        boolean isOk = true;
        if (isOk &= this.handler.validateName(this.sdkNameField.getText())) {
            isOk &= this.handler.validateVersion(this.sdkVersionField.getText());
        }
        if (isOk) {
            isOk &= this.handler.validateExists(this.sdkNameField.getText(), this.sdkVersionField.getText());
        }
        if (isOk) {
            isOk &= this.handler.validateEnv(this.envName, false);
        }
        if (isOk) {
            this.setErrorMessage(null);
            this.resName = this.sdkNameField.getText();
            this.resVers = this.sdkVersionField.getText();
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(this.getErrorMessage() == null);
        }
    }
}

