/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.internal.ExtendedPath;
import com.freescale.s32ds.cross.sdk.ui.internal.ConflictedFilesTreeViewer;
import com.freescale.s32ds.cross.sdk.ui.internal.CustomTreeViewer;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SDKConflictedFilesDialog
extends TitleAreaDialog {
    private static final String HELP_CONTEXT_ID = "com.freescale.s32ds.cross.sdk.support.SDK_conflicted_files_context";
    private final ISDK sdk;
    private final IProject project;
    private final Set<IExtendedPath> conflictedFiles;
    private final Set<IExtendedPath> filesToOverride;
    private boolean isBackupFiles;
    private ConflictedFilesTreeViewer tree;

    public SDKConflictedFilesDialog(Shell parentShell, ISDK sdk, IProject project, Set<IExtendedPath> conflictedFiles) {
        super(parentShell);
        this.sdk = Objects.requireNonNull(sdk, "SDK must not be null");
        this.project = Objects.requireNonNull(project, "Project must not be null");
        this.conflictedFiles = Objects.requireNonNull(conflictedFiles);
        this.filesToOverride = new HashSet<IExtendedPath>();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SDKConflictedFilesDialog_text);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        this.setupViewer(contents, "Conflicted files:", this.createPathMatcher());
        return contents;
    }

    private PathMatcher createPathMatcher() {
        StringBuilder sb = new StringBuilder("{");
        this.conflictedFiles.forEach(f -> {
            sb.append(f.toPortableString());
            sb.append(',');
        });
        sb.append("}");
        String pattern = sb.toString();
        return FileSystems.getDefault().getPathMatcher("glob:" + pattern);
    }

    private Composite createComposite(Composite parentComposite) {
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(1808);
        data.widthHint = 500;
        data.heightHint = 600;
        contents.setLayoutData((Object)data);
        this.setTitle(Messages.SDKConflictedFilesDialog_message_title);
        this.setMessage(String.format(Messages.SDKConflictedFilesDialog_message_head, this.project.getName()));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)contents, HELP_CONTEXT_ID);
        return contents;
    }

    private CustomTreeViewer setupViewer(Composite parent, String label, PathMatcher matcher) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tree = new ConflictedFilesTreeViewer(group, matcher);
        this.tree.setConflictedFiles(this.conflictedFiles);
        String rootPath = this.sdk.getEnv().getValue();
        if (rootPath != null) {
            this.tree.setInput(CustomTreeViewer.wrap(ExtendedPath.fromOSString(rootPath, true)), this.conflictedFiles, true);
        }
        return this.tree;
    }

    public Set<IExtendedPath> getFilesToOverride() {
        return this.filesToOverride;
    }

    public boolean isBackupFiles() {
        return this.isBackupFiles;
    }

    protected void okPressed() {
        ConflictedFilesTreeViewer cftv = this.tree;
        IExtendedPath[] checked = cftv.getChecked();
        int i = 0;
        while (i < checked.length) {
            this.filesToOverride.add(checked[i]);
            ++i;
        }
        this.isBackupFiles = cftv.isBackupFiles();
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
        MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)String.format(Messages.SDKAttach_Not_attached_to_prj, this.sdk.getId(), this.project.getName()));
    }
}

