/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import java.io.File;
import java.nio.file.FileSystems;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SDKExportDialog
extends TitleAreaDialog {
    private static final String MSG = Messages.SDKExportDialog_use_browse;
    private final ISDK sdk;
    private String location;
    private boolean withContent;
    private boolean needsOverwrite = false;
    private Text locationField;
    private Button withContentButton;
    private final String standardMessage;

    public SDKExportDialog(Shell parentShell, ISDK sdk) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.sdk = sdk;
        this.standardMessage = Messages.SDKDialog_export_dialog_header_text;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SDKDialog_export_dialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(1808);
        data.widthHint = 500;
        composite.setLayoutData((Object)data);
        Label locationLabel = new Label(composite, 16384);
        locationLabel.setText(Messages.SDKExportDialog_ToArchive);
        locationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.locationField = new Text(composite, 2060);
        this.locationField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.locationField.setToolTipText(MSG);
        this.locationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDKExportDialog.this.updateButtonsState();
            }
        });
        Button folderButton = new Button(composite, 8);
        folderButton.setText(Messages.SDKDialog_location_button_text);
        folderButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String location = SDKExportDialog.this.selectFolder();
                if (location != null) {
                    SDKExportDialog.this.locationField.setText(String.format("%s%s%s_%s.zip", location, location.endsWith(FileSystems.getDefault().getSeparator()) ? "" : FileSystems.getDefault().getSeparator(), SDKExportDialog.this.sdk.getName(), SDKExportDialog.this.sdk.getVersion()));
                }
                SDKExportDialog.this.updateButtonsState();
            }
        });
        this.setButtonLayoutData(folderButton);
        Group options = new Group(composite, 16);
        options.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        options.setText(Messages.SDKExportDialog_Options);
        options.setLayout((Layout)new GridLayout(1, true));
        this.withContentButton = new Button((Composite)options, 32);
        this.withContentButton.setText(Messages.SDKExportDialog_Export_descriptor);
        this.withContentButton.setSelection(false);
        this.setButtonLayoutData(this.withContentButton);
        this.setTitle(Messages.SDKDialog_export_dialog_title);
        this.setMessage(this.standardMessage);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.freescale.s32ds.cross.sdk.support.SDK_export_context");
        return composite;
    }

    private String selectFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10000000);
        dialog.setText(Messages.SDKDialog_folder_selection_dialog_title);
        dialog.setMessage(Messages.SDKDialog_folder_selection_dialog_header_text);
        return dialog.open();
    }

    private void updateButtonsState() {
        boolean status = true;
        this.needsOverwrite = false;
        if (this.locationField.getText().isEmpty()) {
            this.setMessage(MSG);
            status = false;
        } else {
            String s = this.locationField.getText();
            StringBuilder sb = new StringBuilder();
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                char[] cArray2 = "#;=,:@*?<>\\|\"' {}[]()`&$%".toCharArray();
                int n3 = cArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    char x = cArray2[n4];
                    if (x != ':' && x != '\\' && x == c) {
                        sb.append(c);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (sb.length() > 0) {
                this.setMessage(String.format(Messages.SDKExportDialog_bad_symbol, sb.toString()));
                status = false;
            } else {
                File f = new File(s);
                if (f.exists()) {
                    if (f.isFile() && f.canWrite()) {
                        this.setMessage(Messages.SDKExportDialog_File_Exists);
                        this.needsOverwrite = true;
                    } else {
                        this.setMessage(Messages.SDKExportDialog_Cannot_Rewrite);
                        status = false;
                    }
                } else {
                    try {
                        this.setMessage(f.getCanonicalPath());
                        f.createNewFile();
                        f.delete();
                    }
                    catch (Exception e) {
                        this.setMessage(String.valueOf(Messages.SDKExportDialog_Cannot_Create) + ' ' + e.getMessage());
                        status = false;
                    }
                }
            }
        }
        this.getButton(0).setEnabled(status);
    }

    public void create() {
        super.create();
        this.updateButtonsState();
    }

    protected void okPressed() {
        if (this.needsOverwrite && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.SDKExportDialog_title, (String)Messages.SDKExportDialog_overwrite)) {
            return;
        }
        this.location = this.locationField.getText();
        this.withContent = !this.withContentButton.getSelection();
        super.okPressed();
    }

    public String location() {
        return this.location;
    }

    public boolean withContent() {
        return this.withContent;
    }
}

