/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.core.model.ISDKFilterInfo;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.ui.SDKManagementWidget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SDKSelectDialog
extends Dialog {
    private SDKManagementWidget widget = SDKManagementWidget.WIZARD;
    private Object[] selection;
    private final Object[] initial;
    private Label message;

    public SDKSelectDialog(Shell parentShell, ISDKFilterInfo info, Object initial) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.initial = this.checkNullAndCastToArray(initial);
        this.widget.setFilterInfo(info);
        this.widget.holderDialog = this;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SDKDialog_select_dialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.message = new Label(composite, 4);
        this.message.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selection = this.checkNullAndCastToArray(this.initial);
        this.widget.createContents(composite);
        this.widget.setSelected(this.selection);
        return composite;
    }

    protected void okPressed() {
        this.selection = this.widget.getSelectedToAttach().toArray();
        this.widget.cancelSelectedToAttach();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.widget.cancelSelectedToAttach();
        super.cancelPressed();
    }

    public Object[] get() {
        return this.selection;
    }

    private Object[] checkNullAndCastToArray(Object value) {
        return value != null ? (Object[])value : new Object[]{};
    }

    public Button getOK() {
        return this.getButton(0);
    }

    public void setMessage(String msg) {
        this.message.setText(msg);
    }
}

