/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.sdkexplorer;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.IExtendedIncludeReference;
import com.freescale.s32ds.ui.dndexplorer.ADnDExplorerLabelProvider;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class SDKExplorerLabelProvider
extends ADnDExplorerLabelProvider {
    private final Map<ITranslationUnit, IASTComment[]> tuCommentsMap = new HashMap<ITranslationUnit, IASTComment[]>();
    private final Map<IFunctionDeclaration, String> functionCommentMap = new HashMap<IFunctionDeclaration, String>();

    public String getText(Object element) {
        if (element instanceof ISDK) {
            ISDK sdk = (ISDK)element;
            return String.format(Messages.SDKExplorerLabelProvider_name_version, sdk.getName(), sdk.getVersion());
        }
        if (element instanceof IExtendedIncludeReference) {
            IExtendedIncludeReference incRef = (IExtendedIncludeReference)element;
            return incRef.getRelativePath().toString();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof ISDK) {
            descriptor = CDTSharedImages.getImageDescriptor((String)"icons/obj16/hfolder_obj.gif");
            return new CElementImageDescriptor(descriptor, 2, SMALL_SIZE).createImage();
        }
        return super.getImage(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof IFunctionDeclaration) {
            try {
                IFunctionDeclaration fd = (IFunctionDeclaration)element;
                String cmmnt = this.functionCommentMap.get(fd);
                if (cmmnt != null) {
                    return cmmnt;
                }
                ITranslationUnit tu = fd.getTranslationUnit();
                int fLoc = fd.getSourceRange().getStartLine();
                IASTComment[] comments = this.tuCommentsMap.get(tu);
                if (comments == null) {
                    comments = tu.getAST(null, 6).getComments();
                    this.tuCommentsMap.put(tu, comments);
                }
                IASTComment[] iASTCommentArray = comments;
                int n = comments.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTComment c = iASTCommentArray[n2];
                    int cLoc = c.getFileLocation().getEndingLineNumber();
                    if (fLoc - cLoc < 3) {
                        String comment = String.valueOf(c.getComment());
                        String value = String.format("%s%n%s : %s", comment, fd.getSignature(), fd.getReturnType());
                        this.functionCommentMap.put(fd, value);
                        return value;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                SDKSupportPlugin.error(e);
            }
        }
        return super.getToolTipText(element);
    }
}

