/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.GitSDK;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.ImportSDK;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKLoadException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class SDKDescriptorParser {
    public static List<ISDK> loadSDKs(String sourceXml, IProject project, String alterEnvValue, int origin) throws SDKLoadException {
        ArrayList<ISDK> result = new ArrayList<ISDK>();
        if (sourceXml == null || sourceXml.length() == 0) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format);
        }
        Element root = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(sourceXml.getBytes("UTF-8"));
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(stream).getDocumentElement();
        }
        catch (Exception e) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format, e);
        }
        if (!root.getNodeName().equals("sdks")) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format);
        }
        NodeList sdkNodes = root.getElementsByTagName("sdk");
        int i = 0;
        while (i < sdkNodes.getLength()) {
            ISDK sdk = SDKDescriptorParser.parseSDKElement((Element)sdkNodes.item(i), project, alterEnvValue, origin);
            if (sdk != null) {
                result.add(sdk);
            }
            ++i;
        }
        return result;
    }

    public static List<ISDK> loadSDKs(File sourceXmlFile, IProject project, String alterEnvValue, int origin) throws SDKLoadException {
        String sourceXml = SDKDescriptorParser.loadSourceXml(sourceXmlFile);
        return SDKDescriptorParser.loadSDKs(sourceXml, project, alterEnvValue, origin);
    }

    public static ISDK loadSDK(String sourceXml, String sdkId, IProject project, int origin, String alterEnvValue) throws SDKLoadException {
        ISDK result = null;
        NodeList sdkNodes = SDKDescriptorParser.getSDKNodesList(sourceXml);
        int i = 0;
        while (i < sdkNodes.getLength()) {
            Element element = (Element)sdkNodes.item(i);
            if (element.getAttribute("id").equals(sdkId)) {
                result = SDKDescriptorParser.parseSDKElement(element, project, alterEnvValue, origin);
                break;
            }
            ++i;
        }
        if (result == null) {
            throw new SDKLoadException(Messages.AbstractSDK_exception);
        }
        return result;
    }

    public static Map<String, SDKHeader> loadSDKHeaders(String sourceXml) throws SDKLoadException {
        NodeList sdkNodes = SDKDescriptorParser.getSDKNodesList(sourceXml);
        HashMap<String, SDKHeader> result = new HashMap<String, SDKHeader>();
        int i = 0;
        while (i < sdkNodes.getLength()) {
            Element sdkNode = (Element)sdkNodes.item(i);
            result.put(sdkNode.getAttribute("id"), new SDKHeader(false, sdkNode));
            ++i;
        }
        if (result == null || result.isEmpty()) {
            throw new SDKLoadException(Messages.AbstractSDK_exception);
        }
        return result;
    }

    public static Map<String, SDKHeader> loadSDKHeaders(File sourceXmlFile) throws SDKLoadException {
        return SDKDescriptorParser.loadSDKHeaders(SDKDescriptorParser.loadSourceXml(sourceXmlFile));
    }

    public static NodeList getSDKNodesList(String sourceXml) throws SDKLoadException {
        Element root = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(sourceXml.getBytes("UTF-8"));
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(stream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new SDKLoadException(Messages.AbstractSDK_exception);
        }
        if (!root.getNodeName().equals("sdks")) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format);
        }
        NodeList sdkNodes = root.getElementsByTagName("sdk");
        if (sdkNodes == null || sdkNodes.getLength() == 0) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format);
        }
        return sdkNodes;
    }

    private static ISDK parseSDKElement(Element sdkElement, IProject project, String alterEnvValue, int origin) {
        TCHolder rootHolder = SDKDescriptorParser.createToolchainsHolder(sdkElement.getAttribute("symbols"));
        SDKHeader sdkHeader = SDKDescriptorParser.createSDKHeader(sdkElement, origin, alterEnvValue);
        ArrayList<TCHolder> toolchainsList = SDKDescriptorParser.parseSDKContent(sdkElement, sdkHeader, rootHolder, alterEnvValue);
        TCHolder[] tcs = !toolchainsList.isEmpty() ? toolchainsList.toArray(new TCHolder[toolchainsList.size()]) : null;
        IFilterOptions filter = SDKDescriptorParser.createFilterOptions(sdkHeader, tcs);
        return SDKDescriptorParser.createSDK(sdkHeader, rootHolder, tcs, filter, origin, alterEnvValue, project);
    }

    private static SDKHeader createSDKHeader(Element sdkElement, int origin, String alterEnvValue) {
        boolean isCreateEnv = origin != 3 && origin != 2;
        SDKHeader sdkHeader = new SDKHeader(isCreateEnv, sdkElement);
        if (sdkHeader.getEnv() == null && isCreateEnv) {
            sdkHeader.setEnv(SDKSupportPlugin.createEnvironment(sdkHeader.getName(), sdkHeader.getVersion(), false, true, alterEnvValue, sdkHeader.getDescription()));
        }
        return sdkHeader;
    }

    private static TCHolder createToolchainsHolder(String defSymbols) {
        TCHolder toolchainsHolder = new TCHolder(null);
        toolchainsHolder.defs = defSymbols == null || defSymbols.trim().isEmpty() ? Collections.emptyList() : Arrays.asList(defSymbols.split(","));
        return toolchainsHolder;
    }

    private static ArrayList<TCHolder> parseSDKContent(Element sdkElement, SDKHeader sdkHeader, TCHolder rootHolder, String alterEnvValue) {
        String path = sdkHeader.getBasePath();
        if ((path == null || path.trim().isEmpty()) && sdkHeader.env != null) {
            path = sdkHeader.getEnv().getValue();
        }
        ArrayList<TCHolder> toolchainsList = new ArrayList<TCHolder>();
        NodeList children = sdkElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (element.getNodeName().equals("toolchain")) {
                    TCHolder tcHolder = new TCHolder(element, path, alterEnvValue);
                    if (!tcHolder.isEmpty()) {
                        toolchainsList.add(tcHolder);
                    }
                } else {
                    rootHolder.process(element, path, alterEnvValue);
                }
            }
            ++i;
        }
        return toolchainsList;
    }

    private static IFilterOptions createFilterOptions(SDKHeader header, TCHolder[] tcs) {
        String toolchainsIds = tcs != null ? String.join((CharSequence)",", SDKDescriptorParser.getToolchainsIds(tcs)) : null;
        return FilterOptions.createFilterOptions(header.langs, toolchainsIds == null ? header.obsoleteToolchainIds : toolchainsIds, header.cores);
    }

    private static String[] getToolchainsIds(TCHolder[] tcs) {
        if (tcs == null || tcs.length == 0) {
            return new String[0];
        }
        String[] toolchainsIds = new String[tcs.length];
        int i = 0;
        while (i < tcs.length) {
            toolchainsIds[i] = tcs[i].getTCId();
            ++i;
        }
        return toolchainsIds;
    }

    private static ISDK createSDK(SDKHeader sdkHeader, TCHolder rootHolder, TCHolder[] tcs, IFilterOptions filter, int origin, String alterEnvValue, IProject project) {
        switch (origin) {
            case 2: 
            case 3: 
            case 6: {
                return new ImportSDK(sdkHeader, rootHolder, filter, tcs, alterEnvValue);
            }
            case 1: {
                return new GitSDK(sdkHeader, rootHolder, filter, tcs);
            }
            case 4: {
                return new ExternalSDK(sdkHeader, rootHolder, filter);
            }
            case 5: {
                return new ProjectLocalSDK(project, sdkHeader, rootHolder, filter);
            }
        }
        return null;
    }

    private static String loadSourceXml(File sourceXmlFile) throws SDKLoadException {
        String sourceXml = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(sourceXmlFile);){
                sourceXml = SDKUtils.toString(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new SDKLoadException(Messages.AbstractSDK_exception, ioe);
        }
        return sourceXml;
    }
}

