/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cli.ISettings;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.AbstractCommand;
import com.nxp.s32ds.ext.rcp.license.cll.CLLActivationType;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import java.io.File;

public class ReturnLicense
extends AbstractCommand {
    public static final String PARAM_ACT_ID = "actid";
    public static final String PARAM_REQ = "req";

    public ReturnLicense(ISettings settings, ICLL cll) {
        super(cll, settings);
        this.getParams().put(PARAM_ACT_ID, "Software Activation Code for product");
        this.getParams().put(PARAM_REQ, "Specify output xml file name for offline strategy");
    }

    @Override
    public String getName() {
        return "return";
    }

    @Override
    public String getOneLineDesc() {
        return "Return license. If req is set, use offline strategy.";
    }

    @Override
    public boolean canExecute() {
        return this.getProblemDescription() == null;
    }

    @Override
    public String getProblemDescription() {
        String rootProblems = super.getProblemDescription();
        if (rootProblems != null) {
            return rootProblems;
        }
        if (this.getSettings().getParam(PARAM_ACT_ID) == null) {
            return "Software Activation Code not set";
        }
        return null;
    }

    @Override
    public int execute() {
        CLLReason result;
        block6: {
            try {
                super.initLicenseLocation();
                super.setupProxy();
                if (this.isTestFNO()) {
                    if (this.getSettings().isDebugModeOn()) {
                        System.out.println("use test FNO");
                    }
                    this.getCll().setFNOUrlForTesting(true);
                }
                String requestXml = this.getSettings().getParam(PARAM_REQ);
                String actID = this.getSettings().getParam(PARAM_ACT_ID);
                if (this.getActivationType() == CLLActivationType.CLL_ACTIVATION_TYPE_OFFLINE_FNO) {
                    return this.generateXmlRequest(requestXml, actID);
                }
                result = this.getCll().returnLicense(actID, false, null);
                if (result != null) break block6;
                return 0;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return 1;
            }
        }
        System.err.println(result);
        return 1;
    }

    private int generateXmlRequest(String requestXml, String actID) {
        String reqFileName = new File(requestXml).getAbsolutePath();
        CLLReason result = this.getCll().returnLicense(actID, true, reqFileName);
        if (result == null) {
            return 0;
        }
        System.err.println(result);
        return 1;
    }

    private CLLActivationType getActivationType() {
        if (this.getSettings().getParam(PARAM_REQ) != null) {
            return CLLActivationType.CLL_ACTIVATION_TYPE_OFFLINE_FNO;
        }
        return CLLActivationType.CLL_ACTIVATION_TYPE_FNO;
    }
}

