/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cll.ui;

import com.nxp.s32ds.ext.rcp.license.LicenseActivator;
import com.nxp.s32ds.ext.rcp.license.LicenseFeature;
import com.nxp.s32ds.ext.rcp.license.Messages;
import com.nxp.s32ds.ext.rcp.license.cll.LicenseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CLLActivateWindow
extends Dialog {
    private static final boolean ENABLE_REFRESH = true;
    private Text actIDText;
    private Button checkOffline;
    private Button btnLoadOfflineResponse;
    private final LicenseFeature feature;

    public CLLActivateWindow(Shell parentShell, LicenseFeature feature) {
        super(parentShell);
        this.feature = feature;
        this.setShellStyle(67696);
        this.setBlockOnOpen(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString(this.feature.isEnabled() ? "LicenseWindow_titleOpen" : "LicenseWindow_titleActivate", new String[]{this.feature.getLabel()}));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.feature.isEnabled()) {
            this.createButton(parent, 0, Messages.getString("LicenseWindow_return", null), false);
        } else {
            this.createButton(parent, 0, Messages.getString("LicenseWindow_activate", null), true);
        }
        if (!this.feature.isEnabled()) {
            this.btnLoadOfflineResponse = this.createButton(parent, 1025, Messages.getString("LicenseWindow_activateLoadOffline", null), false);
            this.btnLoadOfflineResponse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    CLLActivateWindow.this.processOfflineResponse();
                }
            });
        } else {
            Button btnRefresh = this.createButton(parent, 1026, Messages.getString("LicenseWindow_refresh", null), false);
            btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CLLJob cllJob = new CLLJob(){

                        @Override
                        public void runCLL() throws LicenseException {
                            CLLActivateWindow.this.feature.refresh();
                        }
                    };
                    BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)cllJob);
                    if (cllJob.getException() != null) {
                        LicenseActivator.log(4, cllJob.getException().getMessage(), cllJob.getException());
                        CLLActivateWindow.this.showError("Offline Activation error", cllJob.getException().getMessage());
                    }
                    CLLActivateWindow.super.okPressed();
                }
            });
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, this.feature.isEnabled());
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        new Label(panel, 0).setText("Software Activation Code: ");
        this.actIDText = new Text(panel, 2048);
        this.actIDText.setText(this.feature.getActivationId());
        this.actIDText.setLayoutData((Object)new GridData(768));
        if (this.feature.isEnabled()) {
            this.actIDText.setEditable(false);
        }
        this.checkOffline = new Button(panel, 32);
        GridData gdata = new GridData();
        gdata.horizontalSpan = 2;
        this.checkOffline.setLayoutData((Object)gdata);
        this.checkOffline.setText(Messages.getString("LicenseWindow_activateGenerateOfflineRequest", null));
        return panel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void okPressed() {
        try {
            if (this.isOfflineMode()) {
                if (!this.feature.isEnabled()) {
                    this.generateOfflineRequest(this.feature.isEnabled());
                    return;
                }
                this.generateOfflineRequest(this.feature.isEnabled());
                super.okPressed();
            } else {
                this.onlineRequest(this.feature.isEnabled());
            }
            super.okPressed();
            return;
        }
        catch (Exception e) {
            LicenseActivator.log(2, e.getMessage(), e);
            this.showError("Software Activation Code error", e.getMessage());
        }
    }

    private boolean generateOfflineRequest(boolean returnLicense) throws LicenseException {
        FileDialog fDialog = new FileDialog(this.getShell(), 8192);
        fDialog.setFileName("request.xml");
        String path = fDialog.open();
        if (path == null) {
            return false;
        }
        String id = this.getUsersActivationId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("offlineRequest", path);
        if (!returnLicense) {
            this.activate(id, params, this.feature);
        } else {
            this.feature.returnLicense(id, params);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Offline Request Generation", (String)("Path to offline license request file: " + path));
        return true;
    }

    private String getUsersActivationId() {
        return this.actIDText.getText().trim();
    }

    private void onlineRequest(final boolean returnLicense) throws LicenseException {
        CLLJob cllJob = new CLLJob(){

            @Override
            public void runCLL() throws LicenseException {
                String id = CLLActivateWindow.this.getUsersActivationId();
                if (!returnLicense) {
                    CLLActivateWindow.this.activate(id, new HashMap(), CLLActivateWindow.this.feature);
                } else {
                    CLLActivateWindow.this.feature.returnLicense(id, new HashMap<String, String>());
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)cllJob);
        if (cllJob.getException() != null) {
            throw cllJob.getException();
        }
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void activate(String actId, Map<String, String> params, LicenseFeature feature) throws LicenseException {
        feature.activate(actId, params);
        if (feature.isEnabled()) {
            return;
        }
        if (this.isOfflineMode() && !params.containsKey("offlineResponse")) {
            return;
        }
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Feature NOT activated.", (String)"Your Software Activation Code is for another feature. Do you want to return it?")) {
            if (this.isOfflineMode()) {
                this.generateOfflineRequest(true);
            } else {
                this.onlineRequest(true);
            }
        }
    }

    private boolean isOfflineMode() {
        return this.checkOffline.getSelection();
    }

    private void processOfflineResponse() {
        String path = new FileDialog(this.getShell(), 4096).open();
        if (path == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("offlineResponse", path);
        try {
            this.activate("", params, this.feature);
        }
        catch (Exception e) {
            LicenseActivator.log(4, e.getMessage(), e);
            this.showError("Offline Activation error", e.getMessage());
        }
        CLLActivateWindow.super.okPressed();
    }

    private static abstract class CLLJob
    implements Runnable {
        private LicenseException exception = null;

        private CLLJob() {
        }

        @Override
        public void run() {
            try {
                this.runCLL();
            }
            catch (LicenseException ex) {
                this.exception = ex;
            }
        }

        public LicenseException getException() {
            return this.exception;
        }

        public abstract void runCLL() throws LicenseException;
    }
}

