/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.makefilegenerator;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.Activator;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.FSLMessages;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.FSLPathUtil;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IFSLBuildProgressMonitor;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IFSLManagedOutputNameProvider2;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IMakefileGeneratorContributor;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IMakefileGeneratorContributor2;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IToolConstants;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.MakefileGeneratorResources;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.MakefileGeneratorUtil;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.ToolProxy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class BaseMakefileGenerator {
    protected static final String EXECUTING_TARGET = "Executing target #";
    protected static final String TOTAL_RULE_COUNT = "Progress monitor hint: ";
    protected static final String USER_OBJS = "USER_OBJS";
    protected static final String OIPUS = "OIPUS";
    protected static final String OIPUV = "OIPUV";
    protected static final String _QUOTED = "_QUOTED";
    protected static final String _OS_FORMAT = "_OS_FORMAT";
    protected static final String LIBS_VARIABLE = "LIBS";
    protected static final String USER_OBJS_QUOTED = "USER_OBJS_QUOTED";
    protected static final String LIBS_VARIABLE_QUOTED = "LIBS_QUOTED";
    protected static final String DEPS = "_DEPS_";
    public static final String EMPTY_STRING = new String();
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final String EXPLICIT_DEPENDENCIES = "explicit-dependencies";
    protected static final String WARNING_MESSAGES = "warning-messages";
    static final String MAKEFILE_WARNING_MESSAGE = "CoreIDEMakefileGenerator.warning.message";
    protected IProject project;
    protected IPath topBuildPath = null;
    protected IPath topBuildLocation = null;
    protected String buildTargetName;
    protected String buildTargetExt;
    protected IConfiguration config;
    protected IBuilder builder;
    protected MakefileGeneratorResources resourceLists = new MakefileGeneratorResources();
    private ICSourceEntry[] srcEntries;
    protected List<IPath> absoluteDependencies = new ArrayList<IPath>();
    protected List<IPath> exceedinglyLongPaths = new ArrayList<IPath>();
    private IProgressMonitor monitor;
    private static MessageConsole sConsole = null;

    protected void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected void cancel(String message) {
        if (this.getMonitor() != null && !this.getMonitor().isCanceled()) {
            throw new OperationCanceledException(message);
        }
    }

    protected void checkCancel() {
        if (this.getMonitor() != null && this.getMonitor().isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void updateMonitor() {
        if (this.getMonitor() != null && !this.getMonitor().isCanceled()) {
            this.getMonitor().worked(1);
        }
    }

    protected void updateMonitor(String msg) {
        if (this.getMonitor() != null && !this.getMonitor().isCanceled()) {
            this.monitor.subTask(msg);
            this.getMonitor().worked(1);
        }
    }

    private static IPath getBuildWorkingDirLocationStatic(IBuilder builder) {
        IConfiguration config = ((Builder)builder).getConfguration();
        IProject project = config.getOwner().getProject();
        String attribute = ((Builder)builder).getBuildPathAttribute();
        if (attribute != null) {
            IPath projectLocation;
            attribute = BaseMakefileGenerator.resolveValueToMakefileFormat(attribute, builder.getParent().getParent());
            IPath buildLocation = Path.fromOSString((String)attribute);
            if (attribute.length() == 0) {
                buildLocation = project.getLocation().append(config.getName());
            }
            if (!(projectLocation = project.getLocation()).isPrefixOf(buildLocation)) {
                String folderName = "build-" + project.getName() + "-" + config.getName();
                buildLocation = buildLocation.append(folderName);
            }
            return buildLocation;
        }
        return null;
    }

    protected IContainer getTopBuildFolder() {
        if (this.topBuildPath.segmentCount() == 1) {
            return this.project.getWorkspace().getRoot().getProject(this.topBuildPath.lastSegment());
        }
        return this.project.getParent().getFolder(this.topBuildPath);
    }

    protected IPath inFullPathFromOutFullPath(IPath path) {
        IPath inPath = null;
        if (this.topBuildPath.isPrefixOf(path)) {
            inPath = path.removeFirstSegments(this.topBuildPath.segmentCount());
            inPath = this.project.getFullPath().append(path);
        }
        return inPath;
    }

    protected void createOutputDirectory() {
        IPath buildOutputDirectory = Path.fromOSString((String)this.getBuildTargetName());
        if (!buildOutputDirectory.isAbsolute()) {
            buildOutputDirectory = this.topBuildLocation.append(this.getBuildTargetName());
        }
        buildOutputDirectory = buildOutputDirectory.removeLastSegments(1);
        try {
            buildOutputDirectory.toFile().mkdirs();
        }
        catch (RuntimeException runtimeException) {}
    }

    protected IPath createBuildDirectory() {
        try {
            IPath buildLocation = this.builder.getBuildLocation();
            IPath projectLocation = this.project.getLocation();
            if (buildLocation.toOSString().length() == 0) {
                buildLocation = projectLocation.append(this.getConfig().getName());
            }
            if (projectLocation.isPrefixOf(buildLocation)) {
                IPath p2;
                Object newPath = null;
                IPath p1 = PathUtil.getCanonicalPath((IPath)projectLocation);
                if (!p1.equals((Object)(p2 = PathUtil.getCanonicalPath((IPath)buildLocation)))) {
                    int count;
                    int i = count = buildLocation.matchingFirstSegments(projectLocation);
                    while (i < buildLocation.segmentCount()) {
                        newPath = i == count ? new Path(buildLocation.segment(i)) : newPath.append(buildLocation.segment(i));
                        ++i;
                    }
                    IFolder folder = this.project.getFolder(buildLocation.removeFirstSegments(projectLocation.segmentCount()));
                    if (folder.exists() && folder.isLinked()) {
                        folder.delete(true, null);
                    }
                }
                return newPath == null ? this.project.getFullPath() : this.createDirectory(newPath.toString());
            }
            String folderName = "build-" + this.project.getName() + "-" + this.getConfig().getName();
            buildLocation = buildLocation.append(folderName);
            IFolder folder = this.project.getFolder(this.getConfig().getName());
            if (folder.exists() && !FSLPathUtil.pathEquals(folder.getLocation(), buildLocation)) {
                folder.delete(true, null);
            }
            if (!buildLocation.toFile().exists()) {
                buildLocation.toFile().mkdirs();
            }
            if (!folder.exists()) {
                folder.createLink(this.createRelativeLocation(buildLocation), 0, (IProgressMonitor)new NullProgressMonitor());
            }
            if (!folder.isDerived()) {
                folder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            }
            return folder.getFullPath();
        }
        catch (CoreException coreException) {
            return this.project.getFolder(this.getConfig().getName()).getFullPath();
        }
    }

    IPath createDirectory(String dirName) throws CoreException {
        Path dirPath = new Path(dirName);
        IFolder folder = null;
        if (dirPath.isAbsolute()) {
            IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
            IContainer[] newFolders = root.findContainersForLocationURI(URIUtil.toURI((IPath)dirPath));
            IContainer newFolder = this.chooseFolder(newFolders);
            if (newFolder != null && newFolder.getType() == 2) {
                folder = (IFolder)newFolder;
            } else {
                IPath createdParentPath;
                IFolder parentFolder;
                IPath parentPath = dirPath.removeLastSegments(1);
                if (!parentPath.isEmpty() && (parentFolder = this.project.getFolder(createdParentPath = this.createDirectory(parentPath.toString()))).exists()) {
                    folder = parentFolder.getFolder(dirPath.lastSegment());
                }
            }
        }
        if (folder == null) {
            folder = this.project.getFolder(dirName);
        }
        if (!folder.exists()) {
            IFolder parent;
            IPath parentPath = folder.getProjectRelativePath().removeLastSegments(1);
            if (!parentPath.isEmpty() && !(parent = this.project.getFolder(parentPath)).exists()) {
                this.createDirectory(parentPath.toString());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
            if (!folder.isDerived()) {
                folder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        return folder.getFullPath();
    }

    private IContainer chooseFolder(IContainer[] newFolders) {
        if (newFolders.length > 0) {
            int i = 0;
            while (i < newFolders.length) {
                if (this.topBuildPath.isPrefixOf(newFolders[i].getFullPath())) {
                    return newFolders[i];
                }
                ++i;
            }
            return newFolders[0];
        }
        return null;
    }

    protected IPath createRelativeLocation(IPath location) {
        try {
            URI newLocURI = this.project.getPathVariableManager().convertToRelative(URIUtil.toURI((IPath)location), true, null);
            if (newLocURI != null) {
                IPath newLocation = URIUtil.toPath((URI)newLocURI);
                return newLocation;
            }
        }
        catch (CoreException coreException) {}
        return location;
    }

    protected void removeGeneratedDirectory(IContainer subDir) {
        try {
            if (subDir.exists() && subDir.members().length > 0) {
                return;
            }
        }
        catch (CoreException coreException) {}
        IPath moduleRelativePath = subDir.getProjectRelativePath();
        IPath buildRoot = this.getBuildWorkingDir();
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        IFolder folder = this.project.getFolder(moduleOutputPath);
        if (folder.exists()) {
            try {
                folder.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }

    public IPath getTopBuildDir() {
        return this.topBuildLocation;
    }

    public IPath getBuildWorkingDir() {
        if (this.topBuildPath != null) {
            return this.topBuildPath.removeFirstSegments(1);
        }
        return null;
    }

    public IPath getBuildWorkingDirLocation() {
        return this.getBuildWorkingDirLocation(this.builder);
    }

    public IPath getBuildWorkingDirLocation(IBuilder builderArg) {
        if (this.topBuildLocation != null) {
            return this.topBuildLocation;
        }
        return BaseMakefileGenerator.getBuildWorkingDirLocationStatic(builderArg);
    }

    public IProject getProject() {
        return this.project;
    }

    public IFSLBuildProgressMonitor getBuildProgressMonitor(IProgressMonitor monitor, IBuilder builder, IConfiguration bInfo) {
        return new BuildProgressMonitor(monitor, builder, bInfo);
    }

    public String resolveValueToMakefileFormat(String value) {
        return BaseMakefileGenerator.resolveValueToMakefileFormat(value, 3, this.getConfig());
    }

    protected static String resolveValueToMakefileFormat(String value, IConfiguration configuration) {
        return BaseMakefileGenerator.resolveValueToMakefileFormat(value, 3, configuration);
    }

    protected static String resolveValueToMakefileFormat(String value, int contextType, Object contextData) {
        try {
            value = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(value, IToolConstants.EMPTY_STRING, " ", contextType, contextData);
        }
        catch (BuildMacroException e) {
            Activator.log((Exception)((Object)e));
        }
        return value;
    }

    protected static String resolveValue(String value, IConfiguration configuration) {
        return BaseMakefileGenerator.resolveValue(value, 3, configuration);
    }

    protected static String resolveValue(String value, int contextType, Object contextData) {
        try {
            value = ManagedBuildManager.getBuildMacroProvider().resolveValue(value, IToolConstants.EMPTY_STRING, " ", contextType, contextData);
        }
        catch (BuildMacroException e) {
            Activator.log((Exception)((Object)e));
        }
        return value;
    }

    protected IPath getBuildLocationRelativePath(String outputFile) {
        IPath path = Path.fromOSString((String)outputFile);
        if (path.isAbsolute()) {
            return path;
        }
        return this.topBuildLocation.append(outputFile);
    }

    public void setBuildTargetExt(String buildTargetExt) {
        this.buildTargetExt = buildTargetExt;
    }

    public String getBuildTargetExt() {
        return this.buildTargetExt;
    }

    public void setConfig(IConfiguration config) {
        this.config = config;
    }

    public IConfiguration getConfig() {
        return this.config;
    }

    public void setBuildTargetName(String buildTargetName) {
        this.buildTargetName = buildTargetName;
    }

    public String getBuildTargetName() {
        return this.buildTargetName;
    }

    protected boolean isSource(IPath path) {
        return !CDataUtil.isExcluded((IPath)path, (ICSourceEntry[])this.srcEntries);
    }

    protected boolean generateSourceOutputNameMap(IResource[] resources, HashMap<String, String> sourceOutputMap, IResourceInfoProxy resourceInfoProxy) {
        Hashtable<String, Integer> outputNamesMap = new Hashtable<String, Integer>();
        IPath[] sourceLocations = new IPath[resources.length];
        boolean[] shouldResolveConflicts = new boolean[resources.length];
        String[] fileNames = new String[resources.length];
        String[] optDotExts = new String[resources.length];
        boolean isConflicting = false;
        int i = 0;
        while (i < resources.length) {
            IPath rcProjRelPath;
            IResource resource = resources[i];
            if (resource.getType() == 1 && this.isSource(rcProjRelPath = resource.getProjectRelativePath())) {
                ITool tool;
                String inputExtension;
                sourceLocations[i] = resource.getLocation();
                IResourceInfo rcInfo = resourceInfoProxy.getResourceInfo(resource);
                if (sourceLocations[i] != null && (inputExtension = sourceLocations[i].getFileExtension()) != null && (tool = this.getToolToInvoke(rcInfo, inputExtension)) != null) {
                    shouldResolveConflicts[i] = true;
                    Vector<IPath> relativeOutputLocations = this.getRelativeOutputLocations(resource, tool, false);
                    String outputExtension = relativeOutputLocations.get(0).getFileExtension();
                    fileNames[i] = relativeOutputLocations.get(0).removeFileExtension().lastSegment();
                    optDotExts[i] = EMPTY_STRING;
                    if (outputExtension != null && outputExtension.length() > 0) {
                        optDotExts[i] = "." + outputExtension;
                    }
                    this.recordOutputNameOccurance(outputNamesMap, String.valueOf(fileNames[i]) + optDotExts[i]);
                }
            }
            ++i;
        }
        i = 0;
        while (i < resources.length) {
            if (shouldResolveConflicts[i]) {
                String outputName = fileNames[i];
                String key = String.valueOf(outputName) + optDotExts[i];
                Integer count = (Integer)outputNamesMap.get(key);
                if (count != null && count > 1) {
                    String qualifiedFileName;
                    outputName = qualifiedFileName = sourceLocations[i].lastSegment().replace(".", "_");
                    isConflicting = true;
                    int increment = 1;
                    while (outputNamesMap.contains(String.valueOf(outputName) + optDotExts[i])) {
                        outputName = String.valueOf(qualifiedFileName) + increment;
                        ++increment;
                    }
                }
                this.recordOutputNameOccurance(outputNamesMap, String.valueOf(outputName) + optDotExts[i]);
                sourceOutputMap.put(sourceLocations[i].toString(), outputName);
            }
            ++i;
        }
        return isConflicting;
    }

    private void recordOutputNameOccurance(Hashtable<String, Integer> outputNamesMap, String key) {
        Integer count = outputNamesMap.get(key);
        if (count != null) {
            outputNamesMap.put(key, count + 1);
        } else {
            outputNamesMap.put(key, 1);
        }
    }

    protected ITool getToolToInvoke(IResourceInfo rcInfo, String inputExtension) {
        ITool tool = null;
        if (rcInfo instanceof IFileInfo) {
            IFileInfo fi = (IFileInfo)rcInfo;
            ITool[] tools = fi.getToolsToInvoke();
            if (tools != null && tools.length > 0) {
                tool = tools[0];
            }
        } else {
            IFolderInfo foInfo = (IFolderInfo)rcInfo;
            tool = foInfo.getToolFromInputExtension(inputExtension);
        }
        return tool;
    }

    public String getOutputNameForResource(IResource file, ITool tool) {
        return this.getRelativeOutputLocations(file, tool).get(0).toString();
    }

    public Vector<IPath> getRelativeOutputLocations(IResource file, ITool tool) {
        return this.getRelativeOutputLocations(file, tool, true);
    }

    public Vector<IPath> getRelativeOutputLocations(IResource file, ITool tool, boolean resolveConflicts) {
        boolean containsConflictingOutputNames;
        Vector<IPath> ruleOutputs = new Vector<IPath>();
        IResource[] siblings = new IResource[]{};
        try {
            if (file.getParent().exists()) {
                siblings = file.getParent().members();
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        String outputNameHint = null;
        HashMap<String, String> sourceOutputMap = new HashMap<String, String>();
        if (resolveConflicts && (containsConflictingOutputNames = this.generateSourceOutputNameMap(siblings, sourceOutputMap, new IResourceInfoProxy(){

            @Override
            public IResourceInfo getResourceInfo(IResource resource) {
                return BaseMakefileGenerator.this.getConfig().getResourceInfo(resource.getProjectRelativePath(), false);
            }
        }))) {
            outputNameHint = sourceOutputMap.get(file.getLocation().toString());
        }
        Vector<IPath> enumeratedPrimaryOutputs = new Vector<IPath>();
        Vector<IPath> enumeratedSecondaryOutputs = new Vector<IPath>();
        String relativePath = String.valueOf(file.getProjectRelativePath().removeLastSegments(1).toString()) + "/";
        this.calculateOutputsForSource(tool, relativePath, file, file.getLocation(), ruleOutputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs, outputNameHint);
        if (enumeratedPrimaryOutputs.size() > 0) {
            return enumeratedPrimaryOutputs;
        }
        IPath path = new Path(relativePath).append(ToolProxy.getDefaultOutputName(tool, file.getLocation()));
        Vector<IPath> paths = new Vector<IPath>();
        paths.add(path);
        return paths;
    }

    protected void calculateOutputsForSource(ITool tool, String relativePath, IResource resource, IPath sourceLocation, Vector<IPath> ruleOutputs, Vector<IPath> enumeratedPrimaryOutputs, Vector<IPath> enumeratedSecondaryOutputs, String outputNameHint) {
        IOutputType[] outTypes;
        String inExt = sourceLocation.getFileExtension();
        String outExt = tool.getOutputExtension(inExt);
        if ((outExt == null || outExt.length() == 0) && tool.getPrimaryOutputType() != null && tool.getPrimaryOutputType().getOutputExtensionsAttribute() != null && tool.getPrimaryOutputType().getOutputExtensionsAttribute().length > 0) {
            outExt = tool.getPrimaryOutputType().getOutputExtensionsAttribute()[0];
        }
        boolean useExplicitFileName = false;
        if (outputNameHint != null) {
            sourceLocation = this.replacePathName(sourceLocation, outputNameHint);
        }
        if ((outTypes = tool.getOutputTypes()) != null && outTypes.length > 0) {
            int i = 0;
            while (i < outTypes.length) {
                IPath outPath;
                IPath oPath;
                IOutputType type = outTypes[i];
                boolean primaryOutput = type == tool.getPrimaryOutputType();
                String outputPrefix = type.getOutputPrefix();
                outputPrefix = FSLPathUtil.containsSpecialCharacters(sourceLocation.toString()) ? BaseMakefileGenerator.resolveValue(outputPrefix, this.getConfig()) : BaseMakefileGenerator.resolveValueToMakefileFormat(outputPrefix, this.getConfig());
                boolean multOfType = type.getMultipleOfType();
                IOption option = tool.getOptionBySuperClassId(type.getOptionId());
                IManagedOutputNameProvider nameProvider = type.getNameProvider();
                String[] outputNames = type.getOutputNames();
                FileContextData fileContextData = new FileContextData(sourceLocation, null, option, (IBuildObject)tool);
                if (option != null) {
                    try {
                        int j;
                        List<String> outputList = new ArrayList<String>();
                        int optType = option.getValueType();
                        if (optType == 2) {
                            outputList.add(String.valueOf(outputPrefix) + option.getStringValue());
                        } else if (optType == 3 || optType == 6 || optType == 7 || optType == 8 || optType == 9 || optType == 10 || optType == 11) {
                            outputList = (List)option.getValue();
                            ((Tool)tool).filterValues(optType, outputList);
                            if (outputPrefix.length() > 0) {
                                j = 0;
                                while (j < outputList.size()) {
                                    outputList.set(j, String.valueOf(outputPrefix) + (String)outputList.get(j));
                                    ++j;
                                }
                            }
                        }
                        j = 0;
                        while (j < outputList.size()) {
                            IPath outPath2;
                            String outputName = (String)outputList.get(j);
                            String resolved = null;
                            resolved = FSLPathUtil.containsSpecialCharacters(sourceLocation.toString()) ? BaseMakefileGenerator.resolveValue(outputName, 1, fileContextData) : BaseMakefileGenerator.resolveValueToMakefileFormat(outputName, 1, fileContextData);
                            if ((resolved = resolved.trim()).length() > 0) {
                                outputName = resolved;
                            }
                            if ((outPath2 = Path.fromOSString((String)outputName)).segmentCount() == 1) {
                                outPath2 = Path.fromOSString((String)(String.valueOf(relativePath) + (String)outputList.get(j)));
                            }
                            oPath = MakefileGeneratorUtil.resolvePercent(outPath2, sourceLocation);
                            if (primaryOutput) {
                                if (useExplicitFileName) {
                                    ruleOutputs.add(j, oPath);
                                } else {
                                    ruleOutputs.add(j, outPath2);
                                }
                                enumeratedPrimaryOutputs.add(j, oPath);
                            } else {
                                if (useExplicitFileName) {
                                    ruleOutputs.add(oPath);
                                } else {
                                    ruleOutputs.add(outPath2);
                                }
                                enumeratedSecondaryOutputs.add(oPath);
                            }
                            ++j;
                        }
                    }
                    catch (BuildException buildException) {}
                } else if (nameProvider != null) {
                    IPath[] outPaths;
                    IPath[] inPaths = new IPath[]{sourceLocation};
                    if (nameProvider instanceof IFSLManagedOutputNameProvider2 && outputNameHint != null) {
                        String[] outNameHints = new String[]{outputNameHint};
                        outPaths = ((IFSLManagedOutputNameProvider2)nameProvider).getOutputNames(tool, inPaths, outNameHints);
                    } else {
                        outPaths = nameProvider.getOutputNames(tool, inPaths);
                    }
                    int j = 0;
                    while (j < outPaths.length) {
                        outPath = outPaths[j];
                        String outputName = outPaths[j].toString();
                        String resolved = null;
                        resolved = FSLPathUtil.containsSpecialCharacters(sourceLocation.toString()) ? BaseMakefileGenerator.resolveValue(outputName, 1, fileContextData) : BaseMakefileGenerator.resolveValueToMakefileFormat(outputName, 1, fileContextData);
                        if ((resolved = resolved.trim()).length() > 0) {
                            outputName = resolved;
                        }
                        if (outPath.segmentCount() == 1) {
                            outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPath.toString()));
                        }
                        oPath = MakefileGeneratorUtil.resolvePercent(outPath, sourceLocation);
                        if (primaryOutput) {
                            if (useExplicitFileName) {
                                ruleOutputs.add(j, oPath);
                            } else {
                                ruleOutputs.add(j, outPath);
                            }
                            enumeratedPrimaryOutputs.add(j, oPath);
                        } else {
                            if (useExplicitFileName) {
                                ruleOutputs.add(oPath);
                            } else {
                                ruleOutputs.add(outPath);
                            }
                            enumeratedSecondaryOutputs.add(oPath);
                        }
                        ++j;
                    }
                } else if (outputNames != null) {
                    int j = 0;
                    while (j < outputNames.length) {
                        String outputName = outputNames[j];
                        String resolved = BaseMakefileGenerator.resolveValueToMakefileFormat(outputName, 1, fileContextData);
                        if ((resolved = resolved.trim()).length() > 0) {
                            outputName = resolved;
                        }
                        if ((outPath = Path.fromOSString((String)outputName)).segmentCount() == 1) {
                            outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPath.toString()));
                        }
                        IPath oPath2 = MakefileGeneratorUtil.resolvePercent(outPath, sourceLocation);
                        if (primaryOutput) {
                            if (useExplicitFileName) {
                                ruleOutputs.add(j, oPath2);
                            } else {
                                ruleOutputs.add(j, outPath);
                            }
                            enumeratedPrimaryOutputs.add(j, oPath2);
                        } else {
                            if (useExplicitFileName) {
                                ruleOutputs.add(oPath2);
                            } else {
                                ruleOutputs.add(outPath);
                            }
                            enumeratedSecondaryOutputs.add(oPath2);
                        }
                        ++j;
                    }
                } else if (multOfType) {
                    Activator.log(new IllegalArgumentException("A nameProvider or outputNames must be specified"));
                } else {
                    String namePattern = type.getNamePattern();
                    IPath namePatternPath = null;
                    if (namePattern == null || namePattern.length() == 0) {
                        namePattern = String.valueOf(relativePath) + outputPrefix + "%";
                        if (outExt != null && outExt.length() > 0) {
                            namePattern = String.valueOf(namePattern) + "." + outExt;
                        }
                        namePatternPath = Path.fromOSString((String)namePattern);
                    } else {
                        if (outputPrefix.length() > 0) {
                            namePattern = String.valueOf(outputPrefix) + namePattern;
                        }
                        if ((namePatternPath = Path.fromOSString((String)namePattern)).segmentCount() == 1) {
                            namePatternPath = Path.fromOSString((String)(String.valueOf(relativePath) + namePatternPath.toString()));
                        }
                    }
                    if (MakefileGeneratorUtil.getReplacementFlag(tool) != null) {
                        IPath oPath3 = MakefileGeneratorUtil.resolvePercent(namePatternPath, sourceLocation);
                        if (primaryOutput) {
                            ruleOutputs.add(0, oPath3);
                            enumeratedPrimaryOutputs.add(0, oPath3);
                        } else {
                            ruleOutputs.add(oPath3);
                            enumeratedSecondaryOutputs.add(oPath3);
                        }
                        useExplicitFileName = true;
                    } else if (primaryOutput) {
                        ruleOutputs.add(0, namePatternPath);
                        enumeratedPrimaryOutputs.add(0, MakefileGeneratorUtil.resolvePercent(namePatternPath, sourceLocation));
                    } else {
                        ruleOutputs.add(namePatternPath);
                        enumeratedSecondaryOutputs.add(MakefileGeneratorUtil.resolvePercent(namePatternPath, sourceLocation));
                    }
                }
                ++i;
            }
        } else {
            String outPrefix = tool.getOutputPrefix();
            IPath outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPrefix + "%"));
            outPath = outPath.addFileExtension(outExt);
            ruleOutputs.add(0, outPath);
            enumeratedPrimaryOutputs.add(0, MakefileGeneratorUtil.resolvePercent(outPath, sourceLocation));
        }
    }

    protected IPath replacePathName(IPath sourceLocation, String newFileName) {
        String extension = sourceLocation.getFileExtension();
        if (extension != null && extension.length() > 0) {
            newFileName = String.valueOf(newFileName) + "." + extension;
        }
        sourceLocation = sourceLocation.removeLastSegments(1).append(newFileName);
        return sourceLocation;
    }

    public void initialize(IProject project) {
        this.project = project;
        try {
            project.accept(new IResourceVisitor(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean visit(IResource resource) {
                    if (resource.getType() != 1) {
                        if (resource.getType() != 2) return true;
                        if (!resource.isDerived()) return true;
                        return false;
                    }
                    if (resource.isDerived()) return false;
                    BaseMakefileGenerator.this.resourceLists.getProjectResources().add(resource);
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            this.resourceLists.getProjectResources().clear();
        }
    }

    public void initialize(IConfiguration cfg, IBuilder builder, IProgressMonitor monitor) {
        IProject proj = cfg.getOwner().getProject();
        this.initialize(proj);
        if (builder == null) {
            builder = cfg.getEditableBuilder();
        }
        this.setMonitor(monitor);
        this.setBuildTargetName(FSLPathUtil.removeQuotes(cfg.getArtifactName()));
        this.setBuildTargetExt(FSLPathUtil.removeQuotes(cfg.getArtifactExtension()));
        this.setBuildTargetExt(BaseMakefileGenerator.resolveValueToMakefileFormat(this.getBuildTargetExt(), builder.getParent().getParent()));
        String resolved = BaseMakefileGenerator.resolveValueToMakefileFormat(this.getBuildTargetName(), builder.getParent().getParent());
        if (resolved != null && (resolved = resolved.trim()).length() > 0) {
            this.setBuildTargetName(resolved);
        }
        if (this.getBuildTargetExt() == null) {
            this.setBuildTargetExt(new String());
        }
        this.setConfig(cfg);
        this.builder = builder;
        this.topBuildPath = this.project.getFolder(cfg.getName()).getFullPath();
        this.topBuildLocation = this.getTopBuildFolder().getLocation();
        this.srcEntries = this.getConfig().getSourceEntries();
        if (this.srcEntries.length == 0) {
            this.srcEntries = new ICSourceEntry[]{new CSourceEntry((IPath)Path.EMPTY, null, 24)};
        } else {
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)this.getConfig());
            this.srcEntries = CDataUtil.resolveEntries((ICSourceEntry[])this.srcEntries, (ICConfigurationDescription)cfgDes);
        }
    }

    public String[] getFullPathOutputFiles(IBuilder inBuilder, IConfiguration inConfig) {
        if (this.topBuildLocation == null) {
            this.initialize(inConfig, inBuilder, (IProgressMonitor)new NullProgressMonitor());
            if (this.topBuildLocation == null) {
                return null;
            }
        }
        String depTarget = FSLPathUtil.removeQuotes(inConfig.getArtifactName());
        String depExt = FSLPathUtil.removeQuotes(inConfig.getArtifactExtension());
        String resolved = null;
        if (depExt == null) {
            depExt = new String();
        } else {
            resolved = BaseMakefileGenerator.resolveValueToMakefileFormat(depExt, this.getConfig());
            if (resolved != null && (resolved = resolved.trim()).length() > 0) {
                depExt = resolved;
            }
        }
        resolved = BaseMakefileGenerator.resolveValueToMakefileFormat(depTarget, this.getConfig());
        if (resolved != null && (resolved = resolved.trim()).length() > 0) {
            depTarget = resolved;
        }
        String depPrefix = inConfig.getOutputPrefix(depExt);
        String outputFile = BaseMakefileGenerator.resolveValueToMakefileFormat(String.valueOf(depPrefix) + depTarget, this.getConfig());
        if (depExt.length() > 0) {
            outputFile = String.valueOf(outputFile) + "." + depExt;
        }
        ArrayList<String> fileList = new ArrayList<String>();
        IPath mainOutputFile = this.getBuildLocationRelativePath(outputFile);
        fileList.add(mainOutputFile.toOSString());
        IMakefileGeneratorContributor[] contributors = MakefileGeneratorUtil.getContributors(inConfig);
        if (contributors != null && contributors.length > 0) {
            IMakefileGeneratorContributor[] iMakefileGeneratorContributorArray = contributors;
            int n = contributors.length;
            int n2 = 0;
            while (n2 < n) {
                IMakefileGeneratorContributor contributor = iMakefileGeneratorContributorArray[n2];
                if (contributor != null) {
                    try {
                        IPath[] results;
                        IPath[] iPathArray = results = ((IMakefileGeneratorContributor2)contributor).getAdditionalOutputFiles(mainOutputFile, inBuilder, inConfig);
                        int n3 = results.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPath result = iPathArray[n4];
                            fileList.add(this.getBuildLocationRelativePath(result.toOSString()).toOSString());
                            ++n4;
                        }
                    }
                    catch (IMakefileGeneratorContributor.NotImplementedException notImplementedException) {}
                }
                ++n2;
            }
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    public void postBuildProcess(IBuilder builder, IConfiguration info) {
        String[] fullPaths;
        String[] stringArray = fullPaths = this.getFullPathOutputFiles(builder, info);
        int n = fullPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IFile buildTargetLink;
            String path = stringArray[n2];
            Path buildTargetLocation = new Path(path);
            IPath buildWorkingDirLocation = this.getBuildWorkingDirLocation();
            if (!buildWorkingDirLocation.isPrefixOf((IPath)buildTargetLocation) && !(buildTargetLink = this.getTopBuildFolder().getFile(Path.fromOSString((String)buildTargetLocation.lastSegment()))).exists()) {
                try {
                    buildTargetLink.createLink(this.createRelativeLocation((IPath)buildTargetLocation), 16, this.getMonitor());
                }
                catch (CoreException e) {
                    Status warning = new Status(2, "com.nxp.s32ds.ext.cdt.makefilegenerator", e.getLocalizedMessage());
                    Activator.getDefault().getLog().log((IStatus)warning);
                    try {
                        IMarker marker = this.project.createMarker("org.eclipse.cdt.core.indexermarker");
                        marker.setAttribute("message", (Object)e.getLocalizedMessage());
                        marker.setAttribute("severity", 1);
                    }
                    catch (CoreException coreException) {}
                }
            }
            ++n2;
        }
    }

    public void invokeBuilder(IResource[] resourcesToBuild, IConfiguration cfg, boolean initNewConsole, IProgressMonitor monitor) {
        try {
            if (sConsole == null) {
                sConsole = new MessageConsole(FSLMessages.getString("MakefileBuilder_buildSelectedFiles", new Object[0]), null);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{sConsole});
            }
            if (initNewConsole) {
                sConsole.clearConsole();
            }
            sConsole.activate();
            this.builder = cfg.getBuilder();
            int i = 0;
            while (i < resourcesToBuild.length) {
                IResource file = resourcesToBuild[i];
                this.project = file.getProject();
                IPath outDir = this.getBuildWorkingDirLocation();
                MessageConsoleStream stream = sConsole.newMessageStream();
                stream.println(FSLMessages.getString("MakefileBuilder_buildingFile", new Object[]{file.getName()}));
                MakefileGeneratorUtil.removeMarkers(file);
                this.initialize(cfg, this.builder, (IProgressMonitor)new NullProgressMonitor());
                IManagedBuildInfo builderInfo = ManagedBuildManager.getBuildInfo((IResource)this.project);
                if (builderInfo == null) {
                    return;
                }
                ITool tool = builderInfo.getToolFromInputExtension(file.getFileExtension());
                if (tool == null) {
                    return;
                }
                String fileExt = file.getFileExtension();
                String srcMacro = MakefileGeneratorUtil.getSourceMacroName(fileExt).toString();
                String cmdLinePattern = tool.getCommandLinePattern();
                if (cmdLinePattern.indexOf(srcMacro) > 0) {
                    String temp = cmdLinePattern.replace(MakefileGeneratorUtil.createMakefileMacro(srcMacro), EMPTY_STRING);
                    temp = temp.replace(MakefileGeneratorUtil.createMakefileMacro(String.valueOf(srcMacro) + _QUOTED), EMPTY_STRING);
                    tool.setCommandLinePattern(temp);
                }
                this.setConfig(cfg);
                String resourceOutputName = this.getOutputNameForResource(file, tool);
                IPath result = ToolProxy.execute(this.project, tool, file.getLocation(), outDir, outDir, false, MakefileGeneratorUtil.needCmdArray(tool), true, null, tool, stream, EMPTY_STRING, null, resourceOutputName, monitor);
                tool.setCommandLinePattern(cmdLinePattern);
                try {
                    IFolder folder = (IFolder)this.project.getWorkspace().getRoot().findContainersForLocationURI(outDir.toFile().toURI())[0];
                    folder.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (result == null) {
                    return;
                }
                monitor.worked(1);
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    protected void recordAbsoluteDependency(IPath file) {
        this.absoluteDependencies.add(file);
    }

    protected void clearAbsoluteDependencies() {
        this.absoluteDependencies.clear();
    }

    protected void recordExceedinglyLongPath(IPath sourceLocation) {
        this.exceedinglyLongPaths.add(sourceLocation);
    }

    class BuildProgressMonitor
    implements IFSLBuildProgressMonitor {
        IProgressMonitor monitor;
        IBuilder builder;
        IConfiguration configuration;

        public BuildProgressMonitor(IProgressMonitor monitor, IBuilder builder, IConfiguration configuration) {
            this.monitor = monitor;
            this.builder = builder;
            this.configuration = configuration;
            int count = this.getTotalRuleCount();
            monitor.beginTask("Building", count);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int getTotalRuleCount() {
            IPath path = BaseMakefileGenerator.this.getBuildWorkingDirLocation(this.builder);
            if (path == null) {
                path = this.configuration.getOwner().getProject().getLocation();
                if (this.builder.isManagedBuildOn()) {
                    path = path.append(this.configuration.getName());
                }
            }
            path = path.append("makefile");
            try {
                File file = new File(path.toOSString());
                if (!file.exists()) return 1;
                try (FileReader fileReader = new FileReader(file);
                     BufferedReader reader = new BufferedReader(fileReader);){
                    String line = reader.readLine();
                    while (true) {
                        if (line == null) {
                            return 1;
                        }
                        if (line.contains(BaseMakefileGenerator.TOTAL_RULE_COUNT)) {
                            line = line.substring(line.indexOf(BaseMakefileGenerator.TOTAL_RULE_COUNT) + BaseMakefileGenerator.TOTAL_RULE_COUNT.length());
                            int n = Integer.parseInt(line);
                            return n;
                        }
                        line = reader.readLine();
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return 1;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return 1;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return 1;
        }

        @Override
        public void processLine(String line) {
            if (line.contains(BaseMakefileGenerator.EXECUTING_TARGET)) {
                String fileName = this.extractFileName(line);
                if (fileName != null) {
                    this.monitor.subTask(NLS.bind((String)FSLMessages.getString("CoreIDEMakefileGenerator.message.building"), (Object)fileName));
                }
                this.monitor.worked(1);
            }
        }

        private String extractFileName(String line) {
            int whiteSpaceIndex = (line = line.substring(line.indexOf(BaseMakefileGenerator.EXECUTING_TARGET) + BaseMakefileGenerator.EXECUTING_TARGET.length())).indexOf(" ");
            if (whiteSpaceIndex != -1) {
                String fileName = line.substring(whiteSpaceIndex + 1);
                if (fileName.contains("/")) {
                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                }
                if (fileName.contains("\\")) {
                    fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
                }
                return fileName;
            }
            return null;
        }

        @Override
        public void done() {
            this.monitor.done();
        }
    }

    static interface IResourceInfoProxy {
        public IResourceInfo getResourceInfo(IResource var1);
    }
}

