/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.makefilegenerator;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.ui.console.MessageConsoleStream;

public class ToolOutputReader
extends Thread {
    private OutputStream mDataOutputStream;
    private InputStream mInputStream;
    private OutputStream mErrorParser;
    private MessageConsoleStream mConsoleOut;
    private AtomicBoolean mbHasOutput;
    private String mConsoleFilter;
    StringBuffer mPendingConsoleOutput = new StringBuffer();
    public static final byte LINE_SEPARATOR;
    private static final int BUFFER_SIZE = 64;
    private static final int AGGREGATED_BUFFER_SIZE = 512;

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n".getBytes()[0] : s.getBytes()[0];
    }

    public ToolOutputReader(InputStream instream, MessageConsoleStream consoleOut, OutputStream errManager) {
        this(instream, consoleOut, errManager, null);
    }

    public ToolOutputReader(InputStream instream, MessageConsoleStream consoleOut, OutputStream errManager, String consoleFilter) {
        this.mInputStream = instream;
        this.mErrorParser = errManager;
        this.mConsoleOut = consoleOut;
        this.mConsoleFilter = consoleFilter;
        this.mDataOutputStream = new ByteArrayOutputStream();
        this.mbHasOutput = new AtomicBoolean(false);
    }

    public void setDataOuputStream(OutputStream stream) {
        this.mDataOutputStream = stream;
    }

    public boolean hasOutput() {
        return this.mbHasOutput.get();
    }

    public String getString() {
        if (this.mDataOutputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.mDataOutputStream).toString();
        }
        return null;
    }

    private boolean readLine(ReadContext context, Buffer buffer) throws IOException {
        int readCount = 0;
        try {
            byte c = context.get();
            while (c >= 0) {
                char ch = (char)c;
                if (ch == '\r') {
                    c = context.get();
                    ch = (char)c;
                    if (ch != '\n') {
                        context.revert();
                    }
                } else if (ch != '\n') {
                    buffer.put(c);
                    ++readCount;
                    c = context.get();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            return readCount > 0;
        }
        return true;
    }

    public boolean writeToConsole(String line) {
        if (this.mConsoleOut != null) {
            this.mConsoleOut.println(line);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLine(Buffer line) throws IOException {
        if (!this.mbHasOutput.get()) {
            this.mbHasOutput.set(true);
        }
        byte[] array = line.array();
        int size = line.size();
        this.mDataOutputStream.write(array, 0, size);
        if (this.mErrorParser != null) {
            this.mErrorParser.write(array, 0, size);
        }
        String string = new String(array, 0, size);
        this.mPendingConsoleOutput.append(string);
        if (this.mConsoleFilter == null || !string.contains(this.mConsoleFilter)) {
            OutputStream outputStream = this.mDataOutputStream;
            synchronized (outputStream) {
                if (this.writeToConsole(this.mPendingConsoleOutput.toString())) {
                    this.mPendingConsoleOutput = new StringBuffer();
                }
            }
        }
    }

    public String getPendingText() {
        return this.mPendingConsoleOutput.toString();
    }

    @Override
    public void run() {
        ReadContext readContext = new ReadContext(this.mInputStream);
        Buffer agregatedBuffer = new Buffer();
        int maximumAggregatedBufferSize = this.mConsoleFilter != null ? 0 : 512;
        try {
            while (this.readLine(readContext, agregatedBuffer)) {
                agregatedBuffer.put(LINE_SEPARATOR);
                if (agregatedBuffer.size() <= maximumAggregatedBufferSize) continue;
                this.processLine(agregatedBuffer);
                agregatedBuffer = new Buffer();
            }
        }
        catch (Throwable throwable) {}
        if (agregatedBuffer.size() > 0) {
            try {
                this.processLine(agregatedBuffer);
            }
            catch (IOException iOException) {}
        }
        try {
            this.mInputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static class Buffer {
        private byte[] buffer = new byte[640];
        private int size = 0;

        public byte[] array() {
            return this.buffer;
        }

        public void put(byte b) {
            this.buffer[this.size++] = b;
            if (this.size == this.buffer.length) {
                this.growBuffer();
            }
        }

        public void put(byte[] array) {
            this.put(array, 0, array.length);
        }

        public void put(byte[] array, int offset, int count) {
            this.size += count;
            while (this.size > this.buffer.length) {
                this.growBuffer();
            }
            System.arraycopy(array, 0, this.buffer, this.size - count, count);
        }

        private void growBuffer() {
            byte[] tmp = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            this.buffer = tmp;
        }

        public int size() {
            return this.size;
        }
    }

    static class ReadContext {
        private InputStream mInputStream;
        private byte[] lookAheadBuffer = new byte[64];
        private int bufferIndex = 0;
        private int bufferLength = 0;

        public ReadContext(InputStream inputStream) {
            this.mInputStream = inputStream;
        }

        public void revert() {
            --this.bufferIndex;
        }

        public byte get() throws IOException {
            if (this.bufferIndex == this.bufferLength) {
                if (this.bufferLength == -1) {
                    throw new EOFException();
                }
                this.bufferLength = this.mInputStream.read(this.lookAheadBuffer);
                if (this.bufferLength == -1) {
                    this.bufferIndex = -1;
                    throw new EOFException();
                }
                this.bufferIndex = 0;
            }
            return this.lookAheadBuffer[this.bufferIndex++];
        }
    }
}

