/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.makefilegenerator;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.Activator;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.FSLMessages;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.FSLPathUtil;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.ToolProxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.core.envvar.EclipseEnvironmentSupplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class VariableRegistry {
    private static VariableRegistry sInstance = null;
    static final String ENV_VAR_CW_INSTALL_LOC = "CWInstallLocationEnv";
    static final String ESCAPED = "_ESCAPED";
    TreeMap<String, Variable> fDependencies = new TreeMap();
    TreeMap<String, Variable> fVariables = new TreeMap();
    HashMap<String, String> makeVar = new HashMap();

    public static VariableRegistry getDefault() {
        if (sInstance == null) {
            sInstance = new VariableRegistry();
        }
        return sInstance;
    }

    protected VariableRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.nxp.s32ds.ext.cdt.makefilegenerator.EnvironmentVariableDependency");
        IExtension[] extensions = point.getExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    Variable var;
                    String value;
                    String name;
                    if (elements[j].getName().equals("dependency")) {
                        name = elements[j].getAttribute("name");
                        value = elements[j].getAttribute("value");
                        var = new Variable(name, value);
                        this.fDependencies.put(name, var);
                    }
                    if (elements[j].getName().equals("variable")) {
                        name = elements[j].getAttribute("name");
                        value = elements[j].getAttribute("value");
                        var = new Variable(name, value);
                        this.fVariables.put(name, var);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void verifyDependencies() {
        for (Variable var : this.fDependencies.values()) {
            this.verifyVariableExists(var.name, var.value);
        }
    }

    private void verifyVariableExists(String name, String value) {
        if (this.fVariables.containsKey(name)) {
            return;
        }
        String returnedValue = null;
        EclipseEnvironmentSupplier supplier = new EclipseEnvironmentSupplier();
        IEnvironmentVariable var = supplier.getVariable(name, null);
        if (var == null) {
            var = supplier.getVariable(name.toUpperCase(), null);
        }
        if (var != null) {
            returnedValue = var.getValue();
        }
        if (returnedValue == null || returnedValue.length() == 0) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.nxp.s32ds.ext.cdt.makefilegenerator", NLS.bind((String)FSLMessages.getString("StartupVerification.NotResolved"), (Object)name)));
        } else if (value != null && !returnedValue.equals(value)) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.nxp.s32ds.ext.cdt.makefilegenerator", NLS.bind((String)FSLMessages.getString("StartupVerification.NotCorrectValue"), (Object[])new Object[]{name, value, returnedValue})));
        }
    }

    public String getVariable(String name) {
        Variable var = this.fVariables.get(name);
        if (var != null) {
            return var.value;
        }
        return null;
    }

    public void addVariable(String variable, String value) {
        Variable var = new Variable(variable, value);
        this.fVariables.put(variable, var);
    }

    public String resolveValue(String value) {
        String result = this.resolveMacroRecursive(value);
        while (!result.equals(value)) {
            value = result;
            result = this.resolveMacroRecursive(value);
        }
        return result;
    }

    private String resolveMacroRecursive(String value) {
        if (value.startsWith("${")) {
            int start = value.indexOf("${");
            int end = value.indexOf("}");
            String name = value.substring(start + 2, end);
            String registryValue = VariableRegistry.getDefault().getVariable(name);
            if (registryValue != null) {
                return String.valueOf(value.substring(0, start)) + registryValue + value.substring(end + 1);
            }
            String envVar = System.getenv(name);
            if (envVar == null) {
                envVar = System.getenv(name.toUpperCase());
            }
            if (envVar != null) {
                return String.valueOf(value.substring(0, start)) + envVar + value.substring(end + 1);
            }
            try {
                value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
            }
            catch (CoreException coreException) {}
            return value;
        }
        return value;
    }

    public String convertToRelativeMakefileFormat(String buildCmd, String variableHint, String variableHintValue, StringContainer existingVariables) {
        if (buildCmd == null) {
            return null;
        }
        if (this.fVariables.size() == 0) {
            return buildCmd;
        }
        boolean pathEscaped = FSLPathUtil.isPathEscaped(buildCmd);
        String[] commands = !pathEscaped ? ToolProxy.mergeLinesWithQuotes(buildCmd.split(" ")) : ToolProxy.mergeLinesWithEscape(buildCmd.split(" "));
        if (variableHintValue != null && FSLPathUtil.isPathEscaped(variableHintValue)) {
            variableHintValue = FSLPathUtil.removeEscapeSequence(variableHintValue);
        }
        int i = 0;
        while (i < commands.length) {
            String command = commands[i];
            if (command.indexOf("/") != -1 || command.indexOf("\\") != -1) {
                int d = command.indexOf("\"");
                String leadingFlag = null;
                if (d > 1) {
                    leadingFlag = command.substring(0, d);
                    command = command.substring(d);
                }
                boolean quoted = false;
                if ((command.startsWith("\"") || command.startsWith("'")) && (command.endsWith("\"") || command.endsWith("'"))) {
                    command = command.substring(1, command.length() - 1);
                    quoted = true;
                }
                Path path = new Path(command);
                String usedVar = null;
                String varValue = null;
                if (path.isAbsolute()) {
                    if (variableHint != null) {
                        path = this.makeRelativeToVariable((IPath)path, variableHint, variableHintValue);
                    }
                    String strPath = path.toPortableString();
                    if (path.isAbsolute()) {
                        Iterator<Variable> it = this.fVariables.values().iterator();
                        int maxSegCount = -1;
                        while (it.hasNext()) {
                            int segCount;
                            Variable var = it.next();
                            String value = var.value;
                            Path varPath = new Path(value = this.resolveValue(value));
                            if (!varPath.isPrefixOf((IPath)path) || (segCount = varPath.segmentCount()) <= maxSegCount) continue;
                            maxSegCount = segCount;
                            strPath = this.makeRelativeToVariable((IPath)path, var.name, varPath.toPortableString()).toPortableString();
                            usedVar = var.name;
                        }
                        boolean selfCreatedVar = false;
                        if (new Path(strPath).isAbsolute()) {
                            IPath prefix;
                            if (new Path(strPath = this.checkCWRelative(strPath)).isAbsolute()) {
                                strPath = this.makeRelativeToVariable((IPath)new Path(strPath), "ProjDirPath", null).toPortableString();
                            }
                            if (strPath.startsWith("$(")) {
                                usedVar = strPath.substring(2, strPath.indexOf(")"));
                                selfCreatedVar = true;
                            }
                            if (new Path(strPath).isAbsolute()) {
                                maxSegCount = -1;
                                for (Map.Entry<String, String> pair : this.makeVar.entrySet()) {
                                    int segCount;
                                    Path pairPath = new Path(this.getResolvedPath(pair.getValue()));
                                    if (!pairPath.isPrefixOf((IPath)path) || (segCount = pairPath.segmentCount()) <= maxSegCount) continue;
                                    maxSegCount = segCount;
                                    strPath = this.makeRelativeToVariable((IPath)path, pair.getKey(), pairPath.toPortableString()).toPortableString();
                                    usedVar = pair.getKey();
                                }
                            }
                            if (new Path(strPath).isAbsolute() && (prefix = path.removeLastSegments(1).removeTrailingSeparator()) != null && prefix.lastSegment() != null) {
                                usedVar = this.findUsableVar(prefix.lastSegment().toUpperCase(), prefix.toPortableString(), existingVariables);
                                strPath = this.makeRelativeToVariable((IPath)path, usedVar, prefix.toPortableString()).toPortableString();
                                selfCreatedVar = true;
                            }
                        }
                        if (usedVar != null) {
                            if (!selfCreatedVar) {
                                varValue = new Path(this.resolveValue("${" + usedVar + "}")).toPortableString();
                                if (varValue.equals("${" + usedVar + "}")) {
                                    varValue = this.getResolvedPath("$(" + usedVar + ")");
                                }
                            } else {
                                int segCount = new Path(strPath).segmentCount();
                                varValue = path.removeLastSegments(segCount - 1).toPortableString();
                            }
                        }
                    } else {
                        usedVar = variableHint;
                        varValue = variableHintValue != null ? variableHintValue : this.resolveValue("${" + variableHint + "}");
                    }
                    if (strPath.startsWith("$(")) {
                        int index;
                        if (pathEscaped && (index = varValue.indexOf(" ")) > -1) {
                            usedVar = String.valueOf(usedVar) + ESCAPED;
                            strPath = String.valueOf(strPath.substring(0, strPath.indexOf(")"))) + ESCAPED + strPath.substring(strPath.indexOf(")"));
                            varValue = FSLPathUtil.escapeWhitespaces(varValue);
                        }
                        if (!this.makeVar.containsKey(usedVar)) {
                            varValue = this.checkCWRelative(varValue);
                            this.makeVar.put(usedVar, this.removeLastSlash(varValue));
                        }
                    }
                    commands[i] = leadingFlag == null ? (quoted ? "\"" + strPath + "\"" : strPath) : (quoted ? String.valueOf(leadingFlag) + "\"" + strPath + "\"" : String.valueOf(leadingFlag) + strPath);
                }
            }
            ++i;
        }
        String cmd = null;
        int i2 = 0;
        while (i2 < commands.length) {
            cmd = pathEscaped ? (i2 == 0 ? FSLPathUtil.escapeWhitespaces(commands[i2]) : String.valueOf(cmd) + " " + FSLPathUtil.escapeWhitespaces(commands[i2])) : (i2 == 0 ? commands[i2] : String.valueOf(cmd) + " " + commands[i2]);
            ++i2;
        }
        return cmd;
    }

    private String removeLastSlash(String value) {
        if (value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public HashMap<String, String> getMakeVariables() {
        return this.makeVar;
    }

    private String findUsableVar(String inVar, String value, StringContainer existingVariables) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < inVar.length()) {
            char c = inVar.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                builder.append(c);
            } else {
                builder.append("_");
            }
            ++i;
        }
        String newVar = inVar = builder.toString();
        int counter = this.getNumericSuffix(inVar);
        inVar = this.stripNumericSuffix(inVar);
        while (this.fVariables.containsKey(newVar) || this.makeVar.containsKey(newVar) || this.makeVar.containsKey(String.valueOf(newVar) + ESCAPED) || this.isReservedVariable(newVar) || existingVariables.contains(newVar) || System.getenv(newVar) != null) {
            if (this.makeVar.containsKey(String.valueOf(newVar) + ESCAPED) && !this.makeVar.containsKey(newVar)) {
                String escapeValue = this.getResolvedPath(this.makeVar.get(String.valueOf(newVar) + ESCAPED));
                if ((escapeValue = FSLPathUtil.removeEscapeSequence(escapeValue)).equals(value)) {
                    return newVar;
                }
            }
            newVar = String.valueOf(inVar) + ++counter;
        }
        return newVar;
    }

    private String stripNumericSuffix(String inVar) {
        int i = inVar.length() - 1;
        while (i > 0) {
            if (!Character.isDigit(inVar.charAt(i))) {
                return inVar.substring(0, i + 1);
            }
            --i;
        }
        if (inVar.length() > 0) {
            return inVar.substring(0, 1);
        }
        return inVar;
    }

    private int getNumericSuffix(String inVar) {
        int i = inVar.length() - 1;
        while (i > 0) {
            if (!Character.isDigit(inVar.charAt(i))) {
                if (i >= inVar.length() - 1) break;
                String suffixString = inVar.substring(i + 1);
                try {
                    int suffix = (int)Double.parseDouble(suffixString);
                    return suffix;
                }
                catch (NumberFormatException e) {
                    Activator.log(e);
                    try {
                        return Integer.parseInt(inVar.substring(inVar.length() - 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 1;
                    }
                }
            }
            --i;
        }
        return 0;
    }

    private boolean isReservedVariable(String name) {
        String[] reservedVariableTable;
        String[] stringArray = reservedVariableTable = new String[]{".LIBPATTERNS", ".SHELLFLAGS", ".VARIABLES", "CURDIR", "HOME", "IFS", "LINE", "MAKE", "MAKECMDGOALS", "MAKEFILES", "MAKEFILE_LIST", "MAKEOVERRIDES", "MAKE_COMMAND", "MAKE_VERSION", "MFLAGS", "PATH", "SHELL"};
        int n = reservedVariableTable.length;
        int n2 = 0;
        while (n2 < n) {
            String reservedVariable = stringArray[n2];
            if (name.equals(reservedVariable)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getResolvedPath(String path) {
        String result = path;
        if (result.startsWith("$(")) {
            String macro = result.substring(2, result.indexOf(")"));
            String rest = result.substring(result.indexOf(")") + 1);
            String value = this.makeVar.get(macro);
            if (value == null) {
                return result;
            }
            value = this.getResolvedPath(value);
            result = value.concat(rest);
        }
        return result;
    }

    private String checkCWRelative(String value) {
        Path home = new Path(String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "/..");
        String homeLoc = home.toPortableString();
        String homeLocEscaped = null;
        int index = homeLoc.indexOf(" ");
        if (index > -1) {
            homeLocEscaped = FSLPathUtil.escapeWhitespaces(homeLoc);
        }
        if (value != null && !value.isEmpty()) {
            Path originalPath = new Path(value);
            if (home.isPrefixOf((IPath)originalPath) && !home.equals((Object)originalPath)) {
                int segCount = home.segmentCount();
                Path path = new Path("$(CWInstallLocationEnv)");
                int i = segCount;
                while (i < originalPath.segmentCount()) {
                    path = path.append(originalPath.segment(i));
                    ++i;
                }
                if (!this.makeVar.containsKey(ENV_VAR_CW_INSTALL_LOC)) {
                    this.makeVar.put(ENV_VAR_CW_INSTALL_LOC, this.removeLastSlash(home.toPortableString()));
                }
                value = path.toString();
            } else if (homeLocEscaped != null && value.startsWith(homeLocEscaped) && !value.equals(homeLocEscaped)) {
                value = "$(CWInstallLocationEnv_ESCAPED)" + value.substring(homeLocEscaped.length());
                if (!this.makeVar.containsKey("CWInstallLocationEnv_ESCAPED")) {
                    this.makeVar.put("CWInstallLocationEnv_ESCAPED", this.removeLastSlash(homeLocEscaped));
                }
            }
        }
        return value;
    }

    private IPath makeRelativeToVariable(IPath originalPath, String variable, String value) {
        Path hintValue;
        if (value == null) {
            value = this.resolveValue("${" + variable + "}");
        }
        if (value.equals("${" + variable + "}") && this.makeVar.containsKey(variable)) {
            value = this.makeVar.get(variable);
        }
        IPath path = originalPath;
        if (value != null && !value.isEmpty() && (hintValue = new Path(value)).isPrefixOf(originalPath)) {
            int segCount = hintValue.segmentCount();
            path = new Path("$(" + variable + ")");
            int i = segCount;
            while (i < originalPath.segmentCount()) {
                path = path.append(originalPath.segment(i));
                ++i;
            }
        }
        return path;
    }

    public void cleanUp() {
        this.makeVar.clear();
    }

    public static interface StringContainer {
        public boolean contains(String var1);
    }

    static class Variable {
        String name;
        String value;

        public Variable(String name2, String value2) {
            this.name = name2;
            this.value = value2;
        }
    }
}

