/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.utils;

import com.nxp.s32ds.ext.ide.utils.OSFamily;
import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public final class PreferencesUtils {
    private PreferencesUtils() {
    }

    public static String getPreferenceValueForId(String pluginId, String key, String defaultValue, IProject project) {
        return PreferencesUtils.getPreferenceValueForId(pluginId, key, defaultValue, PreferencesUtils.getPreferenceScopeContexts(project));
    }

    public static String getPreferenceValueForId(String pluginId, String key, String defaultValue, IScopeContext[] contexts) {
        return Stream.of(contexts).map(c -> c.getNode(pluginId).get(key, null)).filter(Objects::nonNull).map(String::trim).filter(FuncUtils.not(String::isEmpty)).findAny().orElse(defaultValue);
    }

    public static IScopeContext[] getPreferenceScopeContexts(IProject project) {
        return (IScopeContext[])Stream.concat(project == null ? Stream.of(new IScopeContext[0]) : Stream.of(new ProjectScope(project)), Stream.of(InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE)).toArray(IScopeContext[]::new);
    }

    public static String getPathSeparator() {
        return OSFamily.WINDOWS.isCurrent() ? ";" : ":";
    }
}

