/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.backend;

import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.core.SPTSettings;
import com.freescale.s32ds.cross.core.model.DefaultWizardValueProvider;
import com.freescale.s32ds.cross.core.model.IModelSDK;
import com.freescale.s32ds.cross.core.model.IWizardValueProvider;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.freescale.s32ds.cross.wizard.EmbSysSettingsUtil;
import com.freescale.s32ds.cross.wizard.IWizardParticipant;
import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardHandler;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.backend.ProjectGenerationContext;
import com.freescale.s32ds.cross.wizard.backend.WizardBackendException;
import com.freescale.s32ds.cross.wizard.backend.WizardUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class WizardBackend {
    private static final String PATH = "PATH";
    private static final String SUFFIX = "_1";
    private GeneralContext currentContext;
    private final LinkedList<ProjectGenerationContext> generatedProjects = new LinkedList();
    private List<IAdaptable> iad;
    private IConfigurationElement fConfigElement;
    public static final String PROJECT_NAME = "projectName";
    public static final String BASE_NAME = "baseName";
    public static final String CORE_NAME = "CORE_PROJECT_NAME";
    public static final String BASE_NAME_LOWER = "baseNameLower";
    public static final String BASE_NAME_UPPER = "baseNameUpper";
    public static final String LOCATION = "location";
    public static final String OP_COPROC_APU = "APU";
    public static final String OP_COPROC_APU_GRAPH = "APU_GRAPH";
    public static final String OP_COPROC_ISP = "ISP";
    public static final String OP_COPROC_ISP_GRAPH = "ISP_GRAPH";
    final List<IWizardParticipant> wizardParticipants = S32DSWizardPlugin.getDefault().getWizardParticipants();

    public void create(GeneralContext context, IRunnableContext container, IProgressMonitor monitor) throws WizardBackendException {
        this.currentContext = context;
        Instant start = Instant.now();
        this.doCheck();
        this.doCreate(container, monitor);
        Instant end = Instant.now();
        Duration timeElapsed = Duration.between(start, end);
        if (EclipseStarter.debug) {
            S32DSWizardPlugin.logWarning("TIME creating: " + (double)timeElapsed.toMillis() / 1000.0 + " seconds");
        }
    }

    private void doCheck() throws WizardBackendException {
        if (this.currentContext.getResultProjectContexts().isEmpty()) {
            throw new WizardBackendException("ResultProjectContexts is empty");
        }
        WizardBackend.checkExistingProject(this.currentContext);
    }

    private void doCreate(IRunnableContext container, IProgressMonitor monitor) throws WizardBackendException {
        this.iad = new ArrayList<IAdaptable>();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        String workingSetName = this.currentContext.isArggregateFolderNeed() ? this.currentContext.getProjectBaseName() : "Other Projects";
        IWorkingSet workingSet = workingSetManager.createWorkingSet(workingSetName, new IAdaptable[0]);
        IWorkingSet[] workingSets = new IWorkingSet[]{workingSet};
        for (ProjectContext pc : this.currentContext.getResultProjectContexts()) {
            this.processProjectContext(container, monitor, workingSets, pc);
        }
        this.getIAd().forEach(a -> workingSetManager.addToWorkingSets(a, workingSets));
        if (workingSetManager.getWorkingSet(workingSet.getName()) == null) {
            workingSetManager.addWorkingSet(workingSet);
        }
        try {
            try {
                container.run(false, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(this.runSetDescriptions(this.currentContext.getResultProjectContexts())));
            }
            catch (InterruptedException | InvocationTargetException e) {
                this.clearProject();
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            S32DSWizardPlugin.log(e);
            if (e instanceof Exception) {
                throw new WizardBackendException((Exception)e);
            }
            throw new WizardBackendException(e.getMessage());
        }
        this.currentContext.reset();
    }

    private void processProjectContext(IRunnableContext container, IProgressMonitor monitor, IWorkingSet[] workingSets, ProjectContext pc) throws WizardBackendException {
        ProjectGenerationContext pgc = ProjectGenerationContext.start(this.currentContext, pc);
        this.generatedProjects.addFirst(pgc);
        IProject newProject = this.createProject(pgc, true, monitor);
        if (newProject == null) {
            S32DSWizardPlugin.logWarning(Messages.S32DSMultiProjectWizard_cannot_create_prj);
            throw new WizardBackendException(Messages.S32DSMultiProjectWizard_cannot_create_prj);
        }
        try {
            try {
                this.applyWizardParticipants(container, workingSets, pc, pgc);
                try {
                    this.setupCDT(newProject);
                    if (pc instanceof CProjectMasterContext) {
                        this.applySDKs(newProject, ((CProjectMasterContext)pc).getSdkList());
                    }
                    WizardBackend.savePrefs(pc, this.currentContext, newProject);
                }
                catch (Exception e) {
                    S32DSWizardPlugin.log(e);
                    throw new WizardBackendException(e);
                }
            }
            catch (Exception e) {
                S32DSWizardPlugin.log(e, String.format(Messages.S32DSMultiProjectWizard_for_subproject, pgc.getProjectName()));
                this.iad.add((IAdaptable)pgc.getProject());
            }
        }
        finally {
            this.iad.add((IAdaptable)pgc.getProject());
        }
    }

    private void applyWizardParticipants(IRunnableContext container, IWorkingSet[] workingSets, ProjectContext pc, ProjectGenerationContext pgc) throws WizardBackendException {
        List<IWizardParticipant> applicableParticipants = this.filterApplicableWizardParticipant(pc);
        for (IWizardParticipant participant : applicableParticipants) {
            WorkspaceModifyOperation operation = participant.participate(pc, pgc.getProject(), workingSets);
            if (operation == null) continue;
            try {
                container.run(false, true, (IRunnableWithProgress)operation);
            }
            catch (Exception e) {
                String message = NLS.bind((String)Messages.S32DSMultiProjectWizard_error_exec, (Object)participant.getId(), (Object)pgc.getProjectName());
                S32DSWizardPlugin.log(e, message);
                throw new WizardBackendException(e);
            }
        }
    }

    private void setupCDT(IProject project) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(project, true);
        if (des != null && des.isCdtProjectCreating()) {
            des = mngr.getProjectDescription(project, true);
            des.setCdtProjectCreated();
            mngr.setProjectDescription(project, des, false, null);
        }
    }

    private void applySDKs(IProject project, List<? extends IModelSDK> sdks) {
        try {
            Map<String, List<ILanguageSettingsProvider>> settings = WizardUtils.removeLanguageSettingsProviders(project);
            sdks.stream().filter(ISDK.class::isInstance).map(ISDK.class::cast).forEach(sdk -> {
                IConfiguration[] cfgs = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
                SDKAttach.attachToProjectConfigurations((ISDK)sdk, Arrays.asList(cfgs), (int)1);
                SDKUtils.openResources((ISDK)sdk, (IProject)project);
            });
            WizardUtils.addLanguageSettingsProviders(settings, project);
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
    }

    private static void savePrefs(ProjectContext pcxt, GeneralContext context, IProject project) {
        ProjectSettings ps = new ProjectSettings(project, "com.freescale.s32ds.cross.wizard");
        if (context.isMulticore()) {
            ps.append("groupName", context.getProjectBaseName());
        }
        String proc = pcxt instanceof CProjectContext ? ((CProjectContext)pcxt).getProcessor().getId() : "";
        String core = pcxt.getStringValue("core");
        String type = pcxt.getStringValue("coreType");
        if (core.isEmpty()) {
            core = String.valueOf(type) + SUFFIX;
        }
        IToolChain toolChain = pcxt instanceof CProjectContext ? ((CProjectContext)pcxt).getToolChain() : null;
        String tcVer = toolChain != null ? toolChain.getVersionsSupported() : "";
        String wizardVer = (String)Platform.getBundle((String)"com.freescale.s32ds.cross.wizard").getHeaders().get("Bundle-Version");
        ps.append("processor", proc).append("core", core).append("coreType", type).append("library", pcxt.getStringValue("library")).append("language", pcxt.getStringValue("language")).append("io", pcxt.getStringValue("io")).append("fpu", pcxt.getStringValue("fpu")).append("flashStart", pcxt.getStringValue("flashStart")).append("flashSize", pcxt.getStringValue("flashSize")).append("ramStart", pcxt.getStringValue("ramStart")).append("ramSize", pcxt.getStringValue("ramSize")).append("pinSet", pcxt.getStringValue("pinSet")).append("toolchainVersion", tcVer).append("wizardVersion", wizardVer).append("productVersion", S32DSWizardPlugin.getProductVersion()).store();
        WizardBackend.saveSptPrefs(pcxt, project);
    }

    private static void saveSptPrefs(ProjectContext pcxt, IProject project) {
        String sptVersion = null;
        SPTSettings.SptKeys[] sptKeysArray = SPTSettings.SptKeys.values();
        int n = sptKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            SPTSettings.SptKeys key = sptKeysArray[n2];
            if (pcxt.getBooleanValue(key.getKey())) {
                sptVersion = key.getValue();
                break;
            }
            ++n2;
        }
        if (sptVersion != null) {
            ProjectSettings sptPrefs = new ProjectSettings(project, "com.nxp.s32ds.cross.wizard.spt");
            sptPrefs.append("sptVersion", sptVersion).store();
        }
    }

    private IProject createProject(ProjectGenerationContext pgc, boolean onFinish, IProgressMonitor monitor) {
        IProgressMonitor fMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        pgc.setProject(null);
        fMonitor.beginTask(CUIPlugin.getResourceString((String)"CProjectWizard.op_description"), 100);
        fMonitor.worked(10);
        try {
            IProject newProject = this.createIProject(pgc, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)fMonitor, (int)40));
            if (newProject != null) {
                pgc.getProjectContext().setProject(newProject);
                if (pgc.getProjectContext() instanceof CProjectContext) {
                    S32DSWizardHandler h = new S32DSWizardHandler("", this, (CProjectContext)pgc.getProjectContext());
                    h.createProject(newProject, true, onFinish, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)fMonitor, (int)40));
                }
            }
            fMonitor.worked(10);
            IProject iProject = newProject;
            return iProject;
        }
        catch (CoreException e) {
            CUIPlugin.log((Throwable)e);
        }
        finally {
            fMonitor.done();
        }
        return null;
    }

    public static void checkExistingProject(GeneralContext currentContext) throws WizardBackendException {
        try {
            for (ProjectContext pc : currentContext.getResultProjectContexts()) {
                String projectLocation = new ProjectGenerationContext(currentContext, pc).getLocation();
                IFileStore fs = EFS.getStore((URI)Paths.get(projectLocation, new String[0]).toUri());
                IFileInfo f = fs.fetchInfo();
                if (!f.exists() || !f.isDirectory() || !fs.getChild(".project").fetchInfo().exists()) continue;
                throw new WizardBackendException(String.valueOf(Messages.S32DSMultiProjectWizard_prj_already_exists) + ": " + pc.getProjectName());
            }
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
            throw new WizardBackendException((Exception)((Object)e));
        }
    }

    public void clearProject() {
        this.generatedProjects.forEach(pgc -> {
            if (pgc.getProjectName() == null) {
                return;
            }
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pgc.getProjectName());
                project.delete(!pgc.isLastProjectLocationExists(), true, null);
            }
            catch (CoreException e) {
                S32DSWizardPlugin.log(e);
            }
        });
    }

    public List<IAdaptable> getIAd() {
        return this.iad;
    }

    private IProject createIProject(ProjectGenerationContext pgc, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("CREATING PROJECT", 100);
        if (pgc.getProject() != null) {
            return pgc.getProject();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject newProjectHandle = root.getProject(pgc.getProjectName());
        if (!newProjectHandle.exists()) {
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            if (pgc.getLocation() != null) {
                description.setLocation((IPath)new Path(pgc.getLocation()));
            } else if (this.currentContext.isArggregateFolderNeed()) {
                Path loc = new Path(String.valueOf(this.getLocation()) + "/" + this.currentContext.getProjectBaseName() + "/" + pgc.getProjectName());
                description.setLocation((IPath)loc);
            }
            pgc.setProject(CCorePlugin.getDefault().createCDTProject(description, newProjectHandle, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)25)));
        } else {
            IWorkspaceRunnable runnable = monitor1 -> newProjectHandle.refreshLocal(2, monitor1);
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)25));
            pgc.setProject(newProjectHandle);
        }
        if (!pgc.getProject().isOpen()) {
            pgc.getProject().open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)25));
        }
        this.setNatures(pgc);
        monitor.done();
        return pgc.getProject();
    }

    private void setNatures(ProjectGenerationContext pgc) {
        if (pgc.getProjectContext() instanceof CProjectContext && ((CProjectContext)pgc.getProjectContext()).getTargetTemplate() == null) {
            try {
                CProjectNature.addCNature((IProject)pgc.getProject(), null);
                CCProjectNature.addCCNature((IProject)pgc.getProject(), null);
            }
            catch (CoreException e) {
                S32DSWizardPlugin.log(e);
            }
        }
    }

    private IRunnableWithProgress runSetDescriptions(List<ProjectContext> resultProjectContexts) {
        return imonitor -> {
            List newProjects = GeneralContext.getProjectsFromContexts((List)resultProjectContexts);
            resultProjectContexts.forEach(projectContext -> {
                IProject currentProject = projectContext.getProject();
                if (currentProject == null) {
                    S32DSWizardPlugin.logWarning(String.format(Messages.S32DSMultiProjectWizard_no_project_for_ctx, projectContext.getContextId()));
                    return;
                }
                try {
                    imonitor.beginTask(String.format(Messages.S32DSMultiProjectWizard_making_refs, currentProject.getName()), 40);
                    LinkedList refsList = new LinkedList(newProjects);
                    refsList.remove(currentProject);
                    imonitor.worked(10);
                    IProject[] refs = refsList.toArray(new IProject[refsList.size()]);
                    WizardBackend.updateProjectDescription(projectContext, refs, imonitor);
                }
                catch (CoreException e) {
                    S32DSWizardPlugin.log(e);
                }
                imonitor.done();
            });
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.getfConfigElement());
        };
    }

    private static void updateProjectDescription(ProjectContext projectContext, IProject[] refs, IProgressMonitor imonitor) throws CoreException {
        Map<Object, Object> refMap;
        if (!(projectContext instanceof CProjectContext)) {
            S32DSWizardPlugin.logWarning(projectContext + " is not " + projectContext);
            return;
        }
        IProject project = projectContext.getProject();
        CProjectContext cProjectContext = (CProjectContext)projectContext;
        boolean autoStart = cProjectContext.isAutoStart();
        CoreModel coreModel = CoreModel.getDefault();
        ICProjectDescription projectDescription = coreModel.getProjectDescription(project);
        Map<Object, Object> map = refMap = autoStart ? WizardBackend.createProjectReferenceMap(refs) : Collections.emptyMap();
        if (projectDescription != null) {
            IContributedEnvironment ice = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
            EmbSysSettingsUtil.setEmbsysDescriptionData(project, autoStart, projectDescription);
            String path = WizardBackend.getVariablesNames(cProjectContext);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDescription.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
                ice.addVariable(PATH, path, 3, File.pathSeparator, cfg);
                if (!refMap.isEmpty()) {
                    Map<String, String> refMapCfg = WizardBackend.createProjectCfgReferenceMap(cfg, refs);
                    if (!refMapCfg.isEmpty()) {
                        cfg.setReferenceInfo(refMapCfg);
                    } else {
                        cfg.setReferenceInfo(refMap);
                    }
                }
                ++n2;
            }
        }
        coreModel.setProjectDescription(project, projectDescription, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)imonitor, (int)10));
    }

    private static Map<String, String> createProjectReferenceMap(IProject[] refs) {
        HashMap<String, String> refMap = new HashMap<String, String>();
        IProject[] iProjectArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IProject ref = iProjectArray[n2];
            refMap.put(ref.getName(), "");
            ++n2;
        }
        return refMap;
    }

    private static String getVariablesNames(CProjectContext projectContext) {
        StringBuilder variableNames = new StringBuilder();
        IStringVariableManager stringVarManager = VariablesPlugin.getDefault().getStringVariableManager();
        for (String var : projectContext.getTemplate().getValueVariables()) {
            IValueVariable vv = stringVarManager.getValueVariable(var);
            if (vv == null || variableNames.toString().contains(vv.getName())) continue;
            variableNames.append("${");
            variableNames.append(vv.getName());
            variableNames.append("}" + File.pathSeparator);
        }
        return variableNames.toString();
    }

    private static Map<String, String> createProjectCfgReferenceMap(ICConfigurationDescription cfg, IProject[] refs) {
        HashMap<String, String> refMap = new HashMap<String, String>();
        String cfgName = cfg.getName();
        String curCfgName = null;
        IProject[] iProjectArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IProject ref = iProjectArray[n2];
            ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(ref);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDescription.getConfigurations();
            int n3 = iCConfigurationDescriptionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ICConfigurationDescription cfgProject = iCConfigurationDescriptionArray[n4];
                if (cfgProject.getName().equalsIgnoreCase(cfgName)) {
                    curCfgName = cfgProject.getId();
                    break;
                }
                ++n4;
            }
            if (curCfgName != null) {
                refMap.put(ref.getName(), curCfgName);
            }
            ++n2;
        }
        return refMap;
    }

    public IConfigurationElement getfConfigElement() {
        return this.fConfigElement;
    }

    public void setfConfigElement(IConfigurationElement fConfigElement) {
        this.fConfigElement = fConfigElement;
    }

    public String getLocation() {
        return this.currentContext.getBaseProjectPath() == null ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() : this.currentContext.getBaseProjectPath();
    }

    public Map<String, String> getProjectData(ProjectContext projectContext) {
        IWizardValueProvider valueProvider;
        HashMap<String, String> data = new HashMap<String, String>();
        if (projectContext == null) {
            S32DSWizardPlugin.logWarning("Context for project not found !");
            return data;
        }
        String projectName = projectContext.getProjectName();
        String baseName = projectName;
        int dot = baseName.lastIndexOf(46);
        if (dot != -1) {
            baseName = baseName.substring(dot + 1);
        }
        if ((dot = baseName.indexOf(32)) != -1) {
            baseName = baseName.substring(0, dot);
        }
        data.put(PROJECT_NAME, projectName);
        data.put(BASE_NAME, baseName);
        data.put(BASE_NAME_UPPER, baseName.toUpperCase());
        data.put(BASE_NAME_LOWER, baseName.toLowerCase());
        String location = ProjectGenerationContext.getLocation(this.currentContext, projectContext);
        data.put(LOCATION, location);
        if (projectContext instanceof CProjectContext) {
            CoreNatureData coreNature = ((CProjectContext)projectContext).getCoreNature();
            data.put(CORE_NAME, coreNature.getSuffix());
            ProcessorData processor = ((CProjectContext)projectContext).getProcessor();
            FamilyData family = ((CProjectContext)projectContext).getFamily();
            WizardBackend.putNotNull(OP_COPROC_APU, projectContext.getStringValue("apuCoProcessorEnable"), data);
            WizardBackend.putNotNull(OP_COPROC_APU_GRAPH, projectContext.getStringValue("apuCoProcessorGraphEnable"), data);
            WizardBackend.putNotNull(OP_COPROC_ISP, projectContext.getStringValue("ispCoProcessorEnable"), data);
            WizardBackend.putNotNull(OP_COPROC_ISP_GRAPH, projectContext.getStringValue("ispCoProcessorGraphEnable"), data);
            WizardBackend.parseParams(family.getStringValue("params"), data);
            WizardBackend.parseParams(processor.getStringValue("params"), data);
            WizardBackend.parseParams(coreNature.getStringValue("params"), data);
        }
        if ((valueProvider = projectContext.getRegistry().getValueProvider()) == null) {
            valueProvider = new DefaultWizardValueProvider();
        }
        data.putAll(valueProvider.createValueMap(projectContext, location));
        return data;
    }

    private static String putNotNull(String key, String value, Map<String, String> data) {
        if (value != null) {
            return data.put(key, value);
        }
        return null;
    }

    private static void parseParams(String parms, Map<String, String> res) {
        if (parms == null) {
            return;
        }
        String[] stringArray = parms.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] ps = s.split("=");
            if (ps.length == 2) {
                String key = ps[0].trim();
                res.put(key, ps[1].trim());
            } else if (s.trim().length() > 0) {
                S32DSWizardPlugin.logWarning("Bad extra parameter: <" + s + "> in " + parms);
            }
            ++n2;
        }
    }

    private List<IWizardParticipant> filterApplicableWizardParticipant(ProjectContext pc) {
        ArrayList<IWizardParticipant> applicableParticipants = new ArrayList<IWizardParticipant>();
        for (IWizardParticipant participant : this.wizardParticipants) {
            boolean applicable = participant.isApplicable(pc);
            if (!applicable) continue;
            applicableParticipants.add(participant);
        }
        return applicableParticipants;
    }
}

