/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.runtime.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class Strings {
    public static String[] toEnvp(Map<String, String> envMap) {
        if (envMap == null) {
            return new String[0];
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        Set<Map.Entry<String, String>> entries = envMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            strings.add(String.valueOf(name) + '=' + value);
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String toLowerCaseUnderscores(String path) {
        if (path == null) {
            return null;
        }
        char[] charArray = path.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (Character.isUpperCase(c)) {
                if (i > 0 && !Character.isLowerCase(charArray[i - 1])) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toUpperCaseUnderscores(String path) {
        if (path == null) {
            return null;
        }
        char[] charArray = path.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (Character.isUpperCase(c)) {
                char prev;
                if (i > 0 && (prev = charArray[i - 1]) != '_' && !Character.isUpperCase(prev)) {
                    sb.append('_');
                }
                sb.append(c);
            } else {
                sb.append(Character.toUpperCase(c));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toCamelCaseUnderscores(String path) {
        if (path == null) {
            return null;
        }
        char[] charArray = path.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (i == 0 || charArray[i - 1] == '_') {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toCamelCaseMember(String path) {
        if (path == null) {
            return null;
        }
        char[] charArray = path.toCharArray();
        boolean raiseChar = false;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (c == '_') {
                raiseChar = true;
            } else {
                char p;
                if (!raiseChar && i > 0 && Character.isLowerCase(p = charArray[i - 1]) && Character.isUpperCase(c)) {
                    raiseChar = true;
                }
                if (raiseChar) {
                    sb.append(Character.toUpperCase(c));
                    raiseChar = false;
                } else {
                    sb.append(Character.toLowerCase(c));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String beforeDot(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        if (index != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    public static String afterDot(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        if (index != -1) {
            return name.substring(index, name.length());
        }
        return name;
    }
}

