/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.model.IModelSDK;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ObjectData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.data.TemplateData;
import com.freescale.s32ds.cross.core.model.registry.ContextDefinition;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.ui.templateengine.Template;

public abstract class CProjectContext
extends ProjectContext {
    private List<? extends IModelSDK> sdkList = Collections.emptyList();
    private boolean active = true;
    private final CoreNatureConfiguration configuration;

    public CProjectContext(CoreNatureConfiguration cConfiguration, ContextDefinition contextDefinition, List<ContextPart> insertionParts, AbstractContext parent) {
        super((ObjectData)cConfiguration.getCoreNature(), contextDefinition, insertionParts, parent, parent.getRegistry());
        this.configuration = cConfiguration;
    }

    public IToolChain getToolChain() {
        return this.configuration != null ? this.configuration.getToolChain() : null;
    }

    public String getToolChainId() {
        IToolChain toolChain = this.getToolChain();
        return toolChain != null ? toolChain.getId() : null;
    }

    public TemplateData getTemplate() {
        return this.configuration != null ? this.configuration.getTemplate() : null;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void reset() {
        this.setActive(this.isEnabledByDefault());
        this.sdkList = Collections.emptyList();
        super.reset();
    }

    @Override
    public boolean isEnabledByDefault() {
        if (this.isAutoStart()) {
            return true;
        }
        return this.getCoreNature().getBooleanValue("enabledByDefault");
    }

    public Template getTargetTemplate() {
        String targetTemplateId = this.getTargetTemplateId();
        this.getProcessorContext();
        GeneralContext gc = this.getGeneralContext();
        return targetTemplateId != null && gc != null ? gc.getCDTTemplate(targetTemplateId) : null;
    }

    public String getTargetProjectTypeId() {
        Template t = this.getTargetTemplate();
        return t != null ? t.getTemplateInfo().getProjectType() : null;
    }

    public IProjectType getTargetProjectType() {
        String ptid = this.getTargetProjectTypeId();
        GeneralContext gc = this.getGeneralContext();
        return ptid != null && gc != null ? gc.getProjectType(ptid) : null;
    }

    public abstract String getTargetTemplateId();

    public abstract boolean isExecutable();

    public abstract boolean isAutoStart();

    public abstract ProcessorContext getProcessorContext();

    public abstract ProcessorData getProcessor();

    public GeneralContext getGeneralContext() {
        ProcessorContext processorContext = this.getProcessorContext();
        return processorContext != null ? processorContext.getParent() : null;
    }

    public CoreNatureConfiguration getConfiguration() {
        return this.configuration;
    }

    public FamilyData getFamily() {
        return this.getCoreNature().getFamily();
    }

    public CoreNatureData getCoreNature() {
        return this.getRootData();
    }

    @Override
    public CoreNatureData getRootData() {
        return (CoreNatureData)super.getRootData();
    }

    public String getCoreNatureId() {
        return this.getRootData().getId();
    }

    public String getCoreNatureName() {
        return this.getRootData().getName();
    }

    public List<? extends IModelSDK> getSdkList() {
        return this.sdkList == null ? Collections.EMPTY_LIST : this.sdkList;
    }

    public ChangeResult setSdkList(List<? extends IModelSDK> sdkList) {
        this.sdkList = sdkList;
        ChangeResult changeResult = this.getParameterManager().getChangeResult("sdks", sdkList, false);
        List<ContextChange> contextChanges = changeResult.getContextChanges();
        for (ContextChange c : contextChanges) {
            c.applyChanges();
        }
        return changeResult;
    }

    @Override
    public String getProjectBaseName() {
        return this.getProcessorContext().getProjectBaseName();
    }
}

