/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.ContextType;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.data.CoProcessorData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureSlaveData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.data.TemplateData;
import com.freescale.s32ds.cross.core.model.registry.ContextDefinition;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;
import java.util.Collections;
import java.util.List;

public class CProjectSlaveContext
extends CProjectContext {
    public CProjectSlaveContext(CoreNatureSlaveData rootData, CProjectMasterContext parent) {
        super(CoreNatureConfiguration.createDefault(rootData), new ContextDefinition(ContextType.UNDEFINED), (List<ContextPart>)Collections.EMPTY_LIST, parent);
    }

    @Override
    public CoProcessorData getRootData() {
        return (CoProcessorData)super.getRootData();
    }

    @Override
    public CoProcessorData getCoreNature() {
        return this.getRootData();
    }

    @Override
    public CProjectMasterContext getParent() {
        return (CProjectMasterContext)super.getParent();
    }

    @Override
    public String getProjectName() {
        return String.valueOf(this.getParent().getProjectBaseName()) + "_" + this.getSuffix().trim();
    }

    @Override
    public boolean isExecutable() {
        return this.getParent().isExecutable();
    }

    @Override
    public ProcessorData getProcessor() {
        return this.getParent().getProcessor();
    }

    @Override
    public String getSuffix() {
        return String.valueOf(this.getParent().getSuffix()) + "_" + this.getCoreNature().getSuffix();
    }

    @Override
    public String getTargetTemplateId() {
        String tId;
        TemplateData t = this.getConfiguration().getTemplate();
        if (t == null) {
            Activator.logWarning("No template defined for co-processor " + this.getCoreNatureId());
            return null;
        }
        String string = tId = this.isExecutable() ? t.getExecutableTemplateId() : t.getLibraryTemplateId();
        if (tId == null) {
            Activator.logWarning("No templateId configuration defined for co-processor " + this.getCoreNatureId() + ", executable: " + this.isExecutable());
        }
        return tId;
    }

    @Override
    public boolean isAutoStart() {
        return false;
    }

    @Override
    public ProcessorContext getProcessorContext() {
        return this.getParent().getParent();
    }
}

