/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProcessorConfiguration {
    private final ProcessorData processor;
    private final Map<String, CoreNatureConfiguration> coreNatureCnfigurationMap = new LinkedHashMap<String, CoreNatureConfiguration>();
    private final boolean executable;
    private final String key;

    public ProcessorConfiguration(ProcessorData processor, Collection<CoreNatureConfiguration> configurations, boolean executable) {
        this.processor = processor;
        this.executable = executable;
        this.key = ProcessorConfiguration.createKey(processor, configurations);
        for (CoreNatureConfiguration c : configurations) {
            this.coreNatureCnfigurationMap.put(c.getCoreNature().getId(), c);
        }
    }

    public ProcessorData getProcessor() {
        return this.processor;
    }

    public List<CoreNatureConfiguration> getCoreNatureConfigurations() {
        return new ArrayList<CoreNatureConfiguration>(this.coreNatureCnfigurationMap.values());
    }

    public Map<String, CoreNatureConfiguration> getCoreNatureConfigurationMap() {
        return Collections.unmodifiableMap(this.coreNatureCnfigurationMap);
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public String getKey() {
        return this.key;
    }

    public static String createKey(ProcessorData processor, Collection<CoreNatureConfiguration> configurations) {
        StringBuilder sb = new StringBuilder(processor.getId());
        for (CoreNatureConfiguration c : configurations) {
            sb.append(":");
            sb.append(c.getKey());
        }
        return sb.toString();
    }
}

