/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.registry;

import com.freescale.s32ds.cross.core.model.CdtTemplateInfo;
import com.freescale.s32ds.cross.core.model.ContextType;
import com.freescale.s32ds.cross.core.model.DefaultWizardValueProvider;
import com.freescale.s32ds.cross.core.model.IWizardValueProvider;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.TemplateVariable;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.registry.ContextDefinition;
import com.freescale.s32ds.cross.core.model.registry.DataRegistry;
import com.freescale.s32ds.cross.core.model.registry.ParameterRegistry;
import com.freescale.s32ds.cross.core.model.registry.ToolchainRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IToolChain;

public class ModelRegistry {
    private final String id;
    private String name;
    private String description = "";
    private final Set<String> tags = new HashSet<String>();
    private final Map<String, DataRegistry> dataRegistryMap = new HashMap<String, DataRegistry>();
    private final ParameterRegistry parameterRegistry;
    private final Map<String, CdtTemplateInfo> cdtTemplateInfoMap = new HashMap<String, CdtTemplateInfo>();
    private Map<ContextType, ContextDefinition> contextDefinitionMap = new HashMap<ContextType, ContextDefinition>();
    private Map<String, TemplateVariable> templateVariableMap = new LinkedHashMap<String, TemplateVariable>();
    private IWizardValueProvider valueProvider = new DefaultWizardValueProvider();
    private final ToolchainRegistry toolchainRegistry;

    public ModelRegistry(String id, ParameterRegistry parameterRegistry, ToolchainRegistry toolchainRegistry) {
        this.id = id;
        this.name = id;
        this.parameterRegistry = parameterRegistry;
        this.toolchainRegistry = toolchainRegistry;
        this.contextDefinitionMap.put(ContextType.GENERAL, new ContextDefinition(ContextType.GENERAL));
        this.contextDefinitionMap.put(ContextType.PROCESSOR_EXECUTABLE, new ContextDefinition(ContextType.PROCESSOR_EXECUTABLE));
        this.contextDefinitionMap.put(ContextType.PROCESSOR_LIBRARY, new ContextDefinition(ContextType.PROCESSOR_LIBRARY));
        this.contextDefinitionMap.put(ContextType.PROJECT_EXECUTABLE, new ContextDefinition(ContextType.PROJECT_EXECUTABLE));
        this.contextDefinitionMap.put(ContextType.PROJECT_LIBRARY, new ContextDefinition(ContextType.PROJECT_LIBRARY));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void registerTag(String tag) {
        this.tags.add(tag);
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public DataRegistry getDataRegistry(String tag) {
        DataRegistry dataRegistry = this.dataRegistryMap.get(tag);
        if (dataRegistry == null) {
            dataRegistry = new DataRegistry(tag);
            this.dataRegistryMap.put(tag, dataRegistry);
        }
        return dataRegistry;
    }

    public ConfigurationData getData(String tag, String dataId) {
        return this.getDataRegistry(tag).getDataMap().get(dataId);
    }

    public DataSet getDataSet(String dataSetTag, String dataId) {
        return (DataSet)this.getDataRegistry(dataSetTag).getDataMap().get(dataId);
    }

    public void registerData(ConfigurationData data) {
        if (!this.tags.contains(data.getTag())) {
            this.registerTag(data.getTag());
        }
        this.getDataRegistry(data.getTag()).register(data);
    }

    public Collection<ConfigurationData> getDatas(String tag) {
        return this.getDataRegistry(tag).getDataMap().values();
    }

    public boolean containsTag(String tag) {
        return this.getDataRegistry(tag).getDataMap().containsKey(tag);
    }

    public ParameterRegistry getParameterRegistry() {
        return this.parameterRegistry;
    }

    public ParameterType registerParameterType(ParameterType parameterType) {
        return this.parameterRegistry.registerType(parameterType);
    }

    public Parameter registerParameter(Parameter parameter) {
        return this.parameterRegistry.register(parameter);
    }

    public ParameterType getParameterType(String tag) {
        return this.getParameterRegistry().getParameterType(tag);
    }

    public Parameter getParameter(String id) {
        return this.getParameterRegistry().getParameter(id);
    }

    public void addContextDefinition(ContextDefinition d) {
        if (d != null) {
            this.contextDefinitionMap.put(d.getType(), d);
        }
    }

    public ContextDefinition getContextDefinition(ContextType contextType) {
        ContextDefinition d = this.contextDefinitionMap.get((Object)contextType);
        return d != null ? d : new ContextDefinition(contextType);
    }

    public void registerCdtTemplateInfo(CdtTemplateInfo templateInfo) {
        this.cdtTemplateInfoMap.put(templateInfo.getTemplateId(), templateInfo);
    }

    public CdtTemplateInfo getCdtTemplateInfo(String templateId) {
        return this.cdtTemplateInfoMap.get(templateId);
    }

    public Collection<TemplateVariable> getTemplateVariables() {
        return Collections.unmodifiableCollection(this.templateVariableMap.values());
    }

    public void registerTemplateVariable(TemplateVariable templateVariable) {
        if (!this.templateVariableMap.containsKey(templateVariable)) {
            this.templateVariableMap.put(templateVariable.getId(), templateVariable);
        }
    }

    public IWizardValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public void setValueProvider(IWizardValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public ToolchainRegistry getToolchainRegistry() {
        return this.toolchainRegistry;
    }

    public IToolChain getToolChain(String toolChainId) {
        return this.toolchainRegistry.getToolchain(toolChainId);
    }
}

