/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.preferences;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.utils.Tuple;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.List;

public class PreferenceStoreSupport {
    private static ArrayList<Tuple> tuples = new ArrayList();

    public static void addTuple(Tuple t) {
        tuples.add(t);
    }

    protected static String[] parseString(String stringList, String delim) {
        StringTokenizer st = new StringTokenizer(stringList, delim);
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreElements()) {
            v.add((String)st.nextElement());
        }
        return v.toArray(new String[v.size()]);
    }

    protected static String createList(String[] items, String delim) {
        String str = "";
        int i = 0;
        while (i < items.length - 1) {
            str = String.valueOf(str) + items[i] + delim;
            ++i;
        }
        return String.valueOf(str) + items[i];
    }

    public static void doLoad(List list) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int version = store.getInt("version");
        if (version != 0) {
            return;
        }
        String s = store.getString("tupleList");
        String[] selarray = PreferenceStoreSupport.parseString(s, String.valueOf(File.pathSeparator) + "\n\r");
        s = store.getString("tupleData");
        String[] array = PreferenceStoreSupport.parseString(s, "?");
        int i = 0;
        while (i < selarray.length) {
            String[] tuplearray = PreferenceStoreSupport.parseString(array[i], "!");
            if (tuplearray.length == 4) {
                Tuple mytuple = new Tuple(selarray[i], PreferenceStoreSupport.parseString(tuplearray[0], String.valueOf(File.pathSeparator) + "\n\r"), PreferenceStoreSupport.parseString(tuplearray[1], String.valueOf(File.pathSeparator) + "\n\r"), PreferenceStoreSupport.parseString(tuplearray[2], String.valueOf(File.pathSeparator) + "\n\r"), PreferenceStoreSupport.parseString(tuplearray[3], String.valueOf(File.pathSeparator) + "\n\r"));
                tuples.add(mytuple);
            }
            ++i;
        }
        if (list != null) {
            i = 0;
            while (i < selarray.length) {
                list.add(selarray[i]);
                ++i;
            }
        }
    }

    public static void doLoadDefault(List list) {
        String s = Activator.getDefault().getPreferenceStore().getDefaultString("tupleList");
        String[] array = PreferenceStoreSupport.parseString(s, String.valueOf(File.pathSeparator) + "\n\r");
        if (list != null) {
            list.removeAll();
            int i = 0;
            while (i < array.length) {
                list.add(array[i]);
                ++i;
            }
        }
    }

    public static void doStore() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int i = 0;
        String[] tuplearray = new String[tuples.size()];
        for (Tuple t : tuples) {
            tuplearray[i++] = t.getName();
        }
        String s = PreferenceStoreSupport.createList(tuplearray, String.valueOf(File.pathSeparator) + "\n\r");
        if (s != null) {
            store.setValue("tupleList", s);
        }
        i = 0;
        for (Tuple t : tuples) {
            tuplearray[i++] = String.valueOf(PreferenceStoreSupport.createList(t.getHdrlist(), String.valueOf(File.pathSeparator) + "\n\r")) + "!" + PreferenceStoreSupport.createList(t.getSrcslist(), String.valueOf(File.pathSeparator) + "\n\r") + "!" + PreferenceStoreSupport.createList(t.getLibpathlist(), String.valueOf(File.pathSeparator) + "\n\r") + "!" + PreferenceStoreSupport.createList(t.getLibnamelist(), String.valueOf(File.pathSeparator) + "\n\r");
        }
        store.setValue("tupleData", PreferenceStoreSupport.createList(tuplearray, "?"));
    }

    public static void removeTuple(int index) {
        if (index < tuples.size()) {
            tuples.remove(index);
        }
    }

    public static Tuple getTuple(int index) {
        if (index < tuples.size()) {
            return tuples.get(index);
        }
        return null;
    }

    public static void updateTuple(int index, Tuple t) {
        if (index < tuples.size()) {
            tuples.set(index, t);
        }
    }

    public static void resetTuple() {
        PreferenceStoreSupport.doLoad(null);
    }

    public static Tuple[] getTuples() {
        return tuples.toArray(new Tuple[tuples.size()]);
    }
}

