/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.StepBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.GeneratedMakefileBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GeneratedMakefileBuilder2
extends GeneratedMakefileBuilder {
    private List<IFile> outputBinaryFiles;
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final int TICKS_STREAM_PROGRESS_MONITOR = 100;
    private static final int TICKS_DELETE_MARKERS = 100;
    private IConsole console;

    public List<IFile> getOutputBinaryFiles() {
        return this.outputBinaryFiles;
    }

    private Vector<IStatus> getGenerationProblems() {
        if (this.generationProblems == null) {
            this.generationProblems = new Vector();
        }
        return this.generationProblems;
    }

    private Map<IProject, List<IFile>> arrangeFilesByProject(List<IFile> files) {
        HashMap<IProject, List<IFile>> projectMap = new HashMap<IProject, List<IFile>>();
        for (IFile file : files) {
            IProject project = file.getProject();
            ArrayList<IFile> filesInProject = (ArrayList<IFile>)projectMap.get(project);
            if (filesInProject == null) {
                filesInProject = new ArrayList<IFile>();
                projectMap.put(project, filesInProject);
            }
            filesInProject.add(file);
        }
        return projectMap;
    }

    public IStatus invokeInternalBuilder(List<IFile> files, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            Map<IProject, List<IFile>> projectMap = this.arrangeFilesByProject(files);
            monitor.beginTask("", projectMap.size() * 100);
            this.outputBinaryFiles = new ArrayList<IFile>();
            for (List<IFile> filesInProject : projectMap.values()) {
                IProject project = filesInProject.get(0).getProject();
                this.setCurrentProject(project);
                monitor.subTask(ManagedMakeMessages.getFormattedString((String)"GeneratedMakefileBuilder.buildingProject", (String)project.getName()));
                this.invokeInternalBuilderForOneProject(filesInProject, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
            }
        }
        finally {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void invokeInternalBuilderForOneProject(List<IFile> files, IProgressMonitor monitor) {
        IProject project = files.get(0).getProject();
        BuildRunnerHelper buildRunnerHelper = new BuildRunnerHelper(project);
        try {
            try {
                monitor.beginTask(String.valueOf(ManagedMakeMessages.getFormattedString((String)"GeneratedMakefileBuilder.buildingProject", (String)project.getName())) + ':', 100 + files.size() * 100);
                this.console = CCorePlugin.getDefault().getConsole();
                this.console.start(project);
                IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                IConfiguration configuration = buildInfo.getDefaultConfiguration();
                String cfgName = configuration.getName();
                String toolchainName = configuration.getToolChain().getName();
                boolean isSupported = configuration.isSupported();
                IBuildDescription des = BuildDescriptionManager.createBuildDescription((IConfiguration)configuration, null, (int)0);
                String[] errorParsers = configuration.getErrorParserList();
                ErrorParserManager epm = new ErrorParserManager(project, des.getDefaultBuildDirLocationURI(), (IMarkerGenerator)this, errorParsers);
                buildRunnerHelper.prepareStreams(epm, null, this.console, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                OutputStream stdout = buildRunnerHelper.getOutputStream();
                OutputStream stderr = buildRunnerHelper.getErrorStream();
                buildRunnerHelper.greeting(ManagedMakeMessages.getResourceString((String)"GeneratedMakefileBuilder.buildingSelectedFiles"), cfgName, toolchainName, isSupported);
                buildRunnerHelper.printLine(ManagedMakeMessages.getResourceString((String)"ManagedMakeBuilder.message.internal.builder.header.note"));
                block16: for (IFile file : files) {
                    if (monitor.isCanceled()) break;
                    String filePath = file.getProjectRelativePath().toString();
                    try {
                        IBuildResource buildResource = des.getBuildResource((IResource)file);
                        HashSet<IBuildStep> dependentSteps = new HashSet<IBuildStep>();
                        IBuildIOType[] iBuildIOTypeArray = buildResource.getDependentIOTypes();
                        int n = iBuildIOTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IBuildIOType btype = iBuildIOTypeArray[n2];
                            if (btype != null && btype.getStep() != null) {
                                dependentSteps.add(btype.getStep());
                            }
                            ++n2;
                        }
                        SubProgressMonitor monitor2 = new SubProgressMonitor(monitor, 100, 4);
                        try {
                            monitor2.beginTask("", 100 + dependentSteps.size() * 100);
                            monitor2.subTask(ManagedMakeMessages.getFormattedString((String)"GeneratedMakefileBuilder.removingResourceMarkers", (String)filePath));
                            buildRunnerHelper.removeOldMarkers((IResource)file, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor2, 100, 2));
                            for (IBuildStep step : dependentSteps) {
                                IBuildIOType[] outputIOTypes;
                                if (monitor2.isCanceled()) {
                                    continue block16;
                                }
                                monitor2.subTask(filePath);
                                StepBuilder stepBuilder = new StepBuilder(step, null);
                                stepBuilder.build(stdout, stderr, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor2, 100, 2));
                                monitor2.subTask(ManagedMakeMessages.getFormattedString((String)"GeneratedMakefileBuilder.refreshingArtifacts", (String)filePath));
                                IBuildIOType[] iBuildIOTypeArray2 = outputIOTypes = step.getOutputIOTypes();
                                int n3 = outputIOTypes.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IBuildIOType type = iBuildIOTypeArray2[n4];
                                    IBuildResource[] iBuildResourceArray = type.getResources();
                                    int n5 = iBuildResourceArray.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        IBuildResource outResource = iBuildResourceArray[n6];
                                        IPath location = outResource.getLocation();
                                        IFile outFile = project.getFile(location);
                                        outFile.refreshLocal(2, null);
                                        IFile[] findFilesForLocation = PathUtil.getWorkspaceRoot().findFilesForLocation(location);
                                        this.outputBinaryFiles.add(findFilesForLocation[0]);
                                        ++n6;
                                    }
                                    ++n4;
                                }
                            }
                        }
                        finally {
                            monitor2.done();
                        }
                    }
                    catch (Exception e) {
                        ManagedBuilderCorePlugin.log((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e)));
                    }
                }
                buildRunnerHelper.close();
                buildRunnerHelper.goodbye();
            }
            catch (Exception e) {
                ManagedBuilderCorePlugin.log((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e)));
                this.forgetLastBuiltState();
                this.getGenerationProblems().clear();
                try {
                    buildRunnerHelper.close();
                }
                catch (IOException e2) {
                    ManagedBuilderCorePlugin.log((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e2)));
                }
                monitor.done();
            }
        }
        finally {
            this.getGenerationProblems().clear();
            try {
                buildRunnerHelper.close();
            }
            catch (IOException e) {
                ManagedBuilderCorePlugin.log((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e)));
            }
            monitor.done();
        }
    }
}

