/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.utils;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.utils.UtilsMessages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public abstract class ExtensionUtils {
    private static final String E_EXTENSION_POINT_NOT_FOUND = UtilsMessages.ExtensionUtils_e_extension_point_not_found;
    private static final String E_IMPLEMENTATION_NOT_FOUND = UtilsMessages.ExtensionUtils_e_implementation_not_found;

    private ExtensionUtils() {
    }

    public static <T> T getImplementation(String namespace, String extensionPointName, String propertyName, String attributeName, Class<T> extensionClass) {
        List<T> result = ExtensionUtils.getExecutableExtensions(namespace, extensionPointName, propertyName, attributeName, extensionClass);
        if (result.size() == 0) {
            Activator.logError(String.format(E_IMPLEMENTATION_NOT_FOUND, extensionClass.getName()));
            return null;
        }
        return result.get(0);
    }

    public static <T> List<T> getExecutableExtensions(String namespace, String extensionPointName, String propertyName, String attributeName, Class<T> extensionClass) {
        return new ArrayList<T>(namespace, extensionPointName, propertyName, attributeName, extensionClass){
            {
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(string, string2);
                if (ep == null) {
                    Activator.logError(String.format(E_EXTENSION_POINT_NOT_FOUND, string, string2));
                } else {
                    IExtension[] iExtensionArray = ep.getExtensions();
                    int n = iExtensionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                        int n3 = iConfigurationElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            ExtensionUtils.readElement(element, string3, string4, clazz, this);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        };
    }

    private static <T> void readElement(IConfigurationElement element, String propertyName, String attributeName, Class<T> extensionClass, List<T> result) {
        if (propertyName.equals(element.getName())) {
            ExtensionUtils.createExtension(element, attributeName, extensionClass, result);
        }
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            ExtensionUtils.readElement(child, propertyName, attributeName, extensionClass, result);
            ++n2;
        }
    }

    private static <T> void createExtension(IConfigurationElement element, String attributeName, Class<T> extensionClass, List<T> result) {
        try {
            Object extensionInstance = element.createExecutableExtension(attributeName);
            if (extensionClass.isAssignableFrom(extensionInstance.getClass())) {
                result.add(extensionInstance);
            }
        }
        catch (CoreException ex) {
            Activator.log(ex.getStatus());
        }
    }
}

