/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.internal.commanderview.view;

import com.freescale.s32ds.cdt.core.internal.commanderview.handlers.BaseLaunchConfigContextHandler;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.CommandManager;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.CommanderView;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.PinHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class ContextManager {
    static Map<IWorkbenchWindow, ContextManager> fManagers = new HashMap<IWorkbenchWindow, ContextManager>();
    private boolean fPinned;
    private IProject[] fProjects;
    private ISelection fSelection;
    private CommanderView fView;
    private final ISelectionListener fSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (ContextManager.this.fPinned) {
                return;
            }
            IProject[] projectsSave = ContextManager.this.fProjects;
            ContextManager.this.fSelection = selection;
            ContextManager.this.fProjects = null;
            if (selection == null || selection.isEmpty()) {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                if (projects.length == 1 && ContextManager.isCproject(projects[0])) {
                    ContextManager.this.fProjects = new IProject[]{projects[0]};
                }
            } else if (selection instanceof IStructuredSelection) {
                IStructuredSelection sselection = (IStructuredSelection)selection;
                Iterator iter = sselection.iterator();
                ArrayList<IProject> projects = new ArrayList<IProject>(sselection.size());
                boolean invalidSelection = false;
                while (iter.hasNext()) {
                    Object element = iter.next();
                    IProject project = ContextManager.selectionElementToProject(element);
                    if (project != null && ContextManager.isCproject(project)) {
                        projects.add(project);
                        continue;
                    }
                    invalidSelection = true;
                    break;
                }
                if (!invalidSelection) {
                    ContextManager.this.fProjects = projects.toArray(new IProject[projects.size()]);
                }
            }
            if (ContextManager.this.fProjects == null) {
                IViewPart view;
                HashSet<IViewPart> views = new HashSet<IViewPart>(4);
                IWorkbenchWindow window = part.getSite().getWorkbenchWindow();
                views.add(ContextManager.getView(window, "org.eclipse.cdt.ui.CView"));
                views.add(ContextManager.getView(window, "org.eclipse.ui.navigator.ProjectExplorer"));
                views.add(ContextManager.getView(window, "org.eclipse.ui.views.ResourceNavigator"));
                views.remove(null);
                if (views.size() == 1 && part != (view = (IViewPart)views.iterator().next())) {
                    ContextManager.this.fProjects = projectsSave;
                    this.selectionChanged((IWorkbenchPart)view, view.getSite().getSelectionProvider().getSelection());
                    return;
                }
            }
            if (projectsSave != ContextManager.this.fProjects && ContextManager.this.fView != null) {
                ContextManager.this.fView.updateCmdLinks();
            }
            if (ContextManager.this.fView != null) {
                IContributionItem[] iContributionItemArray = ContextManager.this.fView.getViewSite().getActionBars().getToolBarManager().getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    item.isEnabled();
                    ++n2;
                }
            }
        }
    };
    private IResourceChangeListener fResChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if ((event.getDelta().getKind() & 4) != 0) {
                IResource res = event.getDelta().getResource();
                if (ResourcesPlugin.getWorkspace().getRoot().equals((Object)res)) {
                    IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                    int n = iResourceDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceDelta childDelta = iResourceDeltaArray[n2];
                        if (childDelta.getResource() instanceof IProject) {
                            WorkbenchJob wjob;
                            IProject proj;
                            if ((childDelta.getKind() & 4) != 0 && (childDelta.getFlags() & 0x4000) != 0) {
                                proj = (IProject)childDelta.getResource();
                                wjob = new WorkbenchJob("Commander view resource changed handling"){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        boolean update = false;
                                        if (proj.isOpen()) {
                                            if (ContextManager.this.fProjects == null) {
                                                update = true;
                                            }
                                        } else if (ContextManager.this.fProjects != null && Arrays.asList(ContextManager.this.fProjects).contains(proj)) {
                                            update = true;
                                        }
                                        if (update && !ContextManager.this.fPinned) {
                                            ContextManager.this.updateToCurrentSelection();
                                        }
                                        return Status.OK_STATUS;
                                    }
                                };
                                wjob.setSystem(true);
                                wjob.schedule();
                            } else if ((childDelta.getKind() & 2) != 0) {
                                proj = (IProject)childDelta.getResource();
                                wjob = new WorkbenchJob("Commander view resource changed handling"){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        if (ContextManager.this.fPinned && ContextManager.this.fProjects != null && proj.equals((Object)ContextManager.this.fProjects[0])) {
                                            ContextManager.this.unPin();
                                            PinHandler.toggleCmdState();
                                        }
                                        return Status.OK_STATUS;
                                    }
                                };
                                wjob.setSystem(true);
                                wjob.schedule();
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
    };
    private IWorkbenchWindow fWindow;
    private static IWindowListener fWindowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            ContextManager mgr = fManagers.get(window);
            if (mgr != null) {
                mgr.dispose();
                fManagers.remove(window);
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }
    };

    public static ContextManager getManager(IWorkbenchWindow window) {
        ContextManager mgr = fManagers.get(window);
        if (mgr == null) {
            mgr = new ContextManager(window);
            fManagers.put(window, mgr);
        }
        return mgr;
    }

    private ContextManager(IWorkbenchWindow window) {
        this.fWindow = window;
        window.getSelectionService().addSelectionListener(this.fSelectionListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResChangeListener, 1);
        this.updateToCurrentSelection();
    }

    private void dispose() {
        ISelectionService service = this.fWindow.getSelectionService();
        if (service != null) {
            service.removeSelectionListener(this.fSelectionListener);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResChangeListener);
    }

    public static void start() {
        PlatformUI.getWorkbench().addWindowListener(fWindowListener);
    }

    public static void stop() {
        PlatformUI.getWorkbench().removeWindowListener(fWindowListener);
    }

    void setView(CommanderView view) {
        this.fView = view;
    }

    void updateToCurrentSelection() {
        ISelectionService selService = this.fWindow.getSelectionService();
        IPartService partService = (IPartService)this.fWindow.getService(IPartService.class);
        this.fSelection = selService.getSelection();
        IWorkbenchPart part = partService.getActivePart();
        if (part != null) {
            this.fSelectionListener.selectionChanged(part, this.fSelection);
        }
    }

    private static IProject selectionElementToProject(Object element) {
        Object adapter;
        IProject project = null;
        if (element instanceof ICElement) {
            ICProject cproject = ((ICElement)element).getCProject();
            if (cproject != null) {
                project = cproject.getProject();
            }
        } else if (element instanceof IResource) {
            project = ((IResource)element).getProject();
        } else if (element instanceof IncludeRefContainer) {
            ICProject fCProject = ((IncludeRefContainer)element).getCProject();
            if (fCProject != null) {
                project = fCProject.getProject();
            }
        } else if (element instanceof IncludeReferenceProxy) {
            ICProject fCProject;
            IncludeRefContainer irc = ((IncludeReferenceProxy)element).getIncludeRefContainer();
            if (irc != null && (fCProject = irc.getCProject()) != null) {
                project = fCProject.getProject();
            }
        } else if (element instanceof IAdaptable && (adapter = ((IAdaptable)element).getAdapter(IProject.class)) != null && adapter instanceof IProject) {
            project = (IProject)adapter;
        }
        return project;
    }

    void pin() {
        assert (!this.fPinned);
        if (this.fProjects == null) {
            return;
        }
        this.fPinned = true;
        if (this.fView != null) {
            this.fView.showPinned();
        }
    }

    void unPin() {
        assert (this.fPinned);
        this.fPinned = false;
        this.updateToCurrentSelection();
        if (this.fView != null) {
            this.fView.showUnpinned();
        }
    }

    static IViewPart getView(IWorkbenchWindow window, String id) {
        IViewReference viewRef = window.getActivePage().findViewReference(id);
        if (viewRef != null) {
            return viewRef.getView(false);
        }
        return null;
    }

    IProject[] getActiveProjects() {
        return this.fProjects;
    }

    ISelection getActiveSelection() {
        return this.fSelection;
    }

    CommanderView getView() {
        return this.fView;
    }

    public Map<String, ?> createContext(CommandManager.Command cmd) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IProject[] projs = this.getActiveProjects();
        map.put("projects", projs);
        boolean[] multiple = new boolean[1];
        ISelection selection = this.getActiveSelection();
        ILaunchConfiguration lconfig = BaseLaunchConfigContextHandler.getLaunchConfiguration(BaseLaunchConfigContextHandler.getDebugLaunchGroup(), projs != null ? projs[0] : null, selection, false, multiple);
        map.put("launchConfig", lconfig);
        map.put("multipleLaunchConfig", multiple[0]);
        map.put("workbenchWindow", this.fWindow);
        map.put("selection", selection);
        map.put("id", cmd.id);
        return map;
    }

    private static boolean isCproject(IProject proj) {
        return CoreModel.hasCNature((IProject)proj) || CoreModel.hasCCNature((IProject)proj);
    }
}

