/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne;

import com.pemicro.debug.gdbjtag.pne.Activator;
import com.pemicro.debug.gdbjtag.pne.Backend;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.AbstractCLIProcess;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;

public class Launch
extends GdbLaunch {
    ILaunchConfiguration fConfig = null;
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private DefaultDsfExecutor fExecutor;

    public Launch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
        this.fConfig = launchConfiguration;
        this.fExecutor = (DefaultDsfExecutor)this.getDsfExecutor();
        this.fSession = this.getSession();
    }

    public void initialize() {
        DsfRunnable initRunnable;
        try {
            ILaunchConfigurationWorkingCopy config = this.getLaunchConfiguration().getWorkingCopy();
            this.provideDefaults(config);
            config.doSave();
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        try {
            super.initialize();
            initRunnable = new DsfRunnable(){

                public void run() {
                    Launch.this.fTracker = new DsfServicesTracker(Activator.getDefault().getBundle().getBundleContext(), Launch.this.fSession.getId());
                }
            };
            this.fExecutor.submit((Runnable)initRunnable).get();
        }
        catch (Exception e) {
            Activator.log((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 10005, "Error initializing launch", (Throwable)e));
        }
        initRunnable = new DsfRunnable(){

            public void run() {
                Launch.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), Launch.this.fSession.getId());
            }
        };
        try {
            this.fExecutor.submit((Runnable)initRunnable).get();
        }
        catch (InterruptedException e) {
            Activator.log((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 10005, "Error initializing launch", (Throwable)e));
        }
        catch (ExecutionException e) {
            Activator.log((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 10005, "Error initializing launch", (Throwable)e));
        }
    }

    protected void provideDefaults(ILaunchConfigurationWorkingCopy config) throws CoreException {
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true);
        }
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true);
        }
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        }
    }

    public void shutdownSession(RequestMonitor rm) {
        super.shutdownSession(rm);
    }

    public IProcess addServerProcess(String label) throws CoreException {
        IProcess newProcess = null;
        try {
            Process serverProc = (Process)this.getDsfExecutor().submit((Callable)new Callable<Process>(){

                @Override
                public Process call() throws CoreException {
                    Backend backend = (Backend)((Object)Launch.this.fTracker.getService(IGDBBackend.class));
                    if (backend != null) {
                        return backend.getServerProcess();
                    }
                    return null;
                }
            }).get();
            HashMap attributes = new HashMap();
            newProcess = DebugPlugin.newProcess((ILaunch)this, (Process)serverProc, (String)label, attributes);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
        return newProcess;
    }

    public IProcess addClientProcess(String label) throws CoreException {
        IProcess newProcess = null;
        try {
            AbstractCLIProcess cliProc = (AbstractCLIProcess)this.getDsfExecutor().submit((Callable)new Callable<AbstractCLIProcess>(){

                @Override
                public AbstractCLIProcess call() throws CoreException {
                    IGDBControl gdb = (IGDBControl)Launch.this.fTracker.getService(IGDBControl.class);
                    if (gdb != null) {
                        return gdb.getCLIProcess();
                    }
                    return null;
                }
            }).get();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.gdbProcess");
            newProcess = DebugPlugin.newProcess((ILaunch)this, (Process)cliProc, (String)label, attributes);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
        return newProcess;
    }

    public IProcess addSemihostingProcess(String label) throws CoreException {
        IProcess newProcess = null;
        try {
            Process serverProc = (Process)this.getDsfExecutor().submit((Callable)new Callable<Process>(){

                @Override
                public Process call() throws CoreException {
                    Backend backend = (Backend)((Object)Launch.this.fTracker.getService(IGDBBackend.class));
                    if (backend != null) {
                        return backend.getSemihostingProcess();
                    }
                    return null;
                }
            }).get();
            HashMap attributes = new HashMap();
            newProcess = DebugPlugin.newProcess((ILaunch)this, (Process)serverProc, (String)label, attributes);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
        return newProcess;
    }
}

