/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.RTVar;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryBytesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIParser;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.debug.core.model.MemoryByte;

public class GdbMiConnection {
    private Socket GDBMISocket;
    private PrintWriter OutputToServer;
    private BufferedReader InputFromServer;
    private MIParser fMiParser;
    private int portUsed;

    GdbMiConnection(int port) {
        this.portUsed = port;
    }

    public boolean init() {
        try {
            this.GDBMISocket = new Socket(InetAddress.getByName("localhost"), this.portUsed);
            this.OutputToServer = new PrintWriter(this.GDBMISocket.getOutputStream(), true);
            this.InputFromServer = new BufferedReader(new InputStreamReader(this.GDBMISocket.getInputStream()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.fMiParser = new MIParser();
        return true;
    }

    public MemoryByte[] getMemory(Long address, int size) {
        MemoryByte[] result = null;
        try {
            this.OutputToServer.println("-data-read-memory-bytes " + Long.toString(address) + " " + Long.toString(size));
            String answer = this.InputFromServer.readLine();
            this.InputFromServer.readLine();
            if (answer == null) {
                return result;
            }
            MIResultRecord resultRecord = this.fMiParser.parseMIResultRecord(answer);
            MIOutput out = new MIOutput(resultRecord, null);
            MIDataReadMemoryBytesInfo info = new MIDataReadMemoryBytesInfo(out, size, 1);
            result = info.getMIMemoryBlock();
        }
        catch (IOException e) {
            System.err.println("Failed to get Value from GDBMIPort " + this.portUsed);
            e.printStackTrace();
        }
        return result;
    }

    public void close() {
        ArrayList<Closeable> streams = new ArrayList<Closeable>();
        streams.add(this.GDBMISocket);
        streams.add(this.OutputToServer);
        streams.add(this.InputFromServer);
        for (Closeable stream : streams) {
            try {
                if (stream == null) continue;
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

