/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne;

import com.pemicro.debug.gdbjtag.pne.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RestartProcessSequence
extends ReflectionSequence {
    private IGDBControl fCommandControl;
    private CommandFactory fCommandFactory;
    private IGDBProcesses fProcService;
    private DsfServicesTracker fTracker;
    private IRunControl.IContainerDMContext fContainerDmc;
    private final Map<String, Object> fAttributes;

    protected IRunControl.IContainerDMContext getContainerContext() {
        return this.fContainerDmc;
    }

    public RestartProcessSequence(DsfExecutor executor, IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        super(executor, rm);
        assert (executor != null);
        assert (containerDmc != null);
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
        }
        this.fContainerDmc = containerDmc;
        this.fAttributes = attributes;
    }

    private void queueCommands(List<String> commands, RequestMonitor rm) {
        if (!commands.isEmpty()) {
            this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fCommandControl.getContext(), Utils.composeCommandWithLf(commands)), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.done();
        }
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            return new String[]{"stepInitializeBaseSequence", "stepRestartCommands"};
        }
        return null;
    }

    @ReflectionSequence.Execute
    public void stepInitializeBaseSequence(RequestMonitor rm) {
        this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fContainerDmc.getSessionId());
        this.fCommandControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        this.fCommandFactory = ((IMICommandControl)this.fTracker.getService(IMICommandControl.class)).getCommandFactory();
        this.fProcService = (IGDBProcesses)this.fTracker.getService(IGDBProcesses.class);
        if (this.fCommandControl == null || this.fCommandFactory == null || this.fProcService == null) {
            rm.setStatus((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 10005, "Cannot obtain service", null));
            rm.done();
            return;
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepRestartCommands(RequestMonitor rm) {
        ArrayList<String> commandsList = new ArrayList<String>();
        boolean noReset = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.pne.attachToRunning", (Object)false);
        if (!noReset) {
            commandsList.add("monitor _reset");
            commandsList.add("monitor _nobr");
            commandsList.add("flushreg");
            String otherCmds = ((String)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.pne.otherRunCommands", (Object)"")).trim();
            try {
                Utils.addMultiLine(otherCmds, commandsList);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (((Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.setStopAt", (Object)false)).booleanValue()) {
            String stopAt = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.stopAt", (Object)"");
            commandsList.add("thbreak " + stopAt);
        }
        if (((Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.pne.doContinue", (Object)true)).booleanValue()) {
            commandsList.add("continue");
        }
        CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        crm.setDoneCount(commandsList.size());
        this.queueCommands(commandsList, rm);
    }
}

