/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.ui;

import com.pemicro.debug.gdbjtag.pne.api.IPemicroUtil;
import com.pemicro.debug.gdbjtag.pne.ui.TabDebugger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class HardwareInterfaceSettings {
    private TabDebugger parent;
    private IPemicroUtil.interfaceType current;
    private Map<IPemicroUtil.interfaceType, HardwareInterface> interfaces;
    private static final String[] attributeHeaders = new String[]{".ml.", ".cyc_ser.", ".cyc_usb.", ".cyc_eth.", ".trc_usb.", ".trc_eth.", ".sda."};
    private static final String[] defaultPowerDownDelays = new String[]{"250", "250", "250", "250", "250", "250", ""};
    private static final String[] defaultPowerUpDelays = new String[]{"1000", "250", "250", "250", "250", "250", ""};

    private static IPemicroUtil.interfaceType getInterfaceType(int index) {
        return IPemicroUtil.interfaceType.values()[index];
    }

    HardwareInterfaceSettings(TabDebugger parent) {
        this.parent = parent;
        this.current = HardwareInterfaceSettings.getInterfaceType(0);
        this.interfaces = new HashMap<IPemicroUtil.interfaceType, HardwareInterface>();
        int i = 0;
        IPemicroUtil.interfaceType[] interfaceTypeArray = IPemicroUtil.interfaceType.values();
        int n = interfaceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPemicroUtil.interfaceType hw = interfaceTypeArray[n2];
            HardwareInterface iface = new HardwareInterface();
            iface.attributeHeader = attributeHeaders[i];
            iface.defaultPowerDownDelay = defaultPowerDownDelays[i];
            iface.defaultPowerUpDelay = defaultPowerUpDelays[i];
            ++i;
            iface.hardwarePortIndex = 0;
            iface.useCycloneIp = false;
            iface.cycloneIp = "";
            iface.useNicIp = false;
            iface.nicIp = "";
            iface.doMassErase = false;
            iface.useSwd = true;
            iface.doProvidePower = true;
            iface.doPowerOff = false;
            iface.voltageOutputIndex = 0;
            iface.shiftFrequency = "5000";
            iface.useResetDelay = false;
            iface.resetDelay = "0";
            this.interfaces.put(hw, iface);
            ++n2;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        for (Map.Entry<IPemicroUtil.interfaceType, HardwareInterface> hw : this.interfaces.entrySet()) {
            HardwareInterface iface = hw.getValue();
            String attributeHeader = iface.getAttributeHeader();
            configuration.setAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT", 0);
            configuration.setAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT_STRING", "");
            configuration.setAttribute(String.valueOf(attributeHeader) + "SPECIFY_IP", false);
            configuration.setAttribute(String.valueOf(attributeHeader) + "CYCLONE_IP", "");
            configuration.setAttribute(String.valueOf(attributeHeader) + "SPECIFY_NETWORK_CARD", false);
            configuration.setAttribute(String.valueOf(attributeHeader) + "NETWORK_CARD_IP", "");
            configuration.setAttribute(String.valueOf(attributeHeader) + "ALWAYS_ERASE", false);
            configuration.setAttribute(String.valueOf(attributeHeader) + "STARTUP_USE_SWD", true);
            configuration.setAttribute(String.valueOf(attributeHeader) + "PROVIDE_POWER", true);
            configuration.setAttribute(String.valueOf(attributeHeader) + "POWER_OFF", false);
            configuration.setAttribute(String.valueOf(attributeHeader) + "REGULATOR_VOLTAGE", 0);
            configuration.setAttribute(String.valueOf(attributeHeader) + "POWER_DOWN_DELAY", iface.powerDownDelay);
            configuration.setAttribute(String.valueOf(attributeHeader) + "POWER_UP_DELAY", iface.powerUpDelay);
            configuration.setAttribute(String.valueOf(attributeHeader) + "SHIFT_FREQ", "5000");
            configuration.setAttribute(String.valueOf(attributeHeader) + "DO_RESET_DELAY", false);
            configuration.setAttribute(String.valueOf(attributeHeader) + "RESET_DELAY", "0");
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        for (Map.Entry<IPemicroUtil.interfaceType, HardwareInterface> hw : this.interfaces.entrySet()) {
            HardwareInterface iface = hw.getValue();
            String attributeHeader = iface.getAttributeHeader();
            try {
                iface.hardwarePortIndex = configuration.getAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT", 0);
                iface.useCycloneIp = configuration.getAttribute(String.valueOf(attributeHeader) + "SPECIFY_IP", false);
                iface.cycloneIp = configuration.getAttribute(String.valueOf(attributeHeader) + "CYCLONE_IP", "");
                iface.useNicIp = configuration.getAttribute(String.valueOf(attributeHeader) + "SPECIFY_NETWORK_CARD", false);
                iface.nicIp = configuration.getAttribute(String.valueOf(attributeHeader) + "NETWORK_CARD_IP", "");
                iface.doMassErase = configuration.getAttribute(String.valueOf(attributeHeader) + "ALWAYS_ERASE", false);
                iface.useSwd = configuration.getAttribute(String.valueOf(attributeHeader) + "STARTUP_USE_SWD", true);
                iface.doProvidePower = configuration.getAttribute(String.valueOf(attributeHeader) + "PROVIDE_POWER", true);
                iface.doPowerOff = configuration.getAttribute(String.valueOf(attributeHeader) + "POWER_OFF", false);
                iface.voltageOutputIndex = configuration.getAttribute(String.valueOf(attributeHeader) + "REGULATOR_VOLTAGE", 0);
                iface.powerDownDelay = configuration.getAttribute(String.valueOf(attributeHeader) + "POWER_DOWN_DELAY", iface.defaultPowerDownDelay);
                iface.powerUpDelay = configuration.getAttribute(String.valueOf(attributeHeader) + "POWER_UP_DELAY", iface.defaultPowerUpDelay);
                iface.shiftFrequency = configuration.getAttribute(String.valueOf(attributeHeader) + "SHIFT_FREQ", "5000");
                iface.useResetDelay = configuration.getAttribute(String.valueOf(attributeHeader) + "DO_RESET_DELAY", false);
                iface.resetDelay = configuration.getAttribute(String.valueOf(attributeHeader) + "RESET_DELAY", "0");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        try {
            int hwIndex = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.HARDWARE_INTERFACE", 0);
            this.current = IPemicroUtil.interfaceType.values()[hwIndex];
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.updatePanel();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.storePanelContext(this.current);
        for (Map.Entry<IPemicroUtil.interfaceType, HardwareInterface> hw : this.interfaces.entrySet()) {
            HardwareInterface iface = hw.getValue();
            String attributeHeader = iface.getAttributeHeader();
            configuration.setAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT", iface.hardwarePortIndex);
            int hwIndex = hw.getKey().ordinal();
            ArrayList<String> hwPorts = TabDebugger.detectedHardwareInterfaces.get((int)hwIndex).ports;
            String portString = iface.hardwarePortIndex < hwPorts.size() && iface.hardwarePortIndex >= 0 ? hwPorts.get(iface.hardwarePortIndex) : "";
            configuration.setAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT_STRING", portString);
            configuration.setAttribute(String.valueOf(attributeHeader) + "SPECIFY_IP", iface.useCycloneIp);
            configuration.setAttribute(String.valueOf(attributeHeader) + "CYCLONE_IP", iface.cycloneIp);
            configuration.setAttribute(String.valueOf(attributeHeader) + "SPECIFY_NETWORK_CARD", iface.useNicIp);
            configuration.setAttribute(String.valueOf(attributeHeader) + "NETWORK_CARD_IP", iface.nicIp);
            configuration.setAttribute(String.valueOf(attributeHeader) + "ALWAYS_ERASE", iface.doMassErase);
            configuration.setAttribute(String.valueOf(attributeHeader) + "STARTUP_USE_SWD", iface.useSwd);
            configuration.setAttribute(String.valueOf(attributeHeader) + "PROVIDE_POWER", iface.doProvidePower);
            configuration.setAttribute(String.valueOf(attributeHeader) + "POWER_OFF", iface.doPowerOff);
            configuration.setAttribute(String.valueOf(attributeHeader) + "REGULATOR_VOLTAGE", iface.voltageOutputIndex);
            configuration.setAttribute(String.valueOf(attributeHeader) + "POWER_DOWN_DELAY", iface.powerDownDelay);
            configuration.setAttribute(String.valueOf(attributeHeader) + "POWER_UP_DELAY", iface.powerUpDelay);
            configuration.setAttribute(String.valueOf(attributeHeader) + "SHIFT_FREQ", iface.shiftFrequency);
            configuration.setAttribute(String.valueOf(attributeHeader) + "DO_RESET_DELAY", iface.useResetDelay);
            configuration.setAttribute(String.valueOf(attributeHeader) + "RESET_DELAY", iface.resetDelay);
        }
    }

    public void updatePanel() {
        this.updatePanelSelections();
        this.updatePanelEnables();
    }

    private void updatePanelEnables() {
        switch (this.current) {
            case MULTILINK: {
                this.parent.specifyIPButton.setEnabled(false);
                this.parent.specifyIPText.setEnabled(false);
                this.parent.specifyNetworkCardButton.setEnabled(false);
                this.parent.specifyNetworkCardText.setEnabled(false);
                this.parent.providePowerButton.setEnabled(true);
                this.parent.powerOffButton.setEnabled(true);
                this.parent.voltageCombo.setEnabled(false);
                this.parent.powerDownDelayText.setEnabled(true);
                this.parent.powerUpDelayText.setEnabled(true);
                this.parent.freqText.setEnabled(true);
                this.parent.delayAfterResetText.setEnabled(this.parent.delayAfterResetButton.getSelection());
                break;
            }
            case CYCLONE_SERIAL: 
            case CYCLONE_USB: 
            case TRACELINK_USB: {
                this.parent.specifyIPButton.setEnabled(false);
                this.parent.specifyIPText.setEnabled(false);
                this.parent.specifyNetworkCardButton.setEnabled(false);
                this.parent.specifyNetworkCardText.setEnabled(false);
                this.parent.providePowerButton.setEnabled(true);
                this.parent.powerOffButton.setEnabled(true);
                this.parent.voltageCombo.setEnabled(true);
                this.parent.powerDownDelayText.setEnabled(true);
                this.parent.powerUpDelayText.setEnabled(true);
                this.parent.freqText.setEnabled(true);
                this.parent.delayAfterResetText.setEnabled(this.parent.delayAfterResetButton.getSelection());
                break;
            }
            case CYCLONE_ETHERNET: 
            case TRACELINK_ETHERNET: {
                this.parent.specifyIPButton.setEnabled(true);
                this.parent.specifyIPText.setEnabled(this.parent.specifyIPButton.getSelection());
                this.parent.specifyNetworkCardButton.setEnabled(true);
                this.parent.specifyNetworkCardText.setEnabled(this.parent.specifyNetworkCardButton.getSelection());
                this.parent.providePowerButton.setEnabled(true);
                this.parent.powerOffButton.setEnabled(true);
                this.parent.voltageCombo.setEnabled(true);
                this.parent.powerDownDelayText.setEnabled(true);
                this.parent.powerUpDelayText.setEnabled(true);
                this.parent.freqText.setEnabled(true);
                this.parent.delayAfterResetText.setEnabled(this.parent.delayAfterResetButton.getSelection());
                break;
            }
            case OPENSDA: {
                this.parent.specifyIPButton.setEnabled(false);
                this.parent.specifyIPText.setEnabled(false);
                this.parent.specifyNetworkCardButton.setEnabled(false);
                this.parent.specifyNetworkCardText.setEnabled(false);
                this.parent.providePowerButton.setEnabled(false);
                this.parent.powerOffButton.setEnabled(false);
                this.parent.voltageCombo.setEnabled(false);
                this.parent.powerDownDelayText.setEnabled(false);
                this.parent.powerUpDelayText.setEnabled(false);
                this.parent.freqText.setEnabled(false);
                this.parent.delayAfterResetText.setEnabled(this.parent.delayAfterResetButton.getSelection());
            }
        }
    }

    private void updatePanelSelections() {
        HardwareInterface iface = this.interfaces.get((Object)this.current);
        this.parent.probeAddressCombo.setItems(TabDebugger.detectedHardwareInterfaces.get(this.current.ordinal()).getComboString());
        this.parent.probeAddressCombo.select(iface.hardwarePortIndex);
        this.parent.specifyIPButton.setSelection(iface.useCycloneIp);
        this.parent.specifyIPText.setText(iface.cycloneIp);
        this.parent.specifyNetworkCardButton.setSelection(iface.useNicIp);
        this.parent.specifyNetworkCardText.setText(iface.nicIp);
        this.parent.eraseButton.setSelection(iface.doMassErase);
        this.parent.swdButton.setSelection(iface.useSwd);
        this.parent.providePowerButton.setSelection(iface.doProvidePower);
        this.parent.powerOffButton.setSelection(iface.doPowerOff);
        this.parent.voltageCombo.select(iface.voltageOutputIndex);
        this.parent.powerDownDelayText.setText(iface.powerDownDelay);
        this.parent.powerUpDelayText.setText(iface.powerUpDelay);
        this.parent.freqText.setText(iface.shiftFrequency);
        this.parent.delayAfterResetButton.setSelection(iface.useResetDelay);
        this.parent.delayAfterResetText.setText(iface.resetDelay);
    }

    public void hardwareContextSwitch(int newInterface) {
        IPemicroUtil.interfaceType hw = IPemicroUtil.interfaceType.values()[newInterface];
        this.hardwareContextSwitch(hw);
    }

    public void hardwareContextSwitch(IPemicroUtil.interfaceType newInterface) {
        this.storePanelContext(this.current);
        this.current = newInterface;
        this.updatePanel();
    }

    private void storePanelContext(IPemicroUtil.interfaceType hw) {
        HardwareInterface iface = this.interfaces.get((Object)hw);
        int hwIndex = this.parent.probeAddressCombo.getSelectionIndex();
        iface.hardwarePortIndex = hwIndex = hwIndex == -1 ? 0 : hwIndex;
        iface.useCycloneIp = this.parent.specifyIPButton.getSelection();
        iface.cycloneIp = this.parent.specifyIPText.getText();
        iface.useNicIp = this.parent.specifyNetworkCardButton.getSelection();
        iface.nicIp = this.parent.specifyNetworkCardText.getText();
        iface.doMassErase = this.parent.eraseButton.getSelection();
        iface.useSwd = this.parent.swdButton.getSelection();
        iface.doProvidePower = this.parent.providePowerButton.getSelection();
        iface.doPowerOff = this.parent.powerOffButton.getSelection();
        iface.voltageOutputIndex = this.parent.voltageCombo.getSelectionIndex();
        iface.powerDownDelay = this.parent.powerDownDelayText.getText();
        iface.powerUpDelay = this.parent.powerUpDelayText.getText();
        iface.shiftFrequency = this.parent.freqText.getText();
        iface.useResetDelay = this.parent.delayAfterResetButton.getSelection();
        iface.resetDelay = this.parent.delayAfterResetText.getText();
    }

    public static String getAttributeHeader(int index) {
        return "com.pemicro.debug.gdbjtag.pne" + attributeHeaders[index];
    }

    private static class HardwareInterface {
        String attributeHeader;
        String defaultPowerDownDelay;
        String defaultPowerUpDelay;
        int hardwarePortIndex;
        boolean useCycloneIp;
        String cycloneIp;
        boolean useNicIp;
        String nicIp;
        boolean doMassErase;
        boolean useSwd;
        boolean doProvidePower;
        boolean doPowerOff;
        int voltageOutputIndex;
        String powerDownDelay;
        String powerUpDelay;
        String shiftFrequency;
        boolean useResetDelay;
        String resetDelay;

        private HardwareInterface() {
        }

        public String getAttributeHeader() {
            return "com.pemicro.debug.gdbjtag.pne" + this.attributeHeader;
        }
    }
}

