/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.ui;

import com.pemicro.debug.gdbjtag.pne.Activator;
import com.pemicro.debug.gdbjtag.pne.ui.Messages;
import java.io.File;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class TabStartup
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Startup";
    private static final String TAB_ID = "com.pemicro.debug.gdbjtag.pne.ui.startuptab";
    private Button enableSemihostingButton;
    private Button semihostingTelnetButton;
    private Button semihostingGdbClientButton;
    private Button enableTelnetConsoleButton;
    private Text telnetPortText;
    private Button loadSymbols;
    private Button useProjectBinaryForSymbols;
    private Label projBinaryLabel2;
    private Button useFileForSymbols;
    private Text symbolsFileName;
    private Button symbolsFileBrowseWs;
    private Button symbolsFileBrowse;
    private Label symbolsOffsetLabel;
    private Text symbolsOffset;
    private Button loadExecutable;
    private Button useProjectBinaryForImage;
    private Label projBinaryLabel1;
    private Button useFileForImage;
    private Text imageFileName;
    private Button imageFileBrowseWs;
    private Button imageFileBrowse;
    private Label imageOffsetLabel;
    private Text imageOffset;
    private Button attachToRunningButton;
    private Button doContinue;
    private Button setPcRegister;
    private Text pcRegister;
    private Button setStopAt;
    private Text stopAt;
    private Text runCommands;

    protected TabStartup() {
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getStartupTabImage();
    }

    public String getId() {
        return TAB_ID;
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.setControl((Control)sc);
        Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createSemihostingControl(comp);
        this.createLoadControl(comp);
        this.createRunOptionControl(comp);
        sc.setMinSize(comp.computeSize(-1, -1));
    }

    public void createSemihostingControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("StartupTab.semihostingGroupText"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.enableSemihostingButton = new Button(comp, 32);
        this.enableSemihostingButton.setText(Messages.getString("StartupTab.enableSemihosting_Text"));
        this.enableSemihostingButton.setToolTipText(Messages.getString("StartupTab.enableSemihosting_ToolTipText"));
        this.enableSemihostingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.doEnableSemihostingChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("StartupTab.enableSemihostingRouted_Text"));
        label.setToolTipText(Messages.getString("StartupTab.enableSemihostingRouted_ToolTipText"));
        this.semihostingTelnetButton = new Button(comp, 32);
        this.semihostingTelnetButton.setText(Messages.getString("StartupTab.semihostingTelnet_Text"));
        this.semihostingTelnetButton.setToolTipText(Messages.getString("StartupTab.semihostingTelnet_ToolTipText"));
        this.semihostingTelnetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.doTelnetChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.semihostingGdbClientButton = new Button(comp, 32);
        this.semihostingGdbClientButton.setText(Messages.getString("StartupTab.semihostingGdbClient_Text"));
        this.semihostingGdbClientButton.setToolTipText(Messages.getString("StartupTab.semihostingGdbClient_ToolTipText"));
        this.semihostingGdbClientButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.enableTelnetConsoleButton = new Button(comp, 32);
        this.enableTelnetConsoleButton.setText(Messages.getString("StartupTab.gdbServerAllocateSemihostingConsole_Label"));
        this.enableTelnetConsoleButton.setToolTipText(Messages.getString("StartupTab.gdbServerAllocateSemihostingConsole_ToolTipText"));
        this.enableTelnetConsoleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.getString("StartupTab.telnetPortText"));
        this.telnetPortText = new Text(comp, 2052);
        this.telnetPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.telnetPortText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
    }

    private void createLoadControl(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("StartupTab.loadGroup_Text"));
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.loadSymbols = new Button(comp, 32);
        this.loadSymbols.setText(Messages.getString("StartupTab.loadSymbols_Text"));
        Composite local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        local.setLayout((Layout)layout);
        local.setLayoutData((Object)new GridData(768));
        this.useProjectBinaryForSymbols = new Button(local, 16);
        this.useProjectBinaryForSymbols.setText(Messages.getString("StartupTab.useProjectBinary_Label"));
        this.useProjectBinaryForSymbols.setToolTipText(Messages.getString("StartupTab.useProjectBinary_ToolTip"));
        this.projBinaryLabel2 = new Label(local, 0);
        gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        this.projBinaryLabel2.setLayoutData((Object)gd);
        this.useFileForSymbols = new Button(local, 16);
        this.useFileForSymbols.setText(Messages.getString("StartupTab.useFile_Label"));
        this.symbolsFileName = new Text(local, 2048);
        gd = new GridData(768);
        this.symbolsFileName.setLayoutData((Object)gd);
        this.symbolsFileBrowseWs = this.createPushButton(local, Messages.getString("StartupTab.FileBrowseWs_Label"), null);
        this.symbolsFileBrowse = this.createPushButton(local, Messages.getString("StartupTab.FileBrowse_Label"), null);
        this.symbolsOffsetLabel = new Label(local, 0);
        this.symbolsOffsetLabel.setText(Messages.getString("StartupTab.symbolsOffsetLabel_Text"));
        this.symbolsOffset = new Text(local, 2048);
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        gd.widthHint = 100;
        this.symbolsOffset.setLayoutData((Object)gd);
        this.loadExecutable = new Button(comp, 32);
        this.loadExecutable.setText(Messages.getString("StartupTab.loadImage_Text"));
        local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        local.setLayout((Layout)layout);
        local.setLayoutData((Object)new GridData(768));
        this.useProjectBinaryForImage = new Button(local, 16);
        this.useProjectBinaryForImage.setText(Messages.getString("StartupTab.useProjectBinary_Label"));
        this.useProjectBinaryForImage.setToolTipText(Messages.getString("StartupTab.useProjectBinary_ToolTipText"));
        this.projBinaryLabel1 = new Label(local, 0);
        gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        this.projBinaryLabel1.setLayoutData((Object)gd);
        this.useFileForImage = new Button(local, 16);
        this.useFileForImage.setText(Messages.getString("StartupTab.useFile_Label"));
        this.imageFileName = new Text(local, 2048);
        gd = new GridData(768);
        this.imageFileName.setLayoutData((Object)gd);
        this.imageFileBrowseWs = this.createPushButton(local, Messages.getString("StartupTab.FileBrowseWs_Label"), null);
        this.imageFileBrowse = this.createPushButton(local, Messages.getString("StartupTab.FileBrowse_Label"), null);
        this.imageOffsetLabel = new Label(local, 0);
        this.imageOffsetLabel.setText(Messages.getString("StartupTab.imageOffsetLabel_Text"));
        this.imageOffset = new Text(local, 2048);
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        gd.widthHint = ((GridData)this.symbolsOffset.getLayoutData()).widthHint;
        this.imageOffset.setLayoutData((Object)gd);
        this.loadExecutable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.loadExecutableChanged();
                TabStartup.this.updateLaunchConfigurationDialog();
            }
        });
        SelectionListener radioButtonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.updateLaunchConfigurationDialog();
                TabStartup.this.updateUseFileEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.useProjectBinaryForImage.addSelectionListener(radioButtonListener);
        this.useFileForImage.addSelectionListener(radioButtonListener);
        this.useProjectBinaryForSymbols.addSelectionListener(radioButtonListener);
        this.useFileForSymbols.addSelectionListener(radioButtonListener);
        this.imageFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.imageFileBrowseWs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseWsButtonSelected(Messages.getString("StartupTab.imageFileBrowseWs_Title"), TabStartup.this.imageFileName);
            }
        });
        this.imageFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseButtonSelected(Messages.getString("StartupTab.imageFileBrowse_Title"), TabStartup.this.imageFileName);
            }
        });
        this.imageOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.imageOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.loadSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.loadSymbolsChanged();
                TabStartup.this.updateLaunchConfigurationDialog();
            }
        });
        this.symbolsFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.symbolsFileBrowseWs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseWsButtonSelected(Messages.getString("StartupTab.symbolsFileBrowseWs_Title"), TabStartup.this.symbolsFileName);
            }
        });
        this.symbolsFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseButtonSelected(Messages.getString("StartupTab.symbolsFileBrowse_Title"), TabStartup.this.symbolsFileName);
            }
        });
        this.symbolsOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.symbolsOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
    }

    public void createRunOptionControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("StartupTab.runOptionGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.attachToRunningButton = new Button(comp, 32);
        this.attachToRunningButton.setText(Messages.getString("StartupTab.ServerAttachButton"));
        this.attachToRunningButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.updateLaunchConfigurationDialog();
            }
        });
        this.doContinue = new Button(comp, 32);
        this.doContinue.setText(Messages.getString("StartupTab.doContinue_Text"));
        this.doContinue.setToolTipText(Messages.getString("StartupTab.doContinue_ToolTipText"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.doContinue.setLayoutData((Object)gd);
        this.doContinue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.setPcRegister = new Button(comp, 32);
        this.setPcRegister.setText(Messages.getString("StartupTab.setPcRegister_Text"));
        this.setPcRegister.setToolTipText(Messages.getString("StartupTab.setPcRegister_ToolTipText"));
        this.pcRegister = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        this.pcRegister.setLayoutData((Object)gd);
        this.setStopAt = new Button(comp, 32);
        this.setStopAt.setText(Messages.getString("StartupTab.setStopAt_Text"));
        this.stopAt = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        this.stopAt.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("StartupTab.extraRunCommands_Text"));
        label.setToolTipText(Messages.getString("StartupTab.extraRunCommands_ToolTipText"));
        this.runCommands = new Text(comp, 2626);
        gd = new GridData(1808);
        gd.heightHint = 60;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.runCommands.setLayoutData((Object)gd);
        this.setPcRegister.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.pcRegisterChanged();
                TabStartup.this.updateLaunchConfigurationDialog();
            }
        });
        this.pcRegister.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.setStopAt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.stopAtChanged();
                TabStartup.this.updateLaunchConfigurationDialog();
            }
        });
        this.stopAt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.runCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void browseWsButtonSelected(String title, Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(Messages.getString("StartupTab.FileBrowseWs_Message"));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getFullPath().toOSString();
            String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
            text.setText(fileLoc);
        }
    }

    private void doEnableSemihostingChanged() {
        boolean enabled = this.enableSemihostingButton.getSelection();
        this.semihostingTelnetButton.setEnabled(enabled);
        this.semihostingGdbClientButton.setEnabled(enabled);
        if (enabled) {
            this.doTelnetChanged();
        } else {
            this.telnetPortText.setEnabled(enabled);
            this.enableTelnetConsoleButton.setEnabled(enabled);
        }
    }

    private void doTelnetChanged() {
        boolean enabled = this.semihostingTelnetButton.getSelection();
        this.telnetPortText.setEnabled(enabled);
        this.enableTelnetConsoleButton.setEnabled(enabled);
    }

    private void updateUseFileEnablement() {
        boolean enabled = this.loadExecutable.getSelection() && this.useFileForImage.getSelection();
        this.imageFileName.setEnabled(enabled);
        this.imageFileBrowseWs.setEnabled(enabled);
        this.imageFileBrowse.setEnabled(enabled);
        enabled = this.loadSymbols.getSelection() && this.useFileForSymbols.getSelection();
        this.symbolsFileName.setEnabled(enabled);
        this.symbolsFileBrowseWs.setEnabled(enabled);
        this.symbolsFileBrowse.setEnabled(enabled);
    }

    private void loadExecutableChanged() {
        boolean enabled = this.loadExecutable.getSelection();
        this.useProjectBinaryForImage.setEnabled(enabled);
        this.useFileForImage.setEnabled(enabled);
        this.imageOffset.setEnabled(enabled);
        this.imageOffsetLabel.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    private void loadSymbolsChanged() {
        boolean enabled = this.loadSymbols.getSelection();
        this.useProjectBinaryForSymbols.setEnabled(enabled);
        this.useFileForSymbols.setEnabled(enabled);
        this.symbolsOffset.setEnabled(enabled);
        this.symbolsOffsetLabel.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    private void pcRegisterChanged() {
        this.pcRegister.setEnabled(this.setPcRegister.getSelection());
    }

    private void stopAtChanged() {
        this.stopAt.setEnabled(this.setStopAt.getSelection());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        Path filePath;
        String path;
        if (!super.isValid(launchConfig)) {
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.loadExecutable.getSelection()) {
            if (!this.useProjectBinaryForImage.getSelection()) {
                if (this.imageFileName.getText().trim().length() == 0) {
                    this.setErrorMessage(Messages.getString("StartupTab.imageFileName_not_specified"));
                    return false;
                }
                try {
                    path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.imageFileName.getText().trim());
                    filePath = new Path(path);
                    if (!filePath.toFile().exists()) {
                        this.setErrorMessage(Messages.getString("StartupTab.imageFileName_does_not_exist"));
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    this.setErrorMessage(Messages.getString("StartupTab.imageFileName_does_not_exist"));
                    return false;
                }
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.loadSymbols.getSelection()) {
            if (!this.useProjectBinaryForSymbols.getSelection()) {
                if (this.symbolsFileName.getText().trim().length() == 0) {
                    this.setErrorMessage(Messages.getString("StartupTab.symbolsFileName_not_specified"));
                    return false;
                }
                try {
                    path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.symbolsFileName.getText().trim());
                    filePath = new Path(path);
                    if (!filePath.toFile().exists()) {
                        this.setErrorMessage(Messages.getString("StartupTab.symbolsFileName_does_not_exist"));
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    this.setErrorMessage(Messages.getString("StartupTab.symbolsFileName_does_not_exist"));
                    return false;
                }
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.setPcRegister.getSelection()) {
            if (this.pcRegister.getText().trim().length() == 0) {
                this.setErrorMessage(Messages.getString("StartupTab.pcRegister_not_specified"));
                return false;
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.setStopAt.getSelection()) {
            if (this.stopAt.getText().trim().length() == 0) {
                this.setErrorMessage(Messages.getString("StartupTab.stopAt_not_specified"));
            }
        } else {
            this.setErrorMessage(null);
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihosting", true);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientTelnet", true);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientGdbClient", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.gdbServerTelnetPortNumber", 51794);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.doGdbServerAllocateSemihostingConsole", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", "main");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.attachToRunning", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.otherRunCommands", "");
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.doContinue", true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.enableSemihostingButton.setSelection(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihosting", true));
            this.semihostingTelnetButton.setSelection(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientTelnet", true));
            this.semihostingGdbClientButton.setSelection(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientGdbClient", false));
            this.telnetPortText.setText(Integer.toString(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.gdbServerTelnetPortNumber", 51794)));
            this.enableTelnetConsoleButton.setSelection(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.doGdbServerAllocateSemihostingConsole", true));
            configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", "");
            this.enableSemihostingButton.setEnabled(true);
            this.doEnableSemihostingChanged();
            this.loadExecutable.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", true));
            this.useProjectBinaryForImage.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true));
            this.useFileForImage.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", false));
            this.imageFileName.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", ""));
            this.imageOffset.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", ""));
            this.loadSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true));
            this.useProjectBinaryForSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true));
            this.useFileForSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", false));
            this.symbolsFileName.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", ""));
            this.symbolsOffset.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", ""));
            this.attachToRunningButton.setSelection(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.attachToRunning", false));
            this.setPcRegister.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false));
            this.pcRegister.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", ""));
            this.setStopAt.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", true));
            this.stopAt.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", "main"));
            this.runCommands.setText(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.otherRunCommands", ""));
            this.doContinue.setSelection(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.doContinue", true));
            String programName = CDebugUtils.getProgramName((ILaunchConfiguration)configuration);
            if (programName != null) {
                int lastSlash = programName.indexOf(92);
                if (lastSlash >= 0) {
                    programName = programName.substring(lastSlash + 1);
                }
                if ((lastSlash = programName.indexOf(47)) >= 0) {
                    programName = programName.substring(lastSlash + 1);
                }
                this.projBinaryLabel1.setText(programName);
                this.projBinaryLabel2.setText(programName);
            }
            this.loadExecutableChanged();
            this.loadSymbolsChanged();
            this.updateUseFileEnablement();
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihosting", this.enableSemihostingButton.getSelection());
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientTelnet", this.semihostingTelnetButton.getSelection());
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientGdbClient", this.semihostingGdbClientButton.getSelection());
        int port = Integer.parseInt(this.telnetPortText.getText().trim());
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.gdbServerTelnetPortNumber", port);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.doGdbServerAllocateSemihostingConsole", this.enableTelnetConsoleButton.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", this.loadExecutable.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", this.useProjectBinaryForImage.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", this.useFileForImage.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", this.imageFileName.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", this.imageOffset.getText());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", this.loadSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", this.useProjectBinaryForSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", this.useFileForSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", this.symbolsFileName.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", this.symbolsOffset.getText());
        boolean inputBool = this.attachToRunningButton.getSelection();
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.attachToRunning", inputBool);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", this.setPcRegister.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", this.pcRegister.getText());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", this.setStopAt.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", this.stopAt.getText());
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.otherRunCommands", this.runCommands.getText());
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.doContinue", this.doContinue.getSelection());
    }
}

