/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.IRenameParticipant;
import com.nxp.s32ds.ext.ide.validation.ui.TextChangeFinder;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public class GdbResourcesRefactoring
implements IRenameParticipant {
    public static String BUNDLE_ID = "com.nxp.s32ds.ext.ide.ui.refactoring";
    public static final String[] GDB_FILES = new String[]{"*.gdbinit"};

    public IStatus renameProject(IProject resources, String search, String replace, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.applyOperation((IResource)resources, GDB_FILES, search, replace, monitor);
    }

    private IStatus applyOperation(IResource projects, String[] filesExt, String search, String replace, IProgressMonitor monitor) {
        MultiStatus mtStatus = new MultiStatus(BUNDLE_ID, 0, "", null);
        try {
            List fileForRenameNotMatcher = TextChangeFinder.findResourceOutofMatching((IResource)projects, (String[])filesExt, (String)search, (String)replace, (IProgressMonitor)monitor);
            if (!fileForRenameNotMatcher.isEmpty()) {
                for (IFile file : fileForRenameNotMatcher) {
                    mtStatus.add(this.renameFile(file, search, replace, monitor));
                }
            }
        }
        catch (CoreException e) {
            mtStatus.add(e.getStatus());
        }
        return mtStatus;
    }
}

