/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.validation.core;

import com.nxp.s32ds.ext.cdt.internal.validation.core.Messages;
import com.nxp.s32ds.ext.ide.checker.IResourceChecker;
import com.nxp.s32ds.ext.ide.validation.core.RefreshPolicyMarker;
import java.util.function.Predicate;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class CdtRefreshPolicyChecker
implements IResourceChecker {
    public IStatus check(IResource resource, IProgressMonitor monitor) {
        if (resource instanceof IProject && CoreModel.hasCNature((IProject)((IProject)resource))) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String resourceName = resource.getName();
            IProject project = root.getProject(resourceName);
            RefreshScopeManager rsm = RefreshScopeManager.getInstance();
            MultiStatus ms = new MultiStatus("com.nxp.s32ds.validation.project", 0, Messages.RefreshPolicyValidator_refresh_failed, null);
            rsm.getConfigurationToResourcesMap(project).forEach((config, map) -> {
                Predicate<IResource> namesAreEqual = res -> res.getName().equals(resourceName);
                boolean noneMatch = map.keySet().stream().noneMatch(namesAreEqual);
                if (noneMatch) {
                    ms.add(RefreshPolicyMarker.createMarker((String)config, (IProject)project, (String)resourceName));
                }
            });
        }
        return Status.OK_STATUS;
    }
}

