package com.freescale.s32ds.cross.sdk.s32k118_1_8_8.pexconf;

import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SdkAttachStatusHandler;

public abstract class APExConfig implements ISDKHook {
    protected static final int MODE_BEFORE_ATTACH_ALL = ISDKHook.STATE_ATTACH_ALL + ISDKHook.TIME_BEFORE;
    protected static final int MODE_AFTER_ATTACH_ALL = ISDKHook.STATE_ATTACH_ALL + ISDKHook.TIME_AFTER;

    private static final String ATTACH_CONFIRMATION_MESSAGE = "Project's structure and settings can be changed after this SDK will be attached to it. Are you sure to continue?"; //$NON-NLS-1$

    @Override
    public IStatus checkPreconditions(int mode, ISDK sdk, Map<String, Object> context) {
        if (mode == MODE_BEFORE_ATTACH_ALL) {
            IStatus status = new Status(IStatus.WARNING, SDKSupportPlugin.getUniqueIdentifier(),
                    SdkAttachStatusHandler.CHECK_ATTACH_PRECONDITIONS, ATTACH_CONFIRMATION_MESSAGE, null);
            return status;
        }
        return Status.OK_STATUS;
    }
}
