/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.model;

import com.nxp.s32ds.cle.spt.model.ISptDefinition;
import com.nxp.s32ds.cle.spt.model.ISptInstructionsHolder;
import com.nxp.s32ds.cle.spt.model.SptDirective;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class SptDefinition
implements ISptDefinition {
    private Set<ISptInstructionsHolder> holders = new LinkedHashSet<ISptInstructionsHolder>();
    private String version;
    private String toolsLocation;

    public SptDefinition(String version, String toolsLocation) {
        this.version = version;
        this.toolsLocation = toolsLocation;
    }

    @Override
    public void addHolder(ISptInstructionsHolder holder) {
        this.holders.add(holder);
    }

    @Override
    public Set<ISptInstructionsHolder> getHolders() {
        return this.holders.size() > 1 ? this.holders : Collections.emptySet();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setToolsLocation(String toolsLocation) {
        this.toolsLocation = toolsLocation;
    }

    @Override
    public String getToolsLocation() {
        return this.toolsLocation;
    }

    @Override
    public void addDirectives(ISptInstructionsHolder directives) {
        this.addHolder(this.initDirectives(directives));
    }

    private ISptInstructionsHolder initDirectives(ISptInstructionsHolder directives) {
        directives.getInstructions().stream().filter(i -> i instanceof SptDirective).forEach(d -> ((SptDirective)d).init(this));
        return directives;
    }
}

