/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.model;

import com.nxp.s32ds.cle.spt.model.ISptDefinition;
import com.nxp.s32ds.cle.spt.model.ISptInstructionsHolder;
import com.nxp.s32ds.cle.spt.model.SptDefinition;
import com.nxp.s32ds.cle.spt.model.SptDirective;
import com.nxp.s32ds.cle.spt.model.SptIncludeDirective;
import com.nxp.s32ds.cle.spt.model.SptInstructionParamType;
import com.nxp.s32ds.cle.spt.model.SptInstructionsHolder;
import java.util.Set;
import java.util.TreeSet;

public class SptDefinitions {
    public static final String ROOT_NAME = "SPT Instructions";
    private ISptInstructionsHolder directives;
    private Set<ISptInstructionsHolder> definitions = new TreeSet<ISptInstructionsHolder>();

    public SptDefinitions() {
        this.directives = new SptInstructionsHolder(ISptInstructionsHolder.Type.DIRECTIVES);
        this.createDirectives();
    }

    public void addHolder(ISptInstructionsHolder holder) {
        this.definitions.add(holder);
    }

    public ISptDefinition getDefinition(String version, String toolsLocation) {
        SptDefinition definition = new SptDefinition(version, toolsLocation);
        for (ISptInstructionsHolder h : this.definitions) {
            if (!h.matchVersion(version)) continue;
            definition.addDirectives(this.directives);
            definition.addHolder(h);
        }
        return definition;
    }

    private void createDirectives() {
        this.directives.addInstruction(new SptDirective(SptInstructionParamType.EXTERN));
        this.directives.addInstruction(new SptDirective(SptInstructionParamType.GLOBAL));
        this.directives.addInstruction(new SptDirective(SptInstructionParamType.LABEL));
        this.directives.addInstruction(new SptDirective(SptInstructionParamType.SECTION));
        this.directives.addInstruction(new SptIncludeDirective());
    }
}

