/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.model;

import com.nxp.s32ds.cle.spt.model.ISptInstruction;
import com.nxp.s32ds.cle.spt.model.ISptInstructionGroup;
import com.nxp.s32ds.cle.spt.model.ISptInstructionParam;
import com.nxp.s32ds.cle.spt.model.SptInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SptInstructionGroup
extends SptInstruction
implements ISptInstructionGroup {
    private Set<ISptInstruction> instructions = new TreeSet<ISptInstruction>();
    private Set<ISptInstructionGroup> instructionsGroups = new TreeSet<ISptInstructionGroup>();
    private ISptInstructionGroup holderGroup;

    public SptInstructionGroup(String name, String[] mnemonics, ISptInstructionGroup holderGroup) {
        super(name, mnemonics);
        this.holderGroup = holderGroup;
    }

    @Override
    public void addInstruction(ISptInstruction instruction) {
        this.instructions.add(instruction);
    }

    @Override
    public Set<ISptInstruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public boolean hasInstructions() {
        return !this.instructions.isEmpty();
    }

    @Override
    public void addInstructionsGroup(ISptInstructionGroup instructionsGroup) {
        this.instructionsGroups.add(instructionsGroup);
    }

    @Override
    public Set<ISptInstructionGroup> getInstructionsGroup() {
        return this.instructionsGroups;
    }

    @Override
    public boolean hasInstructionsGroups() {
        return !this.instructionsGroups.isEmpty();
    }

    @Override
    public ISptInstructionGroup getHolderGroup() {
        return this.holderGroup;
    }

    @Override
    public List<String> getMnemonics() {
        if ((this.mnemonics == null || this.mnemonics.isEmpty()) && this.holderGroup != null) {
            return this.holderGroup.getMnemonics();
        }
        return this.mnemonics;
    }

    @Override
    public List<ISptInstructionParam> getParams() {
        ArrayList<ISptInstructionParam> result = new ArrayList<ISptInstructionParam>();
        if (this.holderGroup != null) {
            result.addAll(this.holderGroup.getParams());
        }
        result.addAll(this.params);
        return result;
    }
}

