/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.model;

import com.nxp.s32ds.cle.spt.model.ISptInstruction;
import com.nxp.s32ds.cle.spt.model.ISptInstructionOption;
import com.nxp.s32ds.cle.spt.model.ISptInstructionsHolder;
import com.nxp.s32ds.cle.spt.model.ISptRegister;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SptInstructionsHolder
implements ISptInstructionsHolder,
Comparable<SptInstructionsHolder> {
    private ISptInstructionsHolder.Type type;
    private String name;
    private String version;
    private Map<String, ISptRegister> registers;
    private Set<ISptInstruction> instructions;
    private Map<String, ISptInstructionOption> options;

    public SptInstructionsHolder(ISptInstructionsHolder.Type type, String version) {
        this.type = type;
        this.version = version;
        this.setName(type, version);
        this.instructions = new TreeSet<ISptInstruction>();
        this.options = new HashMap<String, ISptInstructionOption>();
        this.registers = new HashMap<String, ISptRegister>();
    }

    public SptInstructionsHolder(ISptInstructionsHolder.Type type) {
        this(type, null);
    }

    @Override
    public void addInstruction(ISptInstruction instruction) {
        this.instructions.add(instruction);
    }

    @Override
    public boolean hasInstructions() {
        return !this.instructions.isEmpty();
    }

    @Override
    public Set<ISptInstruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ISptInstructionsHolder.Type getType() {
        return this.type;
    }

    @Override
    public boolean matchVersion(String version) {
        return this.version == null || this.version.isEmpty() || this.version.equals(version);
    }

    @Override
    public int compareTo(SptInstructionsHolder instructionsHolder) {
        return this.name.compareTo(instructionsHolder.getName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SptInstructionsHolder other = (SptInstructionsHolder)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    private void setName(ISptInstructionsHolder.Type type, String version) {
        StringBuilder sb = new StringBuilder(type.getTypeName());
        if (version != null) {
            sb.append(' ').append('(').append(version).append(')');
        }
        this.name = sb.toString();
    }

    @Override
    public void addOption(ISptInstructionOption option) {
        this.options.put(option.getName(), option);
    }

    @Override
    public ISptInstructionOption getOption(String name) {
        return this.options.get(name);
    }

    @Override
    public void addRegister(ISptRegister register) {
        this.registers.put(register.getName(), register);
    }

    @Override
    public ISptRegister getRegister(String name) {
        return this.registers.get(name);
    }
}

