/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.ui.navigator;

import com.nxp.s32ds.cle.spt.core.ISptToolsLocationResolver;
import com.nxp.s32ds.cle.spt.core.ISptVersionResolver;
import com.nxp.s32ds.cle.spt.model.ISptDefinition;
import com.nxp.s32ds.cle.spt.model.SptDefinitions;
import com.nxp.s32ds.ext.ide.ui.selection.SelectionUtils;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;

public class SptExplorerService {
    private static final String BUNDLE_CLE_SPT_CORE = "com.nxp.s32ds.cle.spt.core";
    private static final String EXT_POINT_SPT_VERSION_RESOLVERS = "sptVersionResolvers";
    private static final String EXT_POINT_SPT_TOOLS_LOCATION_RESOLVERS = "sptToolsLocationResolvers";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_RESOLVER = "resolver";
    private static List<ISptVersionResolver> resolvers = Extensions.createSimpleExecutableExtensions((String)"com.nxp.s32ds.cle.spt.core", (String)"sptVersionResolvers", (String)"resolver", (String)"class", ISptVersionResolver.class);
    private static List<ISptToolsLocationResolver> toolsLocationResolvers = Extensions.createSimpleExecutableExtensions((String)"com.nxp.s32ds.cle.spt.core", (String)"sptToolsLocationResolvers", (String)"resolver", (String)"class", ISptToolsLocationResolver.class);

    public static ISptDefinition loadSptDefinition(ISelection selection, SptDefinitions sptDefinitions) {
        String version = null;
        Object selectedObject = SelectionUtils.getObjectFromSelection((ISelection)selection);
        for (ISptVersionResolver resolver : resolvers) {
            version = resolver.resolve(selectedObject);
            if (version != null && !version.isEmpty()) break;
        }
        String toolsLocation = SptExplorerService.resolveSptToolsLocation(version);
        ISptDefinition definition = sptDefinitions.getDefinition(version, toolsLocation);
        return definition;
    }

    public static String resolveSptToolsLocation(String version) {
        String toolsLocation = null;
        for (ISptToolsLocationResolver resolver : toolsLocationResolvers) {
            toolsLocation = resolver.resolve((Object)version);
            if (toolsLocation != null && !toolsLocation.isEmpty()) break;
        }
        return toolsLocation;
    }
}

