/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.ppc.ui;

import com.pemicro.debug.gdbjtag.ppc.ConfigurationAttributes;
import com.pemicro.debug.gdbjtag.ppc.ui.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CMainTab;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TabMain
extends CMainTab {
    private ElfFileEntry[] elfFileEntryArray;
    private int numberElfEntries;
    private Label numberEntriesLabel;
    private Text numberEntriesText;
    private Button generateElfFieldsButton;
    private ScrolledComposite scrolledelfComp;
    private Composite elfComp;
    private Label errorLabel;

    public TabMain() {
        super(10);
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    public String[] getAdditionalElfFiles() {
        String[] additionalElvesToProgram = new String[this.numberElfEntries];
        if (this.elfFileEntryArray != null && this.numberElfEntries > 0) {
            int i = 0;
            while (i < this.numberElfEntries) {
                additionalElvesToProgram[i] = this.elfFileEntryArray[i].elfText.getText();
                ++i;
            }
        }
        return additionalElvesToProgram;
    }

    public String[] getAdditionalElfFilesOffset() {
        String[] additionalElvesToProgramOffset = new String[this.numberElfEntries];
        if (this.elfFileEntryArray != null && this.numberElfEntries > 0) {
            int i = 0;
            while (i < this.numberElfEntries) {
                additionalElvesToProgramOffset[i] = this.elfFileEntryArray[i].imageOffset.getText();
                ++i;
            }
        }
        return additionalElvesToProgramOffset;
    }

    protected void generateAdditionalElfEntries(String numberEntriesString) {
        if (this.elfFileEntryArray != null && this.numberElfEntries > 0) {
            ElfFileEntry[] elfFileEntryArray = this.elfFileEntryArray;
            int n = this.elfFileEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ElfFileEntry elfEntry = elfFileEntryArray[n2];
                elfEntry.close();
                ++n2;
            }
        }
        try {
            this.numberElfEntries = Integer.parseInt(numberEntriesString);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.elfFileEntryArray = new ElfFileEntry[this.numberElfEntries];
        int i = 0;
        while (i < this.numberElfEntries) {
            this.elfFileEntryArray[i] = new ElfFileEntry();
            this.elfFileEntryArray[i].createElfEntry(this.elfComp, i + 1);
            ++i;
        }
        this.scrolledelfComp.setMinSize(this.elfComp.computeSize(-1, -1));
        this.scrolledelfComp.layout(true);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        String[] additionalElvesToProgram = this.getAdditionalElfFiles();
        ArrayList<String> addElvesList = new ArrayList<String>();
        String[] stringArray = additionalElvesToProgram;
        int n = additionalElvesToProgram.length;
        int n2 = 0;
        while (n2 < n) {
            String additionalElf = stringArray[n2];
            addElvesList.add(additionalElf);
            ++n2;
        }
        config.setAttribute("com.pemicro.debug.gdbjtag.ppc.ELVES", addElvesList);
        config.setAttribute("com.pemicro.debug.gdbjtag.ppc.NUMBER_ELVES", this.numberElfEntries);
        String[] additionalElvesToProgramOffset = this.getAdditionalElfFilesOffset();
        ArrayList<String> addElvesOffsetList = new ArrayList<String>();
        String[] stringArray2 = additionalElvesToProgramOffset;
        int n3 = additionalElvesToProgramOffset.length;
        int n4 = 0;
        while (n4 < n3) {
            String additionalElfOffset = stringArray2[n4];
            addElvesOffsetList.add(additionalElfOffset);
            ++n4;
        }
        config.setAttribute("com.pemicro.debug.gdbjtag.ppc.ELVES_OFFSET", addElvesOffsetList);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        int numberelves = 0;
        List addElvesList = new ArrayList();
        List addElvesOffsetList = new ArrayList();
        try {
            numberelves = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.NUMBER_ELVES", 0);
            addElvesList = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.ELVES", ConfigurationAttributes.ADDITIONAL_ELVES_DEFAULT);
            addElvesOffsetList = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.ELVES_OFFSET", ConfigurationAttributes.ADDITIONAL_ELVES_OFFSET_DEFAULT);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.generateAdditionalElfEntries(Integer.toString(numberelves));
        this.numberEntriesText.setText(Integer.toString(numberelves));
        if (!addElvesList.isEmpty()) {
            int i = 0;
            while (i < this.numberElfEntries) {
                this.elfFileEntryArray[i].elfText.setText((String)addElvesList.get(i));
                if (addElvesOffsetList.size() == this.numberElfEntries) {
                    this.elfFileEntryArray[i].imageOffset.setText((String)addElvesOffsetList.get(i));
                }
                ++i;
            }
        }
    }

    protected void createProjectGroup(Composite parent, int colSpan) {
        super.createProjectGroup(parent, colSpan);
        this.scrolledelfComp = new ScrolledComposite(parent, 2560);
        this.scrolledelfComp.setLayout((Layout)new GridLayout());
        this.scrolledelfComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledelfComp.setExpandVertical(true);
        this.scrolledelfComp.setExpandHorizontal(true);
        this.scrolledelfComp.setAlwaysShowScrollBars(true);
        this.elfComp = new Composite((Composite)this.scrolledelfComp, 0);
        GridLayout elfLayout = new GridLayout(2, false);
        elfLayout.numColumns = 5;
        elfLayout.marginHeight = 0;
        elfLayout.marginWidth = 0;
        elfLayout.marginLeft = 5;
        elfLayout.marginTop = 5;
        elfLayout.marginBottom = 5;
        this.elfComp.setLayout((Layout)elfLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        this.elfComp.setLayoutData((Object)gd);
        this.numberEntriesLabel = new Label(this.elfComp, 0);
        this.numberEntriesLabel.setText(Messages.getString("MainTab.ElfFieldGeneratorLabel"));
        this.numberEntriesText = new Text(this.elfComp, 133120);
        gd = new GridData();
        gd.widthHint = 50;
        this.numberEntriesText.setLayoutData((Object)gd);
        this.numberEntriesText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                char[] chrArray;
                char[] cArray = chrArray = event.text.toCharArray();
                int n = chrArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char chr = cArray[n2];
                    if ((chr < '0' || chr > '9') && event.character != '\b' && event.character != '\u007f') {
                        event.doit = false;
                    }
                    ++n2;
                }
            }
        });
        this.generateElfFieldsButton = new Button(this.elfComp, 16384);
        this.generateElfFieldsButton.setText(Messages.getString("MainTab.ElfFieldGeneratorButton"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.generateElfFieldsButton.setLayoutData((Object)gd);
        this.generateElfFieldsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String currentNumberEntries = TabMain.this.numberEntriesText.getText();
                try {
                    if (Integer.parseInt(currentNumberEntries) > 16) {
                        TabMain.this.numberEntriesText.setText("16");
                        currentNumberEntries = "";
                        TabMain.this.generateAdditionalElfEntries("0");
                        TabMain.this.errorLabel.setText("You must select 16 ELF entries or less");
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                if (!currentNumberEntries.isEmpty()) {
                    TabMain.this.errorLabel.setText("");
                    TabMain.this.generateAdditionalElfEntries(currentNumberEntries);
                }
                TabMain.this.updateLaunchConfigurationDialog();
            }
        });
        this.errorLabel = new Label(this.elfComp, 0x1000000);
        this.scrolledelfComp.setContent((Control)this.elfComp);
        this.scrolledelfComp.setMinSize(this.elfComp.computeSize(0, 0));
    }

    class ElfFileEntry {
        Label elfLabel;
        Text elfText;
        Button browseForElf;
        Button variableButton;
        Label imageOffsetLabel;
        Text imageOffset;

        ElfFileEntry() {
        }

        protected void createElfEntry(Composite parent, final int index) {
            this.elfLabel = new Label(parent, 16384);
            this.elfLabel.setText(String.format(Messages.getString("MainTab.ElfLabel"), index));
            GridData gd = new GridData();
            gd.horizontalSpan = 5;
            this.elfLabel.setLayoutData((Object)gd);
            this.elfText = new Text(parent, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.elfText.setLayoutData((Object)gd);
            this.elfText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TabMain.this.updateLaunchConfigurationDialog();
                }
            });
            this.browseForElf = TabMain.this.createPushButton(parent, LaunchMessages.getString((String)"Launch.common.Browse_3"), null);
            this.browseForElf.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String text = TabMain.this.handleBrowseButtonSelected(String.format(Messages.getString("MainTab.ElfBrowser"), index));
                    ElfFileEntry.this.elfText.setText(text);
                    TabMain.this.updateLaunchConfigurationDialog();
                }
            });
            this.variableButton = TabMain.this.createPushButton(parent, Messages.getString("MainTab.ClientVariablesButton"), null);
            this.variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TabMain.this.variablesButtonSelected(ElfFileEntry.this.elfText);
                }
            });
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            comp.setLayout((Layout)layout);
            this.imageOffsetLabel = new Label(comp, 16384);
            this.imageOffsetLabel.setText(String.format(Messages.getString("MainTab.ImageOffsetLabeLText"), index));
            this.imageOffset = new Text(comp, 2052);
            gd = new GridData();
            gd.widthHint = 100;
            gd.horizontalIndent = 5;
            this.imageOffset.setLayoutData((Object)gd);
            this.imageOffset.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
                }
            });
            this.imageOffset.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TabMain.this.updateLaunchConfigurationDialog();
                }
            });
        }

        protected void close() {
            this.elfLabel.dispose();
            this.elfText.dispose();
            this.browseForElf.dispose();
            this.variableButton.dispose();
            this.imageOffsetLabel.dispose();
            this.imageOffset.dispose();
        }
    }
}

