/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.advProgrammingOptions.widget;

import com.pemicro.debugView.CoreDebug;
import com.pemicro.forms.JFS;
import com.pemicro.forms.advProgrammingOptions.data.OptionsData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class OptionsDialog {
    private OptionsData data;
    private Composite parent;
    GridData errorListData = new GridData(1808);
    protected static final int maxAddressRanges = 30;
    protected static final String preservedRangeEnabledText = "Data that resides in a preserved range of memory will be maintained through erase/program cycles. Values will be masked to match the row size of the memory.";
    protected static final String preservedRangeDisabledText = "Preserve Range Functionality is not enabled for this Device/Algorithm.";
    protected static final int numGuiPreservedRanges = 3;
    private FileDialog dlg;
    private Group promptOnFlashGroup;
    private Button alwaysEraseCheckButton;
    private Button enableProgDlgCheckButton;
    private Group flashAlgorithmSelectionGroup;
    private Label flashAlgorithmLabel;
    private Label chipLogoLabel;
    private Button alternativeAlgorithmButton;
    private Button useAlternativeAlgorithmButton;
    private Group preserveRangeGroup;
    private Label preserveRangeCaption;
    private Button preserveRange1CheckButton;
    private Label from1Label;
    private Label to1Label;
    private Button preserveRange2CheckButton;
    private Label from2Label;
    private Label to2Label;
    private Button preserveRange3CheckButton;
    private Label from3Label;
    private Label to3Label;
    private Button preserveEEPROMCheckButton;
    private Group syncToPllGroup;
    private Button freqSyncChangeCheckButton;
    private List errorList;
    private Group trimGroup;
    private Button trimCheckButton;
    private Button doneButton;
    private Group customTrimGroup;
    private Label defaultTrimReferenceLabel;
    private Label customTrimDefaultLabel;
    private Label hz1Label;
    private Label customTrimLowLabel;
    private Label toLabel;
    private Label customTrimHighLabel;
    private Label hz2Label;
    private Button customTrimButton;
    private Text customTrimText;
    private Label hz3Label;
    private Group partitionGroup;
    private Button partitionCheckButton;
    private Text partitionText;
    private Label partitionLabel1;
    private Label partitionLabel2;
    private Label partitionLabel3;
    private Text to3Text;
    private Text from3Text;
    private Text to2Text;
    private Text from2Text;
    private Text to1Text;
    private Text from1Text;
    private Text fileName;
    private Combo flashAlgorithmCombo;
    private String userAlgorithm = "";
    private static final String[] filterNames = new String[]{"S08 Flash Algorithm (*.S8P)", "RS08 Flash Algorithm (*.R8P)", "CFV1 Flash Algorithm (*.CFP)", "ARM Flash Algorithm (*.ARP)", "PPCNEXUS Flash Algorithm (*.PCP)"};
    private static final String[] filterExts = new String[]{"*.s8p", "*.r8p", "*.cfp", "*.arp", "*.pcp"};
    private boolean alternativeAlgorithmChosen = false;

    public OptionsDialog(Composite parent, OptionsData optionsData) {
        Control child;
        this.data = optionsData;
        this.parent = parent;
        boolean errorDetected = !this.data.getPreserve1StartError().equals("") || !this.data.getPreserve1EndError().equals("") || !this.data.getPreserve2StartError().equals("") || !this.data.getPreserve2EndError().equals("") || !this.data.getPreserve3StartError().equals("") || !this.data.getPreserve3EndError().equals("") || !this.data.getOverlap1and2Error().equals("") || !this.data.getOverlap1and3Error().equals("") || !this.data.getOverlap2and3Error().equals("") || !this.data.getCustomTrimError().equals("");
        final boolean altAlgorithm = !this.data.getAltAlgorithm0().equals("") || !this.data.getAltAlgorithm1().equals("") || !this.data.getAltAlgorithm2().equals("") || !this.data.getAltAlgorithm3().equals("") || !this.data.getAltAlgorithm4().equals("") || !this.data.getAltAlgorithm5().equals("") || !this.data.getAltAlgorithm6().equals("") || !this.data.getAltAlgorithm7().equals("") || !this.data.getAltAlgorithm8().equals("") || !this.data.getAltAlgorithm9().equals("");
        final boolean preserveRangeIsEnabled = this.data.getArchitecture().toLowerCase().contains("hcs08") || this.data.getArchitecture().toLowerCase().contains("cfv1") || this.data.getArchitecture().toLowerCase().contains("arm") || this.data.getArchitecture().toLowerCase().contains("ppc");
        boolean customTrimIsEnabled = this.data.getArchitecture().toLowerCase().contains("hcs08") || this.data.getArchitecture().toLowerCase().contains("rs08") || this.data.getArchitecture().toLowerCase().contains("cfv1");
        Font labelFontBold = new Font((Device)parent.getDisplay(), JFS.ADVPROG_LABEL_FONT_BOLD);
        parent.setLayout((Layout)new GridLayout(2, false));
        Canvas flashCanvas = new Canvas(parent, 0);
        flashCanvas.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(1808);
        flashCanvas.setLayoutData((Object)layoutData);
        this.dlg = new FileDialog(parent.getShell(), 4096);
        this.dlg.setFilterNames(filterNames);
        this.dlg.setFilterExtensions(filterExts);
        if (this.data.getArchitecture().toLowerCase().contains("hcs08")) {
            this.dlg.setFilterIndex(0);
        }
        if (this.data.getArchitecture().toLowerCase().contains("rs08")) {
            this.dlg.setFilterIndex(1);
        }
        if (this.data.getArchitecture().toLowerCase().contains("cfv1")) {
            this.dlg.setFilterIndex(2);
        }
        if (this.data.getArchitecture().toLowerCase().contains("arm")) {
            this.dlg.setFilterIndex(3);
        }
        if (this.data.getArchitecture().toLowerCase().contains("ppc")) {
            this.dlg.setFilterIndex(4);
        }
        this.promptOnFlashGroup = new Group((Composite)flashCanvas, 0);
        this.promptOnFlashGroup.setLayout((Layout)new GridLayout(1, false));
        this.promptOnFlashGroup.setText("Prompt on Flash Program?");
        layoutData = new GridData(768);
        this.promptOnFlashGroup.setLayoutData((Object)layoutData);
        this.alwaysEraseCheckButton = new Button((Composite)this.promptOnFlashGroup, 32);
        this.alwaysEraseCheckButton.setText("Always Erase and Program flash without asking.");
        this.alwaysEraseCheckButton.setSelection(true);
        this.alwaysEraseCheckButton.setEnabled(false);
        this.enableProgDlgCheckButton = new Button((Composite)this.promptOnFlashGroup, 32);
        this.enableProgDlgCheckButton.setText("Enable Flash Programming Dialog.");
        this.enableProgDlgCheckButton.setSelection(this.data.isEnableFlashProgDlg());
        this.flashAlgorithmSelectionGroup = new Group((Composite)flashCanvas, 0);
        this.flashAlgorithmSelectionGroup.setText("Flash Algorithm Selection");
        this.flashAlgorithmSelectionGroup.setLayout((Layout)new GridLayout(2, false));
        this.flashAlgorithmSelectionGroup.setLayoutData((Object)new GridData(1808));
        this.flashAlgorithmLabel = new Label((Composite)this.flashAlgorithmSelectionGroup, 64);
        this.flashAlgorithmLabel.setText("Use the Following Flash Algorithm when Programming Flash Data:\n(WARNING: Changing the algorithm will clear all preserved ranges)");
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.flashAlgorithmLabel.setLayoutData((Object)layoutData);
        this.flashAlgorithmCombo = new Combo((Composite)this.flashAlgorithmSelectionGroup, 8);
        this.flashAlgorithmCombo.setEnabled(altAlgorithm);
        this.flashAlgorithmCombo.add("(Default)");
        if (altAlgorithm) {
            if (!this.data.getAltAlgorithm0().equals("")) {
                this.flashAlgorithmCombo.add(this.data.getAltAlgorithm0());
            }
            if (!this.data.getAltAlgorithm1().equals("")) {
                this.flashAlgorithmCombo.add(this.data.getAltAlgorithm1());
            }
            if (!this.data.getAltAlgorithm2().equals("")) {
                this.flashAlgorithmCombo.add(this.data.getAltAlgorithm2());
            }
            if (!this.data.getAltAlgorithm3().equals("")) {
                this.flashAlgorithmCombo.add(this.data.getAltAlgorithm3());
            }
            if (!this.data.getAltAlgorithm4().equals("")) {
                this.flashAlgorithmCombo.add(this.data.getAltAlgorithm4());
            }
            if (!this.data.getAltAlgorithm5().equals("")) {
                this.flashAlgorithmCombo.add(this.data.getAltAlgorithm5());
            }
            if (!this.data.getAltAlgorithm6().equals("")) {
                this.flashAlgorithmCombo.add(this.data.getAltAlgorithm6());
            }
            if (!this.data.getAltAlgorithm7().equals("")) {
                this.flashAlgorithmCombo.add(this.data.getAltAlgorithm7());
            }
            if (!this.data.getAltAlgorithm8().equals("")) {
                this.flashAlgorithmCombo.add(this.data.getAltAlgorithm8());
            }
            if (!this.data.getAltAlgorithm9().equals("")) {
                this.flashAlgorithmCombo.add(this.data.getAltAlgorithm9());
            }
        }
        this.flashAlgorithmCombo.setText("(Default)");
        this.flashAlgorithmCombo.select((int)this.data.getCurrentAlgorithmIndex());
        layoutData = new GridData(776);
        this.flashAlgorithmCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CoreDebug.writeDebug(1, "Algorithm combo Changed");
                OptionsDialog.this.alternativeAlgorithmChosen = true;
            }
        });
        this.flashAlgorithmCombo.setLayoutData((Object)layoutData);
        this.chipLogoLabel = new Label((Composite)this.flashAlgorithmSelectionGroup, 0);
        Image img = new Image((Device)parent.getDisplay(), this.getClass().getResourceAsStream("/images/advProgrammingOptions/chip.bmp"));
        this.chipLogoLabel.setImage(img);
        layoutData = new GridData(1176);
        this.chipLogoLabel.setLayoutData((Object)layoutData);
        this.alternativeAlgorithmButton = new Button((Composite)this.flashAlgorithmSelectionGroup, 0);
        this.alternativeAlgorithmButton.setEnabled(this.data.isUseAlternativeAlgorithm());
        this.alternativeAlgorithmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.alternativeAlgorithmChosen = false;
                OptionsDialog.this.userAlgorithm = OptionsDialog.this.dlg.open();
                if (OptionsDialog.this.userAlgorithm == null) {
                    OptionsDialog.this.userAlgorithm = "Choose an Algorithm";
                }
                if (!OptionsDialog.this.userAlgorithm.equals(OptionsDialog.this.fileName.getText())) {
                    OptionsDialog.this.fileName.setText(OptionsDialog.this.userAlgorithm);
                    String[] subs = OptionsDialog.this.fileName.getText().split("\\.");
                    String extension = "";
                    if (subs.length != 0) {
                        extension = subs[subs.length - 1].toLowerCase();
                    }
                    if (extension.equals("s8p") || extension.equals("r8p") || extension.equals("cfp") || extension.equals("arp") || extension.equals("pcp")) {
                        OptionsDialog.this.alternativeAlgorithmChosen = true;
                    } else {
                        OptionsDialog.this.alternativeAlgorithmChosen = false;
                        OptionsDialog.this.useAlternativeAlgorithmButton.setSelection(false);
                        OptionsDialog.this.alternativeAlgorithmButton.setEnabled(false);
                        if (!OptionsDialog.this.userAlgorithm.equals("Choose an Algorithm")) {
                            OptionsDialog.this.fileName.setText("ERROR: Incorrect File");
                        }
                    }
                }
            }
        });
        this.alternativeAlgorithmButton.setText("Choose Alternative Algorithm");
        this.useAlternativeAlgorithmButton = new Button((Composite)this.flashAlgorithmSelectionGroup, 32);
        this.useAlternativeAlgorithmButton.setText("Use Alternative Algorithm");
        this.useAlternativeAlgorithmButton.setSelection(this.data.isUseAlternativeAlgorithm());
        this.useAlternativeAlgorithmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (OptionsDialog.this.useAlternativeAlgorithmButton.getSelection()) {
                    if (OptionsDialog.this.data.getUserAlgorithm().equals("")) {
                        OptionsDialog.this.fileName.setText("Choose an Algorithm");
                    } else {
                        OptionsDialog.this.fileName.setText(OptionsDialog.this.data.getUserAlgorithm());
                    }
                    if (OptionsDialog.this.fileName.getText().toLowerCase().contains("s8p") || OptionsDialog.this.fileName.getText().toLowerCase().contains("r8p") || OptionsDialog.this.fileName.getText().toLowerCase().contains("cfp") || OptionsDialog.this.fileName.getText().toLowerCase().contains("arp") || OptionsDialog.this.fileName.getText().toLowerCase().contains("pcp")) {
                        OptionsDialog.this.alternativeAlgorithmChosen = true;
                    } else {
                        OptionsDialog.this.alternativeAlgorithmChosen = false;
                    }
                    OptionsDialog.this.flashAlgorithmCombo.setEnabled(false);
                    OptionsDialog.this.alternativeAlgorithmButton.setEnabled(true);
                    OptionsDialog.this.fileName.setEnabled(true);
                } else {
                    OptionsDialog.this.alternativeAlgorithmChosen = true;
                    OptionsDialog.this.flashAlgorithmCombo.setEnabled(altAlgorithm);
                    OptionsDialog.this.from1Text.setEnabled(OptionsDialog.this.preserveRange1CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.from1Label.setEnabled(OptionsDialog.this.preserveRange1CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.to1Text.setEnabled(OptionsDialog.this.preserveRange1CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.to1Label.setEnabled(OptionsDialog.this.preserveRange1CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.from2Text.setEnabled(OptionsDialog.this.preserveRange2CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.from2Label.setEnabled(OptionsDialog.this.preserveRange2CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.to2Text.setEnabled(OptionsDialog.this.preserveRange2CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.to2Label.setEnabled(OptionsDialog.this.preserveRange2CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.from3Text.setEnabled(OptionsDialog.this.preserveRange3CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.from3Label.setEnabled(OptionsDialog.this.preserveRange3CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.to3Text.setEnabled(OptionsDialog.this.preserveRange3CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.to3Label.setEnabled(OptionsDialog.this.preserveRange3CheckButton.getSelection() && preserveRangeIsEnabled);
                    OptionsDialog.this.preserveRange1CheckButton.setEnabled(preserveRangeIsEnabled);
                    OptionsDialog.this.preserveRange2CheckButton.setEnabled(preserveRangeIsEnabled);
                    OptionsDialog.this.preserveRange3CheckButton.setEnabled(preserveRangeIsEnabled);
                    OptionsDialog.this.alternativeAlgorithmButton.setEnabled(false);
                    OptionsDialog.this.fileName.setEnabled(false);
                    if (OptionsDialog.this.data.getUserAlgorithm().equals("")) {
                        OptionsDialog.this.fileName.setText("Alternative Algorithm not Selected");
                    }
                }
            }
        });
        this.fileName = new Text((Composite)this.flashAlgorithmSelectionGroup, 2056);
        if (this.data.getUserAlgorithm().equals("")) {
            this.fileName.setText("Alternative Algorithm not Selected");
        } else {
            this.fileName.setText(this.data.getUserAlgorithm());
        }
        this.fileName.setEnabled(this.data.isUseAlternativeAlgorithm());
        this.preserveRangeGroup = new Group(parent, 0);
        this.preserveRangeGroup.setText("Non-Volatile Memory Preservation");
        this.preserveRangeGroup.setLayout((Layout)new GridLayout(4, false));
        this.preserveRangeGroup.setEnabled(preserveRangeIsEnabled);
        this.preserveRangeCaption = new Label((Composite)this.preserveRangeGroup, 64);
        this.preserveRangeCaption.setText(preservedRangeEnabledText);
        layoutData = new GridData();
        layoutData.horizontalSpan = 4;
        layoutData.widthHint = 205;
        this.preserveRangeCaption.setLayoutData((Object)layoutData);
        this.preserveRangeCaption.setEnabled(preserveRangeIsEnabled);
        this.preserveRange1CheckButton = new Button((Composite)this.preserveRangeGroup, 32);
        this.preserveRange1CheckButton.setText("Preserve this Range (Memory Range 1)");
        layoutData = new GridData();
        layoutData.horizontalSpan = 4;
        this.preserveRange1CheckButton.setLayoutData((Object)layoutData);
        this.preserveRange1CheckButton.setSelection(this.data.isPreserveRange1() && preserveRangeIsEnabled);
        this.from1Label = new Label((Composite)this.preserveRangeGroup, 0);
        this.from1Label.setFont(labelFontBold);
        this.from1Label.setText("From:");
        this.from1Label.setEnabled(this.data.isPreserveRange1());
        this.from1Text = new Text((Composite)this.preserveRangeGroup, 2048);
        this.from1Text.setText(this.data.getPreserveRange1Start());
        this.from1Text.setEnabled(this.data.isPreserveRange1());
        this.to1Label = new Label((Composite)this.preserveRangeGroup, 0);
        this.to1Label.setFont(labelFontBold);
        this.to1Label.setText("To:");
        this.to1Label.setEnabled(this.data.isPreserveRange1());
        this.to1Text = new Text((Composite)this.preserveRangeGroup, 2048);
        this.to1Text.setText(this.data.getPreserveRange1End());
        this.to1Text.setEnabled(this.data.isPreserveRange1());
        this.preserveRange2CheckButton = new Button((Composite)this.preserveRangeGroup, 32);
        layoutData = new GridData();
        layoutData.horizontalSpan = 4;
        this.preserveRange2CheckButton.setLayoutData((Object)layoutData);
        this.preserveRange2CheckButton.setText("Preserve this Range (Memory Range 2)");
        this.preserveRange2CheckButton.setSelection(this.data.isPreserveRange2());
        this.from2Label = new Label((Composite)this.preserveRangeGroup, 0);
        this.from2Label.setFont(labelFontBold);
        this.from2Label.setText("From:");
        this.from2Label.setEnabled(this.data.isPreserveRange2());
        this.from2Text = new Text((Composite)this.preserveRangeGroup, 2048);
        this.from2Text.setText(this.data.getPreserveRange2Start());
        this.from2Text.setEnabled(this.data.isPreserveRange2());
        this.to2Label = new Label((Composite)this.preserveRangeGroup, 0);
        this.to2Label.setFont(labelFontBold);
        this.to2Label.setText("To:");
        this.to2Label.setEnabled(this.data.isPreserveRange2());
        this.to2Text = new Text((Composite)this.preserveRangeGroup, 2048);
        this.to2Text.setText(this.data.getPreserveRange2End());
        this.to2Text.setEnabled(this.data.isPreserveRange2());
        this.preserveRange3CheckButton = new Button((Composite)this.preserveRangeGroup, 32);
        this.preserveRange3CheckButton.setText("Preserve this Range (Memory Range 3)");
        layoutData = new GridData();
        layoutData.horizontalSpan = 4;
        this.preserveRange3CheckButton.setLayoutData((Object)layoutData);
        this.preserveRange3CheckButton.setSelection(this.data.isPreserveRange3());
        this.from3Label = new Label((Composite)this.preserveRangeGroup, 0);
        this.from3Label.setFont(labelFontBold);
        this.from3Label.setText("From:");
        this.from3Label.setEnabled(this.data.isPreserveRange3());
        this.from3Text = new Text((Composite)this.preserveRangeGroup, 2048);
        this.from3Text.setText(this.data.getPreserveRange3Start());
        this.from3Text.setEnabled(this.data.isPreserveRange3());
        this.to3Label = new Label((Composite)this.preserveRangeGroup, 0);
        this.to3Label.setFont(labelFontBold);
        this.to3Label.setText("To:");
        this.to3Label.setEnabled(this.data.isPreserveRange3());
        this.to3Text = new Text((Composite)this.preserveRangeGroup, 2048);
        this.to3Text.setText(this.data.getPreserveRange3End());
        this.to3Text.setEnabled(this.data.isPreserveRange3());
        this.preserveEEPROMCheckButton = new Button((Composite)this.preserveRangeGroup, 32);
        this.preserveEEPROMCheckButton.setVisible(false);
        this.preserveEEPROMCheckButton.setText("Always Preserve All EEPROM Data");
        layoutData = new GridData();
        layoutData.horizontalSpan = 4;
        this.preserveEEPROMCheckButton.setLayoutData((Object)layoutData);
        this.preserveEEPROMCheckButton.setSelection(this.data.isPreserveEEProm());
        this.preserveEEPROMCheckButton.setEnabled(this.data.hasEEProm() && preserveRangeIsEnabled);
        this.syncToPllGroup = new Group(parent, 0);
        this.syncToPllGroup.setText("Sync to PLL Change");
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        this.syncToPllGroup.setLayout((Layout)new GridLayout(1, true));
        this.syncToPllGroup.setLayoutData((Object)layoutData);
        this.freqSyncChangeCheckButton = new Button((Composite)this.syncToPllGroup, 32);
        this.freqSyncChangeCheckButton.setEnabled(false);
        this.freqSyncChangeCheckButton.setSelection(true);
        this.freqSyncChangeCheckButton.setText("Automatically synchronize to the target frequency after each step");
        this.trimGroup = new Group(parent, 0);
        GridData trimData = new GridData(1808);
        trimData.horizontalSpan = 2;
        this.trimGroup.setLayoutData((Object)trimData);
        this.trimGroup.setLayout((Layout)new GridLayout(1, true));
        this.trimCheckButton = new Button((Composite)this.trimGroup, 32);
        this.trimCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.trimCheckButton.setText("Calculate Trim and Program the Non-Volatile Trim Register");
        this.trimCheckButton.setSelection(this.data.isDoTrim());
        this.preserveRange1CheckButton.setEnabled(preserveRangeIsEnabled);
        this.preserveRange2CheckButton.setEnabled(preserveRangeIsEnabled);
        this.preserveRange3CheckButton.setEnabled(preserveRangeIsEnabled);
        final Label tempTo1Label = this.to1Label;
        this.useAlternativeAlgorithmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.preserveRange1CheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (OptionsDialog.this.preserveRange1CheckButton.getSelection()) {
                    OptionsDialog.this.from1Label.setEnabled(true);
                    OptionsDialog.this.from1Text.setEnabled(true);
                    tempTo1Label.setEnabled(true);
                    OptionsDialog.this.to1Text.setEnabled(true);
                } else {
                    OptionsDialog.this.from1Label.setEnabled(false);
                    OptionsDialog.this.from1Text.setEnabled(false);
                    tempTo1Label.setEnabled(false);
                    OptionsDialog.this.to1Text.setEnabled(false);
                }
            }
        });
        this.preserveRange2CheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (OptionsDialog.this.preserveRange2CheckButton.getSelection()) {
                    OptionsDialog.this.from2Label.setEnabled(true);
                    OptionsDialog.this.from2Text.setEnabled(true);
                    OptionsDialog.this.to2Label.setEnabled(true);
                    OptionsDialog.this.to2Text.setEnabled(true);
                } else {
                    OptionsDialog.this.from2Label.setEnabled(false);
                    OptionsDialog.this.from2Text.setEnabled(false);
                    OptionsDialog.this.to2Label.setEnabled(false);
                    OptionsDialog.this.to2Text.setEnabled(false);
                }
            }
        });
        this.preserveRange3CheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (OptionsDialog.this.preserveRange3CheckButton.getSelection()) {
                    OptionsDialog.this.from3Label.setEnabled(true);
                    OptionsDialog.this.from3Text.setEnabled(true);
                    OptionsDialog.this.to3Label.setEnabled(true);
                    OptionsDialog.this.to3Text.setEnabled(true);
                } else {
                    OptionsDialog.this.from3Label.setEnabled(false);
                    OptionsDialog.this.from3Text.setEnabled(false);
                    OptionsDialog.this.to3Label.setEnabled(false);
                    OptionsDialog.this.to3Text.setEnabled(false);
                }
            }
        });
        this.customTrimGroup = new Group(parent, 0);
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        this.customTrimGroup.setLayoutData((Object)layoutData);
        this.customTrimGroup.setLayout((Layout)new GridLayout(7, false));
        this.defaultTrimReferenceLabel = new Label((Composite)this.customTrimGroup, 0);
        this.defaultTrimReferenceLabel.setText("Default trim reference frequency is:");
        this.customTrimDefaultLabel = new Label((Composite)this.customTrimGroup, 0);
        this.customTrimDefaultLabel.setText(this.data.getCustomTrimDefault());
        this.customTrimDefaultLabel.setFont(labelFontBold);
        this.hz1Label = new Label((Composite)this.customTrimGroup, 0);
        this.hz1Label.setText("Hz. (Valid Range:");
        this.customTrimLowLabel = new Label((Composite)this.customTrimGroup, 0);
        this.customTrimLowLabel.setText(this.data.getCustomTrimLow());
        this.customTrimLowLabel.setFont(labelFontBold);
        this.toLabel = new Label((Composite)this.customTrimGroup, 0);
        this.toLabel.setText("to");
        this.customTrimHighLabel = new Label((Composite)this.customTrimGroup, 0);
        this.customTrimHighLabel.setText(this.data.getCustomTrimHigh());
        this.customTrimHighLabel.setFont(labelFontBold);
        this.hz2Label = new Label((Composite)this.customTrimGroup, 0);
        this.hz2Label.setText("Hz)");
        this.customTrimButton = new Button((Composite)this.customTrimGroup, 32);
        this.customTrimButton.setText("Use custom trim reference frequency:");
        CoreDebug.writeDebug(1, "CREATE CONTENT CUSTOM TRIM ENABLED = " + this.data.isCustomTrimEnabled());
        this.customTrimButton.setSelection(this.data.isCustomTrimEnabled());
        this.customTrimButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.customTrimText.setEnabled(OptionsDialog.this.customTrimButton.getSelection());
            }
        });
        layoutData = new GridData();
        layoutData.widthHint = 75;
        this.customTrimText = new Text((Composite)this.customTrimGroup, 2048);
        this.customTrimText.setText(this.data.getCustomTrimOverride());
        this.customTrimText.setLayoutData((Object)layoutData);
        this.customTrimText.setEnabled(this.data.isCustomTrimEnabled());
        this.hz3Label = new Label((Composite)this.customTrimGroup, 0);
        this.hz3Label.setText("Hz");
        layoutData = new GridData();
        layoutData.horizontalSpan = 4;
        this.hz3Label.setLayoutData((Object)layoutData);
        Control[] controlArray = this.trimGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            child.setEnabled(customTrimIsEnabled);
            ++n2;
        }
        controlArray = this.customTrimGroup.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            child.setEnabled(customTrimIsEnabled);
            ++n2;
        }
        if (this.data.getApi() >= 3) {
            this.partitionGroup = new Group(parent, 0);
            this.partitionGroup.setText("Partition");
            layoutData = new GridData(1808);
            layoutData.horizontalSpan = 2;
            this.partitionGroup.setLayoutData((Object)layoutData);
            this.partitionGroup.setLayout((Layout)new GridLayout(2, false));
            Canvas dataGroup = new Canvas((Composite)this.partitionGroup, 0);
            dataGroup.setLayout((Layout)new GridLayout(2, false));
            this.partitionCheckButton = new Button((Composite)dataGroup, 32);
            this.partitionCheckButton.setText("Enable Partitioning for the device");
            this.partitionCheckButton.setSelection(this.data.isPartitionChecked());
            this.partitionText = new Text((Composite)dataGroup, 2048);
            this.partitionText.setTextLimit(4);
            this.partitionText.setText(this.data.getPartition());
            layoutData = new GridData();
            layoutData.widthHint = 50;
            this.partitionText.setLayoutData((Object)layoutData);
            Canvas descriptionGroup = new Canvas((Composite)this.partitionGroup, 0);
            layoutData = new GridData(0x1000000, -1, true, false);
            descriptionGroup.setLayout((Layout)new GridLayout(1, true));
            descriptionGroup.setLayoutData((Object)layoutData);
            this.partitionLabel1 = new Label((Composite)descriptionGroup, 0);
            this.partitionLabel1.setText(this.data.getPartitionDescription1());
            layoutData = new GridData();
            layoutData.horizontalAlignment = 1;
            this.partitionLabel1.setLayoutData((Object)layoutData);
            this.partitionLabel2 = new Label((Composite)descriptionGroup, 0);
            this.partitionLabel2.setText(this.data.getPartitionDescription2());
            layoutData = new GridData();
            this.partitionLabel2.setLayoutData((Object)layoutData);
            this.partitionLabel3 = new Label((Composite)descriptionGroup, 0);
            this.partitionLabel3.setText(this.data.getPartitionDescription3());
            layoutData = new GridData();
            layoutData.horizontalAlignment = 3;
            this.partitionLabel3.setLayoutData((Object)layoutData);
            this.partitionGroup.setEnabled(this.data.isPartitionEnabled());
            dataGroup.setEnabled(this.data.isPartitionEnabled());
            Control[] controlArray2 = dataGroup.getChildren();
            int n3 = controlArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Control child2 = controlArray2[n4];
                child2.setEnabled(this.data.isPartitionEnabled());
                ++n4;
            }
            descriptionGroup.setEnabled(this.data.isPartitionEnabled());
            controlArray2 = descriptionGroup.getChildren();
            n3 = controlArray2.length;
            n4 = 0;
            while (n4 < n3) {
                Control child3 = controlArray2[n4];
                child3.setEnabled(this.data.isPartitionEnabled());
                ++n4;
            }
            this.partitionText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent event) {
                    char[] chrArray;
                    char[] cArray = chrArray = event.text.toCharArray();
                    int n = chrArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char chr = cArray[n2];
                        if (!(chr >= '0' && chr <= '9' || chr >= 'a' && chr <= 'f' || chr >= 'A' && chr <= 'F' || event.character == '\b' || event.character == '\u007f')) {
                            event.doit = false;
                        }
                        ++n2;
                    }
                }
            });
        }
        this.errorList = new List(parent, 2816);
        this.errorList.setVisible(errorDetected);
        if (errorDetected) {
            this.errorListData.exclude = false;
            this.errorListData.widthHint = -1;
            this.errorListData.heightHint = 100;
        } else {
            this.errorListData.exclude = true;
            this.errorListData.widthHint = 0;
            this.errorListData.heightHint = 0;
        }
        this.errorListData.horizontalSpan = 2;
        this.errorList.setLayoutData((Object)this.errorListData);
        this.doneButton = new Button(parent, 0);
        this.doneButton.setText("Done");
        layoutData = new GridData(64);
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = 90;
        this.doneButton.setLayoutData((Object)layoutData);
        parent.pack();
    }

    public void update(OptionsData data) {
        boolean altAlgorithm;
        boolean errorDetected = !data.getPreserve1StartError().equals("") || !data.getPreserve1EndError().equals("") || !data.getPreserve2StartError().equals("") || !data.getPreserve2EndError().equals("") || !data.getPreserve3StartError().equals("") || !data.getPreserve3EndError().equals("") || !data.getOverlap1and2Error().equals("") || !data.getOverlap1and3Error().equals("") || !data.getOverlap2and3Error().equals("") || !data.getCustomTrimError().equals("");
        boolean bl = altAlgorithm = !data.getAltAlgorithm0().equals("") || !data.getAltAlgorithm1().equals("") || !data.getAltAlgorithm2().equals("") || !data.getAltAlgorithm3().equals("") || !data.getAltAlgorithm4().equals("") || !data.getAltAlgorithm5().equals("") || !data.getAltAlgorithm6().equals("") || !data.getAltAlgorithm7().equals("") || !data.getAltAlgorithm8().equals("") || !data.getAltAlgorithm9().equals("");
        if (errorDetected) {
            this.errorList.setVisible(true);
            this.errorListData.exclude = false;
            this.errorListData.widthHint = -1;
            this.errorListData.heightHint = -1;
            this.errorList.removeAll();
            if (!data.getPreserve1StartError().equals("")) {
                this.errorList.add(data.getPreserve1StartError());
                this.from1Label.setForeground(this.parent.getDisplay().getSystemColor(3));
            }
            if (!data.getPreserve1EndError().equals("")) {
                this.errorList.add(data.getPreserve1EndError());
                this.to1Label.setForeground(this.parent.getDisplay().getSystemColor(3));
            }
            if (!data.getPreserve2StartError().equals("")) {
                this.errorList.add(data.getPreserve2StartError());
                this.from2Label.setForeground(this.parent.getDisplay().getSystemColor(3));
            }
            if (!data.getPreserve2EndError().equals("")) {
                this.errorList.add(data.getPreserve2EndError());
                this.to2Label.setForeground(this.parent.getDisplay().getSystemColor(3));
            }
            if (!data.getPreserve3StartError().equals("")) {
                this.errorList.add(data.getPreserve3StartError());
                this.from3Label.setForeground(this.parent.getDisplay().getSystemColor(3));
            }
            if (!data.getPreserve3EndError().equals("")) {
                this.errorList.add(data.getPreserve3EndError());
                this.to3Label.setForeground(this.parent.getDisplay().getSystemColor(3));
            }
            if (!data.getOverlap1and2Error().equals("")) {
                this.errorList.add(data.getOverlap1and2Error());
            }
            if (!data.getOverlap1and3Error().equals("")) {
                this.errorList.add(data.getOverlap1and3Error());
            }
            if (!data.getOverlap2and3Error().equals("")) {
                this.errorList.add(data.getOverlap2and3Error());
            }
            if (!data.getCustomTrimError().equals("")) {
                this.errorList.add(data.getCustomTrimError());
            }
        } else {
            this.errorListData.exclude = true;
            this.errorListData.widthHint = 0;
            this.errorListData.heightHint = 0;
            this.errorList.setVisible(false);
        }
        this.errorList.getParent().pack();
        this.parent.pack();
        if (!this.useAlternativeAlgorithmButton.getSelection()) {
            this.flashAlgorithmCombo.setEnabled(altAlgorithm);
        }
        this.preserveRange1CheckButton.setSelection(data.isPreserveRange1());
        this.from1Text.setEnabled(data.isPreserveRange1());
        this.from1Label.setEnabled(data.isPreserveRange1());
        this.to1Text.setEnabled(data.isPreserveRange1());
        this.to1Label.setEnabled(data.isPreserveRange1());
        this.preserveRange2CheckButton.setSelection(data.isPreserveRange2());
        this.from2Text.setEnabled(data.isPreserveRange2());
        this.from2Label.setEnabled(data.isPreserveRange2());
        this.to2Text.setEnabled(data.isPreserveRange2());
        this.to2Label.setEnabled(data.isPreserveRange2());
        this.preserveRange3CheckButton.setSelection(data.isPreserveRange3());
        this.from3Label.setEnabled(data.isPreserveRange3());
        this.from3Text.setEnabled(data.isPreserveRange3());
        this.to3Text.setEnabled(data.isPreserveRange3());
        this.to3Label.setEnabled(data.isPreserveRange3());
        this.trimCheckButton.setSelection(data.isDoTrim());
        this.from1Text.setText(data.getPreserveRange1Start());
        this.to1Text.setText(data.getPreserveRange1End());
        this.from2Text.setText(data.getPreserveRange2Start());
        this.to2Text.setText(data.getPreserveRange2End());
        this.from3Text.setText(data.getPreserveRange3Start());
        this.to3Text.setText(data.getPreserveRange3End());
        this.preserveEEPROMCheckButton.setSelection(data.isPreserveEEProm());
        this.customTrimDefaultLabel.setText(data.getCustomTrimDefault());
        this.customTrimLowLabel.setText(data.getCustomTrimLow());
        this.customTrimHighLabel.setText(data.getCustomTrimHigh());
        CoreDebug.writeDebug(1, "UPDATE CONTENT CUSTOM TRIM ENABLED = " + data.isCustomTrimEnabled());
        this.customTrimButton.setSelection(data.isCustomTrimEnabled());
        this.customTrimText.setEnabled(data.isCustomTrimEnabled());
        this.customTrimText.setText(data.getCustomTrimOverride());
        if (data.getApi() == 3) {
            this.partitionCheckButton.setSelection(data.isPartitionChecked());
            this.partitionText.setText(data.getPartition());
            this.partitionLabel1.setText(data.getPartitionDescription1());
            this.partitionLabel2.setText(data.getPartitionDescription2());
            this.partitionLabel3.setText(data.getPartitionDescription3());
        }
        this.enableProgDlgCheckButton.setSelection(data.isEnableFlashProgDlg());
        boolean preserveRangeIsEnabled = data.getArchitecture().toLowerCase().contains("hcs08") || data.getArchitecture().toLowerCase().contains("cfv1");
        this.preserveRange1CheckButton.setEnabled(preserveRangeIsEnabled);
        this.preserveRange2CheckButton.setEnabled(preserveRangeIsEnabled);
        this.preserveRange3CheckButton.setEnabled(preserveRangeIsEnabled);
        this.preserveEEPROMCheckButton.setEnabled(preserveRangeIsEnabled);
        this.preserveRange1CheckButton.setSelection(data.isPreserveRange1());
        this.from1Text.setEnabled(data.isPreserveRange1());
        this.to1Text.setEnabled(data.isPreserveRange1());
        this.preserveRange2CheckButton.setSelection(data.isPreserveRange2());
        this.from2Text.setEnabled(data.isPreserveRange2());
        this.to2Text.setEnabled(data.isPreserveRange2());
        this.preserveRange3CheckButton.setSelection(data.isPreserveRange3());
        this.from3Text.setEnabled(data.isPreserveRange3());
        this.to3Text.setEnabled(data.isPreserveRange3());
        this.preserveEEPROMCheckButton.setSelection(data.isPreserveEEProm());
        this.preserveEEPROMCheckButton.setEnabled(data.hasEEProm() && preserveRangeIsEnabled);
        this.parent.pack();
    }

    public Button getAlwaysEraseCheckButton() {
        return this.alwaysEraseCheckButton;
    }

    public Combo getFlashAlgorithmCombo() {
        return this.flashAlgorithmCombo;
    }

    public Button getUseAlternativeAlgorithmButton() {
        return this.useAlternativeAlgorithmButton;
    }

    public Button getFreqSyncChangeCheckButton() {
        return this.freqSyncChangeCheckButton;
    }

    public Button getTrimCheckButton() {
        return this.trimCheckButton;
    }

    public Button getPreserveRange1CheckButton() {
        return this.preserveRange1CheckButton;
    }

    public Text getFrom1Text() {
        return this.from1Text;
    }

    public Text getTo1Text() {
        return this.to1Text;
    }

    public Button getPreserveRange2CheckButton() {
        return this.preserveRange2CheckButton;
    }

    public Text getFrom2Text() {
        return this.from2Text;
    }

    public Text getTo2Text() {
        return this.to2Text;
    }

    public Button getPreserveRange3CheckButton() {
        return this.preserveRange3CheckButton;
    }

    public Text getFrom3Text() {
        return this.from3Text;
    }

    public Text getTo3Text() {
        return this.to3Text;
    }

    public Button getPreserveEEPROMCheckButton() {
        return this.preserveEEPROMCheckButton;
    }

    public Text getCustomTrimText() {
        return this.customTrimText;
    }

    public Button getCustomTrimButton() {
        return this.customTrimButton;
    }

    public Button getEnableProgDlgCheckButton() {
        return this.enableProgDlgCheckButton;
    }

    public Text getFileName() {
        return this.fileName;
    }

    public Button getPartitionCheckButton() {
        return this.partitionCheckButton;
    }

    public Text getPartitionText() {
        return this.partitionText;
    }

    public boolean isAlternativeAlgorithmChosen() {
        return this.alternativeAlgorithmChosen;
    }

    public void setAlternativeAlgorithmChosen(boolean alternativeAlgorithmChosen) {
        this.alternativeAlgorithmChosen = alternativeAlgorithmChosen;
    }

    public Button getDoneButton() {
        return this.doneButton;
    }
}

