/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip.widget;

import com.pemicro.forms.GraphicsUtils;
import com.pemicro.forms.chip.ChipStyle;
import com.pemicro.forms.chip.data.PinData;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class Pin {
    private Map<Integer, Image> imageList;
    private Composite parent;
    private Canvas pinCanvas;
    private PinData data;
    private Label value;
    private Label direction;
    private Label name;
    public static final int SPACING = 0;
    public static final int VALUE_OFFSET = 3;
    public static final int DIRECTION_OFFSET = -2;
    final int Height;
    final int Width;
    private int side;

    public Pin(Composite parent, PinData data, int side) {
        this(parent, side);
        this.setPinData(data);
    }

    public Pin(Composite parent, int side) {
        this.Height = ChipStyle.dfltTopGrey.getImageData().height;
        this.Width = ChipStyle.dfltTopGrey.getImageData().width;
        this.parent = parent;
        this.side = side;
        this.addImages();
        this.pinCanvas = new Canvas(parent, 0);
        GridLayout layout = side == 256 || side == 768 ? new GridLayout(1, false) : new GridLayout(3, false);
        layout.marginBottom = 0;
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        this.pinCanvas.setLayout((Layout)layout);
        if (side == 0 || side == 768) {
            this.name = new Label((Composite)this.pinCanvas, 0);
            this.value = new Label((Composite)this.pinCanvas, 0);
            this.direction = new Label((Composite)this.pinCanvas, 0);
        }
        if (side == 256 || side == 512) {
            this.direction = new Label((Composite)this.pinCanvas, 0);
            this.value = new Label((Composite)this.pinCanvas, 0);
            this.name = new Label((Composite)this.pinCanvas, 0);
        }
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        if (side == 0 || side == 256) {
            data.horizontalAlignment = 131072;
            data.verticalAlignment = 128;
        }
        if (side == 512 || side == 768) {
            data.horizontalAlignment = 16384;
            data.verticalAlignment = 1024;
        }
        this.pinCanvas.setLayoutData((Object)data);
        this.name.setFont(ChipStyle.CHIP_WINDOW_TEXT_FONT);
        this.name.setForeground(ChipStyle.TEXT_COLOR);
        this.name.moveAbove((Control)parent);
        this.value.setForeground(ChipStyle.TEXT_COLOR);
        this.value.setFont(ChipStyle.CHIP_WINDOW_TEXT_FONT);
        this.direction.setImage((Image)(side == 0 ? ChipStyle.dfltLeftGrey : (side == 256 ? ChipStyle.dfltBottomGrey : (side == 512 ? ChipStyle.dfltRightGrey : (side == 768 ? ChipStyle.dfltTopGrey : null)))));
        if (side == 256 || side == 768) {
            if (this.value.getImage() != null && !this.value.getImage().isDisposed()) {
                this.value.getImage().dispose();
            }
            this.value.setImage(GraphicsUtils.createRotatedText(" ", this.value.getFont(), this.value.getForeground(), this.value.getBackground(), 128));
            if (this.name.getImage() != null && !this.name.getImage().isDisposed()) {
                this.name.getImage().dispose();
            }
            this.name.setImage(GraphicsUtils.createRotatedText("Undefined Pin", this.value.getFont(), this.name.getForeground(), this.name.getBackground(), 128));
        } else {
            this.value.setText("");
            this.name.setText("Undefined Pin");
        }
        this.refresh();
    }

    public void refresh() {
        this.parent.pack();
        this.parent.getParent().pack();
    }

    public void setPinData(PinData pinData) {
        this.data = pinData;
    }

    public void updateName() {
        this.setPinText(this.side, this.getPinData().getModuleName(), this.name);
        this.refresh();
    }

    public void updateValue() {
        switch (this.getPinData().getPinType()) {
            case 0: 
            case 1: 
            case 2: {
                String text = "E";
                if (this.getPinData().getDataType() == 1) {
                    text = String.format("%.2f V", Float.valueOf((float)this.getPinData().getAnalogValue() / 100.0f));
                }
                if (this.getPinData().getDataType() == 0) {
                    text = Integer.toString(this.getPinData().getDigitalValue());
                }
                if (this.checkImpedance(this.getPinData()) == 0) {
                    this.value.setForeground(ChipStyle.CHIP_WINDOW_LOW_VALUE_COLOR);
                }
                if (this.checkImpedance(this.getPinData()) == 1) {
                    this.value.setForeground(ChipStyle.CHIP_WINDOW_HIGH_VALUE_COLOR);
                }
                if (this.checkImpedance(this.getPinData()) == 2) {
                    text = "X";
                    this.value.setForeground(ChipStyle.CHIP_WINDOW_TRISTATE_VALUE_COLOR);
                }
                this.setPinText(this.side, text, this.value);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.value.setText("");
            }
        }
        this.refresh();
    }

    public void updateDirection() {
        if (this.getPinData().getPinType() == 4096 || this.getPinData().getPinType() == 8192 || this.getPinData().getPinType() == 0) {
            this.direction.setImage(this.imageList.get(this.side | this.getPinData().getDirection() | this.checkImpedance(this.getPinData())));
        } else {
            this.direction.setImage(this.imageList.get(this.side | this.getPinData().getPinType()));
        }
    }

    private void setPinText(int side, String value, Label label) {
        if (side == 256 || side == 768) {
            if (label.getImage() != null && !label.getImage().isDisposed()) {
                label.getImage().dispose();
            }
            label.setImage(GraphicsUtils.createRotatedText(value, label.getFont(), label.getForeground(), label.getBackground(), 128));
        } else {
            label.setText(value);
        }
    }

    private void addImages() {
        this.imageList = new HashMap<Integer, Image>();
        this.imageList.put(0, ChipStyle.inLeftGreen);
        this.imageList.put(1, ChipStyle.inLeftRed);
        this.imageList.put(2, ChipStyle.inLeftGrey);
        this.imageList.put(16, ChipStyle.outLeftGreen);
        this.imageList.put(17, ChipStyle.outLeftRed);
        this.imageList.put(18, ChipStyle.outLeftGrey);
        this.imageList.put(32, ChipStyle.dfltLeftGreen);
        this.imageList.put(33, ChipStyle.dfltLeftRed);
        this.imageList.put(34, ChipStyle.dfltLeftGrey);
        this.imageList.put(512, ChipStyle.inRightGreen);
        this.imageList.put(513, ChipStyle.inRightRed);
        this.imageList.put(514, ChipStyle.inRightGrey);
        this.imageList.put(528, ChipStyle.outRightGreen);
        this.imageList.put(529, ChipStyle.outRightRed);
        this.imageList.put(530, ChipStyle.outRightGrey);
        this.imageList.put(544, ChipStyle.dfltRightGreen);
        this.imageList.put(545, ChipStyle.dfltRightRed);
        this.imageList.put(546, ChipStyle.dfltRightGrey);
        this.imageList.put(256, ChipStyle.inBottomGreen);
        this.imageList.put(257, ChipStyle.inBottomRed);
        this.imageList.put(258, ChipStyle.inBottomGrey);
        this.imageList.put(272, ChipStyle.outBottomGreen);
        this.imageList.put(273, ChipStyle.outBottomRed);
        this.imageList.put(274, ChipStyle.outBottomGrey);
        this.imageList.put(288, ChipStyle.dfltBottomGreen);
        this.imageList.put(289, ChipStyle.dfltBottomRed);
        this.imageList.put(290, ChipStyle.dfltBottomGrey);
        this.imageList.put(768, ChipStyle.inTopGreen);
        this.imageList.put(769, ChipStyle.inTopRed);
        this.imageList.put(770, ChipStyle.inTopGrey);
        this.imageList.put(784, ChipStyle.outTopGreen);
        this.imageList.put(785, ChipStyle.outTopRed);
        this.imageList.put(786, ChipStyle.outTopGrey);
        this.imageList.put(800, ChipStyle.dfltTopGreen);
        this.imageList.put(801, ChipStyle.dfltTopRed);
        this.imageList.put(802, ChipStyle.dfltTopGrey);
        this.imageList.put(12288, ChipStyle.powerLeft);
        this.imageList.put(12800, ChipStyle.powerRight);
        this.imageList.put(12544, ChipStyle.powerBottom);
        this.imageList.put(13056, ChipStyle.powerTop);
        this.imageList.put(16384, ChipStyle.gndLeft);
        this.imageList.put(16896, ChipStyle.gndRight);
        this.imageList.put(16640, ChipStyle.gndBottom);
        this.imageList.put(17152, ChipStyle.gndTop);
        this.imageList.put(20480, ChipStyle.clkInLeft);
        this.imageList.put(20992, ChipStyle.clkInRight);
        this.imageList.put(20736, ChipStyle.clkInBottom);
        this.imageList.put(21248, ChipStyle.clkInTop);
        this.imageList.put(24576, ChipStyle.clkOutLeft);
        this.imageList.put(25088, ChipStyle.clkOutRight);
        this.imageList.put(24832, ChipStyle.clkOutBottom);
        this.imageList.put(25344, ChipStyle.clkOutTop);
        this.imageList.put(28672, ChipStyle.arefhLeft);
        this.imageList.put(29184, ChipStyle.arefhRight);
        this.imageList.put(28928, ChipStyle.arefhBottom);
        this.imageList.put(29440, ChipStyle.arefhTop);
        this.imageList.put(32768, ChipStyle.areflLeft);
        this.imageList.put(33280, ChipStyle.areflRight);
        this.imageList.put(33024, ChipStyle.areflBottom);
        this.imageList.put(33536, ChipStyle.areflTop);
        this.imageList.put(36864, ChipStyle.anPwrInLeft);
        this.imageList.put(37376, ChipStyle.anPwrInRight);
        this.imageList.put(37120, ChipStyle.anPwrInBottom);
        this.imageList.put(37632, ChipStyle.anPwrInTop);
        this.imageList.put(40960, ChipStyle.anGndInLeft);
        this.imageList.put(41472, ChipStyle.anGndInRight);
        this.imageList.put(41216, ChipStyle.anGndInBottom);
        this.imageList.put(41728, ChipStyle.anGndInTop);
    }

    private int checkImpedance(PinData pinData) {
        int impedance = 0;
        if (pinData.getDigitalValue() == 0 && pinData.getDataType() == 0 || pinData.getAnalogValue() < pinData.getAnalogMax() / 2 && pinData.getDataType() == 1) {
            impedance = 0;
        } else if (pinData.getDigitalValue() == 1 && pinData.getDataType() == 0 || pinData.getAnalogValue() >= pinData.getAnalogMax() / 2 && pinData.getDataType() == 1) {
            impedance = 1;
        } else if (pinData.getDigitalValue() == 2) {
            impedance = 2;
        }
        return impedance;
    }

    public Canvas getCanvas() {
        return this.pinCanvas;
    }

    public Label getDirection() {
        return this.direction;
    }

    public Label getName() {
        return this.name;
    }

    public Label getValue() {
        return this.value;
    }

    public PinData getPinData() {
        return this.data;
    }
}

