/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.core;

import com.nxp.s32ds.cle.spt.core.Activator;
import com.nxp.s32ds.cle.spt.model.ISptInstruction;
import com.nxp.s32ds.cle.spt.model.ISptInstructionGroup;
import com.nxp.s32ds.cle.spt.model.ISptInstructionOption;
import com.nxp.s32ds.cle.spt.model.ISptInstructionParam;
import com.nxp.s32ds.cle.spt.model.ISptInstructionsHolder;
import com.nxp.s32ds.cle.spt.model.ISptRegister;
import com.nxp.s32ds.cle.spt.model.SptDefinitions;
import com.nxp.s32ds.cle.spt.model.SptInstruction;
import com.nxp.s32ds.cle.spt.model.SptInstructionGroup;
import com.nxp.s32ds.cle.spt.model.SptInstructionOption;
import com.nxp.s32ds.cle.spt.model.SptInstructionParam;
import com.nxp.s32ds.cle.spt.model.SptInstructionsHolder;
import com.nxp.s32ds.cle.spt.model.SptRegister;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SptDefinitionParser {
    private static final String EXTENSION_POINT_SPT_DEFINITIONS = "com.nxp.s32ds.cle.spt.core.sptDefinitions";
    private static final String ELEMENT_OPTIONS = "options";
    private static final String ELEMENT_GROUP = "group";
    private static final String ELEMENT_DEFINITION = "definition";
    private static final String ELEMENT_INSTRUCTION = "instruction";
    private static final String ELEMENT_OPTION = "option";
    private static final String ELEMENT_PARAM = "param";
    private static final String ELEMENT_REGISTERS = "registers";
    private static final String ELEMENT_REGISTER = "register";
    private static final String ELEMENT_VALUE = "value";
    private static final String ATTRIBUTE_FILE = "file";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_ALIAS = "alias";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_COMMA = "comma";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ATTRIBUTE_MASK = "mask";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTE_MNEMONICS = "mnemonics";
    private static final String MNEMONICS_SEPARATOR = ",";

    public static SptDefinitions parse() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_SPT_DEFINITIONS);
        if (ep == null) {
            Activator.logWarning(String.format("No extension point '%s' found", EXTENSION_POINT_SPT_DEFINITIONS));
            return new SptDefinitions();
        }
        SptDefinitions root = new SptDefinitions();
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement celk = iConfigurationElementArray[n4];
                if (ELEMENT_DEFINITION.equals(celk.getName())) {
                    String bundle = celk.getContributor().getName();
                    String sptVersion = celk.getAttribute(ATTRIBUTE_VERSION);
                    String file = celk.getAttribute(ATTRIBUTE_FILE);
                    if (file == null || file.isEmpty()) {
                        SptDefinitionParser.reportInstructionsLoadError(sptVersion);
                    } else {
                        SptDefinitionParser.parseDefinition(sptVersion, file, root, bundle);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return root;
    }

    private static void parseDefinition(String sptVersion, String file, SptDefinitions root, String bundle) {
        block28: {
            try {
                SptInstructionsHolder holder = new SptInstructionsHolder(ISptInstructionsHolder.Type.INSTRUCTIONS, sptVersion);
                URL resolvedUrl = FileLocator.resolve((URL)Platform.getBundle((String)bundle).getEntry(file));
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedInputStream bis = new BufferedInputStream(resolvedUrl.openConnection().getInputStream());){
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    parser.setErrorHandler(new DefaultHandler());
                    Element instructionsRoot = parser.parse(bis).getDocumentElement();
                    if (!ELEMENT_DEFINITION.equals(instructionsRoot.getNodeName())) break block28;
                    NodeList list = instructionsRoot.getChildNodes();
                    int i = 0;
                    while (i < list.getLength()) {
                        block29: {
                            Node childNode = list.item(i);
                            if (!(childNode instanceof Element)) break block29;
                            Element node = (Element)childNode;
                            switch (node.getNodeName()) {
                                case "registers": {
                                    SptDefinitionParser.parseRegisters(node, (ISptInstructionsHolder)holder);
                                    break;
                                }
                                case "options": {
                                    SptDefinitionParser.parseOptions(node, (ISptInstructionsHolder)holder);
                                    break;
                                }
                                case "group": {
                                    holder.addInstruction(SptDefinitionParser.parseInstructionsGroup(node, null, (ISptInstructionsHolder)holder));
                                    break;
                                }
                                case "instruction": {
                                    holder.addInstruction(SptDefinitionParser.parseInstruction(node, null, (ISptInstructionsHolder)holder));
                                    break;
                                }
                            }
                        }
                        ++i;
                    }
                    root.addHolder((ISptInstructionsHolder)holder);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                SptDefinitionParser.reportInstructionsLoadError(String.valueOf(sptVersion) + " [" + e.getMessage() + "]");
            }
        }
    }

    private static ISptInstruction parseInstructionsGroup(Element node, ISptInstructionGroup holderGroup, ISptInstructionsHolder holder) {
        String gName = node.getAttribute(ATTRIBUTE_NAME);
        String[] mnemonics = node.getAttribute(ATTRIBUTE_MNEMONICS).split(MNEMONICS_SEPARATOR);
        SptInstructionGroup group = new SptInstructionGroup(gName, mnemonics, holderGroup);
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            block17: {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) break block17;
                Element item = (Element)childNode;
                switch (item.getNodeName()) {
                    case "group": {
                        group.addInstructionsGroup((ISptInstructionGroup)SptDefinitionParser.parseInstructionsGroup(item, (ISptInstructionGroup)group, holder));
                        break;
                    }
                    case "option": {
                        group.addParam((ISptInstructionParam)SptDefinitionParser.getOption(item, holder));
                        break;
                    }
                    case "param": {
                        group.addParam(SptDefinitionParser.parseParam(item, holder));
                        break;
                    }
                    case "instruction": {
                        group.addInstruction(SptDefinitionParser.parseInstruction(item, (ISptInstructionGroup)group, holder));
                        break;
                    }
                }
            }
            ++i;
        }
        return group;
    }

    private static ISptInstruction parseInstruction(Element node, ISptInstructionGroup group, ISptInstructionsHolder holder) {
        SptInstruction instruction = new SptInstruction(node.getAttribute(ATTRIBUTE_NAME), node.getAttribute(ATTRIBUTE_ALIAS), node.getAttribute(ATTRIBUTE_MNEMONICS).split(MNEMONICS_SEPARATOR), group);
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            block11: {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) break block11;
                Element item = (Element)childNode;
                switch (item.getNodeName()) {
                    case "option": {
                        instruction.addParam((ISptInstructionParam)SptDefinitionParser.getOption(item, holder));
                        break;
                    }
                    case "param": {
                        instruction.addParam(SptDefinitionParser.parseParam(item, holder));
                        break;
                    }
                }
            }
            ++i;
        }
        return instruction;
    }

    private static ISptInstructionOption getOption(Element item, ISptInstructionsHolder holder) {
        ISptInstructionOption globalOption = holder.getOption(item.getAttribute(ATTRIBUTE_NAME));
        ISptInstructionOption localOption = SptDefinitionParser.parseOption(item);
        SptInstructionOption option = null;
        if (globalOption != null) {
            if (!localOption.getValues().isEmpty()) {
                return localOption;
            }
            option = new SptInstructionOption(globalOption);
            option.setCommaNeeded(localOption.isCommaNeeded());
            return option;
        }
        return localOption;
    }

    private static ISptInstructionParam parseParam(Element item, ISptInstructionsHolder holder) {
        String paramName = item.getAttribute(ATTRIBUTE_NAME);
        boolean isCommaNeeded = item.getAttribute(ATTRIBUTE_COMMA).isEmpty();
        String paramType = item.getAttribute(ATTRIBUTE_TYPE);
        ISptRegister register = holder.getRegister(paramType);
        if (register != null) {
            return new SptInstructionParam(paramName, register, isCommaNeeded);
        }
        paramType = paramType != null ? paramType.toUpperCase() : "";
        return new SptInstructionParam(paramName, paramType, isCommaNeeded);
    }

    private static void parseRegisters(Element item, ISptInstructionsHolder holder) {
        NodeList registers = item.getElementsByTagName(ELEMENT_REGISTER);
        int i = 0;
        while (i < registers.getLength()) {
            Element register = (Element)registers.item(i);
            holder.addRegister(SptDefinitionParser.parseRegister(register));
            ++i;
        }
    }

    private static ISptRegister parseRegister(Element item) {
        String registerName = item.getAttribute(ATTRIBUTE_NAME);
        String registerMask = item.getAttribute(ATTRIBUTE_MASK);
        String registerDefaultValue = item.getAttribute(ATTRIBUTE_DEFAULT);
        return new SptRegister(registerName, registerMask, registerDefaultValue);
    }

    private static void parseOptions(Element item, ISptInstructionsHolder holder) {
        NodeList options = item.getElementsByTagName(ELEMENT_OPTION);
        int i = 0;
        while (i < options.getLength()) {
            Element option = (Element)options.item(i);
            holder.addOption(SptDefinitionParser.parseOption(option));
            ++i;
        }
    }

    private static ISptInstructionOption parseOption(Element item) {
        String optionName = item.getAttribute(ATTRIBUTE_NAME);
        boolean isCommaNeeded = !item.getAttribute(ATTRIBUTE_COMMA).isEmpty();
        SptInstructionOption option = new SptInstructionOption(optionName, isCommaNeeded);
        NodeList values = item.getElementsByTagName(ELEMENT_VALUE);
        int i = 0;
        while (i < values.getLength()) {
            String value = values.item(i).getTextContent();
            option.addValue(value != null ? value : "");
            ++i;
        }
        return option;
    }

    private static void reportInstructionsLoadError(String sptVersion) {
        Activator.logError(NLS.bind((String)"Unable to load instructions for {0}", (Object)sptVersion));
    }
}

