/**************************************************************************/
/* FILE NAME: INTCISRVECTOR.c               COPYRIGHT (c) Freescale 2012  */
/*                                                All Rights Reserved     */
/* DESCRIPTION:                                                           */
/* This file contains a table of ISRs for INTC in software (SW) vector    */
/* mode. The table contains addresses for 1024 ISR vectors.               */
/* Table address starts at base of section ".isrvectbl"                   */
/* This file is an example Interrupt Service Routine call file with       */
/* ISR's be replaced by the user application code as needed.              */
/*                                                                        */
/*========================================================================*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
/* ---   -----------    ----------    ---------------------               */
/* 0.1   S. Mihalik      07/Jun/04    Initial version                     */
/* 0.2	  R. Moran       23/Feb/07    Modified for specific test ISRs	  */
/* 0.21	  I. Harris      11/Jan/10    Modified for specific test ISRs	  */
/* 0.23   I.Harris       01/Feb/11    Modified for GTM FPGA               */
/* 0.23   I.Harris       01/Feb/12    Modified for MPC5764M               */
/* 0.24   S.Perepelitsa  12/May/16    Modified for C99- compatible build  */
/**************************************************************************/
#include "typedefs.h"
#include "derivative.h"

typedef void (*vector_func)(void);
/*========================================================================*/
/*		PROTOTYPES						  */
/*========================================================================*/
void dummy  (void);

/*========================================================================*/
/*	GLOBAL VARIABLES						  */
/*========================================================================*/


const vector_func __attribute__ ((section (".intc_vector_table"))) IntcIsrVectorTable[] = {

	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 00 - 04 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 05 - 09 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 10 - 14 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 15 - 19 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 20 - 24 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 25 - 29 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 30 - 34 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 35 - 39 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 40 - 44 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 45 - 49 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 50 - 54 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 55 - 59 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 60 - 64 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 65 - 69 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 70 - 74 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 75 - 79 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 80 - 84 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 85 - 89 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 90 - 94 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 95 - 99 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 100 - 104 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 105 - 109 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 110 - 114 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 115 - 119 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 120 - 124 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 125 - 129 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 130 - 134 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 135 - 139 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 140 - 144 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 145 - 149 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 150 - 154 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 155 - 159 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 160 - 164 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 165 - 169 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 170 - 174 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 175 - 179 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 180 - 184 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 185 - 189 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 190 - 194 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 195 - 199 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 200 - 204 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 205 - 209 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 210 - 214 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 215 - 219 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 220 - 224 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 225 - 229 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 230 - 234 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 235 - 239 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 240 - 244 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 245 - 249 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 250 - 254 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 255 - 259 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 260 - 264 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 265 - 269 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 270 - 274 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 275 - 279 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 280 - 284 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 285 - 289 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 290 - 294 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 295 - 299 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 300 - 304 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 305 - 309 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 310 - 314 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 315 - 319 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 320 - 324 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 325 - 329 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 330 - 334 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 335 - 339 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 340 - 344 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 345 - 349 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 350 - 354 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 355 - 359 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 360 - 364 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 365 - 369 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 370 - 374 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 375 - 379 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 380 - 384 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 385 - 389 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 390 - 394 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 395 - 399 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 400 - 404 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 405 - 409 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 410 - 414 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 415 - 419 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 420 - 424 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 425 - 429 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 430 - 434 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 435 - 439 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 440 - 444 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 445 - 449 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 450 - 454 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 455 - 459 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 460 - 464 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 465 - 469 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 470 - 474 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 475 - 479 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 480 - 484 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 485 - 489 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 490 - 494 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 495 - 499 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 500 - 504 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 505 - 509 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 510 - 514 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 515 - 519 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 520 - 524 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 525 - 529 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 530 - 534 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 535 - 539 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 540 - 544 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 545 - 549 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 550 - 554 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 555 - 559 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 560 - 564 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 565 - 569 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 570 - 574 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 575 - 579 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 580 - 584 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 585 - 589 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 590 - 594 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 595 - 599 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 600 - 604 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 605 - 609 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 610 - 614 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 615 - 619 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 620 - 624 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 625 - 629 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 630 - 634 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 635 - 639 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 640 - 644 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 645 - 649 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 650 - 654 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 655 - 659 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 660 - 664 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 665 - 669 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 670 - 674 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 675 - 679 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 680 - 684 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 685 - 689 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 690 - 694 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 695 - 699 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 700 - 704 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 705 - 709 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 710 - 714 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 715 - 719 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 720 - 724 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 725 - 729 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 730 - 734 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 735 - 739 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 740 - 744 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 745 - 749 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 750 - 754 */
	&dummy, &dummy, &dummy, &dummy, &dummy,  /* ISRs 755 - 759 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 760 - 764 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 765 - 769 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 770 - 774 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 775 - 779 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 780 - 784 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 785 - 789 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 790 - 794 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 795 - 799 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 800 - 804 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 805 - 809 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 810 - 814 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 815 - 819 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 820 - 824 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 825 - 829 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 830 - 834 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 835 - 839 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 845 - 849 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 850 - 854 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 855 - 859 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 860 - 864 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 865 - 869 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 870 - 874 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 875 - 879 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 880 - 884 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 885 - 889 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 890 - 894 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 895 - 899 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 900 - 904 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 905 - 909 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 910 - 914 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 915 - 919 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 920 - 924 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 925 - 929 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 930 - 934 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 935 - 939 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 940 - 944 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 945 - 949 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 950 - 954 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 955 - 959 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 960 - 964 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 965 - 969 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 970 - 974 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 975 - 979 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 980 - 984 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 985 - 989 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 990 - 994 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 995 - 999 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 1000 - 1004 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 1005 - 1009 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 1010 - 1014 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 1015 - 1019 */
	&dummy, &dummy, &dummy, &dummy, &dummy, /* ISRs 1020 - 1024 */
};      

#ifdef __GNUC__
__attribute__ ((section(".text")))
#endif

/*========================================================================*/
/*			FUNCTIONS													  */
/*========================================================================*/

/**************************************************************************/
/* FUNCTION     : dummy													  */
/* PURPSE      : Dummy function which is entered if any non-used vector   */
/*							is called.									  */
/**************************************************************************/
void dummy (void) {
	vuint32_t reg;
	reg = INTC.IACKR.R;
	while (1){

	}
}  
