/*
 * main implementation: use this 'C' sample to create your own application
 *
 */

#include "derivative.h" /* include peripheral declarations */
#include <string.h>

#define FP_TX_VERSION_SIZE 0x06
/*## attribute FPTxBuffer */
vuint8_t FPTxBuffer[256];


typedef unsigned long uint32;
typedef volatile uint32_t vuint32;


extern void MC_MODE_INIT(void);
extern void CLK_OUT(void);
extern void OSC_INIT (void);
extern void PLL_INIT_0(void);
extern void SET_SYS_CLK(void);
extern void CGM_INIT (void);

extern void xcptn_xmpl(void);

extern void SPT_INIT_VAR(void);
extern void SPT_ADD(void);
extern void SPT_LOOP(void);



void SPT_prepare(vuint32 address)
{
    SPT.CS_STATUS0.R = 0xFFffffff;   // RESET all status register
    SPT.GBL_CTRL.R = 0x0;            // RESET Ctrl
	SPT.CS_PG_ST_ADDR.R = address; //instructions start address
	SPT.GBL_CTRL.R = 0x1D;		     // Enable SPT & Program start control
	//while ((SPT.CS_STATUS0.R&0x8)!=0x8)  //wait for PS_STOP
	while ((SPT.CS_STATUS0.B.PS_STOP)!=0x1)
	{
	}

}

void FSPT_INIT_VAR (const vuint8_t FPFunc)
		{
		SPT_prepare((vuint32)SPT_INIT_VAR);

		if(SPT.WR_R0_RE.R == 0x0 && SPT.WR_R2_RE.R == 0x0 && SPT.WR_R1_RE.R == 0x1)
				{(void)memcpy((void*)&FPTxBuffer[FPFunc*FP_TX_VERSION_SIZE], (void*)"pass! ", FP_TX_VERSION_SIZE);}
			else
				{(void)memcpy((void*)&FPTxBuffer[FPFunc*FP_TX_VERSION_SIZE], (void*)"fail! ", FP_TX_VERSION_SIZE);
			         while(1);}

		}


void FSPT_ADD (const vuint8_t FPFunc)
		{

	   SPT_prepare((vuint32)SPT_ADD);

		if(SPT.WR_R1_RE.R == 0x3 && SPT.WR_R0_RE.R == 0x1 )
				(void)memcpy((void*)&FPTxBuffer[FPFunc*FP_TX_VERSION_SIZE], (void*)"pass! ", FP_TX_VERSION_SIZE);
			else
				{(void)memcpy((void*)&FPTxBuffer[FPFunc*FP_TX_VERSION_SIZE], (void*)"fail! ", FP_TX_VERSION_SIZE);
			         while(1);}

		}

void FSPT_LOOP (const vuint8_t FPFunc)
		{

	   SPT_prepare((vuint32)SPT_LOOP);

		if(SPT.WR_R1_RE.R == 0x7fe  && SPT.WR_R0_RE.R == 0xA )
				(void)memcpy((void*)&FPTxBuffer[FPFunc*FP_TX_VERSION_SIZE], (void*)"pass! ", FP_TX_VERSION_SIZE);
			else
				{(void)memcpy((void*)&FPTxBuffer[FPFunc*FP_TX_VERSION_SIZE], (void*)"fail! ", FP_TX_VERSION_SIZE);
			         while(1);}

		}



int main(void)
{
	volatile int counter = 0;
	
	    MC_MODE_INIT();		/* Configure Modules Via Mode Entry */
	    CLK_OUT();			/* Enable Clk Out */
	    OSC_INIT ();		/* Configure Osc */
	    PLL_INIT_0();		/* Configure PLL 0 */
	    SET_SYS_CLK();		/* Set the system clk */
	    CGM_INIT ();		/* Configure Clocks  */


	    xcptn_xmpl ();              /* Configure and Enable Interrupts */


	   FSPT_INIT_VAR(0x0);
	   FSPT_ADD(0x1);
	   FSPT_LOOP(0x2);
	/* Loop forever */
	   for(;;) {
	   	counter++;
	}
}
