/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.corePlugin;

import com.pemicro.corePlugin.JLink;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TestProtocol {
    private static final boolean TEST = true;
    private static JLink stream = new JLink();
    private static byte[] outBuffer;
    private static byte[] inBuffer;
    private static int idx;
    private static int idx2;

    public static void TestUnsecureWindow() {
        TestProtocol.initializeOutBuffer();
        TestProtocol.writeWord((short)26);
        TestProtocol.writeWord((short)1);
        TestProtocol.writeString("Password Required");
        TestProtocol.writeString("Device may be secured");
        TestProtocol.writeString("FEEDFACECAFEBEEF");
        inBuffer = stream.doSomethingWithBuffer(outBuffer);
        TestProtocol.initializeInBuffer();
        final String code = TestProtocol.readString();
        final boolean changed = TestProtocol.readBoolean();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageBox mb = new MessageBox(new Shell());
                mb.setText("Unsecure Window Response");
                mb.setMessage(String.format("Code = %s , changed = %b", code, changed));
                mb.open();
            }
        });
    }

    public static void TestPowerDialog() {
        TestProtocol.initializeOutBuffer();
        TestProtocol.writeWord((short)2);
        TestProtocol.writeWord((short)1);
        TestProtocol.writeString("This is a test header");
        TestProtocol.writeString("This is a test Message");
        TestProtocol.writeWord((short)2);
        stream.doSomethingWithBuffer(outBuffer);
    }

    public static void TestLFCWriter() {
        TestProtocol.initializeOutBuffer();
        TestProtocol.writeWord((short)25);
        TestProtocol.writeWord((short)1);
        TestProtocol.writeByte((byte)0);
        TestProtocol.writeString("testQE128_MC9S08QE128_PnE Full Chip Simulator");
        TestProtocol.writeWord((short)4);
        int i = 0;
        while (i < 4) {
            TestProtocol.writeString("ATT" + i);
            TestProtocol.writeString("VALU" + i);
            ++i;
        }
        stream.doSomethingWithBuffer(outBuffer);
        TestProtocol.initializeOutBuffer();
        TestProtocol.writeWord((short)25);
        TestProtocol.writeWord((short)1);
        TestProtocol.writeByte((byte)1);
        TestProtocol.writeString("testQE128_MC9S08QE128_PnE Full Chip Simulator");
        stream.doSomethingWithBuffer(outBuffer);
        TestProtocol.initializeOutBuffer();
        TestProtocol.writeWord((short)25);
        TestProtocol.writeWord((short)1);
        TestProtocol.writeByte((byte)0);
        TestProtocol.writeString("testQE128_MC9S08QE128_PnE Full Chip Simulator");
        TestProtocol.writeWord((short)6);
        i = 0;
        while (i < 6) {
            TestProtocol.writeString("ATT B" + i);
            TestProtocol.writeString("VALU B" + i);
            ++i;
        }
        stream.doSomethingWithBuffer(outBuffer);
    }

    private static void initializeOutBuffer() {
        outBuffer = new byte[8192];
        idx = 0;
        TestProtocol.outBuffer[3] = 0;
        TestProtocol.outBuffer[4] = 0;
        TestProtocol.outBuffer[5] = 0;
        TestProtocol.outBuffer[6] = 4;
        TestProtocol.writeWord((short)-21931);
        TestProtocol.writeByte((byte)1);
        idx = 7;
        TestProtocol.writeLong(1);
        TestProtocol.writeLong(1);
        TestProtocol.writeLong(0);
        TestProtocol.writeLong(0);
    }

    private static void initializeInBuffer() {
        TestProtocol.readWord();
        TestProtocol.readByte();
        TestProtocol.readLong();
        TestProtocol.readLong();
        TestProtocol.readLong();
        TestProtocol.readLong();
        TestProtocol.readLong();
    }

    private static byte[] toByte(short value) {
        return new byte[]{(byte)(value >>> 8), (byte)value};
    }

    private static byte[] toByte(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    private static void writeString(String str) {
        TestProtocol.incBufferLength(str.length() + 1);
        TestProtocol.outBuffer[TestProtocol.idx++] = TestProtocol.mask((byte)str.length());
        int i = 0;
        while (i < str.length()) {
            TestProtocol.outBuffer[TestProtocol.idx++] = TestProtocol.mask(str.getBytes()[i]);
            ++i;
        }
    }

    private static void writeLong(int value) {
        TestProtocol.incBufferLength(4);
        TestProtocol.outBuffer[TestProtocol.idx++] = TestProtocol.mask(TestProtocol.toByte(value)[0]);
        TestProtocol.outBuffer[TestProtocol.idx++] = TestProtocol.mask(TestProtocol.toByte(value)[1]);
        TestProtocol.outBuffer[TestProtocol.idx++] = TestProtocol.mask(TestProtocol.toByte(value)[2]);
        TestProtocol.outBuffer[TestProtocol.idx++] = TestProtocol.mask(TestProtocol.toByte(value)[3]);
    }

    private static void writeWord(short value) {
        TestProtocol.incBufferLength(2);
        TestProtocol.outBuffer[TestProtocol.idx++] = TestProtocol.mask(TestProtocol.toByte(value)[0]);
        TestProtocol.outBuffer[TestProtocol.idx++] = TestProtocol.mask(TestProtocol.toByte(value)[1]);
    }

    private static void writeByte(byte value) {
        TestProtocol.incBufferLength(1);
        TestProtocol.outBuffer[TestProtocol.idx++] = TestProtocol.mask(value);
    }

    public static byte readByte() {
        byte byteValue = 0;
        byteValue = inBuffer[idx2++];
        return byteValue;
    }

    public static short readWord() {
        short wordValue = 0;
        wordValue = (short)((short)(TestProtocol.readByte() & 0xFF) << 8);
        wordValue = (short)(wordValue | (short)(TestProtocol.readByte() & 0xFF));
        return wordValue;
    }

    public static int readLong() {
        int longValue = 0;
        longValue = TestProtocol.readWord() << 16;
        return longValue |= TestProtocol.readWord();
    }

    public static String readString() {
        int length = TestProtocol.readByte() & 0xFF;
        StringBuffer str = new StringBuffer(length + 1);
        int i = 1;
        while (i <= length) {
            str.append((char)TestProtocol.readByte());
            ++i;
        }
        String stringValue = str.toString().replaceAll("\t", "  ");
        return stringValue;
    }

    public static boolean readBoolean() {
        boolean booleanValue = false;
        booleanValue = TestProtocol.readByte() != 0;
        return booleanValue;
    }

    private static void incBufferLength(int inc) {
        int inBufferLength = (outBuffer[3] << 24 & 0xFF000000) + (outBuffer[4] << 16 & 0xFF0000) + (outBuffer[5] << 8 & 0xFF00) + (outBuffer[6] & 0xFF);
        TestProtocol.outBuffer[3] = TestProtocol.mask(TestProtocol.toByte(inBufferLength += inc)[0]);
        TestProtocol.outBuffer[4] = TestProtocol.mask(TestProtocol.toByte(inBufferLength)[1]);
        TestProtocol.outBuffer[5] = TestProtocol.mask(TestProtocol.toByte(inBufferLength)[2]);
        TestProtocol.outBuffer[6] = TestProtocol.mask(TestProtocol.toByte(inBufferLength)[3]);
    }

    private static byte mask(byte value) {
        return (byte)(value & 0xFF);
    }
}

