/*
 * main implementation: use this 'C++' sample to create your own application
 *
 */

#include "derivative.h" /* include peripheral declarations */

#define KEY_VALUE1 0x5AF0ul
#define KEY_VALUE2 0xA50Ful

#ifdef __cplusplus
extern "C" {
#endif

extern void xcptn_xmpl(void);
void hw_init(void);

#ifdef __cplusplus
}
#endif

void hw_init(void)
{
#if defined(TURN_ON_CPU2)
	uint32_t mctl = MC_ME.MCTL.R;
	/* enable core 2 in all modes */
	MC_ME.CCTL3.R = 0x00FE;
	/* Set Start address for core 2: Will reset and start */
#if defined(START_FROM_FLASH)
    MC_ME.CADDR3.R = $(FLASH_START_2) | 0x1;
#else
    MC_ME.CADDR3.R = $(RAM_START_2) | 0x1;
#endif /* defined(START_FROM_FLASH) */
	MC_ME.MCTL.R = (mctl & 0xffff0000ul) | KEY_VALUE1;
	MC_ME.MCTL.R =  mctl; /* key value 2 always from MCTL */
#endif
}

class counterclass
{
private:
  	int m_counter;
public:  
	counterclass(void) 
	{
		m_counter = 0;
	};
	void increment(void) 
	{
		m_counter++;
	};  	
};

int main()
{
	counterclass myccounter;

	xcptn_xmpl ();              /* Configure and Enable Interrupts */

	/* Loop forever */
	for(;;) {	
			myccounter.increment();
		}
}
