/**************************************************************************
 * FILE NAME: MPC5748G.h                           COPYRIGHT (c) NXP 2017 *
 * REVISION:  6.0.2                                   All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the MPC5748G.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 0.1.0      P.A.      24-SEP-12     -First release.                     *
 *                                                                        *
 * 0.1.1      P.A.      25-SEP-12     -TCD registers were set in the same *
 *                                    way than other MCUs as McKinley and *
 *                                    Panther.                            *
 *                                    -USB modules were added.            *
 *                                                                        *
 * 0.2.0      M.D.      06-MAY-13     -First release with new generation  *
 *                                    method.                             *
 *                                    -Does not include BCTU & EMIOS      *
 *                                                                        *
 * 0.3.0      M.D.      14-MAY-13     -Corrected size of CAN message      *
 *                                    buffer. Added eMIOS module.         *
 *                                                                        *
 * 0.3.1      M.D.      15-MAY-13     -Added BCTU, eMIOS200 modules       *
 *                                                                        *
 * 1.0.0      M.D.      16-MAY-13     -Expanded registers for bit access  *
 *                                     In BCTU: SFTRGR1, SFTRGR2, SFTRGR3 *
 *                                     In FCCU: NCF_CFG, NCFS_CFG, NCF_S, *
 *                                     NCF_E, NCF_TOE, IRQ_ALARM_EN,      *
 *                                     NMI_EN, and EOUT_SIG_EN            *
 *                                    -Updated MC_RGM module              *
 *                                                                        *
 * 1.0.1      M.D.      30-MAY-13     -Added SPI                          *
 *                                                                        *
 * 1.0.2      M.D.      27-JUN-13     -Changed GPDO & GPDI array sizes    *
 *                                     from 511 to 512                    *
 *                                                                        *
 * 1.0.3      M.D.      16-AUG-13     -Regenerated with updated generation*
 *                                     program and now SFTRG1,2,3 in BCTU *
 *                                     and NCF_CFG, NCFS_CFG, NCF_S, NCF_E*
 *                                     NCF_TOE, IRQ_ALARM_EN, NMI_EN,     *
 *                                     EOUT_SIG_EN in FCCU have correct   *
 *                                     names for bit positions.           *
 *                                                                        *
 * 2.1.0      M.D.      25-SEP-13     -Regenerated from RDP 2.1           *
 *                                                                        *
 * 2.1.1      M.D.      26-SEP-13     -Corrected endian of registers      *
 *                                                                        *
 * 2.1.2      M.D.      30-SEP-13     -Regenerated with updated ADC       *
 *                                                                        *
 * 2.1.3      M.D.      02-OCT-13     -Corrected some macro definitions:  *
 *                                     ADC, BCTU, ENET, MC_ME             *
 *                                                                        *
 * 2.1.4      M.D.      10-OCT-13     -Regenerated with updates to MEMU_0,*
 *                                     PIT, SPI, and CAN_0(start address) *
 *                                                                        *
 * 2.1.5      M.D.      18-OCT-13     -Removed old SPI_0 macros           *
 *                                                                        *
 * 2.1.6      M.D.      31-OCT-13     -Updated base address for eMIOS_UC  *
 *                                                                        *
 * 2.1.7      M.D.      20-DEC-13     -Removed '_' from macros referencing*
 *                                     LISTCHR array in BCTU incorrectly  *
 *                                                                        *
 * 2.1.8      M.D.      11-FEB-14     -Changed bitfield from PPC to PPCA  *
 *                                     in UHST and UOTG modules HCSPARAMS *
 *                                     registers                          *
 *                                                                        *
 * 2.1.9      M.D.      12-FEB-14     -Corrected macro definitions for    *
 *                                     SIUL2.GPDO and SIUL2.GPDI          *   
 *                                                                        *
 * 2.1.10     M.D.      18-FEB-14     -Corrected macro definition for     *
 *                                     SIUL2.GPDI                         *   
 *                                                                        *
 * 2.1.11     M.D.      25-FEB-14     -Added STCU2.INT_FLG register       * 
 *                                                                        *
 * 2.1.12     M.D.      26-FEB-14     -Added STCU2_INT_FLG macro          * 
 *                                                                        *
 * 2.1.13     M.D.      11-MAR-14     -replaced DMA with eDMA in module   *
 *                                     address declaration                *
 *                                                                        * 
 * 3.0.00     M.D.      15-MAY-14     -regenerated from RDP/RM rev3       * 
 *                                                                        *
 * 4.0.00     M.D.      10-JUL-14     -regenerated from RDP/RM rev4       * 
 *                                                                        *
 * 5.0.00     M.D.      30-APR-15     -regenerated from RDP/RM rev5       * 
 *                                                                        *
 * 5.2.00     M.D.      18-MAR-16     -regenerated from RDP/RM rev5.2     * 
 *                                                                        *
 * 6.0.0      M.D.      13-APR-16     -regenerated from RDP/RM rev6.0     *
 *                                     draft A                            * 
 *                                                                        *
 * 6.0.1      I.T.      09-MAY-17     -Fixed CAN FD Buffers               * 
 *                                                                        *
 * 6.0.2      M.V.      30-OCT-17     -Fixed SEMA42 base address          * 
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                                 *
 *  THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR             *
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES *
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.   *
 *  IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,       *
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES        *
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR        *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)        *
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,       *
 *  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING     *
 *  IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF            *
 *  THE POSSIBILITY OF SUCH DAMAGE.                                           *
 *                                                                            *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MPC5748G_H_
#define _MPC5748G_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif
#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpedantic"
#endif


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

typedef union ADC_MCR_union_tag {      /* Main Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t OWREN:1;                 /* Overwrite enable. */
    vuint32_t WLSIDE:1;                /* Write Left/Right aligned. */
    vuint32_t MODE:1;                  /* One_Shot/Scan. */
    vuint32_t _unused_28:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_25:1;
    vuint32_t NSTART:1;
    vuint32_t _unused_23:1;
    vuint32_t JTRGEN:1;                /* Injection external trigger enable. */
    vuint32_t JEDGE:1;                 /* Injection trigger edge selection. */
    vuint32_t JSTART:1;                /* Injection start. */
    vuint32_t _unused_18:2;
    vuint32_t CTUEN:1;                 /* Crosstrigger Unit Enable. */
    vuint32_t CTU_MODE:1;              /* Crosstrigger Unit MODE bit */
    vuint32_t _unused_15:1;
    vuint32_t _unused_9:6;
    vuint32_t ADCLKSEL:1;              /* Analog Clock frequency Selector. */
    vuint32_t ABORT_CHAIN:1;           /* Abort Chain. */
    vuint32_t ABORT:1;                 /* Abort Conversion. */
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t _unused_3:2;
    vuint32_t REFSEL:2;                /* Reference voltage selection for ADC analog part. */
    vuint32_t PWDN:1;                  /* Power-down enable. */
  } B;
} ADC_MCR_tag;

typedef union ADC_MSR_union_tag {      /* Main Status register */
  vuint32_t R;
  struct {
    vuint32_t CALIBRTD:1;              /* This bit indicates the ADC calibration status. */
    vuint32_t _unused_25:6;
    vuint32_t NSTART:1;                /* This status bit is used to signal that a Normal conversion is ongoing. */
    vuint32_t JABORT:1;
    vuint32_t _unused_21:2;
    vuint32_t JSTART:1;                /* This status bit is used to signal that an Injected conversion is ongoing. */
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_17:1;
    vuint32_t CTUSTART:1;              /* This status bit is used to signal that a BCTU conversion is ongoing. */
    vuint32_t CHADDR:7;                /* Channel under measure address. */
    vuint32_t _unused_6:3;
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t _unused_3:2;
    vuint32_t ADCSTATUS:3;             /* Status of the ADC. */
  } B;
} ADC_MSR_tag;

typedef union ADC_ISR_union_tag {      /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t EOCTU:1;
    vuint32_t JEOC:1;                  /* End of injected channel conversion. */
    vuint32_t JECH:1;                  /* End of injected chain conversion. */
    vuint32_t EOC:1;                   /* End of channel conversion. */
    vuint32_t ECH:1;                   /* End of chain conversion. */
  } B;
} ADC_ISR_tag;

typedef union ADC_CEOCFR0_union_tag {  /* Channel Pending register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t EOCCH15:1;               /* EOC Channel 15. */
    vuint32_t EOCCH14:1;               /* EOC Channel 14. */
    vuint32_t EOCCH13:1;               /* EOC Channel 13. */
    vuint32_t EOCCH12:1;               /* EOC Channel 12. */
    vuint32_t EOCCH11:1;               /* EOC Channel 11. */
    vuint32_t EOCCH10:1;               /* EOC Channel 10. */
    vuint32_t EOCCH9:1;                /* EOC Channel 9. */
    vuint32_t EOCCH8:1;                /* EOC Channel 8. */
    vuint32_t EOCCH7:1;                /* EOC Channel 7. */
    vuint32_t EOCCH6:1;                /* EOC Channel 6. */
    vuint32_t EOCCH5:1;                /* EOC Channel 5. */
    vuint32_t EOCCH4:1;                /* EOC Channel 4. */
    vuint32_t EOCCH3:1;                /* EOC Channel 3. */
    vuint32_t EOCCH2:1;                /* EOC Channel 2. */
    vuint32_t EOCCH1:1;                /* EOC Channel 1. */
    vuint32_t EOCCH0:1;                /* EOC Channel 0. */
  } B;
} ADC_CEOCFR0_tag;

typedef union ADC_CEOCFR1_union_tag {  /* Channel Pending register 1 */
  vuint32_t R;
  struct {
    vuint32_t EOCCH63:1;               /* EOC Channel 63. */
    vuint32_t EOCCH62:1;               /* EOC Channel 62. */
    vuint32_t EOCCH61:1;               /* EOC Channel 61. */
    vuint32_t EOCCH60:1;               /* EOC Channel 60. */
    vuint32_t EOCCH59:1;               /* EOC Channel 59. */
    vuint32_t EOCCH58:1;               /* EOC Channel 58. */
    vuint32_t EOCCH57:1;               /* EOC Channel 57. */
    vuint32_t EOCCH56:1;               /* EOC Channel 56. */
    vuint32_t EOCCH55:1;               /* EOC Channel 55. */
    vuint32_t EOCCH54:1;               /* EOC Channel 54. */
    vuint32_t EOCCH53:1;               /* EOC Channel 53. */
    vuint32_t EOCCH52:1;               /* EOC Channel 52. */
    vuint32_t EOCCH51:1;               /* EOC Channel 51. */
    vuint32_t EOCCH50:1;               /* EOC Channel 50. */
    vuint32_t EOCCH49:1;               /* EOC Channel 49. */
    vuint32_t EOCCH48:1;               /* EOC Channel 48 */
    vuint32_t EOCCH47:1;               /* EOC Channel 47. */
    vuint32_t EOCCH46:1;               /* EOC Channel 46. */
    vuint32_t EOCCH45:1;               /* EOC Channel 45. */
    vuint32_t EOCCH44:1;               /* EOC Channel 44. */
    vuint32_t EOCCH43:1;               /* EOC Channel 43. */
    vuint32_t EOCCH42:1;               /* EOC Channel 42. */
    vuint32_t EOCCH41:1;               /* EOC Channel 41. */
    vuint32_t EOCCH40:1;               /* EOC Channel 40. */
    vuint32_t EOCCH39:1;               /* EOC Channel 39. */
    vuint32_t EOCCH38:1;               /* EOC Channel 38. */
    vuint32_t EOCCH37:1;               /* EOC Channel 37. */
    vuint32_t EOCCH36:1;               /* EOC Channel 36. */
    vuint32_t EOCCH35:1;               /* EOC Channel 35. */
    vuint32_t EOCCH34:1;               /* EOC Channel 34. */
    vuint32_t EOCCH33:1;               /* EOC Channel 33. */
    vuint32_t EOCCH32:1;               /* EOC Channel 32. */
  } B;
} ADC_CEOCFR1_tag;

typedef union ADC_CEOCFR2_union_tag {  /* Channel Pending register 2 */
  vuint32_t R;
  struct {
    vuint32_t EOCCH95:1;               /* EOC Channel 95. */
    vuint32_t EOCCH94:1;               /* EOC Channel 94. */
    vuint32_t EOCCH93:1;               /* EOC Channel 93. */
    vuint32_t EOCCH92:1;               /* EOC Channel 92. */
    vuint32_t EOCCH91:1;               /* EOC Channel 91. */
    vuint32_t EOCCH90:1;               /* EOC Channel 90. */
    vuint32_t EOCCH89:1;               /* EOC Channel 89. */
    vuint32_t EOCCH88:1;               /* EOC Channel 88. */
    vuint32_t EOCCH87:1;               /* EOC Channel 87. */
    vuint32_t EOCCH86:1;               /* EOC Channel 86. */
    vuint32_t EOCCH85:1;               /* EOC Channel 85. */
    vuint32_t EOCCH84:1;               /* EOC Channel 84. */
    vuint32_t EOCCH83:1;               /* EOC Channel 83. */
    vuint32_t EOCCH82:1;               /* EOC Channel 82. */
    vuint32_t EOCCH81:1;               /* EOC Channel 81. */
    vuint32_t EOCCH80:1;               /* EOC Channel 80. */
    vuint32_t EOCCH79:1;               /* EOC Channel 79. */
    vuint32_t EOCCH78:1;               /* EOC Channel 78. */
    vuint32_t EOCCH77:1;               /* EOC Channel 77. */
    vuint32_t EOCCH76:1;               /* EOC Channel 76. */
    vuint32_t EOCCH75:1;               /* EOC Channel 75. */
    vuint32_t EOCCH74:1;               /* EOC Channel 74. */
    vuint32_t EOCCH73:1;               /* EOC Channel 73. */
    vuint32_t EOCCH72:1;               /* EOC Channel 72. */
    vuint32_t EOCCH71:1;               /* EOC Channel 71. */
    vuint32_t EOCCH70:1;               /* EOC Channel 70. */
    vuint32_t EOCCH69:1;               /* EOC Channel 69. */
    vuint32_t EOCCH68:1;               /* EOC Channel 68. */
    vuint32_t EOCCH67:1;               /* EOC Channel 67. */
    vuint32_t EOCCH66:1;               /* EOC Channel 66. */
    vuint32_t EOCCH65:1;               /* EOC Channel 65. */
    vuint32_t EOCCH64:1;               /* EOC Channel 64. */
  } B;
} ADC_CEOCFR2_tag;

typedef union ADC_IMR_union_tag {      /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_15:1;
    vuint32_t _unused_5:10;
    vuint32_t MSKEOCTU:1;              /* Mask bit for EOCTU. */
    vuint32_t MSKJEOC:1;               /* Mask bit for JEOC. */
    vuint32_t MSKJECH:1;               /* Mask bit for JECH. */
    vuint32_t MSKEOC:1;                /* Mask bit for EOC. */
    vuint32_t MSKECH:1;                /* Mask bit for ECH. */
  } B;
} ADC_IMR_tag;

typedef union ADC_CIMR0_union_tag {    /* Channel Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CIM15:1;                 /* Channel 15 interrupt enable. */
    vuint32_t CIM14:1;                 /* Channel 14 interrupt enable. */
    vuint32_t CIM13:1;                 /* Channel 13 interrupt enable. */
    vuint32_t CIM12:1;                 /* Channel 12 interrupt enable. */
    vuint32_t CIM11:1;                 /* Channel 11 interrupt enable. */
    vuint32_t CIM10:1;                 /* Channel 10 interrupt enable. */
    vuint32_t CIM9:1;                  /* Channel 9 interrupt enable. */
    vuint32_t CIM8:1;                  /* Channel 8 interrupt enable. */
    vuint32_t CIM7:1;                  /* Channel 7 interrupt enable. */
    vuint32_t CIM6:1;                  /* Channel 6 interrupt enable. */
    vuint32_t CIM5:1;                  /* Channel 5 interrupt enable. */
    vuint32_t CIM4:1;                  /* Channel 4 interrupt enable. */
    vuint32_t CIM3:1;                  /* Channel 3 interrupt enable. */
    vuint32_t CIM2:1;                  /* Channel 2 interrupt enable. */
    vuint32_t CIM1:1;                  /* Channel 1 interrupt enable. */
    vuint32_t CIM0:1;                  /* Channel 0 interrupt enable. */
  } B;
} ADC_CIMR0_tag;

typedef union ADC_CIMR1_union_tag {    /* Channel Interrupt Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CIM63:1;                 /* Channel 63 interrupt enable. */
    vuint32_t CIM62:1;                 /* Channel 62 interrupt enable. */
    vuint32_t CIM61:1;                 /* Channel 61 interrupt enable. */
    vuint32_t CIM60:1;                 /* Channel 60 interrupt enable. */
    vuint32_t CIM59:1;                 /* Channel 59 interrupt enable. */
    vuint32_t CIM58:1;                 /* Channel 58 interrupt enable. */
    vuint32_t CIM57:1;                 /* Channel 57 interrupt enable. */
    vuint32_t CIM56:1;                 /* Channel 56 interrupt enable. */
    vuint32_t CIM55:1;                 /* Channel 55 interrupt enable. */
    vuint32_t CIM54:1;                 /* Channel 54 interrupt enable. */
    vuint32_t CIM53:1;                 /* Channel 53 interrupt enable. */
    vuint32_t CIM52:1;                 /* Channel 52 interrupt enable. */
    vuint32_t CIM51:1;                 /* Channel 51 interrupt enable. */
    vuint32_t CIM50:1;                 /* Channel 50 interrupt enable. */
    vuint32_t CIM49:1;                 /* Channel 49 interrupt enable. */
    vuint32_t CIM48:1;                 /* Channel 48 interrupt enable. */
    vuint32_t CIM47:1;                 /* Channel 47 interrupt enable. */
    vuint32_t CIM46:1;                 /* Channel 46 interrupt enable. */
    vuint32_t CIM45:1;                 /* Channel 45 interrupt enable. */
    vuint32_t CIM44:1;                 /* Channel 44 interrupt enable. */
    vuint32_t CIM43:1;                 /* Channel 43 interrupt enable. */
    vuint32_t CIM42:1;                 /* Channel 42 interrupt enable. */
    vuint32_t CIM41:1;                 /* Channel 41 interrupt enable. */
    vuint32_t CIM40:1;                 /* Channel 40 interrupt enable. */
    vuint32_t CIM39:1;                 /* Channel 39 interrupt enable. */
    vuint32_t CIM38:1;                 /* Channel 38 interrupt enable. */
    vuint32_t CIM37:1;                 /* Channel 37 interrupt enable. */
    vuint32_t CIM36:1;                 /* Channel 36 interrupt enable. */
    vuint32_t CIM35:1;                 /* Channel 35 interrupt enable. */
    vuint32_t CIM34:1;                 /* Channel 34 interrupt enable. */
    vuint32_t CIM33:1;                 /* Channel 33 interrupt enable. */
    vuint32_t CIM32:1;                 /* Channel 32 interrupt enable. */
  } B;
} ADC_CIMR1_tag;

typedef union ADC_CIMR2_union_tag {    /* Channel Interrupt Mask Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CIM95:1;                 /* Channel 95 interrupt enable. */
    vuint32_t CIM94:1;                 /* Channel 94 interrupt enable. */
    vuint32_t CIM93:1;                 /* Channel 93 interrupt enable. */
    vuint32_t CIM92:1;                 /* Channel 92 interrupt enable. */
    vuint32_t CIM91:1;                 /* Channel 91 interrupt enable. */
    vuint32_t CIM90:1;                 /* Channel 90 interrupt enable. */
    vuint32_t CIM89:1;                 /* Channel 89 interrupt enable. */
    vuint32_t CIM88:1;                 /* Channel 88 interrupt enable. */
    vuint32_t CIM87:1;                 /* Channel 87 interrupt enable. */
    vuint32_t CIM86:1;                 /* Channel 86 interrupt enable. */
    vuint32_t CIM85:1;                 /* Channel 85 interrupt enable. */
    vuint32_t CIM84:1;                 /* Channel 84 interrupt enable. */
    vuint32_t CIM83:1;                 /* Channel 83 interrupt enable. */
    vuint32_t CIM82:1;                 /* Channel 82 interrupt enable. */
    vuint32_t CIM81:1;                 /* Channel 81 interrupt enable. */
    vuint32_t CIM80:1;                 /* Channel 80 interrupt enable. */
    vuint32_t CIM79:1;                 /* Channel 79 interrupt enable. */
    vuint32_t CIM78:1;                 /* Channel 78 interrupt enable. */
    vuint32_t CIM77:1;                 /* Channel 77 interrupt enable. */
    vuint32_t CIM76:1;                 /* Channel 76 interrupt enable. */
    vuint32_t CIM75:1;                 /* Channel 75 interrupt enable. */
    vuint32_t CIM74:1;                 /* Channel 74 interrupt enable. */
    vuint32_t CIM73:1;                 /* Channel 73 interrupt enable. */
    vuint32_t CIM72:1;                 /* Channel 72 interrupt enable. */
    vuint32_t CIM71:1;                 /* Channel 71 interrupt enable. */
    vuint32_t CIM70:1;                 /* Channel 70 interrupt enable. */
    vuint32_t CIM69:1;                 /* Channel 69 interrupt enable. */
    vuint32_t CIM68:1;                 /* Channel 68 interrupt enable. */
    vuint32_t CIM67:1;                 /* Channel 67 interrupt enable. */
    vuint32_t CIM66:1;                 /* Channel 66 interrupt enable. */
    vuint32_t CIM65:1;                 /* Channel 65 interrupt enable. */
    vuint32_t CIM64:1;                 /* Channel 64 interrupt enable. */
  } B;
} ADC_CIMR2_tag;

typedef union ADC_WTISR_union_tag {    /* Watchdog Threshold Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t WDG5H:1;
    vuint32_t WDG5L:1;
    vuint32_t WDG4H:1;
    vuint32_t WDG4L:1;
    vuint32_t WDG3H:1;
    vuint32_t WDG3L:1;
    vuint32_t WDG2H:1;
    vuint32_t WDG2L:1;
    vuint32_t WDG1H:1;
    vuint32_t WDG1L:1;
    vuint32_t WDG0H:1;
    vuint32_t WDG0L:1;
  } B;
} ADC_WTISR_tag;

typedef union ADC_WTIMR_union_tag {    /* Watchdog Threshold Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t MSKWDG5H:1;
    vuint32_t MSKWDG5L:1;
    vuint32_t MSKWDG4H:1;
    vuint32_t MSKWDG4L:1;
    vuint32_t MSKWDG3H:1;
    vuint32_t MSKWDG3L:1;
    vuint32_t MSKWDG2H:1;
    vuint32_t MSKWDG2L:1;
    vuint32_t MSKWDG1H:1;
    vuint32_t MSKWDG1L:1;
    vuint32_t MSKWDG0H:1;
    vuint32_t MSKWDG0L:1;
  } B;
} ADC_WTIMR_tag;

typedef union ADC_DMAE_union_tag {     /* DMA Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t _unused_1:1;
    vuint32_t DMAEN:1;                 /* DMA global enable. */
  } B;
} ADC_DMAE_tag;

typedef union ADC_DMAR0_union_tag {    /* DMA Channel Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DMA15:1;                 /* DMA enable for channel 15. */
    vuint32_t DMA14:1;                 /* DMA enable for channel 14. */
    vuint32_t DMA13:1;                 /* DMA enable for channel 13. */
    vuint32_t DMA12:1;                 /* DMA enable for channel 12. */
    vuint32_t DMA11:1;                 /* DMA enable for channel 11. */
    vuint32_t DMA10:1;                 /* DMA enable for channel 10. */
    vuint32_t DMA9:1;                  /* DMA enable for channel 9. */
    vuint32_t DMA8:1;                  /* DMA enable for channel 8. */
    vuint32_t DMA7:1;                  /* DMA enable for channel 7. */
    vuint32_t DMA6:1;                  /* DMA enable for channel 6. */
    vuint32_t DMA5:1;                  /* DMA enable for channel 5. */
    vuint32_t DMA4:1;                  /* DMA enable for channel 4. */
    vuint32_t DMA3:1;                  /* DMA enable for channel 3. */
    vuint32_t DMA2:1;                  /* DMA enable for channel 2. */
    vuint32_t DMA1:1;                  /* DMA enable for channel 1. */
    vuint32_t DMA0:1;                  /* DMA enable for channel 0. */
  } B;
} ADC_DMAR0_tag;

typedef union ADC_DMAR1_union_tag {    /* DMA Channel Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DMA63:1;                 /* DMA enable for channel 63. */
    vuint32_t DMA62:1;                 /* DMA enable for channel 62. */
    vuint32_t DMA61:1;                 /* DMA enable for channel 61. */
    vuint32_t DMA60:1;                 /* DMA enable for channel 60. */
    vuint32_t DMA59:1;                 /* DMA enable for channel 59. */
    vuint32_t DMA58:1;                 /* DMA enable for channel 58. */
    vuint32_t DMA57:1;                 /* DMA enable for channel 57. */
    vuint32_t DMA56:1;                 /* DMA enable for channel 56. */
    vuint32_t DMA55:1;                 /* DMA enable for channel 55. */
    vuint32_t DMA54:1;                 /* DMA enable for channel 54. */
    vuint32_t DMA53:1;                 /* DMA enable for channel 53. */
    vuint32_t DMA52:1;                 /* DMA enable for channel 52. */
    vuint32_t DMA51:1;                 /* DMA enable for channel 51. */
    vuint32_t DMA50:1;                 /* DMA enable for channel 50. */
    vuint32_t DMA49:1;                 /* DMA enable for channel 49. */
    vuint32_t DMA48:1;                 /* DMA enable for channel 48. */
    vuint32_t DMA47:1;                 /* DMA enable for channel 47. */
    vuint32_t DMA46:1;                 /* DMA enable for channel 46. */
    vuint32_t DMA45:1;                 /* DMA enable for channel 45. */
    vuint32_t DMA44:1;                 /* DMA enable for channel 44. */
    vuint32_t DMA43:1;                 /* DMA enable for channel 43. */
    vuint32_t DMA42:1;                 /* DMA enable for channel 42. */
    vuint32_t DMA41:1;                 /* DMA enable for channel 41. */
    vuint32_t DMA40:1;                 /* DMA enable for channel 40. */
    vuint32_t DMA39:1;                 /* DMA enable for channel 39. */
    vuint32_t DMA38:1;                 /* DMA enable for channel 38. */
    vuint32_t DMA37:1;                 /* DMA enable for channel 37. */
    vuint32_t DMA36:1;                 /* DMA enable for channel 36. */
    vuint32_t DMA35:1;                 /* DMA enable for channel 35. */
    vuint32_t DMA34:1;                 /* DMA enable for channel 34. */
    vuint32_t DMA33:1;                 /* DMA enable for channel 33. */
    vuint32_t DMA32:1;                 /* DMA enable for channel 32. */
  } B;
} ADC_DMAR1_tag;

typedef union ADC_DMAR2_union_tag {    /* DMA Channel Select Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DMA95:1;                 /* DMA enable for channel 95. */
    vuint32_t DMA94:1;                 /* DMA enable for channel 94. */
    vuint32_t DMA93:1;                 /* DMA enable for channel 93. */
    vuint32_t DMA92:1;                 /* DMA enable for channel 92. */
    vuint32_t DMA91:1;                 /* DMA enable for channel 91. */
    vuint32_t DMA90:1;                 /* DMA enable for channel 90. */
    vuint32_t DMA89:1;                 /* DMA enable for channel 89. */
    vuint32_t DMA88:1;                 /* DMA enable for channel 88. */
    vuint32_t DMA87:1;                 /* DMA enable for channel 87. */
    vuint32_t DMA86:1;                 /* DMA enable for channel 86. */
    vuint32_t DMA85:1;                 /* DMA enable for channel 85. */
    vuint32_t DMA84:1;                 /* DMA enable for channel 84. */
    vuint32_t DMA83:1;                 /* DMA enable for channel 83. */
    vuint32_t DMA82:1;                 /* DMA enable for channel 82. */
    vuint32_t DMA81:1;                 /* DMA enable for channel 81. */
    vuint32_t DMA80:1;                 /* DMA enable for channel 80. */
    vuint32_t DMA79:1;                 /* DMA enable for channel 79. */
    vuint32_t DMA78:1;                 /* DMA enable for channel 78. */
    vuint32_t DMA77:1;                 /* DMA enable for channel 77. */
    vuint32_t DMA76:1;                 /* DMA enable for channel 76. */
    vuint32_t DMA75:1;                 /* DMA enable for channel 75. */
    vuint32_t DMA74:1;                 /* DMA enable for channel 74. */
    vuint32_t DMA73:1;                 /* DMA enable for channel 73. */
    vuint32_t DMA72:1;                 /* DMA enable for channel 72. */
    vuint32_t DMA71:1;                 /* DMA enable for channel 71. */
    vuint32_t DMA70:1;                 /* DMA enable for channel 70. */
    vuint32_t DMA69:1;                 /* DMA enable for channel 69. */
    vuint32_t DMA68:1;                 /* DMA enable for channel 68. */
    vuint32_t DMA67:1;                 /* DMA enable for channel 67. */
    vuint32_t DMA66:1;                 /* DMA enable for channel 66. */
    vuint32_t DMA65:1;                 /* DMA enable for channel 65. */
    vuint32_t DMA64:1;                 /* DMA enable for channel 64. */
  } B;
} ADC_DMAR2_tag;

typedef union ADC_THRHLR0_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR0_tag;

typedef union ADC_THRHLR1_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR1_tag;

typedef union ADC_THRHLR2_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR2_tag;

typedef union ADC_THRHLR3_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR3_tag;

typedef union ADC_PSCR_union_tag {     /* Presampling Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t PREVAL2:2;               /* Internal voltage selection for Presampling */
    vuint32_t PREVAL1:2;               /* Internal voltage selection for Presampling. */
    vuint32_t PREVAL0:2;               /* Internal voltage selection for Presampling. */
    vuint32_t PRECONV:1;               /* Convert Presampled value */
  } B;
} ADC_PSCR_tag;

typedef union ADC_PSR0_union_tag {     /* Presampling register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PRES15:1;                /* Presampling enable for channel 15. */
    vuint32_t PRES14:1;                /* Presampling enable for channel 14. */
    vuint32_t PRES13:1;                /* Presampling enable for channel 13. */
    vuint32_t PRES12:1;                /* Presampling enable for channel 12. */
    vuint32_t PRES11:1;                /* Presampling enable for channel 11. */
    vuint32_t PRES10:1;                /* Presampling enable for channel 10. */
    vuint32_t PRES9:1;                 /* Presampling enable for channel 9. */
    vuint32_t PRES8:1;                 /* Presampling enable for channel 8. */
    vuint32_t PRES7:1;                 /* Presampling enable for channel 7. */
    vuint32_t PRES6:1;                 /* Presampling enable for channel 6. */
    vuint32_t PRES5:1;                 /* Presampling enable for channel 5. */
    vuint32_t PRES4:1;                 /* Presampling enable for channel 4. */
    vuint32_t PRES3:1;                 /* Presampling enable for channel 3. */
    vuint32_t PRES2:1;                 /* Presampling enable for channel 2. */
    vuint32_t PRES1:1;                 /* Presampling enable for channel 1. */
    vuint32_t PRES0:1;                 /* Presampling enable for channel 0. */
  } B;
} ADC_PSR0_tag;

typedef union ADC_PSR1_union_tag {     /* Presampling register 1 */
  vuint32_t R;
  struct {
    vuint32_t PRES63:1;                /* Presampling enable for channel 63. */
    vuint32_t PRES62:1;                /* Presampling enable for channel 62. */
    vuint32_t PRES61:1;                /* Presampling enable for channel 61. */
    vuint32_t PRES60:1;                /* Presampling enable for channel 60. */
    vuint32_t PRES59:1;                /* Presampling enable for channel 59. */
    vuint32_t PRES58:1;                /* Presampling enable for channel 58. */
    vuint32_t PRES57:1;                /* Presampling enable for channel 57. */
    vuint32_t PRES56:1;                /* Presampling enable for channel 56. */
    vuint32_t PRES55:1;                /* Presampling enable for channel 55. */
    vuint32_t PRES54:1;                /* Presampling enable for channel 54. */
    vuint32_t PRES53:1;                /* Presampling enable for channel 53. */
    vuint32_t PRES52:1;                /* Presampling enable for channel 52. */
    vuint32_t PRES51:1;                /* Presampling enable for channel 51. */
    vuint32_t PRES50:1;                /* Presampling enable for channel 50. */
    vuint32_t PRES49:1;                /* Presampling enable for channel 49. */
    vuint32_t PRES48:1;                /* Presampling enable for channel 48. */
    vuint32_t PRES47:1;                /* Presampling enable for channel 47. */
    vuint32_t PRES46:1;                /* Presampling enable for channel 46. */
    vuint32_t PRES45:1;                /* Presampling enable for channel 45. */
    vuint32_t PRES44:1;                /* Presampling enable for channel 44. */
    vuint32_t PRES43:1;                /* Presampling enable for channel 43. */
    vuint32_t PRES42:1;                /* Presampling enable for channel 42. */
    vuint32_t PRES41:1;                /* Presampling enable for channel 41. */
    vuint32_t PRES40:1;                /* Presampling enable for channel 40. */
    vuint32_t PRES39:1;                /* Presampling enable for channel 39. */
    vuint32_t PRES38:1;                /* Presampling enable for channel 38. */
    vuint32_t PRES37:1;                /* Presampling enable for channel 37. */
    vuint32_t PRES36:1;                /* Presampling enable for channel 36. */
    vuint32_t PRES35:1;                /* Presampling enable for channel 35. */
    vuint32_t PRES34:1;                /* Presampling enable for channel 34. */
    vuint32_t PRES33:1;                /* Presampling enable for channel 33. */
    vuint32_t PRES32:1;                /* Presampling enable for channel 32. */
  } B;
} ADC_PSR1_tag;

typedef union ADC_PSR2_union_tag {     /* Presampling register 2 */
  vuint32_t R;
  struct {
    vuint32_t PRES95:1;                /* Presampling enable for channel 95. */
    vuint32_t PRES94:1;                /* Presampling enable for channel 94. */
    vuint32_t PRES93:1;                /* Presampling enable for channel 93. */
    vuint32_t PRES92:1;                /* Presampling enable for channel 92. */
    vuint32_t PRES91:1;                /* Presampling enable for channel 91. */
    vuint32_t PRES90:1;                /* Presampling enable for channel 90. */
    vuint32_t PRES89:1;                /* Presampling enable for channel 89. */
    vuint32_t PRES88:1;                /* Presampling enable for channel 88. */
    vuint32_t PRES87:1;                /* Presampling enable for channel 87. */
    vuint32_t PRES86:1;                /* Presampling enable for channel 86. */
    vuint32_t PRES85:1;                /* Presampling enable for channel 85. */
    vuint32_t PRES84:1;                /* Presampling enable for channel 84. */
    vuint32_t PRES83:1;                /* Presampling enable for channel 83. */
    vuint32_t PRES82:1;                /* Presampling enable for channel 82. */
    vuint32_t PRES81:1;                /* Presampling enable for channel 81. */
    vuint32_t PRES80:1;                /* Presampling enable for channel 80. */
    vuint32_t PRES79:1;                /* Presampling enable for channel 79. */
    vuint32_t PRES78:1;                /* Presampling enable for channel 78. */
    vuint32_t PRES77:1;                /* Presampling enable for channel 77. */
    vuint32_t PRES76:1;                /* Presampling enable for channel 76. */
    vuint32_t PRES75:1;                /* Presampling enable for channel 75. */
    vuint32_t PRES74:1;                /* Presampling enable for channel 74. */
    vuint32_t PRES73:1;                /* Presampling enable for channel 73. */
    vuint32_t PRES72:1;                /* Presampling enable for channel 72. */
    vuint32_t PRES71:1;                /* Presampling enable for channel 71. */
    vuint32_t PRES70:1;                /* Presampling enable for channel 70. */
    vuint32_t PRES69:1;                /* Presampling enable for channel 69. */
    vuint32_t PRES68:1;                /* Presampling enable for channel 68. */
    vuint32_t PRES67:1;                /* Presampling enable for channel 67. */
    vuint32_t PRES66:1;                /* Presampling enable for channel 66. */
    vuint32_t PRES65:1;                /* Presampling enable for channel 65. */
    vuint32_t PRES64:1;                /* Presampling enable for channel 64. */
  } B;
} ADC_PSR2_tag;

typedef union ADC_CTR0_union_tag {     /* Conversion Timing Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR0_tag;

typedef union ADC_CTR1_union_tag {     /* Conversion Timing Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR1_tag;

typedef union ADC_CTR2_union_tag {     /* Conversion Timing Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR2_tag;

typedef union ADC_NCMR0_union_tag {    /* Normal Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH15:1;                  /* Normal sampling enable for channel 15. */
    vuint32_t CH14:1;                  /* Normal sampling enable for channel 14. */
    vuint32_t CH13:1;                  /* Normal sampling enable for channel 13. */
    vuint32_t CH12:1;                  /* Normal sampling enable for channel 12. */
    vuint32_t CH11:1;                  /* Normal sampling enable for channel 11. */
    vuint32_t CH10:1;                  /* Normal sampling enable for channel 10. */
    vuint32_t CH9:1;                   /* Normal sampling enable for channel 9. */
    vuint32_t CH8:1;                   /* Normal sampling enable for channel 8. */
    vuint32_t CH7:1;                   /* Normal sampling enable for channel 7. */
    vuint32_t CH6:1;                   /* Normal sampling enable for channel 6. */
    vuint32_t CH5:1;                   /* Normal sampling enable for channel 5. */
    vuint32_t CH4:1;                   /* Normal sampling enable for channel 4. */
    vuint32_t CH3:1;                   /* Normal sampling enable for channel 3. */
    vuint32_t CH2:1;                   /* Normal sampling enable for channel 2. */
    vuint32_t CH1:1;                   /* Normal sampling enable for channel 1. */
    vuint32_t CH0:1;                   /* Normal sampling enable for channel 0. */
  } B;
} ADC_NCMR0_tag;

typedef union ADC_NCMR1_union_tag {    /* Normal Conversion Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CH63:1;                  /* Normal sampling enable for channel 63. */
    vuint32_t CH62:1;                  /* Normal sampling enable for channel 62. */
    vuint32_t CH61:1;                  /* Normal sampling enable for channel 61. */
    vuint32_t CH60:1;                  /* Normal sampling enable for channel 60. */
    vuint32_t CH59:1;                  /* Normal sampling enable for channel 59. */
    vuint32_t CH58:1;                  /* Normal sampling enable for channel 58. */
    vuint32_t CH57:1;                  /* Normal sampling enable for channel 57. */
    vuint32_t CH56:1;                  /* Normal sampling enable for channel 56. */
    vuint32_t CH55:1;                  /* Normal sampling enable for channel 55. */
    vuint32_t CH54:1;                  /* Normal sampling enable for channel 54. */
    vuint32_t CH53:1;                  /* Normal sampling enable for channel 53. */
    vuint32_t CH52:1;                  /* Normal sampling enable for channel 52. */
    vuint32_t CH51:1;                  /* Normal sampling enable for channel 51. */
    vuint32_t CH50:1;                  /* Normal sampling enable for channel 50. */
    vuint32_t CH49:1;                  /* Normal sampling enable for channel 49. */
    vuint32_t CH48:1;                  /* Normal sampling enable for channel 48. */
    vuint32_t CH47:1;                  /* Normal sampling enable for channel 47. */
    vuint32_t CH46:1;                  /* Normal sampling enable for channel 46. */
    vuint32_t CH45:1;                  /* Normal sampling enable for channel 45. */
    vuint32_t CH44:1;                  /* Normal sampling enable for channel 44. */
    vuint32_t CH43:1;                  /* Normal sampling enable for channel 43. */
    vuint32_t CH42:1;                  /* Normal sampling enable for channel 42. */
    vuint32_t CH41:1;                  /* Normal sampling enable for channel 41. */
    vuint32_t CH40:1;                  /* Normal sampling enable for channel 40. */
    vuint32_t CH39:1;                  /* Normal sampling enable for channel 39. */
    vuint32_t CH38:1;                  /* Normal sampling enable for channel 38. */
    vuint32_t CH37:1;                  /* Normal sampling enable for channel 37. */
    vuint32_t CH36:1;                  /* Normal sampling enable for channel 36. */
    vuint32_t CH35:1;                  /* Normal sampling enable for channel 35. */
    vuint32_t CH34:1;                  /* Normal sampling enable for channel 34. */
    vuint32_t CH33:1;                  /* Normal sampling enable for channel 33. */
    vuint32_t CH32:1;                  /* Normal sampling enable for channel 32. */
  } B;
} ADC_NCMR1_tag;

typedef union ADC_NCMR2_union_tag {    /* Normal Conversion Mask Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CH95:1;                  /* Normal sampling enable for channel 95. */
    vuint32_t CH94:1;                  /* Normal sampling enable for channel 94. */
    vuint32_t CH93:1;                  /* Normal sampling enable for channel 93. */
    vuint32_t CH92:1;                  /* Normal sampling enable for channel 92. */
    vuint32_t CH91:1;                  /* Normal sampling enable for channel 91. */
    vuint32_t CH90:1;                  /* Normal sampling enable for channel 90. */
    vuint32_t CH89:1;                  /* Normal sampling enable for channel 89. */
    vuint32_t CH88:1;                  /* Normal sampling enable for channel 88. */
    vuint32_t CH87:1;                  /* Normal sampling enable for channel 87. */
    vuint32_t CH86:1;                  /* Normal sampling enable for channel 86. */
    vuint32_t CH85:1;                  /* Normal sampling enable for channel 85. */
    vuint32_t CH84:1;                  /* Normal sampling enable for channel 84. */
    vuint32_t CH83:1;                  /* Normal sampling enable for channel 83. */
    vuint32_t CH82:1;                  /* Normal sampling enable for channel 82. */
    vuint32_t CH81:1;                  /* Normal sampling enable for channel 81. */
    vuint32_t CH80:1;                  /* Normal sampling enable for channel 80. */
    vuint32_t CH79:1;                  /* Normal sampling enable for channel 79. */
    vuint32_t CH78:1;                  /* Normal sampling enable for channel 78. */
    vuint32_t CH77:1;                  /* Normal sampling enable for channel 77. */
    vuint32_t CH76:1;                  /* Normal sampling enable for channel 76. */
    vuint32_t CH75:1;                  /* Normal sampling enable for channel 75. */
    vuint32_t CH74:1;                  /* Normal sampling enable for channel 74. */
    vuint32_t CH73:1;                  /* Normal sampling enable for channel 73. */
    vuint32_t CH72:1;                  /* Normal sampling enable for channel 72. */
    vuint32_t CH71:1;                  /* Normal sampling enable for channel 71. */
    vuint32_t CH70:1;                  /* Normal sampling enable for channel 70. */
    vuint32_t CH69:1;                  /* Normal sampling enable for channel 69. */
    vuint32_t CH68:1;                  /* Normal sampling enable for channel 68. */
    vuint32_t CH67:1;                  /* Normal sampling enable for channel 67. */
    vuint32_t CH66:1;                  /* Normal sampling enable for channel 66. */
    vuint32_t CH65:1;                  /* Normal sampling enable for channel 65. */
    vuint32_t CH64:1;                  /* Normal sampling enable for channel 64. */
  } B;
} ADC_NCMR2_tag;

typedef union ADC_JCMR0_union_tag {    /* Injected Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH15:1;                  /* Injected sampling enable for channel 15. */
    vuint32_t CH14:1;                  /* Injected sampling enable for channel 14. */
    vuint32_t CH13:1;                  /* Injected sampling enable for channel 13. */
    vuint32_t CH12:1;                  /* Injected sampling enable for channel 12. */
    vuint32_t CH11:1;                  /* Injected sampling enable for channel 11. */
    vuint32_t CH10:1;                  /* Injected sampling enable for channel 10. */
    vuint32_t CH9:1;                   /* Injected sampling enable for channel 9. */
    vuint32_t CH8:1;                   /* Injected sampling enable for channel 8. */
    vuint32_t CH7:1;                   /* Injected sampling enable for channel 7. */
    vuint32_t CH6:1;                   /* Injected sampling enable for channel 6. */
    vuint32_t CH5:1;                   /* Injected sampling enable for channel 5. */
    vuint32_t CH4:1;                   /* Injected sampling enable for channel 4. */
    vuint32_t CH3:1;                   /* Injected sampling enable for channel 3. */
    vuint32_t CH2:1;                   /* Injected sampling enable for channel 2. */
    vuint32_t CH1:1;                   /* Injected sampling enable for channel 1. */
    vuint32_t CH0:1;                   /* Injected sampling enable for channel 0. */
  } B;
} ADC_JCMR0_tag;

typedef union ADC_JCMR1_union_tag {    /* Injected Conversion Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CH63:1;                  /* Injected sampling enable for channel 63. */
    vuint32_t CH62:1;                  /* Injected sampling enable for channel 62. */
    vuint32_t CH61:1;                  /* Injected sampling enable for channel 61. */
    vuint32_t CH60:1;                  /* Injected sampling enable for channel 60. */
    vuint32_t CH59:1;                  /* Injected sampling enable for channel 59. */
    vuint32_t CH58:1;                  /* Injected sampling enable for channel 58. */
    vuint32_t CH57:1;                  /* Injected sampling enable for channel 57. */
    vuint32_t CH56:1;                  /* Injected sampling enable for channel 56. */
    vuint32_t CH55:1;                  /* Injected sampling enable for channel 55. */
    vuint32_t CH54:1;                  /* Injected sampling enable for channel 54. */
    vuint32_t CH53:1;                  /* Injected sampling enable for channel 53. */
    vuint32_t CH52:1;                  /* Injected sampling enable for channel 52. */
    vuint32_t CH51:1;                  /* Injected sampling enable for channel 51. */
    vuint32_t CH50:1;                  /* Injected sampling enable for channel 50. */
    vuint32_t CH49:1;                  /* Injected sampling enable for channel 49. */
    vuint32_t CH48:1;                  /* Injected sampling enable for channel 48. */
    vuint32_t CH47:1;                  /* Injected sampling enable for channel 47. */
    vuint32_t CH46:1;                  /* Injected sampling enable for channel 46. */
    vuint32_t CH45:1;                  /* Injected sampling enable for channel 45. */
    vuint32_t CH44:1;                  /* Injected sampling enable for channel 44. */
    vuint32_t CH43:1;                  /* Injected sampling enable for channel 43. */
    vuint32_t CH42:1;                  /* Injected sampling enable for channel 42. */
    vuint32_t CH41:1;                  /* Injected sampling enable for channel 41. */
    vuint32_t CH40:1;                  /* Injected sampling enable for channel 40. */
    vuint32_t CH39:1;                  /* Injected sampling enable for channel 39. */
    vuint32_t CH38:1;                  /* Injected sampling enable for channel 38. */
    vuint32_t CH37:1;                  /* Injected sampling enable for channel 37. */
    vuint32_t CH36:1;                  /* Injected sampling enable for channel 36. */
    vuint32_t CH35:1;                  /* Injected sampling enable for channel 35. */
    vuint32_t CH34:1;                  /* Injected sampling enable for channel 34. */
    vuint32_t CH33:1;                  /* Injected sampling enable for channel 33. */
    vuint32_t CH32:1;                  /* Injected sampling enable for channel 32. */
  } B;
} ADC_JCMR1_tag;

typedef union ADC_JCMR2_union_tag {    /* Injected Conversion Mask Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CH95:1;                  /* Injected sampling enable for channel 95. */
    vuint32_t CH94:1;                  /* Injected sampling enable for channel 94. */
    vuint32_t CH93:1;                  /* Injected sampling enable for channel 93. */
    vuint32_t CH92:1;                  /* Injected sampling enable for channel 92. */
    vuint32_t CH91:1;                  /* Injected sampling enable for channel 91. */
    vuint32_t CH90:1;                  /* Injected sampling enable for channel 90. */
    vuint32_t CH89:1;                  /* Injected sampling enable for channel 89. */
    vuint32_t CH88:1;                  /* Injected sampling enable for channel 88. */
    vuint32_t CH87:1;                  /* Injected sampling enable for channel 87. */
    vuint32_t CH86:1;                  /* Injected sampling enable for channel 86. */
    vuint32_t CH85:1;                  /* Injected sampling enable for channel 85. */
    vuint32_t CH84:1;                  /* Injected sampling enable for channel 84. */
    vuint32_t CH83:1;                  /* Injected sampling enable for channel 83. */
    vuint32_t CH82:1;                  /* Injected sampling enable for channel 82. */
    vuint32_t CH81:1;                  /* Injected sampling enable for channel 81. */
    vuint32_t CH80:1;                  /* Injected sampling enable for channel 80. */
    vuint32_t CH79:1;                  /* Injected sampling enable for channel 79. */
    vuint32_t CH78:1;                  /* Injected sampling enable for channel 78. */
    vuint32_t CH77:1;                  /* Injected sampling enable for channel 77. */
    vuint32_t CH76:1;                  /* Injected sampling enable for channel 76. */
    vuint32_t CH75:1;                  /* Injected sampling enable for channel 75. */
    vuint32_t CH74:1;                  /* Injected sampling enable for channel 74. */
    vuint32_t CH73:1;                  /* Injected sampling enable for channel 73. */
    vuint32_t CH72:1;                  /* Injected sampling enable for channel 72. */
    vuint32_t CH71:1;                  /* Injected sampling enable for channel 71. */
    vuint32_t CH70:1;                  /* Injected sampling enable for channel 70. */
    vuint32_t CH69:1;                  /* Injected sampling enable for channel 69. */
    vuint32_t CH68:1;                  /* Injected sampling enable for channel 68. */
    vuint32_t CH67:1;                  /* Injected sampling enable for channel 67. */
    vuint32_t CH66:1;                  /* Injected sampling enable for channel 66. */
    vuint32_t CH65:1;                  /* Injected sampling enable for channel 65. */
    vuint32_t CH64:1;                  /* Injected sampling enable for channel 64. */
  } B;
} ADC_JCMR2_tag;

typedef union ADC_DSDR_union_tag {     /* Decode Signals Delay Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DSD:16;
  } B;
} ADC_DSDR_tag;

typedef union ADC_PDEDR_union_tag {    /* Power Down Exit Delay Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t PDED:8;
  } B;
} ADC_PDEDR_tag;

typedef union ADC_CDR_union_tag {      /* Channel Data Register n (Precision Channels) */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t VALID:1;                 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
    vuint32_t OVERW:1;                 /* Overwrite data */
    vuint32_t RESULT:2;
    vuint32_t CDATA:16;                /* Converted Data 11:0. */
  } B;
} ADC_CDR_tag;

typedef union ADC_THRHLR4_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR4_tag;

typedef union ADC_THRHLR5_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR5_tag;

typedef union ADC_CWSELR0_union_tag {  /* Channel Watchdog Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH7:4;              /* Channel Watchdog select for channel 7. */
    vuint32_t WSEL_CH6:4;              /* Channel Watchdog select for channel 6. */
    vuint32_t WSEL_CH5:4;              /* Channel Watchdog select for channel 5. */
    vuint32_t WSEL_CH4:4;              /* Channel Watchdog select for channel 4. */
    vuint32_t WSEL_CH3:4;              /* Channel Watchdog select for channel 3. */
    vuint32_t WSEL_CH2:4;              /* Channel Watchdog select for channel 2. */
    vuint32_t WSEL_CH1:4;              /* Channel Watchdog select for channel 1. */
    vuint32_t WSEL_CH0:4;              /* Channel Watchdog select for channel 0. */
  } B;
} ADC_CWSELR0_tag;

typedef union ADC_CWSELR1_union_tag {  /* Channel Watchdog Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH15:4;             /* Channel Watchdog select for channel 15. */
    vuint32_t WSEL_CH14:4;             /* Channel Watchdog select for channel 14. */
    vuint32_t WSEL_CH13:4;             /* Channel Watchdog select for channel 13. */
    vuint32_t WSEL_CH12:4;             /* Channel Watchdog select for channel 12. */
    vuint32_t WSEL_CH11:4;             /* Channel Watchdog select for channel 11. */
    vuint32_t WSEL_CH10:4;             /* Channel Watchdog select for channel 10. */
    vuint32_t WSEL_CH9:4;              /* Channel Watchdog select for channel 9. */
    vuint32_t WSEL_CH8:4;              /* Channel Watchdog select for channel 8. */
  } B;
} ADC_CWSELR1_tag;

typedef union ADC_CWSELR4_union_tag {  /* Channel Watchdog Select Register 4 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH39:4;             /* Channel Watchdog select for channel 39. */
    vuint32_t WSEL_CH38:4;             /* Channel Watchdog select for channel 38. */
    vuint32_t WSEL_CH37:4;             /* Channel Watchdog select for channel 37. */
    vuint32_t WSEL_CH36:4;             /* Channel Watchdog select for channel 36. */
    vuint32_t WSEL_CH35:4;             /* Channel Watchdog select for channel 35. */
    vuint32_t WSEL_CH34:4;             /* Channel Watchdog select for channel 34. */
    vuint32_t WSEL_CH33:4;             /* Channel Watchdog select for channel 33. */
    vuint32_t WSEL_CH32:4;             /* Channel Watchdog select for channel 32. */
  } B;
} ADC_CWSELR4_tag;

typedef union ADC_CWSELR5_union_tag {  /* Channel Watchdog Select Register 5 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH47:4;             /* Channel Watchdog select for channel 47. */
    vuint32_t WSEL_CH46:4;             /* Channel Watchdog select for channel 46. */
    vuint32_t WSEL_CH45:4;             /* Channel Watchdog select for channel 45. */
    vuint32_t WSEL_CH44:4;             /* Channel Watchdog select for channel 44. */
    vuint32_t WSEL_CH43:4;             /* Channel Watchdog select for channel 43. */
    vuint32_t WSEL_CH42:4;             /* Channel Watchdog select for channel 42. */
    vuint32_t WSEL_CH41:4;             /* Channel Watchdog select for channel 41. */
    vuint32_t WSEL_CH40:4;             /* Channel Watchdog select for channel 40. */
  } B;
} ADC_CWSELR5_tag;

typedef union ADC_CWSELR6_union_tag {  /* Channel Watchdog Select Register 6 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH55:4;             /* Channel Watchdog select for channel 55. */
    vuint32_t WSEL_CH54:4;             /* Channel Watchdog select for channel 54. */
    vuint32_t WSEL_CH53:4;             /* Channel Watchdog select for channel 53. */
    vuint32_t WSEL_CH52:4;             /* Channel Watchdog select for channel 52. */
    vuint32_t WSEL_CH51:4;             /* Channel Watchdog select for channel 51. */
    vuint32_t WSEL_CH50:4;             /* Channel Watchdog select for channel 50. */
    vuint32_t WSEL_CH49:4;             /* Channel Watchdog select for channel 49. */
    vuint32_t WSEL_CH48:4;             /* Channel Watchdog select for channel 48. */
  } B;
} ADC_CWSELR6_tag;

typedef union ADC_CWSELR7_union_tag {  /* Channel Watchdog Select Register 7 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH63:4;             /* Channel Watchdog select for channel 63. */
    vuint32_t WSEL_CH62:4;             /* Channel Watchdog select for channel 62. */
    vuint32_t WSEL_CH61:4;             /* Channel Watchdog select for channel 61. */
    vuint32_t WSEL_CH60:4;             /* Channel Watchdog select for channel 60. */
    vuint32_t WSEL_CH59:4;             /* Channel Watchdog select for channel 59. */
    vuint32_t WSEL_CH58:4;             /* Channel Watchdog select for channel 58. */
    vuint32_t WSEL_CH57:4;             /* Channel Watchdog select for channel 57. */
    vuint32_t WSEL_CH56:4;             /* Channel Watchdog select for channel 56. */
  } B;
} ADC_CWSELR7_tag;

typedef union ADC_CWSELR8_union_tag {  /* Channel Watchdog Select Register 8 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH71:4;             /* Channel Watchdog select for channel 71. */
    vuint32_t WSEL_CH70:4;             /* Channel Watchdog select for channel 70. */
    vuint32_t WSEL_CH69:4;             /* Channel Watchdog select for channel 69. */
    vuint32_t WSEL_CH68:4;             /* Channel Watchdog select for channel 68. */
    vuint32_t WSEL_CH67:4;             /* Channel Watchdog select for channel 67. */
    vuint32_t WSEL_CH66:4;             /* Channel Watchdog select for channel 66. */
    vuint32_t WSEL_CH65:4;             /* Channel Watchdog select for channel 65. */
    vuint32_t WSEL_CH64:4;             /* Channel Watchdog select for channel 64. */
  } B;
} ADC_CWSELR8_tag;

typedef union ADC_CWSELR9_union_tag {  /* Channel Watchdog Select Register 9 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH79:4;             /* Channel Watchdog select for channel 79. */
    vuint32_t WSEL_CH78:4;             /* Channel Watchdog select for channel 78. */
    vuint32_t WSEL_CH77:4;             /* Channel Watchdog select for channel 77. */
    vuint32_t WSEL_CH76:4;             /* Channel Watchdog select for channel 76. */
    vuint32_t WSEL_CH75:4;             /* Channel Watchdog select for channel 75. */
    vuint32_t WSEL_CH74:4;             /* Channel Watchdog select for channel 74. */
    vuint32_t WSEL_CH73:4;             /* Channel Watchdog select for channel 73. */
    vuint32_t WSEL_CH72:4;             /* Channel Watchdog select for channel 72. */
  } B;
} ADC_CWSELR9_tag;

typedef union ADC_CWSELR10_union_tag { /* Channel Watchdog Select Register 10 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH87:4;             /* Channel Watchdog select for channel 87. */
    vuint32_t WSEL_CH86:4;             /* Channel Watchdog select for channel 86. */
    vuint32_t WSEL_CH85:4;             /* Channel Watchdog select for channel 85. */
    vuint32_t WSEL_CH84:4;             /* Channel Watchdog select for channel 84. */
    vuint32_t WSEL_CH83:4;             /* Channel Watchdog select for channel 83. */
    vuint32_t WSEL_CH82:4;             /* Channel Watchdog select for channel 82. */
    vuint32_t WSEL_CH81:4;             /* Channel Watchdog select for channel 81. */
    vuint32_t WSEL_CH80:4;             /* Channel Watchdog select for channel 80. */
  } B;
} ADC_CWSELR10_tag;

typedef union ADC_CWSELR11_union_tag { /* Channel Watchdog Select Register 11 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH95:4;             /* Channel Watchdog select for channel 95. */
    vuint32_t WSEL_CH94:4;             /* Channel Watchdog select for channel 94. */
    vuint32_t WSEL_CH93:4;             /* Channel Watchdog select for channel 93. */
    vuint32_t WSEL_CH92:4;             /* Channel Watchdog select for channel 92. */
    vuint32_t WSEL_CH91:4;             /* Channel Watchdog select for channel 91. */
    vuint32_t WSEL_CH90:4;             /* Channel Watchdog select for channel 90. */
    vuint32_t WSEL_CH89:4;             /* Channel Watchdog select for channel 89. */
    vuint32_t WSEL_CH88:4;             /* Channel Watchdog select for channel 88. */
  } B;
} ADC_CWSELR11_tag;

typedef union ADC_CWENR0_union_tag {   /* Channel Watchdog Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CWEN15:1;                /* Watchdog enable for channel 15. */
    vuint32_t CWEN14:1;                /* Watchdog enable for channel 14. */
    vuint32_t CWEN13:1;                /* Watchdog enable for channel 13. */
    vuint32_t CWEN12:1;                /* Watchdog enable for channel 12. */
    vuint32_t CWEN11:1;                /* Watchdog enable for channel 11. */
    vuint32_t CWEN10:1;                /* Watchdog enable for channel 10. */
    vuint32_t CWEN9:1;                 /* Watchdog enable for channel 9. */
    vuint32_t CWEN8:1;                 /* Watchdog enable for channel 8. */
    vuint32_t CWEN7:1;                 /* Watchdog enable for channel 7. */
    vuint32_t CWEN6:1;                 /* Watchdog enable for channel 6. */
    vuint32_t CWEN5:1;                 /* Watchdog enable for channel 5. */
    vuint32_t CWEN4:1;                 /* Watchdog enable for channel 4. */
    vuint32_t CWEN3:1;                 /* Watchdog enable for channel 3. */
    vuint32_t CWEN2:1;                 /* Watchdog enable for channel 2. */
    vuint32_t CWEN1:1;                 /* Watchdog enable for channel 1. */
    vuint32_t CWEN0:1;                 /* Watchdog enable for channel 0. */
  } B;
} ADC_CWENR0_tag;

typedef union ADC_CWENR1_union_tag {   /* Channel Watchdog Enable Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CWEN63:1;                /* Watchdog enable for channel 63. */
    vuint32_t CWEN62:1;                /* Watchdog enable for channel 62. */
    vuint32_t CWEN61:1;                /* Watchdog enable for channel 61. */
    vuint32_t CWEN60:1;                /* Watchdog enable for channel 60. */
    vuint32_t CWEN59:1;                /* Watchdog enable for channel 59. */
    vuint32_t CWEN58:1;                /* Watchdog enable for channel 58. */
    vuint32_t CWEN57:1;                /* Watchdog enable for channel 57. */
    vuint32_t CWEN56:1;                /* Watchdog enable for channel 56. */
    vuint32_t CWEN55:1;                /* Watchdog enable for channel 55. */
    vuint32_t CWEN54:1;                /* Watchdog enable for channel 54. */
    vuint32_t CWEN53:1;                /* Watchdog enable for channel 53. */
    vuint32_t CWEN52:1;                /* Watchdog enable for channel 52. */
    vuint32_t CWEN51:1;                /* Watchdog enable for channel 51. */
    vuint32_t CWEN50:1;                /* Watchdog enable for channel 50. */
    vuint32_t CWEN49:1;                /* Watchdog enable for channel 49. */
    vuint32_t CWEN48:1;                /* Watchdog enable for channel 48. */
    vuint32_t CWEN47:1;                /* Watchdog enable for channel 47. */
    vuint32_t CWEN46:1;                /* Watchdog enable for channel 46. */
    vuint32_t CWEN45:1;                /* Watchdog enable for channel 45. */
    vuint32_t CWEN44:1;                /* Watchdog enable for channel 44. */
    vuint32_t CWEN43:1;                /* Watchdog enable for channel 43. */
    vuint32_t CWEN42:1;                /* Watchdog enable for channel 42. */
    vuint32_t CWEN41:1;                /* Watchdog enable for channel 41. */
    vuint32_t CWEN40:1;                /* Watchdog enable for channel 40. */
    vuint32_t CWEN39:1;                /* Watchdog enable for channel 39. */
    vuint32_t CWEN38:1;                /* Watchdog enable for channel 38. */
    vuint32_t CWEN37:1;                /* Watchdog enable for channel 37. */
    vuint32_t CWEN36:1;                /* Watchdog enable for channel 36. */
    vuint32_t CWEN35:1;                /* Watchdog enable for channel 35. */
    vuint32_t CWEN34:1;                /* Watchdog enable for channel 34. */
    vuint32_t CWEN33:1;                /* Watchdog enable for channel 33. */
    vuint32_t CWEN32:1;                /* Watchdog enable for channel 32. */
  } B;
} ADC_CWENR1_tag;

typedef union ADC_CWENR2_union_tag {   /* Channel Watchdog Enable Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CWEN95:1;                /* Watchdog enable for channel 95. */
    vuint32_t CWEN94:1;                /* Watchdog enable for channel 94. */
    vuint32_t CWEN93:1;                /* Watchdog enable for channel 93. */
    vuint32_t CWEN92:1;                /* Watchdog enable for channel 92. */
    vuint32_t CWEN91:1;                /* Watchdog enable for channel 91. */
    vuint32_t CWEN90:1;                /* Watchdog enable for channel 90. */
    vuint32_t CWEN89:1;                /* Watchdog enable for channel 89. */
    vuint32_t CWEN88:1;                /* Watchdog enable for channel 88. */
    vuint32_t CWEN87:1;                /* Watchdog enable for channel 87. */
    vuint32_t CWEN86:1;                /* Watchdog enable for channel 86. */
    vuint32_t CWEN85:1;                /* Watchdog enable for channel 85. */
    vuint32_t CWEN84:1;                /* Watchdog enable for channel 84. */
    vuint32_t CWEN83:1;                /* Watchdog enable for channel 83. */
    vuint32_t CWEN82:1;                /* Watchdog enable for channel 82. */
    vuint32_t CWEN81:1;                /* Watchdog enable for channel 81. */
    vuint32_t CWEN80:1;                /* Watchdog enable for channel 80. */
    vuint32_t CWEN79:1;                /* Watchdog enable for channel 79. */
    vuint32_t CWEN78:1;                /* Watchdog enable for channel 78. */
    vuint32_t CWEN77:1;                /* Watchdog enable for channel 77. */
    vuint32_t CWEN76:1;                /* Watchdog enable for channel 76. */
    vuint32_t CWEN75:1;                /* Watchdog enable for channel 75. */
    vuint32_t CWEN74:1;                /* Watchdog enable for channel 74. */
    vuint32_t CWEN73:1;                /* Watchdog enable for channel 73. */
    vuint32_t CWEN72:1;                /* Watchdog enable for channel 72. */
    vuint32_t CWEN71:1;                /* Watchdog enable for channel 71. */
    vuint32_t CWEN70:1;                /* Watchdog enable for channel 70. */
    vuint32_t CWEN69:1;                /* Watchdog enable for channel 69. */
    vuint32_t CWEN68:1;                /* Watchdog enable for channel 68. */
    vuint32_t CWEN67:1;                /* Watchdog enable for channel 67. */
    vuint32_t CWEN66:1;                /* Watchdog enable for channel 66. */
    vuint32_t CWEN65:1;                /* Watchdog enable for channel 65. */
    vuint32_t CWEN64:1;                /* Watchdog enable for channel 64. */
  } B;
} ADC_CWENR2_tag;

typedef union ADC_AWORR0_union_tag {   /* Analog Watchdog Out of Range Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t AWOR_CH15:1;             /* Analog watchdog out of range for channel 15. */
    vuint32_t AWOR_CH14:1;             /* Analog watchdog out of range for channel 14. */
    vuint32_t AWOR_CH13:1;             /* Analog watchdog out of range for channel 13. */
    vuint32_t AWOR_CH12:1;             /* Analog watchdog out of range for channel 12. */
    vuint32_t AWOR_CH11:1;             /* Analog watchdog out of range for channel 11. */
    vuint32_t AWOR_CH10:1;             /* Analog watchdog out of range for channel 10. */
    vuint32_t AWOR_CH9:1;              /* Analog watchdog out of range for channel 9. */
    vuint32_t AWOR_CH8:1;              /* Analog watchdog out of range for channel 8. */
    vuint32_t AWOR_CH7:1;              /* Analog watchdog out of range for channel 7. */
    vuint32_t AWOR_CH6:1;              /* Analog watchdog out of range for channel 6. */
    vuint32_t AWOR_CH5:1;              /* Analog watchdog out of range for channel 5. */
    vuint32_t AWOR_CH4:1;              /* Analog watchdog out of range for channel 4. */
    vuint32_t AWOR_CH3:1;              /* Analog watchdog out of range for channel 3. */
    vuint32_t AWOR_CH2:1;              /* Analog watchdog out of range for channel 2. */
    vuint32_t AWOR_CH1:1;              /* Analog watchdog out of range for channel 1. */
    vuint32_t AWOR_CH0:1;              /* Analog watchdog out of range for channel 0. */
  } B;
} ADC_AWORR0_tag;

typedef union ADC_AWORR1_union_tag {   /* Analog Watchdog Out of Range Register 1 */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH63:1;             /* Analog watchdog out of range for channel 63. */
    vuint32_t AWOR_CH62:1;             /* Analog watchdog out of range for channel 62. */
    vuint32_t AWOR_CH61:1;             /* Analog watchdog out of range for channel 61. */
    vuint32_t AWOR_CH60:1;             /* Analog watchdog out of range for channel 60. */
    vuint32_t AWOR_CH59:1;             /* Analog watchdog out of range for channel 59. */
    vuint32_t AWOR_CH58:1;             /* Analog watchdog out of range for channel 58. */
    vuint32_t AWOR_CH57:1;             /* Analog watchdog out of range for channel 57. */
    vuint32_t AWOR_CH56:1;             /* Analog watchdog out of range for channel 56. */
    vuint32_t AWOR_CH55:1;             /* Analog watchdog out of range for channel 55. */
    vuint32_t AWOR_CH54:1;             /* Analog watchdog out of range for channel 54. */
    vuint32_t AWOR_CH53:1;             /* Analog watchdog out of range for channel 53. */
    vuint32_t AWOR_CH52:1;             /* Analog watchdog out of range for channel 52. */
    vuint32_t AWOR_CH51:1;             /* Analog watchdog out of range for channel 51. */
    vuint32_t AWOR_CH50:1;             /* Analog watchdog out of range for channel 50. */
    vuint32_t AWOR_CH49:1;             /* Analog watchdog out of range for channel 49. */
    vuint32_t AWOR_CH48:1;             /* Analog watchdog out of range for channel 48. */
    vuint32_t AWOR_CH47:1;             /* Analog watchdog out of range for channel 47. */
    vuint32_t AWOR_CH46:1;             /* Analog watchdog out of range for channel 46. */
    vuint32_t AWOR_CH45:1;             /* Analog watchdog out of range for channel 45. */
    vuint32_t AWOR_CH44:1;             /* Analog watchdog out of range for channel 44. */
    vuint32_t AWOR_CH43:1;             /* Analog watchdog out of range for channel 43. */
    vuint32_t AWOR_CH42:1;             /* Analog watchdog out of range for channel 42. */
    vuint32_t AWOR_CH41:1;             /* Analog watchdog out of range for channel 41. */
    vuint32_t AWOR_CH40:1;             /* Analog watchdog out of range for channel 40. */
    vuint32_t AWOR_CH39:1;             /* Analog watchdog out of range for channel 39. */
    vuint32_t AWOR_CH38:1;             /* Analog watchdog out of range for channel 38. */
    vuint32_t AWOR_CH37:1;             /* Analog watchdog out of range for channel 37. */
    vuint32_t AWOR_CH36:1;             /* Analog watchdog out of range for channel 36. */
    vuint32_t AWOR_CH35:1;             /* Analog watchdog out of range for channel 35. */
    vuint32_t AWOR_CH34:1;             /* Analog watchdog out of range for channel 34. */
    vuint32_t AWOR_CH33:1;             /* Analog watchdog out of range for channel 33. */
    vuint32_t AWOR_CH32:1;             /* Analog watchdog out of range for channel 32. */
  } B;
} ADC_AWORR1_tag;

typedef union ADC_AWORR2_union_tag {   /* Analog Watchdog Out of Range Register 2 */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH95:1;             /* Analog watchdog out of range for channel 95. */
    vuint32_t AWOR_CH94:1;             /* Analog watchdog out of range for channel 94. */
    vuint32_t AWOR_CH93:1;             /* Analog watchdog out of range for channel 93. */
    vuint32_t AWOR_CH92:1;             /* Analog watchdog out of range for channel 92. */
    vuint32_t AWOR_CH91:1;             /* Analog watchdog out of range for channel 91. */
    vuint32_t AWOR_CH90:1;             /* Analog watchdog out of range for channel 90. */
    vuint32_t AWOR_CH89:1;             /* Analog watchdog out of range for channel 89. */
    vuint32_t AWOR_CH88:1;             /* Analog watchdog out of range for channel 88. */
    vuint32_t AWOR_CH87:1;             /* Analog watchdog out of range for channel 87. */
    vuint32_t AWOR_CH86:1;             /* Analog watchdog out of range for channel 86. */
    vuint32_t AWOR_CH85:1;             /* Analog watchdog out of range for channel 85. */
    vuint32_t AWOR_CH84:1;             /* Analog watchdog out of range for channel 84. */
    vuint32_t AWOR_CH83:1;             /* Analog watchdog out of range for channel 83. */
    vuint32_t AWOR_CH82:1;             /* Analog watchdog out of range for channel 82. */
    vuint32_t AWOR_CH81:1;             /* Analog watchdog out of range for channel 81. */
    vuint32_t AWOR_CH80:1;             /* Analog watchdog out of range for channel 80. */
    vuint32_t AWOR_CH79:1;             /* Analog watchdog out of range for channel 79. */
    vuint32_t AWOR_CH78:1;             /* Analog watchdog out of range for channel 78. */
    vuint32_t AWOR_CH77:1;             /* Analog watchdog out of range for channel 77. */
    vuint32_t AWOR_CH76:1;             /* Analog watchdog out of range for channel 76. */
    vuint32_t AWOR_CH75:1;             /* Analog watchdog out of range for channel 75. */
    vuint32_t AWOR_CH74:1;             /* Analog watchdog out of range for channel 74. */
    vuint32_t AWOR_CH73:1;             /* Analog watchdog out of range for channel 73. */
    vuint32_t AWOR_CH72:1;             /* Analog watchdog out of range for channel 72. */
    vuint32_t AWOR_CH71:1;             /* Analog watchdog out of range for channel 71. */
    vuint32_t AWOR_CH70:1;             /* Analog watchdog out of range for channel 70. */
    vuint32_t AWOR_CH69:1;             /* Analog watchdog out of range for channel 69. */
    vuint32_t AWOR_CH68:1;             /* Analog watchdog out of range for channel 68. */
    vuint32_t AWOR_CH67:1;             /* Analog watchdog out of range for channel 67. */
    vuint32_t AWOR_CH66:1;             /* Analog watchdog out of range for channel 66. */
    vuint32_t AWOR_CH65:1;             /* Analog watchdog out of range for channel 65. */
    vuint32_t AWOR_CH64:1;             /* Analog watchdog out of range for channel 64. */
  } B;
} ADC_AWORR2_tag;

typedef union ADC_CALBISTREG_union_tag { /* Calibration, BIST Control and status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_29:2;
    vuint32_t TSAMP:2;                 /* Test Sample period in Calibration, BIST and Offset calculation process. */
    vuint32_t _unused_24:3;
    vuint32_t _unused_16:8;
    vuint32_t C_T_BUSY:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_7:1;
    vuint32_t NR_SMPL:2;               /* Number of Samples for averaging. */
    vuint32_t AVG_EN:1;                /* Average Enable (for Calibration only). */
    vuint32_t TEST_FAIL:1;             /* Test Fail. */
    vuint32_t _unused_1:2;
    vuint32_t TEST_EN:1;               /* Enable the test. */
  } B;
} ADC_CALBISTREG_tag;

typedef union ADC_OFSGNUSR_union_tag { /* Offset and Gain User Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t GAIN_USER:10;
    vuint32_t _unused_8:8;
    vuint32_t OFFSET_USER:8;
  } B;
} ADC_OFSGNUSR_tag;

struct ADC_tag {
  ADC_MCR_tag MCR;                     /* Main Configuration Register */
  ADC_MSR_tag MSR;                     /* Main Status register */
  uint8_t ADC_reserved0[8];
  ADC_ISR_tag ISR;                     /* Interrupt Status Register */
  ADC_CEOCFR0_tag CEOCFR0;             /* Channel Pending register 0 */
  ADC_CEOCFR1_tag CEOCFR1;             /* Channel Pending register 1 */
  ADC_CEOCFR2_tag CEOCFR2;             /* Channel Pending register 2 */
  ADC_IMR_tag IMR;                     /* Interrupt Mask Register */
  ADC_CIMR0_tag CIMR0;                 /* Channel Interrupt Mask Register 0 */
  ADC_CIMR1_tag CIMR1;                 /* Channel Interrupt Mask Register 1 */
  ADC_CIMR2_tag CIMR2;                 /* Channel Interrupt Mask Register 2 */
  ADC_WTISR_tag WTISR;                 /* Watchdog Threshold Interrupt Status Register */
  ADC_WTIMR_tag WTIMR;                 /* Watchdog Threshold Interrupt Mask Register */
  uint8_t ADC_reserved1[8];
  ADC_DMAE_tag DMAE;                   /* DMA Enable register */
  ADC_DMAR0_tag DMAR0;                 /* DMA Channel Select Register 0 */
  ADC_DMAR1_tag DMAR1;                 /* DMA Channel Select Register 1 */
  ADC_DMAR2_tag DMAR2;                 /* DMA Channel Select Register 2 */
  uint8_t ADC_reserved2[16];
  ADC_THRHLR0_tag THRHLR0;             /* Threshold Register */
  ADC_THRHLR1_tag THRHLR1;             /* Threshold Register */
  ADC_THRHLR2_tag THRHLR2;             /* Threshold Register */
  ADC_THRHLR3_tag THRHLR3;             /* Threshold Register */
  uint8_t ADC_reserved3[16];
  ADC_PSCR_tag PSCR;                   /* Presampling Control Register */
  ADC_PSR0_tag PSR0;                   /* Presampling register 0 */
  ADC_PSR1_tag PSR1;                   /* Presampling register 1 */
  ADC_PSR2_tag PSR2;                   /* Presampling register 2 */
  uint8_t ADC_reserved4[4];
  ADC_CTR0_tag CTR0;                   /* Conversion Timing Register 0 */
  ADC_CTR1_tag CTR1;                   /* Conversion Timing Register 1 */
  ADC_CTR2_tag CTR2;                   /* Conversion Timing Register 2 */
  uint8_t ADC_reserved5[4];
  ADC_NCMR0_tag NCMR0;                 /* Normal Conversion Mask Register 0 */
  ADC_NCMR1_tag NCMR1;                 /* Normal Conversion Mask Register 1 */
  ADC_NCMR2_tag NCMR2;                 /* Normal Conversion Mask Register 2 */
  uint8_t ADC_reserved6[4];
  ADC_JCMR0_tag JCMR0;                 /* Injected Conversion Mask Register 0 */
  ADC_JCMR1_tag JCMR1;                 /* Injected Conversion Mask Register 1 */
  ADC_JCMR2_tag JCMR2;                 /* Injected Conversion Mask Register 2 */
  uint8_t ADC_reserved7[4];
  ADC_DSDR_tag DSDR;                   /* Decode Signals Delay Register */
  ADC_PDEDR_tag PDEDR;                 /* Power Down Exit Delay Register */
  uint8_t ADC_reserved8[52];
  ADC_CDR_tag CDR[96];                 /* Channel Data Register n (Precision Channels) */
  ADC_THRHLR4_tag THRHLR4;             /* Threshold Register */
  ADC_THRHLR5_tag THRHLR5;             /* Threshold Register */
  uint8_t ADC_reserved9[40];
  ADC_CWSELR0_tag CWSELR0;             /* Channel Watchdog Select Register 0 */
  ADC_CWSELR1_tag CWSELR1;             /* Channel Watchdog Select Register 1 */
  uint8_t ADC_reserved10[8];
  ADC_CWSELR4_tag CWSELR4;             /* Channel Watchdog Select Register 4 */
  ADC_CWSELR5_tag CWSELR5;             /* Channel Watchdog Select Register 5 */
  ADC_CWSELR6_tag CWSELR6;             /* Channel Watchdog Select Register 6 */
  ADC_CWSELR7_tag CWSELR7;             /* Channel Watchdog Select Register 7 */
  ADC_CWSELR8_tag CWSELR8;             /* Channel Watchdog Select Register 8 */
  ADC_CWSELR9_tag CWSELR9;             /* Channel Watchdog Select Register 9 */
  ADC_CWSELR10_tag CWSELR10;           /* Channel Watchdog Select Register 10 */
  ADC_CWSELR11_tag CWSELR11;           /* Channel Watchdog Select Register 11 */
  ADC_CWENR0_tag CWENR0;               /* Channel Watchdog Enable Register 0 */
  ADC_CWENR1_tag CWENR1;               /* Channel Watchdog Enable Register 1 */
  ADC_CWENR2_tag CWENR2;               /* Channel Watchdog Enable Register 2 */
  uint8_t ADC_reserved11[4];
  ADC_AWORR0_tag AWORR0;               /* Analog Watchdog Out of Range Register 0 */
  ADC_AWORR1_tag AWORR1;               /* Analog Watchdog Out of Range Register 1 */
  ADC_AWORR2_tag AWORR2;               /* Analog Watchdog Out of Range Register 2 */
  uint8_t ADC_reserved12[164];
  ADC_CALBISTREG_tag CALBISTREG;       /* Calibration, BIST Control and status Register */
  uint8_t ADC_reserved13[4];
  ADC_OFSGNUSR_tag OFSGNUSR;           /* Offset and Gain User Register */
};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

typedef union AIPS_MPRA_union_tag {    /* Master Privilege Register A */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MTR0:1;                  /* Master 0 Trusted For Read */
    vuint32_t MTW0:1;                  /* Master 0 Trusted For Writes */
    vuint32_t MPL0:1;                  /* Master 0 Privilege Level */
    vuint32_t _unused_27:1;
    vuint32_t MTR1:1;                  /* Master 1 trusted for read */
    vuint32_t MTW1:1;                  /* Master 1 trusted for writes */
    vuint32_t MPL1:1;                  /* Master 1 privilege level */
    vuint32_t _unused_23:1;
    vuint32_t MTR2:1;                  /* Master 2 Trusted For Read */
    vuint32_t MTW2:1;                  /* Master 2 Trusted For Writes */
    vuint32_t MPL2:1;                  /* Master 2 Privilege Level */
    vuint32_t _unused_19:1;
    vuint32_t MTR3:1;                  /* Master 3 Trusted For Read */
    vuint32_t MTW3:1;                  /* Master 3 Trusted For Writes */
    vuint32_t MPL3:1;                  /* Master 3 Privilege Level */
    vuint32_t _unused_15:1;
    vuint32_t MTR4:1;                  /* Master 4 Trusted For Read */
    vuint32_t MTW4:1;                  /* Master 4 Trusted For Writes */
    vuint32_t MPL4:1;                  /* Master 4 Privilege Level */
    vuint32_t _unused_8:4;
    vuint32_t _unused_4:4;
    vuint32_t _unused_0:4;
  } B;
} AIPS_MPRA_tag;

typedef union AIPS_MPRB_union_tag {    /* Master Privilege Register B */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MTR8:1;                  /* Master 8 trusted for read */
    vuint32_t MTW8:1;                  /* Master 8 trusted for writes */
    vuint32_t MPL8:1;                  /* Master 8 privilege level */
    vuint32_t _unused_27:1;
    vuint32_t MTR9:1;                  /* Master 9 trusted for read */
    vuint32_t MTW9:1;                  /* Master 9 trusted for writes */
    vuint32_t MPL9:1;                  /* Master 9 privilege level */
    vuint32_t _unused_23:1;
    vuint32_t MTR10:1;                 /* Master 10 trusted for read */
    vuint32_t MTW10:1;                 /* Master 10 trusted for writes */
    vuint32_t MPL10:1;                 /* Master 10 privilege level */
    vuint32_t _unused_19:1;
    vuint32_t _unused_16:3;
    vuint32_t _unused_15:1;
    vuint32_t _unused_12:3;
    vuint32_t _unused_11:1;
    vuint32_t _unused_8:3;
    vuint32_t _unused_7:1;
    vuint32_t _unused_4:3;
    vuint32_t _unused_3:1;
    vuint32_t _unused_0:3;
  } B;
} AIPS_MPRB_tag;

typedef union AIPS_PACR_union_tag {    /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACR_tag;

typedef union AIPS_OPACR_union_tag {   /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACR_tag;

struct AIPS_tag {
  AIPS_MPRA_tag MPRA;                  /* Master Privilege Register A */
  AIPS_MPRB_tag MPRB;                  /* Master Privilege Register B */
  uint8_t AIPS_reserved0[248];
  AIPS_PACR_tag PACR[8];               /* Peripheral Access Control Register */
  uint8_t AIPS_reserved1[32];
  AIPS_OPACR_tag OPACR[32];            /* Off-Platform Peripheral Access Control Register */
};


/* ============================================================================
   =============================== Module: AXBS ===============================
   ============================================================================ */

typedef union AXBS_PORT_PRS_union_tag { /* Priority Registers Slave */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t M7:3;                    /* Master 7 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_27:1;
    vuint32_t M6:3;                    /* Master 6 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_23:1;
    vuint32_t M5:3;                    /* Master 5 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_19:1;
    vuint32_t M4:3;                    /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_15:1;
    vuint32_t M3:3;                    /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
  } B;
} AXBS_PORT_PRS_tag;

typedef union AXBS_PORT_CRS_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t RO:1;                    /* Read Only */
    vuint32_t _unused_30:1;
    vuint32_t _unused_24:6;
    vuint32_t HPE7:1;
    vuint32_t HPE6:1;
    vuint32_t HPE5:1;
    vuint32_t HPE4:1;
    vuint32_t HPE3:1;
    vuint32_t HPE2:1;
    vuint32_t HPE1:1;
    vuint32_t HPE0:1;
    vuint32_t _unused_10:6;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} AXBS_PORT_CRS_tag;

typedef struct AXBS_PORT_struct_tag {
  AXBS_PORT_PRS_tag PRS;               /* Priority Registers Slave */
  uint8_t PORT_reserved0[12];
  AXBS_PORT_CRS_tag CRS;               /* Control Register */
  uint8_t PORT_reserved1[236];
} AXBS_PORT_tag;

typedef union AXBS_MGPCR_MGPCR_union_tag { /* Master General Purpose Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t AULB:3;                  /* Arbitrates On Undefined Length Bursts */
  } B;
} AXBS_MGPCR_MGPCR_tag;

typedef struct AXBS_MGPCR_struct_tag {
  AXBS_MGPCR_MGPCR_tag MGPCR;          /* Master General Purpose Control Register */
  uint8_t MGPCR_reserved0[252];
} AXBS_MGPCR_tag;

struct AXBS_tag {
  AXBS_PORT_tag PORT[8];
  AXBS_MGPCR_tag MGPCR[8];
};


/* ============================================================================
   =============================== Module: BCTU ===============================
   ============================================================================ */

typedef union BCTU_MCR_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze mode - for debug operation. */
    vuint32_t _unused_27:2;
    vuint32_t GTRGEN:1;                /* Global Trigger Enable. */
    vuint32_t _unused_20:6;
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t _unused_18:1;
    vuint32_t DMA1:1;                  /* ADC1DR data transferring by DMA. */
    vuint32_t DMA0:1;                  /* ADC0DR data transferring by DMA. */
    vuint32_t _unused_8:8;
    vuint32_t TRGEN:1;                 /* Trigger interrupt request enable. */
    vuint32_t _unused_6:1;
    vuint32_t LIST_IEN:1;              /* LIST interrupt enable. */
    vuint32_t _unused_4:1;
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t IEN1:1;                  /* Interrupt enable bit for ADC1DR new data. */
    vuint32_t IEN0:1;                  /* Interrupt enable bit for ADC0DR new data. */
  } B;
} BCTU_MCR_tag;

typedef union BCTU_MSR_union_tag {     /* Module Status register */
  vuint32_t R;
  struct {
    vuint32_t TRGF_CLR:1;              /* TRGF clear */
    vuint32_t _unused_28:3;
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t _unused_26:1;            /* Reserved. */
    vuint32_t LIST1_Last_CLR:1;
    vuint32_t LIST0_Last_CLR:1;
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t _unused_22:1;            /* Reserved. */
    vuint32_t DATAOVR1_CLR:1;          /* Clears DATAOVR1 flag */
    vuint32_t DATAOVR0_CLR:1;          /* Clears DATAOVR0 flag */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t _unused_18:1;            /* Reserved. */
    vuint32_t NDATA1_CLR:1;            /* Clears NDATA1 flag */
    vuint32_t NDATA0_CLR:1;            /* Clears NDATA0 flag */
    vuint32_t TRGF:1;                  /* Trigger Flag */
    vuint32_t _unused_12:3;
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t _unused_10:1;            /* Reserved. */
    vuint32_t LIST1_Last:1;
    vuint32_t LIST0_Last:1;
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t _unused_6:1;             /* Reserved. */
    vuint32_t DATAOVR1:1;
    vuint32_t DATAOVR0:1;
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t NDATA1:1;
    vuint32_t NDATA0:1;
  } B;
} BCTU_MSR_tag;

typedef union BCTU_TRGCFG_union_tag {  /* Trigger Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t LOOP:1;                  /* LOOP bit */
    vuint32_t _unused_24:7;
    vuint32_t _unused_16:8;            /* Reserved. */
    vuint32_t TRIGEN:1;                /* Trigger enable */
    vuint32_t TRG_FLAG:1;
    vuint32_t TRS:1;                   /* Trigger resolution */
    vuint32_t _unused_12:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_10:1;
    vuint32_t ADC_SEL1:1;
    vuint32_t ADC_SEL0:1;
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t CHANNEL_VALUE_OR_LADDR:7; /* Channel Value or List Address Value. */
  } B;
} BCTU_TRGCFG_tag;

typedef union BCTU_WRPROT_union_tag {  /* Write Protection register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t PROTEC_CODE:4;           /* The Protection code sets protection for the write protected registers */
  } B;
} BCTU_WRPROT_tag;

typedef union BCTU_SFTRGR1_union_tag { /* Software Trigger register 1 */
  vuint32_t R;
  struct {
    vuint32_t SFTRG31:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG30:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG29:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG28:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG27:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG26:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG25:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG24:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG23:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG22:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG21:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG20:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG19:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG18:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG17:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG16:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG15:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG14:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG13:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG12:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG11:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG10:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG9:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG8:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG7:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG6:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG5:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG4:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG3:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG2:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG1:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG0:1;                /* Software trigger to start an ADC conversion. */
  } B;
} BCTU_SFTRGR1_tag;

typedef union BCTU_SFTRGR2_union_tag { /* Software Trigger register 1 */
  vuint32_t R;
  struct {
    vuint32_t SFTRG63:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG62:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG61:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG60:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG59:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG58:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG57:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG56:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG55:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG54:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG53:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG52:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG51:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG50:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG49:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG48:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG47:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG46:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG45:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG44:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG43:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG42:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG41:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG40:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG39:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG38:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG37:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG36:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG35:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG34:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG33:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG32:1;               /* Software trigger to start an ADC conversion. */
  } B;
} BCTU_SFTRGR2_tag;

typedef union BCTU_SFTRGR3_union_tag { /* Software Trigger register 1 */
  vuint32_t R;
  struct {
    vuint32_t SFTRG95:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG94:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG93:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG92:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG91:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG90:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG89:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG88:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG87:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG86:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG85:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG84:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG83:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG82:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG81:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG80:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG79:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG78:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG77:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG76:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG75:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG74:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG73:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG72:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG71:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG70:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG69:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG68:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG67:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG66:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG65:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG64:1;               /* Software trigger to start an ADC conversion. */
  } B;
} BCTU_SFTRGR3_tag;

typedef union BCTU_ADC0DR_union_tag {  /* ADC0 Result Data register */
  vuint32_t R;
  struct {
    vuint32_t TRG_SRC:8;
    vuint32_t CH:8;
    vuint32_t LIST:1;
    vuint32_t LAST:1;
    vuint32_t _unused_12:2;
    vuint32_t ADC_DATA:12;
  } B;
} BCTU_ADC0DR_tag;

typedef union BCTU_ADC1DR_union_tag {  /* ADC1 result data register */
  vuint32_t R;
  struct {
    vuint32_t TRG_SRC:8;
    vuint32_t CH:8;
    vuint32_t LIST:1;
    vuint32_t LAST:1;
    vuint32_t _unused_12:2;
    vuint32_t ADC_DATA:12;
  } B;
} BCTU_ADC1DR_tag;

typedef union BCTU_LISTSTAR_union_tag { /* LIST Size Status register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;            /* Reserved. */
    vuint32_t LISTSZ:8;                /* Size of the LIST in number of elements. */
  } B;
} BCTU_LISTSTAR_tag;

typedef union BCTU_LISTCHR_union_tag { /* LIST Channel Address Register */
  vuint32_t R;
  struct {
    vuint32_t LAST_y:1;                /* Last channel in the list of channels. */
    vuint32_t _unused_28:3;
    vuint32_t _unused_24:4;            /* Reserved. */
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t ADC_CH_y:7;              /* ADC channel selection. */
    vuint32_t LAST_y_plus_1:1;         /* Second to last channel in the list of channels. */
    vuint32_t _unused_12:3;
    vuint32_t _unused_8:4;             /* Reserved. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t ADC_CHL_y_plus_1:7;      /* ADC channel selection. */
  } B;
} BCTU_LISTCHR_tag;

struct BCTU_tag {
  BCTU_MCR_tag MCR;                    /* Module Configuration Register */
  uint8_t BCTU_reserved0[4];
  BCTU_MSR_tag MSR;                    /* Module Status register */
  uint8_t BCTU_reserved1[12];
  BCTU_TRGCFG_tag TRGCFG[96];          /* Trigger Configuration Register */
  uint8_t BCTU_reserved2[144];
  BCTU_WRPROT_tag WRPROT;              /* Write Protection register */
  BCTU_SFTRGR1_tag SFTRGR1;            /* Software Trigger register 1 */
  BCTU_SFTRGR2_tag SFTRGR2;            /* Software Trigger register 1 */
  BCTU_SFTRGR3_tag SFTRGR3;            /* Software Trigger register 1 */
  uint8_t BCTU_reserved3[4];
  BCTU_ADC0DR_tag ADC0DR;              /* ADC0 Result Data register */
  BCTU_ADC1DR_tag ADC1DR;              /* ADC1 result data register */
  uint8_t BCTU_reserved4[8];
  BCTU_LISTSTAR_tag LISTSTAR;          /* LIST Size Status register */
  BCTU_LISTCHR_tag LISTCHR[16];        /* LIST Channel Address Register */
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

typedef union C55FMC_MCR_union_tag {   /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RVE:1;                   /* Read Voltage Error */
    vuint32_t RRE:1;                   /* Read Reference Error */
    vuint32_t AEE:1;                   /* Address Encode Error */
    vuint32_t EEE:1;                   /* ECC after ECC Error */
    vuint32_t _unused_16:12;
    vuint32_t EER:1;                   /* ECC Event Error */
    vuint32_t RWE:1;                   /* Read-While-Write Event Error */
    vuint32_t SBC:1;                   /* Single Bit Correction */
    vuint32_t _unused_12:1;
    vuint32_t PEAS:1;                  /* Program Access Space */
    vuint32_t DONE:1;                  /* State Machine Status */
    vuint32_t PEG:1;                   /* Program/Erase Good */
    vuint32_t PECIE:1;                 /* Program/Erase Complete Interrupt Enable */
    vuint32_t _unused_5:3;
    vuint32_t PGM:1;                   /* Program */
    vuint32_t PSUS:1;                  /* Program Suspend */
    vuint32_t ERS:1;                   /* Erase */
    vuint32_t ESUS:1;                  /* Erase Suspend */
    vuint32_t EHV:1;                   /* Enable High Voltage */
  } B;
} C55FMC_MCR_tag;

typedef union C55FMC_MCRE_union_tag {  /* Extended Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HT:1;                    /* High Temperature Enabled. */
    vuint32_t _unused_29:2;
    vuint32_t n256K:5;
    vuint32_t n64Kh:3;
    vuint32_t n32Kh:2;
    vuint32_t n16Kh:3;
    vuint32_t n64Km:3;
    vuint32_t n32Km:2;
    vuint32_t n16Km:3;
    vuint32_t n64Kl:3;
    vuint32_t n32Kl:2;
    vuint32_t n16Kl:3;
  } B;
} C55FMC_MCRE_tag;

typedef union C55FMC_LOCK0_union_tag { /* Lock 0 register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;                /* UTest NVM Lock. */
    vuint32_t _unused_30:1;
    vuint32_t LOWLOCK:14;              /* Low Block Lock */
    vuint32_t MIDLOCK:16;              /* Mid Block Lock */
  } B;
} C55FMC_LOCK0_tag;

typedef union C55FMC_LOCK1_union_tag { /* Lock 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHLOCK:16;             /* High Block Lock */
  } B;
} C55FMC_LOCK1_tag;

typedef union C55FMC_LOCK2_union_tag { /* Lock 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:32;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK2_tag;

typedef union C55FMC_LOCK3_union_tag { /* Lock 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KLOCK:16;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK3_tag;

typedef union C55FMC_SEL0_union_tag {  /* Select 0 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t LOWSEL:14;               /* LOW Block Select. */
    vuint32_t MIDSEL:16;               /* Mid Block Select. */
  } B;
} C55FMC_SEL0_tag;

typedef union C55FMC_SEL1_union_tag {  /* Select 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHSEL:16;              /* High Block Select. */
  } B;
} C55FMC_SEL1_tag;

typedef union C55FMC_SEL2_union_tag {  /* Select 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:32;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL2_tag;

typedef union C55FMC_SEL3_union_tag {  /* Select 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KSEL:16;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL3_tag;

typedef union C55FMC_ADR_union_tag {   /* Address register */
  vuint32_t R;
  struct {
    vuint32_t SAD:1;
    vuint32_t aH:1;
    vuint32_t aM:1;
    vuint32_t aL:1;
    vuint32_t a256k:1;
    vuint32_t a64k:1;
    vuint32_t a32k:1;
    vuint32_t a16k:1;
    vuint32_t ADDR:21;
    vuint32_t _unused_0:3;
  } B;
} C55FMC_ADR_tag;

typedef union C55FMC_UT0_union_tag {   /* UTest 0 register */
  vuint32_t R;
  struct {
    vuint32_t UTE:1;
    vuint32_t SBCE:1;
    vuint32_t _unused_19:11;
    vuint32_t CPR:1;
    vuint32_t CPA:1;
    vuint32_t CPE:1;
    vuint32_t _unused_10:6;
    vuint32_t NAIBP:1;
    vuint32_t AIBPE:1;
    vuint32_t _unused_7:1;
    vuint32_t AISUS:1;
    vuint32_t MRE:1;
    vuint32_t MRV:1;
    vuint32_t _unused_3:1;
    vuint32_t AIS:1;
    vuint32_t AIE:1;
    vuint32_t AID:1;
  } B;
} C55FMC_UT0_tag;

typedef union C55FMC_UM_union_tag {    /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t MISR:32;
  } B;
} C55FMC_UM_tag;

typedef union C55FMC_UM9_union_tag {   /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t MISR:1;                  /* MISR[288]. */
  } B;
} C55FMC_UM9_tag;

typedef union C55FMC_OPP0_union_tag {  /* Over-Program Protection 0 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t LOWOPP:14;               /* Low Block Over-Program Protection[13:0]. */
    vuint32_t MIDOPP:16;               /* Mid Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP0_tag;

typedef union C55FMC_OPP1_union_tag {  /* Over-Program Protection 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHOPP:16;              /* High Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP1_tag;

typedef union C55FMC_OPP2_union_tag {  /* Over-Program Protection 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KOPP:32;             /* 256K Block Over-Program Protection[31:0]. */
  } B;
} C55FMC_OPP2_tag;

typedef union C55FMC_OPP3_union_tag {  /* Over-Program Protection 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KOPP:16;             /* 256K Block Over-Program Protection[47:32]. */
  } B;
} C55FMC_OPP3_tag;

typedef union C55FMC_TMD_union_tag {   /* Test Mode Disable Password Check register */
  vuint32_t R;
  struct {
    vuint32_t PWD:32;                  /* Password challenge */
  } B;
} C55FMC_TMD_tag;

struct C55FMC_tag {
  C55FMC_MCR_tag MCR;                  /* Module Configuration Register */
  uint8_t C55FMC_reserved0[4];
  C55FMC_MCRE_tag MCRE;                /* Extended Module Configuration Register */
  uint8_t C55FMC_reserved1[4];
  C55FMC_LOCK0_tag LOCK0;              /* Lock 0 register */
  C55FMC_LOCK1_tag LOCK1;              /* Lock 1 register */
  C55FMC_LOCK2_tag LOCK2;              /* Lock 2 register */
  C55FMC_LOCK3_tag LOCK3;              /* Lock 3 register */
  uint8_t C55FMC_reserved2[24];
  C55FMC_SEL0_tag SEL0;                /* Select 0 register */
  C55FMC_SEL1_tag SEL1;                /* Select 1 register */
  C55FMC_SEL2_tag SEL2;                /* Select 2 register */
  C55FMC_SEL3_tag SEL3;                /* Select 3 register */
  uint8_t C55FMC_reserved3[8];
  C55FMC_ADR_tag ADR;                  /* Address register */
  C55FMC_UT0_tag UT0;                  /* UTest 0 register */
  C55FMC_UM_tag UM[9];                 /* UMISR register */
  C55FMC_UM9_tag UM9;                  /* UMISR register */
  C55FMC_OPP0_tag OPP0;                /* Over-Program Protection 0 register */
  C55FMC_OPP1_tag OPP1;                /* Over-Program Protection 1 register */
  C55FMC_OPP2_tag OPP2;                /* Over-Program Protection 2 register */
  C55FMC_OPP3_tag OPP3;                /* Over-Program Protection 3 register */
  C55FMC_TMD_tag TMD;                  /* Test Mode Disable Password Check register */
};


/* ============================================================================
   =============================== Module: CAN_0 ==============================
   ============================================================================ */

typedef union CAN_0_MCR_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t WAKMSK:1;                /* Wake Up Interrupt Mask */
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SUPV:1;                  /* Supervisor Mode */
    vuint32_t SLFWAK:1;                /* Self Wake Up */
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t WAKSRC:1;                /* Wake Up Source */
    vuint32_t _unused_18:1;
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t DMA:1;                   /* DMA Enable */
    vuint32_t PNET_EN:1;               /* Pretended Networking Enable */
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t FDEN:1;                  /* CAN FD operation enable */
    vuint32_t _unused_10:1;
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t _unused_7:1;
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
  } B;
} CAN_0_MCR_tag;

typedef union CAN_0_CTRL1_union_tag {  /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t BOFFMSK:1;               /* Bus Off Interrupt Mask */
    vuint32_t ERRMSK:1;                /* Error Interrupt Mask */
    vuint32_t CLKSRC:1;                /* CAN Engine Clock Source */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t PROPSEG:3;               /* Propagation Segment */
  } B;
} CAN_0_CTRL1_tag;

typedef union CAN_0_TIMER_union_tag {  /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TIMER:16;                /* Timer Value */
  } B;
} CAN_0_TIMER_tag;

typedef union CAN_0_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} CAN_0_RXMGMASK_tag;

typedef union CAN_0_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} CAN_0_RX14MASK_tag;

typedef union CAN_0_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} CAN_0_RX15MASK_tag;

typedef union CAN_0_ECR_union_tag {    /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t RXERRCNT_FAST:8;         /* Receive Error Counter for fast bits */
    vuint32_t TXERRCNT_FAST:8;         /* Transmit Error Counter for fast bits */
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
  } B;
} CAN_0_ECR_tag;

typedef union CAN_0_ESR1_union_tag {   /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t BIT1ERR_FAST:1;          /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BIT0ERR_FAST:1;          /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_29:1;
    vuint32_t CRCERR_FAST:1;           /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
    vuint32_t FRMERR_FAST:1;           /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t STFERR_FAST:1;           /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_22:4;
    vuint32_t ERROVR:1;                /* Error Overrun bit */
    vuint32_t ERRINT_FAST:1;           /* Error Interrupt for errors detected in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BOFFDONEINT:1;           /* Bus Off Done Interrupt */
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t IDLE:1;
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t WAKINT:1;                /* Wake-Up Interrupt */
  } B;
} CAN_0_ESR1_tag;

typedef union CAN_0_IMASK2_union_tag { /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32M:32;           /* Buffer MB i Mask */
  } B;
} CAN_0_IMASK2_tag;

typedef union CAN_0_IMASK1_union_tag { /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO0M:32;            /* Buffer MB i Mask */
  } B;
} CAN_0_IMASK1_tag;

typedef union CAN_0_IFLAG2_union_tag { /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32I:32;           /* Buffer MB i Interrupt */
  } B;
} CAN_0_IFLAG2_tag;

typedef union CAN_0_IFLAG1_union_tag { /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or "reserved" */
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or "reserved" */
  } B;
} CAN_0_IFLAG1_tag;

typedef union CAN_0_CTRL2_union_tag {  /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t ERRMSK_FAST:1;           /* Error Interrupt Mask for errors detected in the Data Phase of fast CAN FD frames */
    vuint32_t BOFFDONEMSK:1;           /* Bus Off Done Interrupt Mask */
    vuint32_t _unused_29:1;
    vuint32_t _unused_28:1;
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t TIMER_SRC:1;             /* Timer Source */
    vuint32_t _unused_14:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_2:9;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} CAN_0_CTRL2_tag;

typedef union CAN_0_ESR2_union_tag {   /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t _unused_0:13;
  } B;
} CAN_0_ESR2_tag;

typedef union CAN_0_CRCR_union_tag {   /* CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t TXCRC:15;                /* Transmitted CRC value */
  } B;
} CAN_0_CRCR_tag;

typedef union CAN_0_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} CAN_0_RXFGMASK_tag;

typedef union CAN_0_RXFIR_union_tag {  /* Rx FIFO Information Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
  } B;
} CAN_0_RXFIR_tag;

typedef union CAN_0_CBT_union_tag {    /* CAN Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t BTF:1;                   /* Bit Timing Format Enable */
    vuint32_t EPRESDIV:10;             /* Extended Prescaler Division Factor */
    vuint32_t _unused_20:1;
    vuint32_t ERJW:4;                  /* Extended Resync Jump Width */
    vuint32_t EPROPSEG:6;              /* Extended Propagation Segment */
    vuint32_t EPSEG1:5;                /* Extended Phase Segment 1 */
    vuint32_t EPSEG2:5;                /* Extended Phase Segment 2 */
  } B;
} CAN_0_CBT_tag;

typedef union CAN_0_IMASK3_union_tag { /* Interrupt Masks 3 Register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64M:32;           /* Buffer MB i Mask */
  } B;
} CAN_0_IMASK3_tag;

typedef union CAN_0_IFLAG3_union_tag { /* Interrupt Flags 3 Register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64:32;            /* Buffer MB i Interrupt */
  } B;
} CAN_0_IFLAG3_tag;

typedef union CAN_0_RAMn_union_tag {   /* Embedded RAM */
  vuint32_t R;
  struct {
    vuint32_t DATA_BYTE_0:8;           /* Data byte 0 of Rx/Tx frame. */
    vuint32_t DATA_BYTE_1:8;           /* Data byte 1 of Rx/Tx frame. */
    vuint32_t DATA_BYTE_2:8;           /* Data byte 2 of Rx/Tx frame. */
    vuint32_t DATA_BYTE_3:8;           /* Data byte 3 of Rx/Tx frame. */
  } B;
} CAN_0_RAMn_tag;

typedef union CAN_0_RXIMR_union_tag {  /* Rx Individual Mask Registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} CAN_0_RXIMR_tag;

typedef union CAN_0_CTRL1_PN_union_tag { /* Pretended Networking Control 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t WTOF_MSK:1;              /* Wake Up by Timeout Flag Mask Bit */
    vuint32_t WUMF_MSK:1;              /* Wake Up by Match Flag Mask Bit */
    vuint32_t NMATCH:8;                /* Number of Messages Matching the Same Filtering Criteria */
    vuint32_t _unused_6:2;
    vuint32_t PLFS:2;                  /* Payload Filtering Selection */
    vuint32_t IDFS:2;                  /* ID Filtering Selection */
    vuint32_t FCS:2;                   /* Filtering Combination Selection */
  } B;
} CAN_0_CTRL1_PN_tag;

typedef union CAN_0_CTRL2_PN_union_tag { /* Pretended Networking Control 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t MATCHTO:16;              /* Timeout for No Message Matching the Filtering Criteria */
  } B;
} CAN_0_CTRL2_PN_tag;

typedef union CAN_0_WU_MTC_union_tag { /* Pretended Networking Wake Up Match Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t WTOF:1;                  /* Wake Up by Timeout Flag Bit */
    vuint32_t WUMF:1;                  /* Wake Up by Match Flag Bit */
    vuint32_t MCOUNTER:8;              /* Number of Matches while in Pretended Networking */
    vuint32_t _unused_0:8;
  } B;
} CAN_0_WU_MTC_tag;

typedef union CAN_0_FLT_ID1_union_tag { /* Pretended Networking ID Filter 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FLT_IDE:1;               /* ID Extended Filter */
    vuint32_t FLT_RTR:1;               /* Remote Transmission Request Filter */
    vuint32_t FLT_ID1:29;              /* ID Filter 1 for Pretended Networking filtering */
  } B;
} CAN_0_FLT_ID1_tag;

typedef union CAN_0_FLT_DLC_union_tag { /* Pretended Networking DLC Filter Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t FLT_DLC_LO:4;            /* Lower Limit for Length of Data Bytes Filter */
    vuint32_t _unused_4:12;
    vuint32_t FLT_DLC_HI:4;            /* Upper Limit for Length of Data Bytes Filter */
  } B;
} CAN_0_FLT_DLC_tag;

typedef union CAN_0_PL1_LO_union_tag { /* Pretended Networking Payload Low Filter 1 Register */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_0:8;           /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 0. */
    vuint32_t Data_byte_1:8;           /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 1. */
    vuint32_t Data_byte_2:8;           /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 2. */
    vuint32_t Data_byte_3:8;           /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 3. */
  } B;
} CAN_0_PL1_LO_tag;

typedef union CAN_0_PL1_HI_union_tag { /* Pretended Networking Payload High Filter 1 Register */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_4:8;           /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 4. */
    vuint32_t Data_byte_5:8;           /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 5. */
    vuint32_t Data_byte_6:8;           /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 6. */
    vuint32_t Data_byte_7:8;           /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 7. */
  } B;
} CAN_0_PL1_HI_tag;

typedef union CAN_0_FLT_ID2_IDMASK_union_tag { /* Pretended Networking ID Filter 2 Register / ID Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t IDE_MSK:1;               /* ID Extended Mask Bit */
    vuint32_t RTR_MSK:1;               /* Remote Transmission Request Mask Bit */
    vuint32_t FLT_ID2_IDMASK:29;       /* ID Filter 2 for Pretended Networking Filtering / ID Mask Bits for Pretended Networking ID Filtering */
  } B;
} CAN_0_FLT_ID2_IDMASK_tag;

typedef union CAN_0_PL2_PLMASK_LO_union_tag { /* Pretended Networking Payload Low Filter 2 Register / Payload Low Mask Register */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_0:8;           /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 0. */
    vuint32_t Data_byte_1:8;           /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 1. */
    vuint32_t Data_byte_2:8;           /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 2. */
    vuint32_t Data_byte_3:8;           /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 3. */
  } B;
} CAN_0_PL2_PLMASK_LO_tag;

typedef union CAN_0_PL2_PLMASK_HI_union_tag { /* Pretended Networking Payload High Filter 2 low order bits / Payload High Mask Register */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_4:8;           /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 4. */
    vuint32_t Data_byte_5:8;           /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 5. */
    vuint32_t Data_byte_6:8;           /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 6. */
    vuint32_t Data_byte_7:8;           /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 7. */
  } B;
} CAN_0_PL2_PLMASK_HI_tag;

typedef union CAN_0_WMB_CS_union_tag { /* Wake Up Message Buffer Register for C/S */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t SRR:1;                   /* Substitute Remote Request */
    vuint32_t IDE:1;                   /* ID Extended Bit */
    vuint32_t RTR:1;                   /* Remote Transmission Request Bit */
    vuint32_t DLC:4;                   /* Length of Data in Bytes */
    vuint32_t _unused_0:16;
  } B;
} CAN_0_WMB_CS_tag;

typedef union CAN_0_WMB_ID_union_tag { /* Wake Up Message Buffer Register for ID */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t ID:29;                   /* Received ID under Pretended Networking mode */
  } B;
} CAN_0_WMB_ID_tag;

typedef union CAN_0_WMB_D03_union_tag { /* Wake Up Message Buffer Register for Data 0-3 */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_0:8;           /* Received payload corresponding to the data byte 0 under Pretended Networking mode */
    vuint32_t Data_byte_1:8;           /* Received payload corresponding to the data byte 1 under Pretended Networking mode */
    vuint32_t Data_byte_2:8;           /* Received payload corresponding to the data byte 2 under Pretended Networking mode */
    vuint32_t Data_byte_3:8;           /* Received payload corresponding to the data byte 3 under Pretended Networking mode */
  } B;
} CAN_0_WMB_D03_tag;

typedef union CAN_0_WMB_D47_union_tag { /* Wake Up Message Buffer Register Data 4-7 */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_4:8;           /* Received payload corresponding to the data byte 4 under Pretended Networking mode */
    vuint32_t Data_byte_5:8;           /* Received payload corresponding to the data byte 5 under Pretended Networking mode */
    vuint32_t Data_byte_6:8;           /* Received payload corresponding to the data byte 6 under Pretended Networking mode */
    vuint32_t Data_byte_7:8;           /* Received payload corresponding to the data byte 7 under Pretended Networking mode */
  } B;
} CAN_0_WMB_D47_tag;

typedef struct CAN_0_WMB_struct_tag {
  CAN_0_WMB_CS_tag CS;                 /* Wake Up Message Buffer Register for C/S */
  CAN_0_WMB_ID_tag ID;                 /* Wake Up Message Buffer Register for ID */
  CAN_0_WMB_D03_tag D03;               /* Wake Up Message Buffer Register for Data 0-3 */
  CAN_0_WMB_D47_tag D47;               /* Wake Up Message Buffer Register Data 4-7 */
} CAN_0_WMB_tag;

typedef union CAN_0_FDCTRL_union_tag { /* CAN FD Control Register */
  vuint32_t R;
  struct {
    vuint32_t FDRATE:1;                /* Bit Rate Switch Enable */
    vuint32_t _unused_27:4;
    vuint32_t _unused_25:2;
    vuint32_t _unused_24:1;
    vuint32_t MBDSR2:2;                /* Message Buffer Data Size for Region 2 */
    vuint32_t _unused_21:1;
    vuint32_t MBDSR1:2;                /* Message Buffer Data Size for Region 1 */
    vuint32_t _unused_18:1;
    vuint32_t MBDSR0:2;                /* Message Buffer Data Size for Region 0 */
    vuint32_t TDCEN:1;                 /* Transceiver Delay Compensation Enable */
    vuint32_t TDCFAIL:1;               /* Transceiver Delay Compensation Fail */
    vuint32_t _unused_13:1;
    vuint32_t TDCOFF:5;                /* Transceiver Delay Compensation Offset */
    vuint32_t _unused_6:2;
    vuint32_t TDCVAL:6;                /* Transceiver Delay Compensation Value */
  } B;
} CAN_0_FDCTRL_tag;

typedef union CAN_0_FDCBT_union_tag {  /* CAN FD Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t FPRESDIV:10;             /* Fast Prescaler Division Factor */
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t FRJW:2;                  /* Fast Resync Jump Width */
    vuint32_t _unused_15:1;
    vuint32_t FPROPSEG:5;              /* Fast Propagation Segment */
    vuint32_t _unused_8:2;
    vuint32_t FPSEG1:3;                /* Fast Phase Segment 1 */
    vuint32_t _unused_3:2;
    vuint32_t FPSEG2:3;                /* Fast Phase Segment 2 */
  } B;
} CAN_0_FDCBT_tag;

typedef union CAN_0_FDCRC_union_tag {  /* CAN FD CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FD_MBCRC:7;              /* CRC Mailbox Number for FD_TXCRC */
    vuint32_t _unused_21:3;
    vuint32_t FD_TXCRC:21;             /* Extended Transmitted CRC value */
  } B;
} CAN_0_FDCRC_tag;

struct CAN_0_tag {
  CAN_0_MCR_tag MCR;                   /* Module Configuration Register */
  CAN_0_CTRL1_tag CTRL1;               /* Control 1 register */
  CAN_0_TIMER_tag TIMER;               /* Free Running Timer */
  uint8_t CAN_0_reserved0[4];
  CAN_0_RXMGMASK_tag RXMGMASK;         /* Rx Mailboxes Global Mask Register */
  CAN_0_RX14MASK_tag RX14MASK;         /* Rx 14 Mask register */
  CAN_0_RX15MASK_tag RX15MASK;         /* Rx 15 Mask register */
  CAN_0_ECR_tag ECR;                   /* Error Counter */
  CAN_0_ESR1_tag ESR1;                 /* Error and Status 1 register */
  CAN_0_IMASK2_tag IMASK2;             /* Interrupt Masks 2 register */
  CAN_0_IMASK1_tag IMASK1;             /* Interrupt Masks 1 register */
  CAN_0_IFLAG2_tag IFLAG2;             /* Interrupt Flags 2 register */
  CAN_0_IFLAG1_tag IFLAG1;             /* Interrupt Flags 1 register */
  CAN_0_CTRL2_tag CTRL2;               /* Control 2 register */
  CAN_0_ESR2_tag ESR2;                 /* Error and Status 2 register */
  uint8_t CAN_0_reserved1[8];
  CAN_0_CRCR_tag CRCR;                 /* CRC Register */
  CAN_0_RXFGMASK_tag RXFGMASK;         /* Rx FIFO Global Mask register */
  CAN_0_RXFIR_tag RXFIR;               /* Rx FIFO Information Register */
  CAN_0_CBT_tag CBT;                   /* CAN Bit Timing Register */
  uint8_t CAN_0_reserved2[24];
  CAN_0_IMASK3_tag IMASK3;             /* Interrupt Masks 3 Register */
  uint8_t CAN_0_reserved3[4];
  CAN_0_IFLAG3_tag IFLAG3;             /* Interrupt Flags 3 Register */
  uint8_t CAN_0_reserved4[8];
  CAN_0_RAMn_tag RAMn[384];            /* Embedded RAM */
  uint8_t CAN_0_reserved5[512];
  CAN_0_RXIMR_tag RXIMR[96];           /* Rx Individual Mask Registers */
  uint8_t CAN_0_reserved6[256];
  CAN_0_CTRL1_PN_tag CTRL1_PN;         /* Pretended Networking Control 1 Register */
  CAN_0_CTRL2_PN_tag CTRL2_PN;         /* Pretended Networking Control 2 Register */
  CAN_0_WU_MTC_tag WU_MTC;             /* Pretended Networking Wake Up Match Register */
  CAN_0_FLT_ID1_tag FLT_ID1;           /* Pretended Networking ID Filter 1 Register */
  CAN_0_FLT_DLC_tag FLT_DLC;           /* Pretended Networking DLC Filter Register */
  CAN_0_PL1_LO_tag PL1_LO;             /* Pretended Networking Payload Low Filter 1 Register */
  CAN_0_PL1_HI_tag PL1_HI;             /* Pretended Networking Payload High Filter 1 Register */
  CAN_0_FLT_ID2_IDMASK_tag FLT_ID2_IDMASK; /* Pretended Networking ID Filter 2 Register / ID Mask Register */
  CAN_0_PL2_PLMASK_LO_tag PL2_PLMASK_LO; /* Pretended Networking Payload Low Filter 2 Register / Payload Low Mask Register */
  CAN_0_PL2_PLMASK_HI_tag PL2_PLMASK_HI; /* Pretended Networking Payload High Filter 2 low order bits / Payload High Mask Register */
  uint8_t CAN_0_reserved7[24];
  CAN_0_WMB_tag WMB[4];
  uint8_t CAN_0_reserved8[128];
  CAN_0_FDCTRL_tag FDCTRL;             /* CAN FD Control Register */
  CAN_0_FDCBT_tag FDCBT;               /* CAN FD Bit Timing Register */
  CAN_0_FDCRC_tag FDCRC;               /* CAN FD CRC Register */
};


/* ============================================================================
   =============================== Module: CAN 1-7 ============================
   ============================================================================ */

typedef union CAN_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t WAKMSK:1;                /* Wake Up Interrupt Mask */
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SUPV:1;                  /* Supervisor Mode */
    vuint32_t SLFWAK:1;                /* Self Wake Up */
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t WAKSRC:1;                /* Wake Up Source */
    vuint32_t _unused_18:1;
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t DMA:1;                   /* DMA Enable */
    vuint32_t _unused_14:1;
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t FDEN:1;                  /* CAN FD operation enable */
    vuint32_t _unused_10:1;
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t _unused_7:1;
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
  } B;
} CAN_MCR_tag;

typedef union CAN_CTRL1_union_tag {    /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t BOFFMSK:1;               /* Bus Off Interrupt Mask */
    vuint32_t ERRMSK:1;                /* Error Interrupt Mask */
    vuint32_t CLKSRC:1;                /* CAN Engine Clock Source */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t PROPSEG:3;               /* Propagation Segment */
  } B;
} CAN_CTRL1_tag;

typedef union CAN_TIMER_union_tag {    /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TIMER:16;                /* Timer Value */
  } B;
} CAN_TIMER_tag;

typedef union CAN_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} CAN_RXMGMASK_tag;

typedef union CAN_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} CAN_RX14MASK_tag;

typedef union CAN_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} CAN_RX15MASK_tag;

typedef union CAN_ECR_union_tag {      /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t RXERRCNT_FAST:8;         /* Receive Error Counter for fast bits */
    vuint32_t TXERRCNT_FAST:8;         /* Transmit Error Counter for fast bits */
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
  } B;
} CAN_ECR_tag;

typedef union CAN_ESR1_union_tag {     /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t BIT1ERR_FAST:1;          /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BIT0ERR_FAST:1;          /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_29:1;
    vuint32_t CRCERR_FAST:1;           /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
    vuint32_t FRMERR_FAST:1;           /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t STFERR_FAST:1;           /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_22:4;
    vuint32_t ERROVR:1;                /* Error Overrun bit */
    vuint32_t ERRINT_FAST:1;           /* Error Interrupt for errors detected in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BOFFDONEINT:1;           /* Bus Off Done Interrupt */
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t IDLE:1;
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t WAKINT:1;                /* Wake-Up Interrupt */
  } B;
} CAN_ESR1_tag;

typedef union CAN_IMASK2_union_tag {   /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32M:32;           /* Buffer MB i Mask */
  } B;
} CAN_IMASK2_tag;

typedef union CAN_IMASK1_union_tag {   /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO0M:32;            /* Buffer MB i Mask */
  } B;
} CAN_IMASK1_tag;

typedef union CAN_IFLAG2_union_tag {   /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32I:32;           /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG2_tag;

typedef union CAN_IFLAG1_union_tag {   /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or "reserved" */
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or "reserved" */
  } B;
} CAN_IFLAG1_tag;

typedef union CAN_CTRL2_union_tag {    /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t ERRMSK_FAST:1;           /* Error Interrupt Mask for errors detected in the Data Phase of fast CAN FD frames */
    vuint32_t BOFFDONEMSK:1;           /* Bus Off Done Interrupt Mask */
    vuint32_t _unused_29:1;
    vuint32_t _unused_28:1;
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t TIMER_SRC:1;             /* Timer Source */
    vuint32_t _unused_14:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_2:9;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} CAN_CTRL2_tag;

typedef union CAN_ESR2_union_tag {     /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t _unused_0:13;
  } B;
} CAN_ESR2_tag;

typedef union CAN_CRCR_union_tag {     /* CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t TXCRC:15;                /* Transmitted CRC value */
  } B;
} CAN_CRCR_tag;

typedef union CAN_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} CAN_RXFGMASK_tag;

typedef union CAN_RXFIR_union_tag {    /* Rx FIFO Information Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
  } B;
} CAN_RXFIR_tag;

typedef union CAN_CBT_union_tag {      /* CAN Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t BTF:1;                   /* Bit Timing Format Enable */
    vuint32_t EPRESDIV:10;             /* Extended Prescaler Division Factor */
    vuint32_t _unused_20:1;
    vuint32_t ERJW:4;                  /* Extended Resync Jump Width */
    vuint32_t EPROPSEG:6;              /* Extended Propagation Segment */
    vuint32_t EPSEG1:5;                /* Extended Phase Segment 1 */
    vuint32_t EPSEG2:5;                /* Extended Phase Segment 2 */
  } B;
} CAN_CBT_tag;

typedef union CAN_IMASK3_union_tag {   /* Interrupt Masks 3 Register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64M:32;           /* Buffer MB i Mask */
  } B;
} CAN_IMASK3_tag;

typedef union CAN_IFLAG3_union_tag {   /* Interrupt Flags 3 Register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64:32;            /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG3_tag;

typedef union CAN_RAMn_union_tag {     /* Embedded RAM */
  vuint32_t R;
  struct {
    vuint32_t DATA_BYTE_0:8;           /* Data byte 0 of Rx/Tx frame. */
    vuint32_t DATA_BYTE_1:8;           /* Data byte 1 of Rx/Tx frame. */
    vuint32_t DATA_BYTE_2:8;           /* Data byte 2 of Rx/Tx frame. */
    vuint32_t DATA_BYTE_3:8;           /* Data byte 3 of Rx/Tx frame. */
  } B;
} CAN_RAMn_tag;

typedef union CAN_RXIMR_union_tag {    /* Rx Individual Mask Registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} CAN_RXIMR_tag;

typedef union CAN_FDCTRL_union_tag {   /* CAN FD Control Register */
  vuint32_t R;
  struct {
    vuint32_t FDRATE:1;                /* Bit Rate Switch Enable */
    vuint32_t _unused_27:4;
    vuint32_t _unused_25:2;
    vuint32_t _unused_24:1;
    vuint32_t MBDSR2:2;                /* Message Buffer Data Size for Region 2 */
    vuint32_t _unused_21:1;
    vuint32_t MBDSR1:2;                /* Message Buffer Data Size for Region 1 */
    vuint32_t _unused_18:1;
    vuint32_t MBDSR0:2;                /* Message Buffer Data Size for Region 0 */
    vuint32_t TDCEN:1;                 /* Transceiver Delay Compensation Enable */
    vuint32_t TDCFAIL:1;               /* Transceiver Delay Compensation Fail */
    vuint32_t _unused_13:1;
    vuint32_t TDCOFF:5;                /* Transceiver Delay Compensation Offset */
    vuint32_t _unused_6:2;
    vuint32_t TDCVAL:6;                /* Transceiver Delay Compensation Value */
  } B;
} CAN_FDCTRL_tag;

typedef union CAN_FDCBT_union_tag {    /* CAN FD Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t FPRESDIV:10;             /* Fast Prescaler Division Factor */
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t FRJW:2;                  /* Fast Resync Jump Width */
    vuint32_t _unused_15:1;
    vuint32_t FPROPSEG:5;              /* Fast Propagation Segment */
    vuint32_t _unused_8:2;
    vuint32_t FPSEG1:3;                /* Fast Phase Segment 1 */
    vuint32_t _unused_3:2;
    vuint32_t FPSEG2:3;                /* Fast Phase Segment 2 */
  } B;
} CAN_FDCBT_tag;

typedef union CAN_FDCRC_union_tag {    /* CAN FD CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FD_MBCRC:7;              /* CRC Mailbox Number for FD_TXCRC */
    vuint32_t _unused_21:3;
    vuint32_t FD_TXCRC:21;             /* Extended Transmitted CRC value */
  } B;
} CAN_FDCRC_tag;

struct CAN_1_7_tag {
  CAN_MCR_tag MCR;                     /* Module Configuration Register */
  CAN_CTRL1_tag CTRL1;                 /* Control 1 register */
  CAN_TIMER_tag TIMER;                 /* Free Running Timer */
  uint8_t CAN_reserved0[4];
  CAN_RXMGMASK_tag RXMGMASK;           /* Rx Mailboxes Global Mask Register */
  CAN_RX14MASK_tag RX14MASK;           /* Rx 14 Mask register */
  CAN_RX15MASK_tag RX15MASK;           /* Rx 15 Mask register */
  CAN_ECR_tag ECR;                     /* Error Counter */
  CAN_ESR1_tag ESR1;                   /* Error and Status 1 register */
  CAN_IMASK2_tag IMASK2;               /* Interrupt Masks 2 register */
  CAN_IMASK1_tag IMASK1;               /* Interrupt Masks 1 register */
  CAN_IFLAG2_tag IFLAG2;               /* Interrupt Flags 2 register */
  CAN_IFLAG1_tag IFLAG1;               /* Interrupt Flags 1 register */
  CAN_CTRL2_tag CTRL2;                 /* Control 2 register */
  CAN_ESR2_tag ESR2;                   /* Error and Status 2 register */
  uint8_t CAN_reserved1[8];
  CAN_CRCR_tag CRCR;                   /* CRC Register */
  CAN_RXFGMASK_tag RXFGMASK;           /* Rx FIFO Global Mask register */
  CAN_RXFIR_tag RXFIR;                 /* Rx FIFO Information Register */
  CAN_CBT_tag CBT;                     /* CAN Bit Timing Register */
  uint8_t CAN_reserved2[24];
  CAN_IMASK3_tag IMASK3;               /* Interrupt Masks 3 Register */
  uint8_t CAN_reserved3[4];
  CAN_IFLAG3_tag IFLAG3;               /* Interrupt Flags 3 Register */
  uint8_t CAN_reserved4[8];
  CAN_RAMn_tag RAMn[384];              /* Embedded RAM */
  uint8_t CAN_reserved5[512];
  CAN_RXIMR_tag RXIMR[96];             /* Rx Individual Mask Registers */
  uint8_t CAN_reserved6[512];
  CAN_FDCTRL_tag FDCTRL;               /* CAN FD Control Register */
  CAN_FDCBT_tag FDCBT;                 /* CAN FD Bit Timing Register */
  CAN_FDCRC_tag FDCRC;                 /* CAN FD CRC Register */
};


/* ============================================================================
   =============================== Module: CMP ================================
   ============================================================================ */

typedef union CMP_C0_union_tag {       /* CMP Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t DMAEN:1;                 /* DMA Enable */
    vuint32_t _unused_29:1;
    vuint32_t IER:1;                   /* Comparator Interrupt Enable Rising */
    vuint32_t IEF:1;                   /* Comparator Interrupt Enable Falling */
    vuint32_t CFR:1;                   /* Analog Comparator Flag Rising */
    vuint32_t CFF:1;                   /* Analog Comparator Flag Falling */
    vuint32_t COUT:1;                  /* Analog Comparator Output */
    vuint32_t FPR:8;                   /* Filter Sample Period */
    vuint32_t SE:1;                    /* Sample Enable */
    vuint32_t WE:1;                    /* Windowing Enable */
    vuint32_t _unused_13:1;
    vuint32_t PMODE:1;                 /* Power Mode Select */
    vuint32_t INVT:1;                  /* Comparator invert */
    vuint32_t COS:1;                   /* Comparator Output Select */
    vuint32_t OPE:1;                   /* Comparator Output Pin Enable */
    vuint32_t EN:1;                    /* Comparator Module Enable */
    vuint32_t _unused_7:1;
    vuint32_t FILTER_CNT:3;            /* Filter Sample Count */
    vuint32_t _unused_2:2;
    vuint32_t HYSTCTR:2;               /* Comparator hard block hysteresis control */
  } B;
} CMP_C0_tag;

typedef union CMP_C1_union_tag {       /* CMP Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_24:7;
    vuint32_t CHN7:1;                  /* Channel 7 input enable */
    vuint32_t CHN6:1;                  /* Channel 6 input enable */
    vuint32_t CHN5:1;                  /* Channel 5 input enable */
    vuint32_t CHN4:1;                  /* Channel 4 input enable */
    vuint32_t CHN3:1;                  /* Channel 3 input enable */
    vuint32_t CHN2:1;                  /* Channel 2 input enable */
    vuint32_t CHN1:1;                  /* Channel 1 input enable */
    vuint32_t CHN0:1;                  /* Channel 0 input enable */
    vuint32_t DPSEL:1;                 /* DAC output to Plus side ANMUX selection */
    vuint32_t DMSEL:1;                 /* DAC output to Minus side ANMUX selection */
    vuint32_t PSEL:3;                  /* Plus Input MUX Control */
    vuint32_t MSEL:3;                  /* Minus Input MUX Control */
    vuint32_t DACEN:1;                 /* DAC Enable */
    vuint32_t VRSEL:1;                 /* Supply Voltage Reference Source Select */
    vuint32_t VOSEL:6;                 /* DAC Output Voltage Select */
  } B;
} CMP_C1_tag;

typedef union CMP_C2_union_tag {       /* CMP Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t RRE:1;                   /* Round-Robin Enable */
    vuint32_t RRIE:1;                  /* Round-Robin interrupt enable */
    vuint32_t FXMP:1;                  /* Fixed MUX Port */
    vuint32_t FXDACI:1;                /* Fix DAC input to the fixed mux port side */
    vuint32_t FXMXCH:3;                /* Fixed channel selection */
    vuint32_t _unused_24:1;
    vuint32_t CH7F:1;
    vuint32_t CH6F:1;
    vuint32_t CH5F:1;
    vuint32_t CH4F:1;
    vuint32_t CH3F:1;
    vuint32_t CH2F:1;
    vuint32_t CH1F:1;
    vuint32_t CH0F:1;
    vuint32_t NSAM:2;                  /* Number of sample clocks */
    vuint32_t _unused_8:6;
    vuint32_t ACOn:8;
  } B;
} CMP_C2_tag;

struct CMP_tag {
  CMP_C0_tag C0;                       /* CMP Control Register 0 */
  CMP_C1_tag C1;                       /* CMP Control Register 1 */
  CMP_C2_tag C2;                       /* CMP Control Register 2 */
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

typedef union CMU_CSR_union_tag {      /* CMU Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t SFM:1;                   /* Start frequency measure. */
    vuint32_t _unused_10:13;
    vuint32_t CKSEL1:2;                /* Frequency measure clock selection bit. */
    vuint32_t _unused_3:5;
    vuint32_t RCDIV:2;                 /* CLKMT0_RMN division factor. */
    vuint32_t CME:1;                   /* CLKMN1 monitor enable. */
  } B;
} CMU_CSR_tag;

typedef union CMU_FDR_union_tag {      /* CMU Frequency Display Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t FD:20;                   /* Measured frequency bits. */
  } B;
} CMU_FDR_tag;

typedef union CMU_HFREFR_union_tag {   /* CMU High Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t HFREF:12;                /* High Frequency reference value. */
  } B;
} CMU_HFREFR_tag;

typedef union CMU_LFREFR_union_tag {   /* CMU Low Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t LFREF:12;                /* Low Frequency reference value. */
  } B;
} CMU_LFREFR_tag;

typedef union CMU_ISR_union_tag {      /* CMU Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t _unused_3:1;
    vuint32_t FHHI:1;                  /* CLKMN1 frequency higher than high reference event status. */
    vuint32_t FLLI:1;                  /* CLKMN1 frequency less than low reference event status. */
    vuint32_t OLRI:1;                  /* Oscillator frequency less than f CLKMT0_RMN * 2CMU_CSR[RCDIV]event status. */
  } B;
} CMU_ISR_tag;

typedef union CMU_MDR_union_tag {      /* CMU Measurement Duration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t MD:20;                   /* Measurement duration bits */
  } B;
} CMU_MDR_tag;

struct CMU_tag {
  CMU_CSR_tag CSR;                     /* CMU Control Status Register */
  CMU_FDR_tag FDR;                     /* CMU Frequency Display Register */
  CMU_HFREFR_tag HFREFR;               /* CMU High Frequency Reference Register CLKMN1 */
  CMU_LFREFR_tag LFREFR;               /* CMU Low Frequency Reference Register CLKMN1 */
  CMU_ISR_tag ISR;                     /* CMU Interrupt Status Register */
  uint8_t CMU_reserved0[4];
  CMU_MDR_tag MDR;                     /* CMU Measurement Duration Register */
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

typedef union CRC_CFG_union_tag {      /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_6:18;
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t INV:1;                   /* Inversion selection */
  } B;
} CRC_CFG_tag;

typedef union CRC_INP_union_tag {      /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_INP_tag;

typedef union CRC_CSTAT_union_tag {    /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CSTAT_tag;

typedef union CRC_OUTP_union_tag {     /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_OUTP_tag;

struct CRC_tag {
  CRC_CFG_tag CFG;                     /* Configuration Register */
  CRC_INP_tag INP;                     /* Input Register */
  CRC_CSTAT_tag CSTAT;                 /* Current Status Register */
  CRC_OUTP_tag OUTP;                   /* Output Register */
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

typedef union DMA_CR_union_tag {       /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t CX:1;                    /* Cancel Transfer */
    vuint32_t ECX:1;                   /* Error Cancel Transfer */
    vuint32_t _unused_11:5;
    vuint32_t GRP1PRI:1;               /* Channel Group 1 Priority */
    vuint32_t _unused_9:1;
    vuint32_t GRP0PRI:1;               /* Channel Group 0 Priority */
    vuint32_t EMLM:1;                  /* Enable Minor Loop Mapping */
    vuint32_t CLM:1;                   /* Continuous Link Mode */
    vuint32_t HALT:1;                  /* Halt DMA Operations */
    vuint32_t HOE:1;                   /* Halt On Error */
    vuint32_t ERGA:1;                  /* Enable Round Robin Group Arbitration */
    vuint32_t ERCA:1;                  /* Enable Round Robin Channel Arbitration */
    vuint32_t EDBG:1;                  /* Enable Debug */
    vuint32_t _unused_0:1;
  } B;
} DMA_CR_tag;

typedef union DMA_ES_union_tag {       /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_18:13;
    vuint32_t UCE:1;                   /* Uncorrectable ECC error during channel execution. */
    vuint32_t ECX:1;                   /* Transfer Canceled */
    vuint32_t GPE:1;                   /* Group Priority Error */
    vuint32_t CPE:1;                   /* Channel Priority Error */
    vuint32_t _unused_13:1;
    vuint32_t ERRCHN:5;                /* Error Channel Number or Canceled Channel Number */
    vuint32_t SAE:1;                   /* Source Address Error */
    vuint32_t SOE:1;                   /* Source Offset Error */
    vuint32_t DAE:1;                   /* Destination Address Error */
    vuint32_t DOE:1;                   /* Destination Offset Error */
    vuint32_t NCE:1;                   /* NBYTES/CITER Configuration Error */
    vuint32_t SGE:1;                   /* Scatter/Gather Configuration Error */
    vuint32_t SBE:1;                   /* Source Bus Error */
    vuint32_t DBE:1;                   /* Destination Bus Error */
  } B;
} DMA_ES_tag;

typedef union DMA_ERQ_union_tag {      /* Enable Request Register */
  vuint32_t R;
  struct {
    vuint32_t ERQ31:1;                 /* Enable DMA Request 31 */
    vuint32_t ERQ30:1;                 /* Enable DMA Request 30 */
    vuint32_t ERQ29:1;                 /* Enable DMA Request 29 */
    vuint32_t ERQ28:1;                 /* Enable DMA Request 28 */
    vuint32_t ERQ27:1;                 /* Enable DMA Request 27 */
    vuint32_t ERQ26:1;                 /* Enable DMA Request 26 */
    vuint32_t ERQ25:1;                 /* Enable DMA Request 25 */
    vuint32_t ERQ24:1;                 /* Enable DMA Request 24 */
    vuint32_t ERQ23:1;                 /* Enable DMA Request 23 */
    vuint32_t ERQ22:1;                 /* Enable DMA Request 22 */
    vuint32_t ERQ21:1;                 /* Enable DMA Request 21 */
    vuint32_t ERQ20:1;                 /* Enable DMA Request 20 */
    vuint32_t ERQ19:1;                 /* Enable DMA Request 19 */
    vuint32_t ERQ18:1;                 /* Enable DMA Request 18 */
    vuint32_t ERQ17:1;                 /* Enable DMA Request 17 */
    vuint32_t ERQ16:1;                 /* Enable DMA Request 16 */
    vuint32_t ERQ15:1;                 /* Enable DMA Request 15 */
    vuint32_t ERQ14:1;                 /* Enable DMA Request 14 */
    vuint32_t ERQ13:1;                 /* Enable DMA Request 13 */
    vuint32_t ERQ12:1;                 /* Enable DMA Request 12 */
    vuint32_t ERQ11:1;                 /* Enable DMA Request 11 */
    vuint32_t ERQ10:1;                 /* Enable DMA Request 10 */
    vuint32_t ERQ9:1;                  /* Enable DMA Request 9 */
    vuint32_t ERQ8:1;                  /* Enable DMA Request 8 */
    vuint32_t ERQ7:1;                  /* Enable DMA Request 7 */
    vuint32_t ERQ6:1;                  /* Enable DMA Request 6 */
    vuint32_t ERQ5:1;                  /* Enable DMA Request 5 */
    vuint32_t ERQ4:1;                  /* Enable DMA Request 4 */
    vuint32_t ERQ3:1;                  /* Enable DMA Request 3 */
    vuint32_t ERQ2:1;                  /* Enable DMA Request 2 */
    vuint32_t ERQ1:1;                  /* Enable DMA Request 1 */
    vuint32_t ERQ0:1;                  /* Enable DMA Request 0 */
  } B;
} DMA_ERQ_tag;

typedef union DMA_EEI_union_tag {      /* Enable Error Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t EEI31:1;                 /* Enable Error Interrupt 31 */
    vuint32_t EEI30:1;                 /* Enable Error Interrupt 30 */
    vuint32_t EEI29:1;                 /* Enable Error Interrupt 29 */
    vuint32_t EEI28:1;                 /* Enable Error Interrupt 28 */
    vuint32_t EEI27:1;                 /* Enable Error Interrupt 27 */
    vuint32_t EEI26:1;                 /* Enable Error Interrupt 26 */
    vuint32_t EEI25:1;                 /* Enable Error Interrupt 25 */
    vuint32_t EEI24:1;                 /* Enable Error Interrupt 24 */
    vuint32_t EEI23:1;                 /* Enable Error Interrupt 23 */
    vuint32_t EEI22:1;                 /* Enable Error Interrupt 22 */
    vuint32_t EEI21:1;                 /* Enable Error Interrupt 21 */
    vuint32_t EEI20:1;                 /* Enable Error Interrupt 20 */
    vuint32_t EEI19:1;                 /* Enable Error Interrupt 19 */
    vuint32_t EEI18:1;                 /* Enable Error Interrupt 18 */
    vuint32_t EEI17:1;                 /* Enable Error Interrupt 17 */
    vuint32_t EEI16:1;                 /* Enable Error Interrupt 16 */
    vuint32_t EEI15:1;                 /* Enable Error Interrupt 15 */
    vuint32_t EEI14:1;                 /* Enable Error Interrupt 14 */
    vuint32_t EEI13:1;                 /* Enable Error Interrupt 13 */
    vuint32_t EEI12:1;                 /* Enable Error Interrupt 12 */
    vuint32_t EEI11:1;                 /* Enable Error Interrupt 11 */
    vuint32_t EEI10:1;                 /* Enable Error Interrupt 10 */
    vuint32_t EEI9:1;                  /* Enable Error Interrupt 9 */
    vuint32_t EEI8:1;                  /* Enable Error Interrupt 8 */
    vuint32_t EEI7:1;                  /* Enable Error Interrupt 7 */
    vuint32_t EEI6:1;                  /* Enable Error Interrupt 6 */
    vuint32_t EEI5:1;                  /* Enable Error Interrupt 5 */
    vuint32_t EEI4:1;                  /* Enable Error Interrupt 4 */
    vuint32_t EEI3:1;                  /* Enable Error Interrupt 3 */
    vuint32_t EEI2:1;                  /* Enable Error Interrupt 2 */
    vuint32_t EEI1:1;                  /* Enable Error Interrupt 1 */
    vuint32_t EEI0:1;                  /* Enable Error Interrupt 0 */
  } B;
} DMA_EEI_tag;

typedef union DMA_SERQ_union_tag {     /* Set Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAER:1;                   /* Set All Enable Requests */
    vuint8_t _unused_5:1;
    vuint8_t SERQ:5;                   /* Set Enable Request */
  } B;
} DMA_SERQ_tag;

typedef union DMA_CERQ_union_tag {     /* Clear Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAER:1;                   /* Clear All Enable Requests */
    vuint8_t _unused_5:1;
    vuint8_t CERQ:5;                   /* Clear Enable Request */
  } B;
} DMA_CERQ_tag;

typedef union DMA_SEEI_union_tag {     /* Set Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAEE:1;                   /* Sets All Enable Error Interrupts */
    vuint8_t _unused_5:1;
    vuint8_t SEEI:5;                   /* Set Enable Error Interrupt */
  } B;
} DMA_SEEI_tag;

typedef union DMA_CEEI_union_tag {     /* Clear Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAEE:1;                   /* Clear All Enable Error Interrupts */
    vuint8_t _unused_5:1;
    vuint8_t CEEI:5;                   /* Clear Enable Error Interrupt */
  } B;
} DMA_CEEI_tag;

typedef union DMA_CINT_union_tag {     /* Clear Interrupt Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAIR:1;                   /* Clear All Interrupt Requests */
    vuint8_t _unused_5:1;
    vuint8_t CINT:5;                   /* Clear Interrupt Request */
  } B;
} DMA_CINT_tag;

typedef union DMA_CERR_union_tag {     /* Clear Error Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAEI:1;                   /* Clear All Error Indicators */
    vuint8_t _unused_5:1;
    vuint8_t CERR:5;                   /* Clear Error Indicator */
  } B;
} DMA_CERR_tag;

typedef union DMA_SSRT_union_tag {     /* Set START Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAST:1;                   /* Set All START Bits (activates all channels) */
    vuint8_t _unused_5:1;
    vuint8_t SSRT:5;                   /* Set START Bit */
  } B;
} DMA_SSRT_tag;

typedef union DMA_CDNE_union_tag {     /* Clear DONE Status Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CADN:1;                   /* Clears All DONE Bits */
    vuint8_t _unused_5:1;
    vuint8_t CDNE:5;                   /* Clear DONE Bit */
  } B;
} DMA_CDNE_tag;

typedef union DMA_INT_union_tag {      /* Interrupt Request Register */
  vuint32_t R;
  struct {
    vuint32_t INT31:1;                 /* Interrupt Request 31 */
    vuint32_t INT30:1;                 /* Interrupt Request 30 */
    vuint32_t INT29:1;                 /* Interrupt Request 29 */
    vuint32_t INT28:1;                 /* Interrupt Request 28 */
    vuint32_t INT27:1;                 /* Interrupt Request 27 */
    vuint32_t INT26:1;                 /* Interrupt Request 26 */
    vuint32_t INT25:1;                 /* Interrupt Request 25 */
    vuint32_t INT24:1;                 /* Interrupt Request 24 */
    vuint32_t INT23:1;                 /* Interrupt Request 23 */
    vuint32_t INT22:1;                 /* Interrupt Request 22 */
    vuint32_t INT21:1;                 /* Interrupt Request 21 */
    vuint32_t INT20:1;                 /* Interrupt Request 20 */
    vuint32_t INT19:1;                 /* Interrupt Request 19 */
    vuint32_t INT18:1;                 /* Interrupt Request 18 */
    vuint32_t INT17:1;                 /* Interrupt Request 17 */
    vuint32_t INT16:1;                 /* Interrupt Request 16 */
    vuint32_t INT15:1;                 /* Interrupt Request 15 */
    vuint32_t INT14:1;                 /* Interrupt Request 14 */
    vuint32_t INT13:1;                 /* Interrupt Request 13 */
    vuint32_t INT12:1;                 /* Interrupt Request 12 */
    vuint32_t INT11:1;                 /* Interrupt Request 11 */
    vuint32_t INT10:1;                 /* Interrupt Request 10 */
    vuint32_t INT9:1;                  /* Interrupt Request 9 */
    vuint32_t INT8:1;                  /* Interrupt Request 8 */
    vuint32_t INT7:1;                  /* Interrupt Request 7 */
    vuint32_t INT6:1;                  /* Interrupt Request 6 */
    vuint32_t INT5:1;                  /* Interrupt Request 5 */
    vuint32_t INT4:1;                  /* Interrupt Request 4 */
    vuint32_t INT3:1;                  /* Interrupt Request 3 */
    vuint32_t INT2:1;                  /* Interrupt Request 2 */
    vuint32_t INT1:1;                  /* Interrupt Request 1 */
    vuint32_t INT0:1;                  /* Interrupt Request 0 */
  } B;
} DMA_INT_tag;

typedef union DMA_ERR_union_tag {      /* Error Register */
  vuint32_t R;
  struct {
    vuint32_t ERR31:1;                 /* Error In Channel 31 */
    vuint32_t ERR30:1;                 /* Error In Channel 30 */
    vuint32_t ERR29:1;                 /* Error In Channel 29 */
    vuint32_t ERR28:1;                 /* Error In Channel 28 */
    vuint32_t ERR27:1;                 /* Error In Channel 27 */
    vuint32_t ERR26:1;                 /* Error In Channel 26 */
    vuint32_t ERR25:1;                 /* Error In Channel 25 */
    vuint32_t ERR24:1;                 /* Error In Channel 24 */
    vuint32_t ERR23:1;                 /* Error In Channel 23 */
    vuint32_t ERR22:1;                 /* Error In Channel 22 */
    vuint32_t ERR21:1;                 /* Error In Channel 21 */
    vuint32_t ERR20:1;                 /* Error In Channel 20 */
    vuint32_t ERR19:1;                 /* Error In Channel 19 */
    vuint32_t ERR18:1;                 /* Error In Channel 18 */
    vuint32_t ERR17:1;                 /* Error In Channel 17 */
    vuint32_t ERR16:1;                 /* Error In Channel 16 */
    vuint32_t ERR15:1;                 /* Error In Channel 15 */
    vuint32_t ERR14:1;                 /* Error In Channel 14 */
    vuint32_t ERR13:1;                 /* Error In Channel 13 */
    vuint32_t ERR12:1;                 /* Error In Channel 12 */
    vuint32_t ERR11:1;                 /* Error In Channel 11 */
    vuint32_t ERR10:1;                 /* Error In Channel 10 */
    vuint32_t ERR9:1;                  /* Error In Channel 9 */
    vuint32_t ERR8:1;                  /* Error In Channel 8 */
    vuint32_t ERR7:1;                  /* Error In Channel 7 */
    vuint32_t ERR6:1;                  /* Error In Channel 6 */
    vuint32_t ERR5:1;                  /* Error In Channel 5 */
    vuint32_t ERR4:1;                  /* Error In Channel 4 */
    vuint32_t ERR3:1;                  /* Error In Channel 3 */
    vuint32_t ERR2:1;                  /* Error In Channel 2 */
    vuint32_t ERR1:1;                  /* Error In Channel 1 */
    vuint32_t ERR0:1;                  /* Error In Channel 0 */
  } B;
} DMA_ERR_tag;

typedef union DMA_HRS_union_tag {      /* Hardware Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t HRS31:1;                 /* Hardware Request Status Channel 31 */
    vuint32_t HRS30:1;                 /* Hardware Request Status Channel 30 */
    vuint32_t HRS29:1;                 /* Hardware Request Status Channel 29 */
    vuint32_t HRS28:1;                 /* Hardware Request Status Channel 28 */
    vuint32_t HRS27:1;                 /* Hardware Request Status Channel 27 */
    vuint32_t HRS26:1;                 /* Hardware Request Status Channel 26 */
    vuint32_t HRS25:1;                 /* Hardware Request Status Channel 25 */
    vuint32_t HRS24:1;                 /* Hardware Request Status Channel 24 */
    vuint32_t HRS23:1;                 /* Hardware Request Status Channel 23 */
    vuint32_t HRS22:1;                 /* Hardware Request Status Channel 22 */
    vuint32_t HRS21:1;                 /* Hardware Request Status Channel 21 */
    vuint32_t HRS20:1;                 /* Hardware Request Status Channel 20 */
    vuint32_t HRS19:1;                 /* Hardware Request Status Channel 19 */
    vuint32_t HRS18:1;                 /* Hardware Request Status Channel 18 */
    vuint32_t HRS17:1;                 /* Hardware Request Status Channel 17 */
    vuint32_t HRS16:1;                 /* Hardware Request Status Channel 16 */
    vuint32_t HRS15:1;                 /* Hardware Request Status Channel 15 */
    vuint32_t HRS14:1;                 /* Hardware Request Status Channel 14 */
    vuint32_t HRS13:1;                 /* Hardware Request Status Channel 13 */
    vuint32_t HRS12:1;                 /* Hardware Request Status Channel 12 */
    vuint32_t HRS11:1;                 /* Hardware Request Status Channel 11 */
    vuint32_t HRS10:1;                 /* Hardware Request Status Channel 10 */
    vuint32_t HRS9:1;                  /* Hardware Request Status Channel 9 */
    vuint32_t HRS8:1;                  /* Hardware Request Status Channel 8 */
    vuint32_t HRS7:1;                  /* Hardware Request Status Channel 7 */
    vuint32_t HRS6:1;                  /* Hardware Request Status Channel 6 */
    vuint32_t HRS5:1;                  /* Hardware Request Status Channel 5 */
    vuint32_t HRS4:1;                  /* Hardware Request Status Channel 4 */
    vuint32_t HRS3:1;                  /* Hardware Request Status Channel 3 */
    vuint32_t HRS2:1;                  /* Hardware Request Status Channel 2 */
    vuint32_t HRS1:1;                  /* Hardware Request Status Channel 1 */
    vuint32_t HRS0:1;                  /* Hardware Request Status Channel 0 */
  } B;
} DMA_HRS_tag;

typedef union DMA_DCHPRI_union_tag {   /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t GRPPRI:2;                 /* Channel n Current Group Priority */
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
  } B;
} DMA_DCHPRI_tag;

typedef union DMA_DCHMID_union_tag {   /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t EMI:1;                    /* Enable Master ID replication */
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t _unused_4:2;
    vuint8_t MID:4;                    /* Master ID */
  } B;
} DMA_DCHMID_tag;

typedef union DMA_TCD_SADDR_union_tag { /* TCD Source Address */
  vuint32_t R;
  struct {
    vuint32_t SADDR:32;                /* Source Address */
  } B;
} DMA_TCD_SADDR_tag;

typedef union DMA_TCD_ATTR_union_tag { /* TCD Transfer Attributes */
  vuint16_t R;
  struct {
    vuint16_t SMOD:5;                  /* Source Address Modulo */
    vuint16_t SSIZE:3;                 /* Source data transfer size */
    vuint16_t DMOD:5;                  /* Destination Address Modulo */
    vuint16_t DSIZE:3;                 /* Destination data transfer size */
  } B;
} DMA_TCD_ATTR_tag;

typedef union DMA_TCD_SOFF_union_tag { /* TCD Signed Source Address Offset */
  vuint16_t R;
  struct {
    vuint16_t SOFF:16;                 /* Source address signed offset */
  } B;
} DMA_TCD_SOFF_tag;

typedef union DMA_TCD_NBYTES_MLNO_union_tag { /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:32;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFNO_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t NBYTES:30;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLOFFNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFYES_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t MLOFF:20;                /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
    vuint32_t NBYTES:10;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLOFFYES_tag;

typedef union DMA_TCD_NBYTES_union_tag {
  DMA_TCD_NBYTES_MLNO_tag MLNO;        /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  DMA_TCD_NBYTES_MLOFFNO_tag MLOFFNO;  /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  DMA_TCD_NBYTES_MLOFFYES_tag MLOFFYES; /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
} DMA_TCD_NBYTES_tag;

typedef union DMA_TCD_SLAST_union_tag { /* TCD Last Source Address Adjustment */
  vuint32_t R;
  struct {
    vuint32_t SLAST:32;                /* Last Source Address Adjustment */
  } B;
} DMA_TCD_SLAST_tag;

typedef union DMA_TCD_DADDR_union_tag { /* TCD Destination Address */
  vuint32_t R;
  struct {
    vuint32_t DADDR:32;                /* Destination Address */
  } B;
} DMA_TCD_DADDR_tag;

typedef union DMA_TCD_CITER_ELINKNO_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
    vuint16_t CITER:15;                /* Current Major Iteration Count */
  } B;
} DMA_TCD_CITER_ELINKNO_tag;

typedef union DMA_TCD_CITER_ELINKYES_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
    vuint16_t _unused_14:1;
    vuint16_t LINKCH:5;                /* Minor Loop Link Channel Number */
    vuint16_t CITER:9;                 /* Current Major Iteration Count */
  } B;
} DMA_TCD_CITER_ELINKYES_tag;

typedef union DMA_TCD_CITER_union_tag {
  DMA_TCD_CITER_ELINKNO_tag ELINKNO;   /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_CITER_ELINKYES_tag ELINKYES; /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_CITER_tag;

typedef union DMA_TCD_DOFF_union_tag { /* TCD Signed Destination Address Offset */
  vuint16_t R;
  struct {
    vuint16_t DOFF:16;                 /* Destination Address Signed Offset */
  } B;
} DMA_TCD_DOFF_tag;

typedef union DMA_TCD_DLASTSGA_union_tag { /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  vuint32_t R;
  struct {
    vuint32_t DLASTSGA:32;
  } B;
} DMA_TCD_DLASTSGA_tag;

typedef union DMA_TCD_BITER_ELINKNO_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
    vuint16_t BITER:15;                /* Starting Major Iteration Count */
  } B;
} DMA_TCD_BITER_ELINKNO_tag;

typedef union DMA_TCD_BITER_ELINKYES_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
    vuint16_t _unused_14:1;
    vuint16_t LINKCH:5;                /* Link Channel Number */
    vuint16_t BITER:9;                 /* Starting major iteration count */
  } B;
} DMA_TCD_BITER_ELINKYES_tag;

typedef union DMA_TCD_BITER_union_tag {
  DMA_TCD_BITER_ELINKNO_tag ELINKNO;   /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_BITER_ELINKYES_tag ELINKYES; /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_BITER_tag;

typedef union DMA_TCD_CSR_union_tag {  /* TCD Control and Status */
  vuint16_t R;
  struct {
    vuint16_t BWC:2;                   /* Bandwidth Control */
    vuint16_t _unused_13:1;
    vuint16_t MAJORLINKCH:5;           /* Major Loop Link Channel Number */
    vuint16_t DONE:1;                  /* Channel Done */
    vuint16_t ACTIVE:1;                /* Channel Active */
    vuint16_t MAJORELINK:1;            /* Enable channel-to-channel linking on major loop complete */
    vuint16_t ESG:1;                   /* Enable Scatter/Gather Processing */
    vuint16_t DREQ:1;                  /* Disable Request */
    vuint16_t INTHALF:1;               /* Enable an interrupt when major counter is half complete. */
    vuint16_t INTMAJOR:1;              /* Enable an interrupt when major iteration count completes. */
    vuint16_t START:1;                 /* Channel Start */
  } B;
} DMA_TCD_CSR_tag;

typedef struct DMA_TCD_struct_tag {
  DMA_TCD_SADDR_tag SADDR;             /* TCD Source Address */
  DMA_TCD_ATTR_tag ATTR;               /* TCD Transfer Attributes */
  DMA_TCD_SOFF_tag SOFF;               /* TCD Signed Source Address Offset */
  DMA_TCD_NBYTES_tag NBYTES;
  DMA_TCD_SLAST_tag SLAST;             /* TCD Last Source Address Adjustment */
  DMA_TCD_DADDR_tag DADDR;             /* TCD Destination Address */
  DMA_TCD_CITER_tag CITER;
  DMA_TCD_DOFF_tag DOFF;               /* TCD Signed Destination Address Offset */
  DMA_TCD_DLASTSGA_tag DLASTSGA;       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  DMA_TCD_BITER_tag BITER;
  DMA_TCD_CSR_tag CSR;                 /* TCD Control and Status */
} DMA_TCD_tag;

struct DMA_tag {
  DMA_CR_tag CR;                       /* Control Register */
  DMA_ES_tag ES;                       /* Error Status Register */
  uint8_t DMA_reserved0[4];
  DMA_ERQ_tag ERQ;                     /* Enable Request Register */
  uint8_t DMA_reserved1[4];
  DMA_EEI_tag EEI;                     /* Enable Error Interrupt Register */
  DMA_SERQ_tag SERQ;                   /* Set Enable Request Register */
  DMA_CERQ_tag CERQ;                   /* Clear Enable Request Register */
  DMA_SEEI_tag SEEI;                   /* Set Enable Error Interrupt Register */
  DMA_CEEI_tag CEEI;                   /* Clear Enable Error Interrupt Register */
  DMA_CINT_tag CINT;                   /* Clear Interrupt Request Register */
  DMA_CERR_tag CERR;                   /* Clear Error Register */
  DMA_SSRT_tag SSRT;                   /* Set START Bit Register */
  DMA_CDNE_tag CDNE;                   /* Clear DONE Status Bit Register */
  uint8_t DMA_reserved2[4];
  DMA_INT_tag INT;                     /* Interrupt Request Register */
  uint8_t DMA_reserved3[4];
  DMA_ERR_tag ERR;                     /* Error Register */
  uint8_t DMA_reserved4[4];
  DMA_HRS_tag HRS;                     /* Hardware Request Status Register */
  uint8_t DMA_reserved5[200];
  DMA_DCHPRI_tag DCHPRI[32];           /* Channel n Priority Register */
  uint8_t DMA_reserved6[32];
  DMA_DCHMID_tag DCHMID[32];           /* Channel n Master ID Register */
  uint8_t DMA_reserved7[3744];
  DMA_TCD_tag TCD[32];
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

typedef union DMAMUX_CHCFG_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
  } B;
} DMAMUX_CHCFG_tag;

struct DMAMUX_tag {
  DMAMUX_CHCFG_tag CHCFG[16];          /* Channel Configuration register */
};


/* ============================================================================
   =============================== Module: DSPI ===============================
   ============================================================================ */

typedef union DSPI_MCR_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTR:1;                  /* Master/Slave Mode Select */
    vuint32_t CONT_SCKE:1;             /* Continuous SCK Enable */
    vuint32_t DCONF:2;                 /* Interface Configuration */
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t MTFE:1;                  /* Modified Transfer Format Enable */
    vuint32_t PCSSE:1;                 /* Peripheral Chip Select Strobe Enable */
    vuint32_t ROOE:1;                  /* Receive FIFO Overflow Overwrite Enable */
    vuint32_t _unused_22:2;            /* Always write the reset value to this field. */
    vuint32_t PCSIS:6;                 /* Peripheral Chip Select x Inactive State */
    vuint32_t _unused_15:1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t DIS_TXF:1;               /* Disable Transmit FIFO */
    vuint32_t DIS_RXF:1;               /* Disable Receive FIFO */
    vuint32_t CLR_TXF:1;               /* Clear TX FIFO */
    vuint32_t CLR_RXF:1;               /* CLR_RXF */
    vuint32_t SMPL_PT:2;               /* Sample Point */
    vuint32_t _unused_4:4;
    vuint32_t XSPI:1;                  /* Extended SPI Mode */
    vuint32_t FCPCS:1;                 /* Fast Continuous PCS Mode. */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t HALT:1;                  /* Halt */
  } B;
} DSPI_MCR_tag;

typedef union DSPI_TCR_union_tag {     /* Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t SPI_TCNT:16;             /* SPI Transfer Counter */
    vuint32_t _unused_0:16;
  } B;
} DSPI_TCR_tag;

typedef union DSPI_MODE_CTAR_union_tag { /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t DBR:1;                   /* Double Baud Rate */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t BR:4;                    /* Baud Rate Scaler */
  } B;
} DSPI_MODE_CTAR_tag;

typedef union DSPI_MODE_CTAR_SLAVE_union_tag { /* Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t FMSZ:5;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t FMSZ5:1;                 /* MSB of Frame Size when DSI is used in 64-bit Mode */
    vuint32_t _unused_0:22;
  } B;
} DSPI_MODE_CTAR_SLAVE_tag;

typedef union DSPI_MODE_union_tag {
  DSPI_MODE_CTAR_tag CTAR[6];          /* Clock and Transfer Attributes Register (In Master Mode) */
  DSPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[2]; /* Clock and Transfer Attributes Register (In Slave Mode) */
} DSPI_MODE_tag;

typedef union DSPI_SR_union_tag {      /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t TCF:1;                   /* Transfer Complete Flag */
    vuint32_t TXRXS:1;                 /* TX and RX Status */
    vuint32_t SPITCF:1;                /* SPI Frame Transfer Complete Flag. */
    vuint32_t EOQF:1;                  /* End of Queue Flag */
    vuint32_t TFUF:1;                  /* Transmit FIFO Underflow Flag */
    vuint32_t DSITCF:1;                /* DSI Frame Transfer Complete Flag. */
    vuint32_t TFFF:1;                  /* Transmit FIFO Fill Flag */
    vuint32_t BSYF:1;                  /* Busy Flag. */
    vuint32_t CMDTCF:1;                /* Command Transfer Complete Flag. */
    vuint32_t DPEF:1;                  /* DSI Parity Error Flag */
    vuint32_t SPEF:1;                  /* SPI Parity Error Flag */
    vuint32_t DDIF:1;                  /* DSI Data Received with Active Bits */
    vuint32_t RFOF:1;                  /* Receive FIFO Overflow Flag */
    vuint32_t TFIWF:1;                 /* Tranmit FIFO Invalid Write Flag */
    vuint32_t RFDF:1;                  /* Receive FIFO Drain Flag */
    vuint32_t CMDFFF:1;                /* Command FIFO Fill Flag */
    vuint32_t TXCTR:4;                 /* TX FIFO Counter */
    vuint32_t TXNXTPTR:4;              /* Transmit Next Pointer */
    vuint32_t RXCTR:4;                 /* RX FIFO Counter */
    vuint32_t POPNXTPTR:4;             /* Pop Next Pointer */
  } B;
} DSPI_SR_tag;

typedef union DSPI_RSER_union_tag {    /* DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TCF_RE:1;                /* Transmission Complete Request Enable */
    vuint32_t CMDFFF_RE:1;             /* Command FIFO Fill Flag Request Enable. */
    vuint32_t SPITCF_RE:1;             /* SPI Frame Transmission Complete Request Enable. */
    vuint32_t EOQF_RE:1;               /* Finished Request Enable */
    vuint32_t TFUF_RE:1;               /* Transmit FIFO Underflow Request Enable */
    vuint32_t DSITCF_RE:1;             /* DSI Frame Transmission Complete Request Enable. */
    vuint32_t TFFF_RE:1;               /* Transmit FIFO Fill Request Enable */
    vuint32_t TFFF_DIRS:1;             /* Transmit FIFO Fill DMA or Interrupt Request Select */
    vuint32_t CMDTCF_RE:1;             /* Command Transmission Complete Request Enable. */
    vuint32_t DPEF_RE:1;               /* DSI Parity Error Request Enable */
    vuint32_t SPEF_RE:1;               /* SPI Parity Error Request Enable */
    vuint32_t DDIF_RE:1;               /* DSI data received with active bits Request Enable */
    vuint32_t RFOF_RE:1;               /* Receive FIFO Overflow Request Enable */
    vuint32_t TFIWF_RE:1;              /* Transmit FIFO Invalid Write Request Enable. */
    vuint32_t RFDF_RE:1;               /* Receive FIFO Drain Request Enable */
    vuint32_t RFDF_DIRS:1;             /* Receive FIFO Drain DMA or Interrupt Request Select */
    vuint32_t CMDFFF_DIRS:1;           /* Command FIFO Fill DMA or Interrupt Request Select */
    vuint32_t DDIF_DIRS:1;             /* DSI data received with active bits - DMA or Interrupt Request Select. */
    vuint32_t _unused_0:14;
  } B;
} DSPI_RSER_tag;

typedef union DSPI_PUSHR_PUSHR_union_tag { /* PUSH TX FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t CONT:1;                  /* Continuous Peripheral Chip Select Enable */
    vuint32_t CTAS:3;                  /* Clock and Transfer Attributes Select */
    vuint32_t EOQ:1;                   /* End Of Queue */
    vuint32_t CTCNT:1;                 /* Clear Transfer Counter */
    vuint32_t PE_MASC:1;               /* Parity Enable or Mask T ASC delay in the current frame */
    vuint32_t PP_MCSC:1;               /* Parity Polarity or Mask T CSC delay in the next frame */
    vuint32_t _unused_22:2;            /* Always write the reset value to this field. */
    vuint32_t PCS:6;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_PUSHR_PUSHR_tag;

typedef union DSPI_PUSHR_PUSHR_SLAVE_union_tag { /* PUSH TX FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_PUSHR_PUSHR_SLAVE_tag;

typedef union DSPI_PUSHR_union_tag {
  DSPI_PUSHR_PUSHR_tag PUSHR;          /* PUSH TX FIFO Register In Master Mode */
  DSPI_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* PUSH TX FIFO Register In Slave Mode */
} DSPI_PUSHR_tag;

typedef union DSPI_POPR_union_tag {    /* POP RX FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Received Data */
  } B;
} DSPI_POPR_tag;

typedef union DSPI_TXFR_union_tag {    /* Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXCMD_TXDATA:16;         /* Transmit Command or Transmit Data */
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_TXFR_tag;

typedef union DSPI_RXFR_union_tag {    /* Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Receive Data */
  } B;
} DSPI_RXFR_tag;

typedef union DSPI_DSICR0_union_tag {  /* DSI Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MTOE:1;                  /* Multiple Transfer Operation Enable */
    vuint32_t FMSZ4:1;                 /* MSB of the frame size in master mode. */
    vuint32_t MTOCNT:6;                /* Multiple Transfer Operation Count */
    vuint32_t FMSZ5:1;                 /* MSB of the frame size in master mode when DSI is used in 64-bit mode. */
    vuint32_t _unused_21:2;
    vuint32_t _unused_20:1;
    vuint32_t TXSS:1;                  /* Transmit Data Source Select. */
    vuint32_t TPOL:1;                  /* Trigger Polarity */
    vuint32_t TRRE:1;                  /* Trigger Reception Enable */
    vuint32_t CID:1;                   /* Change In Data Transfer Enable */
    vuint32_t DCONT:1;                 /* DSI Continuous Peripheral Chip Select Enable */
    vuint32_t DSICTAS:3;               /* DSI Clock and Transfer Attributes Select */
    vuint32_t DMS:1;                   /* Data Match Stop */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t DPCSx:8;                 /* DSI Peripheral Chip Select 0-7 */
  } B;
} DSPI_DSICR0_tag;

typedef union DSPI_SDR0_union_tag {    /* DSI Serialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t SER_DATA:32;             /* Serialized Data */
  } B;
} DSPI_SDR0_tag;

typedef union DSPI_ASDR0_union_tag {   /* DSI Alternate Serialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t ASER_DATA:32;            /* Alternate Serialized Data */
  } B;
} DSPI_ASDR0_tag;

typedef union DSPI_COMPR0_union_tag {  /* DSI Transmit Comparison Register 0 */
  vuint32_t R;
  struct {
    vuint32_t COMP_DATA:32;            /* Compare Data */
  } B;
} DSPI_COMPR0_tag;

typedef union DSPI_DDR0_union_tag {    /* DSI Deserialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DESER_DATA:32;           /* Deserialized Data */
  } B;
} DSPI_DDR0_tag;

typedef union DSPI_DSICR1_union_tag {  /* DSI Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t _unused_24:6;
    vuint32_t _unused_21:3;
    vuint32_t CSI_PRTY:1;              /* CSI Priority */
    vuint32_t _unused_19:1;
    vuint32_t DSI64E:1;                /* DSI 64-bit Mode Enable */
    vuint32_t _unused_16:2;
    vuint32_t _unused_8:8;
    vuint32_t _unused_0:8;
  } B;
} DSPI_DSICR1_tag;

typedef union DSPI_SSR0_union_tag {    /* DSI Serialization Source Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t SS:32;                   /* Source Select */
  } B;
} DSPI_SSR0_tag;

typedef union DSPI_PISR0_union_tag {   /* DSI Parallel Input Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IPS7:4;                  /* Input Pin Select 7 */
    vuint32_t IPS6:4;                  /* Input Pin Select 6 */
    vuint32_t IPS5:4;                  /* Input Pin Select 5 */
    vuint32_t IPS4:4;                  /* Input Pin Select 5 */
    vuint32_t IPS3:4;                  /* Input Pin Select 3 */
    vuint32_t IPS2:4;                  /* Input Pin Select 2 */
    vuint32_t IPS1:4;                  /* Input Pin Select 1 */
    vuint32_t IPS0:4;                  /* Input Pin Select 0 */
  } B;
} DSPI_PISR0_tag;

typedef union DSPI_PISR1_union_tag {   /* DSI Parallel Input Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t IPS15:4;                 /* Input Pin Select 15 */
    vuint32_t IPS14:4;                 /* Input Pin Select 14 */
    vuint32_t IPS13:4;                 /* Input Pin Select 13 */
    vuint32_t IPS12:4;                 /* Input Pin Select 12 */
    vuint32_t IPS11:4;                 /* Input Pin Select 11 */
    vuint32_t IPS10:4;                 /* Input Pin Select 10 */
    vuint32_t IPS9:4;                  /* Input Pin Select 9 */
    vuint32_t IPS8:4;                  /* Input Pin Select 8 */
  } B;
} DSPI_PISR1_tag;

typedef union DSPI_PISR2_union_tag {   /* DSI Parallel Input Select Register 2 */
  vuint32_t R;
  struct {
    vuint32_t IPS23:4;                 /* Input Pin Select 23 */
    vuint32_t IPS22:4;                 /* Input Pin Select 22 */
    vuint32_t IPS21:4;                 /* Input Pin Select 21 */
    vuint32_t IPS20:4;                 /* Input Pin Select 20 */
    vuint32_t IPS19:4;                 /* Input Pin Select 19 */
    vuint32_t IPS18:4;                 /* Input Pin Select 18 */
    vuint32_t IPS17:4;                 /* Input Pin Select 17 */
    vuint32_t IPS16:4;                 /* Input Pin Select 16 */
  } B;
} DSPI_PISR2_tag;

typedef union DSPI_PISR3_union_tag {   /* DSI Parallel Input Select Register 3 */
  vuint32_t R;
  struct {
    vuint32_t IPS31:4;                 /* Input Pin Select 31 */
    vuint32_t IPS30:4;                 /* Input Pin Select 30 */
    vuint32_t IPS29:4;                 /* Input Pin Select 29 */
    vuint32_t IPS28:4;                 /* Input Pin Select 28 */
    vuint32_t IPS27:4;                 /* Input Pin Select 27 */
    vuint32_t IPS26:4;                 /* Input Pin Select 26 */
    vuint32_t IPS25:4;                 /* Input Pin Select 25 */
    vuint32_t IPS24:4;                 /* Input Pin Select 24 */
  } B;
} DSPI_PISR3_tag;

typedef union DSPI_DIMR0_union_tag {   /* DSI Deserialized Data Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MASK:32;                 /* Mask */
  } B;
} DSPI_DIMR0_tag;

typedef union DSPI_DPIR0_union_tag {   /* DSI Deserialized Data Polarity Interrupt Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DP:32;                   /* Data Polarity */
  } B;
} DSPI_DPIR0_tag;

typedef union DSPI_SDR1_union_tag {    /* DSI Serialization Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t SER_DATA:32;             /* Serialized Data */
  } B;
} DSPI_SDR1_tag;

typedef union DSPI_ASDR1_union_tag {   /* DSI Alternate Serialization Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t ASER_DATA:32;            /* Alternate Serialized Data */
  } B;
} DSPI_ASDR1_tag;

typedef union DSPI_COMPR1_union_tag {  /* DSI Transmit Comparison Register 1 */
  vuint32_t R;
  struct {
    vuint32_t COMP_DATA:32;            /* Compare Data */
  } B;
} DSPI_COMPR1_tag;

typedef union DSPI_DDR1_union_tag {    /* DSI Deserialization Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DESER_DATA:32;           /* Deserialized Data */
  } B;
} DSPI_DDR1_tag;

typedef union DSPI_SSR1_union_tag {    /* DSI Serialization Source Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t SS:32;                   /* Source Select */
  } B;
} DSPI_SSR1_tag;

typedef union DSPI_PISR4_union_tag {   /* DSI Parallel Input Select Register 4 */
  vuint32_t R;
  struct {
    vuint32_t IPS39:4;                 /* Input Pin Select 39 */
    vuint32_t IPS38:4;                 /* Input Pin Select 38 */
    vuint32_t IPS37:4;                 /* Input Pin Select 37 */
    vuint32_t IPS36:4;                 /* Input Pin Select 36 */
    vuint32_t IPS35:4;                 /* Input Pin Select 35 */
    vuint32_t IPS34:4;                 /* Input Pin Select 34 */
    vuint32_t IPS33:4;                 /* Input Pin Select 33 */
    vuint32_t IPS32:4;                 /* Input Pin Select 32 */
  } B;
} DSPI_PISR4_tag;

typedef union DSPI_PISR5_union_tag {   /* DSI Parallel Input Select Register 5 */
  vuint32_t R;
  struct {
    vuint32_t IPS47:4;                 /* Input Pin Select 47 */
    vuint32_t IPS46:4;                 /* Input Pin Select 46 */
    vuint32_t IPS45:4;                 /* Input Pin Select 45 */
    vuint32_t IPS44:4;                 /* Input Pin Select 44 */
    vuint32_t IPS43:4;                 /* Input Pin Select 43 */
    vuint32_t IPS42:4;                 /* Input Pin Select 42 */
    vuint32_t IPS41:4;                 /* Input Pin Select 41 */
    vuint32_t IPS40:4;                 /* Input Pin Select 40 */
  } B;
} DSPI_PISR5_tag;

typedef union DSPI_PISR6_union_tag {   /* DSI Parallel Input Select Register 6 */
  vuint32_t R;
  struct {
    vuint32_t IPS55:4;                 /* Input Pin Select 55 */
    vuint32_t IPS54:4;                 /* Input Pin Select 54 */
    vuint32_t IPS53:4;                 /* Input Pin Select 53 */
    vuint32_t IPS52:4;                 /* Input Pin Select 52 */
    vuint32_t IPS51:4;                 /* Input Pin Select 51 */
    vuint32_t IPS50:4;                 /* Input Pin Select 50 */
    vuint32_t IPS49:4;                 /* Input Pin Select 49 */
    vuint32_t IPS48:4;                 /* Input Pin Select 48 */
  } B;
} DSPI_PISR6_tag;

typedef union DSPI_PISR7_union_tag {   /* DSI Parallel Input Select Register 7 */
  vuint32_t R;
  struct {
    vuint32_t IPS63:4;                 /* Input Pin Select 63 */
    vuint32_t IPS62:4;                 /* Input Pin Select 62 */
    vuint32_t IPS61:4;                 /* Input Pin Select 61 */
    vuint32_t IPS60:4;                 /* Input Pin Select 60 */
    vuint32_t IPS59:4;                 /* Input Pin Select 59 */
    vuint32_t IPS58:4;                 /* Input Pin Select 58 */
    vuint32_t IPS57:4;                 /* Input Pin Select 57 */
    vuint32_t IPS56:4;                 /* Input Pin Select 56 */
  } B;
} DSPI_PISR7_tag;

typedef union DSPI_DIMR1_union_tag {   /* DSI Deserialized Data Interrupt Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MASK:32;                 /* Mask */
  } B;
} DSPI_DIMR1_tag;

typedef union DSPI_DPIR1_union_tag {   /* DSI Deserialized Data Polarity Interrupt Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DP:32;                   /* Data Polarity */
  } B;
} DSPI_DPIR1_tag;

typedef union DSPI_CTARE_union_tag {   /* Clock and Transfer Attributes Register Extended */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t FMSZE:1;                 /* Frame Size Extended */
    vuint32_t _unused_11:5;
    vuint32_t DTCP:11;                 /* Data Transfer Count Preload */
  } B;
} DSPI_CTARE_tag;

typedef union DSPI_SREX_union_tag {    /* Status Register Extended */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t RXCTR4:1;                /* RX FIFO Counter[4] */
    vuint32_t _unused_12:2;
    vuint32_t TXCTR4:1;                /* TX FIFO Counter[4] */
    vuint32_t _unused_9:2;
    vuint32_t CMDCTR:5;                /* CMD FIFO Counter */
    vuint32_t CMDNXTPTR:4;             /* Command Next Pointer */
  } B;
} DSPI_SREX_tag;

typedef union DSPI_TRIG_union_tag {    /* Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;                /* Trigger Register Enable */
    vuint32_t _unused_4:27;
    vuint32_t _unused_3:1;
    vuint32_t ASDR_WT:1;               /* ASDR Write Trigger Enable */
    vuint32_t CID:1;                   /* Change In Data Transfer Enable */
    vuint32_t TRRE:1;                  /* Trigger Reception Enable */
  } B;
} DSPI_TRIG_tag;

struct DSPI_tag {
  DSPI_MCR_tag MCR;                    /* Module Configuration Register */
  uint8_t DSPI_reserved0[4];
  DSPI_TCR_tag TCR;                    /* Transfer Count Register */
  DSPI_MODE_tag MODE;
  uint8_t DSPI_reserved1[8];
  DSPI_SR_tag SR;                      /* Status Register */
  DSPI_RSER_tag RSER;                  /* DMA/Interrupt Request Select and Enable Register */
  DSPI_PUSHR_tag PUSHR;
  DSPI_POPR_tag POPR;                  /* POP RX FIFO Register */
  DSPI_TXFR_tag TXFR[4];               /* Transmit FIFO Registers */
  uint8_t DSPI_reserved2[48];
  DSPI_RXFR_tag RXFR[4];               /* Receive FIFO Registers */
  uint8_t DSPI_reserved3[48];
  DSPI_DSICR0_tag DSICR0;              /* DSI Configuration Register 0 */
  DSPI_SDR0_tag SDR0;                  /* DSI Serialization Data Register 0 */
  DSPI_ASDR0_tag ASDR0;                /* DSI Alternate Serialization Data Register 0 */
  DSPI_COMPR0_tag COMPR0;              /* DSI Transmit Comparison Register 0 */
  DSPI_DDR0_tag DDR0;                  /* DSI Deserialization Data Register 0 */
  DSPI_DSICR1_tag DSICR1;              /* DSI Configuration Register 1 */
  DSPI_SSR0_tag SSR0;                  /* DSI Serialization Source Select Register 0 */
  DSPI_PISR0_tag PISR0;                /* DSI Parallel Input Select Register 0 */
  DSPI_PISR1_tag PISR1;                /* DSI Parallel Input Select Register 1 */
  DSPI_PISR2_tag PISR2;                /* DSI Parallel Input Select Register 2 */
  DSPI_PISR3_tag PISR3;                /* DSI Parallel Input Select Register 3 */
  DSPI_DIMR0_tag DIMR0;                /* DSI Deserialized Data Interrupt Mask Register 0 */
  DSPI_DPIR0_tag DPIR0;                /* DSI Deserialized Data Polarity Interrupt Register 0 */
  DSPI_SDR1_tag SDR1;                  /* DSI Serialization Data Register 1 */
  DSPI_ASDR1_tag ASDR1;                /* DSI Alternate Serialization Data Register 1 */
  DSPI_COMPR1_tag COMPR1;              /* DSI Transmit Comparison Register 1 */
  DSPI_DDR1_tag DDR1;                  /* DSI Deserialization Data Register 1 */
  DSPI_SSR1_tag SSR1;                  /* DSI Serialization Source Select Register 1 */
  DSPI_PISR4_tag PISR4;                /* DSI Parallel Input Select Register 4 */
  DSPI_PISR5_tag PISR5;                /* DSI Parallel Input Select Register 5 */
  DSPI_PISR6_tag PISR6;                /* DSI Parallel Input Select Register 6 */
  DSPI_PISR7_tag PISR7;                /* DSI Parallel Input Select Register 7 */
  DSPI_DIMR1_tag DIMR1;                /* DSI Deserialized Data Interrupt Mask Register 1 */
  DSPI_DPIR1_tag DPIR1;                /* DSI Deserialized Data Polarity Interrupt Register 1 */
  DSPI_CTARE_tag CTARE[6];             /* Clock and Transfer Attributes Register Extended */
  uint8_t DSPI_reserved4[8];
  DSPI_SREX_tag SREX;                  /* Status Register Extended */
  DSPI_TRIG_tag TRIG;                  /* Trigger Register */
};


/* ============================================================================
   =============================== Module: ENET ===============================
   ============================================================================ */

typedef union ENET_EIR_union_tag {     /* Interrupt Event Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t BABR:1;                  /* Babbling Receive Error */
    vuint32_t BABT:1;                  /* Babbling Transmit Error */
    vuint32_t GRA:1;                   /* Graceful Stop Complete */
    vuint32_t TXF:1;                   /* Transmit Frame Interrupt */
    vuint32_t TXB:1;                   /* Transmit Buffer Interrupt */
    vuint32_t RXF:1;                   /* Receive Frame Interrupt */
    vuint32_t RXB:1;                   /* Receive Buffer Interrupt */
    vuint32_t MII:1;                   /* MII Interrupt. */
    vuint32_t EBERR:1;                 /* Ethernet Bus Error */
    vuint32_t LC:1;                    /* Late Collision */
    vuint32_t RL:1;                    /* Collision Retry Limit */
    vuint32_t UN:1;                    /* Transmit FIFO Underrun */
    vuint32_t PLR:1;                   /* Payload Receive Error */
    vuint32_t WAKEUP:1;                /* Node Wakeup Request Indication */
    vuint32_t TS_AVAIL:1;              /* Transmit Timestamp Available */
    vuint32_t TS_TIMER:1;              /* Timestamp Timer */
    vuint32_t RXFLUSH_2:1;
    vuint32_t RXFLUSH_1:1;
    vuint32_t RXFLUSH_0:1;
    vuint32_t _unused_11:1;
    vuint32_t PARSERR:1;
    vuint32_t PARSRF:1;
    vuint32_t _unused_8:1;
    vuint32_t TXF2:1;                  /* Transmit frame interrupt, class 2 */
    vuint32_t TXB2:1;                  /* Transmit buffer interrupt, class 2 */
    vuint32_t RXF2:1;                  /* Receive frame interrupt, class 2 */
    vuint32_t RXB2:1;                  /* Receive buffer interrupt, class 2 */
    vuint32_t TXF1:1;                  /* Transmit frame interrupt, class 1 */
    vuint32_t TXB1:1;                  /* Transmit buffer interrupt, class 1 */
    vuint32_t RXF1:1;                  /* Receive frame interrupt, class 1 */
    vuint32_t RXB1:1;                  /* Receive buffer interrupt, class 1 */
  } B;
} ENET_EIR_tag;

typedef union ENET_EIMR_union_tag {    /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t BABR:1;                  /* BABR Interrupt Mask */
    vuint32_t BABT:1;                  /* BABT Interrupt Mask */
    vuint32_t GRA:1;                   /* GRA Interrupt Mask */
    vuint32_t TXF:1;                   /* TXF Interrupt Mask */
    vuint32_t TXB:1;                   /* TXB Interrupt Mask */
    vuint32_t RXF:1;                   /* RXF Interrupt Mask */
    vuint32_t RXB:1;                   /* RXB Interrupt Mask */
    vuint32_t MII:1;                   /* MII Interrupt Mask */
    vuint32_t EBERR:1;                 /* EBERR Interrupt Mask */
    vuint32_t LC:1;                    /* LC Interrupt Mask */
    vuint32_t RL:1;                    /* RL Interrupt Mask */
    vuint32_t UN:1;                    /* UN Interrupt Mask */
    vuint32_t PLR:1;                   /* PLR Interrupt Mask */
    vuint32_t WAKEUP:1;                /* WAKEUP Interrupt Mask */
    vuint32_t TS_AVAIL:1;              /* TS_AVAIL Interrupt Mask */
    vuint32_t TS_TIMER:1;              /* TS_TIMER Interrupt Mask */
    vuint32_t RXFLUSH_2:1;
    vuint32_t RXFLUSH_1:1;
    vuint32_t RXFLUSH_0:1;
    vuint32_t _unused_11:1;
    vuint32_t PARSERR:1;
    vuint32_t PARSRF:1;
    vuint32_t _unused_8:1;
    vuint32_t TXF2:1;                  /* Transmit frame interrupt, class 2 */
    vuint32_t TXB2:1;                  /* Transmit buffer interrupt, class 2 */
    vuint32_t RXF2:1;                  /* Receive frame interrupt, class 2 */
    vuint32_t RXB2:1;                  /* Receive buffer interrupt, class 2 */
    vuint32_t TXF1:1;                  /* Transmit frame interrupt, class 1 */
    vuint32_t TXB1:1;                  /* Transmit buffer interrupt, class 1 */
    vuint32_t RXF1:1;                  /* Receive frame interrupt, class 1 */
    vuint32_t RXB1:1;                  /* Receive buffer interrupt, class 1 */
  } B;
} ENET_EIMR_tag;

typedef union ENET_RDAR_union_tag {    /* Receive Descriptor Active Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_RDAR_tag;

typedef union ENET_TDAR_union_tag {    /* Transmit Descriptor Active Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_TDAR_tag;

typedef union ENET_ECR_union_tag {     /* Ethernet Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t _unused_12:6;
    vuint32_t SVLANDBL:1;              /* S-VLAN double tag */
    vuint32_t VLANUSE2ND:1;            /* VLAN use second tag */
    vuint32_t SVLANEN:1;               /* S-VLAN enable */
    vuint32_t DBSWP:1;                 /* Descriptor Byte Swapping Enable */
    vuint32_t _unused_7:1;
    vuint32_t DBGEN:1;                 /* Debug Enable */
    vuint32_t _unused_5:1;
    vuint32_t EN1588:1;                /* EN1588 Enable */
    vuint32_t SLEEP:1;                 /* Sleep Mode Enable */
    vuint32_t MAGICEN:1;               /* Magic Packet Detection Enable */
    vuint32_t ETHEREN:1;               /* Ethernet Enable */
    vuint32_t RESET:1;                 /* Ethernet MAC Reset */
  } B;
} ENET_ECR_tag;

typedef union ENET_MMFR_union_tag {    /* MII Management Frame Register */
  vuint32_t R;
  struct {
    vuint32_t ST:2;                    /* Start Of Frame Delimiter */
    vuint32_t OP:2;                    /* Operation Code */
    vuint32_t PA:5;                    /* PHY Address */
    vuint32_t RA:5;                    /* Register Address */
    vuint32_t TA:2;                    /* Turn Around */
    vuint32_t DATA:16;                 /* Management Frame Data */
  } B;
} ENET_MMFR_tag;

typedef union ENET_MSCR_union_tag {    /* MII Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t HOLDTIME:3;              /* Hold time On MDIO Output */
    vuint32_t DIS_PRE:1;               /* Disable Preamble */
    vuint32_t MII_SPEED:6;             /* MII Speed */
    vuint32_t _unused_0:1;
  } B;
} ENET_MSCR_tag;

typedef union ENET_MIBC_union_tag {    /* MIB Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIB_DIS:1;               /* Disable MIB Logic */
    vuint32_t MIB_IDLE:1;              /* MIB Idle */
    vuint32_t MIB_CLEAR:1;             /* MIB Clear */
    vuint32_t _unused_0:29;
  } B;
} ENET_MIBC_tag;

typedef union ENET_RCR_union_tag {     /* Receive Control Register */
  vuint32_t R;
  struct {
    vuint32_t GRS:1;                   /* Graceful Receive Stopped */
    vuint32_t NLC:1;                   /* Payload Length Check Disable */
    vuint32_t MAX_FL:14;               /* Maximum Frame Length */
    vuint32_t CFEN:1;                  /* MAC Control Frame Enable */
    vuint32_t CRCFWD:1;                /* Terminate/Forward Received CRC */
    vuint32_t PAUFWD:1;                /* Terminate/Forward Pause Frames */
    vuint32_t PADEN:1;                 /* Enable Frame Padding Remove On Receive */
    vuint32_t _unused_10:2;
    vuint32_t RMII_10T:1;
    vuint32_t RMII_MODE:1;             /* RMII Mode Enable */
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t FCE:1;                   /* Flow Control Enable */
    vuint32_t BC_REJ:1;                /* Broadcast Frame Reject */
    vuint32_t PROM:1;                  /* Promiscuous Mode */
    vuint32_t MII_MODE:1;              /* Media Independent Interface Mode */
    vuint32_t DRT:1;                   /* Disable Receive On Transmit */
    vuint32_t LOOP:1;                  /* Internal Loopback */
  } B;
} ENET_RCR_tag;

typedef union ENET_TCR_union_tag {     /* Transmit Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t _unused_10:1;
    vuint32_t CRCFWD:1;                /* Forward Frame From Application With CRC */
    vuint32_t ADDINS:1;                /* Set MAC Address On Transmit */
    vuint32_t ADDSEL:3;                /* Source MAC Address Select On Transmit */
    vuint32_t RFC_PAUSE:1;             /* Receive Frame Control Pause */
    vuint32_t TFC_PAUSE:1;             /* Transmit Frame Control Pause */
    vuint32_t FDEN:1;                  /* Full-Duplex Enable */
    vuint32_t _unused_1:1;
    vuint32_t GTS:1;                   /* Graceful Transmit Stop */
  } B;
} ENET_TCR_tag;

typedef union ENET_PALR_union_tag {    /* Physical Address Lower Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR1:32;               /* Pause Address */
  } B;
} ENET_PALR_tag;

typedef union ENET_PAUR_union_tag {    /* Physical Address Upper Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR2:16;
    vuint32_t TYPE:16;                 /* Type Field In PAUSE Frames */
  } B;
} ENET_PAUR_tag;

typedef union ENET_OPD_union_tag {     /* Opcode/Pause Duration Register */
  vuint32_t R;
  struct {
    vuint32_t OPCODE:16;               /* Opcode Field In PAUSE Frames */
    vuint32_t PAUSE_DUR:16;            /* Pause Duration */
  } B;
} ENET_OPD_tag;

typedef union ENET_TXIC_union_tag {    /* Transmit Interrupt Coalescing Register */
  vuint32_t R;
  struct {
    vuint32_t ICEN:1;                  /* Interrupt Coalescing Enable */
    vuint32_t ICCS:1;                  /* Interrupt Coalescing Timer Clock Source Select */
    vuint32_t _unused_28:2;            /* This field must be set to 0. */
    vuint32_t ICFT:8;                  /* Interrupt coalescing frame count threshold */
    vuint32_t _unused_16:4;            /* This field must be set to 0. */
    vuint32_t ICTT:16;                 /* Interrupt coalescing timer threshold */
  } B;
} ENET_TXIC_tag;

typedef union ENET_RXIC_union_tag {    /* Receive Interrupt Coalescing Register */
  vuint32_t R;
  struct {
    vuint32_t ICEN:1;                  /* Interrupt Coalescing Enable */
    vuint32_t ICCS:1;                  /* Interrupt Coalescing Timer Clock Source Select */
    vuint32_t _unused_28:2;            /* This field must be set to 0. */
    vuint32_t ICFT:8;                  /* Interrupt coalescing frame count threshold */
    vuint32_t _unused_16:4;            /* This field must be set to 0. */
    vuint32_t ICTT:16;                 /* Interrupt coalescing timer threshold */
  } B;
} ENET_RXIC_tag;

typedef union ENET_IAUR_union_tag {    /* Descriptor Individual Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR1:32;
  } B;
} ENET_IAUR_tag;

typedef union ENET_IALR_union_tag {    /* Descriptor Individual Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR2:32;
  } B;
} ENET_IALR_tag;

typedef union ENET_GAUR_union_tag {    /* Descriptor Group Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR1:32;
  } B;
} ENET_GAUR_tag;

typedef union ENET_GALR_union_tag {    /* Descriptor Group Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR2:32;
  } B;
} ENET_GALR_tag;

typedef union ENET_TFWR_union_tag {    /* Transmit FIFO Watermark Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t STRFWD:1;                /* Store And Forward Enable */
    vuint32_t _unused_6:2;
    vuint32_t TFWR:6;                  /* Transmit FIFO Write */
  } B;
} ENET_TFWR_tag;

typedef union ENET_RDSR1_union_tag {   /* Receive Descriptor Ring 1 Start Register */
  vuint32_t R;
  struct {
    vuint32_t R_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_RDSR1_tag;

typedef union ENET_TDSR1_union_tag {   /* Transmit Buffer Descriptor Ring 1 Start Register */
  vuint32_t R;
  struct {
    vuint32_t X_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_TDSR1_tag;

typedef union ENET_MRBR1_union_tag {   /* Maximum Receive Buffer Size Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t R_BUF_SIZE:7;
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
  } B;
} ENET_MRBR1_tag;

typedef union ENET_RDSR2_union_tag {   /* Receive Descriptor Ring 2 Start Register */
  vuint32_t R;
  struct {
    vuint32_t R_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_RDSR2_tag;

typedef union ENET_TDSR2_union_tag {   /* Transmit Buffer Descriptor Ring 2 Start Register */
  vuint32_t R;
  struct {
    vuint32_t X_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_TDSR2_tag;

typedef union ENET_MRBR2_union_tag {   /* Maximum Receive Buffer Size Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t R_BUF_SIZE:7;
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
  } B;
} ENET_MRBR2_tag;

typedef union ENET_RDSR_union_tag {    /* Receive Descriptor Ring 0 Start Register */
  vuint32_t R;
  struct {
    vuint32_t R_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_RDSR_tag;

typedef union ENET_TDSR_union_tag {    /* Transmit Buffer Descriptor Ring 0 Start Register */
  vuint32_t R;
  struct {
    vuint32_t X_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_TDSR_tag;

typedef union ENET_MRBR_union_tag {    /* Maximum Receive Buffer Size Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t R_BUF_SIZE:7;
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
  } B;
} ENET_MRBR_tag;

typedef union ENET_RSFL_union_tag {    /* Receive FIFO Section Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RX_SECTION_FULL:8;       /* Value Of Receive FIFO Section Full Threshold */
  } B;
} ENET_RSFL_tag;

typedef union ENET_RSEM_union_tag {    /* Receive FIFO Section Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t STAT_SECTION_EMPTY:5;    /* RX Status FIFO Section Empty Threshold */
    vuint32_t _unused_8:8;
    vuint32_t RX_SECTION_EMPTY:8;      /* Value Of The Receive FIFO Section Empty Threshold */
  } B;
} ENET_RSEM_tag;

typedef union ENET_RAEM_union_tag {    /* Receive FIFO Almost Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RX_ALMOST_EMPTY:8;       /* Value Of The Receive FIFO Almost Empty Threshold */
  } B;
} ENET_RAEM_tag;

typedef union ENET_RAFL_union_tag {    /* Receive FIFO Almost Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RX_ALMOST_FULL:8;        /* Value Of The Receive FIFO Almost Full Threshold */
  } B;
} ENET_RAFL_tag;

typedef union ENET_TSEM_union_tag {    /* Transmit FIFO Section Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TX_SECTION_EMPTY:8;      /* Value Of The Transmit FIFO Section Empty Threshold */
  } B;
} ENET_TSEM_tag;

typedef union ENET_TAEM_union_tag {    /* Transmit FIFO Almost Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TX_ALMOST_EMPTY:8;       /* Value of Transmit FIFO Almost Empty Threshold */
  } B;
} ENET_TAEM_tag;

typedef union ENET_TAFL_union_tag {    /* Transmit FIFO Almost Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TX_ALMOST_FULL:8;        /* Value Of The Transmit FIFO Almost Full Threshold */
  } B;
} ENET_TAFL_tag;

typedef union ENET_TIPG_union_tag {    /* Transmit Inter-Packet Gap */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t IPG:5;                   /* Transmit Inter-Packet Gap */
  } B;
} ENET_TIPG_tag;

typedef union ENET_FTRL_union_tag {    /* Frame Truncation Length */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t TRUNC_FL:14;             /* Frame Truncation Length */
  } B;
} ENET_FTRL_tag;

typedef union ENET_TACC_union_tag {    /* Transmit Accelerator Function Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t PROCHK:1;
    vuint32_t IPCHK:1;
    vuint32_t _unused_1:2;
    vuint32_t SHIFT16:1;               /* TX FIFO Shift-16 */
  } B;
} ENET_TACC_tag;

typedef union ENET_RACC_union_tag {    /* Receive Accelerator Function Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t SHIFT16:1;               /* RX FIFO Shift-16 */
    vuint32_t LINEDIS:1;               /* Enable Discard Of Frames With MAC Layer Errors */
    vuint32_t _unused_3:3;
    vuint32_t PRODIS:1;                /* Enable Discard Of Frames With Wrong Protocol Checksum */
    vuint32_t IPDIS:1;                 /* Enable Discard Of Frames With Wrong IPv4 Header Checksum */
    vuint32_t PADREM:1;                /* Enable Padding Removal For Short IP Frames */
  } B;
} ENET_RACC_tag;

typedef union ENET_RCMR_union_tag {    /* Receive Classification Match Register for Class n */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t MATCHEN:1;               /* Match Enable */
    vuint32_t _unused_15:1;
    vuint32_t CMP3:3;                  /* Compare 3 */
    vuint32_t _unused_11:1;
    vuint32_t CMP2:3;                  /* Compare 2 */
    vuint32_t _unused_7:1;
    vuint32_t CMP1:3;                  /* Compare 1 */
    vuint32_t _unused_3:1;
    vuint32_t CMP0:3;                  /* Compare 0 */
  } B;
} ENET_RCMR_tag;

typedef union ENET_DMACFG_union_tag {  /* DMA Class Based Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_18:6;
    vuint32_t CALC_NOIPG:1;            /* Calculate no IPG */
    vuint32_t DMA_CLASS_EN:1;          /* DMA class enable */
    vuint32_t IDLE_SLOPE:16;           /* Idle slope */
  } B;
} ENET_DMACFG_tag;

typedef union ENET_RDAR1_union_tag {   /* Receive Descriptor Active Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_RDAR1_tag;

typedef union ENET_TDAR1_union_tag {   /* Transmit Descriptor Active Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_TDAR1_tag;

typedef union ENET_RDAR2_union_tag {   /* Receive Descriptor Active Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_RDAR2_tag;

typedef union ENET_TDAR2_union_tag {   /* Transmit Descriptor Active Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_TDAR2_tag;

typedef union ENET_QOS_union_tag {     /* QOS Scheme */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t RX_FLUSH2:1;             /* RX Flush Ring 2 */
    vuint32_t RX_FLUSH1:1;             /* RX Flush Ring 1 */
    vuint32_t RX_FLUSH0:1;             /* RX Flush Ring 0 */
    vuint32_t TX_SCHEME:3;             /* TX scheme configuration */
  } B;
} ENET_QOS_tag;

typedef union ENET_RMON_T_DROP_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* This read-only field always has the value 0. */
  } B;
} ENET_RMON_T_DROP_tag;

typedef union ENET_RMON_T_PACKETS_union_tag { /* Tx Packet Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Packet count */
  } B;
} ENET_RMON_T_PACKETS_tag;

typedef union ENET_RMON_T_BC_PKT_union_tag { /* Tx Broadcast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Broadcast packets */
  } B;
} ENET_RMON_T_BC_PKT_tag;

typedef union ENET_RMON_T_MC_PKT_union_tag { /* Tx Multicast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Multicast packets */
  } B;
} ENET_RMON_T_MC_PKT_tag;

typedef union ENET_RMON_T_CRC_ALIGN_union_tag { /* Tx Packets with CRC/Align Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Packets with CRC/align error */
  } B;
} ENET_RMON_T_CRC_ALIGN_tag;

typedef union ENET_RMON_T_UNDERSIZE_union_tag { /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of transmit packets less than 64 bytes with good CRC */
  } B;
} ENET_RMON_T_UNDERSIZE_tag;

typedef union ENET_RMON_T_OVERSIZE_union_tag { /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
  } B;
} ENET_RMON_T_OVERSIZE_tag;

typedef union ENET_RMON_T_FRAG_union_tag { /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of packets less than 64 bytes with bad CRC */
  } B;
} ENET_RMON_T_FRAG_tag;

typedef union ENET_RMON_T_JAB_union_tag { /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
  } B;
} ENET_RMON_T_JAB_tag;

typedef union ENET_RMON_T_COL_union_tag { /* Tx Collision Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of transmit collisions */
  } B;
} ENET_RMON_T_COL_tag;

typedef union ENET_RMON_T_P64_union_tag { /* Tx 64-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of 64-byte transmit packets */
  } B;
} ENET_RMON_T_P64_tag;

typedef union ENET_RMON_T_P65TO127_union_tag { /* Tx 65- to 127-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of 65- to 127-byte transmit packets */
  } B;
} ENET_RMON_T_P65TO127_tag;

typedef union ENET_RMON_T_P128TO255_union_tag { /* Tx 128- to 255-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of 128- to 255-byte transmit packets */
  } B;
} ENET_RMON_T_P128TO255_tag;

typedef union ENET_RMON_T_P256TO511_union_tag { /* Tx 256- to 511-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of 256- to 511-byte transmit packets */
  } B;
} ENET_RMON_T_P256TO511_tag;

typedef union ENET_RMON_T_P512TO1023_union_tag { /* Tx 512- to 1023-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of 512- to 1023-byte transmit packets */
  } B;
} ENET_RMON_T_P512TO1023_tag;

typedef union ENET_RMON_T_P1024TO2047_union_tag { /* Tx 1024- to 2047-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of 1024- to 2047-byte transmit packets */
  } B;
} ENET_RMON_T_P1024TO2047_tag;

typedef union ENET_RMON_T_P_GTE2048_union_tag { /* Tx Packets Greater Than 2048 Bytes Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS:16;               /* Number of transmit packets greater than 2048 bytes */
  } B;
} ENET_RMON_T_P_GTE2048_tag;

typedef union ENET_RMON_T_OCTETS_union_tag { /* Tx Octets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXOCTS:32;               /* Number of transmit octets */
  } B;
} ENET_RMON_T_OCTETS_tag;

typedef union ENET_IEEE_T_DROP_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* This read-only field always has the value 0. */
  } B;
} ENET_IEEE_T_DROP_tag;

typedef union ENET_IEEE_T_FRAME_OK_union_tag { /* Frames Transmitted OK Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames transmitted OK */
  } B;
} ENET_IEEE_T_FRAME_OK_tag;

typedef union ENET_IEEE_T_1COL_union_tag { /* Frames Transmitted with Single Collision Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames transmitted with one collision */
  } B;
} ENET_IEEE_T_1COL_tag;

typedef union ENET_IEEE_T_MCOL_union_tag { /* Frames Transmitted with Multiple Collisions Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames transmitted with multiple collisions */
  } B;
} ENET_IEEE_T_MCOL_tag;

typedef union ENET_IEEE_T_DEF_union_tag { /* Frames Transmitted after Deferral Delay Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames transmitted with deferral delay */
  } B;
} ENET_IEEE_T_DEF_tag;

typedef union ENET_IEEE_T_LCOL_union_tag { /* Frames Transmitted with Late Collision Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames transmitted with late collision */
  } B;
} ENET_IEEE_T_LCOL_tag;

typedef union ENET_IEEE_T_EXCOL_union_tag { /* Frames Transmitted with Excessive Collisions Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames transmitted with excessive collisions */
  } B;
} ENET_IEEE_T_EXCOL_tag;

typedef union ENET_IEEE_T_MACERR_union_tag { /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames transmitted with transmit FIFO underrun */
  } B;
} ENET_IEEE_T_MACERR_tag;

typedef union ENET_IEEE_T_CSERR_union_tag { /* Frames Transmitted with Carrier Sense Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames transmitted with carrier sense error */
  } B;
} ENET_IEEE_T_CSERR_tag;

typedef union ENET_IEEE_T_SQE_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;
  } B;
} ENET_IEEE_T_SQE_tag;

typedef union ENET_IEEE_T_FDXFC_union_tag { /* Flow Control Pause Frames Transmitted Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of flow-control pause frames transmitted */
  } B;
} ENET_IEEE_T_FDXFC_tag;

typedef union ENET_IEEE_T_OCTETS_OK_union_tag { /* Octet Count for Frames Transmitted w/o Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
  } B;
} ENET_IEEE_T_OCTETS_OK_tag;

typedef union ENET_RMON_R_PACKETS_union_tag { /* Rx Packet Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of packets received */
  } B;
} ENET_RMON_R_PACKETS_tag;

typedef union ENET_RMON_R_BC_PKT_union_tag { /* Rx Broadcast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of receive broadcast packets */
  } B;
} ENET_RMON_R_BC_PKT_tag;

typedef union ENET_RMON_R_MC_PKT_union_tag { /* Rx Multicast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of receive multicast packets */
  } B;
} ENET_RMON_R_MC_PKT_tag;

typedef union ENET_RMON_R_CRC_ALIGN_union_tag { /* Rx Packets with CRC/Align Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of receive packets with CRC or align error */
  } B;
} ENET_RMON_R_CRC_ALIGN_tag;

typedef union ENET_RMON_R_UNDERSIZE_union_tag { /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of receive packets with less than 64 bytes and good CRC */
  } B;
} ENET_RMON_R_UNDERSIZE_tag;

typedef union ENET_RMON_R_OVERSIZE_union_tag { /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of receive packets greater than MAX_FL and good CRC */
  } B;
} ENET_RMON_R_OVERSIZE_tag;

typedef union ENET_RMON_R_FRAG_union_tag { /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of receive packets with less than 64 bytes and bad CRC */
  } B;
} ENET_RMON_R_FRAG_tag;

typedef union ENET_RMON_R_JAB_union_tag { /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of receive packets greater than MAX_FL and bad CRC */
  } B;
} ENET_RMON_R_JAB_tag;

typedef union ENET_RMON_R_RESVD_0_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_0:16;
  } B;
} ENET_RMON_R_RESVD_0_tag;

typedef union ENET_RMON_R_P64_union_tag { /* Rx 64-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of 64-byte receive packets */
  } B;
} ENET_RMON_R_P64_tag;

typedef union ENET_RMON_R_P65TO127_union_tag { /* Rx 65- to 127-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of 65- to 127-byte recieve packets */
  } B;
} ENET_RMON_R_P65TO127_tag;

typedef union ENET_RMON_R_P128TO255_union_tag { /* Rx 128- to 255-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of 128- to 255-byte recieve packets */
  } B;
} ENET_RMON_R_P128TO255_tag;

typedef union ENET_RMON_R_P256TO511_union_tag { /* Rx 256- to 511-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of 256- to 511-byte recieve packets */
  } B;
} ENET_RMON_R_P256TO511_tag;

typedef union ENET_RMON_R_P512TO1023_union_tag { /* Rx 512- to 1023-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of 512- to 1023-byte recieve packets */
  } B;
} ENET_RMON_R_P512TO1023_tag;

typedef union ENET_RMON_R_P1024TO2047_union_tag { /* Rx 1024- to 2047-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of 1024- to 2047-byte recieve packets */
  } B;
} ENET_RMON_R_P1024TO2047_tag;

typedef union ENET_RMON_R_P_GTE2048_union_tag { /* Rx Packets Greater than 2048 Bytes Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of greater-than-2048-byte recieve packets */
  } B;
} ENET_RMON_R_P_GTE2048_tag;

typedef union ENET_RMON_R_OCTETS_union_tag { /* Rx Octets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Number of receive octets */
  } B;
} ENET_RMON_R_OCTETS_tag;

typedef union ENET_IEEE_R_DROP_union_tag { /* Frames not Counted Correctly Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Frame count */
  } B;
} ENET_IEEE_R_DROP_tag;

typedef union ENET_IEEE_R_FRAME_OK_union_tag { /* Frames Received OK Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames received OK */
  } B;
} ENET_IEEE_R_FRAME_OK_tag;

typedef union ENET_IEEE_R_CRC_union_tag { /* Frames Received with CRC Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames received with CRC error */
  } B;
} ENET_IEEE_R_CRC_tag;

typedef union ENET_IEEE_R_ALIGN_union_tag { /* Frames Received with Alignment Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of frames received with alignment error */
  } B;
} ENET_IEEE_R_ALIGN_tag;

typedef union ENET_IEEE_R_MACERR_union_tag { /* Receive FIFO Overflow Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Receive FIFO overflow count */
  } B;
} ENET_IEEE_R_MACERR_tag;

typedef union ENET_IEEE_R_FDXFC_union_tag { /* Flow Control Pause Frames Received Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT:16;                /* Number of flow-control pause frames received */
  } B;
} ENET_IEEE_R_FDXFC_tag;

typedef union ENET_IEEE_R_OCTETS_OK_union_tag { /* Octet Count for Frames Received without Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Number of octets for frames received without error */
  } B;
} ENET_IEEE_R_OCTETS_OK_tag;

typedef union ENET_ATCR_union_tag {    /* Adjustable Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t SLAVE:1;                 /* Enable Timer Slave Mode */
    vuint32_t _unused_12:1;
    vuint32_t CAPTURE:1;               /* Capture Timer Value */
    vuint32_t _unused_10:1;
    vuint32_t RESTART:1;               /* Reset Timer */
    vuint32_t _unused_8:1;
    vuint32_t PINPER:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t PEREN:1;                 /* Enable Periodical Event */
    vuint32_t OFFRST:1;                /* Reset Timer On Offset Event */
    vuint32_t OFFEN:1;                 /* Enable One-Shot Offset Event */
    vuint32_t _unused_1:1;
    vuint32_t EN:1;                    /* Enable Timer */
  } B;
} ENET_ATCR_tag;

typedef union ENET_ATVR_union_tag {    /* Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t ATIME:32;
  } B;
} ENET_ATVR_tag;

typedef union ENET_ATOFF_union_tag {   /* Timer Offset Register */
  vuint32_t R;
  struct {
    vuint32_t OFFSET:32;
  } B;
} ENET_ATOFF_tag;

typedef union ENET_ATPER_union_tag {   /* Timer Period Register */
  vuint32_t R;
  struct {
    vuint32_t PERIOD:32;
  } B;
} ENET_ATPER_tag;

typedef union ENET_ATCOR_union_tag {   /* Timer Correction Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t COR:31;                  /* Correction Counter Wrap-Around Value */
  } B;
} ENET_ATCOR_tag;

typedef union ENET_ATINC_union_tag {   /* Time-Stamping Clock Period Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t INC_CORR:7;              /* Correction Increment Value */
    vuint32_t _unused_7:1;
    vuint32_t INC:7;                   /* Clock Period Of The Timestamping Clock (ts_clk) In Nanoseconds */
  } B;
} ENET_ATINC_tag;

typedef union ENET_ATSTMP_union_tag {  /* Timestamp of Last Transmitted Frame */
  vuint32_t R;
  struct {
    vuint32_t TIMESTAMP:32;
  } B;
} ENET_ATSTMP_tag;

typedef union ENET_MDATA_union_tag {   /* Pattern Match Data Register */
  vuint32_t R;
  struct {
    vuint32_t MATCHDATA:32;            /* Match Data */
  } B;
} ENET_MDATA_tag;

typedef union ENET_MMASK_union_tag {   /* Match Entry Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MATCHMASK:32;            /* Match Mask */
  } B;
} ENET_MMASK_tag;

typedef union ENET_MCONFIG_union_tag { /* Match Entry Rules Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t AF:1;                    /* Accept Frame */
    vuint32_t RF:1;                    /* Reject Frame */
    vuint32_t IM:1;                    /* Invert Match */
    vuint32_t _unused_24:5;
    vuint32_t OK_INDEX:8;
    vuint32_t _unused_8:8;
    vuint32_t FRMOFF:6;                /* Frame Offset */
    vuint32_t _unused_0:2;
  } B;
} ENET_MCONFIG_tag;

typedef union ENET_MENTRYRW_union_tag { /* Match Entry Read/Write Command Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t RD:1;                    /* Entry Read Command */
    vuint32_t WR:1;                    /* Entry write command */
    vuint32_t ENTRYADD:8;              /* Entry Address */
  } B;
} ENET_MENTRYRW_tag;

typedef union ENET_RXPCTL_union_tag {  /* Receive Parser Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t MAXINDEX:8;              /* Maximum Index */
    vuint32_t _unused_5:3;
    vuint32_t PRSRSCLR:1;              /* Clear Parser Statistics Counter */
    vuint32_t _unused_2:2;
    vuint32_t INVBYTORD:1;             /* Inverse Frame Byte Order */
    vuint32_t ENPARSER:1;              /* Enable Receive Parser */
  } B;
} ENET_RXPCTL_tag;

typedef union ENET_MAXFRMOFF_union_tag { /* Maximum Frame Offset */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t MXFRMOFF:6;              /* Max. Frame Offset */
  } B;
} ENET_MAXFRMOFF_tag;

typedef union ENET_RXPARST_union_tag { /* Receive Parser Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t RXPRSDN:1;               /* Receive Parser Done */
    vuint32_t _unused_6:2;
    vuint32_t INVMAXIDX:1;             /* Invalid Value of MAXINDEX */
    vuint32_t PRSENDERR:1;             /* Parser End Error */
    vuint32_t FMOFFERR:1;              /* Maximum Frame Offset Error */
    vuint32_t NOMTCERR:1;              /* No Match Error */
    vuint32_t TBLDPTERR:1;             /* Table Depth Error */
    vuint32_t MXINDERR:1;              /* Maximum Index Error */
  } B;
} ENET_RXPARST_tag;

typedef union ENET_PARSDSCD_union_tag { /* Parser Discard Count */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PARSDSCD_tag;

typedef union ENET_PRSACPT0_union_tag { /* Parser Accept Count 0 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSACPT0_tag;

typedef union ENET_PRSRJCT0_union_tag { /* Parser Reject Count 0 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSRJCT0_tag;

typedef union ENET_PRSACPT1_union_tag { /* Parser Accept Count 1 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSACPT1_tag;

typedef union ENET_PRSRJCT1_union_tag { /* Parser Reject Count 1 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSRJCT1_tag;

typedef union ENET_PRSACPT2_union_tag { /* Parser Accept Count 2 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSACPT2_tag;

typedef union ENET_PRSRJCT2_union_tag { /* Parser Reject Count 2 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSRJCT2_tag;

typedef union ENET_TGSR_union_tag {    /* Timer Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t TF3:1;                   /* Copy Of Timer Flag For Channel 3 */
    vuint32_t TF2:1;                   /* Copy Of Timer Flag For Channel 2 */
    vuint32_t TF1:1;                   /* Copy Of Timer Flag For Channel 1 */
    vuint32_t TF0:1;                   /* Copy Of Timer Flag For Channel 0 */
  } B;
} ENET_TGSR_tag;

typedef union ENET_TIMER_TCSR_union_tag { /* Timer Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TF:1;                    /* Timer Flag */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TMODE:4;                 /* Timer Mode */
    vuint32_t _unused_1:1;
    vuint32_t TDRE:1;                  /* Timer DMA Request Enable */
  } B;
} ENET_TIMER_TCSR_tag;

typedef union ENET_TIMER_TCCR_union_tag { /* Timer Compare Capture Register */
  vuint32_t R;
  struct {
    vuint32_t TCC:32;                  /* Timer Capture Compare */
  } B;
} ENET_TIMER_TCCR_tag;

typedef struct ENET_TIMER_struct_tag {
  ENET_TIMER_TCSR_tag TCSR;            /* Timer Control Status Register */
  ENET_TIMER_TCCR_tag TCCR;            /* Timer Compare Capture Register */
} ENET_TIMER_tag;

struct ENET_tag {
  uint8_t ENET_reserved0[4];
  ENET_EIR_tag EIR;                    /* Interrupt Event Register */
  ENET_EIMR_tag EIMR;                  /* Interrupt Mask Register */
  uint8_t ENET_reserved1[4];
  ENET_RDAR_tag RDAR;                  /* Receive Descriptor Active Register - Ring 0 */
  ENET_TDAR_tag TDAR;                  /* Transmit Descriptor Active Register - Ring 0 */
  uint8_t ENET_reserved2[12];
  ENET_ECR_tag ECR;                    /* Ethernet Control Register */
  uint8_t ENET_reserved3[24];
  ENET_MMFR_tag MMFR;                  /* MII Management Frame Register */
  ENET_MSCR_tag MSCR;                  /* MII Speed Control Register */
  uint8_t ENET_reserved4[28];
  ENET_MIBC_tag MIBC;                  /* MIB Control Register */
  uint8_t ENET_reserved5[28];
  ENET_RCR_tag RCR;                    /* Receive Control Register */
  uint8_t ENET_reserved6[60];
  ENET_TCR_tag TCR;                    /* Transmit Control Register */
  uint8_t ENET_reserved7[28];
  ENET_PALR_tag PALR;                  /* Physical Address Lower Register */
  ENET_PAUR_tag PAUR;                  /* Physical Address Upper Register */
  ENET_OPD_tag OPD;                    /* Opcode/Pause Duration Register */
  ENET_TXIC_tag TXIC[3];               /* Transmit Interrupt Coalescing Register */
  uint8_t ENET_reserved8[4];
  ENET_RXIC_tag RXIC[3];               /* Receive Interrupt Coalescing Register */
  uint8_t ENET_reserved9[12];
  ENET_IAUR_tag IAUR;                  /* Descriptor Individual Upper Address Register */
  ENET_IALR_tag IALR;                  /* Descriptor Individual Lower Address Register */
  ENET_GAUR_tag GAUR;                  /* Descriptor Group Upper Address Register */
  ENET_GALR_tag GALR;                  /* Descriptor Group Lower Address Register */
  uint8_t ENET_reserved10[28];
  ENET_TFWR_tag TFWR;                  /* Transmit FIFO Watermark Register */
  uint8_t ENET_reserved11[24];
  ENET_RDSR1_tag RDSR1;                /* Receive Descriptor Ring 1 Start Register */
  ENET_TDSR1_tag TDSR1;                /* Transmit Buffer Descriptor Ring 1 Start Register */
  ENET_MRBR1_tag MRBR1;                /* Maximum Receive Buffer Size Register - Ring 1 */
  ENET_RDSR2_tag RDSR2;                /* Receive Descriptor Ring 2 Start Register */
  ENET_TDSR2_tag TDSR2;                /* Transmit Buffer Descriptor Ring 2 Start Register */
  ENET_MRBR2_tag MRBR2;                /* Maximum Receive Buffer Size Register - Ring 2 */
  uint8_t ENET_reserved12[8];
  ENET_RDSR_tag RDSR;                  /* Receive Descriptor Ring 0 Start Register */
  ENET_TDSR_tag TDSR;                  /* Transmit Buffer Descriptor Ring 0 Start Register */
  ENET_MRBR_tag MRBR;                  /* Maximum Receive Buffer Size Register - Ring 0 */
  uint8_t ENET_reserved13[4];
  ENET_RSFL_tag RSFL;                  /* Receive FIFO Section Full Threshold */
  ENET_RSEM_tag RSEM;                  /* Receive FIFO Section Empty Threshold */
  ENET_RAEM_tag RAEM;                  /* Receive FIFO Almost Empty Threshold */
  ENET_RAFL_tag RAFL;                  /* Receive FIFO Almost Full Threshold */
  ENET_TSEM_tag TSEM;                  /* Transmit FIFO Section Empty Threshold */
  ENET_TAEM_tag TAEM;                  /* Transmit FIFO Almost Empty Threshold */
  ENET_TAFL_tag TAFL;                  /* Transmit FIFO Almost Full Threshold */
  ENET_TIPG_tag TIPG;                  /* Transmit Inter-Packet Gap */
  ENET_FTRL_tag FTRL;                  /* Frame Truncation Length */
  uint8_t ENET_reserved14[12];
  ENET_TACC_tag TACC;                  /* Transmit Accelerator Function Configuration */
  ENET_RACC_tag RACC;                  /* Receive Accelerator Function Configuration */
  ENET_RCMR_tag RCMR[2];               /* Receive Classification Match Register for Class n */
  uint8_t ENET_reserved15[8];
  ENET_DMACFG_tag DMACFG[2];           /* DMA Class Based Configuration */
  ENET_RDAR1_tag RDAR1;                /* Receive Descriptor Active Register - Ring 1 */
  ENET_TDAR1_tag TDAR1;                /* Transmit Descriptor Active Register - Ring 1 */
  ENET_RDAR2_tag RDAR2;                /* Receive Descriptor Active Register - Ring 2 */
  ENET_TDAR2_tag TDAR2;                /* Transmit Descriptor Active Register - Ring 2 */
  ENET_QOS_tag QOS;                    /* QOS Scheme */
  uint8_t ENET_reserved16[12];
  ENET_RMON_T_DROP_tag RMON_T_DROP;    /* Reserved Statistic Register */
  ENET_RMON_T_PACKETS_tag RMON_T_PACKETS; /* Tx Packet Count Statistic Register */
  ENET_RMON_T_BC_PKT_tag RMON_T_BC_PKT; /* Tx Broadcast Packets Statistic Register */
  ENET_RMON_T_MC_PKT_tag RMON_T_MC_PKT; /* Tx Multicast Packets Statistic Register */
  ENET_RMON_T_CRC_ALIGN_tag RMON_T_CRC_ALIGN; /* Tx Packets with CRC/Align Error Statistic Register */
  ENET_RMON_T_UNDERSIZE_tag RMON_T_UNDERSIZE; /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
  ENET_RMON_T_OVERSIZE_tag RMON_T_OVERSIZE; /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
  ENET_RMON_T_FRAG_tag RMON_T_FRAG;    /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  ENET_RMON_T_JAB_tag RMON_T_JAB;      /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
  ENET_RMON_T_COL_tag RMON_T_COL;      /* Tx Collision Count Statistic Register */
  ENET_RMON_T_P64_tag RMON_T_P64;      /* Tx 64-Byte Packets Statistic Register */
  ENET_RMON_T_P65TO127_tag RMON_T_P65TO127; /* Tx 65- to 127-byte Packets Statistic Register */
  ENET_RMON_T_P128TO255_tag RMON_T_P128TO255; /* Tx 128- to 255-byte Packets Statistic Register */
  ENET_RMON_T_P256TO511_tag RMON_T_P256TO511; /* Tx 256- to 511-byte Packets Statistic Register */
  ENET_RMON_T_P512TO1023_tag RMON_T_P512TO1023; /* Tx 512- to 1023-byte Packets Statistic Register */
  ENET_RMON_T_P1024TO2047_tag RMON_T_P1024TO2047; /* Tx 1024- to 2047-byte Packets Statistic Register */
  ENET_RMON_T_P_GTE2048_tag RMON_T_P_GTE2048; /* Tx Packets Greater Than 2048 Bytes Statistic Register */
  ENET_RMON_T_OCTETS_tag RMON_T_OCTETS; /* Tx Octets Statistic Register */
  ENET_IEEE_T_DROP_tag IEEE_T_DROP;    /* Reserved Statistic Register */
  ENET_IEEE_T_FRAME_OK_tag IEEE_T_FRAME_OK; /* Frames Transmitted OK Statistic Register */
  ENET_IEEE_T_1COL_tag IEEE_T_1COL;    /* Frames Transmitted with Single Collision Statistic Register */
  ENET_IEEE_T_MCOL_tag IEEE_T_MCOL;    /* Frames Transmitted with Multiple Collisions Statistic Register */
  ENET_IEEE_T_DEF_tag IEEE_T_DEF;      /* Frames Transmitted after Deferral Delay Statistic Register */
  ENET_IEEE_T_LCOL_tag IEEE_T_LCOL;    /* Frames Transmitted with Late Collision Statistic Register */
  ENET_IEEE_T_EXCOL_tag IEEE_T_EXCOL;  /* Frames Transmitted with Excessive Collisions Statistic Register */
  ENET_IEEE_T_MACERR_tag IEEE_T_MACERR; /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
  ENET_IEEE_T_CSERR_tag IEEE_T_CSERR;  /* Frames Transmitted with Carrier Sense Error Statistic Register */
  ENET_IEEE_T_SQE_tag IEEE_T_SQE;      /* Reserved Statistic Register */
  ENET_IEEE_T_FDXFC_tag IEEE_T_FDXFC;  /* Flow Control Pause Frames Transmitted Statistic Register */
  ENET_IEEE_T_OCTETS_OK_tag IEEE_T_OCTETS_OK; /* Octet Count for Frames Transmitted w/o Error Statistic Register */
  uint8_t ENET_reserved17[12];
  ENET_RMON_R_PACKETS_tag RMON_R_PACKETS; /* Rx Packet Count Statistic Register */
  ENET_RMON_R_BC_PKT_tag RMON_R_BC_PKT; /* Rx Broadcast Packets Statistic Register */
  ENET_RMON_R_MC_PKT_tag RMON_R_MC_PKT; /* Rx Multicast Packets Statistic Register */
  ENET_RMON_R_CRC_ALIGN_tag RMON_R_CRC_ALIGN; /* Rx Packets with CRC/Align Error Statistic Register */
  ENET_RMON_R_UNDERSIZE_tag RMON_R_UNDERSIZE; /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
  ENET_RMON_R_OVERSIZE_tag RMON_R_OVERSIZE; /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
  ENET_RMON_R_FRAG_tag RMON_R_FRAG;    /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  ENET_RMON_R_JAB_tag RMON_R_JAB;      /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
  ENET_RMON_R_RESVD_0_tag RMON_R_RESVD_0; /* Reserved Statistic Register */
  ENET_RMON_R_P64_tag RMON_R_P64;      /* Rx 64-Byte Packets Statistic Register */
  ENET_RMON_R_P65TO127_tag RMON_R_P65TO127; /* Rx 65- to 127-Byte Packets Statistic Register */
  ENET_RMON_R_P128TO255_tag RMON_R_P128TO255; /* Rx 128- to 255-Byte Packets Statistic Register */
  ENET_RMON_R_P256TO511_tag RMON_R_P256TO511; /* Rx 256- to 511-Byte Packets Statistic Register */
  ENET_RMON_R_P512TO1023_tag RMON_R_P512TO1023; /* Rx 512- to 1023-Byte Packets Statistic Register */
  ENET_RMON_R_P1024TO2047_tag RMON_R_P1024TO2047; /* Rx 1024- to 2047-Byte Packets Statistic Register */
  ENET_RMON_R_P_GTE2048_tag RMON_R_P_GTE2048; /* Rx Packets Greater than 2048 Bytes Statistic Register */
  ENET_RMON_R_OCTETS_tag RMON_R_OCTETS; /* Rx Octets Statistic Register */
  ENET_IEEE_R_DROP_tag IEEE_R_DROP;    /* Frames not Counted Correctly Statistic Register */
  ENET_IEEE_R_FRAME_OK_tag IEEE_R_FRAME_OK; /* Frames Received OK Statistic Register */
  ENET_IEEE_R_CRC_tag IEEE_R_CRC;      /* Frames Received with CRC Error Statistic Register */
  ENET_IEEE_R_ALIGN_tag IEEE_R_ALIGN;  /* Frames Received with Alignment Error Statistic Register */
  ENET_IEEE_R_MACERR_tag IEEE_R_MACERR; /* Receive FIFO Overflow Count Statistic Register */
  ENET_IEEE_R_FDXFC_tag IEEE_R_FDXFC;  /* Flow Control Pause Frames Received Statistic Register */
  ENET_IEEE_R_OCTETS_OK_tag IEEE_R_OCTETS_OK; /* Octet Count for Frames Received without Error Statistic Register */
  uint8_t ENET_reserved18[284];
  ENET_ATCR_tag ATCR;                  /* Adjustable Timer Control Register */
  ENET_ATVR_tag ATVR;                  /* Timer Value Register */
  ENET_ATOFF_tag ATOFF;                /* Timer Offset Register */
  ENET_ATPER_tag ATPER;                /* Timer Period Register */
  ENET_ATCOR_tag ATCOR;                /* Timer Correction Register */
  ENET_ATINC_tag ATINC;                /* Time-Stamping Clock Period Register */
  ENET_ATSTMP_tag ATSTMP;              /* Timestamp of Last Transmitted Frame */
  uint8_t ENET_reserved19[356];
  ENET_MDATA_tag MDATA;                /* Pattern Match Data Register */
  ENET_MMASK_tag MMASK;                /* Match Entry Mask Register */
  ENET_MCONFIG_tag MCONFIG;            /* Match Entry Rules Configuration Register */
  ENET_MENTRYRW_tag MENTRYRW;          /* Match Entry Read/Write Command Register */
  ENET_RXPCTL_tag RXPCTL;              /* Receive Parser Control Register */
  ENET_MAXFRMOFF_tag MAXFRMOFF;        /* Maximum Frame Offset */
  ENET_RXPARST_tag RXPARST;            /* Receive Parser Status */
  uint8_t ENET_reserved20[4];
  ENET_PARSDSCD_tag PARSDSCD;          /* Parser Discard Count */
  ENET_PRSACPT0_tag PRSACPT0;          /* Parser Accept Count 0 */
  ENET_PRSRJCT0_tag PRSRJCT0;          /* Parser Reject Count 0 */
  ENET_PRSACPT1_tag PRSACPT1;          /* Parser Accept Count 1 */
  ENET_PRSRJCT1_tag PRSRJCT1;          /* Parser Reject Count 1 */
  ENET_PRSACPT2_tag PRSACPT2;          /* Parser Accept Count 2 */
  ENET_PRSRJCT2_tag PRSRJCT2;          /* Parser Reject Count 2 */
  uint8_t ENET_reserved21[72];
  ENET_TGSR_tag TGSR;                  /* Timer Global Status Register */
  ENET_TIMER_tag TIMER[4];
};


/* ============================================================================
   =============================== Module: ESW ================================
   ============================================================================ */

typedef union ESW_REV_union_tag {      /* Revision */
  vuint32_t R;
  struct {
    vuint32_t CSTREV:16;
    vuint32_t CORREV:16;
  } B;
} ESW_REV_tag;

typedef union ESW_SCR_union_tag {      /* Scratch register */
  vuint32_t R;
  struct {
    vuint32_t SCRATCH:32;
  } B;
} ESW_SCR_tag;

typedef union ESW_PER_union_tag {      /* Port enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t RE2:1;
    vuint32_t RE1:1;
    vuint32_t RE0:1;
    vuint32_t _unused_3:13;
    vuint32_t TE2:1;
    vuint32_t TE1:1;
    vuint32_t TE0:1;
  } B;
} ESW_PER_tag;

typedef union ESW_VLANV_union_tag {    /* VLAN verify */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t DU2:1;                   /* Discard unknown. */
    vuint32_t DU1:1;                   /* Discard unknown. */
    vuint32_t DU0:1;                   /* Discard unknown. */
    vuint32_t _unused_3:13;
    vuint32_t VV2:1;
    vuint32_t VV1:1;
    vuint32_t VV0:1;
  } B;
} ESW_VLANV_tag;

typedef union ESW_DBCR_union_tag {     /* Default broadcast resolution */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_DBCR_tag;

typedef union ESW_DMCR_union_tag {     /* Default multicast resolution */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_DMCR_tag;

typedef union ESW_BKLR_union_tag {     /* Blocking and learning enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t LD2:1;
    vuint32_t LD1:1;
    vuint32_t LD0:1;
    vuint32_t _unused_3:13;
    vuint32_t BE2:1;
    vuint32_t BE1:1;
    vuint32_t BE0:1;
  } B;
} ESW_BKLR_tag;

typedef union ESW_BMPC_union_tag {     /* Bridge management port configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t PORTMASK:3;
    vuint32_t PRIORITY:3;
    vuint32_t _unused_8:5;
    vuint32_t DIS:1;
    vuint32_t EN:1;
    vuint32_t MSGTX:1;
    vuint32_t _unused_4:1;
    vuint32_t PORT:4;
  } B;
} ESW_BMPC_tag;

typedef union ESW_MODE_union_tag {     /* Mode configuration */
  vuint32_t R;
  struct {
    vuint32_t STATRST:1;
    vuint32_t _unused_10:21;
    vuint32_t P0CT:1;
    vuint32_t CRCTRAN:1;
    vuint32_t STOP:1;
    vuint32_t _unused_2:5;
    vuint32_t SWEN:1;
    vuint32_t SWRST:1;
  } B;
} ESW_MODE_tag;

typedef union ESW_VIMSEL_union_tag {   /* VLAN input manipulation select */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t IM2:2;
    vuint32_t IM1:2;
    vuint32_t IM0:2;
  } B;
} ESW_VIMSEL_tag;

typedef union ESW_VOMSEL_union_tag {   /* VLAN output manipulation select */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t OM2:2;
    vuint32_t OM1:2;
    vuint32_t OM0:2;
  } B;
} ESW_VOMSEL_tag;

typedef union ESW_VIMEN_union_tag {    /* VLAN input manipulation enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t EN2:1;
    vuint32_t EN1:1;
    vuint32_t EN0:1;
  } B;
} ESW_VIMEN_tag;

typedef union ESW_VID_union_tag {      /* VLAN tag ID */
  vuint32_t R;
  struct {
    vuint32_t TAG:32;
  } B;
} ESW_VID_tag;

typedef union ESW_RCMR_union_tag {     /* Receive Classification Match Register for Class n */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t MATCHEN:1;               /* Match Enable */
    vuint32_t _unused_15:1;
    vuint32_t CMP3:3;                  /* Compare 3 */
    vuint32_t _unused_11:1;
    vuint32_t CMP2:3;                  /* Compare 2 */
    vuint32_t _unused_7:1;
    vuint32_t CMP1:3;                  /* Compare 1 */
    vuint32_t _unused_3:1;
    vuint32_t CMP0:3;                  /* Compare 0 */
  } B;
} ESW_RCMR_tag;

typedef union ESW_MCR_union_tag {      /* Mirror control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t EGDA:1;
    vuint32_t EGSA:1;
    vuint32_t INGDA:1;
    vuint32_t INGSA:1;
    vuint32_t EGMAP:1;
    vuint32_t INGMAP:1;
    vuint32_t MEN:1;
    vuint32_t PORT:4;
  } B;
} ESW_MCR_tag;

typedef union ESW_EGMAP_union_tag {    /* Egress port definitions */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t EG2:1;
    vuint32_t EG1:1;
    vuint32_t EG0:1;
  } B;
} ESW_EGMAP_tag;

typedef union ESW_INGMAP_union_tag {   /* Ingress port definitions */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t ING2:1;
    vuint32_t ING1:1;
    vuint32_t ING0:1;
  } B;
} ESW_INGMAP_tag;

typedef union ESW_INGSAL_union_tag {   /* Ingress source MAC address low */
  vuint32_t R;
  struct {
    vuint32_t ADDLOW:32;
  } B;
} ESW_INGSAL_tag;

typedef union ESW_INGSAH_union_tag {   /* Ingress source MAC address high */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t ADDHIGH:16;
  } B;
} ESW_INGSAH_tag;

typedef union ESW_INGDAL_union_tag {   /* Ingress destination MAC address low */
  vuint32_t R;
  struct {
    vuint32_t ADDLOW:32;
  } B;
} ESW_INGDAL_tag;

typedef union ESW_INGDAH_union_tag {   /* Ingress destination MAC address high */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t ADDHIGH:16;
  } B;
} ESW_INGDAH_tag;

typedef union ESW_EGSAL_union_tag {    /* Egress source MAC address low */
  vuint32_t R;
  struct {
    vuint32_t ADDLOW:32;
  } B;
} ESW_EGSAL_tag;

typedef union ESW_EGSAH_union_tag {    /* Egress source MAC address high */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t ADDHIGH:16;
  } B;
} ESW_EGSAH_tag;

typedef union ESW_EGDAL_union_tag {    /* Egress destination MAC address low */
  vuint32_t R;
  struct {
    vuint32_t ADDLOW:32;
  } B;
} ESW_EGDAL_tag;

typedef union ESW_EGDAH_union_tag {    /* Egress destination MAC address high */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t ADDHIGH:16;
  } B;
} ESW_EGDAH_tag;

typedef union ESW_MCVAL_union_tag {    /* Mirror count value */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t COUNT:8;
  } B;
} ESW_MCVAL_tag;

typedef union ESW_MMSR_union_tag {     /* Memory manager status */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t CELLS_AVAIL:8;
    vuint32_t _unused_7:9;
    vuint32_t DQGRNT:1;
    vuint32_t _unused_4:2;
    vuint32_t MFLATCH:1;
    vuint32_t MEMFULL:1;
    vuint32_t NOCELL:1;
    vuint32_t BUSY:1;
  } B;
} ESW_MMSR_tag;

typedef union ESW_LMT_union_tag {      /* Low memory threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t THRESH:8;
  } B;
} ESW_LMT_tag;

typedef union ESW_LFC_union_tag {      /* Lowest number of free cells */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_LFC_tag;

typedef union ESW_PCSR_union_tag {     /* Port congestion status */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t PC2:1;
    vuint32_t PC1:1;
    vuint32_t PC0:1;
  } B;
} ESW_PCSR_tag;

typedef union ESW_IOSR_union_tag {     /* Switch input and output interface status */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t IR2:1;
    vuint32_t IR1:1;
    vuint32_t IR0:1;
    vuint32_t _unused_3:13;
    vuint32_t OR2:1;
    vuint32_t OR1:1;
    vuint32_t OR0:1;
  } B;
} ESW_IOSR_tag;

typedef union ESW_QWT_union_tag {      /* Queue weights */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t Q3WT:5;
    vuint32_t _unused_21:3;
    vuint32_t Q2WT:5;
    vuint32_t _unused_13:3;
    vuint32_t Q1WT:5;
    vuint32_t _unused_5:3;
    vuint32_t Q0WT:5;
  } B;
} ESW_QWT_tag;

typedef union ESW_P0BCT_union_tag {    /* Port 0 Backpressure Congestion Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t THRESH:8;
  } B;
} ESW_P0BCT_tag;

typedef union ESW_FFEN_union_tag {     /* Port 0 forced forwarding enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t FD:2;
    vuint32_t _unused_1:1;
    vuint32_t FEN:1;
  } B;
} ESW_FFEN_tag;

typedef union ESW_PSNP1_union_tag {    /* Port snooping registers */
  vuint32_t R;
  struct {
    vuint32_t PORT_COMPARE:16;
    vuint32_t _unused_5:11;
    vuint32_t CS:1;
    vuint32_t CD:1;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_PSNP1_tag;

typedef union ESW_PSNP2_union_tag {    /* Port snooping registers */
  vuint32_t R;
  struct {
    vuint32_t PORT_COMPARE:16;
    vuint32_t _unused_5:11;
    vuint32_t CS:1;
    vuint32_t CD:1;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_PSNP2_tag;

typedef union ESW_PSNP3_union_tag {    /* Port snooping registers */
  vuint32_t R;
  struct {
    vuint32_t PORT_COMPARE:16;
    vuint32_t _unused_5:11;
    vuint32_t CS:1;
    vuint32_t CD:1;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_PSNP3_tag;

typedef union ESW_PSNP4_union_tag {    /* Port snooping registers */
  vuint32_t R;
  struct {
    vuint32_t PORT_COMPARE:16;
    vuint32_t _unused_5:11;
    vuint32_t CS:1;
    vuint32_t CD:1;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_PSNP4_tag;

typedef union ESW_PSNP5_union_tag {    /* Port snooping registers */
  vuint32_t R;
  struct {
    vuint32_t PORT_COMPARE:16;
    vuint32_t _unused_5:11;
    vuint32_t CS:1;
    vuint32_t CD:1;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_PSNP5_tag;

typedef union ESW_PSNP6_union_tag {    /* Port snooping registers */
  vuint32_t R;
  struct {
    vuint32_t PORT_COMPARE:16;
    vuint32_t _unused_5:11;
    vuint32_t CS:1;
    vuint32_t CD:1;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_PSNP6_tag;

typedef union ESW_PSNP7_union_tag {    /* Port snooping registers */
  vuint32_t R;
  struct {
    vuint32_t PORT_COMPARE:16;
    vuint32_t _unused_5:11;
    vuint32_t CS:1;
    vuint32_t CD:1;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_PSNP7_tag;

typedef union ESW_PSNP8_union_tag {    /* Port snooping registers */
  vuint32_t R;
  struct {
    vuint32_t PORT_COMPARE:16;
    vuint32_t _unused_5:11;
    vuint32_t CS:1;
    vuint32_t CD:1;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_PSNP8_tag;

typedef union ESW_IPSNP1_union_tag {   /* IP snooping registers */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PROTOCOL:8;
    vuint32_t _unused_3:5;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_IPSNP1_tag;

typedef union ESW_IPSNP2_union_tag {   /* IP snooping registers */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PROTOCOL:8;
    vuint32_t _unused_3:5;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_IPSNP2_tag;

typedef union ESW_IPSNP3_union_tag {   /* IP snooping registers */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PROTOCOL:8;
    vuint32_t _unused_3:5;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_IPSNP3_tag;

typedef union ESW_IPSNP4_union_tag {   /* IP snooping registers */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PROTOCOL:8;
    vuint32_t _unused_3:5;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_IPSNP4_tag;

typedef union ESW_IPSNP5_union_tag {   /* IP snooping registers */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PROTOCOL:8;
    vuint32_t _unused_3:5;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_IPSNP5_tag;

typedef union ESW_IPSNP6_union_tag {   /* IP snooping registers */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PROTOCOL:8;
    vuint32_t _unused_3:5;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_IPSNP6_tag;

typedef union ESW_IPSNP7_union_tag {   /* IP snooping registers */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PROTOCOL:8;
    vuint32_t _unused_3:5;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_IPSNP7_tag;

typedef union ESW_IPSNP8_union_tag {   /* IP snooping registers */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PROTOCOL:8;
    vuint32_t _unused_3:5;
    vuint32_t MODE:2;
    vuint32_t EN:1;
  } B;
} ESW_IPSNP8_tag;

typedef union ESW_P0VRES_union_tag {   /* Port 0 VLAN priority resolution map */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t PRI7:3;
    vuint32_t PRI6:3;
    vuint32_t PRI5:3;
    vuint32_t PRI4:3;
    vuint32_t PRI3:3;
    vuint32_t PRI2:3;
    vuint32_t PRI1:3;
    vuint32_t PRI0:3;
  } B;
} ESW_P0VRES_tag;

typedef union ESW_P1VRES_union_tag {   /* Port 1 VLAN priority resolution map */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t PRI7:3;
    vuint32_t PRI6:3;
    vuint32_t PRI5:3;
    vuint32_t PRI4:3;
    vuint32_t PRI3:3;
    vuint32_t PRI2:3;
    vuint32_t PRI1:3;
    vuint32_t PRI0:3;
  } B;
} ESW_P1VRES_tag;

typedef union ESW_P2VRES_union_tag {   /* Port 2 VLAN priority resolution map */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t PRI7:3;
    vuint32_t PRI6:3;
    vuint32_t PRI5:3;
    vuint32_t PRI4:3;
    vuint32_t PRI3:3;
    vuint32_t PRI2:3;
    vuint32_t PRI1:3;
    vuint32_t PRI0:3;
  } B;
} ESW_P2VRES_tag;

typedef union ESW_IPRES_union_tag {    /* IPv4/v6 priority resolution table */
  vuint32_t R;
  struct {
    vuint32_t READ:1;
    vuint32_t _unused_15:16;
    vuint32_t PRI2:2;
    vuint32_t PRI1:2;
    vuint32_t PRI0:2;
    vuint32_t IPV4SEL:1;
    vuint32_t ADDRESS:8;
  } B;
} ESW_IPRES_tag;

typedef union ESW_P0RES_union_tag {    /* Port 0 priority resolution configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t DFLT_PRI:3;
    vuint32_t _unused_3:1;
    vuint32_t MAC:1;
    vuint32_t IP:1;
    vuint32_t VLAN:1;
  } B;
} ESW_P0RES_tag;

typedef union ESW_P1RES_union_tag {    /* Port 1 priority resolution configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t DFLT_PRI:3;
    vuint32_t _unused_3:1;
    vuint32_t MAC:1;
    vuint32_t IP:1;
    vuint32_t VLAN:1;
  } B;
} ESW_P1RES_tag;

typedef union ESW_P2RES_union_tag {    /* Port 2 priority resolution configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t DFLT_PRI:3;
    vuint32_t _unused_3:1;
    vuint32_t MAC:1;
    vuint32_t IP:1;
    vuint32_t VLAN:1;
  } B;
} ESW_P2RES_tag;

typedef union ESW_P0ID_union_tag {     /* Port 0 VLAN ID */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t VLANID:16;
  } B;
} ESW_P0ID_tag;

typedef union ESW_P1ID_union_tag {     /* Port 1 VLAN ID */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t VLANID:16;
  } B;
} ESW_P1ID_tag;

typedef union ESW_P2ID_union_tag {     /* Port 2 VLAN ID */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t VLANID:16;
  } B;
} ESW_P2ID_tag;

typedef union ESW_VRES0_union_tag {    /* VLAN domain resolution entry 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES0_tag;

typedef union ESW_VRES1_union_tag {    /* VLAN domain resolution entry 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES1_tag;

typedef union ESW_VRES2_union_tag {    /* VLAN domain resolution entry 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES2_tag;

typedef union ESW_VRES3_union_tag {    /* VLAN domain resolution entry 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES3_tag;

typedef union ESW_VRES4_union_tag {    /* VLAN domain resolution entry 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES4_tag;

typedef union ESW_VRES5_union_tag {    /* VLAN domain resolution entry 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES5_tag;

typedef union ESW_VRES6_union_tag {    /* VLAN domain resolution entry 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES6_tag;

typedef union ESW_VRES7_union_tag {    /* VLAN domain resolution entry 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES7_tag;

typedef union ESW_VRES8_union_tag {    /* VLAN domain resolution entry 8 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES8_tag;

typedef union ESW_VRES9_union_tag {    /* VLAN domain resolution entry 9 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES9_tag;

typedef union ESW_VRES10_union_tag {   /* VLAN domain resolution entry 10 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES10_tag;

typedef union ESW_VRES11_union_tag {   /* VLAN domain resolution entry 11 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES11_tag;

typedef union ESW_VRES12_union_tag {   /* VLAN domain resolution entry 12 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES12_tag;

typedef union ESW_VRES13_union_tag {   /* VLAN domain resolution entry 13 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES13_tag;

typedef union ESW_VRES14_union_tag {   /* VLAN domain resolution entry 14 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES14_tag;

typedef union ESW_VRES15_union_tag {   /* VLAN domain resolution entry 15 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES15_tag;

typedef union ESW_VRES16_union_tag {   /* VLAN domain resolution entry 16 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES16_tag;

typedef union ESW_VRES17_union_tag {   /* VLAN domain resolution entry 17 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES17_tag;

typedef union ESW_VRES18_union_tag {   /* VLAN domain resolution entry 18 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES18_tag;

typedef union ESW_VRES19_union_tag {   /* VLAN domain resolution entry 19 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES19_tag;

typedef union ESW_VRES20_union_tag {   /* VLAN domain resolution entry 20 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES20_tag;

typedef union ESW_VRES21_union_tag {   /* VLAN domain resolution entry 21 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES21_tag;

typedef union ESW_VRES22_union_tag {   /* VLAN domain resolution entry 22 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES22_tag;

typedef union ESW_VRES23_union_tag {   /* VLAN domain resolution entry 23 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES23_tag;

typedef union ESW_VRES24_union_tag {   /* VLAN domain resolution entry 24 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES24_tag;

typedef union ESW_VRES25_union_tag {   /* VLAN domain resolution entry 25 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES25_tag;

typedef union ESW_VRES26_union_tag {   /* VLAN domain resolution entry 26 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES26_tag;

typedef union ESW_VRES27_union_tag {   /* VLAN domain resolution entry 27 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES27_tag;

typedef union ESW_VRES28_union_tag {   /* VLAN domain resolution entry 28 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES28_tag;

typedef union ESW_VRES29_union_tag {   /* VLAN domain resolution entry 29 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES29_tag;

typedef union ESW_VRES30_union_tag {   /* VLAN domain resolution entry 30 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES30_tag;

typedef union ESW_VRES31_union_tag {   /* VLAN domain resolution entry 31 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t VLANID:12;
    vuint32_t P2:1;
    vuint32_t P1:1;
    vuint32_t P0:1;
  } B;
} ESW_VRES31_tag;

typedef union ESW_DISCN_union_tag {    /* Number of discarded frames */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_DISCN_tag;

typedef union ESW_DISCB_union_tag {    /* Bytes of discarded frames */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_DISCB_tag;

typedef union ESW_NDISCN_union_tag {   /* Number of non-discarded frames */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_NDISCN_tag;

typedef union ESW_NDISCB_union_tag {   /* Bytes of non-discarded frames */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_NDISCB_tag;

typedef union ESW_P0OQC_union_tag {    /* Port 0 output queue congestion */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P0OQC_tag;

typedef union ESW_P0MVID_union_tag {   /* Port 0 mismatching VLAN ID */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P0MVID_tag;

typedef union ESW_P0MVTAG_union_tag {  /* Port 0 missing VLAN tag */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P0MVTAG_tag;

typedef union ESW_P0BL_union_tag {     /* Port 0 blocked */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P0BL_tag;

typedef union ESW_P1OQC_union_tag {    /* Port 1 output queue congestion */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P1OQC_tag;

typedef union ESW_P1MVID_union_tag {   /* Port 1 mismatching VLAN ID */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P1MVID_tag;

typedef union ESW_P1MVTAG_union_tag {  /* Port 1 missing VLAN tag */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P1MVTAG_tag;

typedef union ESW_P1BL_union_tag {     /* Port 1 blocked */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P1BL_tag;

typedef union ESW_P2OQC_union_tag {    /* Port 2 output queue congestion */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P2OQC_tag;

typedef union ESW_P2MVID_union_tag {   /* Port 2 mismatching VLAN ID */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P2MVID_tag;

typedef union ESW_P2MVTAG_union_tag {  /* Port 2 missing VLAN tag */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P2MVTAG_tag;

typedef union ESW_P2BL_union_tag {     /* Port 2 blocked */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} ESW_P2BL_tag;

typedef union ESW_ISR_union_tag {      /* Interrupt status register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t RXFLUSH2:1;              /* RX DMA Ring 2 flush indication */
    vuint32_t RXFLUSH1:1;              /* RX DMA Ring 1 flush indication */
    vuint32_t RXFLUSH0:1;              /* RX DMA Ring 0 flush indication */
    vuint32_t TXF2:1;                  /* Transmit frame interrupt - ring 2 */
    vuint32_t TXB2:1;                  /* Transmit buffer interrupt - ring 2 */
    vuint32_t RXF2:1;                  /* Receive frame interrupt - ring 2 */
    vuint32_t RXB2:1;                  /* Receive buffer interrupt - ring 2 */
    vuint32_t TXF1:1;                  /* Transmit frame interrupt - ring 1 */
    vuint32_t TXB1:1;                  /* Transmit buffer interrupt - ring 1 */
    vuint32_t RXF1:1;                  /* Receive frame interrupt - ring 1 */
    vuint32_t RXB1:1;                  /* Receive buffer interrupt - ring 1 */
    vuint32_t LRN:1;
    vuint32_t OD2:1;
    vuint32_t OD1:1;
    vuint32_t OD0:1;
    vuint32_t QM:1;
    vuint32_t TXF:1;
    vuint32_t TXB:1;
    vuint32_t RXF:1;
    vuint32_t RXB:1;
    vuint32_t EBERR:1;
  } B;
} ESW_ISR_tag;

typedef union ESW_IMR_union_tag {      /* Interrupt mask register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t RXFLUSH2:1;              /* RX DMA Ring 2 flush indication */
    vuint32_t RXFLUSH1:1;              /* RX DMA Ring 1 flush indication */
    vuint32_t RXFLUSH0:1;              /* RX DMA Ring 0 flush indication */
    vuint32_t TXF2:1;
    vuint32_t TXB2:1;
    vuint32_t RXF2:1;
    vuint32_t RXB2:1;
    vuint32_t TXF1:1;
    vuint32_t TXB1:1;
    vuint32_t RXF1:1;
    vuint32_t RXB1:1;
    vuint32_t LRN:1;
    vuint32_t OD2:1;
    vuint32_t OD1:1;
    vuint32_t OD0:1;
    vuint32_t QM:1;
    vuint32_t TXF:1;
    vuint32_t TXB:1;
    vuint32_t RXF:1;
    vuint32_t RXB:1;
    vuint32_t EBERR:1;
  } B;
} ESW_IMR_tag;

typedef union ESW_RDSR_union_tag {     /* Receive descriptor ring pointer */
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ESW_RDSR_tag;

typedef union ESW_TDSR_union_tag {     /* Transmit descriptor ring pointer */
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ESW_TDSR_tag;

typedef union ESW_MRBR_union_tag {     /* Maximum receive buffer size */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t SIZE:7;
    vuint32_t _unused_0:4;             /* This field, which is always zero, are the four least-significant bits of the maximum receive buffer size. */
  } B;
} ESW_MRBR_tag;

typedef union ESW_RDAR_union_tag {     /* Receive descriptor active - class0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t RDAR:1;
    vuint32_t _unused_0:24;
  } B;
} ESW_RDAR_tag;

typedef union ESW_TDAR_union_tag {     /* Transmit descriptor active - class0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t TDAR:1;
    vuint32_t _unused_0:24;
  } B;
} ESW_TDAR_tag;

typedef union ESW_RDAR1_union_tag {    /* Receive descriptor active - class1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t RDAR:1;
    vuint32_t _unused_0:24;
  } B;
} ESW_RDAR1_tag;

typedef union ESW_TDAR1_union_tag {    /* Transmit descriptor active - class1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t TDAR:1;
    vuint32_t _unused_0:24;
  } B;
} ESW_TDAR1_tag;

typedef union ESW_RDAR2_union_tag {    /* Receive descriptor active - class2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t RDAR:1;
    vuint32_t _unused_0:24;
  } B;
} ESW_RDAR2_tag;

typedef union ESW_TDAR2_union_tag {    /* Transmit descriptor active - class2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t TDAR:1;
    vuint32_t _unused_0:24;
  } B;
} ESW_TDAR2_tag;

typedef union ESW_TXIC_union_tag {     /* Transmit interrupt coalesing register */
  vuint32_t R;
  struct {
    vuint32_t ICEN:1;                  /* Interrupt Coalescing Enable */
    vuint32_t ICCS:1;                  /* Interrupt Coalescing Timer Clock Source Select */
    vuint32_t _unused_28:2;            /* This field must be set to 0. */
    vuint32_t ICFT:8;                  /* Interrupt coalescing frame count threshold */
    vuint32_t _unused_16:4;            /* This field must be set to 0. */
    vuint32_t ICTT:16;                 /* Interrupt coalescing timer threshold */
  } B;
} ESW_TXIC_tag;

typedef union ESW_RXIC_union_tag {     /* Receive interrupt coalesing register */
  vuint32_t R;
  struct {
    vuint32_t ICEN:1;                  /* Interrupt Coalescing Enable */
    vuint32_t ICCS:1;                  /* Interrupt Coalescing Timer Clock Source Select */
    vuint32_t _unused_28:2;            /* This field must be set to 0. */
    vuint32_t ICFT:8;                  /* Interrupt coalescing frame count threshold */
    vuint32_t _unused_16:4;            /* This field must be set to 0. */
    vuint32_t ICTT:16;                 /* Interrupt coalescing timer threshold */
  } B;
} ESW_RXIC_tag;

typedef union ESW_SEL_CLASS_union_tag { /* Select register class for read/write access */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t SEL_CLASS:2;             /* Select Class */
  } B;
} ESW_SEL_CLASS_tag;

typedef union ESW_LREC0_union_tag {    /* Learning records A0 & B1 */
  vuint32_t R;
  struct {
    vuint32_t MAC_ADDR0:32;
  } B;
} ESW_LREC0_tag;

typedef union ESW_LREC1_union_tag {    /* Learning record B1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t SWPORT:2;
    vuint32_t HASH:8;
    vuint32_t MAC_ADDR1:16;
  } B;
} ESW_LREC1_tag;

typedef union ESW_LSR_union_tag {      /* Learning data available status */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t DA:1;
  } B;
} ESW_LSR_tag;

struct ESW_tag {
  ESW_REV_tag REV;                     /* Revision */
  ESW_SCR_tag SCR;                     /* Scratch register */
  ESW_PER_tag PER;                     /* Port enable register */
  uint8_t ESW_reserved0[4];
  ESW_VLANV_tag VLANV;                 /* VLAN verify */
  ESW_DBCR_tag DBCR;                   /* Default broadcast resolution */
  ESW_DMCR_tag DMCR;                   /* Default multicast resolution */
  ESW_BKLR_tag BKLR;                   /* Blocking and learning enable */
  ESW_BMPC_tag BMPC;                   /* Bridge management port configuration */
  ESW_MODE_tag MODE;                   /* Mode configuration */
  ESW_VIMSEL_tag VIMSEL;               /* VLAN input manipulation select */
  ESW_VOMSEL_tag VOMSEL;               /* VLAN output manipulation select */
  ESW_VIMEN_tag VIMEN;                 /* VLAN input manipulation enable */
  ESW_VID_tag VID;                     /* VLAN tag ID */
  ESW_RCMR_tag RCMR[2];                /* Receive Classification Match Register for Class n */
  ESW_MCR_tag MCR;                     /* Mirror control register */
  ESW_EGMAP_tag EGMAP;                 /* Egress port definitions */
  ESW_INGMAP_tag INGMAP;               /* Ingress port definitions */
  ESW_INGSAL_tag INGSAL;               /* Ingress source MAC address low */
  ESW_INGSAH_tag INGSAH;               /* Ingress source MAC address high */
  ESW_INGDAL_tag INGDAL;               /* Ingress destination MAC address low */
  ESW_INGDAH_tag INGDAH;               /* Ingress destination MAC address high */
  ESW_EGSAL_tag EGSAL;                 /* Egress source MAC address low */
  ESW_EGSAH_tag EGSAH;                 /* Egress source MAC address high */
  ESW_EGDAL_tag EGDAL;                 /* Egress destination MAC address low */
  ESW_EGDAH_tag EGDAH;                 /* Egress destination MAC address high */
  ESW_MCVAL_tag MCVAL;                 /* Mirror count value */
  uint8_t ESW_reserved1[16];
  ESW_MMSR_tag MMSR;                   /* Memory manager status */
  ESW_LMT_tag LMT;                     /* Low memory threshold */
  ESW_LFC_tag LFC;                     /* Lowest number of free cells */
  ESW_PCSR_tag PCSR;                   /* Port congestion status */
  ESW_IOSR_tag IOSR;                   /* Switch input and output interface status */
  ESW_QWT_tag QWT;                     /* Queue weights */
  uint8_t ESW_reserved2[4];
  ESW_P0BCT_tag P0BCT;                 /* Port 0 Backpressure Congestion Threshold */
  uint8_t ESW_reserved3[28];
  ESW_FFEN_tag FFEN;                   /* Port 0 forced forwarding enable */
  ESW_PSNP1_tag PSNP1;                 /* Port snooping registers */
  ESW_PSNP2_tag PSNP2;                 /* Port snooping registers */
  ESW_PSNP3_tag PSNP3;                 /* Port snooping registers */
  ESW_PSNP4_tag PSNP4;                 /* Port snooping registers */
  ESW_PSNP5_tag PSNP5;                 /* Port snooping registers */
  ESW_PSNP6_tag PSNP6;                 /* Port snooping registers */
  ESW_PSNP7_tag PSNP7;                 /* Port snooping registers */
  ESW_PSNP8_tag PSNP8;                 /* Port snooping registers */
  ESW_IPSNP1_tag IPSNP1;               /* IP snooping registers */
  ESW_IPSNP2_tag IPSNP2;               /* IP snooping registers */
  ESW_IPSNP3_tag IPSNP3;               /* IP snooping registers */
  ESW_IPSNP4_tag IPSNP4;               /* IP snooping registers */
  ESW_IPSNP5_tag IPSNP5;               /* IP snooping registers */
  ESW_IPSNP6_tag IPSNP6;               /* IP snooping registers */
  ESW_IPSNP7_tag IPSNP7;               /* IP snooping registers */
  ESW_IPSNP8_tag IPSNP8;               /* IP snooping registers */
  ESW_P0VRES_tag P0VRES;               /* Port 0 VLAN priority resolution map */
  ESW_P1VRES_tag P1VRES;               /* Port 1 VLAN priority resolution map */
  ESW_P2VRES_tag P2VRES;               /* Port 2 VLAN priority resolution map */
  uint8_t ESW_reserved4[52];
  ESW_IPRES_tag IPRES;                 /* IPv4/v6 priority resolution table */
  uint8_t ESW_reserved5[60];
  ESW_P0RES_tag P0RES;                 /* Port 0 priority resolution configuration */
  ESW_P1RES_tag P1RES;                 /* Port 1 priority resolution configuration */
  ESW_P2RES_tag P2RES;                 /* Port 2 priority resolution configuration */
  uint8_t ESW_reserved6[116];
  ESW_P0ID_tag P0ID;                   /* Port 0 VLAN ID */
  ESW_P1ID_tag P1ID;                   /* Port 1 VLAN ID */
  ESW_P2ID_tag P2ID;                   /* Port 2 VLAN ID */
  uint8_t ESW_reserved7[116];
  ESW_VRES0_tag VRES0;                 /* VLAN domain resolution entry 0 */
  ESW_VRES1_tag VRES1;                 /* VLAN domain resolution entry 1 */
  ESW_VRES2_tag VRES2;                 /* VLAN domain resolution entry 2 */
  ESW_VRES3_tag VRES3;                 /* VLAN domain resolution entry 4 */
  ESW_VRES4_tag VRES4;                 /* VLAN domain resolution entry 4 */
  ESW_VRES5_tag VRES5;                 /* VLAN domain resolution entry 5 */
  ESW_VRES6_tag VRES6;                 /* VLAN domain resolution entry 6 */
  ESW_VRES7_tag VRES7;                 /* VLAN domain resolution entry 7 */
  ESW_VRES8_tag VRES8;                 /* VLAN domain resolution entry 8 */
  ESW_VRES9_tag VRES9;                 /* VLAN domain resolution entry 9 */
  ESW_VRES10_tag VRES10;               /* VLAN domain resolution entry 10 */
  ESW_VRES11_tag VRES11;               /* VLAN domain resolution entry 11 */
  ESW_VRES12_tag VRES12;               /* VLAN domain resolution entry 12 */
  ESW_VRES13_tag VRES13;               /* VLAN domain resolution entry 13 */
  ESW_VRES14_tag VRES14;               /* VLAN domain resolution entry 14 */
  ESW_VRES15_tag VRES15;               /* VLAN domain resolution entry 15 */
  ESW_VRES16_tag VRES16;               /* VLAN domain resolution entry 16 */
  ESW_VRES17_tag VRES17;               /* VLAN domain resolution entry 17 */
  ESW_VRES18_tag VRES18;               /* VLAN domain resolution entry 18 */
  ESW_VRES19_tag VRES19;               /* VLAN domain resolution entry 19 */
  ESW_VRES20_tag VRES20;               /* VLAN domain resolution entry 20 */
  ESW_VRES21_tag VRES21;               /* VLAN domain resolution entry 21 */
  ESW_VRES22_tag VRES22;               /* VLAN domain resolution entry 22 */
  ESW_VRES23_tag VRES23;               /* VLAN domain resolution entry 23 */
  ESW_VRES24_tag VRES24;               /* VLAN domain resolution entry 24 */
  ESW_VRES25_tag VRES25;               /* VLAN domain resolution entry 25 */
  ESW_VRES26_tag VRES26;               /* VLAN domain resolution entry 26 */
  ESW_VRES27_tag VRES27;               /* VLAN domain resolution entry 27 */
  ESW_VRES28_tag VRES28;               /* VLAN domain resolution entry 28 */
  ESW_VRES29_tag VRES29;               /* VLAN domain resolution entry 29 */
  ESW_VRES30_tag VRES30;               /* VLAN domain resolution entry 30 */
  ESW_VRES31_tag VRES31;               /* VLAN domain resolution entry 31 */
  ESW_DISCN_tag DISCN;                 /* Number of discarded frames */
  ESW_DISCB_tag DISCB;                 /* Bytes of discarded frames */
  ESW_NDISCN_tag NDISCN;               /* Number of non-discarded frames */
  ESW_NDISCB_tag NDISCB;               /* Bytes of non-discarded frames */
  ESW_P0OQC_tag P0OQC;                 /* Port 0 output queue congestion */
  ESW_P0MVID_tag P0MVID;               /* Port 0 mismatching VLAN ID */
  ESW_P0MVTAG_tag P0MVTAG;             /* Port 0 missing VLAN tag */
  ESW_P0BL_tag P0BL;                   /* Port 0 blocked */
  ESW_P1OQC_tag P1OQC;                 /* Port 1 output queue congestion */
  ESW_P1MVID_tag P1MVID;               /* Port 1 mismatching VLAN ID */
  ESW_P1MVTAG_tag P1MVTAG;             /* Port 1 missing VLAN tag */
  ESW_P1BL_tag P1BL;                   /* Port 1 blocked */
  ESW_P2OQC_tag P2OQC;                 /* Port 2 output queue congestion */
  ESW_P2MVID_tag P2MVID;               /* Port 2 mismatching VLAN ID */
  ESW_P2MVTAG_tag P2MVTAG;             /* Port 2 missing VLAN tag */
  ESW_P2BL_tag P2BL;                   /* Port 2 blocked */
  uint8_t ESW_reserved8[192];
  ESW_ISR_tag ISR;                     /* Interrupt status register */
  ESW_IMR_tag IMR;                     /* Interrupt mask register */
  ESW_RDSR_tag RDSR;                   /* Receive descriptor ring pointer */
  ESW_TDSR_tag TDSR;                   /* Transmit descriptor ring pointer */
  ESW_MRBR_tag MRBR;                   /* Maximum receive buffer size */
  ESW_RDAR_tag RDAR;                   /* Receive descriptor active - class0 */
  ESW_TDAR_tag TDAR;                   /* Transmit descriptor active - class0 */
  ESW_RDAR1_tag RDAR1;                 /* Receive descriptor active - class1 */
  ESW_TDAR1_tag TDAR1;                 /* Transmit descriptor active - class1 */
  ESW_RDAR2_tag RDAR2;                 /* Receive descriptor active - class2 */
  ESW_TDAR2_tag TDAR2;                 /* Transmit descriptor active - class2 */
  uint8_t ESW_reserved9[84];
  ESW_TXIC_tag TXIC;                   /* Transmit interrupt coalesing register */
  ESW_RXIC_tag RXIC;                   /* Receive interrupt coalesing register */
  uint8_t ESW_reserved10[8];
  ESW_SEL_CLASS_tag SEL_CLASS;         /* Select register class for read/write access */
  uint8_t ESW_reserved11[108];
  ESW_LREC0_tag LREC0;                 /* Learning records A0 & B1 */
  ESW_LREC1_tag LREC1;                 /* Learning record B1 */
  ESW_LSR_tag LSR;                     /* Learning data available status */
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

typedef union FCCU_CTRL_union_tag {    /* Control */
  vuint32_t R;
  struct {
    vuint32_t FILTER_BYPASS:1;
    vuint32_t FILTER_WIDTH:2;
    vuint32_t _unused_10:19;
    vuint32_t DEBUG:1;                 /* Debug Mode Enable */
    vuint32_t _unused_8:1;
    vuint32_t OPS:2;
    vuint32_t _unused_5:1;
    vuint32_t OPR:5;                   /* Operation Run */
  } B;
} FCCU_CTRL_tag;

typedef union FCCU_CTRLK_union_tag {   /* Control Key */
  vuint32_t R;
  struct {
    vuint32_t CTRLK:32;                /* Locked-Operation Control Key */
  } B;
} FCCU_CTRLK_tag;

typedef union FCCU_CFG_union_tag {     /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t TGL:7;                   /* EOUT Toggling Time */
    vuint32_t FCCU_SET_AFTER_RESET:1;  /* Fault-Output (EOUT) Activate */
    vuint32_t FCCU_SET_CLEAR:2;        /* Fault-Output (EOUT) Control */
    vuint32_t _unused_20:2;
    vuint32_t _unused_16:4;
    vuint32_t FOPE:1;                  /* Fault-Output (EOUT) Prescaler Extension */
    vuint32_t FOME:2;                  /* Fault Output Mode Extension */
    vuint32_t OD:1;
    vuint32_t _unused_11:1;
    vuint32_t SM:1;                    /* Fault-Output (EOUT) Switching Mode */
    vuint32_t PS:1;                    /* Fault-Output (EOUT) Polarity Selection */
    vuint32_t FOM:3;                   /* Fault-Output (EOUT) Mode */
    vuint32_t FOP:6;                   /* Fault-Output (EOUT) Prescaler */
  } B;
} FCCU_CFG_tag;

typedef union FCCU_NCF_CFG_union_tag { /* Noncritical Fault Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFC31:1;
    vuint32_t NCFC30:1;
    vuint32_t NCFC29:1;
    vuint32_t NCFC28:1;
    vuint32_t NCFC27:1;
    vuint32_t NCFC26:1;
    vuint32_t NCFC25:1;
    vuint32_t NCFC24:1;
    vuint32_t NCFC23:1;
    vuint32_t NCFC22:1;
    vuint32_t NCFC21:1;
    vuint32_t NCFC20:1;
    vuint32_t NCFC19:1;
    vuint32_t NCFC18:1;
    vuint32_t NCFC17:1;
    vuint32_t NCFC16:1;
    vuint32_t NCFC15:1;
    vuint32_t NCFC14:1;
    vuint32_t NCFC13:1;
    vuint32_t NCFC12:1;
    vuint32_t NCFC11:1;
    vuint32_t NCFC10:1;
    vuint32_t NCFC9:1;
    vuint32_t NCFC8:1;
    vuint32_t NCFC7:1;
    vuint32_t NCFC6:1;
    vuint32_t NCFC5:1;
    vuint32_t NCFC4:1;
    vuint32_t NCFC3:1;
    vuint32_t NCFC2:1;
    vuint32_t NCFC1:1;
    vuint32_t NCFC0:1;
  } B;
} FCCU_NCF_CFG_tag;

typedef union FCCU_NCFS_CFG_union_tag { /* Noncritical Fault State Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFSC31:1;
    vuint32_t NCFSC30:1;
    vuint32_t NCFSC29:1;
    vuint32_t NCFSC28:1;
    vuint32_t NCFSC27:1;
    vuint32_t NCFSC26:1;
    vuint32_t NCFSC25:1;
    vuint32_t NCFSC24:1;
    vuint32_t NCFSC23:1;
    vuint32_t NCFSC22:1;
    vuint32_t NCFSC21:1;
    vuint32_t NCFSC20:1;
    vuint32_t NCFSC19:1;
    vuint32_t NCFSC18:1;
    vuint32_t NCFSC17:1;
    vuint32_t NCFSC16:1;
    vuint32_t NCFSC15:1;
    vuint32_t NCFSC14:1;
    vuint32_t NCFSC13:1;
    vuint32_t NCFSC12:1;
    vuint32_t NCFSC11:1;
    vuint32_t NCFSC10:1;
    vuint32_t NCFSC9:1;
    vuint32_t NCFSC8:1;
    vuint32_t NCFSC7:1;
    vuint32_t NCFSC6:1;
    vuint32_t NCFSC5:1;
    vuint32_t NCFSC4:1;
    vuint32_t NCFSC3:1;
    vuint32_t NCFSC2:1;
    vuint32_t NCFSC1:1;
    vuint32_t NCFSC0:1;
  } B;
} FCCU_NCFS_CFG_tag;

typedef union FCCU_NCF_S_union_tag {   /* Noncritical Fault Status */
  vuint32_t R;
  struct {
    vuint32_t NCFS31:1;
    vuint32_t NCFS30:1;
    vuint32_t NCFS29:1;
    vuint32_t NCFS28:1;
    vuint32_t NCFS27:1;
    vuint32_t NCFS26:1;
    vuint32_t NCFS25:1;
    vuint32_t NCFS24:1;
    vuint32_t NCFS23:1;
    vuint32_t NCFS22:1;
    vuint32_t NCFS21:1;
    vuint32_t NCFS20:1;
    vuint32_t NCFS19:1;
    vuint32_t NCFS18:1;
    vuint32_t NCFS17:1;
    vuint32_t NCFS16:1;
    vuint32_t NCFS15:1;
    vuint32_t NCFS14:1;
    vuint32_t NCFS13:1;
    vuint32_t NCFS12:1;
    vuint32_t NCFS11:1;
    vuint32_t NCFS10:1;
    vuint32_t NCFS9:1;
    vuint32_t NCFS8:1;
    vuint32_t NCFS7:1;
    vuint32_t NCFS6:1;
    vuint32_t NCFS5:1;
    vuint32_t NCFS4:1;
    vuint32_t NCFS3:1;
    vuint32_t NCFS2:1;
    vuint32_t NCFS1:1;
    vuint32_t NCFS0:1;
  } B;
} FCCU_NCF_S_tag;

typedef union FCCU_NCFK_union_tag {    /* Noncritical Fault Key */
  vuint32_t R;
  struct {
    vuint32_t NCFK:32;
  } B;
} FCCU_NCFK_tag;

typedef union FCCU_NCF_E_union_tag {   /* Noncritical Fault Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFE31:1;
    vuint32_t NCFE30:1;
    vuint32_t NCFE29:1;
    vuint32_t NCFE28:1;
    vuint32_t NCFE27:1;
    vuint32_t NCFE26:1;
    vuint32_t NCFE25:1;
    vuint32_t NCFE24:1;
    vuint32_t NCFE23:1;
    vuint32_t NCFE22:1;
    vuint32_t NCFE21:1;
    vuint32_t NCFE20:1;
    vuint32_t NCFE19:1;
    vuint32_t NCFE18:1;
    vuint32_t NCFE17:1;
    vuint32_t NCFE16:1;
    vuint32_t NCFE15:1;
    vuint32_t NCFE14:1;
    vuint32_t NCFE13:1;
    vuint32_t NCFE12:1;
    vuint32_t NCFE11:1;
    vuint32_t NCFE10:1;
    vuint32_t NCFE9:1;
    vuint32_t NCFE8:1;
    vuint32_t NCFE7:1;
    vuint32_t NCFE6:1;
    vuint32_t NCFE5:1;
    vuint32_t NCFE4:1;
    vuint32_t NCFE3:1;
    vuint32_t NCFE2:1;
    vuint32_t NCFE1:1;
    vuint32_t NCFE0:1;
  } B;
} FCCU_NCF_E_tag;

typedef union FCCU_NCF_TOE_union_tag { /* Noncritical Fault Timeout Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFTOE31:1;
    vuint32_t NCFTOE30:1;
    vuint32_t NCFTOE29:1;
    vuint32_t NCFTOE28:1;
    vuint32_t NCFTOE27:1;
    vuint32_t NCFTOE26:1;
    vuint32_t NCFTOE25:1;
    vuint32_t NCFTOE24:1;
    vuint32_t NCFTOE23:1;
    vuint32_t NCFTOE22:1;
    vuint32_t NCFTOE21:1;
    vuint32_t NCFTOE20:1;
    vuint32_t NCFTOE19:1;
    vuint32_t NCFTOE18:1;
    vuint32_t NCFTOE17:1;
    vuint32_t NCFTOE16:1;
    vuint32_t NCFTOE15:1;
    vuint32_t NCFTOE14:1;
    vuint32_t NCFTOE13:1;
    vuint32_t NCFTOE12:1;
    vuint32_t NCFTOE11:1;
    vuint32_t NCFTOE10:1;
    vuint32_t NCFTOE9:1;
    vuint32_t NCFTOE8:1;
    vuint32_t NCFTOE7:1;
    vuint32_t NCFTOE6:1;
    vuint32_t NCFTOE5:1;
    vuint32_t NCFTOE4:1;
    vuint32_t NCFTOE3:1;
    vuint32_t NCFTOE2:1;
    vuint32_t NCFTOE1:1;
    vuint32_t NCFTOE0:1;
  } B;
} FCCU_NCF_TOE_tag;

typedef union FCCU_NCF_TO_union_tag {  /* Noncritical Fault Timeout */
  vuint32_t R;
  struct {
    vuint32_t TO:32;
  } B;
} FCCU_NCF_TO_tag;

typedef union FCCU_CFG_TO_union_tag {  /* Configuration-State Timer Interval */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t TO:3;                    /* Configuration-State Timer Interval */
  } B;
} FCCU_CFG_TO_tag;

typedef union FCCU_EINOUT_union_tag {  /* IO Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t EIN1:1;                  /* Error Input 1 */
    vuint32_t EIN0:1;                  /* Error Input 0 */
    vuint32_t _unused_2:2;
    vuint32_t EOUTX:2;
  } B;
} FCCU_EINOUT_tag;

typedef union FCCU_STAT_union_tag {    /* Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t PhysicErrorPin:2;        /* Fault Output (EOUT) States */
    vuint32_t ESTAT:1;                 /* Fault State */
    vuint32_t STATUS:3;                /* FCCU State */
  } B;
} FCCU_STAT_tag;

typedef union FCCU_N2AF_STATUS_union_tag { /* NA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t NAFS:8;
  } B;
} FCCU_N2AF_STATUS_tag;

typedef union FCCU_A2FF_STATUS_union_tag { /* AF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t AF_SRC:2;
    vuint32_t AFFS:8;
  } B;
} FCCU_A2FF_STATUS_tag;

typedef union FCCU_N2FF_STATUS_union_tag { /* NF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t NF_SRC:2;
    vuint32_t NFFS:8;
  } B;
} FCCU_N2FF_STATUS_tag;

typedef union FCCU_F2A_STATUS_union_tag { /* FA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t FAFS:9;
  } B;
} FCCU_F2A_STATUS_tag;

typedef union FCCU_NCFF_union_tag {    /* Noncritical Fault Fake */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t FNCFC:7;
  } B;
} FCCU_NCFF_tag;

typedef union FCCU_IRQ_STAT_union_tag { /* IRQ Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t DMA_REQ:1;
    vuint32_t IRQ_EOUT:1;
    vuint32_t NMI_STAT:1;
    vuint32_t ALRM_STAT:1;
    vuint32_t CFG_TO_STAT:1;
  } B;
} FCCU_IRQ_STAT_tag;

typedef union FCCU_IRQ_EN_union_tag {  /* IRQ Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t IRQ_EOUT_EN:1;
    vuint32_t _unused_1:2;
    vuint32_t CFG_TO_IEN:1;
  } B;
} FCCU_IRQ_EN_tag;

typedef union FCCU_XTMR_union_tag {    /* XTMR */
  vuint32_t R;
  struct {
    vuint32_t XTMR:32;
  } B;
} FCCU_XTMR_tag;

typedef union FCCU_MCS_union_tag {     /* Mode Controller Status */
  vuint32_t R;
  struct {
    vuint32_t VL3:1;
    vuint32_t FS3:1;                   /* Fault Status 3 */
    vuint32_t _unused_28:2;
    vuint32_t MCS3:4;
    vuint32_t VL2:1;
    vuint32_t FS2:1;                   /* Fault Status 2 */
    vuint32_t _unused_20:2;
    vuint32_t MCS2:4;
    vuint32_t VL1:1;
    vuint32_t FS1:1;                   /* Fault Status 1 */
    vuint32_t _unused_12:2;
    vuint32_t MCS1:4;
    vuint32_t VL0:1;
    vuint32_t FS0:1;                   /* Fault Status 0 */
    vuint32_t _unused_4:2;
    vuint32_t MCS0:4;
  } B;
} FCCU_MCS_tag;

typedef union FCCU_TRANS_LOCK_union_tag { /* Transient Configuration Lock */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t TRANSKEY:9;              /* Transient Configuration Lock */
  } B;
} FCCU_TRANS_LOCK_tag;

typedef union FCCU_PERMNT_LOCK_union_tag { /* Permanent Configuration Lock */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t PERMNTKEY:9;             /* Permanent Configuration Lock */
  } B;
} FCCU_PERMNT_LOCK_tag;

typedef union FCCU_DELTA_T_union_tag { /* Delta T */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t T_TRG:14;                /* IRQ DMA trigger time */
    vuint32_t _unused_14:2;
    vuint32_t DELTA_T:14;              /* Bistable Minimum Fault-Output (EOUT) Faulty Interval */
  } B;
} FCCU_DELTA_T_tag;

typedef union FCCU_IRQ_ALARM_EN_union_tag { /* IRQ Alarm Enable */
  vuint32_t R;
  struct {
    vuint32_t IRQEN31:1;
    vuint32_t IRQEN30:1;
    vuint32_t IRQEN29:1;
    vuint32_t IRQEN28:1;
    vuint32_t IRQEN27:1;
    vuint32_t IRQEN26:1;
    vuint32_t IRQEN25:1;
    vuint32_t IRQEN24:1;
    vuint32_t IRQEN23:1;
    vuint32_t IRQEN22:1;
    vuint32_t IRQEN21:1;
    vuint32_t IRQEN20:1;
    vuint32_t IRQEN19:1;
    vuint32_t IRQEN18:1;
    vuint32_t IRQEN17:1;
    vuint32_t IRQEN16:1;
    vuint32_t IRQEN15:1;
    vuint32_t IRQEN14:1;
    vuint32_t IRQEN13:1;
    vuint32_t IRQEN12:1;
    vuint32_t IRQEN11:1;
    vuint32_t IRQEN10:1;
    vuint32_t IRQEN9:1;
    vuint32_t IRQEN8:1;
    vuint32_t IRQEN7:1;
    vuint32_t IRQEN6:1;
    vuint32_t IRQEN5:1;
    vuint32_t IRQEN4:1;
    vuint32_t IRQEN3:1;
    vuint32_t IRQEN2:1;
    vuint32_t IRQEN1:1;
    vuint32_t IRQEN0:1;
  } B;
} FCCU_IRQ_ALARM_EN_tag;

typedef union FCCU_NMI_EN_union_tag {  /* NMI Enable */
  vuint32_t R;
  struct {
    vuint32_t NMIEN31:1;
    vuint32_t NMIEN30:1;
    vuint32_t NMIEN29:1;
    vuint32_t NMIEN28:1;
    vuint32_t NMIEN27:1;
    vuint32_t NMIEN26:1;
    vuint32_t NMIEN25:1;
    vuint32_t NMIEN24:1;
    vuint32_t NMIEN23:1;
    vuint32_t NMIEN22:1;
    vuint32_t NMIEN21:1;
    vuint32_t NMIEN20:1;
    vuint32_t NMIEN19:1;
    vuint32_t NMIEN18:1;
    vuint32_t NMIEN17:1;
    vuint32_t NMIEN16:1;
    vuint32_t NMIEN15:1;
    vuint32_t NMIEN14:1;
    vuint32_t NMIEN13:1;
    vuint32_t NMIEN12:1;
    vuint32_t NMIEN11:1;
    vuint32_t NMIEN10:1;
    vuint32_t NMIEN9:1;
    vuint32_t NMIEN8:1;
    vuint32_t NMIEN7:1;
    vuint32_t NMIEN6:1;
    vuint32_t NMIEN5:1;
    vuint32_t NMIEN4:1;
    vuint32_t NMIEN3:1;
    vuint32_t NMIEN2:1;
    vuint32_t NMIEN1:1;
    vuint32_t NMIEN0:1;
  } B;
} FCCU_NMI_EN_tag;

typedef union FCCU_EOUT_SIG_EN_union_tag { /* Bistable Fault-Output (EOUT) Mode Signaling Enable */
  vuint32_t R;
  struct {
    vuint32_t EOUTEN31:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN30:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN29:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN28:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN27:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN26:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN25:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN24:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN23:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN22:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN21:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN20:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN19:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN18:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN17:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN16:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN15:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN14:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN13:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN12:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN11:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN10:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN9:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN8:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN7:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN6:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN5:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN4:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN3:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN2:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN1:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN0:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
  } B;
} FCCU_EOUT_SIG_EN_tag;

struct FCCU_tag {
  FCCU_CTRL_tag CTRL;                  /* Control */
  FCCU_CTRLK_tag CTRLK;                /* Control Key */
  FCCU_CFG_tag CFG;                    /* Configuration */
  uint8_t FCCU_reserved0[16];
  FCCU_NCF_CFG_tag NCF_CFG[3];         /* Noncritical Fault Configuration */
  uint8_t FCCU_reserved1[36];
  FCCU_NCFS_CFG_tag NCFS_CFG[5];       /* Noncritical Fault State Configuration */
  uint8_t FCCU_reserved2[32];
  FCCU_NCF_S_tag NCF_S[3];             /* Noncritical Fault Status */
  uint8_t FCCU_reserved3[4];
  FCCU_NCFK_tag NCFK;                  /* Noncritical Fault Key */
  FCCU_NCF_E_tag NCF_E[3];             /* Noncritical Fault Enable */
  uint8_t FCCU_reserved4[4];
  FCCU_NCF_TOE_tag NCF_TOE[3];         /* Noncritical Fault Timeout Enable */
  uint8_t FCCU_reserved5[4];
  FCCU_NCF_TO_tag NCF_TO;              /* Noncritical Fault Timeout */
  FCCU_CFG_TO_tag CFG_TO;              /* Configuration-State Timer Interval */
  FCCU_EINOUT_tag EINOUT;              /* IO Control */
  FCCU_STAT_tag STAT;                  /* Status */
  FCCU_N2AF_STATUS_tag N2AF_STATUS;    /* NA Freeze Status */
  FCCU_A2FF_STATUS_tag A2FF_STATUS;    /* AF Freeze Status */
  FCCU_N2FF_STATUS_tag N2FF_STATUS;    /* NF Freeze Status */
  FCCU_F2A_STATUS_tag F2A_STATUS;      /* FA Freeze Status */
  uint8_t FCCU_reserved6[8];
  FCCU_NCFF_tag NCFF;                  /* Noncritical Fault Fake */
  FCCU_IRQ_STAT_tag IRQ_STAT;          /* IRQ Status */
  FCCU_IRQ_EN_tag IRQ_EN;              /* IRQ Enable */
  FCCU_XTMR_tag XTMR;                  /* XTMR */
  FCCU_MCS_tag MCS;                    /* Mode Controller Status */
  FCCU_TRANS_LOCK_tag TRANS_LOCK;      /* Transient Configuration Lock */
  FCCU_PERMNT_LOCK_tag PERMNT_LOCK;    /* Permanent Configuration Lock */
  FCCU_DELTA_T_tag DELTA_T;            /* Delta T */
  FCCU_IRQ_ALARM_EN_tag IRQ_ALARM_EN[3]; /* IRQ Alarm Enable */
  uint8_t FCCU_reserved7[4];
  FCCU_NMI_EN_tag NMI_EN[3];           /* NMI Enable */
  uint8_t FCCU_reserved8[4];
  FCCU_EOUT_SIG_EN_tag EOUT_SIG_EN[3]; /* Bistable Fault-Output (EOUT) Mode Signaling Enable */
};


/* ============================================================================
   =============================== Module: FIRC ===============================
   ============================================================================ */

typedef union FIRC_CTL_union_tag {     /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t _unused_16:6;
    vuint32_t _unused_13:3;
    vuint32_t FIRCDIV:5;               /* The FIRC Divider bits select the clock divider factor. */
    vuint32_t _unused_5:3;
    vuint32_t FIRCS:1;                 /* Describes the FIRC clock status. */
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} FIRC_CTL_tag;

struct FIRC_tag {
  FIRC_CTL_tag CTL;                    /* Control register */
};


/* ============================================================================
   =============================== Module: FR =================================
   ============================================================================ */

typedef union FR_MVR_union_tag {       /* Module Version Register */
  vuint16_t R;
  struct {
    vuint16_t CHIVER:8;
    vuint16_t PEVER:8;
  } B;
} FR_MVR_tag;

typedef union FR_MCR_union_tag {       /* Module Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MEN:1;
    vuint16_t SBFF:1;                  /* System Bus Failure Freeze */
    vuint16_t SCM:1;
    vuint16_t CHB:1;
    vuint16_t CHA:1;
    vuint16_t SFFE:1;
    vuint16_t ECCE:1;
    vuint16_t _unused_8:1;             /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
    vuint16_t FUM:1;
    vuint16_t FAM:1;
    vuint16_t _unused_5:1;
    vuint16_t CLKSEL:1;
    vuint16_t BITRATE:3;
    vuint16_t _unused_0:1;
  } B;
} FR_MCR_tag;

typedef union FR_SYMBADHR_union_tag {  /* System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;                 /* System Memory Base Address high. This is the value of the system memory base address for the individual message buffers and sync frame table. This is the value of the system memory base address for the receive FIFO if the FIFO address mode bit FR_MCR[FAM] is set to 1. It is defines as a byte address. */
  } B;
} FR_SYMBADHR_tag;

typedef union FR_SYMBADLR_union_tag {  /* System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:12;
    vuint16_t _unused_0:4;
  } B;
} FR_SYMBADLR_tag;

typedef union FR_STBSCR_union_tag {    /* Strobe Signal Control Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_12:3;
    vuint16_t SEL:4;
    vuint16_t _unused_5:3;
    vuint16_t ENB:1;
    vuint16_t _unused_2:2;
    vuint16_t STBPSEL:2;
  } B;
} FR_STBSCR_tag;

typedef union FR_MBDSR_union_tag {     /* Message Buffer Data Size Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t MBSEG2DS:7;
    vuint16_t _unused_7:1;
    vuint16_t MBSEG1DS:7;
  } B;
} FR_MBDSR_tag;

typedef union FR_MBSSUTR_union_tag {   /* Message Buffer Segment Size and Utilization Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t LAST_MB_SEG1:7;
    vuint16_t _unused_7:1;
    vuint16_t LAST_MB_UTIL:7;
  } B;
} FR_MBSSUTR_tag;

typedef union FR_PEDRAR_union_tag {    /* PE DRAM Access Register */
  vuint16_t R;
  struct {
    vuint16_t INST:4;
    vuint16_t ADDR:11;
    vuint16_t DAD:1;
  } B;
} FR_PEDRAR_tag;

typedef union FR_PEDRDR_union_tag {    /* PE DRAM Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_PEDRDR_tag;

typedef union FR_POCR_union_tag {      /* Protocol Operation Control Register */
  vuint16_t R;
  struct {
    vuint16_t WME:1;
    vuint16_t _unused_12:3;
    vuint16_t EOC_AP:2;
    vuint16_t ERC_AP:2;
    vuint16_t BSY_WMC:1;
    vuint16_t _unused_4:3;
    vuint16_t POCCMD:4;
  } B;
} FR_POCR_tag;

typedef union FR_GIFER_union_tag {     /* Global Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t MIF:1;
    vuint16_t PRIF:1;
    vuint16_t CHIF:1;
    vuint16_t WUPIF:1;
    vuint16_t FAFBIF:1;
    vuint16_t FAFAIF:1;
    vuint16_t RBIF:1;
    vuint16_t TBIF:1;
    vuint16_t MIE:1;
    vuint16_t PRIE:1;
    vuint16_t CHIE:1;
    vuint16_t WUPIE:1;
    vuint16_t FAFBIE:1;
    vuint16_t FAFAIE:1;
    vuint16_t RBIE:1;
    vuint16_t TBIE:1;
  } B;
} FR_GIFER_tag;

typedef union FR_PIFR0_union_tag {     /* Protocol Interrupt Flag Register 0 */
  vuint16_t R;
  struct {
    vuint16_t FATL_IF:1;
    vuint16_t INTL_IF:1;
    vuint16_t ILCF_IF:1;
    vuint16_t CSA_IF:1;
    vuint16_t MRC_IF:1;
    vuint16_t MOC_IF:1;
    vuint16_t CCL_IF:1;
    vuint16_t MXS_IF:1;
    vuint16_t MTX_IF:1;
    vuint16_t LTXB_IF:1;
    vuint16_t LTXA_IF:1;
    vuint16_t TBVB_IF:1;
    vuint16_t TBVA_IF:1;
    vuint16_t TI2_IF:1;
    vuint16_t TI1_IF:1;
    vuint16_t CYS_IF:1;
  } B;
} FR_PIFR0_tag;

typedef union FR_PIFR1_union_tag {     /* Protocol Interrupt Flag Register 1 */
  vuint16_t R;
  struct {
    vuint16_t EMC_IF:1;
    vuint16_t IPC_IF:1;
    vuint16_t PECF_IF:1;
    vuint16_t PSC_IF:1;
    vuint16_t SSI3_IF:1;
    vuint16_t SSI2_IF:1;
    vuint16_t SSI1_IF:1;
    vuint16_t SSI0_IF:1;
    vuint16_t _unused_6:2;
    vuint16_t EVT_IF:1;
    vuint16_t ODT_IF:1;
    vuint16_t _unused_0:4;
  } B;
} FR_PIFR1_tag;

typedef union FR_PIER0_union_tag {     /* Protocol Interrupt Enable Register 0 */
  vuint16_t R;
  struct {
    vuint16_t FATL_IE:1;
    vuint16_t INTL_IE:1;
    vuint16_t ILCF_IE:1;
    vuint16_t CSA_IE:1;
    vuint16_t MRC_IE:1;
    vuint16_t MOC_IE:1;
    vuint16_t CCL_IE:1;
    vuint16_t MXS_IE:1;
    vuint16_t MTX_IE:1;
    vuint16_t LTXB_IE:1;
    vuint16_t LTXA_IE:1;
    vuint16_t TBVB_IE:1;
    vuint16_t TBVA_IE:1;
    vuint16_t TI2_IE:1;
    vuint16_t TI1_IE:1;
    vuint16_t CYS_IE:1;
  } B;
} FR_PIER0_tag;

typedef union FR_PIER1_union_tag {     /* Protocol Interrupt Enable Register 1 */
  vuint16_t R;
  struct {
    vuint16_t EMC_IE:1;
    vuint16_t IPC_IE:1;
    vuint16_t PECF_IE:1;
    vuint16_t PSC_IE:1;
    vuint16_t SSI3_IE:1;
    vuint16_t SSI2_IE:1;
    vuint16_t SSI1_IE:1;
    vuint16_t SSI0_IE:1;
    vuint16_t _unused_6:2;
    vuint16_t EVT_IE:1;
    vuint16_t ODT_IE:1;
    vuint16_t _unused_0:4;
  } B;
} FR_PIER1_tag;

typedef union FR_CHIERFR_union_tag {   /* CHI Error Flag Register */
  vuint16_t R;
  struct {
    vuint16_t FRLB_EF:1;
    vuint16_t FRLA_EF:1;
    vuint16_t PCMI_EF:1;
    vuint16_t FOVB_EF:1;
    vuint16_t FOVA_EF:1;
    vuint16_t MBS_EF:1;
    vuint16_t MBU_EF:1;
    vuint16_t LCK_EF:1;
    vuint16_t _unused_7:1;
    vuint16_t SBCF_EF:1;
    vuint16_t FID_EF:1;
    vuint16_t DPL_EF:1;
    vuint16_t SPL_EF:1;
    vuint16_t NML_EF:1;
    vuint16_t NMF_EF:1;
    vuint16_t ILSA_EF:1;
  } B;
} FR_CHIERFR_tag;

typedef union FR_MBIVEC_union_tag {    /* Message Buffer Interrupt Vector Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t TBIVEC:7;
    vuint16_t _unused_7:1;
    vuint16_t RBIVEC:7;
  } B;
} FR_MBIVEC_tag;

typedef union FR_CASERCR_union_tag {   /* Channel A Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHAERSCNT:16;
  } B;
} FR_CASERCR_tag;

typedef union FR_CBSERCR_union_tag {   /* Channel B Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHBERSCNT:16;
  } B;
} FR_CBSERCR_tag;

typedef union FR_PSR0_union_tag {      /* Protocol Status Register 0 */
  vuint16_t R;
  struct {
    vuint16_t ERRMODE:2;
    vuint16_t SLOTMODE:2;
    vuint16_t _unused_11:1;
    vuint16_t PROTSTATE:3;
    vuint16_t STARTUPSTATE:4;
    vuint16_t _unused_3:1;
    vuint16_t WAKEUPSTATUS:3;
  } B;
} FR_PSR0_tag;

typedef union FR_PSR1_union_tag {      /* Protocol Status Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CSAA:1;
    vuint16_t CSP:1;
    vuint16_t _unused_13:1;
    vuint16_t REMCSAT:5;
    vuint16_t CPN:1;
    vuint16_t HHR:1;
    vuint16_t FRZ:1;
    vuint16_t APTAC:5;
  } B;
} FR_PSR1_tag;

typedef union FR_PSR2_union_tag {      /* Protocol Status Register 2 */
  vuint16_t R;
  struct {
    vuint16_t NBVB:1;
    vuint16_t NSEB:1;
    vuint16_t STCB:1;
    vuint16_t SBVB:1;
    vuint16_t SSEB:1;
    vuint16_t MTB:1;
    vuint16_t NBVA:1;
    vuint16_t NSEA:1;
    vuint16_t STCA:1;
    vuint16_t SBVA:1;
    vuint16_t SSEA:1;
    vuint16_t MTA:1;
    vuint16_t CKCORFCNT:4;
  } B;
} FR_PSR2_tag;

typedef union FR_PSR3_union_tag {      /* Protocol Status Register 3 */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t WUB:1;
    vuint16_t ABVB:1;
    vuint16_t AACB:1;
    vuint16_t ACEB:1;
    vuint16_t ASEB:1;
    vuint16_t AVFB:1;
    vuint16_t _unused_6:2;
    vuint16_t WUA:1;
    vuint16_t ABVA:1;
    vuint16_t AACA:1;
    vuint16_t ACEA:1;
    vuint16_t ASEA:1;
    vuint16_t AVFA:1;
  } B;
} FR_PSR3_tag;

typedef union FR_MTCTR_union_tag {     /* Macrotick Counter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t MTCT:14;
  } B;
} FR_MTCTR_tag;

typedef union FR_CYCTR_union_tag {     /* Cycle Counter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_6:10;
    vuint16_t CYCCNT:6;
  } B;
} FR_CYCTR_tag;

typedef union FR_SLTCTAR_union_tag {   /* Slot Counter Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t SLOTCNTA:11;
  } B;
} FR_SLTCTAR_tag;

typedef union FR_SLTCTBR_union_tag {   /* Slot Counter Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t SLOTCNTB:11;
  } B;
} FR_SLTCTBR_tag;

typedef union FR_RTCORVR_union_tag {   /* Rate Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t RATECORR:16;
  } B;
} FR_RTCORVR_tag;

typedef union FR_OFCORVR_union_tag {   /* Offset Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t OFFSETCORR:16;
  } B;
} FR_OFCORVR_tag;

typedef union FR_CIFR_union_tag {      /* Combined Interrupt Flag Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t MIF:1;
    vuint16_t PRIF:1;
    vuint16_t CHIF:1;
    vuint16_t WUPIF:1;
    vuint16_t FAFBIF:1;
    vuint16_t FAFAIF:1;
    vuint16_t RBIF:1;
    vuint16_t TBIF:1;
  } B;
} FR_CIFR_tag;

typedef union FR_SYMATOR_union_tag {   /* System Memory Access Time-Out Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t TIMEOUT:8;
  } B;
} FR_SYMATOR_tag;

typedef union FR_SFCNTR_union_tag {    /* Sync Frame Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SFEVB:4;
    vuint16_t SFEVA:4;
    vuint16_t SFODB:4;
    vuint16_t SFODA:4;
  } B;
} FR_SFCNTR_tag;

typedef union FR_SFTOR_union_tag {     /* Sync Frame Table Offset Register */
  vuint16_t R;
  struct {
    vuint16_t SFT_OFFSET:15;
    vuint16_t _unused_0:1;
  } B;
} FR_SFTOR_tag;

typedef union FR_SFTCCSR_union_tag {   /* Sync Frame Table Configuration, Control, Status Register */
  vuint16_t R;
  struct {
    vuint16_t ELKT:1;
    vuint16_t OLKT:1;
    vuint16_t CYCNUM:6;
    vuint16_t ELKS:1;
    vuint16_t OLKS:1;
    vuint16_t EVAL:1;
    vuint16_t OVAL:1;
    vuint16_t _unused_3:1;
    vuint16_t OPT:1;
    vuint16_t SDVEN:1;
    vuint16_t SIDEN:1;
  } B;
} FR_SFTCCSR_tag;

typedef union FR_SFIDRFR_union_tag {   /* Sync Frame ID Rejection Filter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t SYNFRID:10;
  } B;
} FR_SFIDRFR_tag;

typedef union FR_SFIDAFVR_union_tag {  /* Sync Frame ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t FVAL:10;
  } B;
} FR_SFIDAFVR_tag;

typedef union FR_SFIDAFMR_union_tag {  /* Sync Frame ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t FMSK:10;
  } B;
} FR_SFIDAFMR_tag;

typedef union FR_NMVR_union_tag {      /* Network Management Vector Register */
  vuint16_t R;
  struct {
    vuint16_t NMVP:16;
  } B;
} FR_NMVR_tag;

typedef union FR_NMVLR_union_tag {     /* Network Management Vector Length Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_4:12;
    vuint16_t NMVL:4;
  } B;
} FR_NMVLR_tag;

typedef union FR_TICCR_union_tag {     /* Timer Configuration and Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T2_CFG:1;
    vuint16_t T2_REP:1;
    vuint16_t _unused_11:1;
    vuint16_t T2SP:1;
    vuint16_t T2TR:1;
    vuint16_t T2ST:1;
    vuint16_t _unused_5:3;
    vuint16_t T1_REP:1;
    vuint16_t _unused_3:1;
    vuint16_t T1SP:1;
    vuint16_t T1TR:1;
    vuint16_t T1ST:1;
  } B;
} FR_TICCR_tag;

typedef union FR_TI1CYSR_union_tag {   /* Timer 1 Cycle Set Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T1_CYC_VAL:6;
    vuint16_t _unused_6:2;
    vuint16_t T1_CYC_MSK:6;
  } B;
} FR_TI1CYSR_tag;

typedef union FR_TI1MTOR_union_tag {   /* Timer 1 Macrotick Offset Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T1_MTOFFSET:14;
  } B;
} FR_TI1MTOR_tag;

typedef union FR_TI2CR0_ABS_union_tag { /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T2CYCVAL:6;              /* Timer T2 Cycle Filter Mask */
    vuint16_t _unused_6:2;
    vuint16_t T2CYCMSK:6;              /* Timer T2 Cycle Filter Mask */
  } B;
} FR_TI2CR0_ABS_tag;

typedef union FR_TI2CR0_REL_union_tag { /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;              /* Timer T2 Macrotick High Word */
  } B;
} FR_TI2CR0_REL_tag;

typedef union FR_TI2CR0_union_tag {
  FR_TI2CR0_ABS_tag ABS;               /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  FR_TI2CR0_REL_tag REL;               /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
} FR_TI2CR0_tag;

typedef union FR_TI2CR1_ABS_union_tag { /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T2MOFF:14;               /* Timer T2 Macrotick Offset */
  } B;
} FR_TI2CR1_ABS_tag;

typedef union FR_TI2CR1_REL_union_tag { /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;
  } B;
} FR_TI2CR1_REL_tag;

typedef union FR_TI2CR1_union_tag {
  FR_TI2CR1_ABS_tag ABS;               /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  FR_TI2CR1_REL_tag REL;               /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
} FR_TI2CR1_tag;

typedef union FR_SSSR_union_tag {      /* Slot Status Selection Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_14:1;
    vuint16_t SEL:2;
    vuint16_t _unused_11:1;
    vuint16_t SLOTNUMBER:11;
  } B;
} FR_SSSR_tag;

typedef union FR_SSCCR_union_tag {     /* Slot Status Counter Condition Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_14:1;
    vuint16_t SEL:2;
    vuint16_t _unused_11:1;
    vuint16_t CNTCFG:2;
    vuint16_t MCY:1;
    vuint16_t VFR:1;
    vuint16_t SYF:1;
    vuint16_t NUF:1;
    vuint16_t SUF:1;
    vuint16_t STATUSMASK:4;
  } B;
} FR_SSCCR_tag;

typedef union FR_SSR_union_tag {       /* Slot Status Register */
  vuint16_t R;
  struct {
    vuint16_t VFB:1;
    vuint16_t SYB:1;
    vuint16_t NFB:1;
    vuint16_t SUB:1;
    vuint16_t SEB:1;
    vuint16_t CEB:1;
    vuint16_t BVB:1;
    vuint16_t TCB:1;
    vuint16_t VFA:1;
    vuint16_t SYA:1;
    vuint16_t NFA:1;
    vuint16_t SUA:1;
    vuint16_t SEA:1;
    vuint16_t CEA:1;
    vuint16_t BVA:1;
    vuint16_t TCA:1;
  } B;
} FR_SSR_tag;

typedef union FR_SSCR_union_tag {      /* Slot Status Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTSTATUSCNT:16;
  } B;
} FR_SSCR_tag;

typedef union FR_MTSACFR_union_tag {   /* MTS A Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MTE:1;
    vuint16_t _unused_14:1;
    vuint16_t CYCCNTMSK:6;
    vuint16_t _unused_6:2;
    vuint16_t CYCCNTVAL:6;
  } B;
} FR_MTSACFR_tag;

typedef union FR_MTSBCFR_union_tag {   /* MTS B Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MTE:1;
    vuint16_t _unused_14:1;
    vuint16_t CYCCNTMSK:6;
    vuint16_t _unused_6:2;
    vuint16_t CYCCNTVAL:6;
  } B;
} FR_MTSBCFR_tag;

typedef union FR_RSBIR_union_tag {     /* Receive Shadow Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_14:1;
    vuint16_t SEL:2;
    vuint16_t _unused_8:4;
    vuint16_t RSBIDX:8;                /* RSBIDXA1/RSBIDXA2/RSBIDXB1/RSBIDXB2- Receive Shadow Buffer Index */
  } B;
} FR_RSBIR_tag;

typedef union FR_RFWMSR_union_tag {    /* Receive FIFO Watermark and Selection Register */
  vuint16_t R;
  struct {
    vuint16_t WM:8;                    /* WMA/WMB - Watermark */
    vuint16_t _unused_1:7;
    vuint16_t SEL:1;
  } B;
} FR_RFWMSR_tag;

typedef union FR_RFSIR_union_tag {     /* Receive FIFO Start Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t SIDX:10;                 /* SIDXA/SIDXB - Start Index */
  } B;
} FR_RFSIR_tag;

typedef union FR_RFDSR_union_tag {     /* Receive FIFO Depth and Size Register */
  vuint16_t R;
  struct {
    vuint16_t FIFO_DEPTH:8;            /* FIFO_DEPTHA/FIFO_DEPTHB - FIFO Depth */
    vuint16_t _unused_7:1;
    vuint16_t ENTRY_SIZE:7;            /* ENTRY_SIZEA/ENTRY_SIZEB - Entry Size */
  } B;
} FR_RFDSR_tag;

typedef union FR_RFARIR_union_tag {    /* Receive FIFO A Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t RDIDX:10;
  } B;
} FR_RFARIR_tag;

typedef union FR_RFBRIR_union_tag {    /* Receive FIFO B Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t RDIDX:10;
  } B;
} FR_RFBRIR_tag;

typedef union FR_RFMIDAFVR_union_tag { /* Receive FIFO Message ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFVAL:16;             /* MIDAFVALA/MIDAFVALB - Message ID Acceptance Filter Value */
  } B;
} FR_RFMIDAFVR_tag;

typedef union FR_RFMIDAFMR_union_tag { /* Receive FIFO Message ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFMSK:16;             /* MIDAFMSKA/MIDAFMSKB - Message ID Acceptance Filter Mask */
  } B;
} FR_RFMIDAFMR_tag;

typedef union FR_RFFIDRFVR_union_tag { /* Receive FIFO Frame ID Rejection Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FIDRFVAL:11;             /* FIDRFVALA/FIDRFVALB - Frame ID Rejection Filter Value */
  } B;
} FR_RFFIDRFVR_tag;

typedef union FR_RFFIDRFMR_union_tag { /* Receive FIFO Frame ID Rejection Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FIDRFMSK:11;
  } B;
} FR_RFFIDRFMR_tag;

typedef union FR_RFRFCFR_union_tag {   /* Receive FIFO Range Filter Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t IBD:1;
    vuint16_t SEL:2;
    vuint16_t _unused_11:1;
    vuint16_t SID:11;                  /* Slot ID */
  } B;
} FR_RFRFCFR_tag;

typedef union FR_RFRFCTR_union_tag {   /* Receive FIFO Range Filter Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t F3MD:1;
    vuint16_t F2MD:1;
    vuint16_t F1MD:1;
    vuint16_t F0MD:1;
    vuint16_t _unused_4:4;
    vuint16_t F3EN:1;
    vuint16_t F2EN:1;
    vuint16_t F1EN:1;
    vuint16_t F0EN:1;
  } B;
} FR_RFRFCTR_tag;

typedef union FR_LDTXSLAR_union_tag {  /* Last Dynamic Transmit Slot Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t LDYNTXSLOTA:11;
  } B;
} FR_LDTXSLAR_tag;

typedef union FR_LDTXSLBR_union_tag {  /* Last Dynamic Transmit Slot Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t LDYNTXSLOTB:11;
  } B;
} FR_LDTXSLBR_tag;

typedef union FR_PCR0_union_tag {      /* Protocol Configuration Register 0 */
  vuint16_t R;
  struct {
    vuint16_t action_point_offset:6;
    vuint16_t static_slot_length:10;
  } B;
} FR_PCR0_tag;

typedef union FR_PCR1_union_tag {      /* Protocol Configuration Register 1 */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t macro_after_first_static_slot:14;
  } B;
} FR_PCR1_tag;

typedef union FR_PCR2_union_tag {      /* Protocol Configuration Register 2 */
  vuint16_t R;
  struct {
    vuint16_t minislot_after_action_point:6;
    vuint16_t number_of_static_slots:10; /* gNumberOfStaticSlots */
  } B;
} FR_PCR2_tag;

typedef union FR_PCR3_union_tag {      /* Protocol Configuration Register 3 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_symbol_rx_low:6;
    vuint16_t minislot_action_point_offset:5;
    vuint16_t coldstart_attempts:5;
  } B;
} FR_PCR3_tag;

typedef union FR_PCR4_union_tag {      /* Protocol Configuration Register 4 */
  vuint16_t R;
  struct {
    vuint16_t cas_rx_low_max:7;
    vuint16_t wakeup_symbol_rx_window:9;
  } B;
} FR_PCR4_tag;

typedef union FR_PCR5_union_tag {      /* Protocol Configuration Register 5 */
  vuint16_t R;
  struct {
    vuint16_t tss_transmitter:4;
    vuint16_t wakeup_symbol_tx_low:6;
    vuint16_t wakeup_symbol_rx_idle:6;
  } B;
} FR_PCR5_tag;

typedef union FR_PCR6_union_tag {      /* Protocol Configuration Register 6 */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t symbol_window_after_action_point:8;
    vuint16_t macro_initial_offset_a:7;
  } B;
} FR_PCR6_tag;

typedef union FR_PCR7_union_tag {      /* Protocol Configuration Register 7 */
  vuint16_t R;
  struct {
    vuint16_t decoding_correction_b:9;
    vuint16_t micro_per_macro_nom_half:7;
  } B;
} FR_PCR7_tag;

typedef union FR_PCR8_union_tag {      /* Protocol Configuration Register 8 */
  vuint16_t R;
  struct {
    vuint16_t max_without_clock_correction_fatal:4;
    vuint16_t max_without_clock_correction_passive:4;
    vuint16_t wakeup_symbol_tx_idle:8;
  } B;
} FR_PCR8_tag;

typedef union FR_PCR9_union_tag {      /* Protocol Configuration Register 9 */
  vuint16_t R;
  struct {
    vuint16_t minislot_exists:1;
    vuint16_t symbol_window_exists:1;
    vuint16_t offset_correction_out:14;
  } B;
} FR_PCR9_tag;

typedef union FR_PCR10_union_tag {     /* Protocol Configuration Register 10 */
  vuint16_t R;
  struct {
    vuint16_t single_slot_enabled:1;
    vuint16_t wakeup_channel:1;
    vuint16_t macro_per_cycle:14;
  } B;
} FR_PCR10_tag;

typedef union FR_PCR11_union_tag {     /* Protocol Configuration Register 11 */
  vuint16_t R;
  struct {
    vuint16_t key_slot_used_for_startup:1;
    vuint16_t key_slot_used_for_sync:1;
    vuint16_t offset_correction_start:14;
  } B;
} FR_PCR11_tag;

typedef union FR_PCR12_union_tag {     /* Protocol Configuration Register 12 */
  vuint16_t R;
  struct {
    vuint16_t allow_passive_to_active:5;
    vuint16_t key_slot_header_crc:11;
  } B;
} FR_PCR12_tag;

typedef union FR_PCR13_union_tag {     /* Protocol Configuration Register 13 */
  vuint16_t R;
  struct {
    vuint16_t first_minislot_action_point_offset:6;
    vuint16_t static_slot_after_action_point:10;
  } B;
} FR_PCR13_tag;

typedef union FR_PCR14_union_tag {     /* Protocol Configuration Register 14 */
  vuint16_t R;
  struct {
    vuint16_t rate_correction_out:11;
    vuint16_t listen_timeout:5;
  } B;
} FR_PCR14_tag;

typedef union FR_PCR15_union_tag {     /* Protocol Configuration Register 15 */
  vuint16_t R;
  struct {
    vuint16_t listen_timeout:16;
  } B;
} FR_PCR15_tag;

typedef union FR_PCR16_union_tag {     /* Protocol Configuration Register 16 */
  vuint16_t R;
  struct {
    vuint16_t macro_initial_offset_b:7;
    vuint16_t noise_listen_timeout:9;
  } B;
} FR_PCR16_tag;

typedef union FR_PCR17_union_tag {     /* Protocol Configuration Register 17 */
  vuint16_t R;
  struct {
    vuint16_t noise_listen_timeout:16;
  } B;
} FR_PCR17_tag;

typedef union FR_PCR18_union_tag {     /* Protocol Configuration Register 18 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_pattern:6;
    vuint16_t key_slot_id:10;
  } B;
} FR_PCR18_tag;

typedef union FR_PCR19_union_tag {     /* Protocol Configuration Register 19 */
  vuint16_t R;
  struct {
    vuint16_t decoding_correction_a:9;
    vuint16_t payload_length_static:7;
  } B;
} FR_PCR19_tag;

typedef union FR_PCR20_union_tag {     /* Protocol Configuration Register 20 */
  vuint16_t R;
  struct {
    vuint16_t micro_initial_offset_b:8;
    vuint16_t micro_initial_offset_a:8;
  } B;
} FR_PCR20_tag;

typedef union FR_PCR21_union_tag {     /* Protocol Configuration Register 21 */
  vuint16_t R;
  struct {
    vuint16_t extern_rate_correction:3;
    vuint16_t latest_tx:13;
  } B;
} FR_PCR21_tag;

typedef union FR_PCR22_union_tag {     /* Protocol Configuration Register 22 */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;            /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
    vuint16_t comp_accepted_startup_range_a:11;
    vuint16_t micro_per_cycle:4;
  } B;
} FR_PCR22_tag;

typedef union FR_PCR23_union_tag {     /* Protocol Configuration Register 23 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle:16;
  } B;
} FR_PCR23_tag;

typedef union FR_PCR24_union_tag {     /* Protocol Configuration Register 24 */
  vuint16_t R;
  struct {
    vuint16_t cluster_drift_damping:5;
    vuint16_t max_payload_length_dynamic:7;
    vuint16_t micro_per_cycle_min:4;
  } B;
} FR_PCR24_tag;

typedef union FR_PCR25_union_tag {     /* Protocol Configuration Register 25 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_min:16;
  } B;
} FR_PCR25_tag;

typedef union FR_PCR26_union_tag {     /* Protocol Configuration Register 26 */
  vuint16_t R;
  struct {
    vuint16_t allow_halt_due_to_clock:1;
    vuint16_t comp_accepted_startup_range_b:11;
    vuint16_t micro_per_cycle_max:4;
  } B;
} FR_PCR26_tag;

typedef union FR_PCR27_union_tag {     /* Protocol Configuration Register 27 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_max:16;
  } B;
} FR_PCR27_tag;

typedef union FR_PCR28_union_tag {     /* Protocol Configuration Register 28 */
  vuint16_t R;
  struct {
    vuint16_t dynamic_slot_idle_phase:2;
    vuint16_t macro_after_offset_correction:14;
  } B;
} FR_PCR28_tag;

typedef union FR_PCR29_union_tag {     /* Protocol Configuration Register 29 */
  vuint16_t R;
  struct {
    vuint16_t extern_offset_correction:3;
    vuint16_t minislots_max:13;
  } B;
} FR_PCR29_tag;

typedef union FR_PCR30_union_tag {     /* Protocol Configuration Register 30 */
  vuint16_t R;
  struct {
    vuint16_t _unused_4:12;
    vuint16_t sync_node_max:4;
  } B;
} FR_PCR30_tag;

typedef union FR_STPWHR_union_tag {    /* StopWatch Count High Register */
  vuint16_t R;
  struct {
    vuint16_t STPW_S_H:16;             /* StopWatch Count High */
  } B;
} FR_STPWHR_tag;

typedef union FR_STPWLR_union_tag {    /* Stop Watch Count Low Register */
  vuint16_t R;
  struct {
    vuint16_t STPW_S_L:16;             /* StopWatch Count Low */
  } B;
} FR_STPWLR_tag;

typedef union FR_PEOER_union_tag {     /* Protocol Event Output Enable and StopWatch Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_9:7;
    vuint16_t STPW_EN:1;               /* Stopwatch count Enable */
    vuint16_t _unused_3:5;
    vuint16_t TIM2_EE:1;
    vuint16_t TIM1_EE:1;
    vuint16_t CYC_EE:1;
  } B;
} FR_PEOER_tag;

typedef union FR_RFSDOR_union_tag {    /* Receive FIFO Start Data Offset Register */
  vuint16_t R;
  struct {
    vuint16_t SDO:16;                  /* SDOA/SDOB - Start Data Field Offset */
  } B;
} FR_RFSDOR_tag;

typedef union FR_RFSYMBADHR_union_tag { /* Receive FIFO System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;
  } B;
} FR_RFSYMBADHR_tag;

typedef union FR_RFSYMBADLR_union_tag { /* Receive FIFO System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:12;
    vuint16_t _unused_0:4;
  } B;
} FR_RFSYMBADLR_tag;

typedef union FR_RFPTR_union_tag {     /* Receive FIFO Periodic Timer Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t PTD:14;
  } B;
} FR_RFPTR_tag;

typedef union FR_RFFLPCR_union_tag {   /* Receive FIFO Fill Level and POP Count Register */
  vuint16_t R;
  struct {
    vuint16_t FLB_or_PCB:8;
    vuint16_t FLA_or_PCA:8;
  } B;
} FR_RFFLPCR_tag;

typedef union FR_EEIFER_union_tag {    /* ECC Error Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t LRNE_OF:1;
    vuint16_t LRCE_OF:1;
    vuint16_t DRNE_OF:1;
    vuint16_t DRCE_OF:1;
    vuint16_t LRNE_IF:1;
    vuint16_t LRCE_IF:1;
    vuint16_t DRNE_IF:1;
    vuint16_t DRCE_IF:1;
    vuint16_t _unused_4:4;
    vuint16_t LRNE_IE:1;
    vuint16_t LRCE_IE:1;
    vuint16_t DRNE_IE:1;
    vuint16_t DRCE_IE:1;
  } B;
} FR_EEIFER_tag;

typedef union FR_EERICR_union_tag {    /* ECC Error Report and Injection Control Register */
  vuint16_t R;
  struct {
    vuint16_t BSY:1;
    vuint16_t _unused_10:5;
    vuint16_t ERS:2;
    vuint16_t _unused_5:3;
    vuint16_t ERM:1;
    vuint16_t _unused_2:2;
    vuint16_t EIM:1;
    vuint16_t EIE:1;
  } B;
} FR_EERICR_tag;

typedef union FR_EERAR_union_tag {     /* ECC Error Report Address Register */
  vuint16_t R;
  struct {
    vuint16_t MID:1;
    vuint16_t BANK:3;
    vuint16_t ADDR:12;
  } B;
} FR_EERAR_tag;

typedef union FR_EERDR_union_tag {     /* ECC Error Report Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_EERDR_tag;

typedef union FR_EERCR_union_tag {     /* ECC Error Report Code Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_5:11;
    vuint16_t CODE:5;
  } B;
} FR_EERCR_tag;

typedef union FR_EEIAR_union_tag {     /* ECC Error Injection Address Register */
  vuint16_t R;
  struct {
    vuint16_t MID:1;
    vuint16_t BANK:3;
    vuint16_t ADDR:12;
  } B;
} FR_EEIAR_tag;

typedef union FR_EEIDR_union_tag {     /* ECC Error Injection Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_EEIDR_tag;

typedef union FR_EEICR_union_tag {     /* ECC Error Injection Code Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_5:11;
    vuint16_t CODE:5;
  } B;
} FR_EEICR_tag;

typedef union FR_MB_CCSR_union_tag {   /* Message Buffer Configuration, Control, Status Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_13:3;
    vuint16_t MTD:1;
    vuint16_t CMT:1;
    vuint16_t EDT:1;
    vuint16_t LCKT:1;
    vuint16_t MBIE:1;
    vuint16_t _unused_5:3;
    vuint16_t DUP:1;
    vuint16_t DVAL:1;
    vuint16_t EDS:1;
    vuint16_t LCKS:1;
    vuint16_t MBIF:1;
  } B;
} FR_MB_CCSR_tag;

typedef union FR_MB_CCFR_union_tag {   /* Message Buffer Cycle Counter Filter Register */
  vuint16_t R;
  struct {
    vuint16_t MTM:1;
    vuint16_t CHA:1;
    vuint16_t CHB:1;
    vuint16_t CCFE:1;
    vuint16_t CCFMSK:6;
    vuint16_t CCFVAL:6;
  } B;
} FR_MB_CCFR_tag;

typedef union FR_MB_FIDR_union_tag {   /* Message Buffer Frame ID Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FID:11;
  } B;
} FR_MB_FIDR_tag;

typedef union FR_MB_IDXR_union_tag {   /* Message Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t MBIDX:8;
  } B;
} FR_MB_IDXR_tag;

typedef struct FR_MB_struct_tag {
  FR_MB_CCSR_tag CCSR;                 /* Message Buffer Configuration, Control, Status Register */
  FR_MB_CCFR_tag CCFR;                 /* Message Buffer Cycle Counter Filter Register */
  FR_MB_FIDR_tag FIDR;                 /* Message Buffer Frame ID Register */
  FR_MB_IDXR_tag IDXR;                 /* Message Buffer Index Register */
} FR_MB_tag;

typedef union FR_MBDOR_union_tag {     /* Message Buffer Data Field Offset Register */
  vuint16_t R;
  struct {
    vuint16_t MBDO:16;
  } B;
} FR_MBDOR_tag;

typedef union FR_LEETR_union_tag {     /* LRAM ECC Error Test Register */
  vuint16_t R;
  struct {
    vuint16_t LEETD:16;
  } B;
} FR_LEETR_tag;

struct FR_tag {
  FR_MVR_tag MVR;                      /* Module Version Register */
  FR_MCR_tag MCR;                      /* Module Configuration Register */
  FR_SYMBADHR_tag SYMBADHR;            /* System Memory Base Address High Register */
  FR_SYMBADLR_tag SYMBADLR;            /* System Memory Base Address Low Register */
  FR_STBSCR_tag STBSCR;                /* Strobe Signal Control Register */
  uint8_t FR_reserved0[2];
  FR_MBDSR_tag MBDSR;                  /* Message Buffer Data Size Register */
  FR_MBSSUTR_tag MBSSUTR;              /* Message Buffer Segment Size and Utilization Register */
  FR_PEDRAR_tag PEDRAR;                /* PE DRAM Access Register */
  FR_PEDRDR_tag PEDRDR;                /* PE DRAM Data Register */
  FR_POCR_tag POCR;                    /* Protocol Operation Control Register */
  FR_GIFER_tag GIFER;                  /* Global Interrupt Flag and Enable Register */
  FR_PIFR0_tag PIFR0;                  /* Protocol Interrupt Flag Register 0 */
  FR_PIFR1_tag PIFR1;                  /* Protocol Interrupt Flag Register 1 */
  FR_PIER0_tag PIER0;                  /* Protocol Interrupt Enable Register 0 */
  FR_PIER1_tag PIER1;                  /* Protocol Interrupt Enable Register 1 */
  FR_CHIERFR_tag CHIERFR;              /* CHI Error Flag Register */
  FR_MBIVEC_tag MBIVEC;                /* Message Buffer Interrupt Vector Register */
  FR_CASERCR_tag CASERCR;              /* Channel A Status Error Counter Register */
  FR_CBSERCR_tag CBSERCR;              /* Channel B Status Error Counter Register */
  FR_PSR0_tag PSR0;                    /* Protocol Status Register 0 */
  FR_PSR1_tag PSR1;                    /* Protocol Status Register 1 */
  FR_PSR2_tag PSR2;                    /* Protocol Status Register 2 */
  FR_PSR3_tag PSR3;                    /* Protocol Status Register 3 */
  FR_MTCTR_tag MTCTR;                  /* Macrotick Counter Register */
  FR_CYCTR_tag CYCTR;                  /* Cycle Counter Register */
  FR_SLTCTAR_tag SLTCTAR;              /* Slot Counter Channel A Register */
  FR_SLTCTBR_tag SLTCTBR;              /* Slot Counter Channel B Register */
  FR_RTCORVR_tag RTCORVR;              /* Rate Correction Value Register */
  FR_OFCORVR_tag OFCORVR;              /* Offset Correction Value Register */
  FR_CIFR_tag CIFR;                    /* Combined Interrupt Flag Register */
  FR_SYMATOR_tag SYMATOR;              /* System Memory Access Time-Out Register */
  FR_SFCNTR_tag SFCNTR;                /* Sync Frame Counter Register */
  FR_SFTOR_tag SFTOR;                  /* Sync Frame Table Offset Register */
  FR_SFTCCSR_tag SFTCCSR;              /* Sync Frame Table Configuration, Control, Status Register */
  FR_SFIDRFR_tag SFIDRFR;              /* Sync Frame ID Rejection Filter Register */
  FR_SFIDAFVR_tag SFIDAFVR;            /* Sync Frame ID Acceptance Filter Value Register */
  FR_SFIDAFMR_tag SFIDAFMR;            /* Sync Frame ID Acceptance Filter Mask Register */
  FR_NMVR_tag NMVR[6];                 /* Network Management Vector Register */
  FR_NMVLR_tag NMVLR;                  /* Network Management Vector Length Register */
  FR_TICCR_tag TICCR;                  /* Timer Configuration and Control Register */
  FR_TI1CYSR_tag TI1CYSR;              /* Timer 1 Cycle Set Register */
  FR_TI1MTOR_tag TI1MTOR;              /* Timer 1 Macrotick Offset Register */
  FR_TI2CR0_tag TI2CR0;
  FR_TI2CR1_tag TI2CR1;
  FR_SSSR_tag SSSR;                    /* Slot Status Selection Register */
  FR_SSCCR_tag SSCCR;                  /* Slot Status Counter Condition Register */
  FR_SSR_tag SSR[8];                   /* Slot Status Register */
  FR_SSCR_tag SSCR[4];                 /* Slot Status Counter Register */
  FR_MTSACFR_tag MTSACFR;              /* MTS A Configuration Register */
  FR_MTSBCFR_tag MTSBCFR;              /* MTS B Configuration Register */
  FR_RSBIR_tag RSBIR;                  /* Receive Shadow Buffer Index Register */
  FR_RFWMSR_tag RFWMSR;                /* Receive FIFO Watermark and Selection Register */
  FR_RFSIR_tag RFSIR;                  /* Receive FIFO Start Index Register */
  FR_RFDSR_tag RFDSR;                  /* Receive FIFO Depth and Size Register */
  FR_RFARIR_tag RFARIR;                /* Receive FIFO A Read Index Register */
  FR_RFBRIR_tag RFBRIR;                /* Receive FIFO B Read Index Register */
  FR_RFMIDAFVR_tag RFMIDAFVR;          /* Receive FIFO Message ID Acceptance Filter Value Register */
  FR_RFMIDAFMR_tag RFMIDAFMR;          /* Receive FIFO Message ID Acceptance Filter Mask Register */
  FR_RFFIDRFVR_tag RFFIDRFVR;          /* Receive FIFO Frame ID Rejection Filter Value Register */
  FR_RFFIDRFMR_tag RFFIDRFMR;          /* Receive FIFO Frame ID Rejection Filter Mask Register */
  FR_RFRFCFR_tag RFRFCFR;              /* Receive FIFO Range Filter Configuration Register */
  FR_RFRFCTR_tag RFRFCTR;              /* Receive FIFO Range Filter Control Register */
  FR_LDTXSLAR_tag LDTXSLAR;            /* Last Dynamic Transmit Slot Channel A Register */
  FR_LDTXSLBR_tag LDTXSLBR;            /* Last Dynamic Transmit Slot Channel B Register */
  FR_PCR0_tag PCR0;                    /* Protocol Configuration Register 0 */
  FR_PCR1_tag PCR1;                    /* Protocol Configuration Register 1 */
  FR_PCR2_tag PCR2;                    /* Protocol Configuration Register 2 */
  FR_PCR3_tag PCR3;                    /* Protocol Configuration Register 3 */
  FR_PCR4_tag PCR4;                    /* Protocol Configuration Register 4 */
  FR_PCR5_tag PCR5;                    /* Protocol Configuration Register 5 */
  FR_PCR6_tag PCR6;                    /* Protocol Configuration Register 6 */
  FR_PCR7_tag PCR7;                    /* Protocol Configuration Register 7 */
  FR_PCR8_tag PCR8;                    /* Protocol Configuration Register 8 */
  FR_PCR9_tag PCR9;                    /* Protocol Configuration Register 9 */
  FR_PCR10_tag PCR10;                  /* Protocol Configuration Register 10 */
  FR_PCR11_tag PCR11;                  /* Protocol Configuration Register 11 */
  FR_PCR12_tag PCR12;                  /* Protocol Configuration Register 12 */
  FR_PCR13_tag PCR13;                  /* Protocol Configuration Register 13 */
  FR_PCR14_tag PCR14;                  /* Protocol Configuration Register 14 */
  FR_PCR15_tag PCR15;                  /* Protocol Configuration Register 15 */
  FR_PCR16_tag PCR16;                  /* Protocol Configuration Register 16 */
  FR_PCR17_tag PCR17;                  /* Protocol Configuration Register 17 */
  FR_PCR18_tag PCR18;                  /* Protocol Configuration Register 18 */
  FR_PCR19_tag PCR19;                  /* Protocol Configuration Register 19 */
  FR_PCR20_tag PCR20;                  /* Protocol Configuration Register 20 */
  FR_PCR21_tag PCR21;                  /* Protocol Configuration Register 21 */
  FR_PCR22_tag PCR22;                  /* Protocol Configuration Register 22 */
  FR_PCR23_tag PCR23;                  /* Protocol Configuration Register 23 */
  FR_PCR24_tag PCR24;                  /* Protocol Configuration Register 24 */
  FR_PCR25_tag PCR25;                  /* Protocol Configuration Register 25 */
  FR_PCR26_tag PCR26;                  /* Protocol Configuration Register 26 */
  FR_PCR27_tag PCR27;                  /* Protocol Configuration Register 27 */
  FR_PCR28_tag PCR28;                  /* Protocol Configuration Register 28 */
  FR_PCR29_tag PCR29;                  /* Protocol Configuration Register 29 */
  FR_PCR30_tag PCR30;                  /* Protocol Configuration Register 30 */
  FR_STPWHR_tag STPWHR;                /* StopWatch Count High Register */
  FR_STPWLR_tag STPWLR;                /* Stop Watch Count Low Register */
  FR_PEOER_tag PEOER;                  /* Protocol Event Output Enable and StopWatch Control Register */
  uint8_t FR_reserved1[2];
  FR_RFSDOR_tag RFSDOR;                /* Receive FIFO Start Data Offset Register */
  FR_RFSYMBADHR_tag RFSYMBADHR;        /* Receive FIFO System Memory Base Address High Register */
  FR_RFSYMBADLR_tag RFSYMBADLR;        /* Receive FIFO System Memory Base Address Low Register */
  FR_RFPTR_tag RFPTR;                  /* Receive FIFO Periodic Timer Register */
  FR_RFFLPCR_tag RFFLPCR;              /* Receive FIFO Fill Level and POP Count Register */
  FR_EEIFER_tag EEIFER;                /* ECC Error Interrupt Flag and Enable Register */
  FR_EERICR_tag EERICR;                /* ECC Error Report and Injection Control Register */
  FR_EERAR_tag EERAR;                  /* ECC Error Report Address Register */
  FR_EERDR_tag EERDR;                  /* ECC Error Report Data Register */
  FR_EERCR_tag EERCR;                  /* ECC Error Report Code Register */
  FR_EEIAR_tag EEIAR;                  /* ECC Error Injection Address Register */
  FR_EEIDR_tag EEIDR;                  /* ECC Error Injection Data Register */
  FR_EEICR_tag EEICR;                  /* ECC Error Injection Code Register */
  uint8_t FR_reserved2[1792];
  FR_MB_tag MB[128];
  uint8_t FR_reserved3[1024];
  FR_MBDOR_tag MBDOR[132];             /* Message Buffer Data Field Offset Register */
  FR_LEETR_tag LEETR[6];               /* LRAM ECC Error Test Register */
};


/* ============================================================================
   =============================== Module: GPR ================================
   ============================================================================ */

typedef union GPR_CTL_union_tag {      /* GPR Control Register */
  vuint32_t R;
  struct {
    vuint32_t HSM_RAM_FAST_INIT_BYPASS:1;
    vuint32_t _unused_29:2;
    vuint32_t EXTREGC:1;               /* This bit enables the external regulator control multiplexed function on PG[6] */
    vuint32_t DEST_ESC_CTRL2:1;        /* Enables the escalation of destructive reset source: SWT0 reset request. This bit will be reset on POR. */
    vuint32_t DEST_ESC_CTRL1:1;        /* Enables the escalation of destructive reset source: functional reset escalation. This bit will be reset on POR. */
    vuint32_t DEST_ESC_CTRL0:1;        /* Enables the escalation of destructive reset source: SSCM secured reset. This bit will be reset on POR. */
    vuint32_t _unused_20:5;
    vuint32_t CMP2_STDBY:1;
    vuint32_t CMP1_STDBY:1;
    vuint32_t CMP0_STDBY:1;
    vuint32_t CLKOUT1_STDBY:1;
    vuint32_t LPU_STOP_ACK_BYPASS:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_13:1;
    vuint32_t RTC_SXOSC_FREE_RUNNING:1; /* Enables seamless RTC operation across functional and destructive reset in the specific case when RTC is running on SXOSC. This Bit should be set after SXOSC is enabled by the software. */
    vuint32_t CMP_ACT_SAM:1;           /* Actual sample to the CMP */
    vuint32_t CMP_SAMP_SEL:1;          /* Sample select to the CMP */
    vuint32_t USDHC_BS:2;              /* uSDHC byte_swapper: Swaps the AHB write/read data at the boundary of uSDHC master */
    vuint32_t MLB_BS:2;                /* MLB byte swapper: Swaps the AHB write/read data at the boundary of MLB master */
    vuint32_t FR_BS:2;                 /* FlexRay byte swapper: Swaps the AHB write/read data at the boundary of FlexRay master */
    vuint32_t ENET_TX_BS:2;            /* ENET TX byte swapper: Swaps the AHB write/read data at the TX boundary of ENET master */
    vuint32_t ENET_RX_BS:2;            /* ENET RX byte swapper: Swaps the AHB write/read data at the RX boundary of ENET master */
  } B;
} GPR_CTL_tag;

typedef union GPR_STAT_union_tag {     /* GPR Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t FLASH_LP_ACK:1;          /* FLASH low power acknowledge status */
    vuint32_t _unused_2:8;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} GPR_STAT_tag;

typedef union GPR_CTL1_union_tag {     /* GPR Control Register1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t _unused_24:3;
    vuint32_t IVPR:24;                 /* Interrupt Vector Prefix Register Programming */
  } B;
} GPR_CTL1_tag;

struct GPR_tag {
  GPR_CTL_tag CTL;                     /* GPR Control Register */
  GPR_STAT_tag STAT;                   /* GPR Status Register */
  uint8_t GPR_reserved0[8];
  GPR_CTL1_tag CTL1;                   /* GPR Control Register1 */
};


/* ============================================================================
   =============================== Module: I2C ================================
   ============================================================================ */

typedef union I2C_IBAD_union_tag {     /* I2C Bus Address Register */
  vuint8_t R;
  struct {
    vuint8_t ADR:7;
    vuint8_t _unused_0:1;
  } B;
} I2C_IBAD_tag;

typedef union I2C_IBFD_union_tag {     /* I2C Bus Frequency Divider Register */
  vuint8_t R;
  struct {
    vuint8_t IBC:8;
  } B;
} I2C_IBFD_tag;

typedef union I2C_IBCR_union_tag {     /* I2C Bus Control Register */
  vuint8_t R;
  struct {
    vuint8_t MDIS:1;
    vuint8_t IBIE:1;
    vuint8_t MSSL:1;
    vuint8_t TXRX:1;
    vuint8_t NOACK:1;
    vuint8_t RSTA:1;
    vuint8_t DMAEN:1;
    vuint8_t _unused_0:1;
  } B;
} I2C_IBCR_tag;

typedef union I2C_IBSR_union_tag {     /* I2C Bus Status Register */
  vuint8_t R;
  struct {
    vuint8_t TCF:1;
    vuint8_t IAAS:1;
    vuint8_t IBB:1;
    vuint8_t IBAL:1;
    vuint8_t _unused_3:1;
    vuint8_t SRW:1;
    vuint8_t IBIF:1;
    vuint8_t RXAK:1;
  } B;
} I2C_IBSR_tag;

typedef union I2C_IBDR_union_tag {     /* I2C Bus Data I/O Register */
  vuint8_t R;
  struct {
    vuint8_t DATA:8;
  } B;
} I2C_IBDR_tag;

typedef union I2C_IBIC_union_tag {     /* I2C Bus Interrupt Config Register */
  vuint8_t R;
  struct {
    vuint8_t BIIE:1;
    vuint8_t BYTERXIE:1;
    vuint8_t _unused_0:6;
  } B;
} I2C_IBIC_tag;

typedef union I2C_IBDBG_union_tag {    /* I2C Bus Debug Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_3:5;
    vuint8_t BYTE_RX:1;
    vuint8_t IPG_DEBUG_HALTED:1;
    vuint8_t IPG_DEBUG_EN:1;
  } B;
} I2C_IBDBG_tag;

struct I2C_tag {
  I2C_IBAD_tag IBAD;                   /* I2C Bus Address Register */
  I2C_IBFD_tag IBFD;                   /* I2C Bus Frequency Divider Register */
  I2C_IBCR_tag IBCR;                   /* I2C Bus Control Register */
  I2C_IBSR_tag IBSR;                   /* I2C Bus Status Register */
  I2C_IBDR_tag IBDR;                   /* I2C Bus Data I/O Register */
  I2C_IBIC_tag IBIC;                   /* I2C Bus Interrupt Config Register */
  I2C_IBDBG_tag IBDBG;                 /* I2C Bus Debug Register */
};


/* ============================================================================
   =============================== Module: I2S ================================
   ============================================================================ */

typedef union I2S_TCSR_union_tag {     /* SAI Transmit Control Register */
  vuint32_t R;
  struct {
    vuint32_t TE:1;                    /* Transmitter Enable */
    vuint32_t STOPE:1;                 /* Stop Enable */
    vuint32_t DBGE:1;                  /* Debug Enable */
    vuint32_t BCE:1;                   /* Bit Clock Enable */
    vuint32_t _unused_26:2;
    vuint32_t FR:1;                    /* FIFO Reset */
    vuint32_t SR:1;                    /* Software Reset */
    vuint32_t _unused_21:3;
    vuint32_t WSF:1;                   /* Word Start Flag */
    vuint32_t SEF:1;                   /* Sync Error Flag */
    vuint32_t FEF:1;                   /* FIFO Error Flag */
    vuint32_t FWF:1;                   /* FIFO Warning Flag */
    vuint32_t FRF:1;                   /* FIFO Request Flag */
    vuint32_t _unused_13:3;
    vuint32_t WSIE:1;                  /* Word Start Interrupt Enable */
    vuint32_t SEIE:1;                  /* Sync Error Interrupt Enable */
    vuint32_t FEIE:1;                  /* FIFO Error Interrupt Enable */
    vuint32_t FWIE:1;                  /* FIFO Warning Interrupt Enable */
    vuint32_t FRIE:1;                  /* FIFO Request Interrupt Enable */
    vuint32_t _unused_5:3;
    vuint32_t _unused_2:3;
    vuint32_t FWDE:1;                  /* FIFO Warning DMA Enable */
    vuint32_t FRDE:1;                  /* FIFO Request DMA Enable */
  } B;
} I2S_TCSR_tag;

typedef union I2S_TCR1_union_tag {     /* SAI Transmit Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t TFW:3;                   /* Transmit FIFO Watermark */
  } B;
} I2S_TCR1_tag;

typedef union I2S_TCR2_union_tag {     /* SAI Transmit Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t SYNC:2;                  /* Synchronous Mode */
    vuint32_t BCS:1;                   /* Bit Clock Swap */
    vuint32_t BCI:1;                   /* Bit Clock Input */
    vuint32_t MSEL:2;                  /* MCLK Select */
    vuint32_t BCP:1;                   /* Bit Clock Polarity */
    vuint32_t BCD:1;                   /* Bit Clock Direction */
    vuint32_t _unused_8:16;
    vuint32_t DIV:8;                   /* Bit Clock Divide */
  } B;
} I2S_TCR2_tag;

typedef union I2S_TCR3_union_tag {     /* SAI Transmit Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t CFR:4;                   /* Channel FIFO Reset */
    vuint32_t _unused_20:4;
    vuint32_t TCE:4;                   /* Transmit Channel Enable */
    vuint32_t _unused_4:12;
    vuint32_t WDFL:4;                  /* Word Flag Configuration */
  } B;
} I2S_TCR3_tag;

typedef union I2S_TCR4_union_tag {     /* SAI Transmit Configuration 4 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t FCONT:1;                 /* FIFO Continue on Error */
    vuint32_t FCOMB:2;                 /* FIFO Combine Mode */
    vuint32_t FPACK:2;                 /* FIFO Packing Mode */
    vuint32_t _unused_20:4;
    vuint32_t FRSZ:4;                  /* Frame size */
    vuint32_t _unused_13:3;
    vuint32_t SYWD:5;                  /* Sync Width */
    vuint32_t _unused_5:3;
    vuint32_t MF:1;                    /* MSB First */
    vuint32_t FSE:1;                   /* Frame Sync Early */
    vuint32_t ONDEM:1;                 /* On Demand Mode */
    vuint32_t FSP:1;                   /* Frame Sync Polarity */
    vuint32_t FSD:1;                   /* Frame Sync Direction */
  } B;
} I2S_TCR4_tag;

typedef union I2S_TCR5_union_tag {     /* SAI Transmit Configuration 5 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t WNW:5;                   /* Word N Width */
    vuint32_t _unused_21:3;
    vuint32_t W0W:5;                   /* Word 0 Width */
    vuint32_t _unused_13:3;
    vuint32_t FBT:5;                   /* First Bit Shifted */
    vuint32_t _unused_0:8;
  } B;
} I2S_TCR5_tag;

typedef union I2S_TDR_union_tag {      /* SAI Transmit Data Register */
  vuint32_t R;
  struct {
    vuint32_t TDR:32;                  /* Transmit Data Register */
  } B;
} I2S_TDR_tag;

typedef union I2S_TFR_union_tag {      /* SAI Transmit FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t WCP:1;                   /* Write Channel Pointer */
    vuint32_t _unused_20:11;
    vuint32_t WFP:4;                   /* Write FIFO Pointer */
    vuint32_t _unused_4:12;
    vuint32_t RFP:4;                   /* Read FIFO Pointer */
  } B;
} I2S_TFR_tag;

typedef union I2S_TMR_union_tag {      /* SAI Transmit Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TWM:16;                  /* Transmit Word Mask */
  } B;
} I2S_TMR_tag;

typedef union I2S_RCSR_union_tag {     /* SAI Receive Control Register */
  vuint32_t R;
  struct {
    vuint32_t RE:1;                    /* Receiver Enable */
    vuint32_t STOPE:1;                 /* Stop Enable */
    vuint32_t DBGE:1;                  /* Debug Enable */
    vuint32_t BCE:1;                   /* Bit Clock Enable */
    vuint32_t _unused_26:2;
    vuint32_t FR:1;                    /* FIFO Reset */
    vuint32_t SR:1;                    /* Software Reset */
    vuint32_t _unused_21:3;
    vuint32_t WSF:1;                   /* Word Start Flag */
    vuint32_t SEF:1;                   /* Sync Error Flag */
    vuint32_t FEF:1;                   /* FIFO Error Flag */
    vuint32_t FWF:1;                   /* FIFO Warning Flag */
    vuint32_t FRF:1;                   /* FIFO Request Flag */
    vuint32_t _unused_13:3;
    vuint32_t WSIE:1;                  /* Word Start Interrupt Enable */
    vuint32_t SEIE:1;                  /* Sync Error Interrupt Enable */
    vuint32_t FEIE:1;                  /* FIFO Error Interrupt Enable */
    vuint32_t FWIE:1;                  /* FIFO Warning Interrupt Enable */
    vuint32_t FRIE:1;                  /* FIFO Request Interrupt Enable */
    vuint32_t _unused_5:3;
    vuint32_t _unused_2:3;
    vuint32_t FWDE:1;                  /* FIFO Warning DMA Enable */
    vuint32_t FRDE:1;                  /* FIFO Request DMA Enable */
  } B;
} I2S_RCSR_tag;

typedef union I2S_RCR1_union_tag {     /* SAI Receive Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t RFW:3;                   /* Receive FIFO Watermark */
  } B;
} I2S_RCR1_tag;

typedef union I2S_RCR2_union_tag {     /* SAI Receive Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t SYNC:2;                  /* Synchronous Mode */
    vuint32_t BCS:1;                   /* Bit Clock Swap */
    vuint32_t BCI:1;                   /* Bit Clock Input */
    vuint32_t MSEL:2;                  /* MCLK Select */
    vuint32_t BCP:1;                   /* Bit Clock Polarity */
    vuint32_t BCD:1;                   /* Bit Clock Direction */
    vuint32_t _unused_8:16;
    vuint32_t DIV:8;                   /* Bit Clock Divide */
  } B;
} I2S_RCR2_tag;

typedef union I2S_RCR3_union_tag {     /* SAI Receive Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t CFR:4;                   /* Channel FIFO Reset */
    vuint32_t _unused_20:4;
    vuint32_t RCE:4;                   /* Receive Channel Enable */
    vuint32_t _unused_4:12;
    vuint32_t WDFL:4;                  /* Word Flag Configuration */
  } B;
} I2S_RCR3_tag;

typedef union I2S_RCR4_union_tag {     /* SAI Receive Configuration 4 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t FCONT:1;                 /* FIFO Continue on Error */
    vuint32_t FCOMB:2;                 /* FIFO Combine Mode */
    vuint32_t FPACK:2;                 /* FIFO Packing Mode */
    vuint32_t _unused_20:4;
    vuint32_t FRSZ:4;                  /* Frame Size */
    vuint32_t _unused_13:3;
    vuint32_t SYWD:5;                  /* Sync Width */
    vuint32_t _unused_5:3;
    vuint32_t MF:1;                    /* MSB First */
    vuint32_t FSE:1;                   /* Frame Sync Early */
    vuint32_t ONDEM:1;                 /* On Demand Mode */
    vuint32_t FSP:1;                   /* Frame Sync Polarity */
    vuint32_t FSD:1;                   /* Frame Sync Direction */
  } B;
} I2S_RCR4_tag;

typedef union I2S_RCR5_union_tag {     /* SAI Receive Configuration 5 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t WNW:5;                   /* Word N Width */
    vuint32_t _unused_21:3;
    vuint32_t W0W:5;                   /* Word 0 Width */
    vuint32_t _unused_13:3;
    vuint32_t FBT:5;                   /* First Bit Shifted */
    vuint32_t _unused_0:8;
  } B;
} I2S_RCR5_tag;

typedef union I2S_RDR_union_tag {      /* SAI Receive Data Register */
  vuint32_t R;
  struct {
    vuint32_t RDR:32;                  /* Receive Data Register */
  } B;
} I2S_RDR_tag;

typedef union I2S_RFR_union_tag {      /* SAI Receive FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t WFP:4;                   /* Write FIFO Pointer */
    vuint32_t RCP:1;                   /* Receive Channel Pointer */
    vuint32_t _unused_4:11;
    vuint32_t RFP:4;                   /* Read FIFO Pointer */
  } B;
} I2S_RFR_tag;

typedef union I2S_RMR_union_tag {      /* SAI Receive Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t RWM:16;                  /* Receive Word Mask */
  } B;
} I2S_RMR_tag;

typedef union I2S_MCR_union_tag {      /* SAI MCLK Control Register */
  vuint32_t R;
  struct {
    vuint32_t DUF:1;                   /* Divider Update Flag */
    vuint32_t MOE:1;                   /* MCLK Output Enable */
    vuint32_t _unused_26:4;
    vuint32_t MICS:2;                  /* MCLK Input Clock Select */
    vuint32_t _unused_0:24;
  } B;
} I2S_MCR_tag;

typedef union I2S_MDR_union_tag {      /* SAI MCLK Divide Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t FRACT:9;                 /* MCLK Fraction */
    vuint32_t DIVIDE:12;               /* MCLK Divide */
  } B;
} I2S_MDR_tag;

struct I2S_tag {
  I2S_TCSR_tag TCSR;                   /* SAI Transmit Control Register */
  I2S_TCR1_tag TCR1;                   /* SAI Transmit Configuration 1 Register */
  I2S_TCR2_tag TCR2;                   /* SAI Transmit Configuration 2 Register */
  I2S_TCR3_tag TCR3;                   /* SAI Transmit Configuration 3 Register */
  I2S_TCR4_tag TCR4;                   /* SAI Transmit Configuration 4 Register */
  I2S_TCR5_tag TCR5;                   /* SAI Transmit Configuration 5 Register */
  uint8_t I2S_reserved0[8];
  I2S_TDR_tag TDR[4];                  /* SAI Transmit Data Register */
  uint8_t I2S_reserved1[16];
  I2S_TFR_tag TFR[4];                  /* SAI Transmit FIFO Register */
  uint8_t I2S_reserved2[16];
  I2S_TMR_tag TMR;                     /* SAI Transmit Mask Register */
  uint8_t I2S_reserved3[28];
  I2S_RCSR_tag RCSR;                   /* SAI Receive Control Register */
  I2S_RCR1_tag RCR1;                   /* SAI Receive Configuration 1 Register */
  I2S_RCR2_tag RCR2;                   /* SAI Receive Configuration 2 Register */
  I2S_RCR3_tag RCR3;                   /* SAI Receive Configuration 3 Register */
  I2S_RCR4_tag RCR4;                   /* SAI Receive Configuration 4 Register */
  I2S_RCR5_tag RCR5;                   /* SAI Receive Configuration 5 Register */
  uint8_t I2S_reserved4[8];
  I2S_RDR_tag RDR[4];                  /* SAI Receive Data Register */
  uint8_t I2S_reserved5[16];
  I2S_RFR_tag RFR[4];                  /* SAI Receive FIFO Register */
  uint8_t I2S_reserved6[16];
  I2S_RMR_tag RMR;                     /* SAI Receive Mask Register */
  uint8_t I2S_reserved7[28];
  I2S_MCR_tag MCR;                     /* SAI MCLK Control Register */
  I2S_MDR_tag MDR;                     /* SAI MCLK Divide Register */
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

typedef union INTC_BCR_union_tag {     /* INTC Block Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t _unused_12:1;
    vuint32_t _unused_9:3;
    vuint32_t HVEN2:1;
    vuint32_t _unused_5:3;
    vuint32_t HVEN1:1;
    vuint32_t _unused_1:3;
    vuint32_t HVEN0:1;
  } B;
} INTC_BCR_tag;

typedef union INTC_MPROT_union_tag {   /* INTC Master Protection Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t ID:2;
    vuint32_t _unused_1:3;
    vuint32_t MPROT:1;
  } B;
} INTC_MPROT_tag;

typedef union INTC_CPR_union_tag {     /* INTC Current Priority Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t PRI:4;
  } B;
} INTC_CPR_tag;

typedef union INTC_IACKR_union_tag {   /* INTC Interrupt Acknowledge Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t VTBA:20;
    vuint32_t INTVEC:10;
    vuint32_t _unused_0:2;
  } B;
} INTC_IACKR_tag;

typedef union INTC_EOIR_union_tag {    /* INTC End Of Interrupt Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t EOI:32;
  } B;
} INTC_EOIR_tag;

typedef union INTC_SSCIR_union_tag {   /* INTC Software Set/Clear Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_2:6;
    vuint8_t SET:1;
    vuint8_t CLR:1;
  } B;
} INTC_SSCIR_tag;

typedef union INTC_PSR_union_tag {     /* INTC Priority Select Register */
  vuint16_t R;
  struct {
    vuint16_t PRC_SELN0:1;
    vuint16_t PRC_SELN1:1;
    vuint16_t PRC_SELN2:1;
    vuint16_t _unused_12:1;
    vuint16_t _unused_9:3;
    vuint16_t SWTN:1;
    vuint16_t _unused_4:4;
    vuint16_t PRIN:4;
  } B;
} INTC_PSR_tag;

struct INTC_tag {
  INTC_BCR_tag BCR;                    /* INTC Block Configuration Register */
  INTC_MPROT_tag MPROT;                /* INTC Master Protection Register */
  uint8_t INTC_reserved0[8];
  INTC_CPR_tag CPR[3];                 /* INTC Current Priority Register for Processor 0 */
  uint8_t INTC_reserved1[4];
  INTC_IACKR_tag IACKR[3];             /* INTC Interrupt Acknowledge Register for Processor 0 */
  uint8_t INTC_reserved2[4];
  INTC_EOIR_tag EOIR[3];               /* INTC End Of Interrupt Register for Processor 0 */
  uint8_t INTC_reserved3[4];
  INTC_SSCIR_tag SSCIR[24];            /* INTC Software Set/Clear Interrupt Register */
  uint8_t INTC_reserved4[8];
  INTC_PSR_tag PSR[1024];              /* INTC Priority Select Register */
};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

typedef union JDC_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t JIN_IEN:1;
    vuint32_t _unused_1:15;
    vuint32_t JOUT_IEN:1;
  } B;
} JDC_MCR_tag;

typedef union JDC_MSR_union_tag {      /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t JIN_RDY:1;
    vuint32_t _unused_17:1;
    vuint32_t JIN_INT:1;
    vuint32_t _unused_3:13;
    vuint32_t JOUT_RDY:1;
    vuint32_t _unused_1:1;
    vuint32_t JOUT_INT:1;
  } B;
} JDC_MSR_tag;

typedef union JDC_JOUT_IPS_union_tag { /* JTAG Output Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JOUT_IPS_tag;

typedef union JDC_JIN_IPS_union_tag {  /* JTAG Input Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JIN_IPS_tag;

struct JDC_tag {
  JDC_MCR_tag MCR;                     /* Module Configuration Register */
  JDC_MSR_tag MSR;                     /* Module Status Register */
  JDC_JOUT_IPS_tag JOUT_IPS;           /* JTAG Output Data Register */
  JDC_JIN_IPS_tag JIN_IPS;             /* JTAG Input Data Register */
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

typedef union LINFlexD_LINCR1_union_tag { /* LIN Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CCD:1;
    vuint32_t CFD:1;
    vuint32_t LASE:1;
    vuint32_t AUTOWU:1;
    vuint32_t MBL:4;
    vuint32_t BF:1;
    vuint32_t _unused_6:1;
    vuint32_t LBKM:1;
    vuint32_t MME:1;
    vuint32_t SSBL:1;
    vuint32_t RBLM:1;
    vuint32_t SLEEP:1;
    vuint32_t INIT:1;
  } B;
} LINFlexD_LINCR1_tag;

typedef union LINFlexD_LINIER_union_tag { /* LIN Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZIE:1;
    vuint32_t OCIE:1;
    vuint32_t BEIE:1;
    vuint32_t CEIE:1;
    vuint32_t HEIE:1;
    vuint32_t _unused_9:2;
    vuint32_t FEIE:1;
    vuint32_t BOIE:1;
    vuint32_t LSIE:1;
    vuint32_t WUIE:1;
    vuint32_t _unused_4:1;
    vuint32_t TOIE:1;
    vuint32_t DRIE:1;
    vuint32_t DTIE:1;
    vuint32_t HRIE:1;
  } B;
} LINFlexD_LINIER_tag;

typedef union LINFlexD_LINSR_union_tag { /* LIN Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t AUTOSYNC_COMP:1;
    vuint32_t RDC:3;
    vuint32_t LINS:4;                  /* LIN state */
    vuint32_t _unused_10:2;
    vuint32_t RMB:1;
    vuint32_t DRBNE:1;
    vuint32_t RXbusy:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t _unused_3:2;
    vuint32_t DRF:1;
    vuint32_t DTF:1;
    vuint32_t HRF:1;
  } B;
} LINFlexD_LINSR_tag;

typedef union LINFlexD_LINESR_union_tag { /* LIN Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t BEF:1;
    vuint32_t CEF:1;
    vuint32_t SFEF:1;
    vuint32_t SDEF:1;
    vuint32_t IDPEF:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t _unused_1:6;
    vuint32_t NF:1;
  } B;
} LINFlexD_LINESR_tag;

typedef union LINFlexD_UARTCR_union_tag { /* UART Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIS:1;
    vuint32_t CSP:3;
    vuint32_t OSR:4;
    vuint32_t ROSE:1;
    vuint32_t NEF:3;
    vuint32_t DTU_PCETX:1;             /* Disable Timeout in UART mode */
    vuint32_t SBUR:2;
    vuint32_t WLS:1;
    vuint32_t TDFL_TFC:3;
    vuint32_t RDFL_RFC:3;
    vuint32_t RFBM:1;
    vuint32_t TFBM:1;
    vuint32_t WL1:1;
    vuint32_t PC1:1;
    vuint32_t RxEn:1;
    vuint32_t TxEn:1;
    vuint32_t PC0:1;
    vuint32_t PCE:1;
    vuint32_t WL0:1;
    vuint32_t UART:1;
  } B;
} LINFlexD_UARTCR_tag;

typedef union LINFlexD_UARTSR_union_tag { /* UART Mode Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t PE:4;
    vuint32_t RMB:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t RFNE:1;
    vuint32_t TO:1;
    vuint32_t DRFRFE:1;
    vuint32_t DTFTFF:1;
    vuint32_t NF:1;
  } B;
} LINFlexD_UARTSR_tag;

typedef union LINFlexD_LINTCSR_union_tag { /* LIN Time-Out Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t MODE:1;
    vuint32_t IOT:1;
    vuint32_t TOCE:1;
    vuint32_t CNT:8;
  } B;
} LINFlexD_LINTCSR_tag;

typedef union LINFlexD_LINOCR_union_tag { /* LIN Output Compare Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t OC2:8;
    vuint32_t OC1:8;
  } B;
} LINFlexD_LINOCR_tag;

typedef union LINFlexD_LINTOCR_union_tag { /* LIN Time-Out Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t RTO:4;
    vuint32_t _unused_7:1;
    vuint32_t HTO:7;
  } B;
} LINFlexD_LINTOCR_tag;

typedef union LINFlexD_LINFBRR_union_tag { /* LIN Fractional Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t FBR:4;
  } B;
} LINFlexD_LINFBRR_tag;

typedef union LINFlexD_LINIBRR_union_tag { /* LIN Integer Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t IBR:20;
  } B;
} LINFlexD_LINIBRR_tag;

typedef union LINFlexD_LINCFR_union_tag { /* LIN Checksum Field Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t CF:8;
  } B;
} LINFlexD_LINCFR_tag;

typedef union LINFlexD_LINCR2_union_tag { /* LIN Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TBDE:1;
    vuint32_t IOBE:1;
    vuint32_t IOPE:1;
    vuint32_t WURQ:1;
    vuint32_t DDRQ:1;
    vuint32_t DTRQ:1;
    vuint32_t ABRQ:1;
    vuint32_t HTRQ:1;
    vuint32_t _unused_0:8;
  } B;
} LINFlexD_LINCR2_tag;

typedef union LINFlexD_BIDR_union_tag { /* Buffer Identifier Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_13:3;
    vuint32_t DFL:3;
    vuint32_t DIR:1;
    vuint32_t CCS:1;
    vuint32_t _unused_6:2;
    vuint32_t ID:6;
  } B;
} LINFlexD_BIDR_tag;

typedef union LINFlexD_BDRL_union_tag { /* Buffer Data Register Least Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA3:8;
    vuint32_t DATA2:8;
    vuint32_t DATA1:8;
    vuint32_t DATA0:8;
  } B;
} LINFlexD_BDRL_tag;

typedef union LINFlexD_BDRM_union_tag { /* Buffer Data Register Most Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA7:8;
    vuint32_t DATA6:8;
    vuint32_t DATA5:8;
    vuint32_t DATA4:8;
  } B;
} LINFlexD_BDRM_tag;

typedef union LINFlexD_IFER_union_tag { /* Identifier Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t FACT:16;
  } B;
} LINFlexD_IFER_tag;

typedef union LINFlexD_IFMI_union_tag { /* Identifier Filter Match Index */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t IFMI:5;
  } B;
} LINFlexD_IFMI_tag;

typedef union LINFlexD_IFMR_union_tag { /* Identifier Filter Mode Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t IFM:8;
  } B;
} LINFlexD_IFMR_tag;

typedef union LINFlexD_IFCR_union_tag { /* Identifier Filter Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_13:3;
    vuint32_t DFL:3;                   /* Data Field Length */
    vuint32_t DIR:1;                   /* Direction */
    vuint32_t CCS:1;                   /* Classic Checksum */
    vuint32_t _unused_6:2;
    vuint32_t ID:6;                    /* Identifier */
  } B;
} LINFlexD_IFCR_tag;

typedef union LINFlexD_GCR_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t TDFBM:1;
    vuint32_t RDFBM:1;
    vuint32_t TDLIS:1;
    vuint32_t RDLIS:1;
    vuint32_t STOP:1;
    vuint32_t SR:1;
  } B;
} LINFlexD_GCR_tag;

typedef union LINFlexD_UARTPTO_union_tag { /* UART Preset Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t PTO:12;
  } B;
} LINFlexD_UARTPTO_tag;

typedef union LINFlexD_UARTCTO_union_tag { /* UART Current Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t CTO:12;
  } B;
} LINFlexD_UARTCTO_tag;

typedef union LINFlexD_DMATXE_union_tag { /* DMA Tx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DTE:16;
  } B;
} LINFlexD_DMATXE_tag;

typedef union LINFlexD_DMARXE_union_tag { /* DMA Rx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DRE:16;
  } B;
} LINFlexD_DMARXE_tag;

struct LINFlexD_tag {
  LINFlexD_LINCR1_tag LINCR1;          /* LIN Control Register 1 */
  LINFlexD_LINIER_tag LINIER;          /* LIN Interrupt enable register */
  LINFlexD_LINSR_tag LINSR;            /* LIN Status Register */
  LINFlexD_LINESR_tag LINESR;          /* LIN Error Status Register */
  LINFlexD_UARTCR_tag UARTCR;          /* UART Mode Control Register */
  LINFlexD_UARTSR_tag UARTSR;          /* UART Mode Status Register */
  LINFlexD_LINTCSR_tag LINTCSR;        /* LIN Time-Out Control Status Register */
  LINFlexD_LINOCR_tag LINOCR;          /* LIN Output Compare Register */
  LINFlexD_LINTOCR_tag LINTOCR;        /* LIN Time-Out Control Register */
  LINFlexD_LINFBRR_tag LINFBRR;        /* LIN Fractional Baud Rate Register */
  LINFlexD_LINIBRR_tag LINIBRR;        /* LIN Integer Baud Rate Register */
  LINFlexD_LINCFR_tag LINCFR;          /* LIN Checksum Field Register */
  LINFlexD_LINCR2_tag LINCR2;          /* LIN Control Register 2 */
  LINFlexD_BIDR_tag BIDR;              /* Buffer Identifier Register */
  LINFlexD_BDRL_tag BDRL;              /* Buffer Data Register Least Significant */
  LINFlexD_BDRM_tag BDRM;              /* Buffer Data Register Most Significant */
  LINFlexD_IFER_tag IFER;              /* Identifier Filter Enable Register */
  LINFlexD_IFMI_tag IFMI;              /* Identifier Filter Match Index */
  LINFlexD_IFMR_tag IFMR;              /* Identifier Filter Mode Register */
  LINFlexD_IFCR_tag IFCR[16];          /* Identifier Filter Control Register */
  LINFlexD_GCR_tag GCR;                /* Global Control Register */
  LINFlexD_UARTPTO_tag UARTPTO;        /* UART Preset Timeout Register */
  LINFlexD_UARTCTO_tag UARTCTO;        /* UART Current Timeout Register */
  LINFlexD_DMATXE_tag DMATXE;          /* DMA Tx Enable Register */
  LINFlexD_DMARXE_tag DMARXE;          /* DMA Rx Enable Register */
};


/* ============================================================================
   =============================== Module: LPU ================================
   ============================================================================ */

typedef union LPU_MCTL_union_tag {     /* LPU Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t TARGET_MODE:4;           /* Target Chip Mode */
    vuint32_t _unused_16:12;
    vuint32_t KEY:16;                  /* This field provides the key to change the target mode. Any write access to the register with a value different from the keys is always ignored. Read access will always return the inverted key */
  } B;
} LPU_MCTL_tag;

typedef union LPU_RUN_CF_union_tag {   /* LPU Run Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t CAN0_CONT:1;             /* CAN0 continuous operation across LPU modes. CAN CHI frequency will switch from FS80 to LPU_SYS_CLK which will require reconfiguration thus inhibiting continuous operation across LPU modes. */
    vuint32_t _unused_9:7;
    vuint32_t DIRECT_DRUN:1;           /* Transition to DRUN on LPU_STANDBY exit */
    vuint32_t SYS_CLK_SEL:1;           /* System clock selection in LPU RUN mode */
    vuint32_t LPU_SLEEP:1;             /* Core sleep request during LPU RUN */
    vuint32_t _unused_5:1;
    vuint32_t SXOSC_ON:1;              /* SXOSC control during LPU_RUN */
    vuint32_t SIRC_ON:1;               /* SIRC control during LPU_RUN */
    vuint32_t _unused_2:1;
    vuint32_t FXOSC_ON:1;              /* FXOSC control during LPU_RUN */
    vuint32_t FIRC_ON:1;               /* FIRC oscillator control during LPU_RUN */
  } B;
} LPU_RUN_CF_tag;

typedef union LPU_STOP_CF_union_tag {  /* LPU Stop Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t SXOSC_ON:1;              /* SXOSC control during LPU_STOP */
    vuint32_t SIRC_ON:1;               /* SIRC control during LPU_STOP */
    vuint32_t _unused_2:1;
    vuint32_t FXOSC_ON:1;              /* FXOSC control during LPU_STOP */
    vuint32_t FIRC_ON:1;               /* FIRC oscillator control during LPU_STOP */
  } B;
} LPU_STOP_CF_tag;

typedef union LPU_STANDBY_CF_union_tag { /* LPU Standby Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t SXOSC_ON:1;              /* SXOSC control during LPU_STANDBY */
    vuint32_t SIRC_ON:1;               /* SIRC control during LPU_STANDBY */
    vuint32_t _unused_2:1;
    vuint32_t FXOSC_ON:1;              /* FXOSC clock source control during LPU_STANDBY */
    vuint32_t FIRC_ON:1;               /* FIRC oscillator control during LPU_STANDBY */
  } B;
} LPU_STANDBY_CF_tag;

typedef union LPU_SR_union_tag {       /* LPU Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t PD2_PWR_STAT:1;          /* Ensures the main domain (power domain 2) is power gated completely. */
    vuint32_t SXOSC_STAT:1;            /* SXOSC clock source status */
    vuint32_t SIRC_STAT:1;             /* SIRC clock status */
    vuint32_t _unused_18:1;
    vuint32_t FXOSC_STAT:1;            /* FXOSC clock source status */
    vuint32_t FIRC_STAT:1;             /* FIRC clock status */
    vuint32_t CLK1_STOP:1;             /* FXOSC clock status during LPU mode */
    vuint32_t CLK0_STOP:1;             /* FIRC status during LPU mode */
    vuint32_t _unused_6:8;
    vuint32_t MTRANS:1;                /* LPU mode transition */
    vuint32_t _unused_4:1;
    vuint32_t CURRENT_MODE:4;          /* Current mode of the chip */
  } B;
} LPU_SR_tag;

typedef union LPU_ICR_union_tag {      /* LPU Interrupt control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t LPU_MRIG_E:1;            /* LPU mode request ignored interrupt enable */
    vuint32_t LPU_NEM_E:1;             /* LPU non-exist mode interrupt enable */
    vuint32_t _unused_17:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_4:12;
    vuint32_t LPU_MRIG:1;              /* LPU mode request ignored */
    vuint32_t LPU_NEM:1;               /* LPU non-exist mode interrupt */
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} LPU_ICR_tag;

typedef union LPU_MDIS_union_tag {     /* Module Disable */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t eMIOS_2:1;
    vuint32_t CMP_2:1;
    vuint32_t CMP_1:1;
    vuint32_t CMP_0:1;
    vuint32_t MEMU_1:1;
    vuint32_t BCTU:1;
    vuint32_t CAN0:1;
    vuint32_t LIN_0:1;
    vuint32_t SPI_0:1;
    vuint32_t ADC_0:1;
  } B;
} LPU_MDIS_tag;

struct LPU_tag {
  LPU_MCTL_tag MCTL;                   /* LPU Mode Control Register */
  LPU_RUN_CF_tag RUN_CF;               /* LPU Run Configuration Register */
  LPU_STOP_CF_tag STOP_CF;             /* LPU Stop Configuration Register */
  LPU_STANDBY_CF_tag STANDBY_CF;       /* LPU Standby Configuration Register */
  LPU_SR_tag SR;                       /* LPU Status Register */
  LPU_ICR_tag ICR;                     /* LPU Interrupt control register */
  LPU_MDIS_tag MDIS;                   /* Module Disable */
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

typedef union MC_CGM_CLKOUT1_SC_union_tag { /* Clockout 1 Select Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELCTL:4;                /* CLKOUT1 Source Select */
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_CLKOUT1_SC_tag;

typedef union MC_CGM_CLKOUT1_DC_union_tag { /* CLKOUT1_DC Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;                    /* CLKOUT1_DC enable */
    vuint32_t _unused_27:4;
    vuint32_t DIV:11;                  /* Divider */
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_CLKOUT1_DC_tag;

typedef union MC_CGM_AC5_SC_union_tag { /* Auxiliary Clock 5 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC5_SC_tag;

typedef union MC_CGM_AC5_SS_union_tag { /* Auxiliary Clock 5 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC5_SS_tag;

typedef union MC_CGM_SC_DC6_union_tag { /* System Clock Divider 6 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_19:12;
    vuint32_t DIV:3;                   /* Divider */
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC6_tag;

typedef union MC_CGM_AC8_SC_union_tag { /* Auxiliary Clock 8 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC8_SC_tag;

typedef union MC_CGM_AC8_SS_union_tag { /* Auxiliary Clock 8 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC8_SS_tag;

typedef union MC_CGM_AC9_SC_union_tag { /* Auxiliary Clock 9 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC9_SC_tag;

typedef union MC_CGM_AC9_SS_union_tag { /* Auxiliary Clock 9 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC9_SS_tag;

typedef union MC_CGM_PCS_SDUR_union_tag { /* PCS Switch Duration Register */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} MC_CGM_PCS_SDUR_tag;

typedef union MC_CGM_PCS_DIVC1_union_tag { /* PCS Divider Change Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC1_tag;

typedef union MC_CGM_PCS_DIVE1_union_tag { /* PCS Divider End Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE1_tag;

typedef union MC_CGM_PCS_DIVS1_union_tag { /* PCS Divider Start Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS1_tag;

typedef union MC_CGM_PCS_DIVC2_union_tag { /* PCS Divider Change Register 2 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC2_tag;

typedef union MC_CGM_PCS_DIVE2_union_tag { /* PCS Divider End Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE2_tag;

typedef union MC_CGM_PCS_DIVS2_union_tag { /* PCS Divider Start Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS2_tag;

typedef union MC_CGM_DIV_UPD_ABRTD_union_tag { /* Divider Update Abort Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t DIV_UPD_ABRTD:1;
  } B;
} MC_CGM_DIV_UPD_ABRTD_tag;

typedef union MC_CGM_SC_DIV_RC_union_tag { /* System Clock Divider Ratio Change Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t HALT_ABORT_DIS:1;
    vuint32_t SYS_DIV_RATIO_CHNG:1;
  } B;
} MC_CGM_SC_DIV_RC_tag;

typedef union MC_CGM_DIV_UPD_TYPE_union_tag { /* Divider Update Type Register */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_TYPE:1;          /* System Clock Divider Update Type */
    vuint32_t _unused_7:24;
    vuint32_t _unused_6:1;
    vuint32_t _unused_0:6;
  } B;
} MC_CGM_DIV_UPD_TYPE_tag;

typedef union MC_CGM_DIV_UPD_TRIG_union_tag { /* Divider Update Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t DIV_UPD_TRIGGER:32;
  } B;
} MC_CGM_DIV_UPD_TRIG_tag;

typedef union MC_CGM_DIV_UPD_STAT_union_tag { /* Divider Update Status Register */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_STAT:1;          /* System Clock Divider Update Status */
    vuint32_t _unused_7:24;
    vuint32_t _unused_6:1;
    vuint32_t _unused_0:6;
  } B;
} MC_CGM_DIV_UPD_STAT_tag;

typedef union MC_CGM_SC_SS_union_tag { /* System Clock Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_20:4;
    vuint32_t SWTRG:3;
    vuint32_t SWIP:1;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_SS_tag;

typedef union MC_CGM_SC_DC0_union_tag { /* System Clock Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_19:12;
    vuint32_t DIV:3;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC0_tag;

typedef union MC_CGM_SC_DC1_union_tag { /* System Clock Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_19:12;
    vuint32_t DIV:3;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC1_tag;

typedef union MC_CGM_SC_DC2_union_tag { /* System Clock Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC2_tag;

typedef union MC_CGM_SC_DC3_union_tag { /* System Clock Divider 3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_18:13;
    vuint32_t DIV:2;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC3_tag;

typedef union MC_CGM_SC_DC4_union_tag { /* System Clock Divider 4 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_18:13;
    vuint32_t DIV:2;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC4_tag;

typedef union MC_CGM_SC_DC5_union_tag { /* System Clock Divider 5 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_19:12;
    vuint32_t DIV:3;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC5_tag;

typedef union MC_CGM_AC2_SC_union_tag { /* Auxiliary Clock 2 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC2_SC_tag;

typedef union MC_CGM_AC2_SS_union_tag { /* Auxiliary Clock 2 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC2_SS_tag;

typedef union MC_CGM_AC3_SS_union_tag { /* Auxiliary Clock 3 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC3_SS_tag;

typedef union MC_CGM_AC4_SC_union_tag { /* Auxiliary Clock 4 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC4_SC_tag;

typedef union MC_CGM_AC4_SS_union_tag { /* Auxiliary Clock 4 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC4_SS_tag;

typedef union MC_CGM_AC6_SC_union_tag { /* Auxiliary Clock 6 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELCTL:4;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC6_SC_tag;

typedef union MC_CGM_AC6_SS_union_tag { /* Auxiliary Clock 6 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC6_SS_tag;

typedef union MC_CGM_AC6_DC0_union_tag { /* Aux Clock 6 Divider Configuration 0 for CLKOUT_0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_21:10;
    vuint32_t DIV:5;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_AC6_DC0_tag;

struct MC_CGM_tag {
  uint8_t MC_CGM_reserved0[384];
  MC_CGM_CLKOUT1_SC_tag CLKOUT1_SC;    /* Clockout 1 Select Register */
  uint8_t MC_CGM_reserved1[4];
  MC_CGM_CLKOUT1_DC_tag CLKOUT1_DC;    /* CLKOUT1_DC Configuration Register */
  uint8_t MC_CGM_reserved2[52];
  MC_CGM_AC5_SC_tag AC5_SC;            /* Auxiliary Clock 5 Select Control Register */
  MC_CGM_AC5_SS_tag AC5_SS;            /* Auxiliary Clock 5 Select Status Register */
  uint8_t MC_CGM_reserved3[56];
  MC_CGM_SC_DC6_tag SC_DC6;            /* System Clock Divider 6 Configuration Register */
  uint8_t MC_CGM_reserved4[124];
  MC_CGM_AC8_SC_tag AC8_SC;            /* Auxiliary Clock 8 Select Control Register */
  MC_CGM_AC8_SS_tag AC8_SS;            /* Auxiliary Clock 8 Select Status Register */
  uint8_t MC_CGM_reserved5[56];
  MC_CGM_AC9_SC_tag AC9_SC;            /* Auxiliary Clock 9 Select Control Register */
  MC_CGM_AC9_SS_tag AC9_SS;            /* Auxiliary Clock 9 Select Status Register */
  uint8_t MC_CGM_reserved6[1080];
  MC_CGM_PCS_SDUR_tag PCS_SDUR;        /* PCS Switch Duration Register */
  uint8_t MC_CGM_reserved7[3];
  MC_CGM_PCS_DIVC1_tag PCS_DIVC1;      /* PCS Divider Change Register 1 */
  MC_CGM_PCS_DIVE1_tag PCS_DIVE1;      /* PCS Divider End Register 1 */
  MC_CGM_PCS_DIVS1_tag PCS_DIVS1;      /* PCS Divider Start Register 1 */
  MC_CGM_PCS_DIVC2_tag PCS_DIVC2;      /* PCS Divider Change Register 2 */
  MC_CGM_PCS_DIVE2_tag PCS_DIVE2;      /* PCS Divider End Register 2 */
  MC_CGM_PCS_DIVS2_tag PCS_DIVS2;      /* PCS Divider Start Register 2 */
  uint8_t MC_CGM_reserved8[176];
  MC_CGM_DIV_UPD_ABRTD_tag DIV_UPD_ABRTD; /* Divider Update Abort Register */
  MC_CGM_SC_DIV_RC_tag SC_DIV_RC;      /* System Clock Divider Ratio Change Register */
  MC_CGM_DIV_UPD_TYPE_tag DIV_UPD_TYPE; /* Divider Update Type Register */
  MC_CGM_DIV_UPD_TRIG_tag DIV_UPD_TRIG; /* Divider Update Trigger Register */
  MC_CGM_DIV_UPD_STAT_tag DIV_UPD_STAT; /* Divider Update Status Register */
  uint8_t MC_CGM_reserved9[4];
  MC_CGM_SC_SS_tag SC_SS;              /* System Clock Select Status Register */
  MC_CGM_SC_DC0_tag SC_DC0;            /* System Clock Divider 0 Configuration Register */
  MC_CGM_SC_DC1_tag SC_DC1;            /* System Clock Divider 1 Configuration Register */
  MC_CGM_SC_DC2_tag SC_DC2;            /* System Clock Divider 2 Configuration Register */
  MC_CGM_SC_DC3_tag SC_DC3;            /* System Clock Divider 3 Configuration Register */
  MC_CGM_SC_DC4_tag SC_DC4;            /* System Clock Divider 4 Configuration Register */
  MC_CGM_SC_DC5_tag SC_DC5;            /* System Clock Divider 5 Configuration Register */
  uint8_t MC_CGM_reserved10[64];
  MC_CGM_AC2_SC_tag AC2_SC;            /* Auxiliary Clock 2 Select Control Register */
  MC_CGM_AC2_SS_tag AC2_SS;            /* Auxiliary Clock 2 Select Status Register */
  uint8_t MC_CGM_reserved11[28];
  MC_CGM_AC3_SS_tag AC3_SS;            /* Auxiliary Clock 3 Select Status Register */
  uint8_t MC_CGM_reserved12[24];
  MC_CGM_AC4_SC_tag AC4_SC;            /* Auxiliary Clock 4 Select Control Register */
  MC_CGM_AC4_SS_tag AC4_SS;            /* Auxiliary Clock 4 Select Status Register */
  uint8_t MC_CGM_reserved13[56];
  MC_CGM_AC6_SC_tag AC6_SC;            /* Auxiliary Clock 6 Select Control Register */
  MC_CGM_AC6_SS_tag AC6_SS;            /* Auxiliary Clock 6 Select Status Register */
  MC_CGM_AC6_DC0_tag AC6_DC0;          /* Aux Clock 6 Divider Configuration 0 for CLKOUT_0 */
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

typedef union MC_ME_GS_union_tag {     /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t S_CURRENT_MODE:4;
    vuint32_t S_MTRANS:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_24:2;
    vuint32_t S_PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t S_MVR:1;
    vuint32_t _unused_18:2;
    vuint32_t S_FLA:2;
    vuint32_t _unused_9:7;
    vuint32_t S_SXOSC:1;               /* 32 KHz external oscillator status */
    vuint32_t S_SIRCON:1;              /* 128 KHz internal RC oscillator status */
    vuint32_t S_PLLON:1;               /* PLL status */
    vuint32_t S_FXOSC:1;               /* 8-40 MHz crystal oscillator status */
    vuint32_t S_FIRCON:1;
    vuint32_t S_SYSCLK:4;
  } B;
} MC_ME_GS_tag;

typedef union MC_ME_MCTL_union_tag {   /* Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t TARGET_MODE:4;           /* Target chip mode */
    vuint32_t _unused_16:12;
    vuint32_t KEY:16;
  } B;
} MC_ME_MCTL_tag;

typedef union MC_ME_ME_union_tag {     /* Mode Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t RESET_DEST:1;
    vuint32_t _unused_14:1;
    vuint32_t STANDBY0:1;              /* STANDBY0 mode enable */
    vuint32_t _unused_11:2;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t _unused_1:1;
    vuint32_t RESET_FUNC:1;
  } B;
} MC_ME_ME_tag;

typedef union MC_ME_IS_union_tag {     /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t I_ICONF_CC:1;
    vuint32_t _unused_4:1;             /* This field is reserved and can be set to 1 by hardware during some mode transitions. The setting of this bit has no impact on the device. */
    vuint32_t I_ICONF:1;
    vuint32_t I_IMODE:1;
    vuint32_t I_SAFE:1;
    vuint32_t I_MTC:1;
  } B;
} MC_ME_IS_tag;

typedef union MC_ME_IM_union_tag {     /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t M_ICONF_CC:1;
    vuint32_t _unused_4:1;
    vuint32_t M_ICONF:1;
    vuint32_t M_IMODE:1;
    vuint32_t M_SAFE:1;
    vuint32_t M_MTC:1;
  } B;
} MC_ME_IM_tag;

typedef union MC_ME_IMTS_union_tag {   /* Invalid Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t S_MRIG:1;
    vuint32_t S_MTI:1;
    vuint32_t S_MRI:1;
    vuint32_t S_DMA:1;
    vuint32_t S_NMA:1;
    vuint32_t S_SEA:1;
  } B;
} MC_ME_IMTS_tag;

typedef union MC_ME_DMTS_union_tag {   /* Debug Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t PREVIOUS_MODE:4;
    vuint32_t _unused_24:4;
    vuint32_t MPH_BUSY:1;
    vuint32_t _unused_21:2;
    vuint32_t PMC_PROG:1;
    vuint32_t DBG_MODE:1;
    vuint32_t CCKL_PROG:1;
    vuint32_t PCS_PROG:1;
    vuint32_t SMR:1;
    vuint32_t CDP_PRPH_0_255:1;        /* Clock Disable Process Pending status for Peripherals 0...255 */
    vuint32_t VREG_CSRC_SC:1;
    vuint32_t CSRC_CSRC_SC:1;
    vuint32_t IRC_SC:1;
    vuint32_t SCSRC_SC:1;
    vuint32_t SYSCLK_SW:1;
    vuint32_t _unused_9:1;
    vuint32_t FLASH_SC:1;
    vuint32_t _unused_4:4;
    vuint32_t CDP_PRPH_96_127:1;
    vuint32_t CDP_PRPH_64_95:1;
    vuint32_t CDP_PRPH_32_63:1;
    vuint32_t CDP_PRPH_0_31:1;
  } B;
} MC_ME_DMTS_tag;

typedef union MC_ME_RESET_MC_union_tag { /* RESET Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32Khz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RESET_MC_tag;

typedef union MC_ME_SAFE_MC_union_tag { /* SAFE Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32Khz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_SAFE_MC_tag;

typedef union MC_ME_DRUN_MC_union_tag { /* DRUN Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32Khz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_DRUN_MC_tag;

typedef union MC_ME_RUN_MC_union_tag { /* RUN0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32 KHz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RUN_MC_tag;

typedef union MC_ME_STOP_MC_union_tag { /* STOP0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32 KHz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_STOP_MC_tag;

typedef union MC_ME_STANDBY_MC_union_tag { /* STANDBY0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32 KHz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_STANDBY_MC_tag;

typedef union MC_ME_PS0_union_tag {    /* Peripheral Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t S_IIC_1:1;
    vuint32_t S_IIC_0:1;
    vuint32_t _unused_29:1;
    vuint32_t S_FlexRay:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
    vuint32_t _unused_26:2;
    vuint32_t S_ADC_1:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active. */
    vuint32_t S_ADC_0:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_23:1;
    vuint32_t S_ACMP_2:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t S_ACMP_1:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t S_ACMP_0:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_16:4;
    vuint32_t S_ENET:1;                /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_13:2;
    vuint32_t S_SAI_2:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t S_SAI_1:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active. */
    vuint32_t S_SAI_0:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_8:2;
    vuint32_t S_SDHC:1;                /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t S_MLB:1;                 /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t S_USB_SPH:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t S_USBOTG:1;
    vuint32_t S_eMIOS_2:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
    vuint32_t S_eMIOS_1:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
    vuint32_t S_eMIOS_0:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
    vuint32_t S_BCTU:1;                /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
  } B;
} MC_ME_PS0_tag;

typedef union MC_ME_PS1_union_tag {    /* Peripheral Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t S_LIN:14;                /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_12:6;
    vuint32_t S_DSPI:4;                /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_2:6;
    vuint32_t S_IIC:2;                 /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
  } B;
} MC_ME_PS1_tag;

typedef union MC_ME_PS2_union_tag {    /* Peripheral Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_30:1;
    vuint32_t S_WKPU:1;
    vuint32_t S_LPU_CTL:1;
    vuint32_t S_PIT_RTI_0:1;
    vuint32_t S_DMAMUX:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
    vuint32_t _unused_21:5;
    vuint32_t S_CRC:1;
    vuint32_t S_MEMU_0:1;
    vuint32_t S_JDC:1;
    vuint32_t S_TDM:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_14:2;
    vuint32_t S_FLEXCAN:8;
    vuint32_t _unused_4:2;
    vuint32_t S_LIN:4;
  } B;
} MC_ME_PS2_tag;

typedef union MC_ME_PS3_union_tag {    /* Peripheral Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t S_MEMU_1:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_7:1;
    vuint32_t S_RTC_API:1;
    vuint32_t S_SPI:6;
  } B;
} MC_ME_PS3_tag;

typedef union MC_ME_RUN_PC_union_tag { /* Run Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t _unused_1:1;
    vuint32_t RESET:1;
  } B;
} MC_ME_RUN_PC_tag;

typedef union MC_ME_LP_PC_union_tag {  /* Low-Power Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t STANDBY0:1;              /* Peripheral control during STANDBY0 */
    vuint32_t _unused_11:2;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_0:8;
  } B;
} MC_ME_LP_PC_tag;

    /* Note on PCTL registers: There are only some PCTL implemented         */
    /*  In order to make the PCTL easily addressable, these are defined     */
    /*  as an array (ie ME.PCTL[x].R). This means you have to be careful    */
    /*  when addressing these registers in order not to access a PCTL that  */
    /*  is not implemented. Following are available: 0-7, 10-12, 15, 20-25, */
    /*  28, 30-33, 40-43, 50-67, 70-77, 80-84, 90-91, 93-94, 96-102, 104    */

typedef union MC_ME_PCTL_union_tag {   /* BCTU Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL_tag;

typedef union MC_ME_CS_union_tag {     /* Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t S_CORE3:1;               /* Core3 Status */
    vuint32_t S_CORE2:1;               /* Core2 Status */
    vuint32_t S_CORE1:1;
    vuint32_t _unused_0:1;
  } B;
} MC_ME_CS_tag;

typedef union MC_ME_CCTL_union_tag {
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t STANDBY0:2;
    vuint16_t _unused_11:2;
    vuint16_t STOP0:1;
    vuint16_t _unused_9:1;
    vuint16_t _unused_8:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t _unused_1:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL_tag;

typedef union MC_ME_CADDR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t _unused_1:1;
    vuint32_t RMC:1;                   /* Reset on Mode Change */
  } B;
} MC_ME_CADDR_tag;

struct MC_ME_tag {
  MC_ME_GS_tag GS;                     /* Global Status Register */
  MC_ME_MCTL_tag MCTL;                 /* Mode Control Register */
  MC_ME_ME_tag ME;                     /* Mode Enable Register */
  MC_ME_IS_tag IS;                     /* Interrupt Status Register */
  MC_ME_IM_tag IM;                     /* Interrupt Mask Register */
  MC_ME_IMTS_tag IMTS;                 /* Invalid Mode Transition Status Register */
  MC_ME_DMTS_tag DMTS;                 /* Debug Mode Transition Status Register */
  uint8_t MC_ME_reserved0[4];
  MC_ME_RESET_MC_tag RESET_MC;         /* RESET Mode Configuration Register */
  uint8_t MC_ME_reserved1[4];
  MC_ME_SAFE_MC_tag SAFE_MC;           /* SAFE Mode Configuration Register */
  MC_ME_DRUN_MC_tag DRUN_MC;           /* DRUN Mode Configuration Register */
  MC_ME_RUN_MC_tag RUN_MC[4];          /* RUN0 Mode Configuration Register */
  uint8_t MC_ME_reserved2[8];
  MC_ME_STOP_MC_tag STOP_MC;           /* STOP0 Mode Configuration Register */
  uint8_t MC_ME_reserved3[8];
  MC_ME_STANDBY_MC_tag STANDBY_MC;     /* STANDBY0 Mode Configuration Register */
  uint8_t MC_ME_reserved4[8];
  MC_ME_PS0_tag PS0;                   /* Peripheral Status Register 0 */
  MC_ME_PS1_tag PS1;                   /* Peripheral Status Register 1 */
  MC_ME_PS2_tag PS2;                   /* Peripheral Status Register 2 */
  MC_ME_PS3_tag PS3;                   /* Peripheral Status Register 3 */
  uint8_t MC_ME_reserved5[16];
  MC_ME_RUN_PC_tag RUN_PC[8];          /* Run Peripheral Configuration Register */
  MC_ME_LP_PC_tag LP_PC[8];            /* Low-Power Peripheral Configuration Register */
  MC_ME_PCTL_tag PCTL[104];            /* BCTU Peripheral Control Register */
  uint8_t MC_ME_reserved6[152];
  MC_ME_CS_tag CS;                     /* Core Status Register */
  MC_ME_CCTL_tag CCTL[4];
  uint8_t MC_ME_reserved7[20];
  MC_ME_CADDR_tag CADDR[4];
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

typedef union MC_PCU_PCONF0_union_tag { /* Power Domain #0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t STBY0:1;                 /* Power domain control during STANDBY0 mode */
    vuint32_t _unused_11:2;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t HALT0:1;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RST:1;
  } B;
} MC_PCU_PCONF0_tag;

typedef union MC_PCU_PCONF1_union_tag { /* Power Domain #1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t STBY0:1;                 /* Power domain control during STANDBY0 mode */
    vuint32_t _unused_11:2;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t HALT0:1;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RST:1;
  } B;
} MC_PCU_PCONF1_tag;

typedef union MC_PCU_PSTAT_union_tag { /* Power Domain Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t PD1:1;                   /* Power status for power domain 1 */
    vuint32_t PD0:1;
  } B;
} MC_PCU_PSTAT_tag;

struct MC_PCU_tag {
  MC_PCU_PCONF0_tag PCONF0;            /* Power Domain #0 Configuration Register */
  MC_PCU_PCONF1_tag PCONF1;            /* Power Domain #1 Configuration Register */
  uint8_t MC_PCU_reserved0[56];
  MC_PCU_PSTAT_tag PSTAT;              /* Power Domain Status Register */
};


/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

typedef union MC_RGM_DES_union_tag {   /* 'Destructive' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t F_SWT2_RES:1;            /* Flag for SWT2 Reset */
    vuint32_t F_SWT1_RES:1;            /* Flag for SWT1 Reset */
    vuint32_t F_SWT0_RES:1;            /* Flag for SWT0 (Flash Initialization Failure) Reset */
    vuint32_t F_SUF:1;                 /* Flag for SUF (STCU unrecoverable fault) */
    vuint32_t F_FUNC_ESC:1;            /* Flag for Functional Reset Escalation */
    vuint32_t F_SSCM_SEC:1;            /* Flag for SSCM Secure Reset Request */
    vuint32_t F_SOFT_DEST:1;           /* Flag for Software Generated Destructive Reset */
    vuint32_t F_HSM_DEST:1;            /* Flag for HSM Destructive Reset */
    vuint32_t _unused_1:1;
    vuint32_t F_POR:1;                 /* Flag for Power-On Reset */
  } B;
} MC_RGM_DES_tag;

typedef union MC_RGM_DBRE_union_tag {  /* 'Destructive' Bidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t BE_SWT2_RES:1;           /* Bidirectional Reset Enable for SWT2 Reset */
    vuint32_t BE_SWT1_RES:1;           /* Bidirectional Reset Enable for SWT1 Reset */
    vuint32_t BE_SWT0_RES:1;           /* Bidirectional Reset Enable for SWT0 (Flash Initialization Failure) Reset */
    vuint32_t BE_SUF:1;                /* Bidirectional Reset Enable for SUF (STCU unrecoverable fault) */
    vuint32_t BE_FUNC_ESC:1;           /* Bidirectional Reset Enable for Functional Reset Escalation */
    vuint32_t BE_SSCM_SEC:1;           /* Bidirectional Reset Enable for SSCM Secure Reset Request */
    vuint32_t BE_SOFT_DEST:1;          /* Bidirectional Reset Enable for Software Generated Destructive Reset */
    vuint32_t BE_HSM_DEST:1;           /* Bidirectional Reset Enable for HSM Generated Functional Reset */
    vuint32_t _unused_1:1;
    vuint32_t BE_POR:1;                /* Bidirectional Power-On Reset */
  } B;
} MC_RGM_DBRE_tag;

typedef union MC_RGM_FES_union_tag {   /* 'Functional' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t F_LVD_LV_PD2_cold:1;     /* Flag for PD2 LVD at cold point */
    vuint32_t _unused_16:1;
    vuint32_t _unused_15:1;
    vuint32_t F_HVD_LV_cold:1;         /* Flag for High Voltage Detect */
    vuint32_t F_LVD_IO_A_HI:1;         /* Flag for Low-Voltage Detect IOs */
    vuint32_t F_Z2_DBG:1;              /* Flag for Z2 Debug Reset */
    vuint32_t F_Z4B_DBG:1;             /* Flag for Z4B Debug Reset */
    vuint32_t F_Z4A_DBG:1;             /* Flag for Z4A Debug Reset */
    vuint32_t F_FCCU_SHORT:1;          /* Flag for FCCU Short Functional Reset */
    vuint32_t F_FCCU_LONG:1;           /* Flag for FCCU Long Functional Reset */
    vuint32_t F_CMU_OLR:1;             /* Flag for OSC Frequency less than RC */
    vuint32_t F_ST_DONE:1;             /* Flag for Selt Test Completed */
    vuint32_t F_JTAG_FUNC:1;           /* Flag for JTAG Functional Reset */
    vuint32_t F_NMI_WKPU:1;            /* Flag for Non Maskable Interrupt from Wakeup Unit */
    vuint32_t F_SOFT_FUNC:1;           /* Flag for Software Generated Functional Reset */
    vuint32_t F_HSM_FUNC:1;            /* Flag for HSM Generated Functional Reset */
    vuint32_t _unused_1:1;
    vuint32_t F_EXR:1;                 /* Flag for External Reset */
  } B;
} MC_RGM_FES_tag;

typedef union MC_RGM_FERD_union_tag {  /* 'Functional' Event Reset Disable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t D_LVD_LV_PD2_cold:1;     /* Disable PD2 LVD at cold point */
    vuint32_t _unused_16:1;
    vuint32_t _unused_15:1;
    vuint32_t D_HVD_LV_cold:1;         /* Disable High Voltage Detect */
    vuint32_t D_LVD_IO_A_HI:1;         /* Disable Low Voltage Detect IOs */
    vuint32_t D_Z2_DBG:1;              /* Disable Z2 Debug Rreset */
    vuint32_t D_Z4B_DBG:1;             /* Disable Z4B Debug Reset */
    vuint32_t D_Z4A_DBG:1;             /* Disable Z4A Debug Reset */
    vuint32_t D_FCCU_SHORT:1;          /* Disable FCCU Short Functional Reset */
    vuint32_t D_FCCU_LONG:1;           /* Disable FCCU Long Functional Reset */
    vuint32_t D_CMU_OLR:1;             /* Disable OSC Frequency less than RC In case OLR is configured as safe mode request, Exit from SAFE mode should be always done via any functional Reset to avoid any unpredictable behavior. */
    vuint32_t D_ST_DONE:1;             /* Disable Selt Test Completed */
    vuint32_t D_JTAG_FUNC:1;           /* Disable JTAG Functional Reset */
    vuint32_t D_NMI_WKPU:1;            /* Disable Non Maskable Interrupt from Wakeup Unit */
    vuint32_t D_SOFT_FUNC:1;           /* Disable Software Generated Functional Reset */
    vuint32_t D_HSM_FUNC:1;            /* Disable HSM Genrated Functional Reset */
    vuint32_t _unused_1:1;
    vuint32_t D_EXR:1;                 /* Disable External Reset */
  } B;
} MC_RGM_FERD_tag;

typedef union MC_RGM_FEAR_union_tag {  /* 'Functional' Event Reset DisableAlternate Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t AR_LVD_LV_PD2_cold:1;    /* Alternate Request for PD2 LVD at cold point */
    vuint32_t _unused_16:1;
    vuint32_t _unused_15:1;
    vuint32_t AR_HVD_LV_cold:1;        /* Alternate Request for High Voltage Detect */
    vuint32_t AR_LVD_IO_A_HI:1;        /* Alternate Request for Low Voltage Detect IOs */
    vuint32_t AR_Z2_DBG:1;             /* Alternate Request for Z2 Debug Reset */
    vuint32_t AR_Z4B_DBG:1;            /* Alternate Request for Z4B Debug Reset */
    vuint32_t AR_Z4A_DBG:1;            /* Alternate Request for Z4A Debug Reset */
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t AR_CMU_OLR:1;            /* Alternate Request for OSC Frequency less than RC */
    vuint32_t _unused_6:1;
    vuint32_t AR_JTAG_FUNC:1;          /* Alternate Request for JTAG functional Reset */
    vuint32_t AR_NMI_WKPU:1;           /* Alternate Request for Non Maskable Interrupt from Wakeup Unit */
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t AR_EXR:1;                /* Flag for External reset */
  } B;
} MC_RGM_FEAR_tag;

typedef union MC_RGM_FBRE_union_tag {  /* 'Functional' Bidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t BE_LVD_LV_PD2_cold:1;    /* Bidirectional Reset Enable for PD2 LVD at Cold Point */
    vuint32_t _unused_16:1;
    vuint32_t _unused_15:1;
    vuint32_t BE_HVD_LV_cold:1;        /* Bidirectional Reset Enable for High Voltage Detect */
    vuint32_t BE_LVD_IO_A_HI:1;        /* Bidirectional Reset Enable for Low Voltage Detect IOs */
    vuint32_t BE_Z2_DBG:1;             /* Bidirectional Reset Enable for Z2 debug reset */
    vuint32_t BE_Z4B_DBG:1;            /* Bidirectional Reset Enable for BE_Z4B_DBG */
    vuint32_t BE_Z4A_DBG:1;            /* Bidirectional Reset Enable for Z4A Debug Reset */
    vuint32_t BE_FCCU_SHORT:1;         /* Bidirectional Reset Enable for FCCU Short Functional Reset */
    vuint32_t BE_FCCU_LONG:1;          /* Bidirectional Reset Enable for FCCU Long Functional Reset */
    vuint32_t BE_CMU_OLR:1;            /* Bidirectional Reset Enable for OSC Frequency less than RC */
    vuint32_t BE_ST_DONE:1;            /* Bidirectional Reset Enable for Selt Test Completed */
    vuint32_t BE_JTAG_FUNC:1;          /* Bidirectional Reset Enable for JTAG Function */
    vuint32_t BE_NMI_WKPU:1;           /* Bidirectional Reset Enable for Non Maskable Interrupt from Wakeup Unit */
    vuint32_t BE_SOFT_FUNC:1;          /* Bidirectional Reset Enable for Software Generated Functional Reset */
    vuint32_t BE_HSM_FUNC:1;           /* Bidirectional Reset Enable for HSM Generated Functional Reset */
    vuint32_t _unused_1:1;
    vuint32_t BE_EXR:1;                /* Flag for External Reset */
  } B;
} MC_RGM_FBRE_tag;

typedef union MC_RGM_FESS_union_tag {  /* 'Functional' Event Short Sequence Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t SS_LVD_LV_PD2_cold:1;    /* Short Sequence for PD2 LVD at Cold Point */
    vuint32_t _unused_16:1;
    vuint32_t _unused_15:1;
    vuint32_t SS_HVD_LV_cold:1;        /* Short Sequence for High Voltage Detect IOs */
    vuint32_t SS_LVD_IO_A_HI:1;        /* Short Sequence for Low Voltage Detect IOs */
    vuint32_t SS_Z2_DBG:1;             /* Short Sequence for Z2 Debug Reset */
    vuint32_t SS_Z4B_DBG:1;            /* Short Sequence for Z4B Debug Reset */
    vuint32_t SS_Z4A_DBG:1;            /* Short Sequence for Z4A Debug Reset */
    vuint32_t SS_FCCU_SHORT:1;         /* Short Sequence for FCCU Short Functional Reset */
    vuint32_t SS_FCCU_LONG:1;          /* Short Sequence for FCCU Long Functional Reset */
    vuint32_t SS_CMU_OLR:1;            /* Short Sequence for OSC Frequency less than RC */
    vuint32_t SS_ST_DONE:1;            /* Short Sequence for Selt Test Completed */
    vuint32_t SS_FUNC_JTAG:1;          /* Short Sequence for JTAG Functional Reset */
    vuint32_t SS_NMI_WKPU:1;           /* Short Sequence for Non Maskable Interrupt 3 Wakeup Unit */
    vuint32_t SS_SOFT_FUNC:1;          /* Short Sequence for Software Generated Functional Reset */
    vuint32_t SS_HSM_FUNC:1;           /* Short Sequence for HSM Genrated Functional Reset */
    vuint32_t _unused_1:1;
    vuint32_t SS_EXR:1;                /* Short Sequence for External Reset */
  } B;
} MC_RGM_FESS_tag;

typedef union MC_RGM_FRET_union_tag {  /* 'Functional' Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t FRET:4;
  } B;
} MC_RGM_FRET_tag;

typedef union MC_RGM_DRET_union_tag {  /* 'Destructive' Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t DRET:4;
  } B;
} MC_RGM_DRET_tag;

struct MC_RGM_tag {
  MC_RGM_DES_tag DES;                  /* 'Destructive' Event Status Register */
  uint8_t MC_RGM_reserved0[44];
  MC_RGM_DBRE_tag DBRE;                /* 'Destructive' Bidirectional Reset Enable Register */
  uint8_t MC_RGM_reserved1[716];
  MC_RGM_FES_tag FES;                  /* 'Functional' Event Status Register */
  uint8_t MC_RGM_reserved2[12];
  MC_RGM_FERD_tag FERD;                /* 'Functional' Event Reset Disable Register */
  uint8_t MC_RGM_reserved3[12];
  MC_RGM_FEAR_tag FEAR;                /* 'Functional' Event Reset DisableAlternate Request Status Register */
  uint8_t MC_RGM_reserved4[12];
  MC_RGM_FBRE_tag FBRE;                /* 'Functional' Bidirectional Reset Enable Register */
  uint8_t MC_RGM_reserved5[12];
  MC_RGM_FESS_tag FESS;                /* 'Functional' Event Short Sequence Register */
  uint8_t MC_RGM_reserved6[704];
  MC_RGM_FRET_tag FRET;                /* 'Functional' Reset Escalation Threshold Register */
  uint8_t MC_RGM_reserved7[3];
  MC_RGM_DRET_tag DRET;                /* 'Destructive' Reset Escalation Threshold Register */
};


/* ============================================================================
   =============================== Module: MEMU_0 =============================
   ============================================================================ */

typedef union MEMU_0_CTRL_union_tag {  /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SWR:1;
    vuint32_t _unused_0:15;
  } B;
} MEMU_0_CTRL_tag;

typedef union MEMU_0_ERR_FLAG_union_tag { /* Error flag register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t PR_CE:1;
    vuint32_t PR_UCE:1;
    vuint32_t PR_CEO:1;
    vuint32_t PR_UCO:1;
    vuint32_t PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t F_CE:1;
    vuint32_t F_UCE:1;
    vuint32_t F_CEO:1;
    vuint32_t F_UCO:1;
    vuint32_t F_EBO:1;
    vuint32_t _unused_5:3;
    vuint32_t SR_CE:1;
    vuint32_t SR_UCE:1;
    vuint32_t SR_CEO:1;
    vuint32_t SR_UCO:1;
    vuint32_t SR_EBO:1;
  } B;
} MEMU_0_ERR_FLAG_tag;

typedef union MEMU_0_DEBUG_union_tag { /* Debug register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t FR_PR_CE:1;
    vuint32_t FR_PR_UCE:1;
    vuint32_t FR_PR_CEO:1;
    vuint32_t FR_PR_UCO:1;
    vuint32_t FR_PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t FR_F_CE:1;
    vuint32_t FR_F_UCE:1;
    vuint32_t FR_F_CEO:1;
    vuint32_t FR_F_UCO:1;
    vuint32_t FR_F_EBO:1;
    vuint32_t _unused_5:3;
    vuint32_t FR_SR_CE:1;
    vuint32_t FR_SR_UCE:1;
    vuint32_t FR_SR_CEO:1;
    vuint32_t FR_SR_UCO:1;
    vuint32_t FR_SR_EBO:1;
  } B;
} MEMU_0_DEBUG_tag;

typedef union MEMU_0_SYS_RAM_CERR_STS_union_tag { /* System RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_0_SYS_RAM_CERR_STS_tag;

typedef union MEMU_0_SYS_RAM_CERR_ADDR_union_tag { /* System RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_SYS_RAM_CERR_ADDR_tag;

typedef struct MEMU_0_SYS_RAM_CERR_struct_tag {
  MEMU_0_SYS_RAM_CERR_STS_tag STS;     /* System RAM correctable error reporting table status register */
  MEMU_0_SYS_RAM_CERR_ADDR_tag ADDR;   /* System RAM correctable error reporting table address register */
} MEMU_0_SYS_RAM_CERR_tag;

typedef union MEMU_0_SYS_RAM_UNCERR_STS_union_tag { /* System RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_0_SYS_RAM_UNCERR_STS_tag;

typedef union MEMU_0_SYS_RAM_UNCERR_ADDR_union_tag { /* System RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_SYS_RAM_UNCERR_ADDR_tag;

typedef union MEMU_0_SYS_RAM_OFLW_union_tag { /* System RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_0_SYS_RAM_OFLW_tag;

typedef union MEMU_0_PERIPH_RAM_CERR_STS_union_tag { /* Peripheral RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_0_PERIPH_RAM_CERR_STS_tag;

typedef union MEMU_0_PERIPH_RAM_CERR_ADDR_union_tag { /* Peripheral RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_PERIPH_RAM_CERR_ADDR_tag;

typedef struct MEMU_0_PERIPH_RAM_CERR_struct_tag {
  MEMU_0_PERIPH_RAM_CERR_STS_tag STS;  /* Peripheral RAM correctable error reporting table status register */
  MEMU_0_PERIPH_RAM_CERR_ADDR_tag ADDR; /* Peripheral RAM correctable error reporting table address register */
} MEMU_0_PERIPH_RAM_CERR_tag;

typedef union MEMU_0_PERIPH_RAM_UNCERR_STS_union_tag { /* Peripheral RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_0_PERIPH_RAM_UNCERR_STS_tag;

typedef union MEMU_0_PERIPH_RAM_UNCERR_ADDR_union_tag { /* Peripheral RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_PERIPH_RAM_UNCERR_ADDR_tag;

typedef union MEMU_0_PERIPH_RAM_OFLW0_union_tag { /* Peripheral RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_0_PERIPH_RAM_OFLW0_tag;

typedef union MEMU_0_FLASH_CERR_STS_union_tag { /* Flash memory correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_0_FLASH_CERR_STS_tag;

typedef union MEMU_0_FLASH_CERR_ADDR_union_tag { /* Flash memory correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_FLASH_CERR_ADDR_tag;

typedef struct MEMU_0_FLASH_CERR_struct_tag {
  MEMU_0_FLASH_CERR_STS_tag STS;       /* Flash memory correctable error reporting table status register */
  MEMU_0_FLASH_CERR_ADDR_tag ADDR;     /* Flash memory correctable error reporting table address register */
} MEMU_0_FLASH_CERR_tag;

typedef union MEMU_0_FLASH_UNCERR_STS_union_tag { /* Flash memory uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_0_FLASH_UNCERR_STS_tag;

typedef union MEMU_0_FLASH_UNCERR_ADDR_union_tag { /* Flash memory uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_FLASH_UNCERR_ADDR_tag;

typedef union MEMU_0_FLASH_OFLW0_union_tag { /* Flash memory concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_0_FLASH_OFLW0_tag;

struct MEMU_0_tag {
  MEMU_0_CTRL_tag CTRL;                /* Control register */
  MEMU_0_ERR_FLAG_tag ERR_FLAG;        /* Error flag register */
  uint8_t MEMU_0_reserved0[4];
  MEMU_0_DEBUG_tag DEBUG;              /* Debug register */
  uint8_t MEMU_0_reserved1[16];
  MEMU_0_SYS_RAM_CERR_tag SYS_RAM_CERR[10];
  MEMU_0_SYS_RAM_UNCERR_STS_tag SYS_RAM_UNCERR_STS; /* System RAM uncorrectable error reporting table status register */
  MEMU_0_SYS_RAM_UNCERR_ADDR_tag SYS_RAM_UNCERR_ADDR; /* System RAM uncorrectable error reporting table address register */
  MEMU_0_SYS_RAM_OFLW_tag SYS_RAM_OFLW[1]; /* System RAM concurrent overflow register */
  uint8_t MEMU_0_reserved2[1444];
  MEMU_0_PERIPH_RAM_CERR_tag PERIPH_RAM_CERR[2];
  MEMU_0_PERIPH_RAM_UNCERR_STS_tag PERIPH_RAM_UNCERR_STS; /* Peripheral RAM uncorrectable error reporting table status register */
  MEMU_0_PERIPH_RAM_UNCERR_ADDR_tag PERIPH_RAM_UNCERR_ADDR; /* Peripheral RAM uncorrectable error reporting table address register */
  MEMU_0_PERIPH_RAM_OFLW0_tag PERIPH_RAM_OFLW0; /* Peripheral RAM concurrent overflow register */
  uint8_t MEMU_0_reserved3[1508];
  MEMU_0_FLASH_CERR_tag FLASH_CERR[20];
  MEMU_0_FLASH_UNCERR_STS_tag FLASH_UNCERR_STS; /* Flash memory uncorrectable error reporting table status register */
  MEMU_0_FLASH_UNCERR_ADDR_tag FLASH_UNCERR_ADDR; /* Flash memory uncorrectable error reporting table address register */
  MEMU_0_FLASH_OFLW0_tag FLASH_OFLW0;  /* Flash memory concurrent overflow register */
};


/* ============================================================================
   =============================== Module: MEMU_1 =============================
   ============================================================================ */

typedef union MEMU_1_CTRL_union_tag {  /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SWR:1;
    vuint32_t _unused_0:15;
  } B;
} MEMU_1_CTRL_tag;

typedef union MEMU_1_ERR_FLAG_union_tag { /* Error flag register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t PR_CE:1;
    vuint32_t PR_UCE:1;
    vuint32_t PR_CEO:1;
    vuint32_t PR_UCO:1;
    vuint32_t PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t _unused_8:5;
    vuint32_t _unused_5:3;
    vuint32_t SR_CE:1;
    vuint32_t SR_UCE:1;
    vuint32_t SR_CEO:1;
    vuint32_t SR_UCO:1;
    vuint32_t SR_EBO:1;
  } B;
} MEMU_1_ERR_FLAG_tag;

typedef union MEMU_1_DEBUG_union_tag { /* Debug register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t FR_PR_CE:1;
    vuint32_t FR_PR_UCE:1;
    vuint32_t FR_PR_CEO:1;
    vuint32_t FR_PR_UCO:1;
    vuint32_t FR_PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t _unused_8:5;
    vuint32_t _unused_5:3;
    vuint32_t FR_SR_CE:1;
    vuint32_t FR_SR_UCE:1;
    vuint32_t FR_SR_CEO:1;
    vuint32_t FR_SR_UCO:1;
    vuint32_t FR_SR_EBO:1;
  } B;
} MEMU_1_DEBUG_tag;

typedef union MEMU_1_SYS_RAM_CERR_STS_union_tag { /* System RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_1_SYS_RAM_CERR_STS_tag;

typedef union MEMU_1_SYS_RAM_CERR_ADDR_union_tag { /* System RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_1_SYS_RAM_CERR_ADDR_tag;

typedef struct MEMU_1_SYS_RAM_CERR_struct_tag {
  MEMU_1_SYS_RAM_CERR_STS_tag STS;     /* System RAM correctable error reporting table status register */
  MEMU_1_SYS_RAM_CERR_ADDR_tag ADDR;   /* System RAM correctable error reporting table address register */
} MEMU_1_SYS_RAM_CERR_tag;

typedef union MEMU_1_SYS_RAM_UNCERR_STS_union_tag { /* System RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_1_SYS_RAM_UNCERR_STS_tag;

typedef union MEMU_1_SYS_RAM_UNCERR_ADDR_union_tag { /* System RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_1_SYS_RAM_UNCERR_ADDR_tag;

typedef union MEMU_1_SYS_RAM_OFLW_union_tag { /* System RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_1_SYS_RAM_OFLW_tag;

typedef union MEMU_1_PERIPH_RAM_CERR_STS0_union_tag { /* Peripheral RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_1_PERIPH_RAM_CERR_STS0_tag;

typedef union MEMU_1_PERIPH_RAM_CERR_ADDR0_union_tag { /* Peripheral RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_1_PERIPH_RAM_CERR_ADDR0_tag;

typedef union MEMU_1_PERIPH_RAM_UNCERR_STS_union_tag { /* Peripheral RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_1_PERIPH_RAM_UNCERR_STS_tag;

typedef union MEMU_1_PERIPH_RAM_UNCERR_ADDR_union_tag { /* Peripheral RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_1_PERIPH_RAM_UNCERR_ADDR_tag;

typedef union MEMU_1_PERIPH_RAM_OFLW0_union_tag { /* Peripheral RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_1_PERIPH_RAM_OFLW0_tag;

struct MEMU_1_tag {
  MEMU_1_CTRL_tag CTRL;                /* Control register */
  MEMU_1_ERR_FLAG_tag ERR_FLAG;        /* Error flag register */
  uint8_t MEMU_1_reserved0[4];
  MEMU_1_DEBUG_tag DEBUG;              /* Debug register */
  uint8_t MEMU_1_reserved1[16];
  MEMU_1_SYS_RAM_CERR_tag SYS_RAM_CERR[3];
  MEMU_1_SYS_RAM_UNCERR_STS_tag SYS_RAM_UNCERR_STS; /* System RAM uncorrectable error reporting table status register */
  MEMU_1_SYS_RAM_UNCERR_ADDR_tag SYS_RAM_UNCERR_ADDR; /* System RAM uncorrectable error reporting table address register */
  MEMU_1_SYS_RAM_OFLW_tag SYS_RAM_OFLW[1]; /* System RAM concurrent overflow register */
  uint8_t MEMU_1_reserved2[1500];
  MEMU_1_PERIPH_RAM_CERR_STS0_tag PERIPH_RAM_CERR_STS0; /* Peripheral RAM correctable error reporting table status register */
  MEMU_1_PERIPH_RAM_CERR_ADDR0_tag PERIPH_RAM_CERR_ADDR0; /* Peripheral RAM correctable error reporting table address register */
  MEMU_1_PERIPH_RAM_UNCERR_STS_tag PERIPH_RAM_UNCERR_STS; /* Peripheral RAM uncorrectable error reporting table status register */
  MEMU_1_PERIPH_RAM_UNCERR_ADDR_tag PERIPH_RAM_UNCERR_ADDR; /* Peripheral RAM uncorrectable error reporting table address register */
  MEMU_1_PERIPH_RAM_OFLW0_tag PERIPH_RAM_OFLW0; /* Peripheral RAM concurrent overflow register */
};


/* ============================================================================
   =============================== Module: MLB ================================
   ============================================================================ */

typedef union MLB_C0_union_tag {       /* MediaLB Control 0 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;           /* Not to be written by user. */
    vuint32_t FCT:3;
    vuint32_t CTLRETRY:1;
    vuint32_t _unused_13:1;            /* Not to be written by user. */
    vuint32_t ASYRETRY:1;
    vuint32_t _unused_8:4;             /* Not to be written by user. */
    vuint32_t MLBLK:1;
    vuint32_t _unused_6:1;             /* Not to be written by user. */
    vuint32_t MLBPEN:1;
    vuint32_t MCK:3;
    vuint32_t _unused_1:1;             /* Not to be written by user. */
    vuint32_t MLBEN:1;
  } B;
} MLB_C0_tag;

typedef union MLB_MS0_union_tag {      /* MediaLB Channel Status 0 Register */
  vuint32_t R;
  struct {
    vuint32_t MCS:32;
  } B;
} MLB_MS0_tag;

typedef union MLB_MS1_union_tag {      /* MediaLB Channel Status1 Register */
  vuint32_t R;
  struct {
    vuint32_t MCS:32;
  } B;
} MLB_MS1_tag;

typedef union MLB_MSS_union_tag {      /* MediaLB System Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;            /* Not to be written by user. */
    vuint32_t SERVREQ:1;
    vuint32_t SWSYSCMD:1;
    vuint32_t CSSYSCMD:1;
    vuint32_t UKSYSCMD:1;
    vuint32_t LKSYSCMD:1;
    vuint32_t RSTSYCMD:1;
  } B;
} MLB_MSS_tag;

typedef union MLB_MSD_union_tag {      /* MediaLB System Data Register */
  vuint32_t R;
  struct {
    vuint32_t SD3:8;
    vuint32_t SD2:8;
    vuint32_t SD1:8;
    vuint32_t SD0:8;
  } B;
} MLB_MSD_tag;

typedef union MLB_MIEN_union_tag {     /* MediaLB Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;            /* Not to be written by user. */
    vuint32_t CTX_BRK:1;
    vuint32_t CTX_PE:1;
    vuint32_t CTX_DONE:1;
    vuint32_t CRX_BRK:1;
    vuint32_t CRX_PE:1;
    vuint32_t CRX_DONE:1;
    vuint32_t _unused_23:1;            /* Not to be written by user. */
    vuint32_t ATX_BRK:1;
    vuint32_t ATX_PE:1;
    vuint32_t ATX_DONE:1;
    vuint32_t ARX_BRK:1;
    vuint32_t ARX_PE:1;
    vuint32_t ARX_DONE:1;
    vuint32_t SYNC_PE:1;
    vuint32_t _unused_2:14;            /* Not to be written by user. */
    vuint32_t ISOC_BFO:1;
    vuint32_t ISOC_PE:1;
  } B;
} MLB_MIEN_tag;

typedef union MLB_C1_union_tag {       /* MediaLB Control 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;           /* Not to be written by user. */
    vuint32_t NDA:8;
    vuint32_t CLKM:1;
    vuint32_t LOCK:1;
    vuint32_t _unused_0:6;             /* Not to be written by user. */
  } B;
} MLB_C1_tag;

typedef union MLB_HCTL_union_tag {     /* HBI Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;           /* Not to be written by user. */
    vuint32_t EN:1;
    vuint32_t _unused_2:13;            /* Not to be written by user. */
    vuint32_t RST1:1;
    vuint32_t RST0:1;
  } B;
} MLB_HCTL_tag;

typedef union MLB_HCMR0_union_tag {    /* HBI Channel Mask 0 Register */
  vuint32_t R;
  struct {
    vuint32_t CM:32;
  } B;
} MLB_HCMR0_tag;

typedef union MLB_HCMR1_union_tag {    /* HBI Channel Mask 1 Register */
  vuint32_t R;
  struct {
    vuint32_t C:32;
  } B;
} MLB_HCMR1_tag;

typedef union MLB_HCER0_union_tag {    /* HBI Channel Error 0 Register */
  vuint32_t R;
  struct {
    vuint32_t CE:32;
  } B;
} MLB_HCER0_tag;

typedef union MLB_HCER1_union_tag {    /* HBI Channel Error 1 Register */
  vuint32_t R;
  struct {
    vuint32_t E:32;
  } B;
} MLB_HCER1_tag;

typedef union MLB_HCBR0_union_tag {    /* HBI Channel Busy 0 Register */
  vuint32_t R;
  struct {
    vuint32_t CB:32;
  } B;
} MLB_HCBR0_tag;

typedef union MLB_HCBR1_union_tag {    /* HBI Channel Busy 1 Register */
  vuint32_t R;
  struct {
    vuint32_t B:32;
  } B;
} MLB_HCBR1_tag;

typedef union MLB_MDAT0_union_tag {    /* MIF Data 0 Register */
  vuint32_t R;
  struct {
    vuint32_t D:32;
  } B;
} MLB_MDAT0_tag;

typedef union MLB_MDAT1_union_tag {    /* MIF Data 1 Register */
  vuint32_t R;
  struct {
    vuint32_t D:32;
  } B;
} MLB_MDAT1_tag;

typedef union MLB_MDAT2_union_tag {    /* MIF Data 2 Register */
  vuint32_t R;
  struct {
    vuint32_t D:32;
  } B;
} MLB_MDAT2_tag;

typedef union MLB_MDAT3_union_tag {    /* MIF Data 3 Register */
  vuint32_t R;
  struct {
    vuint32_t D:32;
  } B;
} MLB_MDAT3_tag;

typedef union MLB_MDWE0_union_tag {    /* MIF Data Write Enable 0 Register */
  vuint32_t R;
  struct {
    vuint32_t M:32;
  } B;
} MLB_MDWE0_tag;

typedef union MLB_MDWE1_union_tag {    /* MIF Data Write Enable 1 Register */
  vuint32_t R;
  struct {
    vuint32_t M:32;
  } B;
} MLB_MDWE1_tag;

typedef union MLB_MDWE2_union_tag {    /* MIF Data Write Enable 2 Register */
  vuint32_t R;
  struct {
    vuint32_t M:32;
  } B;
} MLB_MDWE2_tag;

typedef union MLB_MDWE3_union_tag {    /* MIF Data Write Enable 3 Register */
  vuint32_t R;
  struct {
    vuint32_t M:32;
  } B;
} MLB_MDWE3_tag;

typedef union MLB_MCTL_union_tag {     /* MIF Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;            /* Not to be written by user. */
    vuint32_t XCMP:1;
  } B;
} MLB_MCTL_tag;

typedef union MLB_MADR_union_tag {     /* MIF Address Register */
  vuint32_t R;
  struct {
    vuint32_t WNR:1;
    vuint32_t TB:1;
    vuint32_t _unused_14:16;           /* Not to be written by user. */
    vuint32_t ADDR:6;
    vuint32_t ADR:8;
  } B;
} MLB_MADR_tag;

typedef union MLB_ACTL_union_tag {     /* AHB Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;            /* Not to be written by user. */
    vuint32_t MPB:1;
    vuint32_t _unused_3:1;             /* Not to be written by user. */
    vuint32_t DMA_MODE:1;
    vuint32_t SMX:1;
    vuint32_t SCE:1;
  } B;
} MLB_ACTL_tag;

typedef union MLB_ACSR0_union_tag {    /* AHB Channel Status 0 Register */
  vuint32_t R;
  struct {
    vuint32_t INTS_LOG:32;
  } B;
} MLB_ACSR0_tag;

typedef union MLB_ACSR1_union_tag {    /* AHB Channel Status 1 Register */
  vuint32_t R;
  struct {
    vuint32_t L:32;
  } B;
} MLB_ACSR1_tag;

typedef union MLB_ACMR0_union_tag {    /* AHB Channel Mask 0 Register */
  vuint32_t R;
  struct {
    vuint32_t CM:32;
  } B;
} MLB_ACMR0_tag;

typedef union MLB_ACMR1_union_tag {    /* AHB Channel Mask 1 Register */
  vuint32_t R;
  struct {
    vuint32_t CHM:32;
  } B;
} MLB_ACMR1_tag;

struct MLB_tag {
  MLB_C0_tag C0;                       /* MediaLB Control 0 Register */
  uint8_t MLB_reserved0[8];
  MLB_MS0_tag MS0;                     /* MediaLB Channel Status 0 Register */
  uint8_t MLB_reserved1[4];
  MLB_MS1_tag MS1;                     /* MediaLB Channel Status1 Register */
  uint8_t MLB_reserved2[8];
  MLB_MSS_tag MSS;                     /* MediaLB System Status Register */
  MLB_MSD_tag MSD;                     /* MediaLB System Data Register */
  uint8_t MLB_reserved3[4];
  MLB_MIEN_tag MIEN;                   /* MediaLB Interrupt Enable Register */
  uint8_t MLB_reserved4[12];
  MLB_C1_tag C1;                       /* MediaLB Control 1 Register */
  uint8_t MLB_reserved5[64];
  MLB_HCTL_tag HCTL;                   /* HBI Control Register */
  uint8_t MLB_reserved6[4];
  MLB_HCMR0_tag HCMR0;                 /* HBI Channel Mask 0 Register */
  MLB_HCMR1_tag HCMR1;                 /* HBI Channel Mask 1 Register */
  MLB_HCER0_tag HCER0;                 /* HBI Channel Error 0 Register */
  MLB_HCER1_tag HCER1;                 /* HBI Channel Error 1 Register */
  MLB_HCBR0_tag HCBR0;                 /* HBI Channel Busy 0 Register */
  MLB_HCBR1_tag HCBR1;                 /* HBI Channel Busy 1 Register */
  uint8_t MLB_reserved7[32];
  MLB_MDAT0_tag MDAT0;                 /* MIF Data 0 Register */
  MLB_MDAT1_tag MDAT1;                 /* MIF Data 1 Register */
  MLB_MDAT2_tag MDAT2;                 /* MIF Data 2 Register */
  MLB_MDAT3_tag MDAT3;                 /* MIF Data 3 Register */
  MLB_MDWE0_tag MDWE0;                 /* MIF Data Write Enable 0 Register */
  MLB_MDWE1_tag MDWE1;                 /* MIF Data Write Enable 1 Register */
  MLB_MDWE2_tag MDWE2;                 /* MIF Data Write Enable 2 Register */
  MLB_MDWE3_tag MDWE3;                 /* MIF Data Write Enable 3 Register */
  MLB_MCTL_tag MCTL;                   /* MIF Control Register */
  MLB_MADR_tag MADR;                   /* MIF Address Register */
  uint8_t MLB_reserved8[728];
  MLB_ACTL_tag ACTL;                   /* AHB Control Register */
  uint8_t MLB_reserved9[12];
  MLB_ACSR0_tag ACSR0;                 /* AHB Channel Status 0 Register */
  MLB_ACSR1_tag ACSR1;                 /* AHB Channel Status 1 Register */
  MLB_ACMR0_tag ACMR0;                 /* AHB Channel Mask 0 Register */
  MLB_ACMR1_tag ACMR1;                 /* AHB Channel Mask 1 Register */
};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

typedef union PASS_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t CNS:1;
    vuint32_t JUN:1;
    vuint32_t TME:1;
    vuint32_t _unused_3:26;
    vuint32_t LIFE:3;
  } B;
} PASS_LCSTAT_tag;

typedef union PASS_CHSEL_union_tag {   /* Challenge Selector Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t GRP:2;
  } B;
} PASS_CHSEL_tag;

typedef union PASS_CSTAT_union_tag {   /* Challenge Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t CMST:4;
  } B;
} PASS_CSTAT_tag;

typedef union PASS_CIN_union_tag {     /* Challenge Input Register */
  vuint32_t R;
  struct {
    vuint32_t PW32:32;
  } B;
} PASS_CIN_tag;

typedef union PASS_PG_LOCK0_union_tag { /* Password Group n - Lock 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;
    vuint32_t ATSL:1;
    vuint32_t LOWLOCK:14;
    vuint32_t MIDLOCK:16;
  } B;
} PASS_PG_LOCK0_tag;

typedef union PASS_PG_LOCK1_union_tag { /* Password Group n - Lock 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHLOCK:16;
  } B;
} PASS_PG_LOCK1_tag;

typedef union PASS_PG_LOCK2_union_tag { /* Password Group n - Lock 2 Status Register */
  vuint32_t R;
  struct {
    vuint32_t L_256LCK:32;
  } B;
} PASS_PG_LOCK2_tag;

typedef union PASS_PG_LOCK3_union_tag { /* Password Group n - Lock 3 Status Register */
  vuint32_t R;
  struct {
    vuint32_t PGL:1;
    vuint32_t DBL:1;
    vuint32_t MO:1;
    vuint32_t _unused_28:1;
    vuint32_t MSTR:4;
    vuint32_t _unused_21:3;
    vuint32_t RL4:1;
    vuint32_t RL3:1;
    vuint32_t RL2:1;
    vuint32_t RL1:1;
    vuint32_t RL0:1;
    vuint32_t U_256LCK:16;
  } B;
} PASS_PG_LOCK3_tag;

typedef struct PASS_PG_struct_tag {
  PASS_PG_LOCK0_tag LOCK0;             /* Password Group n - Lock 0 Status Register */
  PASS_PG_LOCK1_tag LOCK1;             /* Password Group n - Lock 1 Status Register */
  PASS_PG_LOCK2_tag LOCK2;             /* Password Group n - Lock 2 Status Register */
  PASS_PG_LOCK3_tag LOCK3;             /* Password Group n - Lock 3 Status Register */
} PASS_PG_tag;

struct PASS_tag {
  PASS_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
  uint8_t PASS_reserved0[4];
  PASS_CHSEL_tag CHSEL;                /* Challenge Selector Register */
  uint8_t PASS_reserved1[4];
  PASS_CSTAT_tag CSTAT;                /* Challenge Status Register */
  uint8_t PASS_reserved2[12];
  PASS_CIN_tag CIN[8];                 /* Challenge Input Register */
  uint8_t PASS_reserved3[192];
  PASS_PG_tag PG[4];
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

typedef union PCM_IAHB_BE0_union_tag { /* Bus Bridge Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t PRE_FLX:1;               /* Pending read enable (PRE) FLX */
    vuint32_t BRE_FLX:1;               /* Burst read enable (BRE) FLX */
    vuint32_t BWE_FLX:1;               /* Burst Read Enable */
    vuint32_t _unused_19:5;
    vuint32_t PRE_ENET:1;              /* Pending Read Enable ENET */
    vuint32_t BRE_ENET:1;              /* Burst read enable (BRE) ENET */
    vuint32_t BWE_ENET:1;              /* Burst Write Enable ENET */
    vuint32_t _unused_11:5;
    vuint32_t PRE_DMA:1;               /* Pending read enable (PRE) DMA */
    vuint32_t BRE_DMA:1;               /* Burst read enable (BRE) DMA */
    vuint32_t BWE_DMA:1;               /* Burst write enable (BWE) DMA */
    vuint32_t _unused_3:5;
    vuint32_t _unused_0:3;
  } B;
} PCM_IAHB_BE0_tag;

typedef union PCM_IAHB_BE1_union_tag { /* Bus Bridge Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t PRE_uSDHC:1;             /* Pending read enable (PRE) uSDHC */
    vuint32_t BRE_uSDHC:1;             /* Burst read enable (BRE) uSDHC */
    vuint32_t BWE_uSDHC:1;             /* Burst Read Enable uSDHC */
    vuint32_t _unused_19:5;
    vuint32_t PRE_USB_1:1;             /* Pending Read Enable USB_1 */
    vuint32_t BRE_USB_1:1;             /* Burst read enable (BRE) USB_1 */
    vuint32_t BWE_USB_1:1;             /* Burst Write Enable USB_1 */
    vuint32_t _unused_11:5;
    vuint32_t PRE_USB_0:1;             /* Pending read enable (PRE) DMA */
    vuint32_t BRE_USB_0:1;             /* Burst read enable (BRE) USB_0 */
    vuint32_t BWE_USB_0:1;             /* Burst write enable (BWE) USB_0 */
    vuint32_t _unused_3:5;
    vuint32_t PRE_MLB:1;               /* Pending read enable (PRE) MLB */
    vuint32_t BRE_MLB:1;               /* Burst read enable (BRE) MLB */
    vuint32_t BWE_MLB:1;               /* Burst write enable (BWE) MLB */
  } B;
} PCM_IAHB_BE1_tag;

typedef union PCM_IAHB_BE2_union_tag { /* Bus Bridge Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t PRE_PBRIDGE_A:1;         /* Pending read enable (PRE) PBRIDGE_A */
    vuint32_t BRE_PBRIDGE_A:1;         /* Burst read enable (BRE) PBRIDGE_A */
    vuint32_t BWE_PBRIDGE_A:1;         /* Burst Read Enable PBRIDGE_A */
    vuint32_t _unused_19:5;
    vuint32_t PRE_PBRIDGE_B:1;         /* Pending Read Enable PBRIDGE_B */
    vuint32_t BRE_PBRIDGE_B:1;         /* Burst read enable (BRE) PBRIDGE_B */
    vuint32_t BWE_PBRIDGE_B:1;         /* Burst Write Enable PBRIDGE_B */
    vuint32_t _unused_11:5;
    vuint32_t PRE_Z2_DATA:1;           /* Pending read enable (PRE) Z2_DATA */
    vuint32_t BRE_Z2_DATA:1;           /* Burst read enable (BRE) Z2_DATA */
    vuint32_t BWE_Z2_DATA:1;           /* Burst write enable (BWE) Z2_DATA */
    vuint32_t _unused_3:5;
    vuint32_t PRE_Z2_INST:1;           /* Pending read enable (PRE) Z2_INST */
    vuint32_t BRE_Z2_INST:1;           /* Burst read enable (BRE) Z2_INST */
    vuint32_t BWE_Z2_INST:1;           /* Burst write enable (BWE) Z2_INST */
  } B;
} PCM_IAHB_BE2_tag;

typedef union PCM_IAHB_BE3_union_tag { /* Bus Bridge Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t PRE_M1:1;                /* Pending read enable (PRE) M1 */
    vuint32_t BRE_M1:1;                /* Burst read enable (BRE) M1 */
    vuint32_t BWE_M1:1;                /* Burst Write Enable M1 */
    vuint32_t _unused_3:5;
    vuint32_t PRE_M0:1;                /* Pending Read Enable */
    vuint32_t BRE_M0:1;                /* Burst Read Enable */
    vuint32_t BWE_M0:1;                /* Burst Write Enable */
  } B;
} PCM_IAHB_BE3_tag;

typedef union PCM_IPS_CGM_EN0_union_tag { /* IPS Clock Gating Module Enable 0 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t IPS_CGM_SMPU_1:1;        /* IPS clock gating endable for SMPU_1 */
    vuint32_t _unused_25:3;
    vuint32_t IPS_CGM_SMPU_0:1;
    vuint32_t _unused_21:3;
    vuint32_t IPS_CGM_AXBS_1:1;
    vuint32_t _unused_17:3;
    vuint32_t IPS_CGM_AXBS_0:1;        /* IPS clock gating endable for AXBS_0 */
    vuint32_t _unused_13:3;
    vuint32_t IPS_CGM_PRAM2:1;         /* IPS clock gating endable for PRAM2 */
    vuint32_t _unused_9:3;
    vuint32_t IPS_CGM_PRAM1:1;         /* IPS clock gating endable for PRAM1 */
    vuint32_t _unused_5:3;
    vuint32_t IPS_CGM_PRAM0:1;         /* IPS clock gating endable for PRAM0 */
    vuint32_t _unused_1:3;
    vuint32_t IPS_CGM_FLASH:1;         /* IPS clock gating endable for PFlash Controller */
  } B;
} PCM_IPS_CGM_EN0_tag;

typedef union PCM_IPS_CGM_EN1_union_tag { /* IPS Clock Gating Enable 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t IPS_CGM_INTC:1;          /* IPS clock gating endable for INTC */
  } B;
} PCM_IPS_CGM_EN1_tag;

struct PCM_tag {
  PCM_IAHB_BE0_tag IAHB_BE0;           /* Bus Bridge Configuration Register 0 */
  PCM_IAHB_BE1_tag IAHB_BE1;           /* Bus Bridge Configuration Register 0 */
  PCM_IAHB_BE2_tag IAHB_BE2;           /* Bus Bridge Configuration Register 0 */
  PCM_IAHB_BE3_tag IAHB_BE3;           /* Bus Bridge Configuration Register 3 */
  PCM_IPS_CGM_EN0_tag IPS_CGM_EN0;     /* IPS Clock Gating Module Enable 0 Register */
  PCM_IPS_CGM_EN1_tag IPS_CGM_EN1;     /* IPS Clock Gating Enable 1 Register */
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

typedef union PFLASH_PFCR1_union_tag { /* Platform Flash Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t P0_M15PFE:1;
    vuint32_t P0_M14PFE:1;
    vuint32_t P0_M13PFE:1;
    vuint32_t P0_M12PFE:1;
    vuint32_t P0_M11PFE:1;
    vuint32_t P0_M10PFE:1;
    vuint32_t P0_M9PFE:1;
    vuint32_t P0_M8PFE:1;
    vuint32_t P0_M7PFE:1;
    vuint32_t P0_M6PFE:1;
    vuint32_t P0_M5PFE:1;
    vuint32_t P0_M4PFE:1;
    vuint32_t P0_M3PFE:1;
    vuint32_t P0_M2PFE:1;
    vuint32_t P0_M1PFE:1;
    vuint32_t P0_M0PFE:1;
    vuint32_t APC:3;
    vuint32_t RWSC:5;
    vuint32_t _unused_7:1;
    vuint32_t P0_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P0_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P0_PFLIM:2;
    vuint32_t P0_BFEN:1;
  } B;
} PFLASH_PFCR1_tag;

typedef union PFLASH_PFCR2_union_tag { /* Platform Flash Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t P1_M15PFE:1;
    vuint32_t P1_M14PFE:1;
    vuint32_t P1_M13PFE:1;
    vuint32_t P1_M12PFE:1;
    vuint32_t P1_M11PFE:1;
    vuint32_t P1_M10PFE:1;
    vuint32_t P1_M9PFE:1;
    vuint32_t P1_M8PFE:1;
    vuint32_t P1_M7PFE:1;
    vuint32_t P1_M6PFE:1;
    vuint32_t P1_M5PFE:1;
    vuint32_t P1_M4PFE:1;
    vuint32_t P1_M3PFE:1;
    vuint32_t P1_M2PFE:1;
    vuint32_t P1_M1PFE:1;
    vuint32_t P1_M0PFE:1;
    vuint32_t _unused_7:9;
    vuint32_t P1_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P1_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P1_PFLIM:2;
    vuint32_t P1_BFEN:1;
  } B;
} PFLASH_PFCR2_tag;

typedef union PFLASH_PFCR3_union_tag { /* Platform Flash Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t P0_WCFG:2;
    vuint32_t P1_WCFG:2;
    vuint32_t P2_WCFG:2;
    vuint32_t _unused_21:5;
    vuint32_t _unused_20:1;
    vuint32_t _unused_17:3;
    vuint32_t BAF_DIS:1;
    vuint32_t ARBM:4;
    vuint32_t _unused_1:11;
    vuint32_t _unused_0:1;
  } B;
} PFLASH_PFCR3_tag;

typedef union PFLASH_PFAPR_union_tag { /* Platform Flash Access Protection Register */
  vuint32_t R;
  struct {
    vuint32_t M0AP:2;
    vuint32_t M1AP:2;
    vuint32_t M2AP:2;
    vuint32_t M3AP:2;
    vuint32_t M4AP:2;
    vuint32_t M5AP:2;
    vuint32_t M6AP:2;
    vuint32_t M7AP:2;
    vuint32_t M8AP:2;
    vuint32_t M9AP:2;
    vuint32_t M10AP:2;
    vuint32_t M11AP:2;
    vuint32_t M12AP:2;
    vuint32_t M13AP:2;
    vuint32_t M14AP:2;
    vuint32_t M15AP:2;
  } B;
} PFLASH_PFAPR_tag;

typedef union PFLASH_PFCRCR_union_tag { /* Platform Flash Remap Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t SAFE_CAL:1;
    vuint32_t _unused_5:3;
    vuint32_t IRMEN:1;
    vuint32_t _unused_1:3;
    vuint32_t GRMEN:1;
  } B;
} PFLASH_PFCRCR_tag;

typedef union PFLASH_PFCRDE_union_tag { /* Platform Flash Remap Descriptor Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CRD0EN:1;
    vuint32_t CRD1EN:1;
    vuint32_t CRD2EN:1;
    vuint32_t CRD3EN:1;
    vuint32_t CRD4EN:1;
    vuint32_t CRD5EN:1;
    vuint32_t CRD6EN:1;
    vuint32_t CRD7EN:1;
    vuint32_t CRD8EN:1;
    vuint32_t CRD9EN:1;
    vuint32_t CRD10EN:1;
    vuint32_t CRD11EN:1;
    vuint32_t CRD12EN:1;
    vuint32_t CRD13EN:1;
    vuint32_t CRD14EN:1;
    vuint32_t CRD15EN:1;
    vuint32_t _unused_0:16;
  } B;
} PFLASH_PFCRDE_tag;

typedef union PFLASH_PFCR4_union_tag { /* Platform Flash Configuration Register 4 */
  vuint32_t R;
  struct {
    vuint32_t P2_M15PFE:1;
    vuint32_t P2_M14PFE:1;
    vuint32_t P2_M13PFE:1;
    vuint32_t P2_M12PFE:1;
    vuint32_t P2_M11PFE:1;
    vuint32_t P2_M10PFE:1;
    vuint32_t P2_M9PFE:1;
    vuint32_t P2_M8PFE:1;
    vuint32_t P2_M7PFE:1;
    vuint32_t P2_M6PFE:1;
    vuint32_t P2_M5PFE:1;
    vuint32_t P2_M4PFE:1;
    vuint32_t P2_M3PFE:1;
    vuint32_t P2_M2PFE:1;
    vuint32_t P2_M1PFE:1;
    vuint32_t P2_M0PFE:1;
    vuint32_t _unused_7:9;
    vuint32_t P2_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P2_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P2_PFLIM:2;
    vuint32_t P2_BFEN:1;
  } B;
} PFLASH_PFCR4_tag;

typedef union PFLASH_PFCRD_Word0_union_tag { /* Platform Flash Calibration Region Descriptor n Word0 */
  vuint32_t R;
  struct {
    vuint32_t LSTARTADDR:28;
    vuint32_t _unused_0:4;
  } B;
} PFLASH_PFCRD_Word0_tag;

typedef union PFLASH_PFCRD_Word1_union_tag { /* Platform Flash Calibration Region Descriptor n Word1 */
  vuint32_t R;
  struct {
    vuint32_t PSTARTADDR:28;
    vuint32_t _unused_0:4;
  } B;
} PFLASH_PFCRD_Word1_tag;

typedef union PFLASH_PFCRD_Word2_union_tag { /* Platform Flash Calibration Region Descriptor n Word2 */
  vuint32_t R;
  struct {
    vuint32_t M0EN:1;
    vuint32_t M1EN:1;
    vuint32_t M2EN:1;
    vuint32_t M3EN:1;
    vuint32_t M4EN:1;
    vuint32_t M5EN:1;
    vuint32_t M6EN:1;
    vuint32_t M7EN:1;
    vuint32_t M8EN:1;
    vuint32_t M9EN:1;
    vuint32_t M10EN:1;
    vuint32_t M11EN:1;
    vuint32_t M12EN:1;
    vuint32_t M13EN:1;
    vuint32_t M14EN:1;
    vuint32_t M15EN:1;
    vuint32_t _unused_5:11;
    vuint32_t CRDSize:5;
  } B;
} PFLASH_PFCRD_Word2_tag;

typedef struct PFLASH_PFCRD_struct_tag {
  PFLASH_PFCRD_Word0_tag Word0;        /* Platform Flash Calibration Region Descriptor n Word0 */
  PFLASH_PFCRD_Word1_tag Word1;        /* Platform Flash Calibration Region Descriptor n Word1 */
  PFLASH_PFCRD_Word2_tag Word2;        /* Platform Flash Calibration Region Descriptor n Word2 */
  uint8_t PFCRD_reserved0[4];
} PFLASH_PFCRD_tag;

struct PFLASH_tag {
  PFLASH_PFCR1_tag PFCR1;              /* Platform Flash Configuration Register 1 */
  PFLASH_PFCR2_tag PFCR2;              /* Platform Flash Configuration Register 2 */
  PFLASH_PFCR3_tag PFCR3;              /* Platform Flash Configuration Register 3 */
  PFLASH_PFAPR_tag PFAPR;              /* Platform Flash Access Protection Register */
  PFLASH_PFCRCR_tag PFCRCR;            /* Platform Flash Remap Control Register */
  PFLASH_PFCRDE_tag PFCRDE;            /* Platform Flash Remap Descriptor Enable Register */
  PFLASH_PFCR4_tag PFCR4;              /* Platform Flash Configuration Register 4 */
  uint8_t PFLASH_reserved0[228];
  PFLASH_PFCRD_tag PFCRD[16];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

typedef union PIT_MCR_union_tag {      /* PIT Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t MDIS_RTI:1;              /* Module Disable - RTI section */
    vuint32_t MDIS:1;                  /* Module Disable - (PIT section) */
    vuint32_t FRZ:1;                   /* Freeze */
  } B;
} PIT_MCR_tag;

typedef union PIT_RTI_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_RTI_LDVAL_tag;

typedef union PIT_RTI_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_RTI_CVAL_tag;

typedef union PIT_RTI_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TEN:1;                   /* Timer Enable Bit */
  } B;
} PIT_RTI_TCTRL_tag;

typedef union PIT_RTI_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t TIF:1;                   /* Timer Interrupt Flag. */
  } B;
} PIT_RTI_TFLG_tag;

typedef union PIT_TIMER_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_TIMER_LDVAL_tag;

typedef union PIT_TIMER_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_TIMER_CVAL_tag;

typedef union PIT_TIMER_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t CHN:1;                   /* Chain Mode */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TEN:1;                   /* Timer Enable */
  } B;
} PIT_TIMER_TCTRL_tag;

typedef union PIT_TIMER_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t TIF:1;                   /* Timer Interrupt Flag */
  } B;
} PIT_TIMER_TFLG_tag;

typedef struct PIT_TIMER_struct_tag {
  PIT_TIMER_LDVAL_tag LDVAL;           /* Timer Load Value Register */
  PIT_TIMER_CVAL_tag CVAL;             /* Current Timer Value Register */
  PIT_TIMER_TCTRL_tag TCTRL;           /* Timer Control Register */
  PIT_TIMER_TFLG_tag TFLG;             /* Timer Flag Register */
} PIT_TIMER_tag;

struct PIT_tag {
  PIT_MCR_tag MCR;                     /* PIT Module Control Register */
  uint8_t PIT_reserved0[236];
  PIT_RTI_LDVAL_tag RTI_LDVAL;         /* Timer Load Value Register */
  PIT_RTI_CVAL_tag RTI_CVAL;           /* Current Timer Value Register */
  PIT_RTI_TCTRL_tag RTI_TCTRL;         /* Timer Control Register */
  PIT_RTI_TFLG_tag RTI_TFLG;           /* Timer Flag Register */
  PIT_TIMER_tag TIMER[16];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

typedef union PLLDIG_PLLCAL3_union_tag { /* PLL Calibration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t MFDEN:16;                /* Denominator of fractional loop division factor. */
    vuint32_t _unused_0:14;
  } B;
} PLLDIG_PLLCAL3_tag;

typedef union PLLDIG_PLLCR_union_tag { /* PLLDIG PLL Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t _unused_10:1;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t LOLRE:1;                 /* Loss-of-lock reset enable. */
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLLCR_tag;

typedef union PLLDIG_PLLSR_union_tag { /* PLLDIG PLL Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t ENPHI1:1;                /* PLL PHI1 Output Enable */
    vuint32_t ENPHI:1;                 /* PLL PHI Output Enable */
    vuint32_t EXTPDF:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t LOCK:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLLSR_tag;

typedef union PLLDIG_PLLDV_union_tag { /* PLLDIG PLL Divider Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t RFDPHI1:6;               /* PHI1 reduced frequency divider. */
    vuint32_t _unused_22:3;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t _unused_15:1;
    vuint32_t PREDIV:3;                /* Input clock predivider. */
    vuint32_t _unused_11:1;
    vuint32_t _unused_8:3;
    vuint32_t MFD:8;                   /* Loop multiplication factor divider. */
  } B;
} PLLDIG_PLLDV_tag;

typedef union PLLDIG_PLLFM_union_tag { /* PLLDIG PLL Frequency Modulation Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SSCGBYP:1;               /* Modulation enable. */
    vuint32_t _unused_29:1;
    vuint32_t _unused_26:3;
    vuint32_t MODPRD:10;               /* Modulation period. */
    vuint32_t _unused_11:5;
    vuint32_t INCSTP:11;               /* Increment step. */
  } B;
} PLLDIG_PLLFM_tag;

typedef union PLLDIG_PLLFD_union_tag { /* PLLDIG PLL Fractional Divide Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SMDEN:1;                 /* Sigma Delta Modulation Enable */
    vuint32_t SDM2:1;                  /* Second Order Sigma Delta Modulation Select */
    vuint32_t SDM3:1;                  /* Third Order Sigma Delta Modulation Select */
    vuint32_t _unused_22:6;
    vuint32_t DTHRCTL:4;               /* Dither Control. */
    vuint32_t DTHDIS:2;                /* Dither Disable. */
    vuint32_t _unused_15:1;
    vuint32_t MFN:15;
  } B;
} PLLDIG_PLLFD_tag;

typedef union PLLDIG_PLLCAL1_union_tag { /* PLL Calibration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t BYPCAL:1;                /* Bypass calibration block. */
    vuint32_t _unused_0:31;
  } B;
} PLLDIG_PLLCAL1_tag;

struct PLLDIG_tag {
  uint8_t PLLDIG_reserved0[24];
  PLLDIG_PLLCAL3_tag PLLCAL3;          /* PLL Calibration Register 3 */
  uint8_t PLLDIG_reserved1[4];
  PLLDIG_PLLCR_tag PLLCR;              /* PLLDIG PLL Control Register */
  PLLDIG_PLLSR_tag PLLSR;              /* PLLDIG PLL Status Register */
  PLLDIG_PLLDV_tag PLLDV;              /* PLLDIG PLL Divider Register */
  PLLDIG_PLLFM_tag PLLFM;              /* PLLDIG PLL Frequency Modulation Register */
  PLLDIG_PLLFD_tag PLLFD;              /* PLLDIG PLL Fractional Divide Register */
  uint8_t PLLDIG_reserved2[4];
  PLLDIG_PLLCAL1_tag PLLCAL1;          /* PLL Calibration Register 1 */
};


/* ============================================================================
   =============================== Module: PMCDIG =============================
   ============================================================================ */

typedef union PMCDIG_RDCR_union_tag {  /* RAM Domain Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t MEM_SLEEP_EN:1;          /* Memory Sleep Enable */
    vuint32_t _unused_17:3;
    vuint32_t PAD_KEEP_EN:1;           /* PAD Keeper Enable */
    vuint32_t _unused_9:7;
    vuint32_t RD256_RET:1;             /* RAM Domain 256K Retention */
    vuint32_t _unused_5:3;
    vuint32_t RD128_RET:1;             /* RAM Domain 128K Retention */
    vuint32_t _unused_1:3;
    vuint32_t RD64_RET:1;              /* RAM Domain 64K Retention */
  } B;
} PMCDIG_RDCR_tag;

typedef union PMCDIG_SGSR_union_tag {  /* Supply Gauge Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t LP_STATUS:2;             /* Low Power Status */
    vuint32_t _unused_10:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t LVD_FLASH:1;             /* LVD VDD_HV_ FLA Flag */
    vuint32_t LVD_IO_A_HI:1;           /* LVD IO Segment A High Flag */
    vuint32_t LVD_IO_A_LO:1;           /* LVD IO Segment A Low Flag */
    vuint32_t LVD_LV_PD0_hot:1;        /* LVD VDD_LV PD0 hot point Flag */
    vuint32_t LVD_LV_PD1_hot:1;        /* LVD VDD_LV PD1 hot point Flag */
    vuint32_t LVD_LV_PD2_COLD:1;       /* LVD_LV_PD2 Cold Point Flag */
    vuint32_t LVD_LV_PD2_HOT:1;        /* LVD LV_PD2 hot Point Flag */
    vuint32_t POR_LV:1;                /* Power On Reset Flag */
  } B;
} PMCDIG_SGSR_tag;

typedef union PMCDIG_MCR_union_tag {   /* MISC Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_28:3;
    vuint32_t _unused_25:3;
    vuint32_t _unused_24:1;
    vuint32_t _unused_17:7;
    vuint32_t LP_ST_CHG_IN_PRGRS:1;    /* Low Power State Change in Progress */
    vuint32_t FLASH_LP_FAST_EXIT_DIS:1; /* Flash Low Power Fast Exit Disable */
    vuint32_t _unused_12:3;
    vuint32_t LVD_PD2_COLD_REE:1;      /* LVD_PD2 Cold Point Flag Reset Event Enable */
    vuint32_t HVD_REE:1;               /* HVD Reset Event Enable */
    vuint32_t _unused_9:1;
    vuint32_t LVD_IO_HI_REE:1;         /* LVD_IO_HI Reset Event Enable */
    vuint32_t _unused_3:5;
    vuint32_t _unused_0:3;
  } B;
} PMCDIG_MCR_tag;

struct PMCDIG_tag {
  PMCDIG_RDCR_tag RDCR;                /* RAM Domain Configuration Register */
  PMCDIG_SGSR_tag SGSR;                /* Supply Gauge Status Register */
  uint8_t PMCDIG_reserved0[8];
  PMCDIG_MCR_tag MCR;                  /* MISC Control Register */
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

typedef union PRAMC_PRCR1_union_tag {  /* Platform RAM Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_6:2;
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR1_tag;

struct PRAMC_tag {
  PRAMC_PRCR1_tag PRCR1;               /* Platform RAM Configuration Register 1 */
};


/* ============================================================================
   =============================== Module: RTC ================================
   ============================================================================ */

typedef union RTC_RTCSUPV_union_tag {  /* RTC Supervisor Control register */
  vuint32_t R;
  struct {
    vuint32_t SUPV:1;                  /* RTC Supervisor Bit. */
    vuint32_t _unused_0:31;            /* Reserved. */
  } B;
} RTC_RTCSUPV_tag;

typedef union RTC_RTCC_union_tag {     /* RTC Control register */
  vuint32_t R;
  struct {
    vuint32_t CNTEN:1;                 /* Counter Enable. */
    vuint32_t RTCIE:1;                 /* RTC Interrupt Enable. */
    vuint32_t FRZEN:1;                 /* Freeze Enable Bit. */
    vuint32_t ROVREN:1;                /* Counter Roll Over Wakeup/Interrupt Enable. */
    vuint32_t _unused_16:12;           /* Reserved. */
    vuint32_t APIEN:1;                 /* Autonomous Periodic Interrupt Enable. */
    vuint32_t APIIE:1;                 /* API Interrupt Enable. */
    vuint32_t CLKSEL:2;                /* Clock Select. */
    vuint32_t DIV512EN:1;              /* Divide by 512 enable. */
    vuint32_t DIV32EN:1;               /* Divide by 32 enable. */
    vuint32_t _unused_1:9;             /* Reserved. */
    vuint32_t TRIG_EN:1;               /* Trigger enable for Analog Comparator */
  } B;
} RTC_RTCC_tag;

typedef union RTC_RTCS_union_tag {     /* RTC Status register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;            /* Reserved. */
    vuint32_t RTCF:1;                  /* RTC Interrupt Flag. */
    vuint32_t _unused_19:10;           /* Reserved. */
    vuint32_t INV_RTC:1;               /* Invalid rtc write */
    vuint32_t INV_API:1;               /* Invalid APIVAL write */
    vuint32_t INV_ANL:1;               /* Invalid ANLCMP write */
    vuint32_t _unused_14:2;
    vuint32_t APIF:1;                  /* API Interrupt Flag. */
    vuint32_t _unused_11:2;            /* Reserved. */
    vuint32_t ROVRF:1;                 /* Counter Roll Over Interrupt Flag. */
    vuint32_t _unused_0:10;            /* Reserved. */
  } B;
} RTC_RTCS_tag;

typedef union RTC_RTCCNT_union_tag {   /* RTC Counter register */
  vuint32_t R;
  struct {
    vuint32_t RTCCNT:32;               /* RTC Counter Value. */
  } B;
} RTC_RTCCNT_tag;

typedef union RTC_APIVAL_union_tag {   /* API Compare Value register */
  vuint32_t R;
  struct {
    vuint32_t APIVAL:32;               /* API Compare Value. */
  } B;
} RTC_APIVAL_tag;

typedef union RTC_RTCVAL_union_tag {   /* RTC Compare Value register */
  vuint32_t R;
  struct {
    vuint32_t RTCVAL:32;               /* RTC Compare Value. */
  } B;
} RTC_RTCVAL_tag;

typedef union RTC_ANLCMP_CNT_union_tag { /* RTC Analogue comparator count register */
  vuint32_t R;
  struct {
    vuint32_t ANLCMP:32;               /* The trigger_en_out pulse will be generated (after the generation of wakeup_api signal) as per the number of API clocks programmed into this register. */
  } B;
} RTC_ANLCMP_CNT_tag;

struct RTC_tag {
  RTC_RTCSUPV_tag RTCSUPV;             /* RTC Supervisor Control register */
  RTC_RTCC_tag RTCC;                   /* RTC Control register */
  RTC_RTCS_tag RTCS;                   /* RTC Status register */
  RTC_RTCCNT_tag RTCCNT;               /* RTC Counter register */
  RTC_APIVAL_tag APIVAL;               /* API Compare Value register */
  RTC_RTCVAL_tag RTCVAL;               /* RTC Compare Value register */
  RTC_ANLCMP_CNT_tag ANLCMP_CNT;       /* RTC Analogue comparator count register */
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

typedef union SEMA42_GATE_union_tag {  /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
  } B;
} SEMA42_GATE_tag;

typedef union SEMA42_RSTGT_R_union_tag { /* Reset Gate Read */
  vuint16_t R;
  struct {
    vuint16_t ROZ:2;
    vuint16_t RSTGSM:2;
    vuint16_t RSTGMS:4;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_R_tag;

typedef union SEMA42_RSTGT_W_union_tag { /* Reset Gate Write */
  vuint16_t R;
  struct {
    vuint16_t RSTGDP:8;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_W_tag;

typedef union SEMA42_RSTGT_union_tag {
  SEMA42_RSTGT_R_tag R;                /* Reset Gate Read */
  SEMA42_RSTGT_W_tag W;                /* Reset Gate Write */
} SEMA42_RSTGT_tag;

struct SEMA42_tag {
  SEMA42_GATE_tag GATE[16];            /* Gate Register */
  uint8_t SEMA42_reserved0[48];
  SEMA42_RSTGT_tag RSTGT;
};


/* ============================================================================
   =============================== Module: SIRC ===============================
   ============================================================================ */

typedef union SIRC_CTL_union_tag {     /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_13:3;
    vuint32_t SIRCDIV:5;               /* The SIRC Divider bits select the clock divider . factor */
    vuint32_t _unused_5:3;
    vuint32_t SIRCS:1;                 /* Describes the SIRC clock status. */
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} SIRC_CTL_tag;

struct SIRC_tag {
  SIRC_CTL_tag CTL;                    /* Control register */
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

typedef union SIUL2_MIDR1_union_tag {  /* SIUL2 MCU ID Register #1 */
  vuint32_t R;
  struct {
    vuint32_t PARTNUM:16;              /* MCU Part Number */
    vuint32_t _unused_15:1;
    vuint32_t PKG:5;                   /* Package Settings */
    vuint32_t _unused_8:2;
    vuint32_t MAJOR_MASK:4;            /* Major Mask Revision */
    vuint32_t MINOR_MASK:4;            /* Minor Mask Revision */
  } B;
} SIUL2_MIDR1_tag;

typedef union SIUL2_MIDR2_union_tag {  /* SIUL2 MCU ID Register #2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FLASH_SIZE_1:4;          /* Coarse granularity for flash memory size */
    vuint32_t FLASH_SIZE_2:4;          /* Fine granularity for flash memory size */
    vuint32_t _unused_16:7;
    vuint32_t PARTNUM:8;               /* ASCII character in MCU Part Number */
    vuint32_t _unused_0:8;
  } B;
} SIUL2_MIDR2_tag;

typedef union SIUL2_ISR0_union_tag {   /* SIUL2 Interrupt Status Flag Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIF31:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF30:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF29:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF28:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF27:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF26:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF25:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF24:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF23:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF22:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF21:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF20:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF19:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF18:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF17:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF16:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF15:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF14:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF13:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF12:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF11:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF10:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF9:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF8:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF7:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF6:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF5:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF4:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF3:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF2:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF1:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF0:1;                  /* External Interrupt Status Flag x */
  } B;
} SIUL2_ISR0_tag;

typedef union SIUL2_IRER0_union_tag {  /* SIUL2 Interrupt Request Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIRE31:1;
    vuint32_t EIRE30:1;
    vuint32_t EIRE29:1;
    vuint32_t EIRE28:1;
    vuint32_t EIRE27:1;
    vuint32_t EIRE26:1;
    vuint32_t EIRE25:1;
    vuint32_t EIRE24:1;
    vuint32_t EIRE23:1;
    vuint32_t EIRE22:1;
    vuint32_t EIRE21:1;
    vuint32_t EIRE20:1;
    vuint32_t EIRE19:1;
    vuint32_t EIRE18:1;
    vuint32_t EIRE17:1;
    vuint32_t EIRE16:1;
    vuint32_t EIRE15:1;
    vuint32_t EIRE14:1;
    vuint32_t EIRE13:1;
    vuint32_t EIRE12:1;
    vuint32_t EIRE11:1;
    vuint32_t EIRE10:1;
    vuint32_t EIRE9:1;
    vuint32_t EIRE8:1;
    vuint32_t EIRE7:1;
    vuint32_t EIRE6:1;
    vuint32_t EIRE5:1;
    vuint32_t EIRE4:1;
    vuint32_t EIRE3:1;
    vuint32_t EIRE2:1;
    vuint32_t EIRE1:1;
    vuint32_t EIRE0:1;
  } B;
} SIUL2_IRER0_tag;

typedef union SIUL2_IRSR0_union_tag {  /* SIUL2 Interrupt Request Select Register0 */
  vuint32_t R;
  struct {
    vuint32_t DIRSR31:1;
    vuint32_t DIRSR30:1;
    vuint32_t DIRSR29:1;
    vuint32_t DIRSR28:1;
    vuint32_t DIRSR27:1;
    vuint32_t DIRSR26:1;
    vuint32_t DIRSR25:1;
    vuint32_t DIRSR24:1;
    vuint32_t DIRSR23:1;
    vuint32_t DIRSR22:1;
    vuint32_t DIRSR21:1;
    vuint32_t DIRSR20:1;
    vuint32_t DIRSR19:1;
    vuint32_t DIRSR18:1;
    vuint32_t DIRSR17:1;
    vuint32_t DIRSR16:1;
    vuint32_t DIRSR15:1;
    vuint32_t DIRSR14:1;
    vuint32_t DIRSR13:1;
    vuint32_t DIRSR12:1;
    vuint32_t DIRSR11:1;
    vuint32_t DIRSR10:1;
    vuint32_t DIRSR9:1;
    vuint32_t DIRSR8:1;
    vuint32_t DIRSR7:1;
    vuint32_t DIRSR6:1;
    vuint32_t DIRSR5:1;
    vuint32_t DIRSR4:1;
    vuint32_t DIRSR3:1;
    vuint32_t DIRSR2:1;
    vuint32_t DIRSR1:1;
    vuint32_t DIRSR0:1;
  } B;
} SIUL2_IRSR0_tag;

typedef union SIUL2_IREER0_union_tag { /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IREE31:1;
    vuint32_t IREE30:1;
    vuint32_t IREE29:1;
    vuint32_t IREE28:1;
    vuint32_t IREE27:1;
    vuint32_t IREE26:1;
    vuint32_t IREE25:1;
    vuint32_t IREE24:1;
    vuint32_t IREE23:1;
    vuint32_t IREE22:1;
    vuint32_t IREE21:1;
    vuint32_t IREE20:1;
    vuint32_t IREE19:1;
    vuint32_t IREE18:1;
    vuint32_t IREE17:1;
    vuint32_t IREE16:1;
    vuint32_t IREE15:1;
    vuint32_t IREE14:1;
    vuint32_t IREE13:1;
    vuint32_t IREE12:1;
    vuint32_t IREE11:1;
    vuint32_t IREE10:1;
    vuint32_t IREE9:1;
    vuint32_t IREE8:1;
    vuint32_t IREE7:1;
    vuint32_t IREE6:1;
    vuint32_t IREE5:1;
    vuint32_t IREE4:1;
    vuint32_t IREE3:1;
    vuint32_t IREE2:1;
    vuint32_t IREE1:1;
    vuint32_t IREE0:1;
  } B;
} SIUL2_IREER0_tag;

typedef union SIUL2_IFEER0_union_tag { /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFEE31:1;
    vuint32_t IFEE30:1;
    vuint32_t IFEE29:1;
    vuint32_t IFEE28:1;
    vuint32_t IFEE27:1;
    vuint32_t IFEE26:1;
    vuint32_t IFEE25:1;
    vuint32_t IFEE24:1;
    vuint32_t IFEE23:1;
    vuint32_t IFEE22:1;
    vuint32_t IFEE21:1;
    vuint32_t IFEE20:1;
    vuint32_t IFEE19:1;
    vuint32_t IFEE18:1;
    vuint32_t IFEE17:1;
    vuint32_t IFEE16:1;
    vuint32_t IFEE15:1;
    vuint32_t IFEE14:1;
    vuint32_t IFEE13:1;
    vuint32_t IFEE12:1;
    vuint32_t IFEE11:1;
    vuint32_t IFEE10:1;
    vuint32_t IFEE9:1;
    vuint32_t IFEE8:1;
    vuint32_t IFEE7:1;
    vuint32_t IFEE6:1;
    vuint32_t IFEE5:1;
    vuint32_t IFEE4:1;
    vuint32_t IFEE3:1;
    vuint32_t IFEE2:1;
    vuint32_t IFEE1:1;
    vuint32_t IFEE0:1;
  } B;
} SIUL2_IFEER0_tag;

typedef union SIUL2_IFER0_union_tag {  /* SIUL2 Interrupt Filter Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFE31:1;
    vuint32_t IFE30:1;
    vuint32_t IFE29:1;
    vuint32_t IFE28:1;
    vuint32_t IFE27:1;
    vuint32_t IFE26:1;
    vuint32_t IFE25:1;
    vuint32_t IFE24:1;
    vuint32_t IFE23:1;
    vuint32_t IFE22:1;
    vuint32_t IFE21:1;
    vuint32_t IFE20:1;
    vuint32_t IFE19:1;
    vuint32_t IFE18:1;
    vuint32_t IFE17:1;
    vuint32_t IFE16:1;
    vuint32_t IFE15:1;
    vuint32_t IFE14:1;
    vuint32_t IFE13:1;
    vuint32_t IFE12:1;
    vuint32_t IFE11:1;
    vuint32_t IFE10:1;
    vuint32_t IFE9:1;
    vuint32_t IFE8:1;
    vuint32_t IFE7:1;
    vuint32_t IFE6:1;
    vuint32_t IFE5:1;
    vuint32_t IFE4:1;
    vuint32_t IFE3:1;
    vuint32_t IFE2:1;
    vuint32_t IFE1:1;
    vuint32_t IFE0:1;
  } B;
} SIUL2_IFER0_tag;

typedef union SIUL2_IFMCR_union_tag {  /* SIUL2 Interrupt Filter Maximum Counter Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t MAXCNT:4;                /* Maximum Interrupt Filter Counter setting */
  } B;
} SIUL2_IFMCR_tag;

typedef union SIUL2_IFCPR_union_tag {  /* SIUL2 Interrupt Filter Clock Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t IFCP:4;                  /* Interrupt Filter Clock Prescaler setting */
  } B;
} SIUL2_IFCPR_tag;

typedef union SIUL2_MSCR_union_tag {   /* SIUL2 Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t SRC:2;                   /* Slew Rate Control */
    vuint32_t _unused_26:2;
    vuint32_t OBE:1;                   /* GPIO Output Buffer Enable */
    vuint32_t ODE:1;                   /* Open Drain Enable */
    vuint32_t SMC:1;                   /* Safe Mode Control */
    vuint32_t APC:1;                   /* Analog Pad Control */
    vuint32_t _unused_21:1;
    vuint32_t _unused_20:1;
    vuint32_t IBE:1;                   /* Input Buffer Enable */
    vuint32_t HYS:1;                   /* Input Hysteresis */
    vuint32_t PUS:1;                   /* Pull Select */
    vuint32_t PUE:1;                   /* Pull Enable */
    vuint32_t _unused_8:8;
    vuint32_t _unused_4:4;
    vuint32_t SSS:4;                   /* Source Signal Select */
  } B;
} SIUL2_MSCR_tag;

typedef union SIUL2_IMCR_union_tag {   /* SIUL2 Input Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t SSS:4;                   /* Source Signal Select */
  } B;
} SIUL2_IMCR_tag;

typedef union SIUL2_GPDO_union_tag {   /* SIUL2 GPIO Pad Data Output Register */
    vuint8_t R;
    struct {
      vuint8_t _unused_1:7;
      vuint8_t PDO_4n:1;					     /* Pad Data Out */
    } B;
} SIUL2_GPDO_tag;

typedef union SIUL2_GPDI_union_tag {   /* SIUL2 GPIO Pad Data Input Register */
    vuint8_t R;
    struct {
      vuint8_t _unused_1:7;
      vuint8_t PDI_4n:1;					     /* Pad Data In */
    } B;
} SIUL2_GPDI_tag;

typedef union SIUL2_PGPDO_union_tag {  /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO_tag;

typedef union SIUL2_PGPDI_union_tag {  /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI_tag;

typedef union SIUL2_MPGPDO_union_tag { /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
  vuint32_t R;
  struct {
    vuint32_t MASK:16;                 /* Mask Field */
    vuint32_t MPPDO:16;                /* Masked Parallel Pad Data Out */
  } B;
} SIUL2_MPGPDO_tag;

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  SIUL2_MIDR1_tag MIDR1;               /* SIUL2 MCU ID Register #1 */
  SIUL2_MIDR2_tag MIDR2;               /* SIUL2 MCU ID Register #2 */
  uint8_t SIUL2_reserved1[4];
  SIUL2_ISR0_tag ISR0;                 /* SIUL2 Interrupt Status Flag Register0 */
  uint8_t SIUL2_reserved2[4];
  SIUL2_IRER0_tag IRER0;               /* SIUL2 Interrupt Request Enable Register0 */
  uint8_t SIUL2_reserved3[4];
  SIUL2_IRSR0_tag IRSR0;               /* SIUL2 Interrupt Request Select Register0 */
  uint8_t SIUL2_reserved4[4];
  SIUL2_IREER0_tag IREER0;             /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved5[4];
  SIUL2_IFEER0_tag IFEER0;             /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved6[4];
  SIUL2_IFER0_tag IFER0;               /* SIUL2 Interrupt Filter Enable Register 0 */
  uint8_t SIUL2_reserved7[4];
  SIUL2_IFMCR_tag IFMCR[32];           /* SIUL2 Interrupt Filter Maximum Counter Register */
  SIUL2_IFCPR_tag IFCPR;               /* SIUL2 Interrupt Filter Clock Prescaler Register */
  uint8_t SIUL2_reserved8[380];
  SIUL2_MSCR_tag MSCR[264];            /* SIUL2 Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved9[992];
  SIUL2_IMCR_tag IMCR[512];            /* SIUL2 Input Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved10[192];
  SIUL2_GPDO_tag GPDO[264];             /* SIUL2 GPIO Pad Data Output Register */
  uint8_t SIUL2_reserved11[248];
  SIUL2_GPDI_tag GPDI[264];             /* SIUL2 GPIO Pad Data Input Register */
  uint8_t SIUL2_reserved12[248];
  SIUL2_PGPDO_tag PGPDO[32];           /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDI_tag PGPDI[32];           /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_MPGPDO_tag MPGPDO[32];         /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

typedef union SMPU_CES0_union_tag {    /* Control/Error Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MERR:16;                 /* Master n error, where the bus master number matches the bit number */
    vuint32_t _unused_4:12;
    vuint32_t HRL:3;                   /* Hardware revision level */
    vuint32_t GVLD:1;                  /* Global Valid (global enable/disable for the SMPU) */
  } B;
} SMPU_CES0_tag;

typedef union SMPU_CES1_union_tag {    /* Control/Error Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MEOVR:16;                /* Master n error overrun, where the bus master number matches the bit number */
    vuint32_t _unused_4:12;
    vuint32_t NRGD:4;                  /* Number of region descriptors */
  } B;
} SMPU_CES1_tag;

typedef union SMPU_ERROR_ADR_union_tag { /* Error Address Register, Bus Master */
  vuint32_t R;
  struct {
    vuint32_t EADDR:32;                /* Error address */
  } B;
} SMPU_ERROR_ADR_tag;

typedef union SMPU_ERROR_ADTL_union_tag { /* Error Attribute Detail Register, Bus Master */
  vuint32_t R;
  struct {
    vuint32_t PID:8;
    vuint32_t _unused_10:14;
    vuint32_t EATTR:2;                 /* Error attributes */
    vuint32_t ERW:1;                   /* Error read/write */
    vuint32_t EMN:7;                   /* Error master number */
  } B;
} SMPU_ERROR_ADTL_tag;

typedef union SMPU_ERROR_ACDL_union_tag { /* Error Attribute Control Detail Register, Bus Master */
  vuint32_t R;
  struct {
    vuint32_t EACD:24;                 /* Error access control detail */
    vuint32_t _unused_0:8;
  } B;
} SMPU_ERROR_ACDL_tag;

typedef struct SMPU_ERROR_struct_tag {
  SMPU_ERROR_ADR_tag ADR;              /* Error Address Register, Bus Master */
  SMPU_ERROR_ADTL_tag ADTL;            /* Error Attribute Detail Register, Bus Master */
  SMPU_ERROR_ACDL_tag ACDL;            /* Error Attribute Control Detail Register, Bus Master */
  uint8_t ERROR_reserved0[4];
} SMPU_ERROR_tag;

typedef union SMPU_RGD_WORD0_union_tag { /* Region Descriptor n, Word 0 */
  vuint32_t R;
  struct {
    vuint32_t SRTADDR:28;              /* Start address */
    vuint32_t _unused_0:4;
  } B;
} SMPU_RGD_WORD0_tag;

typedef union SMPU_RGD_WORD1_union_tag { /* Region Descriptor n, Word 1 */
  vuint32_t R;
  struct {
    vuint32_t ENDADDR:28;              /* End address */
    vuint32_t _unused_0:4;
  } B;
} SMPU_RGD_WORD1_tag;

typedef union SMPU_RGD_WORD2_FMT0_union_tag { /* Region Descriptor n, Word 2 Format 0 */
  vuint32_t R;
  struct {
    vuint32_t M0P:2;                   /* Bus master 0 permissions */
    vuint32_t M1P:2;                   /* Bus master 1 permissions */
    vuint32_t M2P:2;                   /* Bus master 2 permissions */
    vuint32_t M3P:2;                   /* Bus master 3 permissions */
    vuint32_t M4P:2;                   /* Bus master 4 permissions */
    vuint32_t M5P:2;                   /* Bus master 5 permissions */
    vuint32_t M6P:2;                   /* Bus master 6 permissions */
    vuint32_t M7P:2;                   /* Bus master 7 permissions */
    vuint32_t M8P:2;                   /* Bus master 8 permissions */
    vuint32_t M9P:2;                   /* Bus master 9 permissions */
    vuint32_t M10P:2;                  /* Bus master 10 permissions */
    vuint32_t M11P:2;                  /* Bus master 11 permissions */
    vuint32_t M12P:2;                  /* Bus master 12 permissions */
    vuint32_t M13P:2;                  /* Bus master 13 permissions */
    vuint32_t M14P:2;                  /* Bus master 14 permissions */
    vuint32_t M15P:2;                  /* Bus master 15 permissions */
  } B;
} SMPU_RGD_WORD2_FMT0_tag;

typedef union SMPU_RGD_WORD2_FMT1_union_tag { /* Region Descriptor n, Word 2 Format 1 */
  vuint32_t R;
  struct {
    vuint32_t M0S:2;                   /* Bus master 0 permission select */
    vuint32_t M1S:2;                   /* Bus master 1 permission select */
    vuint32_t M2S:2;                   /* Bus master 2 permission select */
    vuint32_t M3S:2;                   /* Bus master 3 permission select */
    vuint32_t M4S:2;                   /* Bus master 4 permission select */
    vuint32_t M5S:2;                   /* Bus master 5 permission select */
    vuint32_t M6S:2;                   /* Bus master 6 permission select */
    vuint32_t M7S:2;                   /* Bus master 7 permission select */
    vuint32_t M8S:2;                   /* Bus master 8 permission select */
    vuint32_t M9S:2;                   /* Bus master 9 permission select */
    vuint32_t M10S:2;                  /* Bus master 10 permission select */
    vuint32_t M11S:2;                  /* Bus master 11 permission select */
    vuint32_t M12S:2;                  /* Bus master 12 permission select */
    vuint32_t M13S:2;                  /* Bus master 13 permission select */
    vuint32_t M14S:2;                  /* Bus master 14 permission select */
    vuint32_t M15S:2;                  /* Bus master 15 permission select */
  } B;
} SMPU_RGD_WORD2_FMT1_tag;

typedef union SMPU_RGD_WORD2_union_tag {
  SMPU_RGD_WORD2_FMT0_tag FMT0;        /* Region Descriptor n, Word 2 Format 0 */
  SMPU_RGD_WORD2_FMT1_tag FMT1;        /* Region Descriptor n, Word 2 Format 1 */
} SMPU_RGD_WORD2_tag;

typedef union SMPU_RGD_WORD3_union_tag { /* Region Descriptor n, Word 3 */
  vuint32_t R;
  struct {
    vuint32_t ACCSET1:6;               /* Access controls, Set 1 */
    vuint32_t ACCSET2:6;               /* Access controls, Set 2 */
    vuint32_t ACCSET3:6;               /* Access controls, Set 3 */
    vuint32_t _unused_5:9;
    vuint32_t FMT:1;                   /* Region Descriptor Format */
    vuint32_t _unused_2:2;
    vuint32_t CI:1;                    /* Cache Inhibit */
    vuint32_t _unused_0:1;
  } B;
} SMPU_RGD_WORD3_tag;

typedef union SMPU_RGD_WORD4_union_tag { /* Region Descriptor n, Word 4 */
  vuint32_t R;
  struct {
    vuint32_t PID:8;                   /* Process Identifier */
    vuint32_t PID_MASK:8;              /* Process Identifier Mask */
    vuint32_t _unused_1:15;
    vuint32_t PIDEN:1;                 /* Region Descriptor PID Enable */
  } B;
} SMPU_RGD_WORD4_tag;

typedef union SMPU_RGD_WORD5_union_tag { /* Region Descriptor n, Word 5 */
  vuint32_t R;
  struct {
    vuint32_t MID:8;                   /* Master ID of RGDn owner */
    vuint32_t _unused_4:20;
    vuint32_t LCK:2;                   /* Region Descriptor Lock */
    vuint32_t _unused_1:1;
    vuint32_t VLD:1;                   /* Valid */
  } B;
} SMPU_RGD_WORD5_tag;

typedef struct SMPU_RGD_struct_tag {
  SMPU_RGD_WORD0_tag WORD0;            /* Region Descriptor n, Word 0 */
  SMPU_RGD_WORD1_tag WORD1;            /* Region Descriptor n, Word 1 */
  SMPU_RGD_WORD2_tag WORD2;
  SMPU_RGD_WORD3_tag WORD3;            /* Region Descriptor n, Word 3 */
  SMPU_RGD_WORD4_tag WORD4;            /* Region Descriptor n, Word 4 */
  SMPU_RGD_WORD5_tag WORD5;            /* Region Descriptor n, Word 5 */
  uint8_t RGD_reserved0[40];
} SMPU_RGD_tag;

struct SMPU_tag {
  SMPU_CES0_tag CES0;                  /* Control/Error Status Register 0 */
  SMPU_CES1_tag CES1;                  /* Control/Error Status Register 1 */
  uint8_t SMPU_reserved0[248];
  SMPU_ERROR_tag ERROR[16];
  uint8_t SMPU_reserved1[512];
  SMPU_RGD_tag RGD[16];
};
/* ============================================================================
   =============================== Module: SPI ================================
   ============================================================================ */

typedef union SPI_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTR:1;                  /* Master/Slave Mode Select */
    vuint32_t CONT_SCKE:1;             /* Continuous SCK Enable */
    vuint32_t DCONF:2;                 /* SPI Configuration. */
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t MTFE:1;                  /* Modified Transfer Format Enable */
    vuint32_t PCSSE:1;                 /* Peripheral Chip Select Strobe Enable */
    vuint32_t ROOE:1;                  /* Receive FIFO Overflow Overwrite Enable */
    vuint32_t _unused_22:2;            /* Always write the reset value to this field. */
    vuint32_t PCSIS:6;                 /* Peripheral Chip Select x Inactive State */
    vuint32_t _unused_15:1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t DIS_TXF:1;               /* Disable Transmit FIFO */
    vuint32_t DIS_RXF:1;               /* Disable Receive FIFO */
    vuint32_t CLR_TXF:1;               /* Clear TX FIFO */
    vuint32_t CLR_RXF:1;               /* CLR_RXF */
    vuint32_t SMPL_PT:2;               /* Sample Point */
    vuint32_t _unused_4:4;
    vuint32_t XSPI:1;                  /* Extended SPI Mode */
    vuint32_t FCPCS:1;                 /* Fast Continuous PCS Mode. */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t HALT:1;                  /* Halt */
  } B;
} SPI_MCR_tag;

typedef union SPI_TCR_union_tag {      /* Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t SPI_TCNT:16;             /* SPI Transfer Counter */
    vuint32_t _unused_0:16;
  } B;
} SPI_TCR_tag;

typedef union SPI_MODE_CTAR_union_tag { /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t DBR:1;                   /* Double Baud Rate */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t BR:4;                    /* Baud Rate Scaler */
  } B;
} SPI_MODE_CTAR_tag;

typedef union SPI_MODE_CTAR_SLAVE_union_tag { /* Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t FMSZ:5;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t _unused_22:1;
    vuint32_t _unused_0:22;
  } B;
} SPI_MODE_CTAR_SLAVE_tag;

typedef union SPI_MODE_union_tag {
  SPI_MODE_CTAR_tag CTAR[6];           /* Clock and Transfer Attributes Register (In Master Mode) */
  SPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[2]; /* Clock and Transfer Attributes Register (In Slave Mode) */
} SPI_MODE_tag;

typedef union SPI_SR_union_tag {       /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t TCF:1;                   /* Transfer Complete Flag */
    vuint32_t TXRXS:1;                 /* TX and RX Status */
    vuint32_t _unused_29:1;
    vuint32_t EOQF:1;                  /* End of Queue Flag */
    vuint32_t TFUF:1;                  /* Transmit FIFO Underflow Flag */
    vuint32_t _unused_26:1;
    vuint32_t TFFF:1;                  /* Transmit FIFO Fill Flag */
    vuint32_t BSYF:1;                  /* Busy Flag. */
    vuint32_t CMDTCF:1;                /* Command Transfer Complete Flag. */
    vuint32_t _unused_22:1;
    vuint32_t SPEF:1;                  /* SPI Parity Error Flag */
    vuint32_t _unused_20:1;
    vuint32_t RFOF:1;                  /* Receive FIFO Overflow Flag */
    vuint32_t TFIWF:1;                 /* Tranmit FIFO Invalid Write Flag */
    vuint32_t RFDF:1;                  /* Receive FIFO Drain Flag */
    vuint32_t CMDFFF:1;                /* Command FIFO Fill Flag */
    vuint32_t TXCTR:4;                 /* TX FIFO Counter */
    vuint32_t TXNXTPTR:4;              /* Transmit Next Pointer */
    vuint32_t RXCTR:4;                 /* RX FIFO Counter */
    vuint32_t POPNXTPTR:4;             /* Pop Next Pointer */
  } B;
} SPI_SR_tag;

typedef union SPI_RSER_union_tag {     /* DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TCF_RE:1;                /* Transmission Complete Request Enable */
    vuint32_t CMDFFF_RE:1;             /* Command FIFO Fill Flag Request Enable. */
    vuint32_t _unused_29:1;            /* Always write the reset value to this field. */
    vuint32_t EOQF_RE:1;               /* Finished Request Enable */
    vuint32_t TFUF_RE:1;               /* Transmit FIFO Underflow Request Enable */
    vuint32_t _unused_26:1;            /* Always write the reset value to this field. */
    vuint32_t TFFF_RE:1;               /* Transmit FIFO Fill Request Enable */
    vuint32_t TFFF_DIRS:1;             /* Transmit FIFO Fill DMA or Interrupt Request Select */
    vuint32_t CMDTCF_RE:1;             /* Command Transmission Complete Request Enable. */
    vuint32_t _unused_22:1;            /* Always write the reset value to this field. */
    vuint32_t SPEF_RE:1;               /* SPI Parity Error Request Enable */
    vuint32_t _unused_20:1;            /* Always write the reset value to this field. */
    vuint32_t RFOF_RE:1;               /* Receive FIFO Overflow Request Enable */
    vuint32_t TFIWF_RE:1;              /* Transmit FIFO Invalid Write Request Enable. */
    vuint32_t RFDF_RE:1;               /* Receive FIFO Drain Request Enable */
    vuint32_t RFDF_DIRS:1;             /* Receive FIFO Drain DMA or Interrupt Request Select */
    vuint32_t CMDFFF_DIRS:1;           /* Command FIFO Fill DMA or Interrupt Request Select */
    vuint32_t DDIF_DIRS:1;             /* DSI data received with active bits - DMA or Interrupt Request Select. */
    vuint32_t _unused_0:14;
  } B;
} SPI_RSER_tag;

typedef union SPI_PUSHR_PUSHR_union_tag { /* PUSH TX FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t CONT:1;                  /* Continuous Peripheral Chip Select Enable */
    vuint32_t CTAS:3;                  /* Clock and Transfer Attributes Select */
    vuint32_t EOQ:1;                   /* End Of Queue */
    vuint32_t CTCNT:1;                 /* Clear Transfer Counter */
    vuint32_t PE_MASC:1;               /* Parity Enable or Mask T ASC delay in the current frame */
    vuint32_t PP_MCSC:1;               /* Parity Polarity or Mask T CSC delay in the next frame */
    vuint32_t _unused_22:2;            /* Always write the reset value to this field. */
    vuint32_t PCS:6;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_PUSHR_PUSHR_tag;

typedef union SPI_PUSHR_PUSHR_SLAVE_union_tag { /* PUSH TX FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_PUSHR_PUSHR_SLAVE_tag;

typedef union SPI_PUSHR_union_tag {
  SPI_PUSHR_PUSHR_tag PUSHR;           /* PUSH TX FIFO Register In Master Mode */
  SPI_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* PUSH TX FIFO Register In Slave Mode */
} SPI_PUSHR_tag;

typedef union SPI_POPR_union_tag {     /* POP RX FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Received Data */
  } B;
} SPI_POPR_tag;

typedef union SPI_TXFR_union_tag {     /* Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXCMD_TXDATA:16;         /* Transmit Command or Transmit Data */
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_TXFR_tag;

typedef union SPI_RXFR_union_tag {     /* Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Receive Data */
  } B;
} SPI_RXFR_tag;

typedef union SPI_CTARE_union_tag {    /* Clock and Transfer Attributes Register Extended */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t FMSZE:1;                 /* Frame Size Extended */
    vuint32_t _unused_11:5;
    vuint32_t DTCP:11;                 /* Data Transfer Count Preload */
  } B;
} SPI_CTARE_tag;

typedef union SPI_SREX_union_tag {     /* Status Register Extended */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t RXCTR4:1;                /* RX FIFO Counter[4] */
    vuint32_t _unused_12:2;
    vuint32_t TXCTR4:1;                /* TX FIFO Counter[4] */
    vuint32_t _unused_9:2;
    vuint32_t CMDCTR:5;                /* CMD FIFO Counter */
    vuint32_t CMDNXTPTR:4;             /* Command Next Pointer */
  } B;
} SPI_SREX_tag;

typedef union SPI_TRIG_union_tag {     /* Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;                /* Trigger Register Enable */
    vuint32_t _unused_4:27;
    vuint32_t _unused_3:1;
    vuint32_t ASDR_WT:1;               /* ASDR Write Trigger Enable */
    vuint32_t CID:1;                   /* Change In Data Transfer Enable */
    vuint32_t TRRE:1;                  /* Trigger Reception Enable */
  } B;
} SPI_TRIG_tag;

struct SPI_tag {
  SPI_MCR_tag MCR;                     /* Module Configuration Register */
  uint8_t SPI_reserved0[4];
  SPI_TCR_tag TCR;                     /* Transfer Count Register */
  SPI_MODE_tag MODE;
  uint8_t SPI_reserved1[8];
  SPI_SR_tag SR;                       /* Status Register */
  SPI_RSER_tag RSER;                   /* DMA/Interrupt Request Select and Enable Register */
  SPI_PUSHR_tag PUSHR;
  SPI_POPR_tag POPR;                   /* POP RX FIFO Register */
  SPI_TXFR_tag TXFR[4];                /* Transmit FIFO Registers */
  uint8_t SPI_reserved2[48];
  SPI_RXFR_tag RXFR[4];                /* Receive FIFO Registers */
  uint8_t SPI_reserved3[144];
  SPI_CTARE_tag CTARE[6];              /* Clock and Transfer Attributes Register Extended */
  uint8_t SPI_reserved4[8];
  SPI_SREX_tag SREX;                   /* Status Register Extended */
  SPI_TRIG_tag TRIG;                   /* Trigger Register */
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

typedef union SSCM_STATUS_union_tag {  /* SSCM System Status */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t CER:1;                   /* Configuration Error */
    vuint16_t CERS:1;                  /* Configuration Error for Safe DCF Clients */
    vuint16_t _unused_12:1;
    vuint16_t NXEN:1;                  /* Processor 0 Nexus enable status */
    vuint16_t _unused_10:1;
    vuint16_t _unused_9:1;
    vuint16_t _unused_8:1;
    vuint16_t BMODE:3;                 /* Device Boot Mode */
    vuint16_t _unused_4:1;
    vuint16_t _unused_3:1;
    vuint16_t _unused_2:1;
    vuint16_t _unused_0:2;
  } B;
} SSCM_STATUS_tag;

typedef union SSCM_MEMCONFIG_union_tag { /* SSCM System Memory and ID Register */
  vuint16_t R;
  struct {
    vuint16_t JPIN:10;
    vuint16_t _unused_5:1;
    vuint16_t MREV:4;                  /* Minor Mask Revision */
    vuint16_t _unused_0:1;
  } B;
} SSCM_MEMCONFIG_tag;

typedef union SSCM_DEBUGPORT_union_tag { /* SSCM Debug Status Port Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_9:7;
    vuint16_t _unused_8:1;
    vuint16_t _unused_3:5;
    vuint16_t DEBUG_MODE:3;
  } B;
} SSCM_DEBUGPORT_tag;

typedef union SSCM_UOPS_union_tag {    /* SSCM HSM and User Option Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t HSB:3;                   /* HSM Boot Configuration */
    vuint32_t HSE:1;                   /* HSM Enabled */
  } B;
} SSCM_UOPS_tag;

typedef union SSCM_PSA_union_tag {     /* Processor Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t SADR:32;                 /* Processor Start Address */
  } B;
} SSCM_PSA_tag;

typedef union SSCM_HSA_union_tag {     /* SSCM HSM Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t HADR:32;                 /* HSM Start Address */
  } B;
} SSCM_HSA_tag;

typedef union SSCM_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_3:5;
    vuint32_t LC:3;                    /* Life Cycle */
  } B;
} SSCM_LCSTAT_tag;

struct SSCM_tag {
  SSCM_STATUS_tag STATUS;              /* SSCM System Status */
  SSCM_MEMCONFIG_tag MEMCONFIG;        /* SSCM System Memory and ID Register */
  uint8_t SSCM_reserved0[4];
  SSCM_DEBUGPORT_tag DEBUGPORT;        /* SSCM Debug Status Port Register */
  uint8_t SSCM_reserved1[22];
  SSCM_UOPS_tag UOPS;                  /* SSCM HSM and User Option Status Register */
  uint8_t SSCM_reserved2[4];
  SSCM_PSA_tag PSA;                    /* Processor Start Address Register */
  uint8_t SSCM_reserved3[4];
  SSCM_HSA_tag HSA;                    /* SSCM HSM Start Address Register */
  SSCM_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

typedef union STCU2_RUN_union_tag {    /* STCU2 Run Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t BYP:1;
    vuint32_t MBPLLEN:1;
    vuint32_t LBPLLEN:1;
    vuint32_t _unused_1:7;
    vuint32_t RUN:1;
  } B;
} STCU2_RUN_tag;

typedef union STCU2_RUNSW_union_tag {  /* STCU2 Run Software Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t MBIE:1;
    vuint32_t LBIE:1;
    vuint32_t MBSWPLLEN:1;
    vuint32_t LBSWPLLEN:1;
    vuint32_t _unused_2:6;
    vuint32_t _unused_1:1;
    vuint32_t RUNSW:1;
  } B;
} STCU2_RUNSW_tag;

typedef union STCU2_SKC_union_tag {    /* STCU2 SK Code Register */
  vuint32_t R;
  struct {
    vuint32_t SKC:32;
  } B;
} STCU2_SKC_tag;

typedef union STCU2_CFG_union_tag {    /* STCU2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PTR:7;
    vuint32_t LB_DELAY:8;
    vuint32_t _unused_9:7;
    vuint32_t WRP:1;
    vuint32_t _unused_6:2;
    vuint32_t _unused_5:1;
    vuint32_t PMOSEN:1;
    vuint32_t MBU:1;
    vuint32_t CLK_CFG:3;
  } B;
} STCU2_CFG_tag;

typedef union STCU2_WDG_union_tag {    /* STCU2 Watchdog Register Granularity */
  vuint32_t R;
  struct {
    vuint32_t WDGEOC:32;
  } B;
} STCU2_WDG_tag;

typedef union STCU2_INT_FLG_union_tag { /* STCU2 Interrupt Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t MBIFLG:1;
    vuint32_t LBIFLG:1;
  } B;
} STCU2_INT_FLG_tag;

typedef union STCU2_ERR_STAT_union_tag { /* STCU2 Error Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t ABORTHW:1;
    vuint32_t _unused_24:1;
    vuint32_t _unused_21:3;
    vuint32_t LOCKESW:1;
    vuint32_t WDTOSW:1;
    vuint32_t _unused_18:1;
    vuint32_t ENGESW:1;
    vuint32_t INVPSW:1;
    vuint32_t _unused_10:6;
    vuint32_t UFSF:1;
    vuint32_t RFSF:1;
    vuint32_t _unused_5:3;
    vuint32_t LOCKE:1;
    vuint32_t WDTO:1;
    vuint32_t _unused_2:1;
    vuint32_t ENGE:1;
    vuint32_t INVP:1;
  } B;
} STCU2_ERR_STAT_tag;

typedef union STCU2_ERR_FM_union_tag { /* STCU2 Error FM Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t LOCKEUFM:1;
    vuint32_t WDTOUFM:1;
    vuint32_t _unused_2:1;
    vuint32_t ENGEUFM:1;
    vuint32_t INVPUFM:1;
  } B;
} STCU2_ERR_FM_tag;

typedef union STCU2_LBS_union_tag {    /* STCU2 Off-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t LBS2:1;
    vuint32_t LBS1:1;
    vuint32_t LBS0:1;
  } B;
} STCU2_LBS_tag;

typedef union STCU2_LBE_union_tag {    /* STCU2 Off-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t LBE2:1;
    vuint32_t LBE1:1;
    vuint32_t LBE0:1;
  } B;
} STCU2_LBE_tag;

typedef union STCU2_LBSSW_union_tag {  /* STCU2 On-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t LBSSW2:1;
    vuint32_t LBSSW1:1;
    vuint32_t LBSSW0:1;
  } B;
} STCU2_LBSSW_tag;

typedef union STCU2_LBESW_union_tag {  /* STCU2 On-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t LBESW2:1;
    vuint32_t LBESW1:1;
    vuint32_t LBESW0:1;
  } B;
} STCU2_LBESW_tag;

typedef union STCU2_LBUFM_union_tag {  /* STCU2 LBIST Unrecoverable FM Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t LBUFM2:1;
    vuint32_t LBUFM1:1;
    vuint32_t LBUFM0:1;
  } B;
} STCU2_LBUFM_tag;

typedef union STCU2_MBSL_union_tag {   /* STCU2 Off-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBS31:1;
    vuint32_t MBS30:1;
    vuint32_t MBS29:1;
    vuint32_t MBS28:1;
    vuint32_t MBS27:1;
    vuint32_t MBS26:1;
    vuint32_t MBS25:1;
    vuint32_t MBS24:1;
    vuint32_t MBS23:1;
    vuint32_t MBS22:1;
    vuint32_t MBS21:1;
    vuint32_t MBS20:1;
    vuint32_t MBS19:1;
    vuint32_t MBS18:1;
    vuint32_t MBS17:1;
    vuint32_t MBS16:1;
    vuint32_t MBS15:1;
    vuint32_t MBS14:1;
    vuint32_t MBS13:1;
    vuint32_t MBS12:1;
    vuint32_t MBS11:1;
    vuint32_t MBS10:1;
    vuint32_t MBS9:1;
    vuint32_t MBS8:1;
    vuint32_t MBS7:1;
    vuint32_t MBS6:1;
    vuint32_t MBS5:1;
    vuint32_t MBS4:1;
    vuint32_t MBS3:1;
    vuint32_t MBS2:1;
    vuint32_t MBS1:1;
    vuint32_t MBS0:1;
  } B;
} STCU2_MBSL_tag;

typedef union STCU2_MBSM_union_tag {   /* STCU2 Off-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBS63:1;
    vuint32_t MBS62:1;
    vuint32_t MBS61:1;
    vuint32_t MBS60:1;
    vuint32_t MBS59:1;
    vuint32_t MBS58:1;
    vuint32_t MBS57:1;
    vuint32_t MBS56:1;
    vuint32_t MBS55:1;
    vuint32_t MBS54:1;
    vuint32_t MBS53:1;
    vuint32_t MBS52:1;
    vuint32_t MBS51:1;
    vuint32_t MBS50:1;
    vuint32_t MBS49:1;
    vuint32_t MBS48:1;
    vuint32_t MBS47:1;
    vuint32_t MBS46:1;
    vuint32_t MBS45:1;
    vuint32_t MBS44:1;
    vuint32_t MBS43:1;
    vuint32_t MBS42:1;
    vuint32_t MBS41:1;
    vuint32_t MBS40:1;
    vuint32_t MBS39:1;
    vuint32_t MBS38:1;
    vuint32_t MBS37:1;
    vuint32_t MBS36:1;
    vuint32_t MBS35:1;
    vuint32_t MBS34:1;
    vuint32_t MBS33:1;
    vuint32_t MBS32:1;
  } B;
} STCU2_MBSM_tag;

typedef union STCU2_MBSH_union_tag {   /* STCU2 Off-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t MBS75:1;
    vuint32_t MBS74:1;
    vuint32_t MBS73:1;
    vuint32_t MBS72:1;
    vuint32_t MBS71:1;
    vuint32_t MBS70:1;
    vuint32_t MBS69:1;
    vuint32_t MBS68:1;
    vuint32_t MBS67:1;
    vuint32_t MBS66:1;
    vuint32_t MBS65:1;
    vuint32_t MBS64:1;
  } B;
} STCU2_MBSH_tag;

typedef union STCU2_MBEL_union_tag {   /* STCU2 Off-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBE31:1;
    vuint32_t MBE30:1;
    vuint32_t MBE29:1;
    vuint32_t MBE28:1;
    vuint32_t MBE27:1;
    vuint32_t MBE26:1;
    vuint32_t MBE25:1;
    vuint32_t MBE24:1;
    vuint32_t MBE23:1;
    vuint32_t MBE22:1;
    vuint32_t MBE21:1;
    vuint32_t MBE20:1;
    vuint32_t MBE19:1;
    vuint32_t MBE18:1;
    vuint32_t MBE17:1;
    vuint32_t MBE16:1;
    vuint32_t MBE15:1;
    vuint32_t MBE14:1;
    vuint32_t MBE13:1;
    vuint32_t MBE12:1;
    vuint32_t MBE11:1;
    vuint32_t MBE10:1;
    vuint32_t MBE9:1;
    vuint32_t MBE8:1;
    vuint32_t MBE7:1;
    vuint32_t MBE6:1;
    vuint32_t MBE5:1;
    vuint32_t MBE4:1;
    vuint32_t MBE3:1;
    vuint32_t MBE2:1;
    vuint32_t MBE1:1;
    vuint32_t MBE0:1;
  } B;
} STCU2_MBEL_tag;

typedef union STCU2_MBEM_union_tag {   /* STCU2 Off-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBE63:1;
    vuint32_t MBE62:1;
    vuint32_t MBE61:1;
    vuint32_t MBE60:1;
    vuint32_t MBE59:1;
    vuint32_t MBE58:1;
    vuint32_t MBE57:1;
    vuint32_t MBE56:1;
    vuint32_t MBE55:1;
    vuint32_t MBE54:1;
    vuint32_t MBE53:1;
    vuint32_t MBE52:1;
    vuint32_t MBE51:1;
    vuint32_t MBE50:1;
    vuint32_t MBE49:1;
    vuint32_t MBE48:1;
    vuint32_t MBE47:1;
    vuint32_t MBE46:1;
    vuint32_t MBE45:1;
    vuint32_t MBE44:1;
    vuint32_t MBE43:1;
    vuint32_t MBE42:1;
    vuint32_t MBE41:1;
    vuint32_t MBE40:1;
    vuint32_t MBE39:1;
    vuint32_t MBE38:1;
    vuint32_t MBE37:1;
    vuint32_t MBE36:1;
    vuint32_t MBE35:1;
    vuint32_t MBE34:1;
    vuint32_t MBE33:1;
    vuint32_t MBE32:1;
  } B;
} STCU2_MBEM_tag;

typedef union STCU2_MBEH_union_tag {   /* STCU2 Off-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t MBE75:1;
    vuint32_t MBE74:1;
    vuint32_t MBE73:1;
    vuint32_t MBE72:1;
    vuint32_t MBE71:1;
    vuint32_t MBE70:1;
    vuint32_t MBE69:1;
    vuint32_t MBE68:1;
    vuint32_t MBE67:1;
    vuint32_t MBE66:1;
    vuint32_t MBE65:1;
    vuint32_t MBE64:1;
  } B;
} STCU2_MBEH_tag;

typedef union STCU2_MBSLSW_union_tag { /* STCU2 On-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW31:1;
    vuint32_t MBSSW30:1;
    vuint32_t MBSSW29:1;
    vuint32_t MBSSW28:1;
    vuint32_t MBSSW27:1;
    vuint32_t MBSSW26:1;
    vuint32_t MBSSW25:1;
    vuint32_t MBSSW24:1;
    vuint32_t MBSSW23:1;
    vuint32_t MBSSW22:1;
    vuint32_t MBSSW21:1;
    vuint32_t MBSSW20:1;
    vuint32_t MBSSW19:1;
    vuint32_t MBSSW18:1;
    vuint32_t MBSSW17:1;
    vuint32_t MBSSW16:1;
    vuint32_t MBSSW15:1;
    vuint32_t MBSSW14:1;
    vuint32_t MBSSW13:1;
    vuint32_t MBSSW12:1;
    vuint32_t MBSSW11:1;
    vuint32_t MBSSW10:1;
    vuint32_t MBSSW9:1;
    vuint32_t MBSSW8:1;
    vuint32_t MBSSW7:1;
    vuint32_t MBSSW6:1;
    vuint32_t MBSSW5:1;
    vuint32_t MBSSW4:1;
    vuint32_t MBSSW3:1;
    vuint32_t MBSSW2:1;
    vuint32_t MBSSW1:1;
    vuint32_t MBSSW0:1;
  } B;
} STCU2_MBSLSW_tag;

typedef union STCU2_MBSMSW_union_tag { /* STCU2 On-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW63:1;
    vuint32_t MBSSW62:1;
    vuint32_t MBSSW61:1;
    vuint32_t MBSSW60:1;
    vuint32_t MBSSW59:1;
    vuint32_t MBSSW58:1;
    vuint32_t MBSSW57:1;
    vuint32_t MBSSW56:1;
    vuint32_t MBSSW55:1;
    vuint32_t MBSSW54:1;
    vuint32_t MBSSW53:1;
    vuint32_t MBSSW52:1;
    vuint32_t MBSSW51:1;
    vuint32_t MBSSW50:1;
    vuint32_t MBSSW49:1;
    vuint32_t MBSSW48:1;
    vuint32_t MBSSW47:1;
    vuint32_t MBSSW46:1;
    vuint32_t MBSSW45:1;
    vuint32_t MBSSW44:1;
    vuint32_t MBSSW43:1;
    vuint32_t MBSSW42:1;
    vuint32_t MBSSW41:1;
    vuint32_t MBSSW40:1;
    vuint32_t MBSSW39:1;
    vuint32_t MBSSW38:1;
    vuint32_t MBSSW37:1;
    vuint32_t MBSSW36:1;
    vuint32_t MBSSW35:1;
    vuint32_t MBSSW34:1;
    vuint32_t MBSSW33:1;
    vuint32_t MBSSW32:1;
  } B;
} STCU2_MBSMSW_tag;

typedef union STCU2_MBSHSW_union_tag { /* STCU2 On-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t MBSSW75:1;
    vuint32_t MBSSW74:1;
    vuint32_t MBSSW73:1;
    vuint32_t MBSSW72:1;
    vuint32_t MBSSW71:1;
    vuint32_t MBSSW70:1;
    vuint32_t MBSSW69:1;
    vuint32_t MBSSW68:1;
    vuint32_t MBSSW67:1;
    vuint32_t MBSSW66:1;
    vuint32_t MBSSW65:1;
    vuint32_t MBSSW64:1;
  } B;
} STCU2_MBSHSW_tag;

typedef union STCU2_MBELSW_union_tag { /* STCU2 On-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW31:1;
    vuint32_t MBESW30:1;
    vuint32_t MBESW29:1;
    vuint32_t MBESW28:1;
    vuint32_t MBESW27:1;
    vuint32_t MBESW26:1;
    vuint32_t MBESW25:1;
    vuint32_t MBESW24:1;
    vuint32_t MBESW23:1;
    vuint32_t MBESW22:1;
    vuint32_t MBESW21:1;
    vuint32_t MBESW20:1;
    vuint32_t MBESW19:1;
    vuint32_t MBESW18:1;
    vuint32_t MBESW17:1;
    vuint32_t MBESW16:1;
    vuint32_t MBESW15:1;
    vuint32_t MBESW14:1;
    vuint32_t MBESW13:1;
    vuint32_t MBESW12:1;
    vuint32_t MBESW11:1;
    vuint32_t MBESW10:1;
    vuint32_t MBESW9:1;
    vuint32_t MBESW8:1;
    vuint32_t MBESW7:1;
    vuint32_t MBESW6:1;
    vuint32_t MBESW5:1;
    vuint32_t MBESW4:1;
    vuint32_t MBESW3:1;
    vuint32_t MBESW2:1;
    vuint32_t MBESW1:1;
    vuint32_t MBESW0:1;
  } B;
} STCU2_MBELSW_tag;

typedef union STCU2_MBEMSW_union_tag { /* STCU2 On-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW63:1;
    vuint32_t MBESW62:1;
    vuint32_t MBESW61:1;
    vuint32_t MBESW60:1;
    vuint32_t MBESW59:1;
    vuint32_t MBESW58:1;
    vuint32_t MBESW57:1;
    vuint32_t MBESW56:1;
    vuint32_t MBESW55:1;
    vuint32_t MBESW54:1;
    vuint32_t MBESW53:1;
    vuint32_t MBESW52:1;
    vuint32_t MBESW51:1;
    vuint32_t MBESW50:1;
    vuint32_t MBESW49:1;
    vuint32_t MBESW48:1;
    vuint32_t MBESW47:1;
    vuint32_t MBESW46:1;
    vuint32_t MBESW45:1;
    vuint32_t MBESW44:1;
    vuint32_t MBESW43:1;
    vuint32_t MBESW42:1;
    vuint32_t MBESW41:1;
    vuint32_t MBESW40:1;
    vuint32_t MBESW39:1;
    vuint32_t MBESW38:1;
    vuint32_t MBESW37:1;
    vuint32_t MBESW36:1;
    vuint32_t MBESW35:1;
    vuint32_t MBESW34:1;
    vuint32_t MBESW33:1;
    vuint32_t MBESW32:1;
  } B;
} STCU2_MBEMSW_tag;

typedef union STCU2_MBEHSW_union_tag { /* STCU2 On-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t MBESW75:1;
    vuint32_t MBESW74:1;
    vuint32_t MBESW73:1;
    vuint32_t MBESW72:1;
    vuint32_t MBESW71:1;
    vuint32_t MBESW70:1;
    vuint32_t MBESW69:1;
    vuint32_t MBESW68:1;
    vuint32_t MBESW67:1;
    vuint32_t MBESW66:1;
    vuint32_t MBESW65:1;
    vuint32_t MBESW64:1;
  } B;
} STCU2_MBEHSW_tag;

typedef union STCU2_MBUFML_union_tag { /* STCU2 MBIST Unrecoverable FM Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM31:1;
    vuint32_t MBUFM30:1;
    vuint32_t MBUFM29:1;
    vuint32_t MBUFM28:1;
    vuint32_t MBUFM27:1;
    vuint32_t MBUFM26:1;
    vuint32_t MBUFM25:1;
    vuint32_t MBUFM24:1;
    vuint32_t MBUFM23:1;
    vuint32_t MBUFM22:1;
    vuint32_t MBUFM21:1;
    vuint32_t MBUFM20:1;
    vuint32_t MBUFM19:1;
    vuint32_t MBUFM18:1;
    vuint32_t MBUFM17:1;
    vuint32_t MBUFM16:1;
    vuint32_t MBUFM15:1;
    vuint32_t MBUFM14:1;
    vuint32_t MBUFM13:1;
    vuint32_t MBUFM12:1;
    vuint32_t MBUFM11:1;
    vuint32_t MBUFM10:1;
    vuint32_t MBUFM9:1;
    vuint32_t MBUFM8:1;
    vuint32_t MBUFM7:1;
    vuint32_t MBUFM6:1;
    vuint32_t MBUFM5:1;
    vuint32_t MBUFM4:1;
    vuint32_t MBUFM3:1;
    vuint32_t MBUFM2:1;
    vuint32_t MBUFM1:1;
    vuint32_t MBUFM0:1;
  } B;
} STCU2_MBUFML_tag;

typedef union STCU2_MBUFMM_union_tag { /* STCU2 MBIST Unrecoverable FM Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM63:1;
    vuint32_t MBUFM62:1;
    vuint32_t MBUFM61:1;
    vuint32_t MBUFM60:1;
    vuint32_t MBUFM59:1;
    vuint32_t MBUFM58:1;
    vuint32_t MBUFM57:1;
    vuint32_t MBUFM56:1;
    vuint32_t MBUFM55:1;
    vuint32_t MBUFM54:1;
    vuint32_t MBUFM53:1;
    vuint32_t MBUFM52:1;
    vuint32_t MBUFM51:1;
    vuint32_t MBUFM50:1;
    vuint32_t MBUFM49:1;
    vuint32_t MBUFM48:1;
    vuint32_t MBUFM47:1;
    vuint32_t MBUFM46:1;
    vuint32_t MBUFM45:1;
    vuint32_t MBUFM44:1;
    vuint32_t MBUFM43:1;
    vuint32_t MBUFM42:1;
    vuint32_t MBUFM41:1;
    vuint32_t MBUFM40:1;
    vuint32_t MBUFM39:1;
    vuint32_t MBUFM38:1;
    vuint32_t MBUFM37:1;
    vuint32_t MBUFM36:1;
    vuint32_t MBUFM35:1;
    vuint32_t MBUFM34:1;
    vuint32_t MBUFM33:1;
    vuint32_t MBUFM32:1;
  } B;
} STCU2_MBUFMM_tag;

typedef union STCU2_MBUFMH_union_tag { /* STCU2 MBIST Unrecoverable FM High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t MBUFM75:1;
    vuint32_t MBUFM74:1;
    vuint32_t MBUFM73:1;
    vuint32_t MBUFM72:1;
    vuint32_t MBUFM71:1;
    vuint32_t MBUFM70:1;
    vuint32_t MBUFM69:1;
    vuint32_t MBUFM68:1;
    vuint32_t MBUFM67:1;
    vuint32_t MBUFM66:1;
    vuint32_t MBUFM65:1;
    vuint32_t MBUFM64:1;
  } B;
} STCU2_MBUFMH_tag;

typedef union STCU2_LB_CTRL_union_tag { /* STCU2 LBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t _unused_20:4;
    vuint32_t PRPGEN:1;
    vuint32_t SHS:3;
    vuint32_t SCEN_OFF:4;
    vuint32_t SCEN_ON:4;
    vuint32_t _unused_4:4;
    vuint32_t PFT:1;
    vuint32_t CWS:3;
  } B;
} STCU2_LB_CTRL_tag;

typedef union STCU2_LB_PCS_union_tag { /* STCU2 LBIST PC Stop Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t PCS:26;
  } B;
} STCU2_LB_PCS_tag;

typedef union STCU2_LB_PRPGL_union_tag { /* STCU2 LBIST PRPG Low Register */
  vuint32_t R;
  struct {
    vuint32_t PRPGx:32;
  } B;
} STCU2_LB_PRPGL_tag;

typedef union STCU2_LB_PRPGH_union_tag { /* STCU2 LBIST PRPG High Register */
  vuint32_t R;
  struct {
    vuint32_t PRPGx:32;
  } B;
} STCU2_LB_PRPGH_tag;

typedef union STCU2_LB_MISREL_union_tag { /* STCU2 Off-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_MISREL_tag;

typedef union STCU2_LB_MISREH_union_tag { /* STCU2 Off-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_MISREH_tag;

typedef union STCU2_LB_MISRRL_union_tag { /* STCU2 Off-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_MISRRL_tag;

typedef union STCU2_LB_MISRRH_union_tag { /* STCU2 Off-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_MISRRH_tag;

typedef union STCU2_LB_MISRELSW_union_tag { /* STCU2 On-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_MISRELSW_tag;

typedef union STCU2_LB_MISREHSW_union_tag { /* STCU2 On-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_MISREHSW_tag;

typedef union STCU2_LB_MISRRLSW_union_tag { /* STCU2 On-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_MISRRLSW_tag;

typedef union STCU2_LB_MISRRHSW_union_tag { /* STCU2 On-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_MISRRHSW_tag;

typedef struct STCU2_LB_struct_tag {
  STCU2_LB_CTRL_tag CTRL;              /* STCU2 LBIST Control Register */
  STCU2_LB_PCS_tag PCS;                /* STCU2 LBIST PC Stop Register */
  STCU2_LB_PRPGL_tag PRPGL;            /* STCU2 LBIST PRPG Low Register */
  STCU2_LB_PRPGH_tag PRPGH;            /* STCU2 LBIST PRPG High Register */
  STCU2_LB_MISREL_tag MISREL;          /* STCU2 Off-Line LBIST MISR Expected Low Register */
  STCU2_LB_MISREH_tag MISREH;          /* STCU2 Off-Line LBIST MISR Expected High Register */
  STCU2_LB_MISRRL_tag MISRRL;          /* STCU2 Off-Line LBIST MISR Read Low Register */
  STCU2_LB_MISRRH_tag MISRRH;          /* STCU2 Off-Line LBIST MISR Read High Register */
  STCU2_LB_MISRELSW_tag MISRELSW;      /* STCU2 On-Line LBIST MISR Expected Low Register */
  STCU2_LB_MISREHSW_tag MISREHSW;      /* STCU2 On-Line LBIST MISR Expected High Register */
  STCU2_LB_MISRRLSW_tag MISRRLSW;      /* STCU2 On-Line LBIST MISR Read Low Register */
  STCU2_LB_MISRRHSW_tag MISRRHSW;      /* STCU2 On-Line LBIST MISR Read High Register */
  uint8_t LB_reserved0[16];
} STCU2_LB_tag;

typedef union STCU2_MB_CTRL_union_tag { /* STCU2 MBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t _unused_0:24;
  } B;
} STCU2_MB_CTRL_tag;

struct STCU2_tag {
  STCU2_RUN_tag RUN;                   /* STCU2 Run Register */
  STCU2_RUNSW_tag RUNSW;               /* STCU2 Run Software Register */
  STCU2_SKC_tag SKC;                   /* STCU2 SK Code Register */
  STCU2_CFG_tag CFG;                   /* STCU2 Configuration Register */
  uint8_t STCU2_reserved0[4];
  STCU2_WDG_tag WDG;                   /* STCU2 Watchdog Register Granularity */
  STCU2_INT_FLG_tag INT_FLG;           /* STCU2 Interrupt Flag Register */
  uint8_t STCU2_reserved1[8];
  STCU2_ERR_STAT_tag ERR_STAT;         /* STCU2 Error Register */
  STCU2_ERR_FM_tag ERR_FM;             /* STCU2 Error FM Register */
  STCU2_LBS_tag LBS;                   /* STCU2 Off-Line LBIST Status Register */
  STCU2_LBE_tag LBE;                   /* STCU2 Off-Line LBIST End Flag Register */
  STCU2_LBSSW_tag LBSSW;               /* STCU2 On-Line LBIST Status Register */
  STCU2_LBESW_tag LBESW;               /* STCU2 On-Line LBIST End Flag Register */
  uint8_t STCU2_reserved2[4];
  STCU2_LBUFM_tag LBUFM;               /* STCU2 LBIST Unrecoverable FM Register */
  STCU2_MBSL_tag MBSL;                 /* STCU2 Off-Line MBIST Status Low Register */
  STCU2_MBSM_tag MBSM;                 /* STCU2 Off-Line MBIST Status Medium Register */
  STCU2_MBSH_tag MBSH;                 /* STCU2 Off-Line MBIST Status High Register */
  STCU2_MBEL_tag MBEL;                 /* STCU2 Off-Line MBIST End Flag Low Register */
  STCU2_MBEM_tag MBEM;                 /* STCU2 Off-Line MBIST End Flag Medium Register */
  STCU2_MBEH_tag MBEH;                 /* STCU2 Off-Line MBIST End Flag High Register */
  STCU2_MBSLSW_tag MBSLSW;             /* STCU2 On-Line MBIST Status Low Register */
  STCU2_MBSMSW_tag MBSMSW;             /* STCU2 On-Line MBIST Status Medium Register */
  STCU2_MBSHSW_tag MBSHSW;             /* STCU2 On-Line MBIST Status High Register */
  STCU2_MBELSW_tag MBELSW;             /* STCU2 On-Line MBIST End Flag Low Register */
  STCU2_MBEMSW_tag MBEMSW;             /* STCU2 On-Line MBIST End Flag Medium Register */
  STCU2_MBEHSW_tag MBEHSW;             /* STCU2 On-Line MBIST End Flag High Register */
  STCU2_MBUFML_tag MBUFML;             /* STCU2 MBIST Unrecoverable FM Low Register */
  STCU2_MBUFMM_tag MBUFMM;             /* STCU2 MBIST Unrecoverable FM Medium Register */
  STCU2_MBUFMH_tag MBUFMH;             /* STCU2 MBIST Unrecoverable FM High Register */
  uint8_t STCU2_reserved3[128];
  STCU2_LB_tag LB[3];
  uint8_t STCU2_reserved4[1088];
  STCU2_MB_CTRL_tag MB_CTRL[76];       /* STCU2 MBIST Control Register */
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

typedef union STM_CR_union_tag {       /* STM Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CPS:8;                   /* Counter Prescaler. */
    vuint32_t _unused_2:6;
    vuint32_t FRZ:1;                   /* Freeze. */
    vuint32_t TEN:1;                   /* Timer counter Enabled. */
  } B;
} STM_CR_tag;

typedef union STM_CNT_union_tag {      /* STM Count Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Timer count value used as the time base for all channels. */
  } B;
} STM_CNT_tag;

typedef union STM_CHANNEL_CCR_union_tag { /* STM Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t CEN:1;                   /* Channel Enable */
  } B;
} STM_CHANNEL_CCR_tag;

typedef union STM_CHANNEL_CIR_union_tag { /* STM Channel Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t CIF:1;                   /* Channel Interrupt Flag */
  } B;
} STM_CHANNEL_CIR_tag;

typedef union STM_CHANNEL_CMP_union_tag { /* STM Channel Compare Register */
  vuint32_t R;
  struct {
    vuint32_t CMP:32;                  /* Compare value for channel n. */
  } B;
} STM_CHANNEL_CMP_tag;

typedef struct STM_CHANNEL_struct_tag {
  STM_CHANNEL_CCR_tag CCR;             /* STM Channel Control Register */
  STM_CHANNEL_CIR_tag CIR;             /* STM Channel Interrupt Register */
  STM_CHANNEL_CMP_tag CMP;             /* STM Channel Compare Register */
  uint8_t CHANNEL_reserved0[4];
} STM_CHANNEL_tag;

struct STM_tag {
  STM_CR_tag CR;                       /* STM Control Register */
  STM_CNT_tag CNT;                     /* STM Count Register */
  uint8_t STM_reserved0[8];
  STM_CHANNEL_tag CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

typedef union SWT_CR_union_tag {       /* SWT Control Register */
  vuint32_t R;
  struct {
    vuint32_t MAP0:1;
    vuint32_t MAP1:1;
    vuint32_t MAP2:1;
    vuint32_t MAP3:1;
    vuint32_t MAP4:1;
    vuint32_t MAP5:1;
    vuint32_t MAP6:1;
    vuint32_t MAP7:1;
    vuint32_t _unused_11:13;
    vuint32_t SMD:2;                   /* Service Mode. */
    vuint32_t RIA:1;
    vuint32_t WND:1;
    vuint32_t ITR:1;                   /* Interrupt Then Reset */
    vuint32_t HLK:1;
    vuint32_t SLK:1;
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t STP:1;
    vuint32_t FRZ:1;
    vuint32_t WEN:1;
  } B;
} SWT_CR_tag;

typedef union SWT_IR_union_tag {       /* SWT Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t TIF:1;                   /* Time-out Interrupt Flag */
  } B;
} SWT_IR_tag;

typedef union SWT_TO_union_tag {       /* SWT Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t WTO:32;
  } B;
} SWT_TO_tag;

typedef union SWT_WN_union_tag {       /* SWT Window Register */
  vuint32_t R;
  struct {
    vuint32_t WST:32;                  /* Window Start Value */
  } B;
} SWT_WN_tag;

typedef union SWT_SR_union_tag {       /* SWT Service Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t WSC:16;                  /* Watchdog Service Code */
  } B;
} SWT_SR_tag;

typedef union SWT_CO_union_tag {       /* SWT Counter Output Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;
  } B;
} SWT_CO_tag;

typedef union SWT_SK_union_tag {       /* SWT Service Key Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SK:16;                   /* Service Key */
  } B;
} SWT_SK_tag;

struct SWT_tag {
  SWT_CR_tag CR;                       /* SWT Control Register */
  SWT_IR_tag IR;                       /* SWT Interrupt Register */
  SWT_TO_tag TO;                       /* SWT Time-out Register */
  SWT_WN_tag WN;                       /* SWT Window Register */
  SWT_SR_tag SR;                       /* SWT Service Register */
  SWT_CO_tag CO;                       /* SWT Counter Output Register */
  SWT_SK_tag SK;                       /* SWT Service Key Register */
};


/* ============================================================================
   =============================== Module: SXOSC ==============================
   ============================================================================ */

typedef union SXOSC_CTL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t OSCBYP:1;                /* Oscillator start-up delay bypass */
    vuint32_t ALC:1;                   /* Auto Level Control */
    vuint32_t _unused_24:6;
    vuint32_t EOCV:8;                  /* End of Counter Value */
    vuint32_t M_OSC:1;                 /* SXOSC clock interrupt mask */
    vuint32_t _unused_13:2;
    vuint32_t OSCDIV:5;                /* The SXOSC Divider bits select the clock divider factor. */
    vuint32_t I_OSC:1;                 /* SXOSC clock interrupt */
    vuint32_t _unused_0:7;
  } B;
} SXOSC_CTL_tag;

struct SXOSC_tag {
  SXOSC_CTL_tag CTL;
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

typedef union TDM_TDRSR_union_tag {    /* TDR Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t TDRSR5:1;
    vuint32_t TDRSR4:1;
    vuint32_t TDRSR3:1;
    vuint32_t TDRSR2:1;
    vuint32_t TDRSR1:1;
    vuint32_t TDRSR0:1;
  } B;
} TDM_TDRSR_tag;

typedef union TDM_LFPAR_union_tag {    /* Last Flash Programmed Address Register */
  vuint32_t R;
  struct {
    vuint32_t LFPAR:32;
  } B;
} TDM_LFPAR_tag;

typedef union TDM_DBA_union_tag {      /* Diary Base Address */
  vuint32_t R;
  struct {
    vuint32_t DBA:32;
  } B;
} TDM_DBA_tag;

typedef union TDM_STO_KEY_union_tag {  /* Software Tamper Override Key Region */
  vuint32_t R;
  struct {
    vuint32_t STO_KEY:32;
  } B;
} TDM_STO_KEY_tag;

struct TDM_tag {
  TDM_TDRSR_tag TDRSR;                 /* TDR Status Register */
  TDM_LFPAR_tag LFPAR;                 /* Last Flash Programmed Address Register */
  TDM_DBA_tag DBA;                     /* Diary Base Address */
  uint8_t TDM_reserved0[4];
  TDM_STO_KEY_tag STO_KEY[6];          /* Software Tamper Override Key Region */
};


/* ============================================================================
   =============================== Module: UHST ===============================
   ============================================================================ */

typedef union UHST_ID_union_tag {      /* Identification Register */
  vuint32_t R;
  struct {
    vuint32_t VERSIONID:3;             /* Version ID */
    vuint32_t VERSION:4;               /* Version */
    vuint32_t REVISION:4;              /* Revision */
    vuint32_t TAG:5;                   /* Tag */
    vuint32_t _unused_14:2;            /* Reserved */
    vuint32_t NID:6;
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t ID:6;                    /* Configuration number */
  } B;
} UHST_ID_tag;

typedef union UHST_GNLHW_union_tag {   /* General Hardware Parameters Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;           /* Reserved */
    vuint32_t SM:2;                    /* Serial mode */
    vuint32_t PHYM:4;                  /* PHY Mode */
    vuint32_t PHYW:2;                  /* PHY Width */
    vuint32_t _unused_3:1;
    vuint32_t CLKC:2;                  /* VUSB_HS_CLOCK_CONFIGURATION. */
    vuint32_t RT:1;                    /* VUSB_HS_RESET_TYPE. */
  } B;
} UHST_GNLHW_tag;

typedef union UHST_HSTHWP_union_tag {  /* Host Hardware Parameters Register */
  vuint32_t R;
  struct {
    vuint32_t TTPER:8;                 /* Transaction translator periodic contexts. */
    vuint32_t TTASY:8;                 /* Transaction translator contexts. */
    vuint32_t _unused_4:12;            /* Reserved */
    vuint32_t NPORT:3;                 /* Number of Ports */
    vuint32_t HC:1;                    /* Host Capable */
  } B;
} UHST_HSTHWP_tag;

typedef union UHST_TXBFP_union_tag {   /* Transmit Buffer Hardware Parameters Register */
  vuint32_t R;
  struct {
    vuint32_t TXLC:1;                  /* Transmit local Context Registers */
    vuint32_t _unused_24:7;            /* Reserved */
    vuint32_t TXCHANADD:8;             /* Transmit Channel Address */
    vuint32_t TXADD:8;                 /* Transmit Address. */
    vuint32_t TXBURST:8;               /* Transmit Burst. */
  } B;
} UHST_TXBFP_tag;

typedef union UHST_RXBFP_union_tag {   /* Receive Buffer Hardware Parameters Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;           /* Reserved */
    vuint32_t RXADD:8;                 /* Receive Address. */
    vuint32_t RXBURST:8;               /* Receive Burst. */
  } B;
} UHST_RXBFP_tag;

typedef union UHST_GPT_LD_union_tag {  /* General Purpose Timer n Load Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;            /* Reserved */
    vuint32_t GPTLD:24;
  } B;
} UHST_GPT_LD_tag;

typedef union UHST_GPT_CTL_union_tag { /* General Purpose Timer n Control Register */
  vuint32_t R;
  struct {
    vuint32_t GPTRUN:1;                /* Timer Run */
    vuint32_t GPTRST:1;                /* Timer Reset */
    vuint32_t _unused_25:5;            /* Reserved */
    vuint32_t GPTMODE:1;               /* Timer Mode */
    vuint32_t GPTCNT:24;               /* Timer Count */
  } B;
} UHST_GPT_CTL_tag;

typedef struct UHST_GPT_struct_tag {
  UHST_GPT_LD_tag LD;                  /* General Purpose Timer n Load Register */
  UHST_GPT_CTL_tag CTL;                /* General Purpose Timer n Control Register */
} UHST_GPT_tag;

typedef union UHST_SBUSCFG_union_tag { /* System Bus Interface Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;            /* Reserved */
    vuint32_t BAWR:3;                  /* AMBA Burst Alignment for Writes. Set by parameter VUSB_HS_AHBBRST_ALIGN_WR. */
    vuint32_t BARD:3;                  /* AMBA Burst Alignment for Reads. */
    vuint32_t AHBBRST:3;               /* AMBA AHB burst configuration. */
  } B;
} UHST_SBUSCFG_tag;

typedef union UHST_CAPLENGTH_union_tag { /* Capability Register Length */
  vuint8_t R;
  struct {
    vuint8_t CAPLENGTH:8;              /* This register is used to indicate which offset to add to the register base address at the beginning of the Operational Register. */
  } B;
} UHST_CAPLENGTH_tag;

typedef union UHST_HCIVERSION_union_tag { /* Host Controller Interface Version and Capability Registers Length Register */
  vuint16_t R;
  struct {
    vuint16_t HCIVERSION:16;           /* EHCI revision number */
  } B;
} UHST_HCIVERSION_tag;

typedef union UHST_HCSPARAMS_union_tag { /* Host Controller Structural Parameters Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;            /* Reserved */
    vuint32_t N_TT:4;                  /* Number of Transaction Translators. */
    vuint32_t N_PTT:4;                 /* Ports per Transaction Translator */
    vuint32_t _unused_17:3;            /* Reserved */
    vuint32_t PI:1;                    /* Port Indicators */
    vuint32_t N_CC:4;                  /* Number of Companion Controllers */
    vuint32_t N_PCC:4;                 /* Number Ports per CC */
    vuint32_t _unused_5:3;             /* Reserved */
    vuint32_t PPCA:1;                  /* Power Port Control */
    vuint32_t N_PORTS:4;               /* Number of Ports */
  } B;
} UHST_HCSPARAMS_tag;

typedef union UHST_HCCPARAMS_union_tag { /* Host Controller Capability Parameters Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;           /* Reserved */
    vuint32_t EECP:8;                  /* EHCI Extended Capabilities Pointer */
    vuint32_t IST:4;                   /* Isochronous Scheduling Threshold */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t ASP:1;                   /* Asynchronous Schedule Park capability */
    vuint32_t PFL:1;                   /* Programmable Frame List flag */
    vuint32_t ADC:1;                   /* 64-bit addressing capability. */
  } B;
} UHST_HCCPARAMS_tag;

typedef union UHST_USBCMD_union_tag {  /* USB Command Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;            /* Reserved */
    vuint32_t ITC:8;                   /* Interrupt Threshold Control */
    vuint32_t FS1:1;                   /* Frame list Size 1 */
    vuint32_t ATDTW:1;                 /* Add dTD TripWire */
    vuint32_t SUTW:1;                  /* Setup TripWire */
    vuint32_t _unused_12:1;            /* Reserved */
    vuint32_t ASPE:1;                  /* Asynchronous Schedule Park mode Enable */
    vuint32_t _unused_10:1;            /* Reserved */
    vuint32_t ASP:2;                   /* Asynchronous Schedule Park mode count */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t IAA:1;                   /* Interrupt on Async Advance doorbell */
    vuint32_t ASE:1;                   /* Asynchronous Schedule Enable */
    vuint32_t PSE:1;                   /* Periodic Schedule Enable */
    vuint32_t FS0:2;                   /* Frame list Size 0 */
    vuint32_t RST:1;                   /* Controller Reset */
    vuint32_t RS:1;                    /* Run/Stop */
  } B;
} UHST_USBCMD_tag;

typedef union UHST_USBSTS_union_tag {  /* USB Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;            /* Reserved */
    vuint32_t TI1:1;                   /* General purpose Timer 1 Interrupt */
    vuint32_t TI0:1;                   /* General purpose Timer 0 Interrupt */
    vuint32_t _unused_20:4;            /* Reserved */
    vuint32_t UPI:1;                   /* USB host Periodic Interrupt */
    vuint32_t UAI:1;                   /* USB host Asynchronous Interrupt */
    vuint32_t _unused_17:1;            /* Reserved */
    vuint32_t NAKI:1;                  /* NAK Interrupt */
    vuint32_t AS:1;                    /* Asynchronous schedule Status */
    vuint32_t PS:1;                    /* Periodic schedule Status */
    vuint32_t RCL:1;                   /* Reclamation */
    vuint32_t HCH:1;                   /* Host Controller Halted */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t ULPII:1;                 /* ULPI Interrupt */
    vuint32_t _unused_9:1;             /* Reserved */
    vuint32_t SLI:1;                   /* Device-controller suspend */
    vuint32_t SRI:1;                   /* SOF Received */
    vuint32_t _unused_6:1;
    vuint32_t AAI:1;                   /* Interrupt on Async Advance */
    vuint32_t SEI:1;                   /* System Error */
    vuint32_t FRI:1;                   /* Frame-list Rollover */
    vuint32_t PCI:1;                   /* Port Change detect */
    vuint32_t UEI:1;                   /* USB Error Interrupt */
    vuint32_t UI:1;                    /* USB Interrupt (USBINT) */
  } B;
} UHST_USBSTS_tag;

typedef union UHST_USBINTR_union_tag { /* USB Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;            /* Reserved */
    vuint32_t TIE1:1;                  /* General purpose Timer 1 Interrupt Enable */
    vuint32_t TIE0:1;                  /* General purpose Timer 0 Interrupt Enable */
    vuint32_t _unused_20:4;            /* Reserved */
    vuint32_t UPIE:1;                  /* USB host Periodic Interrupt Enable */
    vuint32_t UAIE:1;                  /* USB host Asynchronous Interrupt Enable */
    vuint32_t _unused_17:1;            /* Reserved */
    vuint32_t NAKE:1;                  /* NAK Interrupt Enable */
    vuint32_t _unused_12:4;            /* Reserved */
    vuint32_t UALTIE:1;                /* ULPI alt_int Interrupt Enable. */
    vuint32_t ULPIE:1;                 /* ULPI Enable */
    vuint32_t _unused_9:1;             /* Reserved */
    vuint32_t _unused_8:1;
    vuint32_t SRE:1;                   /* SOF-Received Enable */
    vuint32_t _unused_6:1;
    vuint32_t AAE:1;                   /* Interrupt on Async advance Enable */
    vuint32_t SEE:1;                   /* System Error Enable */
    vuint32_t FRE:1;                   /* Frame list Rollover Enable */
    vuint32_t PCE:1;                   /* Port Change detect Enable */
    vuint32_t UEE:1;                   /* USB Error interrupt Enable */
    vuint32_t UE:1;                    /* USB interrupt Enable */
  } B;
} UHST_USBINTR_tag;

typedef union UHST_FRINDEX_union_tag { /* Frame Index Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;           /* Reserved */
    vuint32_t FRINDEX:14;              /* Frame Index */
  } B;
} UHST_FRINDEX_tag;

typedef union UHST_PERIODICLISTBASE_union_tag { /* Periodic Frame List Base Address Register */
  vuint32_t R;
  struct {
    vuint32_t BASEADR:20;              /* Base address */
    vuint32_t _unused_0:12;            /* Reserved */
  } B;
} UHST_PERIODICLISTBASE_tag;

typedef union UHST_ASYNCLISTADDR_union_tag { /* Current Asynchronous List Address Register */
  vuint32_t R;
  struct {
    vuint32_t ASYBASE:27;              /* Link pointer low (LPL) */
    vuint32_t _unused_0:5;             /* Reserved */
  } B;
} UHST_ASYNCLISTADDR_tag;

typedef union UHST_BRSTSIZE_union_tag { /* Master Interface Data Burst Size Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;           /* Reserved */
    vuint32_t TXPBURST:8;              /* Programable TX Burst length */
    vuint32_t RXPBURST:8;              /* Programable RX Burst length */
  } B;
} UHST_BRSTSIZE_tag;

typedef union UHST_TXTFLTNG_union_tag { /* Transmit FIFO Tuning Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;           /* Reserved */
    vuint32_t TXFIFOTHRES:6;           /* FIFO burst Threshold */
    vuint32_t _unused_13:3;            /* Reserved */
    vuint32_t TXSCHHEALTH:5;           /* Scheduler Health counter */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t TXSCHOH:7;               /* Scheduler Overhead */
  } B;
} UHST_TXTFLTNG_tag;

typedef union UHST_ULPIVWPT_union_tag { /* ULPI Register Access */
  vuint32_t R;
  struct {
    vuint32_t ULPI_WU:1;               /* ULPI Wake-Up */
    vuint32_t ULPI_RUN:1;              /* ULPI Run */
    vuint32_t ULPI_RW:1;               /* ULPI Read/Write */
    vuint32_t _unused_28:1;            /* Reserved */
    vuint32_t ULPI_SS:1;               /* ULPI Sync State */
    vuint32_t ULPI_PORT:3;             /* ULPI Port number */
    vuint32_t ULPI_ADDR:8;             /* ULPI data Address */
    vuint32_t ULPI_DATRD:8;            /* ULPI Data Read */
    vuint32_t ULPI_DATWR:8;            /* ULPI Data Write */
  } B;
} UHST_ULPIVWPT_tag;

typedef union UHST_CONFIGFLAG_union_tag { /* Configure Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;            /* Reserved */
    vuint32_t _unused_0:1;             /* Reserved */
  } B;
} UHST_CONFIGFLAG_tag;

typedef union UHST_PORTSC1_union_tag { /* Port Status and Control Registers */
  vuint32_t R;
  struct {
    vuint32_t PTS:2;                   /* Port Transceiver Select */
    vuint32_t _unused_29:1;            /* Reserved */
    vuint32_t _unused_28:1;            /* Reserved */
    vuint32_t PSPD:2;                  /* Port Speed */
    vuint32_t _unused_25:1;            /* Reserved */
    vuint32_t PFSC:1;                  /* Port force Full-Speed Connect */
    vuint32_t PHCD:1;                  /* PHY low power suspend */
    vuint32_t WKOC:1;                  /* Wake on Over-Current enable */
    vuint32_t WKDS:1;                  /* Wake on Disconnect enable */
    vuint32_t WKCN:1;                  /* Wake on Connect enable */
    vuint32_t PTC:4;                   /* Port Test Control */
    vuint32_t PIC:2;                   /* Port Indicator Control */
    vuint32_t PO:1;                    /* Port Owner */
    vuint32_t PP:1;                    /* Port Power */
    vuint32_t LS:2;                    /* Line Status */
    vuint32_t HSP:1;                   /* High Speed Port. */
    vuint32_t PR:1;                    /* Port Reset */
    vuint32_t SUSP:1;                  /* Suspend */
    vuint32_t FPR:1;                   /* Force Port Resume */
    vuint32_t OCC:1;                   /* Over-Current Change */
    vuint32_t OCA:1;                   /* Over-current active */
    vuint32_t PEC:1;                   /* Port Enable/disable Change */
    vuint32_t PE:1;                    /* Port Enabled/disabled */
    vuint32_t CSC:1;                   /* Connect Change Status */
    vuint32_t CCS:1;                   /* Current Connect Status */
  } B;
} UHST_PORTSC1_tag;

typedef union UHST_USBMODE_union_tag { /* USB Mode Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;            /* Reserved */
    vuint32_t ALP:8;                   /* Auto Low Power. */
    vuint32_t SRT:1;                   /* Shorten Reset Time. */
    vuint32_t TXHSD:3;                 /* Tx to Tx HS Delay */
    vuint32_t _unused_5:7;             /* Reserved */
    vuint32_t SDIS:1;                  /* Stream DISable */
    vuint32_t _unused_3:1;
    vuint32_t ES:1;                    /* Endian Select */
    vuint32_t CM:2;                    /* Controller Mode */
  } B;
} UHST_USBMODE_tag;

struct UHST_tag {
  UHST_ID_tag ID;                      /* Identification Register */
  UHST_GNLHW_tag GNLHW;                /* General Hardware Parameters Register */
  UHST_HSTHWP_tag HSTHWP;              /* Host Hardware Parameters Register */
  uint8_t UHST_reserved0[4];
  UHST_TXBFP_tag TXBFP;                /* Transmit Buffer Hardware Parameters Register */
  UHST_RXBFP_tag RXBFP;                /* Receive Buffer Hardware Parameters Register */
  uint8_t UHST_reserved1[104];
  UHST_GPT_tag GPT[2];
  UHST_SBUSCFG_tag SBUSCFG;            /* System Bus Interface Configuration Register */
  uint8_t UHST_reserved2[108];
  UHST_CAPLENGTH_tag CAPLENGTH;        /* Capability Register Length */
  uint8_t UHST_reserved3[1];
  UHST_HCIVERSION_tag HCIVERSION;      /* Host Controller Interface Version and Capability Registers Length Register */
  UHST_HCSPARAMS_tag HCSPARAMS;        /* Host Controller Structural Parameters Register */
  UHST_HCCPARAMS_tag HCCPARAMS;        /* Host Controller Capability Parameters Register */
  uint8_t UHST_reserved4[52];
  UHST_USBCMD_tag USBCMD;              /* USB Command Register */
  UHST_USBSTS_tag USBSTS;              /* USB Status Register */
  UHST_USBINTR_tag USBINTR;            /* USB Interrupt Enable Register */
  UHST_FRINDEX_tag FRINDEX;            /* Frame Index Register */
  uint8_t UHST_reserved5[4];
  UHST_PERIODICLISTBASE_tag PERIODICLISTBASE; /* Periodic Frame List Base Address Register */
  UHST_ASYNCLISTADDR_tag ASYNCLISTADDR; /* Current Asynchronous List Address Register */
  uint8_t UHST_reserved6[4];
  UHST_BRSTSIZE_tag BRSTSIZE;          /* Master Interface Data Burst Size Register */
  UHST_TXTFLTNG_tag TXTFLTNG;          /* Transmit FIFO Tuning Control Register */
  uint8_t UHST_reserved7[8];
  UHST_ULPIVWPT_tag ULPIVWPT;          /* ULPI Register Access */
  uint8_t UHST_reserved8[12];
  UHST_CONFIGFLAG_tag CONFIGFLAG;      /* Configure Flag Register */
  UHST_PORTSC1_tag PORTSC1;            /* Port Status and Control Registers */
  uint8_t UHST_reserved9[32];
  UHST_USBMODE_tag USBMODE;            /* USB Mode Register */
};


/* ============================================================================
   =============================== Module: UHSTNC =============================
   ============================================================================ */

typedef union UHSTNC_CR_union_tag {    /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t WAKEUPIS:1;              /* USB Wake up interrupt status. */
    vuint32_t PWRFLTDF:1;              /* VBUS Power Fault current value default. */
    vuint32_t PWRFLTEN:1;              /* Enable VBUS Power fault detection. */
    vuint32_t ENDNSEL:1;               /* Endian Selection of USB Master Port. */
    vuint32_t WAKEUPIC:1;              /* Clear USB Wake up interrupt. */
    vuint32_t _unused_3:2;
    vuint32_t PWRFLT:1;                /* Power fault infication. */
    vuint32_t CORE_IE:1;               /* Enable interrupt from core. */
    vuint32_t WAKEUP_IE:1;             /* Enable USB Wake up interrupt. */
  } B;
} UHSTNC_CR_tag;

typedef union UHSTNC_ENDNMODE_union_tag { /* USB Endian Mode Select */
  vuint32_t R;
  struct {
    vuint32_t ENDNMODE:32;             /* Select endian mode. */
  } B;
} UHSTNC_ENDNMODE_tag;

typedef union UHSTNC_ENDNMSEL_union_tag { /* USB Endian Select */
  vuint32_t R;
  struct {
    vuint32_t ENDNMSEL:32;
  } B;
} UHSTNC_ENDNMSEL_tag;

struct UHSTNC_tag {
  uint8_t UHSTNC_reserved0[512];
  UHSTNC_CR_tag CR;                    /* Control register */
  uint8_t UHSTNC_reserved1[12];
  UHSTNC_ENDNMODE_tag ENDNMODE;        /* USB Endian Mode Select */
  uint8_t UHSTNC_reserved2[8];
  UHSTNC_ENDNMSEL_tag ENDNMSEL;        /* USB Endian Select */
};


/* ============================================================================
   =============================== Module: UOTG ===============================
   ============================================================================ */

typedef union UOTG_ID_union_tag {      /* Identification register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t REVISION:8;
    vuint32_t _unused_14:2;
    vuint32_t NID:6;
    vuint32_t _unused_6:2;
    vuint32_t ID:6;                    /* Configuration number */
  } B;
} UOTG_ID_tag;

typedef union UOTG_GNLHW_union_tag {   /* Hardware General */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t SM:2;
    vuint32_t PHYM:3;
    vuint32_t PHYW:2;
    vuint32_t _unused_0:4;
  } B;
} UOTG_GNLHW_tag;

typedef union UOTG_HSTHWP_union_tag {  /* Host Hardware Parameters */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t NPORT:3;
    vuint32_t HC:1;                    /* Host Capable */
  } B;
} UOTG_HSTHWP_tag;

typedef union UOTG_DEVHWP_union_tag {  /* Device Hardware Parameters */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t DEVEP:5;                 /* Device Endpoint Number */
    vuint32_t DC:1;
  } B;
} UOTG_DEVHWP_tag;

typedef union UOTG_TXBFP_union_tag {   /* TX Buffer Hardware Parameters */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t TXCHANADD:8;
    vuint32_t TXADD:8;
    vuint32_t TXBURST:8;
  } B;
} UOTG_TXBFP_tag;

typedef union UOTG_RXBFP_union_tag {   /* RX Buffer Hardware Parameters */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t RXADD:8;
    vuint32_t RXBURST:8;
  } B;
} UOTG_RXBFP_tag;

typedef union UOTG_GPT_LD_union_tag {  /* General Purpose Timer Load */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t GPTLD:24;                /* General Purpose Timer Load Value */
  } B;
} UOTG_GPT_LD_tag;

typedef union UOTG_GPT_CL_union_tag {  /* General Purpose Timer Controller */
  vuint32_t R;
  struct {
    vuint32_t GPTRUN:1;
    vuint32_t GPTRST:1;
    vuint32_t _unused_25:5;
    vuint32_t GPTMODE:1;               /* General Purpose Timer Mode */
    vuint32_t GPTCNT:24;               /* General Purpose Timer Counter */
  } B;
} UOTG_GPT_CL_tag;

typedef struct UOTG_GPT_struct_tag {
  UOTG_GPT_LD_tag LD;                  /* General Purpose Timer Load */
  UOTG_GPT_CL_tag CL;                  /* General Purpose Timer Controller */
} UOTG_GPT_tag;

typedef union UOTG_SBUSCFG_union_tag { /* System Bus Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t BAWR:3;                  /* AMBA Burst Alignment for Writes. */
    vuint32_t BARD:3;                  /* AMBA Burst Alignment for Reads. */
    vuint32_t AHBBRST:3;
  } B;
} UOTG_SBUSCFG_tag;

typedef union UOTG_CAPLENGTH_union_tag { /* Capability Register Length */
  vuint8_t R;
  struct {
    vuint8_t CAPLENGTH:8;
  } B;
} UOTG_CAPLENGTH_tag;

typedef union UOTG_HCIVERSION_union_tag { /* Host Controller Interface Version */
  vuint16_t R;
  struct {
    vuint16_t HCIVERSION:16;
  } B;
} UOTG_HCIVERSION_tag;

typedef union UOTG_HCSPARAMS_union_tag { /* Host Controller Structural Parameters */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t N_TT:4;                  /* Number of Transaction Translators */
    vuint32_t N_PTT:4;                 /* Number of Ports per Transaction Translator */
    vuint32_t _unused_17:3;
    vuint32_t PI:1;                    /* Port Indicators */
    vuint32_t N_CC:4;                  /* Number of Companion Controllers */
    vuint32_t N_PCC:4;
    vuint32_t _unused_5:3;
    vuint32_t PPCA:1;
    vuint32_t N_PORTS:4;               /* Number of downstream ports */
  } B;
} UOTG_HCSPARAMS_tag;

typedef union UOTG_HCCPARAMS_union_tag { /* Host Controller Capability Parameters */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t EECP:8;
    vuint32_t IST:4;
    vuint32_t _unused_3:1;
    vuint32_t ASP:1;
    vuint32_t PFL:1;
    vuint32_t ADC:1;
  } B;
} UOTG_HCCPARAMS_tag;

typedef union UOTG_DCIFVER_union_tag { /* Device Controller Interface Version */
  vuint16_t R;
  struct {
    vuint16_t DCIFVER:16;
  } B;
} UOTG_DCIFVER_tag;

typedef union UOTG_DCCAPPAR_union_tag { /* Device Controller Capability Parameters */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t HC:1;
    vuint32_t DC:1;
    vuint32_t _unused_5:2;
    vuint32_t DEN:5;
  } B;
} UOTG_DCCAPPAR_tag;

typedef union UOTG_USBCMD_union_tag {  /* USB Command Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t ITC:8;                   /* Interrupt Threshold Control */
    vuint32_t FS1:1;                   /* Frame List Size */
    vuint32_t ATDTW:1;                 /* Add dTD TripWire */
    vuint32_t SUTW:1;                  /* Setup TripWire */
    vuint32_t _unused_12:1;
    vuint32_t ASPE:1;
    vuint32_t _unused_10:1;
    vuint32_t ASP:2;                   /* Asynchronous Schedule Park Mode Count */
    vuint32_t _unused_7:1;
    vuint32_t IAA:1;                   /* Interrupt on Async Advance Doorbell */
    vuint32_t ASE:1;                   /* Asynchronous Schedule Enable */
    vuint32_t PSE:1;                   /* Periodic Schedule Enable */
    vuint32_t FS0:2;
    vuint32_t RST:1;                   /* Controller Reset */
    vuint32_t RS:1;                    /* Run/Stop */
  } B;
} UOTG_USBCMD_tag;

typedef union UOTG_USBSTS_union_tag {  /* USB Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t TI1:1;                   /* General Purpose Timer Interrupt 1 */
    vuint32_t TI0:1;                   /* General Purpose Timer Interrupt 0 */
    vuint32_t _unused_20:4;
    vuint32_t UPI:1;                   /* USB Host Periodic Interrupt */
    vuint32_t UAI:1;                   /* USB Host Asynchronous Interrupt */
    vuint32_t _unused_17:1;
    vuint32_t NAKI:1;                  /* NAK Interrupt Bit */
    vuint32_t AS:1;                    /* Asynchronous Schedule Status */
    vuint32_t PS:1;                    /* Periodic Schedule Status */
    vuint32_t RCL:1;                   /* Reclamation */
    vuint32_t HCH:1;                   /* HC Halted */
    vuint32_t UALTI:1;                 /* ULPI alt_int Interrupt */
    vuint32_t ULPII:1;                 /* ULPI Interrupt */
    vuint32_t _unused_9:1;
    vuint32_t SLI:1;                   /* DC Suspend */
    vuint32_t SRI:1;                   /* SOF Received */
    vuint32_t URI:1;                   /* USB Reset Received */
    vuint32_t AAI:1;                   /* Interrupt on Async Advance */
    vuint32_t SEI:1;                   /* System Error */
    vuint32_t FRI:1;                   /* Frame List Rollover */
    vuint32_t PCI:1;                   /* Port Change Detect */
    vuint32_t UEI:1;                   /* USB Error Interrupt */
    vuint32_t UI:1;                    /* USB Interrupt */
  } B;
} UOTG_USBSTS_tag;

typedef union UOTG_USBINTR_union_tag { /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t TIE1:1;
    vuint32_t TIE0:1;
    vuint32_t _unused_20:4;
    vuint32_t UPIE:1;
    vuint32_t UAIE:1;
    vuint32_t _unused_17:1;
    vuint32_t NAKE:1;
    vuint32_t _unused_11:5;
    vuint32_t ULPIE:1;
    vuint32_t _unused_9:1;
    vuint32_t SLE:1;
    vuint32_t SRE:1;
    vuint32_t URE:1;
    vuint32_t AAE:1;
    vuint32_t SEE:1;
    vuint32_t FRE:1;
    vuint32_t PCE:1;
    vuint32_t UEE:1;
    vuint32_t UE:1;
  } B;
} UOTG_USBINTR_tag;

typedef union UOTG_FRINDEX_union_tag { /* USB Frame Index */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t FRINDEX:14;
  } B;
} UOTG_FRINDEX_tag;

typedef union UOTG_ADDRESS1_DEVADR_union_tag { /* Device Address */
  vuint32_t R;
  struct {
    vuint32_t USBADR:7;
    vuint32_t USBADRA:1;               /* Device Address Advance */
    vuint32_t _unused_0:24;
  } B;
} UOTG_ADDRESS1_DEVADR_tag;

typedef union UOTG_ADDRESS1_PERIODICLISTBASE_union_tag { /* Frame List Base Address */
  vuint32_t R;
  struct {
    vuint32_t BASEADR:20;
    vuint32_t _unused_0:12;
  } B;
} UOTG_ADDRESS1_PERIODICLISTBASE_tag;

typedef union UOTG_ADDRESS1_union_tag {
  UOTG_ADDRESS1_DEVADR_tag DEVADR;     /* Device Address */
  UOTG_ADDRESS1_PERIODICLISTBASE_tag PERIODICLISTBASE; /* Frame List Base Address */
} UOTG_ADDRESS1_tag;

typedef union UOTG_ADDRESS2_ASYNCLISTADDR_union_tag { /* Next Asynch. Address */
  vuint32_t R;
  struct {
    vuint32_t ASYBASE:27;
    vuint32_t _unused_0:5;
  } B;
} UOTG_ADDRESS2_ASYNCLISTADDR_tag;

typedef union UOTG_ADDRESS2_ENDPLADR_union_tag { /* Endpoint List Address */
  vuint32_t R;
  struct {
    vuint32_t EPBASE:21;               /* Endpoint List Pointer(Low) */
    vuint32_t _unused_0:11;
  } B;
} UOTG_ADDRESS2_ENDPLADR_tag;

typedef union UOTG_ADDRESS2_union_tag {
  UOTG_ADDRESS2_ASYNCLISTADDR_tag ASYNCLISTADDR; /* Next Asynch. Address */
  UOTG_ADDRESS2_ENDPLADR_tag ENDPLADR; /* Endpoint List Address */
} UOTG_ADDRESS2_tag;

typedef union UOTG_BRSTSIZE_union_tag { /* Programmable Burst Size */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPBURST:8;
    vuint32_t RXPBURST:8;
  } B;
} UOTG_BRSTSIZE_tag;

typedef union UOTG_TXTFLTNG_union_tag { /* TX FIFO Fill Tuning */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t TXFIFOTHRES:6;           /* FIFO Burst Threshold */
    vuint32_t _unused_13:3;
    vuint32_t TXSCHHEALTH:5;           /* Scheduler Health Counter */
    vuint32_t TXSCHOH:8;               /* Scheduler Overhead */
  } B;
} UOTG_TXTFLTNG_tag;

typedef union UOTG_ICUSBEN_union_tag { /* IC_USB enable and voltage negotiation */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t IC1:1;
    vuint32_t IC_VDD1:3;
  } B;
} UOTG_ICUSBEN_tag;

typedef union UOTG_ULPIVWPT_union_tag { /* ULPI Register Access */
  vuint32_t R;
  struct {
    vuint32_t ULPI_WU:1;               /* ULPI Wake-Up */
    vuint32_t ULPI_RUN:1;              /* ULPI Run */
    vuint32_t ULPI_RW:1;               /* ULPI Read/Write */
    vuint32_t _unused_28:1;            /* Reserved */
    vuint32_t ULPI_SS:1;               /* ULPI Sync State */
    vuint32_t ULPI_PORT:3;             /* ULPI Port number */
    vuint32_t ULPI_ADDR:8;             /* ULPI data Address */
    vuint32_t ULPI_DATRD:8;            /* ULPI Data Read */
    vuint32_t ULPI_DATWR:8;            /* ULPI Data Write */
  } B;
} UOTG_ULPIVWPT_tag;

typedef union UOTG_ENDPNAK_union_tag { /* Endpoint NAK */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t EPTN:4;                  /* TX Endpoint NAK */
    vuint32_t _unused_4:12;
    vuint32_t EPRN:4;                  /* RX Endpoint NAK */
  } B;
} UOTG_ENDPNAK_tag;

typedef union UOTG_ENDPNAKE_union_tag { /* Endpoint NAK Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t EPTNE:4;                 /* TX Endpoint NAK Enable */
    vuint32_t _unused_4:12;
    vuint32_t EPRNE:4;                 /* RX Endpoint NAK Enable */
  } B;
} UOTG_ENDPNAKE_tag;

typedef union UOTG_CONFIGFLAG_union_tag { /* Configure Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;            /* Reserved */
    vuint32_t _unused_0:1;             /* Reserved */
  } B;
} UOTG_CONFIGFLAG_tag;

typedef union UOTG_PORTSC1_union_tag { /* Port Status and Control */
  vuint32_t R;
  struct {
    vuint32_t PTS1:2;                  /* Parallel Transceiver Select */
    vuint32_t STS:1;                   /* Serial Transceiver Select */
    vuint32_t PTW:1;                   /* Parallel Transceiver Width */
    vuint32_t PSPD:2;                  /* Port Speed */
    vuint32_t PTS0:1;
    vuint32_t PFSC:1;                  /* Port Force Full Speed Connect */
    vuint32_t PHCD:1;                  /* PHY Low Power Suspend - Clock Disable */
    vuint32_t WKOC:1;                  /* Wake on Over-current Enable */
    vuint32_t WKDS:1;                  /* Wake on Disconnect Enable */
    vuint32_t WKCN:1;                  /* Wake on Connect Enable */
    vuint32_t PTC:4;                   /* Port Test Control */
    vuint32_t PIC:2;                   /* Port Indicator Control */
    vuint32_t PO:1;                    /* Port Owner */
    vuint32_t PP:1;
    vuint32_t LS:2;                    /* Line Status */
    vuint32_t HSP:1;                   /* High-Speed Port */
    vuint32_t PR:1;                    /* Port Reset */
    vuint32_t SUSP:1;                  /* Suspend */
    vuint32_t FPR:1;                   /* Force Port Resume */
    vuint32_t OCC:1;                   /* Over-current Change */
    vuint32_t OCA:1;                   /* Over-current Active */
    vuint32_t PEC:1;                   /* Port Enable/Disable Change */
    vuint32_t PE:1;                    /* Port Enabled/Disabled */
    vuint32_t CSC:1;                   /* Connect Status Change */
    vuint32_t CCS:1;                   /* Current Connect Status */
  } B;
} UOTG_PORTSC1_tag;

typedef union UOTG_OTGSC_union_tag {   /* On-The-Go Status Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t DPIE:1;
    vuint32_t TIMIE:1;                 /* One-millisecond timer interrupt enable */
    vuint32_t BSEIE:1;                 /* B Session End Interrupt Enable */
    vuint32_t BSVIE:1;                 /* B Session Valid Interrupt Enable */
    vuint32_t ASVIE:1;                 /* A Session Valid Interrupt Enable */
    vuint32_t AVVIE:1;                 /* A VBus Valid Interrupt Enable */
    vuint32_t IDIE:1;                  /* USB ID Interrupt Enable */
    vuint32_t _unused_23:1;
    vuint32_t DPIS:1;                  /* Data Pulse Interrupt Status */
    vuint32_t TIMIS:1;                 /* One-millisecond timer interrupt status */
    vuint32_t BSEIS:1;                 /* B Session End Interrupt Status */
    vuint32_t BSVIS:1;                 /* B Session Valid Interrupt Status */
    vuint32_t ASVIS:1;                 /* A Session Valid Interrupt Status */
    vuint32_t AVVIS:1;                 /* A VBus Valid Interrupt Status */
    vuint32_t IDIS:1;                  /* USB ID Interrupt Status */
    vuint32_t _unused_15:1;
    vuint32_t DPS:1;                   /* Data Bus Pulsing Status */
    vuint32_t TIM_TOG:1;               /* One-millisecond timer toggle */
    vuint32_t BSE:1;                   /* B Session End */
    vuint32_t BSV:1;                   /* B Session Valid */
    vuint32_t ASV:1;                   /* A Session Valid */
    vuint32_t AVV:1;                   /* A VBus Valid */
    vuint32_t ID:1;                    /* USB ID */
    vuint32_t HABA:1;                  /* Hardware Assist B-Disconnect to A-connect. */
    vuint32_t HADP:1;                  /* HADP Hardware Assist Data. */
    vuint32_t IDPU:1;                  /* ID Pullup */
    vuint32_t DP:1;                    /* Data Pulsing. */
    vuint32_t OT:1;                    /* OTG Termination */
    vuint32_t HAAR:1;                  /* Hardware Assist Auto-Reset. */
    vuint32_t VC:1;                    /* VBUS Charge */
    vuint32_t VD:1;                    /* VBUS Discharge */
  } B;
} UOTG_OTGSC_tag;

typedef union UOTG_USBDMODE_union_tag { /* USB Device Mode */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t ALP:8;                   /* Auto Low Power */
    vuint32_t SRT:1;                   /* Shorten Reset Time */
    vuint32_t TXHSD:4;                 /* Tx to Tx HS Delay. */
    vuint32_t _unused_5:6;
    vuint32_t SDIS:1;                  /* Stream Disable Mode */
    vuint32_t SLOM:1;                  /* Setup Lockout Mode */
    vuint32_t ES:1;                    /* Endian Select */
    vuint32_t CM:2;                    /* Controller Mode */
  } B;
} UOTG_USBDMODE_tag;

typedef union UOTG_ENPSTPST_union_tag { /* Endpoint Setup Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t ENPSTPST:16;             /* Setup Endpoint Status */
  } B;
} UOTG_ENPSTPST_tag;

typedef union UOTG_ENDPINT_union_tag { /* Endpoint Initialization */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t PETB:4;                  /* Prime Endpoint Transmit Buffer */
    vuint32_t _unused_4:12;
    vuint32_t PERB:4;                  /* Prime Endpoint Receive Buffer */
  } B;
} UOTG_ENDPINT_tag;

typedef union UOTG_ENDPDINT_union_tag { /* Endpoint De-Initialize */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t FETB:4;                  /* Flush Endpoint Transmit Buffer */
    vuint32_t _unused_4:12;
    vuint32_t FERB:4;                  /* Flush Endpoint Receive Buffer */
  } B;
} UOTG_ENDPDINT_tag;

typedef union UOTG_ENDPST_union_tag {  /* Endpoint Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t ETBR:4;                  /* Endpoint Transmit Buffer Ready */
    vuint32_t _unused_4:12;
    vuint32_t ERBR:4;                  /* Endpoint Receive Buffer Ready */
  } B;
} UOTG_ENDPST_tag;

typedef union UOTG_ENPCPLT_union_tag { /* Endpoint Complete */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t ETCE:4;                  /* Endpoint Transmit Complete Event */
    vuint32_t _unused_4:12;
    vuint32_t ERCE:4;                  /* Endpoint Receive Complete Event */
  } B;
} UOTG_ENPCPLT_tag;

typedef union UOTG_ENDPTC0_union_tag { /* Endpoint Control 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t TXE:1;
    vuint32_t _unused_20:3;
    vuint32_t TXT:2;                   /* TX Endpoint Type */
    vuint32_t _unused_17:1;
    vuint32_t TXS:1;                   /* TX Endpoint Stall */
    vuint32_t _unused_8:8;
    vuint32_t RXE:1;
    vuint32_t _unused_4:3;
    vuint32_t RXT:2;                   /* RX Endpoint Type */
    vuint32_t _unused_1:1;
    vuint32_t RXS:1;                   /* RX Endpoint Stall */
  } B;
} UOTG_ENDPTC0_tag;

typedef union UOTG_ENDPTC_union_tag {  /* Endpoint Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t TXE:1;
    vuint32_t TXR:1;                   /* TX Data Toggle Reset */
    vuint32_t TXI:1;
    vuint32_t _unused_20:1;
    vuint32_t TXT:2;
    vuint32_t TXD:1;
    vuint32_t TXS:1;
    vuint32_t _unused_8:8;
    vuint32_t RXE:1;
    vuint32_t RXR:1;                   /* RX Data Toggle Reset */
    vuint32_t RXI:1;                   /* RX Data Toggle Inhibit */
    vuint32_t _unused_4:1;
    vuint32_t RXT:2;                   /* RX Endpoint Type */
    vuint32_t RXD:1;                   /* RX Endpoint Data Sink */
    vuint32_t RXS:1;                   /* RX Endpoint Stall */
  } B;
} UOTG_ENDPTC_tag;

struct UOTG_tag {
  UOTG_ID_tag ID;                      /* Identification register */
  UOTG_GNLHW_tag GNLHW;                /* Hardware General */
  UOTG_HSTHWP_tag HSTHWP;              /* Host Hardware Parameters */
  UOTG_DEVHWP_tag DEVHWP;              /* Device Hardware Parameters */
  UOTG_TXBFP_tag TXBFP;                /* TX Buffer Hardware Parameters */
  UOTG_RXBFP_tag RXBFP;                /* RX Buffer Hardware Parameters */
  uint8_t UOTG_reserved0[104];
  UOTG_GPT_tag GPT[2];
  UOTG_SBUSCFG_tag SBUSCFG;            /* System Bus Configuration */
  uint8_t UOTG_reserved1[108];
  UOTG_CAPLENGTH_tag CAPLENGTH;        /* Capability Register Length */
  uint8_t UOTG_reserved2[1];
  UOTG_HCIVERSION_tag HCIVERSION;      /* Host Controller Interface Version */
  UOTG_HCSPARAMS_tag HCSPARAMS;        /* Host Controller Structural Parameters */
  UOTG_HCCPARAMS_tag HCCPARAMS;        /* Host Controller Capability Parameters */
  uint8_t UOTG_reserved3[20];
  UOTG_DCIFVER_tag DCIFVER;            /* Device Controller Interface Version */
  uint8_t UOTG_reserved4[2];
  UOTG_DCCAPPAR_tag DCCAPPAR;          /* Device Controller Capability Parameters */
  uint8_t UOTG_reserved5[24];
  UOTG_USBCMD_tag USBCMD;              /* USB Command Register */
  UOTG_USBSTS_tag USBSTS;              /* USB Status Register */
  UOTG_USBINTR_tag USBINTR;            /* Interrupt Enable Register */
  UOTG_FRINDEX_tag FRINDEX;            /* USB Frame Index */
  uint8_t UOTG_reserved6[4];
  UOTG_ADDRESS1_tag ADDRESS1;
  UOTG_ADDRESS2_tag ADDRESS2;
  uint8_t UOTG_reserved7[4];
  UOTG_BRSTSIZE_tag BRSTSIZE;          /* Programmable Burst Size */
  UOTG_TXTFLTNG_tag TXTFLTNG;          /* TX FIFO Fill Tuning */
  uint8_t UOTG_reserved8[4];
  UOTG_ICUSBEN_tag ICUSBEN;            /* IC_USB enable and voltage negotiation */
  UOTG_ULPIVWPT_tag ULPIVWPT;          /* ULPI Register Access */
  uint8_t UOTG_reserved9[4];
  UOTG_ENDPNAK_tag ENDPNAK;            /* Endpoint NAK */
  UOTG_ENDPNAKE_tag ENDPNAKE;          /* Endpoint NAK Enable */
  UOTG_CONFIGFLAG_tag CONFIGFLAG;      /* Configure Flag Register */
  UOTG_PORTSC1_tag PORTSC1;            /* Port Status and Control */
  uint8_t UOTG_reserved10[28];
  UOTG_OTGSC_tag OTGSC;                /* On-The-Go Status Control */
  UOTG_USBDMODE_tag USBDMODE;          /* USB Device Mode */
  UOTG_ENPSTPST_tag ENPSTPST;          /* Endpoint Setup Status */
  UOTG_ENDPINT_tag ENDPINT;            /* Endpoint Initialization */
  UOTG_ENDPDINT_tag ENDPDINT;          /* Endpoint De-Initialize */
  UOTG_ENDPST_tag ENDPST;              /* Endpoint Status */
  UOTG_ENPCPLT_tag ENPCPLT;            /* Endpoint Complete */
  UOTG_ENDPTC0_tag ENDPTC0;            /* Endpoint Control 0 */
  UOTG_ENDPTC_tag ENDPTC[4];           /* Endpoint Control */
};


/* ============================================================================
   =============================== Module: UOTGNC =============================
   ============================================================================ */

typedef union UOTGNC_CR_union_tag {    /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t WAKEUPIS:1;              /* USB wake up interrupt status */
    vuint32_t PWRFLTDF:1;              /* Vbus power fault current value default */
    vuint32_t PWRFLTEN:1;              /* Enable Vbus power fault detection */
    vuint32_t ENDNSEL:1;               /* Endian selection of USB master port */
    vuint32_t WAKEUPIC:1;              /* Clear USB wake up interrupt */
    vuint32_t _unused_3:2;
    vuint32_t PWRFLT:1;                /* Power fault indication */
    vuint32_t CORE_IE:1;               /* Enable interrupt from core */
    vuint32_t WAKEUP_IE:1;             /* USB wake up interrupt enable */
  } B;
} UOTGNC_CR_tag;

typedef union UOTGNC_ENDNMODE_union_tag { /* USB Endian Mode Select */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* User should not write anything on this register. In case any thing is written, it need to be cleared by writing all Zeros. */
  } B;
} UOTGNC_ENDNMODE_tag;

typedef union UOTGNC_ENDNMSEL_union_tag { /* USB endian select */
  vuint32_t R;
  struct {
    vuint32_t ENDNMSEL:32;
  } B;
} UOTGNC_ENDNMSEL_tag;

struct UOTGNC_tag {
  uint8_t UOTGNC_reserved0[512];
  UOTGNC_CR_tag CR;                    /* Control register */
  uint8_t UOTGNC_reserved1[12];
  UOTGNC_ENDNMODE_tag ENDNMODE;        /* USB Endian Mode Select */
  uint8_t UOTGNC_reserved2[8];
  UOTGNC_ENDNMSEL_tag ENDNMSEL;        /* USB endian select */
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

typedef union WKPU_NSR_union_tag {     /* NMI Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t NIF0:1;
    vuint32_t NOVF0:1;
    vuint32_t _unused_24:6;
    vuint32_t NIF1:1;
    vuint32_t NOVF1:1;
    vuint32_t _unused_16:6;
    vuint32_t NIF2:1;
    vuint32_t NOVF2:1;
    vuint32_t _unused_8:6;
    vuint32_t RIF:1;                   /* Reset Status Flag */
    vuint32_t ROVF:1;                  /* Reset Overrun Status Flag */
    vuint32_t _unused_0:6;
  } B;
} WKPU_NSR_tag;

typedef union WKPU_NCR_union_tag {     /* NMI Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t NLOCK0:1;
    vuint32_t NDSS0:2;
    vuint32_t NWRE0:1;
    vuint32_t _unused_27:1;
    vuint32_t NREE0:1;
    vuint32_t NFEE0:1;
    vuint32_t NFE0:1;
    vuint32_t NLOCK1:1;
    vuint32_t NDSS1:2;
    vuint32_t NWRE1:1;
    vuint32_t _unused_19:1;
    vuint32_t NREE1:1;
    vuint32_t NFEE1:1;
    vuint32_t _unused_16:1;
    vuint32_t NLOCK2:1;
    vuint32_t NDSS2:2;
    vuint32_t NWRE2:1;
    vuint32_t _unused_11:1;
    vuint32_t NREE2:1;
    vuint32_t NFEE2:1;
    vuint32_t _unused_8:1;
    vuint32_t RLOCK:1;
    vuint32_t RDSS:2;
    vuint32_t RWRE:1;
    vuint32_t _unused_3:1;
    vuint32_t RREE:1;
    vuint32_t RFEE:1;
    vuint32_t _unused_0:1;
  } B;
} WKPU_NCR_tag;

typedef union WKPU_WISR_union_tag {    /* Wakeup/Interrupt Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t EIF:32;
  } B;
} WKPU_WISR_tag;

typedef union WKPU_IRER_union_tag {    /* Interrupt Request Enable Register */
  vuint32_t R;
  struct {
    vuint32_t EIRE:32;
  } B;
} WKPU_IRER_tag;

typedef union WKPU_WRER_union_tag {    /* Wakeup Request Enable Register */
  vuint32_t R;
  struct {
    vuint32_t WRE:32;
  } B;
} WKPU_WRER_tag;

typedef union WKPU_WIREER_union_tag {  /* Wakeup/Interrupt Rising-Edge Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IREE:32;
  } B;
} WKPU_WIREER_tag;

typedef union WKPU_WIFEER_union_tag {  /* Wakeup/Interrupt Falling-Edge Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IFEEx:32;
  } B;
} WKPU_WIFEER_tag;

typedef union WKPU_WIFER_union_tag {   /* Wakeup/Interrupt Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IFE:32;
  } B;
} WKPU_WIFER_tag;

typedef union WKPU_WIPUER_union_tag {  /* Wakeup/Interrupt Pullup Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IPUE:32;
  } B;
} WKPU_WIPUER_tag;

struct WKPU_tag {
  WKPU_NSR_tag NSR;                    /* NMI Status Flag Register */
  uint8_t WKPU_reserved0[4];
  WKPU_NCR_tag NCR;                    /* NMI Configuration Register */
  uint8_t WKPU_reserved1[8];
  WKPU_WISR_tag WISR;                  /* Wakeup/Interrupt Status Flag Register */
  WKPU_IRER_tag IRER;                  /* Interrupt Request Enable Register */
  WKPU_WRER_tag WRER;                  /* Wakeup Request Enable Register */
  uint8_t WKPU_reserved2[8];
  WKPU_WIREER_tag WIREER;              /* Wakeup/Interrupt Rising-Edge Event Enable Register */
  WKPU_WIFEER_tag WIFEER;              /* Wakeup/Interrupt Falling-Edge Event Enable Register */
  WKPU_WIFER_tag WIFER;                /* Wakeup/Interrupt Filter Enable Register */
  WKPU_WIPUER_tag WIPUER;              /* Wakeup/Interrupt Pullup Enable Register */
};


/* ============================================================================
   =============================== Module: XOSC ===============================
   ============================================================================ */

typedef union XOSC_CTL_union_tag {     /* XOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t OSCBYP:1;
    vuint32_t _unused_29:2;
    vuint32_t _unused_24:5;
    vuint32_t EOCV:8;                  /* End of Count Value */
    vuint32_t M_OSC:1;                 /* Crystal oscillator clock interrupt mask */
    vuint32_t _unused_13:2;
    vuint32_t _unused_8:5;
    vuint32_t I_OSC:1;
    vuint32_t _unused_2:5;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} XOSC_CTL_tag;

struct XOSC_tag {
  XOSC_CTL_tag CTL;                    /* XOSC Control Register */
};


/* ============================================================================
   =============================== Module: eMIOS ==============================
   ============================================================================ */

typedef union eMIOS_MCR_union_tag {    /* eMIOS Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;            /* Reserved. */
    vuint32_t MDIS:1;                  /* Module Disable bit. */
    vuint32_t FRZ:1;                   /* Freeze bit. */
    vuint32_t GTBE:1;                  /* Global Time Base Enable bit. */
    vuint32_t ETB:1;                   /* External Time Base bit */
    vuint32_t GPREN:1;                 /* Global Prescaler Enable bit. */
    vuint32_t _unused_20:6;            /* Reserved. */
    vuint32_t _unused_16:4;            /* Reserved. */
    vuint32_t GPRE:8;                  /* Global Prescaler bits. */
    vuint32_t _unused_0:8;             /* Reserved. */
  } B;
} eMIOS_MCR_tag;

typedef union eMIOS_GFLAG_union_tag {  /* eMIOS Global FLAG Register */
  vuint32_t R;
  struct {
    vuint32_t F31_F0:32;               /* Channel [n] mirrored FLAG bit. */
  } B;
} eMIOS_GFLAG_tag;

typedef union eMIOS_OUDIS_union_tag {  /* eMIOS Output Update Disable register */
  vuint32_t R;
  struct {
    vuint32_t OU31_OU0:32;             /* Channel [n] Output Update Disable bit. */
  } B;
} eMIOS_OUDIS_tag;

typedef union eMIOS_UCDIS_union_tag {  /* eMIOS Disable Channel register */
  vuint32_t R;
  struct {
    vuint32_t CHDIS31_CHDIS0:32;       /* Enable Channel n bit. */
  } B;
} eMIOS_UCDIS_tag;

struct eMIOS_tag {
  eMIOS_MCR_tag MCR;                   /* eMIOS Module Configuration Register */
  eMIOS_GFLAG_tag GFLAG;               /* eMIOS Global FLAG Register */
  eMIOS_OUDIS_tag OUDIS;               /* eMIOS Output Update Disable register */
  eMIOS_UCDIS_tag UCDIS;               /* eMIOS Disable Channel register */
};


/* ============================================================================
   =============================== Module: eMIOS_UC ===========================
   ============================================================================ */

typedef union eMIOS_UC_UC_A_union_tag { /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;            /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_UC_UC_A_tag;

typedef union eMIOS_UC_UC_B_union_tag { /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;            /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_UC_UC_B_tag;

typedef union eMIOS_UC_UC_CNT_union_tag { /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;           /* Reserved. */
    vuint32_t C:16;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_UC_UC_CNT_tag;

typedef union eMIOS_UC_UC_C_union_tag { /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t _unused_14:3;            /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_UC_UC_C_tag;

typedef union eMIOS_UC_UC_S_union_tag { /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t _unused_16:15;           /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t _unused_3:12;            /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_UC_UC_S_tag;

typedef union eMIOS_UC_UC_ALTA_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;            /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_UC_UC_ALTA_tag;

typedef union eMIOS_UC_UC_C2_union_tag { /* eMIOS UC Control 2 register n */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;           /* Reserved. */
    vuint32_t UCEXTPRE:4;              /* Extended Prescaler bits */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t UCPRECLK:1;              /* Prescaler Clock select bit. */
    vuint32_t _unused_0:14;            /* Reserved. */
  } B;
} eMIOS_UC_UC_C2_tag;

typedef struct eMIOS_UC_UC_struct_tag {
  eMIOS_UC_UC_A_tag A;                 /* eMIOS UC A register n */
  eMIOS_UC_UC_B_tag B;                 /* eMIOS UC B register n */
  eMIOS_UC_UC_CNT_tag CNT;             /* eMIOS CNT register n */
  eMIOS_UC_UC_C_tag C;                 /* eMIOS UC Control register n */
  eMIOS_UC_UC_S_tag S;                 /* eMIOS UC Status register n */
  eMIOS_UC_UC_ALTA_tag ALTA;           /* eMIOS Alternate Address register n */
  eMIOS_UC_UC_C2_tag C2;               /* eMIOS UC Control 2 register n */
  uint8_t UC_reserved0[4];
} eMIOS_UC_UC_tag;

struct eMIOS_UC_tag {
  uint8_t eMIOS_UC_reserved0[32];
  eMIOS_UC_UC_tag UC[32];
};

/* ============================================================================
   =============================== Module: uSDHC ==============================
   ============================================================================ */

typedef union uSDHC_S_ADDR_union_tag { /* DMA System Address */
  vuint32_t R;
  struct {
    vuint32_t DS_ADDR:30;
    vuint32_t _unused_0:2;
  } B;
} uSDHC_S_ADDR_tag;

typedef union uSDHC_BLK_ATT_union_tag { /* Block Attributes */
  vuint32_t R;
  struct {
    vuint32_t BLKCNT:16;
    vuint32_t _unused_13:3;
    vuint32_t BLKSIZE:13;
  } B;
} uSDHC_BLK_ATT_tag;

typedef union uSDHC_CMD_ARG_union_tag { /* Command Argument */
  vuint32_t R;
  struct {
    vuint32_t CMDARG:32;
  } B;
} uSDHC_CMD_ARG_tag;

typedef union uSDHC_CMD_XFR_TYP_union_tag { /* Command Transfer Type */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t CMDINX:6;
    vuint32_t CMDTYP:2;
    vuint32_t DPSEL:1;
    vuint32_t CICEN:1;
    vuint32_t CCCEN:1;
    vuint32_t _unused_18:1;
    vuint32_t RSPTYP:2;
    vuint32_t _unused_0:16;
  } B;
} uSDHC_CMD_XFR_TYP_tag;

typedef union uSDHC_CMD_RSP0_union_tag { /* Command Response0 */
  vuint32_t R;
  struct {
    vuint32_t CMDRSP0:32;
  } B;
} uSDHC_CMD_RSP0_tag;

typedef union uSDHC_CMD_RSP1_union_tag { /* Command Response1 */
  vuint32_t R;
  struct {
    vuint32_t CMDRSP1:32;
  } B;
} uSDHC_CMD_RSP1_tag;

typedef union uSDHC_CMD_RSP2_union_tag { /* Command Response2 */
  vuint32_t R;
  struct {
    vuint32_t CMDRSP2:32;
  } B;
} uSDHC_CMD_RSP2_tag;

typedef union uSDHC_CMD_RSP3_union_tag { /* Command Response3 */
  vuint32_t R;
  struct {
    vuint32_t CMDRSP3:32;
  } B;
} uSDHC_CMD_RSP3_tag;

typedef union uSDHC_DATA_BUFF_ACC_PORT_union_tag { /* Data Buffer Access Port */
  vuint32_t R;
  struct {
    vuint32_t DATCONT:32;
  } B;
} uSDHC_DATA_BUFF_ACC_PORT_tag;

typedef union uSDHC_PRES_STATE_union_tag { /* Present State */
  vuint32_t R;
  struct {
    vuint32_t DLSL:8;
    vuint32_t CLSL:1;
    vuint32_t _unused_20:3;
    vuint32_t WPSPL:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_17:1;
    vuint32_t CINST:1;
    vuint32_t _unused_15:1;
    vuint32_t _unused_13:2;
    vuint32_t _unused_12:1;
    vuint32_t BREN:1;
    vuint32_t BWEN:1;
    vuint32_t RTA:1;
    vuint32_t WTA:1;
    vuint32_t SDOFF:1;
    vuint32_t PEROFF:1;
    vuint32_t HCKOFF:1;
    vuint32_t BUSOFF:1;
    vuint32_t SDSTB:1;
    vuint32_t DLA:1;
    vuint32_t CDIHB:1;
    vuint32_t CIHB:1;
  } B;
} uSDHC_PRES_STATE_tag;

typedef union uSDHC_PROT_CTRL_union_tag { /* Protocol Control */
  vuint32_t R;
  struct {
    vuint32_t RD_NO8CLK_EN:1;
    vuint32_t NON_EXACT_BLK_RD:1;
    vuint32_t BURST_LEN_EN:3;
    vuint32_t WECRM:1;
    vuint32_t WECINS:1;
    vuint32_t WECINT:1;
    vuint32_t RD_WAIT_POINT:3;
    vuint32_t RD_DONE_NO_8CLK:1;
    vuint32_t IABG:1;
    vuint32_t RWCTL:1;
    vuint32_t CREQ:1;
    vuint32_t SABGREQ:1;
    vuint32_t _unused_10:6;
    vuint32_t DMASEL:2;
    vuint32_t CDSS:1;
    vuint32_t CDTL:1;
    vuint32_t EMODE:2;
    vuint32_t D3CD:1;
    vuint32_t DTW:2;
    vuint32_t LCTL:1;
  } B;
} uSDHC_PROT_CTRL_tag;

typedef union uSDHC_SYS_CTRL_union_tag { /* System Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t _unused_28:1;
    vuint32_t INITA:1;
    vuint32_t RSTD:1;
    vuint32_t RSTC:1;
    vuint32_t RSTA:1;
    vuint32_t IPP_RST_N:1;
    vuint32_t _unused_22:1;
    vuint32_t _unused_20:2;
    vuint32_t DTOCV:4;
    vuint32_t SDCLKFS:8;
    vuint32_t DVS:4;
    vuint32_t _unused_0:4;
  } B;
} uSDHC_SYS_CTRL_tag;

typedef union uSDHC_INT_STATUS_union_tag { /* Interrupt Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t DMAE:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_25:1;
    vuint32_t AC12E:1;
    vuint32_t _unused_23:1;
    vuint32_t DEBE:1;
    vuint32_t DCE:1;
    vuint32_t DTOE:1;
    vuint32_t CIE:1;
    vuint32_t CEBE:1;
    vuint32_t CCE:1;
    vuint32_t CTOE:1;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_9:3;
    vuint32_t CINT:1;
    vuint32_t CRM:1;
    vuint32_t CINS:1;
    vuint32_t BRR:1;
    vuint32_t BWR:1;
    vuint32_t DINT:1;
    vuint32_t BGE:1;
    vuint32_t TC:1;
    vuint32_t CC:1;
  } B;
} uSDHC_INT_STATUS_tag;

typedef union uSDHC_INT_STATUS_EN_union_tag { /* Interrupt Status Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t DMAESEN:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_25:1;
    vuint32_t AC12ESEN:1;
    vuint32_t _unused_23:1;
    vuint32_t DEBESEN:1;
    vuint32_t DCESEN:1;
    vuint32_t DTOESEN:1;
    vuint32_t CIESEN:1;
    vuint32_t CEBESEN:1;
    vuint32_t CCESEN:1;
    vuint32_t CTOESEN:1;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_9:3;
    vuint32_t CINTSEN:1;
    vuint32_t CRMSEN:1;
    vuint32_t CINSSEN:1;
    vuint32_t BRRSEN:1;
    vuint32_t BWRSEN:1;
    vuint32_t DINTSEN:1;
    vuint32_t BGESEN:1;
    vuint32_t TCSEN:1;
    vuint32_t CCSEN:1;
  } B;
} uSDHC_INT_STATUS_EN_tag;

typedef union uSDHC_INT_SIGNAL_EN_union_tag { /* Interrupt Signal Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t DMAEIEN:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_25:1;
    vuint32_t AC12EIEN:1;
    vuint32_t _unused_23:1;
    vuint32_t DEBEIEN:1;
    vuint32_t DCEIEN:1;
    vuint32_t DTOEIEN:1;
    vuint32_t CIEIEN:1;
    vuint32_t CEBEIEN:1;
    vuint32_t CCEIEN:1;
    vuint32_t CTOEIEN:1;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_9:3;
    vuint32_t CINTIEN:1;
    vuint32_t CRMIEN:1;
    vuint32_t CINSIEN:1;
    vuint32_t BRRIEN:1;
    vuint32_t BWRIEN:1;
    vuint32_t DINTIEN:1;
    vuint32_t BGEIEN:1;
    vuint32_t TCIEN:1;
    vuint32_t CCIEN:1;
  } B;
} uSDHC_INT_SIGNAL_EN_tag;

typedef union uSDHC_AUTOCMD12_ERR_STATUS_union_tag { /* Auto CMD12 Error Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_23:1;
    vuint32_t EXECUTE_TUNING:1;
    vuint32_t _unused_8:14;
    vuint32_t CNIBAC12E:1;
    vuint32_t _unused_5:2;
    vuint32_t AC12IE:1;
    vuint32_t AC12CE:1;
    vuint32_t AC12EBE:1;
    vuint32_t AC12TOE:1;
    vuint32_t AC12NE:1;
  } B;
} uSDHC_AUTOCMD12_ERR_STATUS_tag;

typedef union uSDHC_HOST_CTRL_CAP_union_tag { /* Host Controller Capabilities */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t VS18:1;
    vuint32_t VS30:1;
    vuint32_t VS33:1;
    vuint32_t SRS:1;
    vuint32_t DMAS:1;
    vuint32_t HSS:1;
    vuint32_t ADMAS:1;
    vuint32_t _unused_19:1;
    vuint32_t MBL:3;
    vuint32_t _unused_14:2;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_8:4;
    vuint32_t _unused_3:5;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} uSDHC_HOST_CTRL_CAP_tag;

typedef union uSDHC_WTMK_LVL_union_tag { /* Watermark Level */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t WR_BRST_LEN:5;
    vuint32_t WR_WML:8;
    vuint32_t _unused_13:3;
    vuint32_t RD_BRST_LEN:5;
    vuint32_t RD_WML:8;
  } B;
} uSDHC_WTMK_LVL_tag;

typedef union uSDHC_MIX_CTRL_union_tag { /* Mixer Control */
  vuint32_t R;
  struct {
    vuint32_t CMD_DMY_EN:1;
    vuint32_t CMD_DMY_WAIT_CFG:1;
    vuint32_t AC12_RD_POINT:1;
    vuint32_t _unused_26:3;
    vuint32_t _unused_25:1;
    vuint32_t _unused_24:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_22:1;
    vuint32_t _unused_8:14;
    vuint32_t AC23EN:1;
    vuint32_t _unused_6:1;
    vuint32_t MSBSEL:1;
    vuint32_t DTDSEL:1;
    vuint32_t _unused_3:1;
    vuint32_t AC12EN:1;
    vuint32_t BCEN:1;
    vuint32_t DMAEN:1;
  } B;
} uSDHC_MIX_CTRL_tag;

typedef union uSDHC_FORCE_EVENT_union_tag { /* Force Event */
  vuint32_t R;
  struct {
    vuint32_t FEVTCINT:1;
    vuint32_t _unused_29:2;
    vuint32_t FEVTDMAE:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_25:1;
    vuint32_t FEVTAC12E:1;
    vuint32_t _unused_23:1;
    vuint32_t FEVTDEBE:1;
    vuint32_t FEVTDCE:1;
    vuint32_t FEVTDTOE:1;
    vuint32_t FEVTCIE:1;
    vuint32_t FEVTCEBE:1;
    vuint32_t FEVTCCE:1;
    vuint32_t FEVTCTOE:1;
    vuint32_t _unused_8:8;
    vuint32_t FEVTCNIBAC12E:1;
    vuint32_t _unused_5:2;
    vuint32_t FEVTAC12IE:1;
    vuint32_t FEVTAC12EBE:1;
    vuint32_t FEVTAC12CE:1;
    vuint32_t FEVTAC12TOE:1;
    vuint32_t FEVTAC12NE:1;
  } B;
} uSDHC_FORCE_EVENT_tag;

typedef union uSDHC_ADMA_ERR_STATUS_union_tag { /* ADMA Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t ADMADCE:1;
    vuint32_t ADMALME:1;
    vuint32_t ADMAES:2;
  } B;
} uSDHC_ADMA_ERR_STATUS_tag;

typedef union uSDHC_ADMA_SYS_ADDR_union_tag { /* ADMA System Address */
  vuint32_t R;
  struct {
    vuint32_t ADS_ADDR:30;
    vuint32_t _unused_0:2;
  } B;
} uSDHC_ADMA_SYS_ADDR_tag;

typedef union uSDHC_VEND_SPEC_union_tag { /* Vendor Specific Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t AC12_RD_CHKBUSY_EN:1;
    vuint32_t CMD_OE_PRE_EN:1;
    vuint32_t DBG_SEL:4;
    vuint32_t INT_ST_VAL:8;
    vuint32_t CRC_CHK_DIS:1;
    vuint32_t CARD_CLK_SOFT_EN:1;
    vuint32_t IPG_PERCLK_SOFT_EN:1;
    vuint32_t HCLK_SOFT_EN:1;
    vuint32_t BUS_CLK_SOFT_EN:1;
    vuint32_t _unused_10:1;
    vuint32_t AC12_ISNOT_ABORT:1;
    vuint32_t FRC_SDCLK_ON:1;
    vuint32_t CLKONJ_IN_ABORT:1;
    vuint32_t WP_POL:1;
    vuint32_t CD_POL:1;
    vuint32_t DAT3_CD_POL:1;
    vuint32_t AC12_WR_CHKBUSY_EN:1;
    vuint32_t CONFLICT_CHK_EN:1;
    vuint32_t VSELECT:1;
    vuint32_t EXT_DMA_EN:1;
  } B;
} uSDHC_VEND_SPEC_tag;

typedef union uSDHC_VEND_SPEC2_union_tag { /* Vendor Specific 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t CARD_INT_AUTO_CLR_DIS:1;
    vuint32_t _unused_4:3;
    vuint32_t CARD_INT_D3_TEST:1;
    vuint32_t _unused_0:3;
  } B;
} uSDHC_VEND_SPEC2_tag;

typedef union uSDHC_HOST_CTRL_VER_union_tag { /* Host Controller Version */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t VVN:8;
    vuint32_t SVN:8;
  } B;
} uSDHC_HOST_CTRL_VER_tag;

struct uSDHC_tag {
  uSDHC_S_ADDR_tag S_ADDR;             /* DMA System Address */
  uSDHC_BLK_ATT_tag BLK_ATT;           /* Block Attributes */
  uSDHC_CMD_ARG_tag CMD_ARG;           /* Command Argument */
  uSDHC_CMD_XFR_TYP_tag CMD_XFR_TYP;   /* Command Transfer Type */
  uSDHC_CMD_RSP0_tag CMD_RSP0;         /* Command Response0 */
  uSDHC_CMD_RSP1_tag CMD_RSP1;         /* Command Response1 */
  uSDHC_CMD_RSP2_tag CMD_RSP2;         /* Command Response2 */
  uSDHC_CMD_RSP3_tag CMD_RSP3;         /* Command Response3 */
  uSDHC_DATA_BUFF_ACC_PORT_tag DATA_BUFF_ACC_PORT; /* Data Buffer Access Port */
  uSDHC_PRES_STATE_tag PRES_STATE;     /* Present State */
  uSDHC_PROT_CTRL_tag PROT_CTRL;       /* Protocol Control */
  uSDHC_SYS_CTRL_tag SYS_CTRL;         /* System Control */
  uSDHC_INT_STATUS_tag INT_STATUS;     /* Interrupt Status */
  uSDHC_INT_STATUS_EN_tag INT_STATUS_EN; /* Interrupt Status Enable */
  uSDHC_INT_SIGNAL_EN_tag INT_SIGNAL_EN; /* Interrupt Signal Enable */
  uSDHC_AUTOCMD12_ERR_STATUS_tag AUTOCMD12_ERR_STATUS; /* Auto CMD12 Error Status */
  uSDHC_HOST_CTRL_CAP_tag HOST_CTRL_CAP; /* Host Controller Capabilities */
  uSDHC_WTMK_LVL_tag WTMK_LVL;         /* Watermark Level */
  uSDHC_MIX_CTRL_tag MIX_CTRL;         /* Mixer Control */
  uint8_t uSDHC_reserved0[4];
  uSDHC_FORCE_EVENT_tag FORCE_EVENT;   /* Force Event */
  uSDHC_ADMA_ERR_STATUS_tag ADMA_ERR_STATUS; /* ADMA Error Status Register */
  uSDHC_ADMA_SYS_ADDR_tag ADMA_SYS_ADDR; /* ADMA System Address */
  uint8_t uSDHC_reserved1[100];
  uSDHC_VEND_SPEC_tag VEND_SPEC;       /* Vendor Specific Register */
  uint8_t uSDHC_reserved2[4];
  uSDHC_VEND_SPEC2_tag VEND_SPEC2;     /* Vendor Specific 2 Register */
  uint8_t uSDHC_reserved3[48];
  uSDHC_HOST_CTRL_VER_tag HOST_CTRL_VER; /* Host Controller Version */
};

#define SRAM0_START 0x40000000UL;
#define ADC_0 (*(volatile struct ADC_tag *) 0xFFE00000UL)
#define ADC_1 (*(volatile struct ADC_tag *) 0xFBE00000UL)
#define AIPS_A (*(volatile struct AIPS_tag *) 0xFC000000UL)
#define AIPS_B (*(volatile struct AIPS_tag *) 0xF8000000UL)
#define AXBS_0 (*(volatile struct AXBS_tag *) 0xFC004000UL)
#define AXBS_1 (*(volatile struct AXBS_tag *) 0xFC008000UL)
#define BCTU (*(volatile struct BCTU_tag *) 0xFFC10000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CAN_0 (*(volatile struct CAN_0_tag *) 0xFFEC0000UL)
#define CAN_1 (*(volatile struct CAN_1_7_tag *) 0xFBEC0000UL)
#define CAN_2 (*(volatile struct CAN_1_7_tag *) 0xFFEC4000UL)
#define CAN_3 (*(volatile struct CAN_1_7_tag *) 0xFBEC4000UL)
#define CAN_4 (*(volatile struct CAN_1_7_tag *) 0xFFEC8000UL)
#define CAN_5 (*(volatile struct CAN_1_7_tag *) 0xFBEC8000UL)
#define CAN_6 (*(volatile struct CAN_1_7_tag *) 0xFFECC000UL)
#define CAN_7 (*(volatile struct CAN_1_7_tag *) 0xFBECC000UL)
#define CMP_0 (*(volatile struct CMP_tag *) 0xFFCDC000UL)
#define CMP_1 (*(volatile struct CMP_tag *) 0xFFCE0000UL)
#define CMP_2 (*(volatile struct CMP_tag *) 0xFFCE4000UL)
#define CMU (*(volatile struct CMU_tag *) 0xFFFB0140UL)
#define CRC (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define EDMA (*(volatile struct DMA_tag *) 0xFC0A0000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFFF6C200UL)
#define DSPI_0 (*(volatile struct DSPI_tag *) 0xFFE70000UL)
#define DSPI_1 (*(volatile struct DSPI_tag *) 0xFBE70000UL)
#define DSPI_2 (*(volatile struct DSPI_tag *) 0xFFE74000UL)
#define DSPI_3 (*(volatile struct DSPI_tag *) 0xFBE74000UL)
#define ENET_0 (*(volatile struct ENET_tag *) 0xFFCC4000UL)
#define ENET_1 (*(volatile struct ENET_tag *) 0xFFCC8000UL)
#define ESW_0 (*(volatile struct ESW_tag *) 0xFFCCC000UL)
#define ESW_1 (*(volatile struct ESW_tag *) 0xFFCD0000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FIRC (*(volatile struct FIRC_tag *) 0xFFFB0000UL)
#define FR (*(volatile struct FR_tag *) 0xFFE50000UL)
#define GPR (*(volatile struct GPR_tag *) 0xFFF94000UL)
#define I2C_0 (*(volatile struct I2C_tag *) 0xFFE68000UL)
#define I2C_1 (*(volatile struct I2C_tag *) 0xFBE68000UL)
#define I2C_2 (*(volatile struct I2C_tag *) 0xFFE6C000UL)
#define I2C_3 (*(volatile struct I2C_tag *) 0xFBE6C000UL)
#define I2S_0 (*(volatile struct I2S_tag *) 0xFFCB4000UL)
#define I2S_1 (*(volatile struct I2S_tag *) 0xFBCB4000UL)
#define I2S_2 (*(volatile struct I2S_tag *) 0xFFCB8000UL)
#define INTC (*(volatile struct INTC_tag *) 0xFC040000UL)
#define JDC (*(volatile struct JDC_tag *) 0xFFF3C000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFFE8C000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFBE8C000UL)
#define LINFlexD_10 (*(volatile struct LINFlexD_tag *) 0xFFEA0000UL)
#define LINFlexD_11 (*(volatile struct LINFlexD_tag *) 0xFBEA0000UL)
#define LINFlexD_12 (*(volatile struct LINFlexD_tag *) 0xFFEA4000UL)
#define LINFlexD_13 (*(volatile struct LINFlexD_tag *) 0xFBEA4000UL)
#define LINFlexD_14 (*(volatile struct LINFlexD_tag *) 0xFFEA8000UL)
#define LINFlexD_15 (*(volatile struct LINFlexD_tag *) 0xFBEA8000UL)
#define LINFlexD_16 (*(volatile struct LINFlexD_tag *) 0xFFEAC000UL)
#define LINFlexD_17 (*(volatile struct LINFlexD_tag *) 0xFBEAC000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define LINFlexD_3 (*(volatile struct LINFlexD_tag *) 0xFBE90000UL)
#define LINFlexD_4 (*(volatile struct LINFlexD_tag *) 0xFFE94000UL)
#define LINFlexD_5 (*(volatile struct LINFlexD_tag *) 0xFBE94000UL)
#define LINFlexD_6 (*(volatile struct LINFlexD_tag *) 0xFFE98000UL)
#define LINFlexD_7 (*(volatile struct LINFlexD_tag *) 0xFBE98000UL)
#define LINFlexD_8 (*(volatile struct LINFlexD_tag *) 0xFFE9C000UL)
#define LINFlexD_9 (*(volatile struct LINFlexD_tag *) 0xFBE9C000UL)
#define LPU (*(volatile struct LPU_tag *) 0xFFF9C000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0xFFFA8000UL)
#define MEMU_0 (*(volatile struct MEMU_0_tag *) 0xFFF50000UL)
#define MEMU_1 (*(volatile struct MEMU_1_tag *) 0xFFFEC000UL)
#define MLB (*(volatile struct MLB_tag *) 0xFFC9C000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0080UL)
#define PMCDIG (*(volatile struct PMCDIG_tag *) 0xFFFA0400UL)
#define PRAMC_0 (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define PRAMC_1 (*(volatile struct PRAMC_tag *) 0xFC024000UL)
#define PRAMC_2 (*(volatile struct PRAMC_tag *) 0xFC02C000UL)
#define RTC (*(volatile struct RTC_tag *) 0xFFFF0000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIRC (*(volatile struct SIRC_tag *) 0xFFFB00C0UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU_0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU_1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SPI_0 (*(volatile struct SPI_tag *) 0xFFFCC000UL)
#define SPI_1 (*(volatile struct SPI_tag *) 0xFBF9C000UL)
#define SPI_2 (*(volatile struct SPI_tag *) 0xFFFD0000UL)
#define SPI_3 (*(volatile struct SPI_tag *) 0xFBFA0000UL)
#define SPI_4 (*(volatile struct SPI_tag *) 0xFFFD4000UL)
#define SPI_5 (*(volatile struct SPI_tag *) 0xFBFA4000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define STM_2 (*(volatile struct STM_tag *) 0xFC070000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SWT_2 (*(volatile struct SWT_tag *) 0xFC058000UL)
#define SXOSC (*(volatile struct SXOSC_tag *) 0xFFFB0100UL)
#define TDM (*(volatile struct TDM_tag *) 0xFFF34000UL)
#define UHST (*(volatile struct UHST_tag *) 0xFFC94000UL)
#define UHSTNC (*(volatile struct UHSTNC_tag *) 0xFFC94000UL)
#define UOTG (*(volatile struct UOTG_tag *) 0xFFC90000UL)
#define UOTGNC (*(volatile struct UOTGNC_tag *) 0xFFC90000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define XOSC (*(volatile struct XOSC_tag *) 0xFFFB0040UL)
#define eMIOS_0 (*(volatile struct eMIOS_tag *) 0xFFC38000UL)
#define eMIOS_1 (*(volatile struct eMIOS_tag *) 0xFBC38000UL)
#define eMIOS_2 (*(volatile struct eMIOS_tag *) 0xFFC3C000UL)
#define eMIOS_UC_0 (*(volatile struct eMIOS_UC_tag *) 0xFFC38000UL)
#define eMIOS_UC_1 (*(volatile struct eMIOS_UC_tag *) 0xFBC38000UL)
#define eMIOS_UC_2 (*(volatile struct eMIOS_UC_tag *) 0xFFC3C000UL)
#define uSDHC (*(volatile struct uSDHC_tag *) 0xFFCA4000UL)

/* ADC */
#define ADC_0_MCR            ADC_0.MCR.R                   /* Main Configuration Register */
#define ADC_0_MSR            ADC_0.MSR.R                   /* Main Status register */
#define ADC_0_ISR            ADC_0.ISR.R                   /* Interrupt Status Register */
#define ADC_0_CEOCFR0        ADC_0.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_0_CEOCFR1        ADC_0.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_0_CEOCFR2        ADC_0.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_0_IMR            ADC_0.IMR.R                   /* Interrupt Mask Register */
#define ADC_0_CIMR0          ADC_0.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_0_CIMR1          ADC_0.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_0_CIMR2          ADC_0.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_0_WTISR          ADC_0.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_0_WTIMR          ADC_0.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_0_DMAE           ADC_0.DMAE.R                  /* DMA Enable register */
#define ADC_0_DMAR0          ADC_0.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_0_DMAR1          ADC_0.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_0_DMAR2          ADC_0.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_0_THRHLR0        ADC_0.THRHLR0.R               /* Threshold Register */
#define ADC_0_THRHLR1        ADC_0.THRHLR1.R               /* Threshold Register */
#define ADC_0_THRHLR2        ADC_0.THRHLR2.R               /* Threshold Register */
#define ADC_0_THRHLR3        ADC_0.THRHLR3.R               /* Threshold Register */
#define ADC_0_PSCR           ADC_0.PSCR.R                  /* Presampling Control Register */
#define ADC_0_PSR0           ADC_0.PSR0.R                  /* Presampling register 0 */
#define ADC_0_PSR1           ADC_0.PSR1.R                  /* Presampling register 1 */
#define ADC_0_PSR2           ADC_0.PSR2.R                  /* Presampling register 2 */
#define ADC_0_CTR0           ADC_0.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_0_CTR1           ADC_0.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_0_CTR2           ADC_0.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_0_NCMR0          ADC_0.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_0_NCMR1          ADC_0.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_0_NCMR2          ADC_0.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_0_JCMR0          ADC_0.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_0_JCMR1          ADC_0.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_0_JCMR2          ADC_0.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_0_DSDR           ADC_0.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_0_PDEDR          ADC_0.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_0_CDR0           ADC_0.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR1           ADC_0.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR2           ADC_0.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR3           ADC_0.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR4           ADC_0.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR5           ADC_0.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR6           ADC_0.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR7           ADC_0.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR8           ADC_0.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR9           ADC_0.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR10          ADC_0.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR11          ADC_0.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR12          ADC_0.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR13          ADC_0.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR14          ADC_0.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR15          ADC_0.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR16          ADC_0.CDR[16].R               /*  */
#define ADC_0_CDR17          ADC_0.CDR[17].R               /*  */
#define ADC_0_CDR18          ADC_0.CDR[18].R               /*  */
#define ADC_0_CDR19          ADC_0.CDR[19].R               /*  */
#define ADC_0_CDR20          ADC_0.CDR[20].R               /*  */
#define ADC_0_CDR21          ADC_0.CDR[21].R               /*  */
#define ADC_0_CDR22          ADC_0.CDR[22].R               /*  */
#define ADC_0_CDR23          ADC_0.CDR[23].R               /*  */
#define ADC_0_CDR24          ADC_0.CDR[24].R               /*  */
#define ADC_0_CDR25          ADC_0.CDR[25].R               /*  */
#define ADC_0_CDR26          ADC_0.CDR[26].R               /*  */
#define ADC_0_CDR27          ADC_0.CDR[27].R               /*  */
#define ADC_0_CDR28          ADC_0.CDR[28].R               /*  */
#define ADC_0_CDR29          ADC_0.CDR[29].R               /*  */
#define ADC_0_CDR30          ADC_0.CDR[30].R               /*  */
#define ADC_0_CDR31          ADC_0.CDR[31].R               /*  */
#define ADC_0_CDR32          ADC_0.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR33          ADC_0.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR34          ADC_0.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR35          ADC_0.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR36          ADC_0.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR37          ADC_0.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR38          ADC_0.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR39          ADC_0.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR40          ADC_0.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR41          ADC_0.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR42          ADC_0.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR43          ADC_0.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR44          ADC_0.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR45          ADC_0.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR46          ADC_0.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR47          ADC_0.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR48          ADC_0.CDR[48].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR49          ADC_0.CDR[49].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR50          ADC_0.CDR[50].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR51          ADC_0.CDR[51].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR52          ADC_0.CDR[52].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR53          ADC_0.CDR[53].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR54          ADC_0.CDR[54].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR55          ADC_0.CDR[55].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR56          ADC_0.CDR[56].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR57          ADC_0.CDR[57].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR58          ADC_0.CDR[58].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR59          ADC_0.CDR[59].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR60          ADC_0.CDR[60].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR61          ADC_0.CDR[61].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR62          ADC_0.CDR[62].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR63          ADC_0.CDR[63].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR64          ADC_0.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR65          ADC_0.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR66          ADC_0.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR67          ADC_0.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR68          ADC_0.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR69          ADC_0.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR70          ADC_0.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR71          ADC_0.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR72          ADC_0.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR73          ADC_0.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR74          ADC_0.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR75          ADC_0.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR76          ADC_0.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR77          ADC_0.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR78          ADC_0.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR79          ADC_0.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR80          ADC_0.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR81          ADC_0.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR82          ADC_0.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR83          ADC_0.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR84          ADC_0.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR85          ADC_0.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR86          ADC_0.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR87          ADC_0.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR88          ADC_0.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR89          ADC_0.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR90          ADC_0.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR91          ADC_0.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR92          ADC_0.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR93          ADC_0.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR94          ADC_0.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR95          ADC_0.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_0_THRHLR4        ADC_0.THRHLR4.R               /* Threshold Register */
#define ADC_0_THRHLR5        ADC_0.THRHLR5.R               /* Threshold Register */
#define ADC_0_CWSELR0        ADC_0.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_0_CWSELR1        ADC_0.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_0_CWSELR4        ADC_0.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_0_CWSELR5        ADC_0.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_0_CWSELR6        ADC_0.CWSELR6.R               /* Channel Watchdog Select Register 6 */
#define ADC_0_CWSELR7        ADC_0.CWSELR7.R               /* Channel Watchdog Select Register 7 */
#define ADC_0_CWSELR8        ADC_0.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_0_CWSELR9        ADC_0.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_0_CWSELR10       ADC_0.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_0_CWSELR11       ADC_0.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_0_CWENR0         ADC_0.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_0_CWENR1         ADC_0.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_0_CWENR2         ADC_0.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_0_AWORR0         ADC_0.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_0_AWORR1         ADC_0.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_0_AWORR2         ADC_0.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_0_CALBISTREG     ADC_0.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_0_OFSGNUSR       ADC_0.OFSGNUSR.R              /* Offset and Gain User Register */

#define ADC_1_MCR            ADC_1.MCR.R                   /* Main Configuration Register */
#define ADC_1_MSR            ADC_1.MSR.R                   /* Main Status register */
#define ADC_1_ISR            ADC_1.ISR.R                   /* Interrupt Status Register */
#define ADC_1_CEOCFR0        ADC_1.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_1_CEOCFR1        ADC_1.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_1_CEOCFR2        ADC_1.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_1_IMR            ADC_1.IMR.R                   /* Interrupt Mask Register */
#define ADC_1_CIMR0          ADC_1.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_1_CIMR1          ADC_1.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_1_CIMR2          ADC_1.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_1_WTISR          ADC_1.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_1_WTIMR          ADC_1.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_1_DMAE           ADC_1.DMAE.R                  /* DMA Enable register */
#define ADC_1_DMAR0          ADC_1.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_1_DMAR1          ADC_1.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_1_DMAR2          ADC_1.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_1_THRHLR0        ADC_1.THRHLR0.R               /* Threshold Register */
#define ADC_1_THRHLR1        ADC_1.THRHLR1.R               /* Threshold Register */
#define ADC_1_THRHLR2        ADC_1.THRHLR2.R               /* Threshold Register */
#define ADC_1_THRHLR3        ADC_1.THRHLR3.R               /* Threshold Register */
#define ADC_1_PSCR           ADC_1.PSCR.R                  /* Presampling Control Register */
#define ADC_1_PSR0           ADC_1.PSR0.R                  /* Presampling register 0 */
#define ADC_1_PSR1           ADC_1.PSR1.R                  /* Presampling register 1 */
#define ADC_1_PSR2           ADC_1.PSR2.R                  /* Presampling register 2 */
#define ADC_1_CTR0           ADC_1.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_1_CTR1           ADC_1.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_1_CTR2           ADC_1.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_1_NCMR0          ADC_1.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_1_NCMR1          ADC_1.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_1_NCMR2          ADC_1.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_1_JCMR0          ADC_1.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_1_JCMR1          ADC_1.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_1_JCMR2          ADC_1.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_1_DSDR           ADC_1.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_1_PDEDR          ADC_1.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_1_CDR0           ADC_1.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR1           ADC_1.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR2           ADC_1.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR3           ADC_1.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR4           ADC_1.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR5           ADC_1.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR6           ADC_1.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR7           ADC_1.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR8           ADC_1.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR9           ADC_1.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR10          ADC_1.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR11          ADC_1.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR12          ADC_1.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR13          ADC_1.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR14          ADC_1.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR15          ADC_1.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR16          ADC_1.CDR[16].R               /*  */
#define ADC_1_CDR17          ADC_1.CDR[17].R               /*  */
#define ADC_1_CDR18          ADC_1.CDR[18].R               /*  */
#define ADC_1_CDR19          ADC_1.CDR[19].R               /*  */
#define ADC_1_CDR20          ADC_1.CDR[20].R               /*  */
#define ADC_1_CDR21          ADC_1.CDR[21].R               /*  */
#define ADC_1_CDR22          ADC_1.CDR[22].R               /*  */
#define ADC_1_CDR23          ADC_1.CDR[23].R               /*  */
#define ADC_1_CDR24          ADC_1.CDR[24].R               /*  */
#define ADC_1_CDR25          ADC_1.CDR[25].R               /*  */
#define ADC_1_CDR26          ADC_1.CDR[26].R               /*  */
#define ADC_1_CDR27          ADC_1.CDR[27].R               /*  */
#define ADC_1_CDR28          ADC_1.CDR[28].R               /*  */
#define ADC_1_CDR29          ADC_1.CDR[29].R               /*  */
#define ADC_1_CDR30          ADC_1.CDR[30].R               /*  */
#define ADC_1_CDR31          ADC_1.CDR[31].R               /*  */
#define ADC_1_CDR32          ADC_1.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR33          ADC_1.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR34          ADC_1.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR35          ADC_1.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR36          ADC_1.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR37          ADC_1.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR38          ADC_1.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR39          ADC_1.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR40          ADC_1.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR41          ADC_1.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR42          ADC_1.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR43          ADC_1.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR44          ADC_1.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR45          ADC_1.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR46          ADC_1.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR47          ADC_1.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR48          ADC_1.CDR[48].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR49          ADC_1.CDR[49].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR50          ADC_1.CDR[50].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR51          ADC_1.CDR[51].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR52          ADC_1.CDR[52].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR53          ADC_1.CDR[53].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR54          ADC_1.CDR[54].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR55          ADC_1.CDR[55].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR56          ADC_1.CDR[56].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR57          ADC_1.CDR[57].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR58          ADC_1.CDR[58].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR59          ADC_1.CDR[59].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR60          ADC_1.CDR[60].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR61          ADC_1.CDR[61].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR62          ADC_1.CDR[62].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR63          ADC_1.CDR[63].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR64          ADC_1.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR65          ADC_1.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR66          ADC_1.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR67          ADC_1.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR68          ADC_1.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR69          ADC_1.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR70          ADC_1.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR71          ADC_1.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR72          ADC_1.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR73          ADC_1.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR74          ADC_1.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR75          ADC_1.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR76          ADC_1.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR77          ADC_1.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR78          ADC_1.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR79          ADC_1.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR80          ADC_1.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR81          ADC_1.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR82          ADC_1.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR83          ADC_1.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR84          ADC_1.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR85          ADC_1.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR86          ADC_1.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR87          ADC_1.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR88          ADC_1.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR89          ADC_1.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR90          ADC_1.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR91          ADC_1.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR92          ADC_1.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR93          ADC_1.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR94          ADC_1.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR95          ADC_1.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_1_THRHLR4        ADC_1.THRHLR4.R               /* Threshold Register */
#define ADC_1_THRHLR5        ADC_1.THRHLR5.R               /* Threshold Register */
#define ADC_1_CWSELR0        ADC_1.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_1_CWSELR1        ADC_1.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_1_CWSELR4        ADC_1.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_1_CWSELR5        ADC_1.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_1_CWSELR6        ADC_1.CWSELR6.R               /* Channel Watchdog Select Register 6 */
#define ADC_1_CWSELR7        ADC_1.CWSELR7.R               /* Channel Watchdog Select Register 7 */
#define ADC_1_CWSELR8        ADC_1.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_1_CWSELR9        ADC_1.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_1_CWSELR10       ADC_1.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_1_CWSELR11       ADC_1.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_1_CWENR0         ADC_1.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_1_CWENR1         ADC_1.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_1_CWENR2         ADC_1.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_1_AWORR0         ADC_1.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_1_AWORR1         ADC_1.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_1_AWORR2         ADC_1.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_1_CALBISTREG     ADC_1.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_1_OFSGNUSR       ADC_1.OFSGNUSR.R              /* Offset and Gain User Register */

/* AIPS */
#define AIPS_A_MPRA          AIPS_A.MPRA.R                 /* Master Privilege Register A */
#define AIPS_A_MPRB          AIPS_A.MPRB.R                 /* Master Privilege Register B */
#define AIPS_A_PACRA         AIPS_A.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRB         AIPS_A.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRC         AIPS_A.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRD         AIPS_A.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRE         AIPS_A.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRF         AIPS_A.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRG         AIPS_A.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRH         AIPS_A.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_A_OPACRA        AIPS_A.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRB        AIPS_A.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRC        AIPS_A.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRD        AIPS_A.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRE        AIPS_A.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRF        AIPS_A.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRG        AIPS_A.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRH        AIPS_A.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRI        AIPS_A.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRJ        AIPS_A.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRK        AIPS_A.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRL        AIPS_A.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRM        AIPS_A.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRN        AIPS_A.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRO        AIPS_A.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRP        AIPS_A.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRQ        AIPS_A.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRR        AIPS_A.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRS        AIPS_A.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRT        AIPS_A.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRU        AIPS_A.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRV        AIPS_A.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRW        AIPS_A.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRX        AIPS_A.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRY        AIPS_A.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRZ        AIPS_A.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAA       AIPS_A.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAB       AIPS_A.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAC       AIPS_A.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAD       AIPS_A.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAE       AIPS_A.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAF       AIPS_A.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

#define AIPS_B_MPRA          AIPS_B.MPRA.R                 /* Master Privilege Register A */
#define AIPS_B_MPRB          AIPS_B.MPRB.R                 /* Master Privilege Register B */
#define AIPS_B_PACRA         AIPS_B.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRB         AIPS_B.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRC         AIPS_B.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRD         AIPS_B.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRE         AIPS_B.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRF         AIPS_B.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRG         AIPS_B.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRH         AIPS_B.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_B_OPACRA        AIPS_B.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRB        AIPS_B.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRC        AIPS_B.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRD        AIPS_B.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRE        AIPS_B.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRF        AIPS_B.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRG        AIPS_B.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRH        AIPS_B.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRI        AIPS_B.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRJ        AIPS_B.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRK        AIPS_B.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRL        AIPS_B.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRM        AIPS_B.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRN        AIPS_B.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRO        AIPS_B.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRP        AIPS_B.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRQ        AIPS_B.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRR        AIPS_B.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRS        AIPS_B.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRT        AIPS_B.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRU        AIPS_B.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRV        AIPS_B.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRW        AIPS_B.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRX        AIPS_B.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRY        AIPS_B.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRZ        AIPS_B.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAA       AIPS_B.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAB       AIPS_B.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAC       AIPS_B.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAD       AIPS_B.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAE       AIPS_B.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAF       AIPS_B.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* AXBS */
#define AXBS_0_PRS0          AXBS_0.PORT[0].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS0          AXBS_0.PORT[0].CRS.R          /* Control Register */
#define AXBS_0_PRS1          AXBS_0.PORT[1].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS1          AXBS_0.PORT[1].CRS.R          /* Control Register */
#define AXBS_0_PRS2          AXBS_0.PORT[2].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS2          AXBS_0.PORT[2].CRS.R          /* Control Register */
#define AXBS_0_PRS3          AXBS_0.PORT[3].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS3          AXBS_0.PORT[3].CRS.R          /* Control Register */
#define AXBS_0_PRS4          AXBS_0.PORT[4].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS4          AXBS_0.PORT[4].CRS.R          /* Control Register */
#define AXBS_0_PRS5          AXBS_0.PORT[5].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS5          AXBS_0.PORT[5].CRS.R          /* Control Register */
#define AXBS_0_PRS6          AXBS_0.PORT[6].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS6          AXBS_0.PORT[6].CRS.R          /* Control Register */
#define AXBS_0_PRS7          AXBS_0.PORT[7].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS7          AXBS_0.PORT[7].CRS.R          /* Control Register */
#define AXBS_0_MGPCR0        AXBS_0.MGPCR[0].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR1        AXBS_0.MGPCR[1].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR2        AXBS_0.MGPCR[2].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR3        AXBS_0.MGPCR[3].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR4        AXBS_0.MGPCR[4].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR5        AXBS_0.MGPCR[5].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR6        AXBS_0.MGPCR[6].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR7        AXBS_0.MGPCR[7].MGPCR.R       /* Master General Purpose Control Register */

#define AXBS_1_PRS0          AXBS_1.PORT[0].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS0          AXBS_1.PORT[0].CRS.R          /* Control Register */
#define AXBS_1_PRS1          AXBS_1.PORT[1].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS1          AXBS_1.PORT[1].CRS.R          /* Control Register */
#define AXBS_1_PRS2          AXBS_1.PORT[2].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS2          AXBS_1.PORT[2].CRS.R          /* Control Register */
#define AXBS_1_PRS3          AXBS_1.PORT[3].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS3          AXBS_1.PORT[3].CRS.R          /* Control Register */
#define AXBS_1_PRS4          AXBS_1.PORT[4].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS4          AXBS_1.PORT[4].CRS.R          /* Control Register */
#define AXBS_1_PRS5          AXBS_1.PORT[5].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS5          AXBS_1.PORT[5].CRS.R          /* Control Register */
#define AXBS_1_PRS6          AXBS_1.PORT[6].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS6          AXBS_1.PORT[6].CRS.R          /* Control Register */
#define AXBS_1_PRS7          AXBS_1.PORT[7].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS7          AXBS_1.PORT[7].CRS.R          /* Control Register */
#define AXBS_1_MGPCR0        AXBS_1.MGPCR[0].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR1        AXBS_1.MGPCR[1].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR2        AXBS_1.MGPCR[2].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR3        AXBS_1.MGPCR[3].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR4        AXBS_1.MGPCR[4].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR5        AXBS_1.MGPCR[5].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR6        AXBS_1.MGPCR[6].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR7        AXBS_1.MGPCR[7].MGPCR.R       /* Master General Purpose Control Register */

/* BCTU */
#define BCTU_MCR             BCTU.MCR.R                    /* Module Configuration Register */
#define BCTU_MSR             BCTU.MSR.R                    /* Module Status register */
#define BCTU_TRGCFG_0        BCTU.TRGCFG[0].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_1        BCTU.TRGCFG[1].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_2        BCTU.TRGCFG[2].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_3        BCTU.TRGCFG[3].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_4        BCTU.TRGCFG[4].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_5        BCTU.TRGCFG[5].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_6        BCTU.TRGCFG[6].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_7        BCTU.TRGCFG[7].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_8        BCTU.TRGCFG[8].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_9        BCTU.TRGCFG[9].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_10       BCTU.TRGCFG[10].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_11       BCTU.TRGCFG[11].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_12       BCTU.TRGCFG[12].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_13       BCTU.TRGCFG[13].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_14       BCTU.TRGCFG[14].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_15       BCTU.TRGCFG[15].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_16       BCTU.TRGCFG[16].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_17       BCTU.TRGCFG[17].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_18       BCTU.TRGCFG[18].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_19       BCTU.TRGCFG[19].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_20       BCTU.TRGCFG[20].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_21       BCTU.TRGCFG[21].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_22       BCTU.TRGCFG[22].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_23       BCTU.TRGCFG[23].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_24       BCTU.TRGCFG[24].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_25       BCTU.TRGCFG[25].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_26       BCTU.TRGCFG[26].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_27       BCTU.TRGCFG[27].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_28       BCTU.TRGCFG[28].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_29       BCTU.TRGCFG[29].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_30       BCTU.TRGCFG[30].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_31       BCTU.TRGCFG[31].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_32       BCTU.TRGCFG[32].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_33       BCTU.TRGCFG[33].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_34       BCTU.TRGCFG[34].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_35       BCTU.TRGCFG[35].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_36       BCTU.TRGCFG[36].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_37       BCTU.TRGCFG[37].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_38       BCTU.TRGCFG[38].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_39       BCTU.TRGCFG[39].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_40       BCTU.TRGCFG[40].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_41       BCTU.TRGCFG[41].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_42       BCTU.TRGCFG[42].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_43       BCTU.TRGCFG[43].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_44       BCTU.TRGCFG[44].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_45       BCTU.TRGCFG[45].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_46       BCTU.TRGCFG[46].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_47       BCTU.TRGCFG[47].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_48       BCTU.TRGCFG[48].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_49       BCTU.TRGCFG[49].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_50       BCTU.TRGCFG[50].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_51       BCTU.TRGCFG[51].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_52       BCTU.TRGCFG[52].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_53       BCTU.TRGCFG[53].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_54       BCTU.TRGCFG[54].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_55       BCTU.TRGCFG[55].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_56       BCTU.TRGCFG[56].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_57       BCTU.TRGCFG[57].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_58       BCTU.TRGCFG[58].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_59       BCTU.TRGCFG[59].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_60       BCTU.TRGCFG[60].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_61       BCTU.TRGCFG[61].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_62       BCTU.TRGCFG[62].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_63       BCTU.TRGCFG[63].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_64       BCTU.TRGCFG[64].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_65       BCTU.TRGCFG[65].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_66       BCTU.TRGCFG[66].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_67       BCTU.TRGCFG[67].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_68       BCTU.TRGCFG[68].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_69       BCTU.TRGCFG[69].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_70       BCTU.TRGCFG[70].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_71       BCTU.TRGCFG[71].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_72       BCTU.TRGCFG[72].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_73       BCTU.TRGCFG[73].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_74       BCTU.TRGCFG[74].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_75       BCTU.TRGCFG[75].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_76       BCTU.TRGCFG[76].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_77       BCTU.TRGCFG[77].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_78       BCTU.TRGCFG[78].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_79       BCTU.TRGCFG[79].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_80       BCTU.TRGCFG[80].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_81       BCTU.TRGCFG[81].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_82       BCTU.TRGCFG[82].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_83       BCTU.TRGCFG[83].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_84       BCTU.TRGCFG[84].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_85       BCTU.TRGCFG[85].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_86       BCTU.TRGCFG[86].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_87       BCTU.TRGCFG[87].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_88       BCTU.TRGCFG[88].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_89       BCTU.TRGCFG[89].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_90       BCTU.TRGCFG[90].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_91       BCTU.TRGCFG[91].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_92       BCTU.TRGCFG[92].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_93       BCTU.TRGCFG[93].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_94       BCTU.TRGCFG[94].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_95       BCTU.TRGCFG[95].R             /* Trigger Configuration Register */
#define BCTU_WRPROT          BCTU.WRPROT.R                 /* Write Protection register */
#define BCTU_SFTRGR1         BCTU.SFTRGR1.R                /* Software Trigger register 1 */
#define BCTU_SFTRGR2         BCTU.SFTRGR2.R                /* Software Trigger register 1 */
#define BCTU_SFTRGR3         BCTU.SFTRGR3.R                /* Software Trigger register 1 */
#define BCTU_ADC0DR          BCTU.ADC0DR.R                 /* ADC0 Result Data register */
#define BCTU_ADC1DR          BCTU.ADC1DR.R                 /* ADC1 result data register */
#define BCTU_LISTSTAR        BCTU.LISTSTAR.R               /* LIST Size Status register */
#define BCTU_LISTCHR_0       BCTU.LISTCHR[0].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_1       BCTU.LISTCHR[1].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_2       BCTU.LISTCHR[2].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_3       BCTU.LISTCHR[3].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_4       BCTU.LISTCHR[4].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_5       BCTU.LISTCHR[5].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_6       BCTU.LISTCHR[6].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_7       BCTU.LISTCHR[7].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_8       BCTU.LISTCHR[8].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_9       BCTU.LISTCHR[9].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_10      BCTU.LISTCHR[10].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_11      BCTU.LISTCHR[11].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_12      BCTU.LISTCHR[12].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_13      BCTU.LISTCHR[13].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_14      BCTU.LISTCHR[14].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_15      BCTU.LISTCHR[15].R            /* LIST Channel Address Register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */
#define C55FMC_TMD           C55FMC.TMD.R                  /* Test Mode Disable Password Check register */

/* CAN_0 */
#define CAN_0_MCR            CAN_0.MCR.R                   /* Module Configuration Register */
#define CAN_0_CTRL1          CAN_0.CTRL1.R                 /* Control 1 register */
#define CAN_0_TIMER          CAN_0.TIMER.R                 /* Free Running Timer */
#define CAN_0_RXMGMASK       CAN_0.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_0_RX14MASK       CAN_0.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_0_RX15MASK       CAN_0.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_0_ECR            CAN_0.ECR.R                   /* Error Counter */
#define CAN_0_ESR1           CAN_0.ESR1.R                  /* Error and Status 1 register */
#define CAN_0_IMASK2         CAN_0.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_0_IMASK1         CAN_0.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_0_IFLAG2         CAN_0.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_0_IFLAG1         CAN_0.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_0_CTRL2          CAN_0.CTRL2.R                 /* Control 2 register */
#define CAN_0_ESR2           CAN_0.ESR2.R                  /* Error and Status 2 register */
#define CAN_0_CRCR           CAN_0.CRCR.R                  /* CRC Register */
#define CAN_0_RXFGMASK       CAN_0.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_0_RXFIR          CAN_0.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_0_CBT            CAN_0.CBT.R                   /* CAN Bit Timing Register */
#define CAN_0_IMASK3         CAN_0.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_0_IFLAG3         CAN_0.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_0_EmbeddedRAM0   CAN_0.RAMn[0].R               /* Embedded RAM */
#define CAN_0_EmbeddedRAM1   CAN_0.RAMn[1].R               /* Embedded RAM */
#define CAN_0_EmbeddedRAM2   CAN_0.RAMn[2].R               /* Embedded RAM */
#define CAN_0_EmbeddedRAM3   CAN_0.RAMn[3].R               /* Embedded RAM */
#define CAN_0_EmbeddedRAM4   CAN_0.RAMn[4].R               /* Embedded RAM */
#define CAN_0_EmbeddedRAM5   CAN_0.RAMn[5].R               /* Embedded RAM */
#define CAN_0_EmbeddedRAM6   CAN_0.RAMn[6].R               /* Embedded RAM */
#define CAN_0_EmbeddedRAM7   CAN_0.RAMn[7].R               /* Embedded RAM */
#define CAN_0_EmbeddedRAM8   CAN_0.RAMn[8].R               /* Embedded RAM */
#define CAN_0_EmbeddedRAM9   CAN_0.RAMn[9].R               /* Embedded RAM */
#define CAN_0_EmbeddedRAM10  CAN_0.RAMn[10].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM11  CAN_0.RAMn[11].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM12  CAN_0.RAMn[12].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM13  CAN_0.RAMn[13].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM14  CAN_0.RAMn[14].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM15  CAN_0.RAMn[15].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM16  CAN_0.RAMn[16].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM17  CAN_0.RAMn[17].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM18  CAN_0.RAMn[18].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM19  CAN_0.RAMn[19].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM20  CAN_0.RAMn[20].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM21  CAN_0.RAMn[21].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM22  CAN_0.RAMn[22].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM23  CAN_0.RAMn[23].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM24  CAN_0.RAMn[24].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM25  CAN_0.RAMn[25].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM26  CAN_0.RAMn[26].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM27  CAN_0.RAMn[27].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM28  CAN_0.RAMn[28].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM29  CAN_0.RAMn[29].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM30  CAN_0.RAMn[30].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM31  CAN_0.RAMn[31].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM32  CAN_0.RAMn[32].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM33  CAN_0.RAMn[33].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM34  CAN_0.RAMn[34].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM35  CAN_0.RAMn[35].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM36  CAN_0.RAMn[36].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM37  CAN_0.RAMn[37].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM38  CAN_0.RAMn[38].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM39  CAN_0.RAMn[39].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM40  CAN_0.RAMn[40].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM41  CAN_0.RAMn[41].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM42  CAN_0.RAMn[42].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM43  CAN_0.RAMn[43].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM44  CAN_0.RAMn[44].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM45  CAN_0.RAMn[45].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM46  CAN_0.RAMn[46].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM47  CAN_0.RAMn[47].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM48  CAN_0.RAMn[48].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM49  CAN_0.RAMn[49].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM50  CAN_0.RAMn[50].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM51  CAN_0.RAMn[51].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM52  CAN_0.RAMn[52].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM53  CAN_0.RAMn[53].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM54  CAN_0.RAMn[54].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM55  CAN_0.RAMn[55].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM56  CAN_0.RAMn[56].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM57  CAN_0.RAMn[57].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM58  CAN_0.RAMn[58].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM59  CAN_0.RAMn[59].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM60  CAN_0.RAMn[60].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM61  CAN_0.RAMn[61].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM62  CAN_0.RAMn[62].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM63  CAN_0.RAMn[63].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM64  CAN_0.RAMn[64].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM65  CAN_0.RAMn[65].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM66  CAN_0.RAMn[66].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM67  CAN_0.RAMn[67].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM68  CAN_0.RAMn[68].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM69  CAN_0.RAMn[69].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM70  CAN_0.RAMn[70].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM71  CAN_0.RAMn[71].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM72  CAN_0.RAMn[72].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM73  CAN_0.RAMn[73].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM74  CAN_0.RAMn[74].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM75  CAN_0.RAMn[75].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM76  CAN_0.RAMn[76].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM77  CAN_0.RAMn[77].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM78  CAN_0.RAMn[78].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM79  CAN_0.RAMn[79].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM80  CAN_0.RAMn[80].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM81  CAN_0.RAMn[81].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM82  CAN_0.RAMn[82].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM83  CAN_0.RAMn[83].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM84  CAN_0.RAMn[84].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM85  CAN_0.RAMn[85].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM86  CAN_0.RAMn[86].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM87  CAN_0.RAMn[87].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM88  CAN_0.RAMn[88].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM89  CAN_0.RAMn[89].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM90  CAN_0.RAMn[90].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM91  CAN_0.RAMn[91].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM92  CAN_0.RAMn[92].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM93  CAN_0.RAMn[93].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM94  CAN_0.RAMn[94].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM95  CAN_0.RAMn[95].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM96  CAN_0.RAMn[96].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM97  CAN_0.RAMn[97].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM98  CAN_0.RAMn[98].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM99  CAN_0.RAMn[99].R              /* Embedded RAM */
#define CAN_0_EmbeddedRAM100 CAN_0.RAMn[100].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM101 CAN_0.RAMn[101].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM102 CAN_0.RAMn[102].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM103 CAN_0.RAMn[103].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM104 CAN_0.RAMn[104].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM105 CAN_0.RAMn[105].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM106 CAN_0.RAMn[106].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM107 CAN_0.RAMn[107].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM108 CAN_0.RAMn[108].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM109 CAN_0.RAMn[109].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM110 CAN_0.RAMn[110].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM111 CAN_0.RAMn[111].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM112 CAN_0.RAMn[112].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM113 CAN_0.RAMn[113].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM114 CAN_0.RAMn[114].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM115 CAN_0.RAMn[115].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM116 CAN_0.RAMn[116].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM117 CAN_0.RAMn[117].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM118 CAN_0.RAMn[118].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM119 CAN_0.RAMn[119].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM120 CAN_0.RAMn[120].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM121 CAN_0.RAMn[121].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM122 CAN_0.RAMn[122].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM123 CAN_0.RAMn[123].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM124 CAN_0.RAMn[124].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM125 CAN_0.RAMn[125].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM126 CAN_0.RAMn[126].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM127 CAN_0.RAMn[127].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM128 CAN_0.RAMn[128].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM129 CAN_0.RAMn[129].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM130 CAN_0.RAMn[130].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM131 CAN_0.RAMn[131].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM132 CAN_0.RAMn[132].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM133 CAN_0.RAMn[133].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM134 CAN_0.RAMn[134].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM135 CAN_0.RAMn[135].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM136 CAN_0.RAMn[136].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM137 CAN_0.RAMn[137].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM138 CAN_0.RAMn[138].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM139 CAN_0.RAMn[139].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM140 CAN_0.RAMn[140].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM141 CAN_0.RAMn[141].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM142 CAN_0.RAMn[142].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM143 CAN_0.RAMn[143].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM144 CAN_0.RAMn[144].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM145 CAN_0.RAMn[145].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM146 CAN_0.RAMn[146].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM147 CAN_0.RAMn[147].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM148 CAN_0.RAMn[148].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM149 CAN_0.RAMn[149].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM150 CAN_0.RAMn[150].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM151 CAN_0.RAMn[151].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM152 CAN_0.RAMn[152].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM153 CAN_0.RAMn[153].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM154 CAN_0.RAMn[154].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM155 CAN_0.RAMn[155].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM156 CAN_0.RAMn[156].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM157 CAN_0.RAMn[157].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM158 CAN_0.RAMn[158].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM159 CAN_0.RAMn[159].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM160 CAN_0.RAMn[160].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM161 CAN_0.RAMn[161].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM162 CAN_0.RAMn[162].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM163 CAN_0.RAMn[163].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM164 CAN_0.RAMn[164].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM165 CAN_0.RAMn[165].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM166 CAN_0.RAMn[166].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM167 CAN_0.RAMn[167].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM168 CAN_0.RAMn[168].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM169 CAN_0.RAMn[169].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM170 CAN_0.RAMn[170].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM171 CAN_0.RAMn[171].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM172 CAN_0.RAMn[172].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM173 CAN_0.RAMn[173].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM174 CAN_0.RAMn[174].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM175 CAN_0.RAMn[175].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM176 CAN_0.RAMn[176].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM177 CAN_0.RAMn[177].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM178 CAN_0.RAMn[178].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM179 CAN_0.RAMn[179].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM180 CAN_0.RAMn[180].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM181 CAN_0.RAMn[181].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM182 CAN_0.RAMn[182].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM183 CAN_0.RAMn[183].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM184 CAN_0.RAMn[184].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM185 CAN_0.RAMn[185].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM186 CAN_0.RAMn[186].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM187 CAN_0.RAMn[187].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM188 CAN_0.RAMn[188].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM189 CAN_0.RAMn[189].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM190 CAN_0.RAMn[190].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM191 CAN_0.RAMn[191].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM192 CAN_0.RAMn[192].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM193 CAN_0.RAMn[193].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM194 CAN_0.RAMn[194].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM195 CAN_0.RAMn[195].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM196 CAN_0.RAMn[196].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM197 CAN_0.RAMn[197].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM198 CAN_0.RAMn[198].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM199 CAN_0.RAMn[199].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM200 CAN_0.RAMn[200].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM201 CAN_0.RAMn[201].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM202 CAN_0.RAMn[202].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM203 CAN_0.RAMn[203].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM204 CAN_0.RAMn[204].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM205 CAN_0.RAMn[205].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM206 CAN_0.RAMn[206].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM207 CAN_0.RAMn[207].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM208 CAN_0.RAMn[208].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM209 CAN_0.RAMn[209].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM210 CAN_0.RAMn[210].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM211 CAN_0.RAMn[211].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM212 CAN_0.RAMn[212].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM213 CAN_0.RAMn[213].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM214 CAN_0.RAMn[214].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM215 CAN_0.RAMn[215].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM216 CAN_0.RAMn[216].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM217 CAN_0.RAMn[217].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM218 CAN_0.RAMn[218].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM219 CAN_0.RAMn[219].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM220 CAN_0.RAMn[220].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM221 CAN_0.RAMn[221].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM222 CAN_0.RAMn[222].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM223 CAN_0.RAMn[223].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM224 CAN_0.RAMn[224].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM225 CAN_0.RAMn[225].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM226 CAN_0.RAMn[226].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM227 CAN_0.RAMn[227].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM228 CAN_0.RAMn[228].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM229 CAN_0.RAMn[229].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM230 CAN_0.RAMn[230].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM231 CAN_0.RAMn[231].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM232 CAN_0.RAMn[232].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM233 CAN_0.RAMn[233].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM234 CAN_0.RAMn[234].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM235 CAN_0.RAMn[235].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM236 CAN_0.RAMn[236].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM237 CAN_0.RAMn[237].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM238 CAN_0.RAMn[238].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM239 CAN_0.RAMn[239].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM240 CAN_0.RAMn[240].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM241 CAN_0.RAMn[241].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM242 CAN_0.RAMn[242].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM243 CAN_0.RAMn[243].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM244 CAN_0.RAMn[244].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM245 CAN_0.RAMn[245].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM246 CAN_0.RAMn[246].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM247 CAN_0.RAMn[247].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM248 CAN_0.RAMn[248].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM249 CAN_0.RAMn[249].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM250 CAN_0.RAMn[250].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM251 CAN_0.RAMn[251].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM252 CAN_0.RAMn[252].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM253 CAN_0.RAMn[253].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM254 CAN_0.RAMn[254].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM255 CAN_0.RAMn[255].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM256 CAN_0.RAMn[256].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM257 CAN_0.RAMn[257].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM258 CAN_0.RAMn[258].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM259 CAN_0.RAMn[259].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM260 CAN_0.RAMn[260].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM261 CAN_0.RAMn[261].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM262 CAN_0.RAMn[262].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM263 CAN_0.RAMn[263].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM264 CAN_0.RAMn[264].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM265 CAN_0.RAMn[265].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM266 CAN_0.RAMn[266].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM267 CAN_0.RAMn[267].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM268 CAN_0.RAMn[268].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM269 CAN_0.RAMn[269].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM270 CAN_0.RAMn[270].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM271 CAN_0.RAMn[271].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM272 CAN_0.RAMn[272].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM273 CAN_0.RAMn[273].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM274 CAN_0.RAMn[274].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM275 CAN_0.RAMn[275].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM276 CAN_0.RAMn[276].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM277 CAN_0.RAMn[277].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM278 CAN_0.RAMn[278].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM279 CAN_0.RAMn[279].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM280 CAN_0.RAMn[280].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM281 CAN_0.RAMn[281].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM282 CAN_0.RAMn[282].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM283 CAN_0.RAMn[283].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM284 CAN_0.RAMn[284].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM285 CAN_0.RAMn[285].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM286 CAN_0.RAMn[286].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM287 CAN_0.RAMn[287].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM288 CAN_0.RAMn[288].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM289 CAN_0.RAMn[289].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM290 CAN_0.RAMn[290].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM291 CAN_0.RAMn[291].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM292 CAN_0.RAMn[292].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM293 CAN_0.RAMn[293].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM294 CAN_0.RAMn[294].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM295 CAN_0.RAMn[295].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM296 CAN_0.RAMn[296].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM297 CAN_0.RAMn[297].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM298 CAN_0.RAMn[298].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM299 CAN_0.RAMn[299].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM300 CAN_0.RAMn[300].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM301 CAN_0.RAMn[301].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM302 CAN_0.RAMn[302].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM303 CAN_0.RAMn[303].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM304 CAN_0.RAMn[304].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM305 CAN_0.RAMn[305].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM306 CAN_0.RAMn[306].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM307 CAN_0.RAMn[307].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM308 CAN_0.RAMn[308].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM309 CAN_0.RAMn[309].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM310 CAN_0.RAMn[310].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM311 CAN_0.RAMn[311].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM312 CAN_0.RAMn[312].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM313 CAN_0.RAMn[313].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM314 CAN_0.RAMn[314].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM315 CAN_0.RAMn[315].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM316 CAN_0.RAMn[316].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM317 CAN_0.RAMn[317].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM318 CAN_0.RAMn[318].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM319 CAN_0.RAMn[319].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM320 CAN_0.RAMn[320].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM321 CAN_0.RAMn[321].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM322 CAN_0.RAMn[322].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM323 CAN_0.RAMn[323].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM324 CAN_0.RAMn[324].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM325 CAN_0.RAMn[325].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM326 CAN_0.RAMn[326].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM327 CAN_0.RAMn[327].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM328 CAN_0.RAMn[328].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM329 CAN_0.RAMn[329].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM330 CAN_0.RAMn[330].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM331 CAN_0.RAMn[331].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM332 CAN_0.RAMn[332].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM333 CAN_0.RAMn[333].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM334 CAN_0.RAMn[334].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM335 CAN_0.RAMn[335].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM336 CAN_0.RAMn[336].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM337 CAN_0.RAMn[337].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM338 CAN_0.RAMn[338].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM339 CAN_0.RAMn[339].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM340 CAN_0.RAMn[340].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM341 CAN_0.RAMn[341].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM342 CAN_0.RAMn[342].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM343 CAN_0.RAMn[343].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM344 CAN_0.RAMn[344].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM345 CAN_0.RAMn[345].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM346 CAN_0.RAMn[346].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM347 CAN_0.RAMn[347].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM348 CAN_0.RAMn[348].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM349 CAN_0.RAMn[349].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM350 CAN_0.RAMn[350].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM351 CAN_0.RAMn[351].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM352 CAN_0.RAMn[352].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM353 CAN_0.RAMn[353].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM354 CAN_0.RAMn[354].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM355 CAN_0.RAMn[355].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM356 CAN_0.RAMn[356].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM357 CAN_0.RAMn[357].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM358 CAN_0.RAMn[358].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM359 CAN_0.RAMn[359].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM360 CAN_0.RAMn[360].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM361 CAN_0.RAMn[361].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM362 CAN_0.RAMn[362].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM363 CAN_0.RAMn[363].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM364 CAN_0.RAMn[364].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM365 CAN_0.RAMn[365].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM366 CAN_0.RAMn[366].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM367 CAN_0.RAMn[367].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM368 CAN_0.RAMn[368].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM369 CAN_0.RAMn[369].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM370 CAN_0.RAMn[370].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM371 CAN_0.RAMn[371].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM372 CAN_0.RAMn[372].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM373 CAN_0.RAMn[373].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM374 CAN_0.RAMn[374].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM375 CAN_0.RAMn[375].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM376 CAN_0.RAMn[376].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM377 CAN_0.RAMn[377].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM378 CAN_0.RAMn[378].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM379 CAN_0.RAMn[379].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM380 CAN_0.RAMn[380].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM381 CAN_0.RAMn[381].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM382 CAN_0.RAMn[382].R             /* Embedded RAM */
#define CAN_0_EmbeddedRAM383 CAN_0.RAMn[383].R             /* Embedded RAM */
#define CAN_0_RXIMR0         CAN_0.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR1         CAN_0.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR2         CAN_0.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR3         CAN_0.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR4         CAN_0.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR5         CAN_0.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR6         CAN_0.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR7         CAN_0.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR8         CAN_0.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR9         CAN_0.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR10        CAN_0.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR11        CAN_0.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR12        CAN_0.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR13        CAN_0.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR14        CAN_0.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR15        CAN_0.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR16        CAN_0.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR17        CAN_0.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR18        CAN_0.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR19        CAN_0.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR20        CAN_0.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR21        CAN_0.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR22        CAN_0.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR23        CAN_0.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR24        CAN_0.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR25        CAN_0.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR26        CAN_0.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR27        CAN_0.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR28        CAN_0.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR29        CAN_0.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR30        CAN_0.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR31        CAN_0.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR32        CAN_0.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR33        CAN_0.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR34        CAN_0.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR35        CAN_0.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR36        CAN_0.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR37        CAN_0.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR38        CAN_0.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR39        CAN_0.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR40        CAN_0.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR41        CAN_0.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR42        CAN_0.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR43        CAN_0.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR44        CAN_0.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR45        CAN_0.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR46        CAN_0.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR47        CAN_0.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR48        CAN_0.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR49        CAN_0.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR50        CAN_0.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR51        CAN_0.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR52        CAN_0.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR53        CAN_0.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR54        CAN_0.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR55        CAN_0.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR56        CAN_0.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR57        CAN_0.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR58        CAN_0.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR59        CAN_0.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR60        CAN_0.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR61        CAN_0.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR62        CAN_0.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR63        CAN_0.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR64        CAN_0.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR65        CAN_0.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR66        CAN_0.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR67        CAN_0.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR68        CAN_0.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR69        CAN_0.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR70        CAN_0.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR71        CAN_0.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR72        CAN_0.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR73        CAN_0.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR74        CAN_0.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR75        CAN_0.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR76        CAN_0.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR77        CAN_0.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR78        CAN_0.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR79        CAN_0.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR80        CAN_0.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR81        CAN_0.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR82        CAN_0.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR83        CAN_0.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR84        CAN_0.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR85        CAN_0.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR86        CAN_0.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR87        CAN_0.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR88        CAN_0.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR89        CAN_0.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR90        CAN_0.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR91        CAN_0.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR92        CAN_0.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR93        CAN_0.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR94        CAN_0.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR95        CAN_0.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_0_CTRL1_PN       CAN_0.CTRL1_PN.R              /* Pretended Networking Control 1 Register */
#define CAN_0_CTRL2_PN       CAN_0.CTRL2_PN.R              /* Pretended Networking Control 2 Register */
#define CAN_0_WU_MTC         CAN_0.WU_MTC.R                /* Pretended Networking Wake Up Match Register */
#define CAN_0_FLT_ID1        CAN_0.FLT_ID1.R               /* Pretended Networking ID Filter 1 Register */
#define CAN_0_FLT_DLC        CAN_0.FLT_DLC.R               /* Pretended Networking DLC Filter Register */
#define CAN_0_PL1_LO         CAN_0.PL1_LO.R                /* Pretended Networking Payload Low Filter 1 Register */
#define CAN_0_PL1_HI         CAN_0.PL1_HI.R                /* Pretended Networking Payload High Filter 1 Register */
#define CAN_0_FLT_ID2_IDMASK CAN_0.FLT_ID2_IDMASK.R        /* Pretended Networking ID Filter 2 Register / ID Mask Register */
#define CAN_0_PL2_PLMASK_LO  CAN_0.PL2_PLMASK_LO.R         /* Pretended Networking Payload Low Filter 2 Register / Payload Low Mask Register */
#define CAN_0_PL2_PLMASK_HI  CAN_0.PL2_PLMASK_HI.R         /* Pretended Networking Payload High Filter 2 low order bits / Payload High Mask Register */
#define CAN_0_WMB0_CS        CAN_0.WMB[0].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB0_ID        CAN_0.WMB[0].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB0_D03       CAN_0.WMB[0].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB0_D47       CAN_0.WMB[0].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_WMB1_CS        CAN_0.WMB[1].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB1_ID        CAN_0.WMB[1].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB1_D03       CAN_0.WMB[1].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB1_D47       CAN_0.WMB[1].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_WMB2_CS        CAN_0.WMB[2].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB2_ID        CAN_0.WMB[2].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB2_D03       CAN_0.WMB[2].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB2_D47       CAN_0.WMB[2].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_WMB3_CS        CAN_0.WMB[3].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB3_ID        CAN_0.WMB[3].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB3_D03       CAN_0.WMB[3].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB3_D47       CAN_0.WMB[3].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_FDCTRL         CAN_0.FDCTRL.R                /* CAN FD Control Register */
#define CAN_0_FDCBT          CAN_0.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_0_FDCRC          CAN_0.FDCRC.R                 /* CAN FD CRC Register */

/* CAN */
#define CAN_1_MCR            CAN_1.MCR.R                   /* Module Configuration Register */
#define CAN_1_CTRL1          CAN_1.CTRL1.R                 /* Control 1 register */
#define CAN_1_TIMER          CAN_1.TIMER.R                 /* Free Running Timer */
#define CAN_1_RXMGMASK       CAN_1.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_1_RX14MASK       CAN_1.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_1_RX15MASK       CAN_1.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_1_ECR            CAN_1.ECR.R                   /* Error Counter */
#define CAN_1_ESR1           CAN_1.ESR1.R                  /* Error and Status 1 register */
#define CAN_1_IMASK2         CAN_1.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_1_IMASK1         CAN_1.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_1_IFLAG2         CAN_1.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_1_IFLAG1         CAN_1.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_1_CTRL2          CAN_1.CTRL2.R                 /* Control 2 register */
#define CAN_1_ESR2           CAN_1.ESR2.R                  /* Error and Status 2 register */
#define CAN_1_CRCR           CAN_1.CRCR.R                  /* CRC Register */
#define CAN_1_RXFGMASK       CAN_1.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_1_RXFIR          CAN_1.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_1_CBT            CAN_1.CBT.R                   /* CAN Bit Timing Register */
#define CAN_1_IMASK3         CAN_1.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_1_IFLAG3         CAN_1.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_1_EmbeddedRAM0   CAN_1.RAMn[0].R               /* Embedded RAM */
#define CAN_1_EmbeddedRAM1   CAN_1.RAMn[1].R               /* Embedded RAM */
#define CAN_1_EmbeddedRAM2   CAN_1.RAMn[2].R               /* Embedded RAM */
#define CAN_1_EmbeddedRAM3   CAN_1.RAMn[3].R               /* Embedded RAM */
#define CAN_1_EmbeddedRAM4   CAN_1.RAMn[4].R               /* Embedded RAM */
#define CAN_1_EmbeddedRAM5   CAN_1.RAMn[5].R               /* Embedded RAM */
#define CAN_1_EmbeddedRAM6   CAN_1.RAMn[6].R               /* Embedded RAM */
#define CAN_1_EmbeddedRAM7   CAN_1.RAMn[7].R               /* Embedded RAM */
#define CAN_1_EmbeddedRAM8   CAN_1.RAMn[8].R               /* Embedded RAM */
#define CAN_1_EmbeddedRAM9   CAN_1.RAMn[9].R               /* Embedded RAM */
#define CAN_1_EmbeddedRAM10  CAN_1.RAMn[10].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM11  CAN_1.RAMn[11].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM12  CAN_1.RAMn[12].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM13  CAN_1.RAMn[13].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM14  CAN_1.RAMn[14].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM15  CAN_1.RAMn[15].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM16  CAN_1.RAMn[16].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM17  CAN_1.RAMn[17].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM18  CAN_1.RAMn[18].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM19  CAN_1.RAMn[19].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM20  CAN_1.RAMn[20].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM21  CAN_1.RAMn[21].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM22  CAN_1.RAMn[22].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM23  CAN_1.RAMn[23].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM24  CAN_1.RAMn[24].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM25  CAN_1.RAMn[25].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM26  CAN_1.RAMn[26].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM27  CAN_1.RAMn[27].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM28  CAN_1.RAMn[28].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM29  CAN_1.RAMn[29].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM30  CAN_1.RAMn[30].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM31  CAN_1.RAMn[31].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM32  CAN_1.RAMn[32].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM33  CAN_1.RAMn[33].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM34  CAN_1.RAMn[34].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM35  CAN_1.RAMn[35].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM36  CAN_1.RAMn[36].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM37  CAN_1.RAMn[37].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM38  CAN_1.RAMn[38].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM39  CAN_1.RAMn[39].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM40  CAN_1.RAMn[40].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM41  CAN_1.RAMn[41].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM42  CAN_1.RAMn[42].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM43  CAN_1.RAMn[43].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM44  CAN_1.RAMn[44].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM45  CAN_1.RAMn[45].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM46  CAN_1.RAMn[46].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM47  CAN_1.RAMn[47].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM48  CAN_1.RAMn[48].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM49  CAN_1.RAMn[49].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM50  CAN_1.RAMn[50].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM51  CAN_1.RAMn[51].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM52  CAN_1.RAMn[52].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM53  CAN_1.RAMn[53].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM54  CAN_1.RAMn[54].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM55  CAN_1.RAMn[55].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM56  CAN_1.RAMn[56].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM57  CAN_1.RAMn[57].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM58  CAN_1.RAMn[58].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM59  CAN_1.RAMn[59].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM60  CAN_1.RAMn[60].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM61  CAN_1.RAMn[61].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM62  CAN_1.RAMn[62].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM63  CAN_1.RAMn[63].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM64  CAN_1.RAMn[64].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM65  CAN_1.RAMn[65].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM66  CAN_1.RAMn[66].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM67  CAN_1.RAMn[67].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM68  CAN_1.RAMn[68].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM69  CAN_1.RAMn[69].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM70  CAN_1.RAMn[70].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM71  CAN_1.RAMn[71].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM72  CAN_1.RAMn[72].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM73  CAN_1.RAMn[73].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM74  CAN_1.RAMn[74].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM75  CAN_1.RAMn[75].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM76  CAN_1.RAMn[76].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM77  CAN_1.RAMn[77].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM78  CAN_1.RAMn[78].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM79  CAN_1.RAMn[79].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM80  CAN_1.RAMn[80].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM81  CAN_1.RAMn[81].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM82  CAN_1.RAMn[82].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM83  CAN_1.RAMn[83].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM84  CAN_1.RAMn[84].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM85  CAN_1.RAMn[85].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM86  CAN_1.RAMn[86].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM87  CAN_1.RAMn[87].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM88  CAN_1.RAMn[88].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM89  CAN_1.RAMn[89].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM90  CAN_1.RAMn[90].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM91  CAN_1.RAMn[91].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM92  CAN_1.RAMn[92].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM93  CAN_1.RAMn[93].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM94  CAN_1.RAMn[94].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM95  CAN_1.RAMn[95].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM96  CAN_1.RAMn[96].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM97  CAN_1.RAMn[97].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM98  CAN_1.RAMn[98].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM99  CAN_1.RAMn[99].R              /* Embedded RAM */
#define CAN_1_EmbeddedRAM100 CAN_1.RAMn[100].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM101 CAN_1.RAMn[101].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM102 CAN_1.RAMn[102].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM103 CAN_1.RAMn[103].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM104 CAN_1.RAMn[104].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM105 CAN_1.RAMn[105].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM106 CAN_1.RAMn[106].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM107 CAN_1.RAMn[107].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM108 CAN_1.RAMn[108].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM109 CAN_1.RAMn[109].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM110 CAN_1.RAMn[110].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM111 CAN_1.RAMn[111].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM112 CAN_1.RAMn[112].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM113 CAN_1.RAMn[113].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM114 CAN_1.RAMn[114].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM115 CAN_1.RAMn[115].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM116 CAN_1.RAMn[116].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM117 CAN_1.RAMn[117].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM118 CAN_1.RAMn[118].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM119 CAN_1.RAMn[119].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM120 CAN_1.RAMn[120].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM121 CAN_1.RAMn[121].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM122 CAN_1.RAMn[122].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM123 CAN_1.RAMn[123].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM124 CAN_1.RAMn[124].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM125 CAN_1.RAMn[125].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM126 CAN_1.RAMn[126].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM127 CAN_1.RAMn[127].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM128 CAN_1.RAMn[128].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM129 CAN_1.RAMn[129].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM130 CAN_1.RAMn[130].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM131 CAN_1.RAMn[131].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM132 CAN_1.RAMn[132].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM133 CAN_1.RAMn[133].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM134 CAN_1.RAMn[134].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM135 CAN_1.RAMn[135].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM136 CAN_1.RAMn[136].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM137 CAN_1.RAMn[137].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM138 CAN_1.RAMn[138].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM139 CAN_1.RAMn[139].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM140 CAN_1.RAMn[140].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM141 CAN_1.RAMn[141].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM142 CAN_1.RAMn[142].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM143 CAN_1.RAMn[143].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM144 CAN_1.RAMn[144].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM145 CAN_1.RAMn[145].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM146 CAN_1.RAMn[146].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM147 CAN_1.RAMn[147].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM148 CAN_1.RAMn[148].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM149 CAN_1.RAMn[149].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM150 CAN_1.RAMn[150].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM151 CAN_1.RAMn[151].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM152 CAN_1.RAMn[152].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM153 CAN_1.RAMn[153].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM154 CAN_1.RAMn[154].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM155 CAN_1.RAMn[155].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM156 CAN_1.RAMn[156].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM157 CAN_1.RAMn[157].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM158 CAN_1.RAMn[158].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM159 CAN_1.RAMn[159].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM160 CAN_1.RAMn[160].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM161 CAN_1.RAMn[161].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM162 CAN_1.RAMn[162].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM163 CAN_1.RAMn[163].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM164 CAN_1.RAMn[164].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM165 CAN_1.RAMn[165].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM166 CAN_1.RAMn[166].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM167 CAN_1.RAMn[167].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM168 CAN_1.RAMn[168].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM169 CAN_1.RAMn[169].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM170 CAN_1.RAMn[170].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM171 CAN_1.RAMn[171].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM172 CAN_1.RAMn[172].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM173 CAN_1.RAMn[173].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM174 CAN_1.RAMn[174].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM175 CAN_1.RAMn[175].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM176 CAN_1.RAMn[176].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM177 CAN_1.RAMn[177].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM178 CAN_1.RAMn[178].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM179 CAN_1.RAMn[179].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM180 CAN_1.RAMn[180].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM181 CAN_1.RAMn[181].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM182 CAN_1.RAMn[182].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM183 CAN_1.RAMn[183].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM184 CAN_1.RAMn[184].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM185 CAN_1.RAMn[185].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM186 CAN_1.RAMn[186].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM187 CAN_1.RAMn[187].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM188 CAN_1.RAMn[188].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM189 CAN_1.RAMn[189].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM190 CAN_1.RAMn[190].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM191 CAN_1.RAMn[191].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM192 CAN_1.RAMn[192].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM193 CAN_1.RAMn[193].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM194 CAN_1.RAMn[194].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM195 CAN_1.RAMn[195].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM196 CAN_1.RAMn[196].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM197 CAN_1.RAMn[197].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM198 CAN_1.RAMn[198].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM199 CAN_1.RAMn[199].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM200 CAN_1.RAMn[200].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM201 CAN_1.RAMn[201].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM202 CAN_1.RAMn[202].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM203 CAN_1.RAMn[203].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM204 CAN_1.RAMn[204].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM205 CAN_1.RAMn[205].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM206 CAN_1.RAMn[206].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM207 CAN_1.RAMn[207].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM208 CAN_1.RAMn[208].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM209 CAN_1.RAMn[209].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM210 CAN_1.RAMn[210].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM211 CAN_1.RAMn[211].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM212 CAN_1.RAMn[212].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM213 CAN_1.RAMn[213].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM214 CAN_1.RAMn[214].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM215 CAN_1.RAMn[215].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM216 CAN_1.RAMn[216].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM217 CAN_1.RAMn[217].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM218 CAN_1.RAMn[218].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM219 CAN_1.RAMn[219].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM220 CAN_1.RAMn[220].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM221 CAN_1.RAMn[221].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM222 CAN_1.RAMn[222].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM223 CAN_1.RAMn[223].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM224 CAN_1.RAMn[224].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM225 CAN_1.RAMn[225].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM226 CAN_1.RAMn[226].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM227 CAN_1.RAMn[227].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM228 CAN_1.RAMn[228].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM229 CAN_1.RAMn[229].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM230 CAN_1.RAMn[230].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM231 CAN_1.RAMn[231].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM232 CAN_1.RAMn[232].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM233 CAN_1.RAMn[233].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM234 CAN_1.RAMn[234].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM235 CAN_1.RAMn[235].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM236 CAN_1.RAMn[236].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM237 CAN_1.RAMn[237].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM238 CAN_1.RAMn[238].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM239 CAN_1.RAMn[239].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM240 CAN_1.RAMn[240].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM241 CAN_1.RAMn[241].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM242 CAN_1.RAMn[242].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM243 CAN_1.RAMn[243].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM244 CAN_1.RAMn[244].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM245 CAN_1.RAMn[245].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM246 CAN_1.RAMn[246].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM247 CAN_1.RAMn[247].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM248 CAN_1.RAMn[248].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM249 CAN_1.RAMn[249].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM250 CAN_1.RAMn[250].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM251 CAN_1.RAMn[251].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM252 CAN_1.RAMn[252].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM253 CAN_1.RAMn[253].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM254 CAN_1.RAMn[254].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM255 CAN_1.RAMn[255].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM256 CAN_1.RAMn[256].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM257 CAN_1.RAMn[257].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM258 CAN_1.RAMn[258].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM259 CAN_1.RAMn[259].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM260 CAN_1.RAMn[260].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM261 CAN_1.RAMn[261].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM262 CAN_1.RAMn[262].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM263 CAN_1.RAMn[263].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM264 CAN_1.RAMn[264].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM265 CAN_1.RAMn[265].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM266 CAN_1.RAMn[266].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM267 CAN_1.RAMn[267].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM268 CAN_1.RAMn[268].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM269 CAN_1.RAMn[269].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM270 CAN_1.RAMn[270].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM271 CAN_1.RAMn[271].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM272 CAN_1.RAMn[272].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM273 CAN_1.RAMn[273].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM274 CAN_1.RAMn[274].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM275 CAN_1.RAMn[275].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM276 CAN_1.RAMn[276].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM277 CAN_1.RAMn[277].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM278 CAN_1.RAMn[278].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM279 CAN_1.RAMn[279].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM280 CAN_1.RAMn[280].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM281 CAN_1.RAMn[281].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM282 CAN_1.RAMn[282].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM283 CAN_1.RAMn[283].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM284 CAN_1.RAMn[284].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM285 CAN_1.RAMn[285].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM286 CAN_1.RAMn[286].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM287 CAN_1.RAMn[287].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM288 CAN_1.RAMn[288].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM289 CAN_1.RAMn[289].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM290 CAN_1.RAMn[290].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM291 CAN_1.RAMn[291].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM292 CAN_1.RAMn[292].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM293 CAN_1.RAMn[293].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM294 CAN_1.RAMn[294].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM295 CAN_1.RAMn[295].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM296 CAN_1.RAMn[296].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM297 CAN_1.RAMn[297].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM298 CAN_1.RAMn[298].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM299 CAN_1.RAMn[299].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM300 CAN_1.RAMn[300].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM301 CAN_1.RAMn[301].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM302 CAN_1.RAMn[302].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM303 CAN_1.RAMn[303].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM304 CAN_1.RAMn[304].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM305 CAN_1.RAMn[305].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM306 CAN_1.RAMn[306].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM307 CAN_1.RAMn[307].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM308 CAN_1.RAMn[308].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM309 CAN_1.RAMn[309].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM310 CAN_1.RAMn[310].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM311 CAN_1.RAMn[311].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM312 CAN_1.RAMn[312].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM313 CAN_1.RAMn[313].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM314 CAN_1.RAMn[314].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM315 CAN_1.RAMn[315].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM316 CAN_1.RAMn[316].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM317 CAN_1.RAMn[317].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM318 CAN_1.RAMn[318].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM319 CAN_1.RAMn[319].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM320 CAN_1.RAMn[320].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM321 CAN_1.RAMn[321].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM322 CAN_1.RAMn[322].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM323 CAN_1.RAMn[323].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM324 CAN_1.RAMn[324].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM325 CAN_1.RAMn[325].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM326 CAN_1.RAMn[326].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM327 CAN_1.RAMn[327].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM328 CAN_1.RAMn[328].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM329 CAN_1.RAMn[329].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM330 CAN_1.RAMn[330].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM331 CAN_1.RAMn[331].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM332 CAN_1.RAMn[332].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM333 CAN_1.RAMn[333].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM334 CAN_1.RAMn[334].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM335 CAN_1.RAMn[335].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM336 CAN_1.RAMn[336].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM337 CAN_1.RAMn[337].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM338 CAN_1.RAMn[338].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM339 CAN_1.RAMn[339].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM340 CAN_1.RAMn[340].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM341 CAN_1.RAMn[341].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM342 CAN_1.RAMn[342].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM343 CAN_1.RAMn[343].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM344 CAN_1.RAMn[344].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM345 CAN_1.RAMn[345].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM346 CAN_1.RAMn[346].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM347 CAN_1.RAMn[347].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM348 CAN_1.RAMn[348].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM349 CAN_1.RAMn[349].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM350 CAN_1.RAMn[350].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM351 CAN_1.RAMn[351].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM352 CAN_1.RAMn[352].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM353 CAN_1.RAMn[353].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM354 CAN_1.RAMn[354].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM355 CAN_1.RAMn[355].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM356 CAN_1.RAMn[356].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM357 CAN_1.RAMn[357].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM358 CAN_1.RAMn[358].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM359 CAN_1.RAMn[359].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM360 CAN_1.RAMn[360].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM361 CAN_1.RAMn[361].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM362 CAN_1.RAMn[362].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM363 CAN_1.RAMn[363].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM364 CAN_1.RAMn[364].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM365 CAN_1.RAMn[365].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM366 CAN_1.RAMn[366].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM367 CAN_1.RAMn[367].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM368 CAN_1.RAMn[368].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM369 CAN_1.RAMn[369].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM370 CAN_1.RAMn[370].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM371 CAN_1.RAMn[371].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM372 CAN_1.RAMn[372].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM373 CAN_1.RAMn[373].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM374 CAN_1.RAMn[374].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM375 CAN_1.RAMn[375].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM376 CAN_1.RAMn[376].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM377 CAN_1.RAMn[377].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM378 CAN_1.RAMn[378].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM379 CAN_1.RAMn[379].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM380 CAN_1.RAMn[380].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM381 CAN_1.RAMn[381].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM382 CAN_1.RAMn[382].R             /* Embedded RAM */
#define CAN_1_EmbeddedRAM383 CAN_1.RAMn[383].R             /* Embedded RAM */
#define CAN_1_RXIMR0         CAN_1.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR1         CAN_1.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR2         CAN_1.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR3         CAN_1.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR4         CAN_1.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR5         CAN_1.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR6         CAN_1.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR7         CAN_1.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR8         CAN_1.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR9         CAN_1.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR10        CAN_1.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR11        CAN_1.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR12        CAN_1.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR13        CAN_1.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR14        CAN_1.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR15        CAN_1.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR16        CAN_1.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR17        CAN_1.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR18        CAN_1.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR19        CAN_1.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR20        CAN_1.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR21        CAN_1.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR22        CAN_1.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR23        CAN_1.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR24        CAN_1.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR25        CAN_1.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR26        CAN_1.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR27        CAN_1.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR28        CAN_1.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR29        CAN_1.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR30        CAN_1.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR31        CAN_1.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR32        CAN_1.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR33        CAN_1.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR34        CAN_1.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR35        CAN_1.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR36        CAN_1.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR37        CAN_1.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR38        CAN_1.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR39        CAN_1.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR40        CAN_1.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR41        CAN_1.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR42        CAN_1.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR43        CAN_1.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR44        CAN_1.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR45        CAN_1.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR46        CAN_1.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR47        CAN_1.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR48        CAN_1.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR49        CAN_1.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR50        CAN_1.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR51        CAN_1.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR52        CAN_1.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR53        CAN_1.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR54        CAN_1.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR55        CAN_1.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR56        CAN_1.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR57        CAN_1.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR58        CAN_1.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR59        CAN_1.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR60        CAN_1.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR61        CAN_1.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR62        CAN_1.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR63        CAN_1.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR64        CAN_1.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR65        CAN_1.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR66        CAN_1.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR67        CAN_1.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR68        CAN_1.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR69        CAN_1.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR70        CAN_1.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR71        CAN_1.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR72        CAN_1.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR73        CAN_1.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR74        CAN_1.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR75        CAN_1.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR76        CAN_1.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR77        CAN_1.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR78        CAN_1.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR79        CAN_1.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR80        CAN_1.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR81        CAN_1.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR82        CAN_1.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR83        CAN_1.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR84        CAN_1.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR85        CAN_1.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR86        CAN_1.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR87        CAN_1.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR88        CAN_1.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR89        CAN_1.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR90        CAN_1.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR91        CAN_1.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR92        CAN_1.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR93        CAN_1.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR94        CAN_1.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR95        CAN_1.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_1_FDCTRL         CAN_1.FDCTRL.R                /* CAN FD Control Register */
#define CAN_1_FDCBT          CAN_1.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_1_FDCRC          CAN_1.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_2_MCR            CAN_2.MCR.R                   /* Module Configuration Register */
#define CAN_2_CTRL1          CAN_2.CTRL1.R                 /* Control 1 register */
#define CAN_2_TIMER          CAN_2.TIMER.R                 /* Free Running Timer */
#define CAN_2_RXMGMASK       CAN_2.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_2_RX14MASK       CAN_2.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_2_RX15MASK       CAN_2.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_2_ECR            CAN_2.ECR.R                   /* Error Counter */
#define CAN_2_ESR1           CAN_2.ESR1.R                  /* Error and Status 1 register */
#define CAN_2_IMASK2         CAN_2.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_2_IMASK1         CAN_2.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_2_IFLAG2         CAN_2.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_2_IFLAG1         CAN_2.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_2_CTRL2          CAN_2.CTRL2.R                 /* Control 2 register */
#define CAN_2_ESR2           CAN_2.ESR2.R                  /* Error and Status 2 register */
#define CAN_2_CRCR           CAN_2.CRCR.R                  /* CRC Register */
#define CAN_2_RXFGMASK       CAN_2.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_2_RXFIR          CAN_2.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_2_CBT            CAN_2.CBT.R                   /* CAN Bit Timing Register */
#define CAN_2_IMASK3         CAN_2.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_2_IFLAG3         CAN_2.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_2_EmbeddedRAM0   CAN_2.RAMn[0].R               /* Embedded RAM */
#define CAN_2_EmbeddedRAM1   CAN_2.RAMn[1].R               /* Embedded RAM */
#define CAN_2_EmbeddedRAM2   CAN_2.RAMn[2].R               /* Embedded RAM */
#define CAN_2_EmbeddedRAM3   CAN_2.RAMn[3].R               /* Embedded RAM */
#define CAN_2_EmbeddedRAM4   CAN_2.RAMn[4].R               /* Embedded RAM */
#define CAN_2_EmbeddedRAM5   CAN_2.RAMn[5].R               /* Embedded RAM */
#define CAN_2_EmbeddedRAM6   CAN_2.RAMn[6].R               /* Embedded RAM */
#define CAN_2_EmbeddedRAM7   CAN_2.RAMn[7].R               /* Embedded RAM */
#define CAN_2_EmbeddedRAM8   CAN_2.RAMn[8].R               /* Embedded RAM */
#define CAN_2_EmbeddedRAM9   CAN_2.RAMn[9].R               /* Embedded RAM */
#define CAN_2_EmbeddedRAM10  CAN_2.RAMn[10].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM11  CAN_2.RAMn[11].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM12  CAN_2.RAMn[12].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM13  CAN_2.RAMn[13].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM14  CAN_2.RAMn[14].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM15  CAN_2.RAMn[15].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM16  CAN_2.RAMn[16].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM17  CAN_2.RAMn[17].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM18  CAN_2.RAMn[18].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM19  CAN_2.RAMn[19].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM20  CAN_2.RAMn[20].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM21  CAN_2.RAMn[21].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM22  CAN_2.RAMn[22].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM23  CAN_2.RAMn[23].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM24  CAN_2.RAMn[24].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM25  CAN_2.RAMn[25].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM26  CAN_2.RAMn[26].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM27  CAN_2.RAMn[27].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM28  CAN_2.RAMn[28].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM29  CAN_2.RAMn[29].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM30  CAN_2.RAMn[30].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM31  CAN_2.RAMn[31].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM32  CAN_2.RAMn[32].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM33  CAN_2.RAMn[33].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM34  CAN_2.RAMn[34].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM35  CAN_2.RAMn[35].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM36  CAN_2.RAMn[36].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM37  CAN_2.RAMn[37].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM38  CAN_2.RAMn[38].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM39  CAN_2.RAMn[39].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM40  CAN_2.RAMn[40].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM41  CAN_2.RAMn[41].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM42  CAN_2.RAMn[42].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM43  CAN_2.RAMn[43].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM44  CAN_2.RAMn[44].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM45  CAN_2.RAMn[45].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM46  CAN_2.RAMn[46].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM47  CAN_2.RAMn[47].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM48  CAN_2.RAMn[48].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM49  CAN_2.RAMn[49].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM50  CAN_2.RAMn[50].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM51  CAN_2.RAMn[51].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM52  CAN_2.RAMn[52].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM53  CAN_2.RAMn[53].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM54  CAN_2.RAMn[54].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM55  CAN_2.RAMn[55].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM56  CAN_2.RAMn[56].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM57  CAN_2.RAMn[57].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM58  CAN_2.RAMn[58].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM59  CAN_2.RAMn[59].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM60  CAN_2.RAMn[60].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM61  CAN_2.RAMn[61].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM62  CAN_2.RAMn[62].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM63  CAN_2.RAMn[63].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM64  CAN_2.RAMn[64].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM65  CAN_2.RAMn[65].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM66  CAN_2.RAMn[66].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM67  CAN_2.RAMn[67].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM68  CAN_2.RAMn[68].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM69  CAN_2.RAMn[69].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM70  CAN_2.RAMn[70].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM71  CAN_2.RAMn[71].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM72  CAN_2.RAMn[72].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM73  CAN_2.RAMn[73].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM74  CAN_2.RAMn[74].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM75  CAN_2.RAMn[75].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM76  CAN_2.RAMn[76].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM77  CAN_2.RAMn[77].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM78  CAN_2.RAMn[78].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM79  CAN_2.RAMn[79].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM80  CAN_2.RAMn[80].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM81  CAN_2.RAMn[81].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM82  CAN_2.RAMn[82].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM83  CAN_2.RAMn[83].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM84  CAN_2.RAMn[84].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM85  CAN_2.RAMn[85].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM86  CAN_2.RAMn[86].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM87  CAN_2.RAMn[87].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM88  CAN_2.RAMn[88].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM89  CAN_2.RAMn[89].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM90  CAN_2.RAMn[90].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM91  CAN_2.RAMn[91].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM92  CAN_2.RAMn[92].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM93  CAN_2.RAMn[93].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM94  CAN_2.RAMn[94].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM95  CAN_2.RAMn[95].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM96  CAN_2.RAMn[96].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM97  CAN_2.RAMn[97].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM98  CAN_2.RAMn[98].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM99  CAN_2.RAMn[99].R              /* Embedded RAM */
#define CAN_2_EmbeddedRAM100 CAN_2.RAMn[100].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM101 CAN_2.RAMn[101].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM102 CAN_2.RAMn[102].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM103 CAN_2.RAMn[103].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM104 CAN_2.RAMn[104].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM105 CAN_2.RAMn[105].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM106 CAN_2.RAMn[106].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM107 CAN_2.RAMn[107].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM108 CAN_2.RAMn[108].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM109 CAN_2.RAMn[109].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM110 CAN_2.RAMn[110].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM111 CAN_2.RAMn[111].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM112 CAN_2.RAMn[112].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM113 CAN_2.RAMn[113].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM114 CAN_2.RAMn[114].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM115 CAN_2.RAMn[115].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM116 CAN_2.RAMn[116].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM117 CAN_2.RAMn[117].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM118 CAN_2.RAMn[118].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM119 CAN_2.RAMn[119].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM120 CAN_2.RAMn[120].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM121 CAN_2.RAMn[121].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM122 CAN_2.RAMn[122].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM123 CAN_2.RAMn[123].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM124 CAN_2.RAMn[124].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM125 CAN_2.RAMn[125].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM126 CAN_2.RAMn[126].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM127 CAN_2.RAMn[127].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM128 CAN_2.RAMn[128].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM129 CAN_2.RAMn[129].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM130 CAN_2.RAMn[130].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM131 CAN_2.RAMn[131].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM132 CAN_2.RAMn[132].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM133 CAN_2.RAMn[133].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM134 CAN_2.RAMn[134].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM135 CAN_2.RAMn[135].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM136 CAN_2.RAMn[136].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM137 CAN_2.RAMn[137].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM138 CAN_2.RAMn[138].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM139 CAN_2.RAMn[139].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM140 CAN_2.RAMn[140].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM141 CAN_2.RAMn[141].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM142 CAN_2.RAMn[142].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM143 CAN_2.RAMn[143].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM144 CAN_2.RAMn[144].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM145 CAN_2.RAMn[145].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM146 CAN_2.RAMn[146].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM147 CAN_2.RAMn[147].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM148 CAN_2.RAMn[148].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM149 CAN_2.RAMn[149].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM150 CAN_2.RAMn[150].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM151 CAN_2.RAMn[151].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM152 CAN_2.RAMn[152].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM153 CAN_2.RAMn[153].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM154 CAN_2.RAMn[154].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM155 CAN_2.RAMn[155].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM156 CAN_2.RAMn[156].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM157 CAN_2.RAMn[157].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM158 CAN_2.RAMn[158].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM159 CAN_2.RAMn[159].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM160 CAN_2.RAMn[160].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM161 CAN_2.RAMn[161].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM162 CAN_2.RAMn[162].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM163 CAN_2.RAMn[163].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM164 CAN_2.RAMn[164].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM165 CAN_2.RAMn[165].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM166 CAN_2.RAMn[166].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM167 CAN_2.RAMn[167].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM168 CAN_2.RAMn[168].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM169 CAN_2.RAMn[169].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM170 CAN_2.RAMn[170].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM171 CAN_2.RAMn[171].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM172 CAN_2.RAMn[172].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM173 CAN_2.RAMn[173].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM174 CAN_2.RAMn[174].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM175 CAN_2.RAMn[175].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM176 CAN_2.RAMn[176].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM177 CAN_2.RAMn[177].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM178 CAN_2.RAMn[178].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM179 CAN_2.RAMn[179].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM180 CAN_2.RAMn[180].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM181 CAN_2.RAMn[181].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM182 CAN_2.RAMn[182].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM183 CAN_2.RAMn[183].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM184 CAN_2.RAMn[184].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM185 CAN_2.RAMn[185].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM186 CAN_2.RAMn[186].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM187 CAN_2.RAMn[187].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM188 CAN_2.RAMn[188].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM189 CAN_2.RAMn[189].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM190 CAN_2.RAMn[190].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM191 CAN_2.RAMn[191].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM192 CAN_2.RAMn[192].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM193 CAN_2.RAMn[193].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM194 CAN_2.RAMn[194].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM195 CAN_2.RAMn[195].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM196 CAN_2.RAMn[196].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM197 CAN_2.RAMn[197].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM198 CAN_2.RAMn[198].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM199 CAN_2.RAMn[199].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM200 CAN_2.RAMn[200].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM201 CAN_2.RAMn[201].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM202 CAN_2.RAMn[202].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM203 CAN_2.RAMn[203].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM204 CAN_2.RAMn[204].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM205 CAN_2.RAMn[205].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM206 CAN_2.RAMn[206].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM207 CAN_2.RAMn[207].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM208 CAN_2.RAMn[208].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM209 CAN_2.RAMn[209].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM210 CAN_2.RAMn[210].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM211 CAN_2.RAMn[211].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM212 CAN_2.RAMn[212].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM213 CAN_2.RAMn[213].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM214 CAN_2.RAMn[214].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM215 CAN_2.RAMn[215].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM216 CAN_2.RAMn[216].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM217 CAN_2.RAMn[217].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM218 CAN_2.RAMn[218].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM219 CAN_2.RAMn[219].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM220 CAN_2.RAMn[220].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM221 CAN_2.RAMn[221].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM222 CAN_2.RAMn[222].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM223 CAN_2.RAMn[223].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM224 CAN_2.RAMn[224].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM225 CAN_2.RAMn[225].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM226 CAN_2.RAMn[226].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM227 CAN_2.RAMn[227].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM228 CAN_2.RAMn[228].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM229 CAN_2.RAMn[229].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM230 CAN_2.RAMn[230].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM231 CAN_2.RAMn[231].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM232 CAN_2.RAMn[232].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM233 CAN_2.RAMn[233].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM234 CAN_2.RAMn[234].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM235 CAN_2.RAMn[235].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM236 CAN_2.RAMn[236].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM237 CAN_2.RAMn[237].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM238 CAN_2.RAMn[238].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM239 CAN_2.RAMn[239].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM240 CAN_2.RAMn[240].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM241 CAN_2.RAMn[241].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM242 CAN_2.RAMn[242].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM243 CAN_2.RAMn[243].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM244 CAN_2.RAMn[244].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM245 CAN_2.RAMn[245].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM246 CAN_2.RAMn[246].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM247 CAN_2.RAMn[247].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM248 CAN_2.RAMn[248].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM249 CAN_2.RAMn[249].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM250 CAN_2.RAMn[250].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM251 CAN_2.RAMn[251].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM252 CAN_2.RAMn[252].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM253 CAN_2.RAMn[253].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM254 CAN_2.RAMn[254].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM255 CAN_2.RAMn[255].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM256 CAN_2.RAMn[256].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM257 CAN_2.RAMn[257].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM258 CAN_2.RAMn[258].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM259 CAN_2.RAMn[259].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM260 CAN_2.RAMn[260].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM261 CAN_2.RAMn[261].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM262 CAN_2.RAMn[262].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM263 CAN_2.RAMn[263].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM264 CAN_2.RAMn[264].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM265 CAN_2.RAMn[265].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM266 CAN_2.RAMn[266].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM267 CAN_2.RAMn[267].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM268 CAN_2.RAMn[268].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM269 CAN_2.RAMn[269].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM270 CAN_2.RAMn[270].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM271 CAN_2.RAMn[271].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM272 CAN_2.RAMn[272].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM273 CAN_2.RAMn[273].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM274 CAN_2.RAMn[274].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM275 CAN_2.RAMn[275].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM276 CAN_2.RAMn[276].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM277 CAN_2.RAMn[277].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM278 CAN_2.RAMn[278].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM279 CAN_2.RAMn[279].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM280 CAN_2.RAMn[280].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM281 CAN_2.RAMn[281].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM282 CAN_2.RAMn[282].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM283 CAN_2.RAMn[283].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM284 CAN_2.RAMn[284].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM285 CAN_2.RAMn[285].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM286 CAN_2.RAMn[286].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM287 CAN_2.RAMn[287].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM288 CAN_2.RAMn[288].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM289 CAN_2.RAMn[289].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM290 CAN_2.RAMn[290].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM291 CAN_2.RAMn[291].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM292 CAN_2.RAMn[292].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM293 CAN_2.RAMn[293].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM294 CAN_2.RAMn[294].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM295 CAN_2.RAMn[295].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM296 CAN_2.RAMn[296].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM297 CAN_2.RAMn[297].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM298 CAN_2.RAMn[298].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM299 CAN_2.RAMn[299].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM300 CAN_2.RAMn[300].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM301 CAN_2.RAMn[301].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM302 CAN_2.RAMn[302].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM303 CAN_2.RAMn[303].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM304 CAN_2.RAMn[304].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM305 CAN_2.RAMn[305].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM306 CAN_2.RAMn[306].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM307 CAN_2.RAMn[307].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM308 CAN_2.RAMn[308].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM309 CAN_2.RAMn[309].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM310 CAN_2.RAMn[310].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM311 CAN_2.RAMn[311].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM312 CAN_2.RAMn[312].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM313 CAN_2.RAMn[313].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM314 CAN_2.RAMn[314].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM315 CAN_2.RAMn[315].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM316 CAN_2.RAMn[316].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM317 CAN_2.RAMn[317].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM318 CAN_2.RAMn[318].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM319 CAN_2.RAMn[319].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM320 CAN_2.RAMn[320].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM321 CAN_2.RAMn[321].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM322 CAN_2.RAMn[322].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM323 CAN_2.RAMn[323].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM324 CAN_2.RAMn[324].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM325 CAN_2.RAMn[325].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM326 CAN_2.RAMn[326].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM327 CAN_2.RAMn[327].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM328 CAN_2.RAMn[328].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM329 CAN_2.RAMn[329].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM330 CAN_2.RAMn[330].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM331 CAN_2.RAMn[331].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM332 CAN_2.RAMn[332].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM333 CAN_2.RAMn[333].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM334 CAN_2.RAMn[334].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM335 CAN_2.RAMn[335].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM336 CAN_2.RAMn[336].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM337 CAN_2.RAMn[337].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM338 CAN_2.RAMn[338].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM339 CAN_2.RAMn[339].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM340 CAN_2.RAMn[340].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM341 CAN_2.RAMn[341].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM342 CAN_2.RAMn[342].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM343 CAN_2.RAMn[343].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM344 CAN_2.RAMn[344].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM345 CAN_2.RAMn[345].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM346 CAN_2.RAMn[346].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM347 CAN_2.RAMn[347].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM348 CAN_2.RAMn[348].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM349 CAN_2.RAMn[349].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM350 CAN_2.RAMn[350].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM351 CAN_2.RAMn[351].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM352 CAN_2.RAMn[352].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM353 CAN_2.RAMn[353].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM354 CAN_2.RAMn[354].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM355 CAN_2.RAMn[355].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM356 CAN_2.RAMn[356].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM357 CAN_2.RAMn[357].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM358 CAN_2.RAMn[358].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM359 CAN_2.RAMn[359].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM360 CAN_2.RAMn[360].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM361 CAN_2.RAMn[361].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM362 CAN_2.RAMn[362].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM363 CAN_2.RAMn[363].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM364 CAN_2.RAMn[364].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM365 CAN_2.RAMn[365].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM366 CAN_2.RAMn[366].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM367 CAN_2.RAMn[367].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM368 CAN_2.RAMn[368].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM369 CAN_2.RAMn[369].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM370 CAN_2.RAMn[370].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM371 CAN_2.RAMn[371].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM372 CAN_2.RAMn[372].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM373 CAN_2.RAMn[373].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM374 CAN_2.RAMn[374].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM375 CAN_2.RAMn[375].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM376 CAN_2.RAMn[376].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM377 CAN_2.RAMn[377].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM378 CAN_2.RAMn[378].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM379 CAN_2.RAMn[379].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM380 CAN_2.RAMn[380].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM381 CAN_2.RAMn[381].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM382 CAN_2.RAMn[382].R             /* Embedded RAM */
#define CAN_2_EmbeddedRAM383 CAN_2.RAMn[383].R             /* Embedded RAM */
#define CAN_2_RXIMR0         CAN_2.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR1         CAN_2.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR2         CAN_2.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR3         CAN_2.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR4         CAN_2.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR5         CAN_2.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR6         CAN_2.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR7         CAN_2.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR8         CAN_2.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR9         CAN_2.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR10        CAN_2.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR11        CAN_2.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR12        CAN_2.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR13        CAN_2.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR14        CAN_2.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR15        CAN_2.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR16        CAN_2.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR17        CAN_2.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR18        CAN_2.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR19        CAN_2.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR20        CAN_2.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR21        CAN_2.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR22        CAN_2.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR23        CAN_2.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR24        CAN_2.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR25        CAN_2.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR26        CAN_2.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR27        CAN_2.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR28        CAN_2.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR29        CAN_2.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR30        CAN_2.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR31        CAN_2.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR32        CAN_2.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR33        CAN_2.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR34        CAN_2.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR35        CAN_2.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR36        CAN_2.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR37        CAN_2.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR38        CAN_2.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR39        CAN_2.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR40        CAN_2.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR41        CAN_2.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR42        CAN_2.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR43        CAN_2.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR44        CAN_2.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR45        CAN_2.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR46        CAN_2.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR47        CAN_2.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR48        CAN_2.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR49        CAN_2.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR50        CAN_2.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR51        CAN_2.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR52        CAN_2.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR53        CAN_2.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR54        CAN_2.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR55        CAN_2.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR56        CAN_2.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR57        CAN_2.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR58        CAN_2.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR59        CAN_2.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR60        CAN_2.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR61        CAN_2.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR62        CAN_2.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR63        CAN_2.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR64        CAN_2.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR65        CAN_2.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR66        CAN_2.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR67        CAN_2.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR68        CAN_2.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR69        CAN_2.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR70        CAN_2.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR71        CAN_2.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR72        CAN_2.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR73        CAN_2.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR74        CAN_2.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR75        CAN_2.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR76        CAN_2.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR77        CAN_2.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR78        CAN_2.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR79        CAN_2.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR80        CAN_2.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR81        CAN_2.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR82        CAN_2.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR83        CAN_2.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR84        CAN_2.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR85        CAN_2.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR86        CAN_2.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR87        CAN_2.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR88        CAN_2.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR89        CAN_2.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR90        CAN_2.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR91        CAN_2.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR92        CAN_2.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR93        CAN_2.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR94        CAN_2.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR95        CAN_2.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_2_FDCTRL         CAN_2.FDCTRL.R                /* CAN FD Control Register */
#define CAN_2_FDCBT          CAN_2.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_2_FDCRC          CAN_2.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_3_MCR            CAN_3.MCR.R                   /* Module Configuration Register */
#define CAN_3_CTRL1          CAN_3.CTRL1.R                 /* Control 1 register */
#define CAN_3_TIMER          CAN_3.TIMER.R                 /* Free Running Timer */
#define CAN_3_RXMGMASK       CAN_3.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_3_RX14MASK       CAN_3.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_3_RX15MASK       CAN_3.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_3_ECR            CAN_3.ECR.R                   /* Error Counter */
#define CAN_3_ESR1           CAN_3.ESR1.R                  /* Error and Status 1 register */
#define CAN_3_IMASK2         CAN_3.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_3_IMASK1         CAN_3.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_3_IFLAG2         CAN_3.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_3_IFLAG1         CAN_3.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_3_CTRL2          CAN_3.CTRL2.R                 /* Control 2 register */
#define CAN_3_ESR2           CAN_3.ESR2.R                  /* Error and Status 2 register */
#define CAN_3_CRCR           CAN_3.CRCR.R                  /* CRC Register */
#define CAN_3_RXFGMASK       CAN_3.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_3_RXFIR          CAN_3.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_3_CBT            CAN_3.CBT.R                   /* CAN Bit Timing Register */
#define CAN_3_IMASK3         CAN_3.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_3_IFLAG3         CAN_3.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_3_EmbeddedRAM0   CAN_3.RAMn[0].R               /* Embedded RAM */
#define CAN_3_EmbeddedRAM1   CAN_3.RAMn[1].R               /* Embedded RAM */
#define CAN_3_EmbeddedRAM2   CAN_3.RAMn[2].R               /* Embedded RAM */
#define CAN_3_EmbeddedRAM3   CAN_3.RAMn[3].R               /* Embedded RAM */
#define CAN_3_EmbeddedRAM4   CAN_3.RAMn[4].R               /* Embedded RAM */
#define CAN_3_EmbeddedRAM5   CAN_3.RAMn[5].R               /* Embedded RAM */
#define CAN_3_EmbeddedRAM6   CAN_3.RAMn[6].R               /* Embedded RAM */
#define CAN_3_EmbeddedRAM7   CAN_3.RAMn[7].R               /* Embedded RAM */
#define CAN_3_EmbeddedRAM8   CAN_3.RAMn[8].R               /* Embedded RAM */
#define CAN_3_EmbeddedRAM9   CAN_3.RAMn[9].R               /* Embedded RAM */
#define CAN_3_EmbeddedRAM10  CAN_3.RAMn[10].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM11  CAN_3.RAMn[11].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM12  CAN_3.RAMn[12].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM13  CAN_3.RAMn[13].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM14  CAN_3.RAMn[14].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM15  CAN_3.RAMn[15].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM16  CAN_3.RAMn[16].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM17  CAN_3.RAMn[17].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM18  CAN_3.RAMn[18].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM19  CAN_3.RAMn[19].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM20  CAN_3.RAMn[20].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM21  CAN_3.RAMn[21].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM22  CAN_3.RAMn[22].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM23  CAN_3.RAMn[23].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM24  CAN_3.RAMn[24].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM25  CAN_3.RAMn[25].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM26  CAN_3.RAMn[26].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM27  CAN_3.RAMn[27].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM28  CAN_3.RAMn[28].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM29  CAN_3.RAMn[29].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM30  CAN_3.RAMn[30].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM31  CAN_3.RAMn[31].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM32  CAN_3.RAMn[32].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM33  CAN_3.RAMn[33].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM34  CAN_3.RAMn[34].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM35  CAN_3.RAMn[35].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM36  CAN_3.RAMn[36].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM37  CAN_3.RAMn[37].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM38  CAN_3.RAMn[38].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM39  CAN_3.RAMn[39].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM40  CAN_3.RAMn[40].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM41  CAN_3.RAMn[41].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM42  CAN_3.RAMn[42].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM43  CAN_3.RAMn[43].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM44  CAN_3.RAMn[44].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM45  CAN_3.RAMn[45].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM46  CAN_3.RAMn[46].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM47  CAN_3.RAMn[47].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM48  CAN_3.RAMn[48].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM49  CAN_3.RAMn[49].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM50  CAN_3.RAMn[50].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM51  CAN_3.RAMn[51].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM52  CAN_3.RAMn[52].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM53  CAN_3.RAMn[53].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM54  CAN_3.RAMn[54].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM55  CAN_3.RAMn[55].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM56  CAN_3.RAMn[56].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM57  CAN_3.RAMn[57].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM58  CAN_3.RAMn[58].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM59  CAN_3.RAMn[59].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM60  CAN_3.RAMn[60].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM61  CAN_3.RAMn[61].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM62  CAN_3.RAMn[62].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM63  CAN_3.RAMn[63].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM64  CAN_3.RAMn[64].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM65  CAN_3.RAMn[65].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM66  CAN_3.RAMn[66].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM67  CAN_3.RAMn[67].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM68  CAN_3.RAMn[68].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM69  CAN_3.RAMn[69].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM70  CAN_3.RAMn[70].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM71  CAN_3.RAMn[71].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM72  CAN_3.RAMn[72].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM73  CAN_3.RAMn[73].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM74  CAN_3.RAMn[74].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM75  CAN_3.RAMn[75].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM76  CAN_3.RAMn[76].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM77  CAN_3.RAMn[77].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM78  CAN_3.RAMn[78].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM79  CAN_3.RAMn[79].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM80  CAN_3.RAMn[80].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM81  CAN_3.RAMn[81].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM82  CAN_3.RAMn[82].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM83  CAN_3.RAMn[83].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM84  CAN_3.RAMn[84].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM85  CAN_3.RAMn[85].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM86  CAN_3.RAMn[86].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM87  CAN_3.RAMn[87].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM88  CAN_3.RAMn[88].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM89  CAN_3.RAMn[89].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM90  CAN_3.RAMn[90].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM91  CAN_3.RAMn[91].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM92  CAN_3.RAMn[92].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM93  CAN_3.RAMn[93].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM94  CAN_3.RAMn[94].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM95  CAN_3.RAMn[95].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM96  CAN_3.RAMn[96].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM97  CAN_3.RAMn[97].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM98  CAN_3.RAMn[98].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM99  CAN_3.RAMn[99].R              /* Embedded RAM */
#define CAN_3_EmbeddedRAM100 CAN_3.RAMn[100].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM101 CAN_3.RAMn[101].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM102 CAN_3.RAMn[102].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM103 CAN_3.RAMn[103].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM104 CAN_3.RAMn[104].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM105 CAN_3.RAMn[105].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM106 CAN_3.RAMn[106].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM107 CAN_3.RAMn[107].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM108 CAN_3.RAMn[108].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM109 CAN_3.RAMn[109].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM110 CAN_3.RAMn[110].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM111 CAN_3.RAMn[111].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM112 CAN_3.RAMn[112].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM113 CAN_3.RAMn[113].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM114 CAN_3.RAMn[114].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM115 CAN_3.RAMn[115].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM116 CAN_3.RAMn[116].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM117 CAN_3.RAMn[117].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM118 CAN_3.RAMn[118].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM119 CAN_3.RAMn[119].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM120 CAN_3.RAMn[120].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM121 CAN_3.RAMn[121].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM122 CAN_3.RAMn[122].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM123 CAN_3.RAMn[123].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM124 CAN_3.RAMn[124].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM125 CAN_3.RAMn[125].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM126 CAN_3.RAMn[126].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM127 CAN_3.RAMn[127].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM128 CAN_3.RAMn[128].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM129 CAN_3.RAMn[129].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM130 CAN_3.RAMn[130].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM131 CAN_3.RAMn[131].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM132 CAN_3.RAMn[132].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM133 CAN_3.RAMn[133].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM134 CAN_3.RAMn[134].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM135 CAN_3.RAMn[135].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM136 CAN_3.RAMn[136].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM137 CAN_3.RAMn[137].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM138 CAN_3.RAMn[138].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM139 CAN_3.RAMn[139].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM140 CAN_3.RAMn[140].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM141 CAN_3.RAMn[141].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM142 CAN_3.RAMn[142].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM143 CAN_3.RAMn[143].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM144 CAN_3.RAMn[144].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM145 CAN_3.RAMn[145].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM146 CAN_3.RAMn[146].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM147 CAN_3.RAMn[147].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM148 CAN_3.RAMn[148].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM149 CAN_3.RAMn[149].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM150 CAN_3.RAMn[150].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM151 CAN_3.RAMn[151].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM152 CAN_3.RAMn[152].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM153 CAN_3.RAMn[153].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM154 CAN_3.RAMn[154].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM155 CAN_3.RAMn[155].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM156 CAN_3.RAMn[156].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM157 CAN_3.RAMn[157].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM158 CAN_3.RAMn[158].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM159 CAN_3.RAMn[159].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM160 CAN_3.RAMn[160].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM161 CAN_3.RAMn[161].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM162 CAN_3.RAMn[162].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM163 CAN_3.RAMn[163].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM164 CAN_3.RAMn[164].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM165 CAN_3.RAMn[165].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM166 CAN_3.RAMn[166].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM167 CAN_3.RAMn[167].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM168 CAN_3.RAMn[168].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM169 CAN_3.RAMn[169].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM170 CAN_3.RAMn[170].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM171 CAN_3.RAMn[171].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM172 CAN_3.RAMn[172].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM173 CAN_3.RAMn[173].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM174 CAN_3.RAMn[174].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM175 CAN_3.RAMn[175].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM176 CAN_3.RAMn[176].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM177 CAN_3.RAMn[177].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM178 CAN_3.RAMn[178].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM179 CAN_3.RAMn[179].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM180 CAN_3.RAMn[180].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM181 CAN_3.RAMn[181].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM182 CAN_3.RAMn[182].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM183 CAN_3.RAMn[183].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM184 CAN_3.RAMn[184].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM185 CAN_3.RAMn[185].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM186 CAN_3.RAMn[186].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM187 CAN_3.RAMn[187].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM188 CAN_3.RAMn[188].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM189 CAN_3.RAMn[189].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM190 CAN_3.RAMn[190].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM191 CAN_3.RAMn[191].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM192 CAN_3.RAMn[192].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM193 CAN_3.RAMn[193].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM194 CAN_3.RAMn[194].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM195 CAN_3.RAMn[195].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM196 CAN_3.RAMn[196].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM197 CAN_3.RAMn[197].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM198 CAN_3.RAMn[198].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM199 CAN_3.RAMn[199].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM200 CAN_3.RAMn[200].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM201 CAN_3.RAMn[201].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM202 CAN_3.RAMn[202].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM203 CAN_3.RAMn[203].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM204 CAN_3.RAMn[204].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM205 CAN_3.RAMn[205].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM206 CAN_3.RAMn[206].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM207 CAN_3.RAMn[207].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM208 CAN_3.RAMn[208].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM209 CAN_3.RAMn[209].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM210 CAN_3.RAMn[210].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM211 CAN_3.RAMn[211].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM212 CAN_3.RAMn[212].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM213 CAN_3.RAMn[213].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM214 CAN_3.RAMn[214].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM215 CAN_3.RAMn[215].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM216 CAN_3.RAMn[216].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM217 CAN_3.RAMn[217].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM218 CAN_3.RAMn[218].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM219 CAN_3.RAMn[219].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM220 CAN_3.RAMn[220].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM221 CAN_3.RAMn[221].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM222 CAN_3.RAMn[222].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM223 CAN_3.RAMn[223].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM224 CAN_3.RAMn[224].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM225 CAN_3.RAMn[225].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM226 CAN_3.RAMn[226].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM227 CAN_3.RAMn[227].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM228 CAN_3.RAMn[228].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM229 CAN_3.RAMn[229].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM230 CAN_3.RAMn[230].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM231 CAN_3.RAMn[231].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM232 CAN_3.RAMn[232].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM233 CAN_3.RAMn[233].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM234 CAN_3.RAMn[234].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM235 CAN_3.RAMn[235].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM236 CAN_3.RAMn[236].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM237 CAN_3.RAMn[237].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM238 CAN_3.RAMn[238].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM239 CAN_3.RAMn[239].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM240 CAN_3.RAMn[240].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM241 CAN_3.RAMn[241].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM242 CAN_3.RAMn[242].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM243 CAN_3.RAMn[243].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM244 CAN_3.RAMn[244].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM245 CAN_3.RAMn[245].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM246 CAN_3.RAMn[246].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM247 CAN_3.RAMn[247].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM248 CAN_3.RAMn[248].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM249 CAN_3.RAMn[249].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM250 CAN_3.RAMn[250].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM251 CAN_3.RAMn[251].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM252 CAN_3.RAMn[252].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM253 CAN_3.RAMn[253].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM254 CAN_3.RAMn[254].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM255 CAN_3.RAMn[255].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM256 CAN_3.RAMn[256].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM257 CAN_3.RAMn[257].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM258 CAN_3.RAMn[258].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM259 CAN_3.RAMn[259].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM260 CAN_3.RAMn[260].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM261 CAN_3.RAMn[261].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM262 CAN_3.RAMn[262].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM263 CAN_3.RAMn[263].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM264 CAN_3.RAMn[264].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM265 CAN_3.RAMn[265].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM266 CAN_3.RAMn[266].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM267 CAN_3.RAMn[267].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM268 CAN_3.RAMn[268].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM269 CAN_3.RAMn[269].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM270 CAN_3.RAMn[270].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM271 CAN_3.RAMn[271].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM272 CAN_3.RAMn[272].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM273 CAN_3.RAMn[273].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM274 CAN_3.RAMn[274].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM275 CAN_3.RAMn[275].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM276 CAN_3.RAMn[276].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM277 CAN_3.RAMn[277].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM278 CAN_3.RAMn[278].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM279 CAN_3.RAMn[279].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM280 CAN_3.RAMn[280].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM281 CAN_3.RAMn[281].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM282 CAN_3.RAMn[282].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM283 CAN_3.RAMn[283].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM284 CAN_3.RAMn[284].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM285 CAN_3.RAMn[285].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM286 CAN_3.RAMn[286].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM287 CAN_3.RAMn[287].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM288 CAN_3.RAMn[288].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM289 CAN_3.RAMn[289].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM290 CAN_3.RAMn[290].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM291 CAN_3.RAMn[291].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM292 CAN_3.RAMn[292].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM293 CAN_3.RAMn[293].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM294 CAN_3.RAMn[294].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM295 CAN_3.RAMn[295].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM296 CAN_3.RAMn[296].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM297 CAN_3.RAMn[297].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM298 CAN_3.RAMn[298].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM299 CAN_3.RAMn[299].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM300 CAN_3.RAMn[300].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM301 CAN_3.RAMn[301].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM302 CAN_3.RAMn[302].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM303 CAN_3.RAMn[303].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM304 CAN_3.RAMn[304].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM305 CAN_3.RAMn[305].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM306 CAN_3.RAMn[306].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM307 CAN_3.RAMn[307].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM308 CAN_3.RAMn[308].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM309 CAN_3.RAMn[309].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM310 CAN_3.RAMn[310].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM311 CAN_3.RAMn[311].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM312 CAN_3.RAMn[312].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM313 CAN_3.RAMn[313].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM314 CAN_3.RAMn[314].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM315 CAN_3.RAMn[315].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM316 CAN_3.RAMn[316].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM317 CAN_3.RAMn[317].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM318 CAN_3.RAMn[318].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM319 CAN_3.RAMn[319].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM320 CAN_3.RAMn[320].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM321 CAN_3.RAMn[321].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM322 CAN_3.RAMn[322].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM323 CAN_3.RAMn[323].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM324 CAN_3.RAMn[324].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM325 CAN_3.RAMn[325].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM326 CAN_3.RAMn[326].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM327 CAN_3.RAMn[327].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM328 CAN_3.RAMn[328].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM329 CAN_3.RAMn[329].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM330 CAN_3.RAMn[330].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM331 CAN_3.RAMn[331].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM332 CAN_3.RAMn[332].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM333 CAN_3.RAMn[333].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM334 CAN_3.RAMn[334].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM335 CAN_3.RAMn[335].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM336 CAN_3.RAMn[336].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM337 CAN_3.RAMn[337].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM338 CAN_3.RAMn[338].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM339 CAN_3.RAMn[339].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM340 CAN_3.RAMn[340].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM341 CAN_3.RAMn[341].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM342 CAN_3.RAMn[342].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM343 CAN_3.RAMn[343].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM344 CAN_3.RAMn[344].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM345 CAN_3.RAMn[345].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM346 CAN_3.RAMn[346].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM347 CAN_3.RAMn[347].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM348 CAN_3.RAMn[348].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM349 CAN_3.RAMn[349].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM350 CAN_3.RAMn[350].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM351 CAN_3.RAMn[351].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM352 CAN_3.RAMn[352].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM353 CAN_3.RAMn[353].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM354 CAN_3.RAMn[354].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM355 CAN_3.RAMn[355].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM356 CAN_3.RAMn[356].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM357 CAN_3.RAMn[357].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM358 CAN_3.RAMn[358].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM359 CAN_3.RAMn[359].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM360 CAN_3.RAMn[360].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM361 CAN_3.RAMn[361].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM362 CAN_3.RAMn[362].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM363 CAN_3.RAMn[363].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM364 CAN_3.RAMn[364].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM365 CAN_3.RAMn[365].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM366 CAN_3.RAMn[366].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM367 CAN_3.RAMn[367].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM368 CAN_3.RAMn[368].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM369 CAN_3.RAMn[369].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM370 CAN_3.RAMn[370].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM371 CAN_3.RAMn[371].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM372 CAN_3.RAMn[372].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM373 CAN_3.RAMn[373].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM374 CAN_3.RAMn[374].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM375 CAN_3.RAMn[375].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM376 CAN_3.RAMn[376].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM377 CAN_3.RAMn[377].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM378 CAN_3.RAMn[378].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM379 CAN_3.RAMn[379].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM380 CAN_3.RAMn[380].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM381 CAN_3.RAMn[381].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM382 CAN_3.RAMn[382].R             /* Embedded RAM */
#define CAN_3_EmbeddedRAM383 CAN_3.RAMn[383].R             /* Embedded RAM */
#define CAN_3_RXIMR0         CAN_3.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR1         CAN_3.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR2         CAN_3.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR3         CAN_3.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR4         CAN_3.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR5         CAN_3.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR6         CAN_3.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR7         CAN_3.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR8         CAN_3.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR9         CAN_3.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR10        CAN_3.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR11        CAN_3.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR12        CAN_3.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR13        CAN_3.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR14        CAN_3.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR15        CAN_3.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR16        CAN_3.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR17        CAN_3.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR18        CAN_3.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR19        CAN_3.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR20        CAN_3.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR21        CAN_3.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR22        CAN_3.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR23        CAN_3.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR24        CAN_3.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR25        CAN_3.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR26        CAN_3.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR27        CAN_3.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR28        CAN_3.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR29        CAN_3.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR30        CAN_3.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR31        CAN_3.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR32        CAN_3.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR33        CAN_3.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR34        CAN_3.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR35        CAN_3.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR36        CAN_3.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR37        CAN_3.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR38        CAN_3.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR39        CAN_3.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR40        CAN_3.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR41        CAN_3.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR42        CAN_3.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR43        CAN_3.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR44        CAN_3.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR45        CAN_3.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR46        CAN_3.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR47        CAN_3.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR48        CAN_3.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR49        CAN_3.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR50        CAN_3.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR51        CAN_3.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR52        CAN_3.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR53        CAN_3.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR54        CAN_3.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR55        CAN_3.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR56        CAN_3.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR57        CAN_3.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR58        CAN_3.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR59        CAN_3.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR60        CAN_3.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR61        CAN_3.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR62        CAN_3.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR63        CAN_3.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR64        CAN_3.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR65        CAN_3.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR66        CAN_3.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR67        CAN_3.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR68        CAN_3.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR69        CAN_3.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR70        CAN_3.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR71        CAN_3.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR72        CAN_3.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR73        CAN_3.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR74        CAN_3.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR75        CAN_3.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR76        CAN_3.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR77        CAN_3.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR78        CAN_3.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR79        CAN_3.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR80        CAN_3.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR81        CAN_3.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR82        CAN_3.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR83        CAN_3.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR84        CAN_3.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR85        CAN_3.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR86        CAN_3.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR87        CAN_3.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR88        CAN_3.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR89        CAN_3.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR90        CAN_3.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR91        CAN_3.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR92        CAN_3.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR93        CAN_3.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR94        CAN_3.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR95        CAN_3.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_3_FDCTRL         CAN_3.FDCTRL.R                /* CAN FD Control Register */
#define CAN_3_FDCBT          CAN_3.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_3_FDCRC          CAN_3.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_4_MCR            CAN_4.MCR.R                   /* Module Configuration Register */
#define CAN_4_CTRL1          CAN_4.CTRL1.R                 /* Control 1 register */
#define CAN_4_TIMER          CAN_4.TIMER.R                 /* Free Running Timer */
#define CAN_4_RXMGMASK       CAN_4.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_4_RX14MASK       CAN_4.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_4_RX15MASK       CAN_4.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_4_ECR            CAN_4.ECR.R                   /* Error Counter */
#define CAN_4_ESR1           CAN_4.ESR1.R                  /* Error and Status 1 register */
#define CAN_4_IMASK2         CAN_4.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_4_IMASK1         CAN_4.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_4_IFLAG2         CAN_4.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_4_IFLAG1         CAN_4.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_4_CTRL2          CAN_4.CTRL2.R                 /* Control 2 register */
#define CAN_4_ESR2           CAN_4.ESR2.R                  /* Error and Status 2 register */
#define CAN_4_CRCR           CAN_4.CRCR.R                  /* CRC Register */
#define CAN_4_RXFGMASK       CAN_4.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_4_RXFIR          CAN_4.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_4_CBT            CAN_4.CBT.R                   /* CAN Bit Timing Register */
#define CAN_4_IMASK3         CAN_4.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_4_IFLAG3         CAN_4.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_4_EmbeddedRAM0   CAN_4.RAMn[0].R               /* Embedded RAM */
#define CAN_4_EmbeddedRAM1   CAN_4.RAMn[1].R               /* Embedded RAM */
#define CAN_4_EmbeddedRAM2   CAN_4.RAMn[2].R               /* Embedded RAM */
#define CAN_4_EmbeddedRAM3   CAN_4.RAMn[3].R               /* Embedded RAM */
#define CAN_4_EmbeddedRAM4   CAN_4.RAMn[4].R               /* Embedded RAM */
#define CAN_4_EmbeddedRAM5   CAN_4.RAMn[5].R               /* Embedded RAM */
#define CAN_4_EmbeddedRAM6   CAN_4.RAMn[6].R               /* Embedded RAM */
#define CAN_4_EmbeddedRAM7   CAN_4.RAMn[7].R               /* Embedded RAM */
#define CAN_4_EmbeddedRAM8   CAN_4.RAMn[8].R               /* Embedded RAM */
#define CAN_4_EmbeddedRAM9   CAN_4.RAMn[9].R               /* Embedded RAM */
#define CAN_4_EmbeddedRAM10  CAN_4.RAMn[10].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM11  CAN_4.RAMn[11].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM12  CAN_4.RAMn[12].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM13  CAN_4.RAMn[13].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM14  CAN_4.RAMn[14].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM15  CAN_4.RAMn[15].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM16  CAN_4.RAMn[16].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM17  CAN_4.RAMn[17].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM18  CAN_4.RAMn[18].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM19  CAN_4.RAMn[19].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM20  CAN_4.RAMn[20].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM21  CAN_4.RAMn[21].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM22  CAN_4.RAMn[22].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM23  CAN_4.RAMn[23].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM24  CAN_4.RAMn[24].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM25  CAN_4.RAMn[25].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM26  CAN_4.RAMn[26].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM27  CAN_4.RAMn[27].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM28  CAN_4.RAMn[28].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM29  CAN_4.RAMn[29].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM30  CAN_4.RAMn[30].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM31  CAN_4.RAMn[31].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM32  CAN_4.RAMn[32].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM33  CAN_4.RAMn[33].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM34  CAN_4.RAMn[34].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM35  CAN_4.RAMn[35].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM36  CAN_4.RAMn[36].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM37  CAN_4.RAMn[37].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM38  CAN_4.RAMn[38].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM39  CAN_4.RAMn[39].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM40  CAN_4.RAMn[40].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM41  CAN_4.RAMn[41].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM42  CAN_4.RAMn[42].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM43  CAN_4.RAMn[43].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM44  CAN_4.RAMn[44].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM45  CAN_4.RAMn[45].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM46  CAN_4.RAMn[46].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM47  CAN_4.RAMn[47].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM48  CAN_4.RAMn[48].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM49  CAN_4.RAMn[49].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM50  CAN_4.RAMn[50].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM51  CAN_4.RAMn[51].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM52  CAN_4.RAMn[52].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM53  CAN_4.RAMn[53].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM54  CAN_4.RAMn[54].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM55  CAN_4.RAMn[55].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM56  CAN_4.RAMn[56].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM57  CAN_4.RAMn[57].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM58  CAN_4.RAMn[58].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM59  CAN_4.RAMn[59].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM60  CAN_4.RAMn[60].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM61  CAN_4.RAMn[61].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM62  CAN_4.RAMn[62].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM63  CAN_4.RAMn[63].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM64  CAN_4.RAMn[64].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM65  CAN_4.RAMn[65].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM66  CAN_4.RAMn[66].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM67  CAN_4.RAMn[67].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM68  CAN_4.RAMn[68].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM69  CAN_4.RAMn[69].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM70  CAN_4.RAMn[70].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM71  CAN_4.RAMn[71].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM72  CAN_4.RAMn[72].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM73  CAN_4.RAMn[73].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM74  CAN_4.RAMn[74].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM75  CAN_4.RAMn[75].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM76  CAN_4.RAMn[76].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM77  CAN_4.RAMn[77].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM78  CAN_4.RAMn[78].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM79  CAN_4.RAMn[79].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM80  CAN_4.RAMn[80].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM81  CAN_4.RAMn[81].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM82  CAN_4.RAMn[82].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM83  CAN_4.RAMn[83].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM84  CAN_4.RAMn[84].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM85  CAN_4.RAMn[85].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM86  CAN_4.RAMn[86].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM87  CAN_4.RAMn[87].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM88  CAN_4.RAMn[88].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM89  CAN_4.RAMn[89].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM90  CAN_4.RAMn[90].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM91  CAN_4.RAMn[91].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM92  CAN_4.RAMn[92].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM93  CAN_4.RAMn[93].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM94  CAN_4.RAMn[94].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM95  CAN_4.RAMn[95].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM96  CAN_4.RAMn[96].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM97  CAN_4.RAMn[97].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM98  CAN_4.RAMn[98].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM99  CAN_4.RAMn[99].R              /* Embedded RAM */
#define CAN_4_EmbeddedRAM100 CAN_4.RAMn[100].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM101 CAN_4.RAMn[101].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM102 CAN_4.RAMn[102].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM103 CAN_4.RAMn[103].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM104 CAN_4.RAMn[104].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM105 CAN_4.RAMn[105].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM106 CAN_4.RAMn[106].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM107 CAN_4.RAMn[107].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM108 CAN_4.RAMn[108].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM109 CAN_4.RAMn[109].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM110 CAN_4.RAMn[110].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM111 CAN_4.RAMn[111].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM112 CAN_4.RAMn[112].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM113 CAN_4.RAMn[113].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM114 CAN_4.RAMn[114].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM115 CAN_4.RAMn[115].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM116 CAN_4.RAMn[116].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM117 CAN_4.RAMn[117].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM118 CAN_4.RAMn[118].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM119 CAN_4.RAMn[119].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM120 CAN_4.RAMn[120].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM121 CAN_4.RAMn[121].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM122 CAN_4.RAMn[122].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM123 CAN_4.RAMn[123].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM124 CAN_4.RAMn[124].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM125 CAN_4.RAMn[125].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM126 CAN_4.RAMn[126].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM127 CAN_4.RAMn[127].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM128 CAN_4.RAMn[128].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM129 CAN_4.RAMn[129].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM130 CAN_4.RAMn[130].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM131 CAN_4.RAMn[131].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM132 CAN_4.RAMn[132].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM133 CAN_4.RAMn[133].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM134 CAN_4.RAMn[134].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM135 CAN_4.RAMn[135].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM136 CAN_4.RAMn[136].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM137 CAN_4.RAMn[137].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM138 CAN_4.RAMn[138].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM139 CAN_4.RAMn[139].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM140 CAN_4.RAMn[140].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM141 CAN_4.RAMn[141].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM142 CAN_4.RAMn[142].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM143 CAN_4.RAMn[143].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM144 CAN_4.RAMn[144].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM145 CAN_4.RAMn[145].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM146 CAN_4.RAMn[146].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM147 CAN_4.RAMn[147].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM148 CAN_4.RAMn[148].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM149 CAN_4.RAMn[149].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM150 CAN_4.RAMn[150].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM151 CAN_4.RAMn[151].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM152 CAN_4.RAMn[152].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM153 CAN_4.RAMn[153].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM154 CAN_4.RAMn[154].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM155 CAN_4.RAMn[155].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM156 CAN_4.RAMn[156].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM157 CAN_4.RAMn[157].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM158 CAN_4.RAMn[158].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM159 CAN_4.RAMn[159].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM160 CAN_4.RAMn[160].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM161 CAN_4.RAMn[161].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM162 CAN_4.RAMn[162].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM163 CAN_4.RAMn[163].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM164 CAN_4.RAMn[164].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM165 CAN_4.RAMn[165].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM166 CAN_4.RAMn[166].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM167 CAN_4.RAMn[167].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM168 CAN_4.RAMn[168].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM169 CAN_4.RAMn[169].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM170 CAN_4.RAMn[170].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM171 CAN_4.RAMn[171].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM172 CAN_4.RAMn[172].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM173 CAN_4.RAMn[173].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM174 CAN_4.RAMn[174].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM175 CAN_4.RAMn[175].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM176 CAN_4.RAMn[176].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM177 CAN_4.RAMn[177].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM178 CAN_4.RAMn[178].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM179 CAN_4.RAMn[179].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM180 CAN_4.RAMn[180].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM181 CAN_4.RAMn[181].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM182 CAN_4.RAMn[182].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM183 CAN_4.RAMn[183].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM184 CAN_4.RAMn[184].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM185 CAN_4.RAMn[185].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM186 CAN_4.RAMn[186].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM187 CAN_4.RAMn[187].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM188 CAN_4.RAMn[188].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM189 CAN_4.RAMn[189].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM190 CAN_4.RAMn[190].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM191 CAN_4.RAMn[191].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM192 CAN_4.RAMn[192].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM193 CAN_4.RAMn[193].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM194 CAN_4.RAMn[194].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM195 CAN_4.RAMn[195].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM196 CAN_4.RAMn[196].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM197 CAN_4.RAMn[197].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM198 CAN_4.RAMn[198].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM199 CAN_4.RAMn[199].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM200 CAN_4.RAMn[200].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM201 CAN_4.RAMn[201].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM202 CAN_4.RAMn[202].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM203 CAN_4.RAMn[203].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM204 CAN_4.RAMn[204].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM205 CAN_4.RAMn[205].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM206 CAN_4.RAMn[206].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM207 CAN_4.RAMn[207].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM208 CAN_4.RAMn[208].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM209 CAN_4.RAMn[209].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM210 CAN_4.RAMn[210].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM211 CAN_4.RAMn[211].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM212 CAN_4.RAMn[212].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM213 CAN_4.RAMn[213].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM214 CAN_4.RAMn[214].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM215 CAN_4.RAMn[215].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM216 CAN_4.RAMn[216].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM217 CAN_4.RAMn[217].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM218 CAN_4.RAMn[218].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM219 CAN_4.RAMn[219].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM220 CAN_4.RAMn[220].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM221 CAN_4.RAMn[221].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM222 CAN_4.RAMn[222].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM223 CAN_4.RAMn[223].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM224 CAN_4.RAMn[224].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM225 CAN_4.RAMn[225].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM226 CAN_4.RAMn[226].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM227 CAN_4.RAMn[227].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM228 CAN_4.RAMn[228].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM229 CAN_4.RAMn[229].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM230 CAN_4.RAMn[230].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM231 CAN_4.RAMn[231].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM232 CAN_4.RAMn[232].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM233 CAN_4.RAMn[233].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM234 CAN_4.RAMn[234].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM235 CAN_4.RAMn[235].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM236 CAN_4.RAMn[236].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM237 CAN_4.RAMn[237].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM238 CAN_4.RAMn[238].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM239 CAN_4.RAMn[239].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM240 CAN_4.RAMn[240].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM241 CAN_4.RAMn[241].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM242 CAN_4.RAMn[242].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM243 CAN_4.RAMn[243].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM244 CAN_4.RAMn[244].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM245 CAN_4.RAMn[245].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM246 CAN_4.RAMn[246].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM247 CAN_4.RAMn[247].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM248 CAN_4.RAMn[248].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM249 CAN_4.RAMn[249].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM250 CAN_4.RAMn[250].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM251 CAN_4.RAMn[251].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM252 CAN_4.RAMn[252].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM253 CAN_4.RAMn[253].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM254 CAN_4.RAMn[254].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM255 CAN_4.RAMn[255].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM256 CAN_4.RAMn[256].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM257 CAN_4.RAMn[257].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM258 CAN_4.RAMn[258].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM259 CAN_4.RAMn[259].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM260 CAN_4.RAMn[260].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM261 CAN_4.RAMn[261].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM262 CAN_4.RAMn[262].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM263 CAN_4.RAMn[263].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM264 CAN_4.RAMn[264].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM265 CAN_4.RAMn[265].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM266 CAN_4.RAMn[266].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM267 CAN_4.RAMn[267].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM268 CAN_4.RAMn[268].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM269 CAN_4.RAMn[269].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM270 CAN_4.RAMn[270].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM271 CAN_4.RAMn[271].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM272 CAN_4.RAMn[272].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM273 CAN_4.RAMn[273].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM274 CAN_4.RAMn[274].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM275 CAN_4.RAMn[275].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM276 CAN_4.RAMn[276].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM277 CAN_4.RAMn[277].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM278 CAN_4.RAMn[278].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM279 CAN_4.RAMn[279].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM280 CAN_4.RAMn[280].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM281 CAN_4.RAMn[281].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM282 CAN_4.RAMn[282].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM283 CAN_4.RAMn[283].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM284 CAN_4.RAMn[284].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM285 CAN_4.RAMn[285].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM286 CAN_4.RAMn[286].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM287 CAN_4.RAMn[287].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM288 CAN_4.RAMn[288].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM289 CAN_4.RAMn[289].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM290 CAN_4.RAMn[290].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM291 CAN_4.RAMn[291].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM292 CAN_4.RAMn[292].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM293 CAN_4.RAMn[293].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM294 CAN_4.RAMn[294].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM295 CAN_4.RAMn[295].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM296 CAN_4.RAMn[296].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM297 CAN_4.RAMn[297].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM298 CAN_4.RAMn[298].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM299 CAN_4.RAMn[299].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM300 CAN_4.RAMn[300].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM301 CAN_4.RAMn[301].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM302 CAN_4.RAMn[302].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM303 CAN_4.RAMn[303].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM304 CAN_4.RAMn[304].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM305 CAN_4.RAMn[305].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM306 CAN_4.RAMn[306].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM307 CAN_4.RAMn[307].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM308 CAN_4.RAMn[308].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM309 CAN_4.RAMn[309].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM310 CAN_4.RAMn[310].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM311 CAN_4.RAMn[311].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM312 CAN_4.RAMn[312].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM313 CAN_4.RAMn[313].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM314 CAN_4.RAMn[314].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM315 CAN_4.RAMn[315].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM316 CAN_4.RAMn[316].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM317 CAN_4.RAMn[317].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM318 CAN_4.RAMn[318].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM319 CAN_4.RAMn[319].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM320 CAN_4.RAMn[320].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM321 CAN_4.RAMn[321].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM322 CAN_4.RAMn[322].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM323 CAN_4.RAMn[323].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM324 CAN_4.RAMn[324].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM325 CAN_4.RAMn[325].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM326 CAN_4.RAMn[326].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM327 CAN_4.RAMn[327].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM328 CAN_4.RAMn[328].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM329 CAN_4.RAMn[329].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM330 CAN_4.RAMn[330].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM331 CAN_4.RAMn[331].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM332 CAN_4.RAMn[332].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM333 CAN_4.RAMn[333].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM334 CAN_4.RAMn[334].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM335 CAN_4.RAMn[335].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM336 CAN_4.RAMn[336].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM337 CAN_4.RAMn[337].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM338 CAN_4.RAMn[338].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM339 CAN_4.RAMn[339].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM340 CAN_4.RAMn[340].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM341 CAN_4.RAMn[341].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM342 CAN_4.RAMn[342].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM343 CAN_4.RAMn[343].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM344 CAN_4.RAMn[344].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM345 CAN_4.RAMn[345].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM346 CAN_4.RAMn[346].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM347 CAN_4.RAMn[347].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM348 CAN_4.RAMn[348].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM349 CAN_4.RAMn[349].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM350 CAN_4.RAMn[350].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM351 CAN_4.RAMn[351].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM352 CAN_4.RAMn[352].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM353 CAN_4.RAMn[353].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM354 CAN_4.RAMn[354].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM355 CAN_4.RAMn[355].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM356 CAN_4.RAMn[356].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM357 CAN_4.RAMn[357].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM358 CAN_4.RAMn[358].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM359 CAN_4.RAMn[359].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM360 CAN_4.RAMn[360].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM361 CAN_4.RAMn[361].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM362 CAN_4.RAMn[362].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM363 CAN_4.RAMn[363].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM364 CAN_4.RAMn[364].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM365 CAN_4.RAMn[365].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM366 CAN_4.RAMn[366].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM367 CAN_4.RAMn[367].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM368 CAN_4.RAMn[368].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM369 CAN_4.RAMn[369].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM370 CAN_4.RAMn[370].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM371 CAN_4.RAMn[371].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM372 CAN_4.RAMn[372].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM373 CAN_4.RAMn[373].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM374 CAN_4.RAMn[374].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM375 CAN_4.RAMn[375].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM376 CAN_4.RAMn[376].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM377 CAN_4.RAMn[377].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM378 CAN_4.RAMn[378].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM379 CAN_4.RAMn[379].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM380 CAN_4.RAMn[380].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM381 CAN_4.RAMn[381].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM382 CAN_4.RAMn[382].R             /* Embedded RAM */
#define CAN_4_EmbeddedRAM383 CAN_4.RAMn[383].R             /* Embedded RAM */
#define CAN_4_RXIMR0         CAN_4.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR1         CAN_4.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR2         CAN_4.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR3         CAN_4.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR4         CAN_4.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR5         CAN_4.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR6         CAN_4.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR7         CAN_4.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR8         CAN_4.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR9         CAN_4.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR10        CAN_4.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR11        CAN_4.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR12        CAN_4.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR13        CAN_4.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR14        CAN_4.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR15        CAN_4.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR16        CAN_4.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR17        CAN_4.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR18        CAN_4.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR19        CAN_4.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR20        CAN_4.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR21        CAN_4.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR22        CAN_4.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR23        CAN_4.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR24        CAN_4.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR25        CAN_4.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR26        CAN_4.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR27        CAN_4.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR28        CAN_4.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR29        CAN_4.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR30        CAN_4.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR31        CAN_4.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR32        CAN_4.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR33        CAN_4.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR34        CAN_4.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR35        CAN_4.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR36        CAN_4.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR37        CAN_4.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR38        CAN_4.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR39        CAN_4.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR40        CAN_4.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR41        CAN_4.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR42        CAN_4.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR43        CAN_4.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR44        CAN_4.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR45        CAN_4.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR46        CAN_4.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR47        CAN_4.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR48        CAN_4.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR49        CAN_4.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR50        CAN_4.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR51        CAN_4.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR52        CAN_4.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR53        CAN_4.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR54        CAN_4.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR55        CAN_4.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR56        CAN_4.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR57        CAN_4.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR58        CAN_4.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR59        CAN_4.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR60        CAN_4.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR61        CAN_4.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR62        CAN_4.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR63        CAN_4.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR64        CAN_4.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR65        CAN_4.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR66        CAN_4.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR67        CAN_4.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR68        CAN_4.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR69        CAN_4.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR70        CAN_4.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR71        CAN_4.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR72        CAN_4.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR73        CAN_4.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR74        CAN_4.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR75        CAN_4.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR76        CAN_4.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR77        CAN_4.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR78        CAN_4.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR79        CAN_4.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR80        CAN_4.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR81        CAN_4.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR82        CAN_4.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR83        CAN_4.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR84        CAN_4.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR85        CAN_4.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR86        CAN_4.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR87        CAN_4.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR88        CAN_4.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR89        CAN_4.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR90        CAN_4.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR91        CAN_4.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR92        CAN_4.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR93        CAN_4.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR94        CAN_4.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR95        CAN_4.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_4_FDCTRL         CAN_4.FDCTRL.R                /* CAN FD Control Register */
#define CAN_4_FDCBT          CAN_4.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_4_FDCRC          CAN_4.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_5_MCR            CAN_5.MCR.R                   /* Module Configuration Register */
#define CAN_5_CTRL1          CAN_5.CTRL1.R                 /* Control 1 register */
#define CAN_5_TIMER          CAN_5.TIMER.R                 /* Free Running Timer */
#define CAN_5_RXMGMASK       CAN_5.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_5_RX14MASK       CAN_5.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_5_RX15MASK       CAN_5.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_5_ECR            CAN_5.ECR.R                   /* Error Counter */
#define CAN_5_ESR1           CAN_5.ESR1.R                  /* Error and Status 1 register */
#define CAN_5_IMASK2         CAN_5.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_5_IMASK1         CAN_5.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_5_IFLAG2         CAN_5.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_5_IFLAG1         CAN_5.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_5_CTRL2          CAN_5.CTRL2.R                 /* Control 2 register */
#define CAN_5_ESR2           CAN_5.ESR2.R                  /* Error and Status 2 register */
#define CAN_5_CRCR           CAN_5.CRCR.R                  /* CRC Register */
#define CAN_5_RXFGMASK       CAN_5.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_5_RXFIR          CAN_5.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_5_CBT            CAN_5.CBT.R                   /* CAN Bit Timing Register */
#define CAN_5_IMASK3         CAN_5.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_5_IFLAG3         CAN_5.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_5_EmbeddedRAM0   CAN_5.RAMn[0].R               /* Embedded RAM */
#define CAN_5_EmbeddedRAM1   CAN_5.RAMn[1].R               /* Embedded RAM */
#define CAN_5_EmbeddedRAM2   CAN_5.RAMn[2].R               /* Embedded RAM */
#define CAN_5_EmbeddedRAM3   CAN_5.RAMn[3].R               /* Embedded RAM */
#define CAN_5_EmbeddedRAM4   CAN_5.RAMn[4].R               /* Embedded RAM */
#define CAN_5_EmbeddedRAM5   CAN_5.RAMn[5].R               /* Embedded RAM */
#define CAN_5_EmbeddedRAM6   CAN_5.RAMn[6].R               /* Embedded RAM */
#define CAN_5_EmbeddedRAM7   CAN_5.RAMn[7].R               /* Embedded RAM */
#define CAN_5_EmbeddedRAM8   CAN_5.RAMn[8].R               /* Embedded RAM */
#define CAN_5_EmbeddedRAM9   CAN_5.RAMn[9].R               /* Embedded RAM */
#define CAN_5_EmbeddedRAM10  CAN_5.RAMn[10].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM11  CAN_5.RAMn[11].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM12  CAN_5.RAMn[12].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM13  CAN_5.RAMn[13].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM14  CAN_5.RAMn[14].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM15  CAN_5.RAMn[15].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM16  CAN_5.RAMn[16].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM17  CAN_5.RAMn[17].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM18  CAN_5.RAMn[18].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM19  CAN_5.RAMn[19].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM20  CAN_5.RAMn[20].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM21  CAN_5.RAMn[21].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM22  CAN_5.RAMn[22].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM23  CAN_5.RAMn[23].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM24  CAN_5.RAMn[24].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM25  CAN_5.RAMn[25].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM26  CAN_5.RAMn[26].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM27  CAN_5.RAMn[27].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM28  CAN_5.RAMn[28].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM29  CAN_5.RAMn[29].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM30  CAN_5.RAMn[30].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM31  CAN_5.RAMn[31].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM32  CAN_5.RAMn[32].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM33  CAN_5.RAMn[33].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM34  CAN_5.RAMn[34].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM35  CAN_5.RAMn[35].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM36  CAN_5.RAMn[36].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM37  CAN_5.RAMn[37].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM38  CAN_5.RAMn[38].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM39  CAN_5.RAMn[39].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM40  CAN_5.RAMn[40].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM41  CAN_5.RAMn[41].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM42  CAN_5.RAMn[42].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM43  CAN_5.RAMn[43].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM44  CAN_5.RAMn[44].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM45  CAN_5.RAMn[45].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM46  CAN_5.RAMn[46].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM47  CAN_5.RAMn[47].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM48  CAN_5.RAMn[48].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM49  CAN_5.RAMn[49].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM50  CAN_5.RAMn[50].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM51  CAN_5.RAMn[51].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM52  CAN_5.RAMn[52].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM53  CAN_5.RAMn[53].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM54  CAN_5.RAMn[54].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM55  CAN_5.RAMn[55].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM56  CAN_5.RAMn[56].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM57  CAN_5.RAMn[57].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM58  CAN_5.RAMn[58].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM59  CAN_5.RAMn[59].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM60  CAN_5.RAMn[60].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM61  CAN_5.RAMn[61].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM62  CAN_5.RAMn[62].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM63  CAN_5.RAMn[63].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM64  CAN_5.RAMn[64].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM65  CAN_5.RAMn[65].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM66  CAN_5.RAMn[66].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM67  CAN_5.RAMn[67].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM68  CAN_5.RAMn[68].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM69  CAN_5.RAMn[69].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM70  CAN_5.RAMn[70].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM71  CAN_5.RAMn[71].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM72  CAN_5.RAMn[72].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM73  CAN_5.RAMn[73].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM74  CAN_5.RAMn[74].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM75  CAN_5.RAMn[75].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM76  CAN_5.RAMn[76].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM77  CAN_5.RAMn[77].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM78  CAN_5.RAMn[78].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM79  CAN_5.RAMn[79].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM80  CAN_5.RAMn[80].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM81  CAN_5.RAMn[81].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM82  CAN_5.RAMn[82].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM83  CAN_5.RAMn[83].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM84  CAN_5.RAMn[84].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM85  CAN_5.RAMn[85].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM86  CAN_5.RAMn[86].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM87  CAN_5.RAMn[87].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM88  CAN_5.RAMn[88].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM89  CAN_5.RAMn[89].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM90  CAN_5.RAMn[90].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM91  CAN_5.RAMn[91].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM92  CAN_5.RAMn[92].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM93  CAN_5.RAMn[93].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM94  CAN_5.RAMn[94].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM95  CAN_5.RAMn[95].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM96  CAN_5.RAMn[96].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM97  CAN_5.RAMn[97].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM98  CAN_5.RAMn[98].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM99  CAN_5.RAMn[99].R              /* Embedded RAM */
#define CAN_5_EmbeddedRAM100 CAN_5.RAMn[100].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM101 CAN_5.RAMn[101].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM102 CAN_5.RAMn[102].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM103 CAN_5.RAMn[103].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM104 CAN_5.RAMn[104].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM105 CAN_5.RAMn[105].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM106 CAN_5.RAMn[106].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM107 CAN_5.RAMn[107].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM108 CAN_5.RAMn[108].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM109 CAN_5.RAMn[109].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM110 CAN_5.RAMn[110].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM111 CAN_5.RAMn[111].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM112 CAN_5.RAMn[112].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM113 CAN_5.RAMn[113].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM114 CAN_5.RAMn[114].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM115 CAN_5.RAMn[115].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM116 CAN_5.RAMn[116].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM117 CAN_5.RAMn[117].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM118 CAN_5.RAMn[118].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM119 CAN_5.RAMn[119].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM120 CAN_5.RAMn[120].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM121 CAN_5.RAMn[121].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM122 CAN_5.RAMn[122].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM123 CAN_5.RAMn[123].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM124 CAN_5.RAMn[124].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM125 CAN_5.RAMn[125].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM126 CAN_5.RAMn[126].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM127 CAN_5.RAMn[127].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM128 CAN_5.RAMn[128].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM129 CAN_5.RAMn[129].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM130 CAN_5.RAMn[130].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM131 CAN_5.RAMn[131].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM132 CAN_5.RAMn[132].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM133 CAN_5.RAMn[133].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM134 CAN_5.RAMn[134].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM135 CAN_5.RAMn[135].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM136 CAN_5.RAMn[136].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM137 CAN_5.RAMn[137].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM138 CAN_5.RAMn[138].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM139 CAN_5.RAMn[139].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM140 CAN_5.RAMn[140].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM141 CAN_5.RAMn[141].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM142 CAN_5.RAMn[142].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM143 CAN_5.RAMn[143].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM144 CAN_5.RAMn[144].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM145 CAN_5.RAMn[145].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM146 CAN_5.RAMn[146].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM147 CAN_5.RAMn[147].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM148 CAN_5.RAMn[148].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM149 CAN_5.RAMn[149].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM150 CAN_5.RAMn[150].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM151 CAN_5.RAMn[151].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM152 CAN_5.RAMn[152].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM153 CAN_5.RAMn[153].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM154 CAN_5.RAMn[154].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM155 CAN_5.RAMn[155].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM156 CAN_5.RAMn[156].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM157 CAN_5.RAMn[157].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM158 CAN_5.RAMn[158].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM159 CAN_5.RAMn[159].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM160 CAN_5.RAMn[160].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM161 CAN_5.RAMn[161].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM162 CAN_5.RAMn[162].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM163 CAN_5.RAMn[163].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM164 CAN_5.RAMn[164].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM165 CAN_5.RAMn[165].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM166 CAN_5.RAMn[166].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM167 CAN_5.RAMn[167].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM168 CAN_5.RAMn[168].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM169 CAN_5.RAMn[169].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM170 CAN_5.RAMn[170].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM171 CAN_5.RAMn[171].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM172 CAN_5.RAMn[172].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM173 CAN_5.RAMn[173].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM174 CAN_5.RAMn[174].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM175 CAN_5.RAMn[175].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM176 CAN_5.RAMn[176].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM177 CAN_5.RAMn[177].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM178 CAN_5.RAMn[178].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM179 CAN_5.RAMn[179].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM180 CAN_5.RAMn[180].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM181 CAN_5.RAMn[181].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM182 CAN_5.RAMn[182].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM183 CAN_5.RAMn[183].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM184 CAN_5.RAMn[184].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM185 CAN_5.RAMn[185].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM186 CAN_5.RAMn[186].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM187 CAN_5.RAMn[187].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM188 CAN_5.RAMn[188].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM189 CAN_5.RAMn[189].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM190 CAN_5.RAMn[190].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM191 CAN_5.RAMn[191].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM192 CAN_5.RAMn[192].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM193 CAN_5.RAMn[193].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM194 CAN_5.RAMn[194].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM195 CAN_5.RAMn[195].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM196 CAN_5.RAMn[196].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM197 CAN_5.RAMn[197].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM198 CAN_5.RAMn[198].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM199 CAN_5.RAMn[199].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM200 CAN_5.RAMn[200].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM201 CAN_5.RAMn[201].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM202 CAN_5.RAMn[202].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM203 CAN_5.RAMn[203].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM204 CAN_5.RAMn[204].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM205 CAN_5.RAMn[205].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM206 CAN_5.RAMn[206].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM207 CAN_5.RAMn[207].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM208 CAN_5.RAMn[208].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM209 CAN_5.RAMn[209].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM210 CAN_5.RAMn[210].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM211 CAN_5.RAMn[211].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM212 CAN_5.RAMn[212].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM213 CAN_5.RAMn[213].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM214 CAN_5.RAMn[214].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM215 CAN_5.RAMn[215].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM216 CAN_5.RAMn[216].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM217 CAN_5.RAMn[217].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM218 CAN_5.RAMn[218].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM219 CAN_5.RAMn[219].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM220 CAN_5.RAMn[220].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM221 CAN_5.RAMn[221].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM222 CAN_5.RAMn[222].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM223 CAN_5.RAMn[223].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM224 CAN_5.RAMn[224].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM225 CAN_5.RAMn[225].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM226 CAN_5.RAMn[226].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM227 CAN_5.RAMn[227].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM228 CAN_5.RAMn[228].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM229 CAN_5.RAMn[229].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM230 CAN_5.RAMn[230].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM231 CAN_5.RAMn[231].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM232 CAN_5.RAMn[232].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM233 CAN_5.RAMn[233].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM234 CAN_5.RAMn[234].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM235 CAN_5.RAMn[235].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM236 CAN_5.RAMn[236].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM237 CAN_5.RAMn[237].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM238 CAN_5.RAMn[238].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM239 CAN_5.RAMn[239].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM240 CAN_5.RAMn[240].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM241 CAN_5.RAMn[241].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM242 CAN_5.RAMn[242].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM243 CAN_5.RAMn[243].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM244 CAN_5.RAMn[244].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM245 CAN_5.RAMn[245].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM246 CAN_5.RAMn[246].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM247 CAN_5.RAMn[247].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM248 CAN_5.RAMn[248].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM249 CAN_5.RAMn[249].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM250 CAN_5.RAMn[250].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM251 CAN_5.RAMn[251].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM252 CAN_5.RAMn[252].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM253 CAN_5.RAMn[253].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM254 CAN_5.RAMn[254].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM255 CAN_5.RAMn[255].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM256 CAN_5.RAMn[256].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM257 CAN_5.RAMn[257].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM258 CAN_5.RAMn[258].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM259 CAN_5.RAMn[259].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM260 CAN_5.RAMn[260].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM261 CAN_5.RAMn[261].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM262 CAN_5.RAMn[262].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM263 CAN_5.RAMn[263].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM264 CAN_5.RAMn[264].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM265 CAN_5.RAMn[265].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM266 CAN_5.RAMn[266].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM267 CAN_5.RAMn[267].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM268 CAN_5.RAMn[268].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM269 CAN_5.RAMn[269].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM270 CAN_5.RAMn[270].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM271 CAN_5.RAMn[271].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM272 CAN_5.RAMn[272].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM273 CAN_5.RAMn[273].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM274 CAN_5.RAMn[274].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM275 CAN_5.RAMn[275].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM276 CAN_5.RAMn[276].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM277 CAN_5.RAMn[277].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM278 CAN_5.RAMn[278].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM279 CAN_5.RAMn[279].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM280 CAN_5.RAMn[280].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM281 CAN_5.RAMn[281].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM282 CAN_5.RAMn[282].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM283 CAN_5.RAMn[283].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM284 CAN_5.RAMn[284].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM285 CAN_5.RAMn[285].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM286 CAN_5.RAMn[286].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM287 CAN_5.RAMn[287].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM288 CAN_5.RAMn[288].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM289 CAN_5.RAMn[289].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM290 CAN_5.RAMn[290].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM291 CAN_5.RAMn[291].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM292 CAN_5.RAMn[292].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM293 CAN_5.RAMn[293].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM294 CAN_5.RAMn[294].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM295 CAN_5.RAMn[295].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM296 CAN_5.RAMn[296].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM297 CAN_5.RAMn[297].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM298 CAN_5.RAMn[298].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM299 CAN_5.RAMn[299].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM300 CAN_5.RAMn[300].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM301 CAN_5.RAMn[301].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM302 CAN_5.RAMn[302].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM303 CAN_5.RAMn[303].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM304 CAN_5.RAMn[304].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM305 CAN_5.RAMn[305].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM306 CAN_5.RAMn[306].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM307 CAN_5.RAMn[307].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM308 CAN_5.RAMn[308].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM309 CAN_5.RAMn[309].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM310 CAN_5.RAMn[310].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM311 CAN_5.RAMn[311].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM312 CAN_5.RAMn[312].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM313 CAN_5.RAMn[313].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM314 CAN_5.RAMn[314].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM315 CAN_5.RAMn[315].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM316 CAN_5.RAMn[316].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM317 CAN_5.RAMn[317].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM318 CAN_5.RAMn[318].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM319 CAN_5.RAMn[319].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM320 CAN_5.RAMn[320].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM321 CAN_5.RAMn[321].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM322 CAN_5.RAMn[322].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM323 CAN_5.RAMn[323].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM324 CAN_5.RAMn[324].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM325 CAN_5.RAMn[325].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM326 CAN_5.RAMn[326].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM327 CAN_5.RAMn[327].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM328 CAN_5.RAMn[328].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM329 CAN_5.RAMn[329].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM330 CAN_5.RAMn[330].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM331 CAN_5.RAMn[331].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM332 CAN_5.RAMn[332].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM333 CAN_5.RAMn[333].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM334 CAN_5.RAMn[334].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM335 CAN_5.RAMn[335].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM336 CAN_5.RAMn[336].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM337 CAN_5.RAMn[337].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM338 CAN_5.RAMn[338].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM339 CAN_5.RAMn[339].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM340 CAN_5.RAMn[340].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM341 CAN_5.RAMn[341].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM342 CAN_5.RAMn[342].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM343 CAN_5.RAMn[343].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM344 CAN_5.RAMn[344].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM345 CAN_5.RAMn[345].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM346 CAN_5.RAMn[346].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM347 CAN_5.RAMn[347].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM348 CAN_5.RAMn[348].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM349 CAN_5.RAMn[349].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM350 CAN_5.RAMn[350].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM351 CAN_5.RAMn[351].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM352 CAN_5.RAMn[352].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM353 CAN_5.RAMn[353].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM354 CAN_5.RAMn[354].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM355 CAN_5.RAMn[355].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM356 CAN_5.RAMn[356].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM357 CAN_5.RAMn[357].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM358 CAN_5.RAMn[358].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM359 CAN_5.RAMn[359].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM360 CAN_5.RAMn[360].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM361 CAN_5.RAMn[361].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM362 CAN_5.RAMn[362].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM363 CAN_5.RAMn[363].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM364 CAN_5.RAMn[364].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM365 CAN_5.RAMn[365].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM366 CAN_5.RAMn[366].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM367 CAN_5.RAMn[367].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM368 CAN_5.RAMn[368].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM369 CAN_5.RAMn[369].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM370 CAN_5.RAMn[370].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM371 CAN_5.RAMn[371].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM372 CAN_5.RAMn[372].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM373 CAN_5.RAMn[373].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM374 CAN_5.RAMn[374].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM375 CAN_5.RAMn[375].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM376 CAN_5.RAMn[376].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM377 CAN_5.RAMn[377].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM378 CAN_5.RAMn[378].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM379 CAN_5.RAMn[379].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM380 CAN_5.RAMn[380].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM381 CAN_5.RAMn[381].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM382 CAN_5.RAMn[382].R             /* Embedded RAM */
#define CAN_5_EmbeddedRAM383 CAN_5.RAMn[383].R             /* Embedded RAM */
#define CAN_5_RXIMR0         CAN_5.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR1         CAN_5.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR2         CAN_5.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR3         CAN_5.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR4         CAN_5.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR5         CAN_5.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR6         CAN_5.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR7         CAN_5.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR8         CAN_5.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR9         CAN_5.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR10        CAN_5.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR11        CAN_5.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR12        CAN_5.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR13        CAN_5.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR14        CAN_5.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR15        CAN_5.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR16        CAN_5.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR17        CAN_5.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR18        CAN_5.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR19        CAN_5.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR20        CAN_5.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR21        CAN_5.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR22        CAN_5.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR23        CAN_5.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR24        CAN_5.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR25        CAN_5.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR26        CAN_5.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR27        CAN_5.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR28        CAN_5.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR29        CAN_5.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR30        CAN_5.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR31        CAN_5.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR32        CAN_5.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR33        CAN_5.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR34        CAN_5.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR35        CAN_5.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR36        CAN_5.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR37        CAN_5.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR38        CAN_5.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR39        CAN_5.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR40        CAN_5.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR41        CAN_5.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR42        CAN_5.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR43        CAN_5.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR44        CAN_5.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR45        CAN_5.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR46        CAN_5.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR47        CAN_5.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR48        CAN_5.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR49        CAN_5.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR50        CAN_5.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR51        CAN_5.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR52        CAN_5.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR53        CAN_5.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR54        CAN_5.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR55        CAN_5.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR56        CAN_5.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR57        CAN_5.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR58        CAN_5.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR59        CAN_5.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR60        CAN_5.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR61        CAN_5.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR62        CAN_5.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR63        CAN_5.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR64        CAN_5.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR65        CAN_5.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR66        CAN_5.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR67        CAN_5.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR68        CAN_5.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR69        CAN_5.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR70        CAN_5.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR71        CAN_5.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR72        CAN_5.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR73        CAN_5.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR74        CAN_5.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR75        CAN_5.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR76        CAN_5.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR77        CAN_5.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR78        CAN_5.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR79        CAN_5.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR80        CAN_5.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR81        CAN_5.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR82        CAN_5.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR83        CAN_5.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR84        CAN_5.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR85        CAN_5.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR86        CAN_5.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR87        CAN_5.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR88        CAN_5.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR89        CAN_5.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR90        CAN_5.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR91        CAN_5.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR92        CAN_5.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR93        CAN_5.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR94        CAN_5.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR95        CAN_5.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_5_FDCTRL         CAN_5.FDCTRL.R                /* CAN FD Control Register */
#define CAN_5_FDCBT          CAN_5.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_5_FDCRC          CAN_5.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_6_MCR            CAN_6.MCR.R                   /* Module Configuration Register */
#define CAN_6_CTRL1          CAN_6.CTRL1.R                 /* Control 1 register */
#define CAN_6_TIMER          CAN_6.TIMER.R                 /* Free Running Timer */
#define CAN_6_RXMGMASK       CAN_6.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_6_RX14MASK       CAN_6.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_6_RX15MASK       CAN_6.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_6_ECR            CAN_6.ECR.R                   /* Error Counter */
#define CAN_6_ESR1           CAN_6.ESR1.R                  /* Error and Status 1 register */
#define CAN_6_IMASK2         CAN_6.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_6_IMASK1         CAN_6.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_6_IFLAG2         CAN_6.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_6_IFLAG1         CAN_6.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_6_CTRL2          CAN_6.CTRL2.R                 /* Control 2 register */
#define CAN_6_ESR2           CAN_6.ESR2.R                  /* Error and Status 2 register */
#define CAN_6_CRCR           CAN_6.CRCR.R                  /* CRC Register */
#define CAN_6_RXFGMASK       CAN_6.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_6_RXFIR          CAN_6.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_6_CBT            CAN_6.CBT.R                   /* CAN Bit Timing Register */
#define CAN_6_IMASK3         CAN_6.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_6_IFLAG3         CAN_6.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_6_EmbeddedRAM0   CAN_6.RAMn[0].R               /* Embedded RAM */
#define CAN_6_EmbeddedRAM1   CAN_6.RAMn[1].R               /* Embedded RAM */
#define CAN_6_EmbeddedRAM2   CAN_6.RAMn[2].R               /* Embedded RAM */
#define CAN_6_EmbeddedRAM3   CAN_6.RAMn[3].R               /* Embedded RAM */
#define CAN_6_EmbeddedRAM4   CAN_6.RAMn[4].R               /* Embedded RAM */
#define CAN_6_EmbeddedRAM5   CAN_6.RAMn[5].R               /* Embedded RAM */
#define CAN_6_EmbeddedRAM6   CAN_6.RAMn[6].R               /* Embedded RAM */
#define CAN_6_EmbeddedRAM7   CAN_6.RAMn[7].R               /* Embedded RAM */
#define CAN_6_EmbeddedRAM8   CAN_6.RAMn[8].R               /* Embedded RAM */
#define CAN_6_EmbeddedRAM9   CAN_6.RAMn[9].R               /* Embedded RAM */
#define CAN_6_EmbeddedRAM10  CAN_6.RAMn[10].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM11  CAN_6.RAMn[11].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM12  CAN_6.RAMn[12].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM13  CAN_6.RAMn[13].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM14  CAN_6.RAMn[14].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM15  CAN_6.RAMn[15].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM16  CAN_6.RAMn[16].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM17  CAN_6.RAMn[17].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM18  CAN_6.RAMn[18].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM19  CAN_6.RAMn[19].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM20  CAN_6.RAMn[20].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM21  CAN_6.RAMn[21].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM22  CAN_6.RAMn[22].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM23  CAN_6.RAMn[23].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM24  CAN_6.RAMn[24].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM25  CAN_6.RAMn[25].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM26  CAN_6.RAMn[26].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM27  CAN_6.RAMn[27].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM28  CAN_6.RAMn[28].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM29  CAN_6.RAMn[29].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM30  CAN_6.RAMn[30].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM31  CAN_6.RAMn[31].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM32  CAN_6.RAMn[32].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM33  CAN_6.RAMn[33].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM34  CAN_6.RAMn[34].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM35  CAN_6.RAMn[35].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM36  CAN_6.RAMn[36].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM37  CAN_6.RAMn[37].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM38  CAN_6.RAMn[38].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM39  CAN_6.RAMn[39].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM40  CAN_6.RAMn[40].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM41  CAN_6.RAMn[41].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM42  CAN_6.RAMn[42].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM43  CAN_6.RAMn[43].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM44  CAN_6.RAMn[44].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM45  CAN_6.RAMn[45].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM46  CAN_6.RAMn[46].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM47  CAN_6.RAMn[47].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM48  CAN_6.RAMn[48].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM49  CAN_6.RAMn[49].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM50  CAN_6.RAMn[50].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM51  CAN_6.RAMn[51].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM52  CAN_6.RAMn[52].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM53  CAN_6.RAMn[53].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM54  CAN_6.RAMn[54].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM55  CAN_6.RAMn[55].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM56  CAN_6.RAMn[56].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM57  CAN_6.RAMn[57].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM58  CAN_6.RAMn[58].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM59  CAN_6.RAMn[59].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM60  CAN_6.RAMn[60].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM61  CAN_6.RAMn[61].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM62  CAN_6.RAMn[62].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM63  CAN_6.RAMn[63].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM64  CAN_6.RAMn[64].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM65  CAN_6.RAMn[65].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM66  CAN_6.RAMn[66].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM67  CAN_6.RAMn[67].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM68  CAN_6.RAMn[68].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM69  CAN_6.RAMn[69].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM70  CAN_6.RAMn[70].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM71  CAN_6.RAMn[71].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM72  CAN_6.RAMn[72].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM73  CAN_6.RAMn[73].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM74  CAN_6.RAMn[74].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM75  CAN_6.RAMn[75].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM76  CAN_6.RAMn[76].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM77  CAN_6.RAMn[77].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM78  CAN_6.RAMn[78].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM79  CAN_6.RAMn[79].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM80  CAN_6.RAMn[80].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM81  CAN_6.RAMn[81].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM82  CAN_6.RAMn[82].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM83  CAN_6.RAMn[83].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM84  CAN_6.RAMn[84].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM85  CAN_6.RAMn[85].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM86  CAN_6.RAMn[86].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM87  CAN_6.RAMn[87].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM88  CAN_6.RAMn[88].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM89  CAN_6.RAMn[89].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM90  CAN_6.RAMn[90].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM91  CAN_6.RAMn[91].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM92  CAN_6.RAMn[92].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM93  CAN_6.RAMn[93].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM94  CAN_6.RAMn[94].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM95  CAN_6.RAMn[95].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM96  CAN_6.RAMn[96].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM97  CAN_6.RAMn[97].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM98  CAN_6.RAMn[98].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM99  CAN_6.RAMn[99].R              /* Embedded RAM */
#define CAN_6_EmbeddedRAM100 CAN_6.RAMn[100].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM101 CAN_6.RAMn[101].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM102 CAN_6.RAMn[102].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM103 CAN_6.RAMn[103].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM104 CAN_6.RAMn[104].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM105 CAN_6.RAMn[105].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM106 CAN_6.RAMn[106].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM107 CAN_6.RAMn[107].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM108 CAN_6.RAMn[108].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM109 CAN_6.RAMn[109].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM110 CAN_6.RAMn[110].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM111 CAN_6.RAMn[111].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM112 CAN_6.RAMn[112].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM113 CAN_6.RAMn[113].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM114 CAN_6.RAMn[114].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM115 CAN_6.RAMn[115].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM116 CAN_6.RAMn[116].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM117 CAN_6.RAMn[117].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM118 CAN_6.RAMn[118].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM119 CAN_6.RAMn[119].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM120 CAN_6.RAMn[120].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM121 CAN_6.RAMn[121].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM122 CAN_6.RAMn[122].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM123 CAN_6.RAMn[123].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM124 CAN_6.RAMn[124].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM125 CAN_6.RAMn[125].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM126 CAN_6.RAMn[126].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM127 CAN_6.RAMn[127].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM128 CAN_6.RAMn[128].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM129 CAN_6.RAMn[129].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM130 CAN_6.RAMn[130].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM131 CAN_6.RAMn[131].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM132 CAN_6.RAMn[132].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM133 CAN_6.RAMn[133].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM134 CAN_6.RAMn[134].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM135 CAN_6.RAMn[135].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM136 CAN_6.RAMn[136].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM137 CAN_6.RAMn[137].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM138 CAN_6.RAMn[138].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM139 CAN_6.RAMn[139].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM140 CAN_6.RAMn[140].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM141 CAN_6.RAMn[141].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM142 CAN_6.RAMn[142].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM143 CAN_6.RAMn[143].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM144 CAN_6.RAMn[144].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM145 CAN_6.RAMn[145].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM146 CAN_6.RAMn[146].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM147 CAN_6.RAMn[147].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM148 CAN_6.RAMn[148].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM149 CAN_6.RAMn[149].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM150 CAN_6.RAMn[150].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM151 CAN_6.RAMn[151].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM152 CAN_6.RAMn[152].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM153 CAN_6.RAMn[153].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM154 CAN_6.RAMn[154].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM155 CAN_6.RAMn[155].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM156 CAN_6.RAMn[156].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM157 CAN_6.RAMn[157].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM158 CAN_6.RAMn[158].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM159 CAN_6.RAMn[159].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM160 CAN_6.RAMn[160].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM161 CAN_6.RAMn[161].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM162 CAN_6.RAMn[162].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM163 CAN_6.RAMn[163].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM164 CAN_6.RAMn[164].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM165 CAN_6.RAMn[165].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM166 CAN_6.RAMn[166].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM167 CAN_6.RAMn[167].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM168 CAN_6.RAMn[168].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM169 CAN_6.RAMn[169].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM170 CAN_6.RAMn[170].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM171 CAN_6.RAMn[171].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM172 CAN_6.RAMn[172].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM173 CAN_6.RAMn[173].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM174 CAN_6.RAMn[174].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM175 CAN_6.RAMn[175].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM176 CAN_6.RAMn[176].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM177 CAN_6.RAMn[177].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM178 CAN_6.RAMn[178].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM179 CAN_6.RAMn[179].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM180 CAN_6.RAMn[180].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM181 CAN_6.RAMn[181].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM182 CAN_6.RAMn[182].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM183 CAN_6.RAMn[183].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM184 CAN_6.RAMn[184].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM185 CAN_6.RAMn[185].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM186 CAN_6.RAMn[186].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM187 CAN_6.RAMn[187].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM188 CAN_6.RAMn[188].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM189 CAN_6.RAMn[189].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM190 CAN_6.RAMn[190].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM191 CAN_6.RAMn[191].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM192 CAN_6.RAMn[192].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM193 CAN_6.RAMn[193].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM194 CAN_6.RAMn[194].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM195 CAN_6.RAMn[195].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM196 CAN_6.RAMn[196].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM197 CAN_6.RAMn[197].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM198 CAN_6.RAMn[198].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM199 CAN_6.RAMn[199].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM200 CAN_6.RAMn[200].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM201 CAN_6.RAMn[201].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM202 CAN_6.RAMn[202].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM203 CAN_6.RAMn[203].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM204 CAN_6.RAMn[204].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM205 CAN_6.RAMn[205].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM206 CAN_6.RAMn[206].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM207 CAN_6.RAMn[207].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM208 CAN_6.RAMn[208].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM209 CAN_6.RAMn[209].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM210 CAN_6.RAMn[210].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM211 CAN_6.RAMn[211].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM212 CAN_6.RAMn[212].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM213 CAN_6.RAMn[213].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM214 CAN_6.RAMn[214].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM215 CAN_6.RAMn[215].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM216 CAN_6.RAMn[216].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM217 CAN_6.RAMn[217].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM218 CAN_6.RAMn[218].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM219 CAN_6.RAMn[219].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM220 CAN_6.RAMn[220].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM221 CAN_6.RAMn[221].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM222 CAN_6.RAMn[222].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM223 CAN_6.RAMn[223].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM224 CAN_6.RAMn[224].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM225 CAN_6.RAMn[225].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM226 CAN_6.RAMn[226].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM227 CAN_6.RAMn[227].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM228 CAN_6.RAMn[228].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM229 CAN_6.RAMn[229].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM230 CAN_6.RAMn[230].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM231 CAN_6.RAMn[231].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM232 CAN_6.RAMn[232].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM233 CAN_6.RAMn[233].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM234 CAN_6.RAMn[234].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM235 CAN_6.RAMn[235].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM236 CAN_6.RAMn[236].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM237 CAN_6.RAMn[237].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM238 CAN_6.RAMn[238].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM239 CAN_6.RAMn[239].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM240 CAN_6.RAMn[240].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM241 CAN_6.RAMn[241].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM242 CAN_6.RAMn[242].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM243 CAN_6.RAMn[243].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM244 CAN_6.RAMn[244].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM245 CAN_6.RAMn[245].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM246 CAN_6.RAMn[246].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM247 CAN_6.RAMn[247].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM248 CAN_6.RAMn[248].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM249 CAN_6.RAMn[249].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM250 CAN_6.RAMn[250].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM251 CAN_6.RAMn[251].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM252 CAN_6.RAMn[252].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM253 CAN_6.RAMn[253].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM254 CAN_6.RAMn[254].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM255 CAN_6.RAMn[255].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM256 CAN_6.RAMn[256].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM257 CAN_6.RAMn[257].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM258 CAN_6.RAMn[258].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM259 CAN_6.RAMn[259].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM260 CAN_6.RAMn[260].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM261 CAN_6.RAMn[261].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM262 CAN_6.RAMn[262].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM263 CAN_6.RAMn[263].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM264 CAN_6.RAMn[264].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM265 CAN_6.RAMn[265].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM266 CAN_6.RAMn[266].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM267 CAN_6.RAMn[267].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM268 CAN_6.RAMn[268].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM269 CAN_6.RAMn[269].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM270 CAN_6.RAMn[270].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM271 CAN_6.RAMn[271].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM272 CAN_6.RAMn[272].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM273 CAN_6.RAMn[273].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM274 CAN_6.RAMn[274].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM275 CAN_6.RAMn[275].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM276 CAN_6.RAMn[276].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM277 CAN_6.RAMn[277].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM278 CAN_6.RAMn[278].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM279 CAN_6.RAMn[279].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM280 CAN_6.RAMn[280].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM281 CAN_6.RAMn[281].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM282 CAN_6.RAMn[282].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM283 CAN_6.RAMn[283].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM284 CAN_6.RAMn[284].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM285 CAN_6.RAMn[285].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM286 CAN_6.RAMn[286].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM287 CAN_6.RAMn[287].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM288 CAN_6.RAMn[288].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM289 CAN_6.RAMn[289].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM290 CAN_6.RAMn[290].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM291 CAN_6.RAMn[291].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM292 CAN_6.RAMn[292].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM293 CAN_6.RAMn[293].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM294 CAN_6.RAMn[294].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM295 CAN_6.RAMn[295].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM296 CAN_6.RAMn[296].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM297 CAN_6.RAMn[297].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM298 CAN_6.RAMn[298].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM299 CAN_6.RAMn[299].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM300 CAN_6.RAMn[300].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM301 CAN_6.RAMn[301].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM302 CAN_6.RAMn[302].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM303 CAN_6.RAMn[303].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM304 CAN_6.RAMn[304].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM305 CAN_6.RAMn[305].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM306 CAN_6.RAMn[306].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM307 CAN_6.RAMn[307].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM308 CAN_6.RAMn[308].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM309 CAN_6.RAMn[309].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM310 CAN_6.RAMn[310].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM311 CAN_6.RAMn[311].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM312 CAN_6.RAMn[312].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM313 CAN_6.RAMn[313].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM314 CAN_6.RAMn[314].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM315 CAN_6.RAMn[315].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM316 CAN_6.RAMn[316].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM317 CAN_6.RAMn[317].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM318 CAN_6.RAMn[318].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM319 CAN_6.RAMn[319].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM320 CAN_6.RAMn[320].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM321 CAN_6.RAMn[321].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM322 CAN_6.RAMn[322].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM323 CAN_6.RAMn[323].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM324 CAN_6.RAMn[324].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM325 CAN_6.RAMn[325].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM326 CAN_6.RAMn[326].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM327 CAN_6.RAMn[327].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM328 CAN_6.RAMn[328].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM329 CAN_6.RAMn[329].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM330 CAN_6.RAMn[330].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM331 CAN_6.RAMn[331].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM332 CAN_6.RAMn[332].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM333 CAN_6.RAMn[333].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM334 CAN_6.RAMn[334].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM335 CAN_6.RAMn[335].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM336 CAN_6.RAMn[336].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM337 CAN_6.RAMn[337].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM338 CAN_6.RAMn[338].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM339 CAN_6.RAMn[339].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM340 CAN_6.RAMn[340].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM341 CAN_6.RAMn[341].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM342 CAN_6.RAMn[342].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM343 CAN_6.RAMn[343].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM344 CAN_6.RAMn[344].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM345 CAN_6.RAMn[345].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM346 CAN_6.RAMn[346].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM347 CAN_6.RAMn[347].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM348 CAN_6.RAMn[348].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM349 CAN_6.RAMn[349].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM350 CAN_6.RAMn[350].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM351 CAN_6.RAMn[351].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM352 CAN_6.RAMn[352].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM353 CAN_6.RAMn[353].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM354 CAN_6.RAMn[354].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM355 CAN_6.RAMn[355].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM356 CAN_6.RAMn[356].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM357 CAN_6.RAMn[357].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM358 CAN_6.RAMn[358].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM359 CAN_6.RAMn[359].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM360 CAN_6.RAMn[360].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM361 CAN_6.RAMn[361].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM362 CAN_6.RAMn[362].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM363 CAN_6.RAMn[363].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM364 CAN_6.RAMn[364].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM365 CAN_6.RAMn[365].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM366 CAN_6.RAMn[366].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM367 CAN_6.RAMn[367].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM368 CAN_6.RAMn[368].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM369 CAN_6.RAMn[369].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM370 CAN_6.RAMn[370].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM371 CAN_6.RAMn[371].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM372 CAN_6.RAMn[372].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM373 CAN_6.RAMn[373].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM374 CAN_6.RAMn[374].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM375 CAN_6.RAMn[375].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM376 CAN_6.RAMn[376].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM377 CAN_6.RAMn[377].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM378 CAN_6.RAMn[378].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM379 CAN_6.RAMn[379].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM380 CAN_6.RAMn[380].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM381 CAN_6.RAMn[381].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM382 CAN_6.RAMn[382].R             /* Embedded RAM */
#define CAN_6_EmbeddedRAM383 CAN_6.RAMn[383].R             /* Embedded RAM */
#define CAN_6_RXIMR0         CAN_6.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR1         CAN_6.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR2         CAN_6.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR3         CAN_6.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR4         CAN_6.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR5         CAN_6.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR6         CAN_6.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR7         CAN_6.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR8         CAN_6.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR9         CAN_6.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR10        CAN_6.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR11        CAN_6.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR12        CAN_6.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR13        CAN_6.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR14        CAN_6.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR15        CAN_6.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR16        CAN_6.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR17        CAN_6.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR18        CAN_6.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR19        CAN_6.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR20        CAN_6.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR21        CAN_6.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR22        CAN_6.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR23        CAN_6.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR24        CAN_6.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR25        CAN_6.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR26        CAN_6.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR27        CAN_6.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR28        CAN_6.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR29        CAN_6.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR30        CAN_6.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR31        CAN_6.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR32        CAN_6.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR33        CAN_6.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR34        CAN_6.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR35        CAN_6.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR36        CAN_6.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR37        CAN_6.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR38        CAN_6.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR39        CAN_6.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR40        CAN_6.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR41        CAN_6.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR42        CAN_6.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR43        CAN_6.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR44        CAN_6.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR45        CAN_6.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR46        CAN_6.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR47        CAN_6.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR48        CAN_6.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR49        CAN_6.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR50        CAN_6.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR51        CAN_6.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR52        CAN_6.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR53        CAN_6.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR54        CAN_6.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR55        CAN_6.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR56        CAN_6.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR57        CAN_6.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR58        CAN_6.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR59        CAN_6.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR60        CAN_6.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR61        CAN_6.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR62        CAN_6.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR63        CAN_6.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR64        CAN_6.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR65        CAN_6.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR66        CAN_6.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR67        CAN_6.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR68        CAN_6.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR69        CAN_6.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR70        CAN_6.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR71        CAN_6.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR72        CAN_6.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR73        CAN_6.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR74        CAN_6.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR75        CAN_6.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR76        CAN_6.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR77        CAN_6.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR78        CAN_6.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR79        CAN_6.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR80        CAN_6.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR81        CAN_6.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR82        CAN_6.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR83        CAN_6.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR84        CAN_6.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR85        CAN_6.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR86        CAN_6.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR87        CAN_6.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR88        CAN_6.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR89        CAN_6.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR90        CAN_6.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR91        CAN_6.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR92        CAN_6.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR93        CAN_6.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR94        CAN_6.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR95        CAN_6.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_6_FDCTRL         CAN_6.FDCTRL.R                /* CAN FD Control Register */
#define CAN_6_FDCBT          CAN_6.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_6_FDCRC          CAN_6.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_7_MCR            CAN_7.MCR.R                   /* Module Configuration Register */
#define CAN_7_CTRL1          CAN_7.CTRL1.R                 /* Control 1 register */
#define CAN_7_TIMER          CAN_7.TIMER.R                 /* Free Running Timer */
#define CAN_7_RXMGMASK       CAN_7.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_7_RX14MASK       CAN_7.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_7_RX15MASK       CAN_7.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_7_ECR            CAN_7.ECR.R                   /* Error Counter */
#define CAN_7_ESR1           CAN_7.ESR1.R                  /* Error and Status 1 register */
#define CAN_7_IMASK2         CAN_7.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_7_IMASK1         CAN_7.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_7_IFLAG2         CAN_7.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_7_IFLAG1         CAN_7.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_7_CTRL2          CAN_7.CTRL2.R                 /* Control 2 register */
#define CAN_7_ESR2           CAN_7.ESR2.R                  /* Error and Status 2 register */
#define CAN_7_CRCR           CAN_7.CRCR.R                  /* CRC Register */
#define CAN_7_RXFGMASK       CAN_7.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_7_RXFIR          CAN_7.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_7_CBT            CAN_7.CBT.R                   /* CAN Bit Timing Register */
#define CAN_7_IMASK3         CAN_7.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_7_IFLAG3         CAN_7.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_7_EmbeddedRAM0   CAN_7.RAMn[0].R               /* Embedded RAM */
#define CAN_7_EmbeddedRAM1   CAN_7.RAMn[1].R               /* Embedded RAM */
#define CAN_7_EmbeddedRAM2   CAN_7.RAMn[2].R               /* Embedded RAM */
#define CAN_7_EmbeddedRAM3   CAN_7.RAMn[3].R               /* Embedded RAM */
#define CAN_7_EmbeddedRAM4   CAN_7.RAMn[4].R               /* Embedded RAM */
#define CAN_7_EmbeddedRAM5   CAN_7.RAMn[5].R               /* Embedded RAM */
#define CAN_7_EmbeddedRAM6   CAN_7.RAMn[6].R               /* Embedded RAM */
#define CAN_7_EmbeddedRAM7   CAN_7.RAMn[7].R               /* Embedded RAM */
#define CAN_7_EmbeddedRAM8   CAN_7.RAMn[8].R               /* Embedded RAM */
#define CAN_7_EmbeddedRAM9   CAN_7.RAMn[9].R               /* Embedded RAM */
#define CAN_7_EmbeddedRAM10  CAN_7.RAMn[10].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM11  CAN_7.RAMn[11].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM12  CAN_7.RAMn[12].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM13  CAN_7.RAMn[13].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM14  CAN_7.RAMn[14].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM15  CAN_7.RAMn[15].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM16  CAN_7.RAMn[16].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM17  CAN_7.RAMn[17].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM18  CAN_7.RAMn[18].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM19  CAN_7.RAMn[19].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM20  CAN_7.RAMn[20].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM21  CAN_7.RAMn[21].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM22  CAN_7.RAMn[22].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM23  CAN_7.RAMn[23].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM24  CAN_7.RAMn[24].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM25  CAN_7.RAMn[25].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM26  CAN_7.RAMn[26].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM27  CAN_7.RAMn[27].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM28  CAN_7.RAMn[28].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM29  CAN_7.RAMn[29].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM30  CAN_7.RAMn[30].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM31  CAN_7.RAMn[31].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM32  CAN_7.RAMn[32].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM33  CAN_7.RAMn[33].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM34  CAN_7.RAMn[34].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM35  CAN_7.RAMn[35].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM36  CAN_7.RAMn[36].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM37  CAN_7.RAMn[37].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM38  CAN_7.RAMn[38].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM39  CAN_7.RAMn[39].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM40  CAN_7.RAMn[40].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM41  CAN_7.RAMn[41].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM42  CAN_7.RAMn[42].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM43  CAN_7.RAMn[43].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM44  CAN_7.RAMn[44].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM45  CAN_7.RAMn[45].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM46  CAN_7.RAMn[46].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM47  CAN_7.RAMn[47].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM48  CAN_7.RAMn[48].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM49  CAN_7.RAMn[49].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM50  CAN_7.RAMn[50].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM51  CAN_7.RAMn[51].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM52  CAN_7.RAMn[52].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM53  CAN_7.RAMn[53].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM54  CAN_7.RAMn[54].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM55  CAN_7.RAMn[55].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM56  CAN_7.RAMn[56].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM57  CAN_7.RAMn[57].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM58  CAN_7.RAMn[58].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM59  CAN_7.RAMn[59].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM60  CAN_7.RAMn[60].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM61  CAN_7.RAMn[61].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM62  CAN_7.RAMn[62].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM63  CAN_7.RAMn[63].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM64  CAN_7.RAMn[64].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM65  CAN_7.RAMn[65].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM66  CAN_7.RAMn[66].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM67  CAN_7.RAMn[67].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM68  CAN_7.RAMn[68].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM69  CAN_7.RAMn[69].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM70  CAN_7.RAMn[70].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM71  CAN_7.RAMn[71].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM72  CAN_7.RAMn[72].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM73  CAN_7.RAMn[73].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM74  CAN_7.RAMn[74].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM75  CAN_7.RAMn[75].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM76  CAN_7.RAMn[76].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM77  CAN_7.RAMn[77].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM78  CAN_7.RAMn[78].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM79  CAN_7.RAMn[79].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM80  CAN_7.RAMn[80].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM81  CAN_7.RAMn[81].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM82  CAN_7.RAMn[82].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM83  CAN_7.RAMn[83].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM84  CAN_7.RAMn[84].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM85  CAN_7.RAMn[85].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM86  CAN_7.RAMn[86].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM87  CAN_7.RAMn[87].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM88  CAN_7.RAMn[88].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM89  CAN_7.RAMn[89].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM90  CAN_7.RAMn[90].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM91  CAN_7.RAMn[91].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM92  CAN_7.RAMn[92].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM93  CAN_7.RAMn[93].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM94  CAN_7.RAMn[94].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM95  CAN_7.RAMn[95].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM96  CAN_7.RAMn[96].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM97  CAN_7.RAMn[97].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM98  CAN_7.RAMn[98].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM99  CAN_7.RAMn[99].R              /* Embedded RAM */
#define CAN_7_EmbeddedRAM100 CAN_7.RAMn[100].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM101 CAN_7.RAMn[101].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM102 CAN_7.RAMn[102].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM103 CAN_7.RAMn[103].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM104 CAN_7.RAMn[104].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM105 CAN_7.RAMn[105].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM106 CAN_7.RAMn[106].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM107 CAN_7.RAMn[107].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM108 CAN_7.RAMn[108].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM109 CAN_7.RAMn[109].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM110 CAN_7.RAMn[110].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM111 CAN_7.RAMn[111].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM112 CAN_7.RAMn[112].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM113 CAN_7.RAMn[113].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM114 CAN_7.RAMn[114].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM115 CAN_7.RAMn[115].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM116 CAN_7.RAMn[116].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM117 CAN_7.RAMn[117].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM118 CAN_7.RAMn[118].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM119 CAN_7.RAMn[119].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM120 CAN_7.RAMn[120].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM121 CAN_7.RAMn[121].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM122 CAN_7.RAMn[122].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM123 CAN_7.RAMn[123].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM124 CAN_7.RAMn[124].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM125 CAN_7.RAMn[125].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM126 CAN_7.RAMn[126].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM127 CAN_7.RAMn[127].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM128 CAN_7.RAMn[128].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM129 CAN_7.RAMn[129].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM130 CAN_7.RAMn[130].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM131 CAN_7.RAMn[131].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM132 CAN_7.RAMn[132].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM133 CAN_7.RAMn[133].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM134 CAN_7.RAMn[134].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM135 CAN_7.RAMn[135].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM136 CAN_7.RAMn[136].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM137 CAN_7.RAMn[137].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM138 CAN_7.RAMn[138].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM139 CAN_7.RAMn[139].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM140 CAN_7.RAMn[140].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM141 CAN_7.RAMn[141].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM142 CAN_7.RAMn[142].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM143 CAN_7.RAMn[143].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM144 CAN_7.RAMn[144].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM145 CAN_7.RAMn[145].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM146 CAN_7.RAMn[146].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM147 CAN_7.RAMn[147].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM148 CAN_7.RAMn[148].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM149 CAN_7.RAMn[149].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM150 CAN_7.RAMn[150].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM151 CAN_7.RAMn[151].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM152 CAN_7.RAMn[152].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM153 CAN_7.RAMn[153].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM154 CAN_7.RAMn[154].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM155 CAN_7.RAMn[155].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM156 CAN_7.RAMn[156].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM157 CAN_7.RAMn[157].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM158 CAN_7.RAMn[158].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM159 CAN_7.RAMn[159].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM160 CAN_7.RAMn[160].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM161 CAN_7.RAMn[161].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM162 CAN_7.RAMn[162].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM163 CAN_7.RAMn[163].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM164 CAN_7.RAMn[164].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM165 CAN_7.RAMn[165].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM166 CAN_7.RAMn[166].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM167 CAN_7.RAMn[167].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM168 CAN_7.RAMn[168].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM169 CAN_7.RAMn[169].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM170 CAN_7.RAMn[170].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM171 CAN_7.RAMn[171].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM172 CAN_7.RAMn[172].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM173 CAN_7.RAMn[173].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM174 CAN_7.RAMn[174].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM175 CAN_7.RAMn[175].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM176 CAN_7.RAMn[176].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM177 CAN_7.RAMn[177].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM178 CAN_7.RAMn[178].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM179 CAN_7.RAMn[179].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM180 CAN_7.RAMn[180].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM181 CAN_7.RAMn[181].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM182 CAN_7.RAMn[182].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM183 CAN_7.RAMn[183].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM184 CAN_7.RAMn[184].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM185 CAN_7.RAMn[185].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM186 CAN_7.RAMn[186].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM187 CAN_7.RAMn[187].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM188 CAN_7.RAMn[188].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM189 CAN_7.RAMn[189].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM190 CAN_7.RAMn[190].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM191 CAN_7.RAMn[191].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM192 CAN_7.RAMn[192].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM193 CAN_7.RAMn[193].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM194 CAN_7.RAMn[194].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM195 CAN_7.RAMn[195].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM196 CAN_7.RAMn[196].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM197 CAN_7.RAMn[197].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM198 CAN_7.RAMn[198].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM199 CAN_7.RAMn[199].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM200 CAN_7.RAMn[200].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM201 CAN_7.RAMn[201].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM202 CAN_7.RAMn[202].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM203 CAN_7.RAMn[203].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM204 CAN_7.RAMn[204].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM205 CAN_7.RAMn[205].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM206 CAN_7.RAMn[206].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM207 CAN_7.RAMn[207].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM208 CAN_7.RAMn[208].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM209 CAN_7.RAMn[209].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM210 CAN_7.RAMn[210].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM211 CAN_7.RAMn[211].R             /* Embedded RAM */
#define CAN_7_EmbeddedRAM212 CAN_7.RAMn[212].R             /* Embedd