/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.ui.navigator;

import com.nxp.s32ds.cle.spt.model.ISptInstruction;
import com.nxp.s32ds.cle.spt.model.ISptInstructionOption;
import com.nxp.s32ds.cle.spt.model.ISptInstructionParam;
import com.nxp.s32ds.cle.spt.model.ISptInstructionParamValue;
import com.nxp.s32ds.cle.spt.ui.navigator.Messages;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SptInstructionParamsDialog
extends TitleAreaDialog {
    private static final int DIALOG_HEIGHT = 400;
    private static final String VALUE_PATTERN = "[_a-zA-Z0-9]*";
    private ISptInstruction instruction;
    private Set<Object> allParams;
    private String result;
    private Button okButton;
    private String selectedMnemonic;

    public SptInstructionParamsDialog(Shell parent, ISptInstruction instruction) {
        super(parent);
        this.instruction = instruction;
        this.allParams = new LinkedHashSet<Object>();
    }

    public String getResult() {
        return this.result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)Messages.SptInstructionParamsDialog_title, null));
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = new Composite(parentComposite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 400;
        contents.setLayoutData((Object)gridData);
        this.setTitle(NLS.bind((String)Messages.SptInstructionParamsDialog_message, (Object)this.instruction.getName().toUpperCase()));
        this.setMessage(NLS.bind((String)Messages.SptInstructionParamsDialog_description, null));
        contents.setLayout((Layout)new GridLayout(1, false));
        this.createWidgets(contents);
        SptInstructionParamsDialog.applyDialogFont((Control)parentComposite);
        this.handleContextHelp(parentComposite);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    protected void okPressed() {
        this.result = this.getInstruction();
        super.okPressed();
    }

    private void handleContextHelp(Composite composite) {
        this.setHelpAvailable(false);
        composite.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
            }
        });
    }

    private String getInstruction() {
        StringBuilder sb = new StringBuilder();
        boolean isLabelDirective = this.instruction.getName().equals(".label");
        if (!isLabelDirective) {
            String signature = this.instruction.getSignature();
            if (this.selectedMnemonic != null) {
                sb.append(this.selectedMnemonic);
                int idx = signature.indexOf(".");
                sb.append(idx > 0 ? signature.substring(idx) : "");
            } else {
                sb.append(signature);
            }
            sb.append(' ');
        }
        for (Object c : this.allParams) {
            Text paramField;
            String paramValue = "";
            if (c instanceof ComboViewer) {
                ISptInstructionParamValue sptInstructionParamValue;
                Object obj = ((ComboViewer)c).getStructuredSelection().getFirstElement();
                if (!(obj instanceof ISptInstructionParamValue) || (paramValue = (sptInstructionParamValue = (ISptInstructionParamValue)obj).getResultValue()).isEmpty()) continue;
                sb.append(paramValue).append(' ');
                continue;
            }
            if (!(c instanceof Text) || (paramValue = (paramField = (Text)c).getText().trim()).isEmpty()) continue;
            if (isLabelDirective) {
                sb.append(paramValue.toUpperCase()).append(':').append(' ');
                continue;
            }
            sb.append(paramValue).append(((ISptInstructionParam)paramField.getData()).isCommaNeeded() ? Character.valueOf(',') : "").append(' ');
        }
        String resultCommand = sb.toString().trim();
        if (resultCommand.endsWith(",")) {
            resultCommand = resultCommand.substring(0, resultCommand.length() - 1);
        }
        return resultCommand;
    }

    private void createWidgets(Composite contents) {
        this.createOptionsGroup(contents);
        this.createParametersGroup(contents);
    }

    private void createParametersGroup(Composite contents) {
        Group paramsHolderGroup = new Group(contents, 0);
        paramsHolderGroup.setLayout((Layout)new GridLayout(1, false));
        GridData paramsHolderGroupData = new GridData(4, 4, true, true);
        paramsHolderGroup.setText(NLS.bind((String)Messages.SptInstructionParamsDialog_params_group_title, null));
        paramsHolderGroup.setLayoutData((Object)paramsHolderGroupData);
        ScrolledComposite scc = new ScrolledComposite((Composite)paramsHolderGroup, 512);
        scc.setLayout((Layout)new GridLayout(1, false));
        scc.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite paramsGroup = new Composite((Composite)scc, 0);
        paramsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 4, true, true);
        paramsGroup.setLayoutData((Object)layoutData);
        for (ISptInstructionParam param : this.instruction.getParams()) {
            Label l = new Label(paramsGroup, 0);
            l.setText(String.valueOf(param.getName().toUpperCase()) + ":");
            if (param instanceof ISptInstructionOption) {
                ISptInstructionOption option = (ISptInstructionOption)param;
                if (option.getValues().isEmpty()) {
                    this.allParams.add(this.createTextField(paramsGroup, (ISptInstructionParam)option));
                    continue;
                }
                this.allParams.add(this.createComboViewer(paramsGroup, option));
                continue;
            }
            this.allParams.add(this.createTextField(paramsGroup, param));
        }
        scc.setContent((Control)paramsGroup);
        scc.setExpandHorizontal(true);
        scc.setExpandVertical(true);
        scc.setMinSize(paramsGroup.computeSize(-1, -1));
    }

    private void createOptionsGroup(Composite contents) {
        if (this.hasOptionsGroup()) {
            Group optionsGroup = new Group(contents, 0);
            optionsGroup.setLayout((Layout)new GridLayout(2, false));
            optionsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            optionsGroup.setText(NLS.bind((String)Messages.SptInstructionParamsDialog_options_group_title, null));
            this.createMnemonicSelector((Composite)optionsGroup);
        }
    }

    private boolean hasOptionsGroup() {
        boolean hasOptionsGroup = true;
        List mnemonics = this.instruction.getMnemonics();
        return hasOptionsGroup &= mnemonics != null && !mnemonics.isEmpty();
    }

    private void createMnemonicSelector(Composite contents) {
        List mnemonics = this.instruction.getMnemonics();
        if (mnemonics != null && !mnemonics.isEmpty()) {
            this.selectedMnemonic = (String)mnemonics.get(0);
            Label l = new Label(contents, 0);
            l.setText(NLS.bind((String)Messages.SptInstructionParamsDialog_mnemonic_label, null));
            Group mnemonicsGroup = new Group(contents, 0);
            mnemonicsGroup.setLayout((Layout)new RowLayout(256));
            mnemonicsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            boolean isSelectedByDefault = false;
            for (String m : mnemonics) {
                final Button button = new Button((Composite)mnemonicsGroup, 16);
                button.setText(m.toUpperCase());
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button source = (Button)e.getSource();
                        if (source.getSelection()) {
                            SptInstructionParamsDialog.this.selectedMnemonic = button.getText().toLowerCase();
                        }
                    }
                });
                if (isSelectedByDefault) continue;
                button.setSelection(true);
                isSelectedByDefault = true;
            }
        }
    }

    private ComboViewer createComboViewer(Composite contents, final ISptInstructionOption option) {
        Combo combo = new Combo(contents, 12);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ComboViewer comboViewer = new ComboViewer(combo);
        comboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return option.getValues().toArray();
            }
        });
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return ((ISptInstructionParamValue)element).getValue();
            }
        });
        comboViewer.setInput((Object)option.getValues());
        comboViewer.refresh();
        comboViewer.setSelection((ISelection)new StructuredSelection(option.getDefaultValue()){});
        return comboViewer;
    }

    private Text createTextField(Composite contents, ISptInstructionParam param) {
        Text paramField = new Text(contents, 2052);
        paramField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        paramField.setData((Object)param);
        paramField.setText(param.getDefaultValue().getValue());
        paramField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SptInstructionParamsDialog.this.validate();
            }
        });
        return paramField;
    }

    private void validate() {
        for (Object param : this.allParams) {
            if (!(param instanceof Text)) continue;
            String value = ((Text)param).getText().trim();
            if (value.isEmpty()) {
                this.onFail(Messages.SptInstructionParamsDialog_value_is_not_set);
                return;
            }
            if (Pattern.matches(VALUE_PATTERN, value)) continue;
            this.onFail(NLS.bind((String)Messages.SptInstructionParamsDialog_value_is_incorrect, (Object)value));
            return;
        }
        this.onOk();
    }

    private void onOk() {
        this.setErrorMessage(null);
        this.okButton.setEnabled(true);
    }

    private void onFail(String msg) {
        this.setErrorMessage(msg);
        this.okButton.setEnabled(false);
    }
}

