/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.ppc;

import com.pemicro.debug.gdbjtag.ppc.ConfigurationAttributes;
import com.pemicro.debug.gdbjtag.ppc.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.core.GDBJtagDSFFinalLaunchSequence;
import org.eclipse.cdt.debug.gdbjtag.core.Messages;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContributionFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;

public class FinalLaunchSequence
extends GDBJtagDSFFinalLaunchSequence {
    private Map<String, Object> fAttributes;
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private IGDBBackend fGDBBackend;
    private IGDBControl fCommandControl;
    private IMIProcesses fProcService;
    private IGDBJtagDevice fGdbJtagDevice;

    public FinalLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        this.fAttributes = attributes;
        this.fSession = session;
    }

    private void queueCommands(List<String> commands, RequestMonitor rm) {
        if (!commands.isEmpty()) {
            this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fCommandControl.getContext(), Utils.composeCommandWithLf(commands)), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepInitializeFinalLaunchSequence(RequestMonitor requestMonitor) {
        this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fSession.getId());
        this.fGDBBackend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        if (this.fGDBBackend == null) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain GDBBackend service", null));
            requestMonitor.done();
            return;
        }
        this.fCommandControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        if (this.fCommandControl == null) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain control service", null));
            requestMonitor.done();
            return;
        }
        this.fCommandControl.getCommandFactory();
        this.fProcService = (IMIProcesses)this.fTracker.getService(IMIProcesses.class);
        if (this.fProcService == null) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain process service", null));
            requestMonitor.done();
            return;
        }
        super.stepInitializeFinalLaunchSequence(requestMonitor);
    }

    @ReflectionSequence.Execute
    public void stepInitializeJTAGFinalLaunchSequence(RequestMonitor rm) {
        this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fSession.getId());
        this.fGDBBackend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        if (this.fGDBBackend == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain GDBBackend service", null));
            return;
        }
        this.fCommandControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        if (this.fCommandControl == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain control service", null));
            return;
        }
        this.fProcService = (IMIProcesses)this.fTracker.getService(IMIProcesses.class);
        if (this.fProcService == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain process service", null));
            return;
        }
        super.stepInitializeJTAGFinalLaunchSequence(rm);
    }

    @ReflectionSequence.Execute
    public void stepConnectToTarget(RequestMonitor rm) {
        ArrayList<String> commands = new ArrayList<String>();
        boolean isRemoteTarget = (Boolean)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", (Object)true);
        if (isRemoteTarget) {
            String ipAddress = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.ipAddress", (Object)"unspecified-ip-address");
            int portNum = (Integer)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.serverPortNumber", (Object)7224);
            int coreNum = (Integer)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.selectedCoreNumber", (Object)1);
            this.fGdbJtagDevice.doRemote(ipAddress, portNum += (coreNum - 1) * 2, commands);
        }
        this.queueCommands(commands, rm);
    }

    @ReflectionSequence.Execute
    public void stepSourceGDBInitFile(RequestMonitor requestMonitor) {
        try {
            ArrayList<String> commandsList = new ArrayList<String>();
            String otherInits = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.gdbClientOtherCommands", (Object)"set mem inaccessible-by-default off\nset tcp auto-retry on\nset tcp connect-timeout 240\nset remotetimeout 60\n");
            otherInits = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(otherInits);
            if (otherInits.length() > 0) {
                String[] commandsStr;
                String[] stringArray = commandsStr = otherInits.split("\\r?\\n");
                int n = commandsStr.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if ((str = str.trim()).length() > 0) {
                        commandsList.add(str);
                    }
                    ++n2;
                }
            }
            if (commandsList.size() > 0) {
                CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), requestMonitor);
                crm.setDoneCount(commandsList.size());
                this.queueCommands(commandsList, requestMonitor);
            } else {
                requestMonitor.done();
            }
        }
        catch (CoreException e) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot run other gdb client commands", (Throwable)e));
            requestMonitor.done();
        }
        super.stepSourceGDBInitFile(requestMonitor);
    }

    private static boolean isHexNumber(String numberToCheck) {
        try {
            Long.parseLong(numberToCheck, 16);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @ReflectionSequence.Execute
    public void stepSetProgramCounter(RequestMonitor rm) {
        String cmd = "";
        if (((Boolean)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", (Object)false)).booleanValue()) {
            String pc = (String)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.pcRegister", (Object)((String)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"")));
            ArrayList<String> commands = new ArrayList<String>();
            cmd = FinalLaunchSequence.isHexNumber(pc) ? "set $pc=0x" + pc : "set $pc=" + pc;
            commands.add("flushreg");
            commands.add(cmd);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepResetBoard(RequestMonitor rm) {
        ArrayList<String> commandsList = new ArrayList<String>();
        boolean noReset = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.attachToRunning", (Object)false);
        if (!noReset) {
            commandsList.add("flushreg");
        }
        CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        crm.setDoneCount(commandsList.size());
        this.queueCommands(commandsList, rm);
    }

    @ReflectionSequence.Execute
    public void stepResumeScript(RequestMonitor rm) {
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepUserInitCommands(RequestMonitor rm) {
        ArrayList<String> commandsList = new ArrayList<String>();
        String commandStr = "";
        int params = 0;
        if (((Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.enableSemihosting", (Object)true)).booleanValue()) {
            if (((Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.enableSemihostingIoclientTelnet", (Object)true)).booleanValue()) {
                params |= 1;
            }
            if (((Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.enableSemihostingIoclientGdbClient", (Object)false)).booleanValue()) {
                params |= 2;
            }
            int port = (Integer)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.gdbServerTelnetPortNumber", (Object)51794);
            commandStr = "monitor semihosting " + String.valueOf(params) + ',' + String.valueOf(port);
            commandsList.add(commandStr);
        }
        int i = 0;
        while (i < 3) {
            boolean tempBool = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)("com.pemicro.debug.gdbjtag.ppc.preserveMemory" + i), (Object)false);
            commandStr = "monitor preserve" + i + (tempBool ? " 1 " : " 0");
            if (tempBool) {
                long tempLong = Long.parseLong((String)CDebugUtils.getAttribute(this.fAttributes, (String)("com.pemicro.debug.gdbjtag.ppc.preserveMemoryFrom" + i), (Object)"0"), 16);
                commandStr = String.valueOf(commandStr) + tempLong + " ";
                tempLong = Long.parseLong((String)CDebugUtils.getAttribute(this.fAttributes, (String)("com.pemicro.debug.gdbjtag.ppc.preserveMemoryTo" + i), (Object)"3"), 16);
                commandStr = String.valueOf(commandStr) + tempLong;
            }
            commandsList.add(commandStr);
            ++i;
        }
        if (commandsList.size() > 0) {
            CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
            crm.setDoneCount(commandsList.size());
            this.queueCommands(commandsList, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepUserDebugCommands(RequestMonitor rm) {
        ArrayList<String> commandsList = new ArrayList<String>();
        boolean attach_to_target = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.attachToRunning", (Object)false);
        if (attach_to_target) {
            boolean force_target_running = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.doContinue", (Object)true);
            if (force_target_running) {
                commandsList.add("continue");
            } else {
                commandsList.add("monitor refreshviews");
                commandsList.add("continue");
            }
        } else {
            commandsList.add("flushreg");
            if (((Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.doContinue", (Object)true)).booleanValue()) {
                commandsList.add("continue");
            }
        }
        String userCmd = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.otherRunCommands", (Object)"");
        try {
            Utils.addMultiLine(userCmd, commandsList);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        crm.setDoneCount(commandsList.size());
        this.queueCommands(commandsList, rm);
    }

    protected Map<String, Object> getAttributes() {
        return this.fAttributes;
    }

    private IGDBJtagDevice getGDBJtagDevice() {
        GDBJtagDeviceContribution[] availableDevices;
        IGDBJtagDevice gdbJtagDevice = null;
        String jtagDeviceName = (String)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", (Object)"");
        GDBJtagDeviceContribution[] gDBJtagDeviceContributionArray = availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        int n = availableDevices.length;
        int n2 = 0;
        while (n2 < n) {
            GDBJtagDeviceContribution availableDevice = gDBJtagDeviceContributionArray[n2];
            if (jtagDeviceName.equals(availableDevice.getDeviceName())) {
                gdbJtagDevice = availableDevice.getDevice();
                break;
            }
            ++n2;
        }
        return gdbJtagDevice;
    }

    @ReflectionSequence.Execute
    public void stepRetrieveJTAGDevice(RequestMonitor rm) {
        NullPointerException exception = null;
        try {
            this.fGdbJtagDevice = this.getGDBJtagDevice();
        }
        catch (NullPointerException e) {
            exception = e;
        }
        if (this.fGdbJtagDevice == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get Jtag device", (Throwable)exception));
            rm.done();
        } else {
            super.stepRetrieveJTAGDevice(rm);
        }
    }

    @ReflectionSequence.Execute
    public void stepLoadSymbols(RequestMonitor rm) {
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepLoadImage(RequestMonitor rm) {
        try {
            if (((Boolean)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", (Object)true)).booleanValue()) {
                String symbolsFileName = null;
                if (this.getAttributes().containsKey("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols") && ((Boolean)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", (Object)true)).booleanValue()) {
                    IPath programFile = this.fGDBBackend.getProgramPath();
                    if (programFile != null) {
                        symbolsFileName = programFile.toOSString();
                    }
                } else {
                    symbolsFileName = (String)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", (Object)"");
                    symbolsFileName = symbolsFileName.length() > 0 ? VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(symbolsFileName) : null;
                }
                if (symbolsFileName == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, Messages.getString((String)"GDBJtagDebugger.err_no_img_file"), null));
                    rm.done();
                    return;
                }
                symbolsFileName = symbolsFileName.replace("\\", "\\\\");
                String symbolsOffset = (String)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", (Object)"");
                if (symbolsOffset.length() > 0) {
                    symbolsOffset = "0x" + symbolsOffset;
                }
                ArrayList<String> commands = new ArrayList<String>();
                this.fGdbJtagDevice.doLoadSymbol(symbolsFileName, symbolsOffset, commands);
                this.queueCommands(commands, rm);
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot load symbol", (Throwable)e));
            rm.done();
        }
        try {
            String imageFileName = null;
            boolean noReset = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.attachToRunning", (Object)false);
            if (!noReset) {
                if (((Boolean)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue()) {
                    if (this.getAttributes().containsKey("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage") && ((Boolean)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", (Object)true)).booleanValue()) {
                        IPath programFile = this.fGDBBackend.getProgramPath();
                        if (programFile != null) {
                            imageFileName = programFile.toOSString();
                        }
                    } else {
                        imageFileName = (String)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageFileName", (Object)"");
                        imageFileName = imageFileName.length() > 0 ? VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(imageFileName) : null;
                    }
                    if (imageFileName == null) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, Messages.getString((String)"GDBJtagDebugger.err_no_img_file"), null));
                        rm.done();
                        return;
                    }
                    imageFileName = imageFileName.replace("\\", "\\\\");
                    String imageOffset = (String)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"");
                    if (imageOffset.length() > 0) {
                        imageOffset = "0x" + (String)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"");
                    }
                    List<String> commands = new ArrayList<String>();
                    List<String> addElvesList = this.getAdditionalImageList();
                    List<String> addElvesOffsetList = this.getAdditionalImageOffsetList();
                    int numberAdditionalElves = (Integer)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.NUMBER_ELVES", (Object)0);
                    commands.add("monitor startmultiload");
                    if (!addElvesList.isEmpty() && numberAdditionalElves != 0) {
                        commands = this.loadAdditionalElves(numberAdditionalElves, addElvesList, addElvesOffsetList, rm, commands);
                    }
                    this.fGdbJtagDevice.doLoadImage(imageFileName, imageOffset, commands);
                    commands.add("monitor endmultiload");
                    String selectCoreCommand = this.selectCore();
                    commands.add(selectCoreCommand);
                    this.queueCommands(commands, rm);
                } else {
                    rm.done();
                }
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot load image", (Throwable)e));
            rm.done();
        }
    }

    private List<String> loadAdditionalElves(int numberAdditionalElves, List<String> addElvesList, List<String> addElvesOffsetList, RequestMonitor rm, List<String> commands) {
        String imageOffset = "";
        String addElf = "";
        int i = 0;
        while (i < numberAdditionalElves) {
            imageOffset = "";
            try {
                boolean noElf = false;
                if (addElvesOffsetList.size() == numberAdditionalElves && !(imageOffset = addElvesOffsetList.get(i)).isEmpty()) {
                    imageOffset = "0x" + imageOffset;
                }
                addElf = addElvesList.get(i);
                addElf = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(addElf, false);
                File tempFile = new File(addElf);
                if (!tempFile.exists() || tempFile.isDirectory()) {
                    noElf = true;
                }
                if (noElf) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "The following additional elf file does not exist: " + addElf, null));
                    rm.done();
                    return commands;
                }
            }
            catch (CoreException coreException) {}
            this.fGdbJtagDevice.doLoadImage(addElf.replace("\\", "\\\\"), imageOffset, commands);
            ++i;
        }
        return commands;
    }

    private String selectCore() {
        int tempLong = 0;
        tempLong = (Integer)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.selectedCoreNumber", (Object)1);
        boolean tempBool = tempLong != 1;
        String commandStr = "monitor selectcore" + (tempBool ? " 1" : " 0");
        if (tempBool) {
            commandStr = String.valueOf(commandStr) + " " + tempLong;
        }
        return commandStr;
    }

    private List<String> getAdditionalImageList() {
        List addElvesList = (List)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.ELVES", ConfigurationAttributes.ADDITIONAL_ELVES_DEFAULT);
        if (!addElvesList.isEmpty()) {
            for (String addElf : addElvesList) {
                int elfIndex = addElvesList.indexOf(addElf);
                addElvesList.set(elfIndex, addElf);
            }
        }
        return addElvesList;
    }

    private List<String> getAdditionalImageOffsetList() {
        List addElvesOffsetList = (List)CDebugUtils.getAttribute(this.fAttributes, (String)"com.pemicro.debug.gdbjtag.ppc.ELVES_OFFSET", ConfigurationAttributes.ADDITIONAL_ELVES_OFFSET_DEFAULT);
        if (!addElvesOffsetList.isEmpty()) {
            for (String addElfOffset : addElvesOffsetList) {
                int elfIndex = addElvesOffsetList.indexOf(addElfOffset);
                addElvesOffsetList.set(elfIndex, addElfOffset);
            }
        }
        return addElvesOffsetList;
    }

    @ReflectionSequence.Execute
    public void stepStopScript(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.setStopAt", (Object)false)).booleanValue()) {
            String stopAt = (String)CDebugUtils.getAttribute(this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.stopAt", (Object)"");
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doStopAt(stopAt, commands);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }
}

