/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip;

import com.pemicro.forms.chip.Signal;
import com.pemicro.forms.chip.SignalWindow;
import com.pemicro.forms.chip.actions.ShowSignalsAction;
import com.pemicro.forms.chip.edit.DataTypeEditingSupport;
import com.pemicro.forms.chip.edit.DirectionEditingSupport;
import com.pemicro.forms.chip.edit.SignalNameEditingSupport;
import com.pemicro.forms.chip.edit.ValueEditingSupport;
import com.pemicro.forms.chip.filter.SignalFilter;
import com.pemicro.forms.chip.sorter.SignalViewerComparator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class SignalView
extends ViewPart {
    public static final String ID = "com.pemicro.core.signalView";
    public static boolean JustOpened = false;
    private TableViewer viewer;
    private SignalViewerComparator comparator;
    private SignalFilter filter;
    private static boolean signalViewVisible = false;

    public void createPartControl(Composite parent) {
        ShowSignalsAction w = new ShowSignalsAction(this.getSite().getWorkbenchWindow());
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)w);
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        Label searchLabel = new Label(parent, 0);
        searchLabel.setText("Search: ");
        final Text searchText = new Text(parent, 2176);
        searchText.setLayoutData((Object)new GridData(768));
        searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                SignalView.this.filter.setSearchText(searchText.getText());
                SignalView.this.viewer.refresh();
            }
        });
        this.createViewer(parent);
        this.comparator = new SignalViewerComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.filter = new SignalFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        SignalView.setSignalViewVisible(true);
        JustOpened = true;
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 66306);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(SignalWindow.getInstance().getDisplayedSignalMap().values());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"Pin Number", "Pin Name", "Signal Name", "Direction", "Value", "Pin Type", "Data Type"};
        int[] bounds = new int[]{100, 100, 100, 100, 100, 100, 100};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Signal s = (Signal)element;
                return s.getPinNumber().toString();
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Signal s = (Signal)element;
                return s.getPinName();
            }
        });
        col = this.createTableViewerColumn(titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Signal s = (Signal)element;
                return s.getSignalName();
            }
        });
        col.setEditingSupport((EditingSupport)new SignalNameEditingSupport(viewer));
        col = this.createTableViewerColumn(titles[3], bounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Signal s = (Signal)element;
                if (s.getDirection() == 0) {
                    return "Input";
                }
                return "Output";
            }
        });
        col.setEditingSupport((EditingSupport)new DirectionEditingSupport(viewer));
        col = this.createTableViewerColumn(titles[4], bounds[4], 4);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Signal s = (Signal)element;
                if (s.getDataType() == 0) {
                    return Integer.toString(s.getValue());
                }
                return String.format("%.2f V", Float.valueOf((float)s.getValue() / 100.0f));
            }
        });
        col.setEditingSupport((EditingSupport)new ValueEditingSupport(viewer));
        col = this.createTableViewerColumn(titles[5], bounds[5], 5);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Signal s = (Signal)element;
                switch (s.getPinType()) {
                    case 0: {
                        return "I/O";
                    }
                    case 4096: {
                        return "Input Only";
                    }
                    case 8192: {
                        return "Output Only";
                    }
                    case 40960: {
                        return "Gnd Input";
                    }
                    case 36864: {
                        return "Vdd Input";
                    }
                    case 20480: {
                        return "Clk Input";
                    }
                    case 24576: {
                        return "Clk Output";
                    }
                    case 16384: {
                        return "Gnd";
                    }
                    case 12288: {
                        return "Power";
                    }
                    case 28672: {
                        return "Ref High";
                    }
                    case 32768: {
                        return "Ref Low";
                    }
                }
                return "N/A";
            }
        });
        col = this.createTableViewerColumn(titles[6], bounds[6], 6);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Signal s = (Signal)element;
                if (s.getDataType() == 0) {
                    return "Digital";
                }
                return "Analog";
            }
        });
        col.setEditingSupport((EditingSupport)new DataTypeEditingSupport(viewer));
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, colNumber));
        return viewerColumn;
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SignalView.this.comparator.setColumn(index);
                int dir = SignalView.this.viewer.getTable().getSortDirection();
                dir = SignalView.this.viewer.getTable().getSortColumn() == column ? (dir == 128 ? 1024 : 128) : 1024;
                SignalView.this.viewer.getTable().setSortDirection(dir);
                SignalView.this.viewer.getTable().setSortColumn(column);
                SignalView.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public static boolean isSignalViewVisible() {
        return signalViewVisible;
    }

    private static void setSignalViewVisible(boolean signalViewVisible) {
        SignalView.signalViewVisible = signalViewVisible;
    }

    public void dispose() {
        SignalView.setSignalViewVisible(false);
        super.dispose();
    }

    public class SignalList {
    }
}

