/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.model;

import com.nxp.s32ds.cle.spt.model.ISptInstruction;
import com.nxp.s32ds.cle.spt.model.ISptInstructionGroup;
import com.nxp.s32ds.cle.spt.model.ISptInstructionParam;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SptInstruction
implements ISptInstruction {
    private String name;
    private String alias;
    protected List<ISptInstructionParam> params;
    private ISptInstructionGroup instructionGroup;
    protected boolean isDirective;
    protected List<String> mnemonics;

    public SptInstruction(String name) {
        this.name = name;
        this.params = new ArrayList<ISptInstructionParam>();
        this.isDirective = false;
    }

    public SptInstruction(String name, String[] mnemonics) {
        this(name);
        if (mnemonics != null) {
            this.mnemonics = Stream.of(mnemonics).map(String::trim).filter(m -> !m.isEmpty()).collect(Collectors.toList());
        }
    }

    public SptInstruction(String name, String alias, String[] mnemonics, ISptInstructionGroup instructionGroup) {
        this(name, mnemonics);
        this.alias = alias;
        this.instructionGroup = instructionGroup;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ISptInstructionParam> getParams() {
        ArrayList<ISptInstructionParam> result = new ArrayList<ISptInstructionParam>();
        if (this.instructionGroup != null) {
            result.addAll(this.instructionGroup.getParams());
        }
        result.addAll(this.params);
        return result;
    }

    @Override
    public void addParam(ISptInstructionParam param) {
        this.params.add(param);
    }

    @Override
    public String getSignature() {
        return this.alias != null && !this.alias.isEmpty() ? this.alias : this.name;
    }

    @Override
    public int compareTo(ISptInstruction sptInstruction) {
        return this.name.compareTo(sptInstruction.getName());
    }

    @Override
    public ISptInstructionGroup getGroup() {
        return this.instructionGroup;
    }

    @Override
    public boolean isDirective() {
        return this.isDirective;
    }

    @Override
    public String getDocumentation(int length) {
        return this.createDocumentation(length);
    }

    @Override
    public List<String> getMnemonics() {
        if ((this.mnemonics == null || this.mnemonics.isEmpty()) && this.instructionGroup != null) {
            return this.instructionGroup.getMnemonics();
        }
        return this.mnemonics;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.isDirective ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SptInstruction)) {
            return false;
        }
        SptInstruction other = (SptInstruction)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.isDirective != other.isDirective) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    private String createDocumentation(int length) {
        StringBuilder sb = new StringBuilder();
        sb.append('#');
        int i = 0;
        while (i < length) {
            sb.append('=');
            ++i;
        }
        sb.append('\n');
        sb.append('#').append('\n');
        sb.append('#').append(' ').append(this.name).append(" instruction").append('\n');
        sb.append('#').append('\n');
        sb.append('#');
        i = 0;
        while (i < length) {
            sb.append('=');
            ++i;
        }
        sb.append('\n');
        return sb.toString();
    }
}

